/*
 * ++Copyright++ 1985, 1989, 1993
 * -
 * Copyright (c) 1985, 1989, 1993
 *    The Regents of the University of California.  All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * 	This product includes software developed by the University of
 * 	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * -
 * Portions Copyright (c) 1993 by Digital Equipment Corporation.
 * 
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Digital Equipment Corporation not be used in advertising or
 * publicity pertaining to distribution of the document or software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * -
 * --Copyright--
 */

#define WITH_SENDMAIL	1
#if !WITH_SENDMAIL
#define RESOLV_HACK	1
#define DO_CACHE	1
#endif

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)res_send.c	8.1 (Berkeley) 6/4/93";
static char rcsid[] = "$Id: res_send.c,v 8.9 1996/08/05 08:31:35 vixie Exp $";
static char Wsccsid[] = "@(#)res_send.c	2.16 (motonori/WIDE) 27 Oct 1996";
#endif /* LIBC_SCCS and not lint */

	/* change this to "0"
	 * if you talk to a lot
	 * of multi-homed SunOS
	 * ("broken") name servers.
	 */
#define	CHECK_SRVR_ADDR	1	/* XXX - should be in options.h */

/*
 * Send query to name server and wait for reply.
 */

#if WITH_SENDMAIL
#include "sendmail.h"
#else
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>
#endif
#include <sys/uio.h>
#if !WITH_SENDMAIL
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <netdb.h>
#include <errno.h>
#endif
#include <resolv.h>
#if !WITH_SENDMAIL
#if defined(BSD) && (BSD >= 199306)
# include <stdlib.h>
# include <string.h>
# include <unistd.h>
#else
# include "../conf/portability.h"
#endif

#if defined(USE_OPTIONS_H)
# include <../conf/options.h>
#endif
#endif

void _res_close __P((void));

#if RESOLV_HACK

#ifdef __RES				/* 4.9 */

#if (__RES > 19940221) 			/* 4.9.3ALPHA5 */
#define RES_UNC_T	u_char *
#if (__RES >= 19941130) 		/* 4.9.3BETA17 */
#define HAS_PFCODE	1
#endif
#else
#define RES_UNC_T	char *
#endif

#else					/* 4.8 or earlier */

#define RES_UNC_T	char *
#ifndef __STDC__
#define	const
#endif
#ifdef ultrix
#define	NSADDR_LIST(x)	ns_list[x].addr	/* ultrix implementation is strange */
#endif

#endif /* __RES */

#ifndef HAS_PFCODE
#define HAS_PFCODE	0
#endif
#ifndef NSADDR_LIST
#define	NSADDR_LIST(x)	nsaddr_list[x]	/* for standerd BIND */
#endif


#ifndef INT16SZ
#define INT16SZ	2		/* for systems without 16-bit ints */
#endif
#ifndef HFIXEDSZ
#define HFIXEDSZ	12		/* #/bytes of fixed data in header */
#endif
#ifndef RES_INSECURE1
#define RES_INSECURE1	0x00000400	/* type 1 security disabled */
#endif
#ifndef RES_INSECURE2
#define RES_INSECURE2	0x00000800	/* type 2 security disabled */
#endif
#ifndef RES_NONBLOCK
#define RES_NONBLOCK	0x01000000	/* return immediately, do cacheing */
#endif

static int s = -1;	/* socket used for communications */
static int connected = 0;	/* is the socket connected */
static int vc = 0;	/* is the socket a virtual ciruit? */

#ifndef FD_SET
/* XXX - should be in portability.h */
#define	NFDBITS		32
#define	FD_SETSIZE	32
#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))
#endif

/* XXX - this should be done in portability.h */
#if WITH_SENDMAIL || (defined(BSD) && (BSD >= 199103)) || defined(linux)
# define CAN_RECONNECT 1
#else
# define CAN_RECONNECT 0
#endif

#ifndef DEBUG
#   define Dprint(cond, args) /*empty*/
#   define DprintQ(cond, args, query, size) /*empty*/
#   define Aerror(file, string, error, address) /*empty*/
#   define Perror(file, string, error) /*empty*/
#else
#   define Dprint(cond, args) if (cond) {fprintf args;} else {}
#   define DprintQ(cond, args, query, size) if (cond) {\
			fprintf args;\
			__fp_nquery(query, size, stdout);\
		} else {}
    static void
    Aerror(file, string, error, address)
	FILE *file;
	char *string;
	int error;
	struct sockaddr_in address;
    {
	int save = errno;

	if (_res.options & RES_DEBUG) {
		fprintf(file, "res_send: %s ([%s].%u): %s\n",
			string,
			inet_ntoa(address.sin_addr),
			ntohs(address.sin_port),
			strerror(error));
	}
	errno = save;
    }
    static void
    Perror(file, string, error)
	FILE *file;
	char *string;
	int error;
    {
	int save = errno;

	if (_res.options & RES_DEBUG) {
		fprintf(file, "res_send: %s: %s\n",
			string, strerror(error));
	}
	errno = save;
    }
#endif

#if !WITH_SENDMAIL
static res_send_qhook Qhook = NULL;
static res_send_rhook Rhook = NULL;

void
res_send_setqhook(hook)
	res_send_qhook hook;
{

	Qhook = hook;
}

void
res_send_setrhook(hook)
	res_send_rhook hook;
{

	Rhook = hook;
}
#endif

/* int
 * res_isourserver(ina)
 *	looks up "ina" in _res.ns_addr_list[]
 * returns:
 *	0  : not found
 *	>0 : found
 * author:
 *	paul vixie, 29may94
 */
int
res_isourserver(inp)
	const struct sockaddr_in *inp;
{
	struct sockaddr_in ina;
	register int ns, ret;

	ina = *inp;
	ret = 0;
	for (ns = 0;  ns < _res.nscount;  ns++) {
		register const struct sockaddr_in *srv = &_res.NSADDR_LIST(ns);

		if (srv->sin_family == ina.sin_family &&
		    srv->sin_port == ina.sin_port &&
		    (srv->sin_addr.s_addr == INADDR_ANY ||
		     srv->sin_addr.s_addr == ina.sin_addr.s_addr)) {
			ret++;
			break;
		}
	}
	return (ret);
}

/* int
 * res_nameinquery(name, type, class, buf, eom)
 *	look for (name,type,class) in the query section of packet (buf,eom)
 * returns:
 *	-1 : format error
 *	0  : not found
 *	>0 : found
 * author:
 *	paul vixie, 29may94
 */
int
res_nameinquery(name, type, class, buf, eom)
	const char *name;
	register int type, class;
	const u_char *buf, *eom;
{
	register const u_char *cp = buf + HFIXEDSZ;
	int qdcount = ntohs(((HEADER*)buf)->qdcount);

	while (qdcount-- > 0) {
		char tname[MAXDNAME+1];
		register int n, ttype, tclass;

		n = dn_expand(buf, eom, cp, tname, sizeof tname);
		if (n < 0)
			return (-1);
		cp += n;
		ttype = _getshort(cp); cp += INT16SZ;
		tclass = _getshort(cp); cp += INT16SZ;
		if (ttype == type &&
		    tclass == class &&
		    strcasecmp(tname, name) == 0)
			return (1);
	}
	return (0);
}

/* int
 * res_queriesmatch(buf1, eom1, buf2, eom2)
 *	is there a 1:1 mapping of (name,type,class)
 *	in (buf1,eom1) and (buf2,eom2)?
 * returns:
 *	-1 : format error
 *	0  : not a 1:1 mapping
 *	>0 : is a 1:1 mapping
 * author:
 *	paul vixie, 29may94
 */
int
res_queriesmatch(buf1, eom1, buf2, eom2)
	const u_char *buf1, *eom1;
	const u_char *buf2, *eom2;
{
	register const u_char *cp = buf1 + HFIXEDSZ;
	int qdcount = ntohs(((HEADER*)buf1)->qdcount);

	if (qdcount != ntohs(((HEADER*)buf2)->qdcount))
		return (0);
	while (qdcount-- > 0) {
		char tname[MAXDNAME+1];
		register int n, ttype, tclass;

		n = dn_expand(buf1, eom1, cp, tname, sizeof tname);
		if (n < 0)
			return (-1);
		cp += n;
		ttype = _getshort(cp);	cp += INT16SZ;
		tclass = _getshort(cp); cp += INT16SZ;
		if (!res_nameinquery(tname, ttype, tclass, buf2, eom2))
			return (0);
	}
	return (1);
}

#if RESOLV_HACK
struct cache {
	u_char	*request;
	u_char	*answer;
	int	reqlen;
	int	anslen;
	u_char	try;
	u_char	ns;
	u_char	badns;
	u_char	nocache;
	time_t	time;
	struct cache *next;
};

static struct cache *Caches = NULL;
#endif

/* XXX cache management in normal use */
int
res_send(buf, buflen, ans, anssiz)
	const RES_UNC_T buf;
	int buflen;
	RES_UNC_T ans;
	int anssiz;
{
	HEADER *hp = (HEADER *) buf;
	HEADER *anhp = (HEADER *) ans;
	int gotsomewhere, connreset, terrno, try, v_circuit, resplen, ns;
	register int n;
	u_int badns;	/* XXX NSMAX can't exceed #/bits in this var */
#if RESOLV_HACK
	struct cache *creq, *pcreq;
	void show_query();

#ifdef LOG
	if (tTd(76, 80))
		syslog(LOG_INFO, "res_send: entered");
#endif
#endif
	if ((_res.options & RES_INIT) == 0 && res_init() == -1) {
		/* errno should have been set by res_init() in this case. */
		return (-1);
	}
	DprintQ((_res.options & RES_DEBUG) || (_res.pfcode & RES_PRF_QUERY),
		(stdout, ";; res_send()\n"), buf, buflen);
	v_circuit = (_res.options & RES_USEVC) || buflen > PACKETSZ;
	gotsomewhere = 0;
	connreset = 0;
	terrno = ETIMEDOUT;
#if RESOLV_HACK
	if (_res.options & RES_NONBLOCK)
	{
#ifdef LOG
		if (tTd(76, 65))
			syslog(LOG_DEBUG, "res_send: switched to res_cache");
#endif
		/* goto caching query routine */
		return res_cache(buf, buflen, ans, anssiz);
	}
#if DO_CACHE
	res_cache(buf, buflen, ans, anssiz);
	res_sync();
#endif
	pcreq = NULL;
	/* scan the query in cache */
	for (creq = Caches; creq != NULL; pcreq = creq, creq = creq->next)
	{
		if (creq->request != NULL
		 && res_queriesmatch(buf, buf + buflen, creq->request,
				     creq->request+creq->reqlen) > 0)
			break; /* already registed */
	}
	if (creq != NULL && creq->nocache == 0)
	{	/* found in cache */
		if (creq->answer != NULL && creq->anslen <= anssiz)
		{
#ifdef LOG
			if (tTd(76, 65))
				syslog(LOG_DEBUG, "res_send: found answer in cache");
#endif
			if (creq->time < time(NULL))
			{
				/* TTL expiration */
				if (pcreq == NULL)
					Caches = creq->next;
				else
					pcreq->next = creq->next;
				free(creq->request);
				free(creq->answer);
				free(creq);
			}
			else
			{
				bcopy(creq->answer, ans, creq->anslen);
#if !WITH_SENDMAIL
				/* one time expiration */
				if (pcreq == NULL)
					Caches = creq->next;
				else
					pcreq->next = creq->next;
				free(creq->request);
				free(creq->answer);
				free(creq);
#endif
				return(creq->anslen);
			}
		}
		else if (creq->try >= (u_char)_res.retry)
		{
#ifdef LOG
			if (tTd(76, 65))
				syslog(LOG_DEBUG, "res_send: cache timeout");
#endif
			return(-1);     /* timed out */
		}
	}
	else
	{
#ifdef LOG
		if (tTd(76, 60))
			show_query("res_send: original process",
				buf, buf+buflen);
#endif
	}
#endif /* RESOLV_HACK */
#if DO_CACHE
#ifdef LOG
	if (tTd(76, 60))
		syslog(LOG_DEBUG, "res_send: FAILED");
#endif
	return(-1);     /* timed out */
#else /* DO_CACHE */
	v_circuit = (_res.options & RES_USEVC) || buflen > PACKETSZ;
	badns = 0;

	/*
	 * Send request, RETRY times, or until successful
	 */
	for (try = 0; try < _res.retry; try++) {
	    for (ns = 0; ns < _res.nscount; ns++) {
		struct sockaddr_in *nsap = &_res.nsaddr_list[ns];
    same_ns:
		if (badns & (1 << ns)) {
			_res_close();
			goto next_ns;
		}

#if !WITH_SENDMAIL
		if (Qhook) {
			int done = 0, loops = 0;

			do {
				res_sendhookact act;

				act = (*Qhook)(&nsap, &buf, &buflen,
					       ans, anssiz, &resplen);
				switch (act) {
				case res_goahead:
					done = 1;
					break;
				case res_nextns:
					_res_close();
					goto next_ns;
				case res_done:
					return (resplen);
				case res_modified:
					/* give the hook another try */
					if (++loops < 42) /*doug adams*/
						break;
					/*FALLTHROUGH*/
				case res_error:
					/*FALLTHROUGH*/
				default:
					return (-1);
				}
			} while (!done);
		}
#endif

		Dprint(_res.options & RES_DEBUG,
		       (stdout, ";; Querying server (# %d) address = %s\n",
			ns + 1, inet_ntoa(nsap->sin_addr)));

		if (v_circuit) {
			int truncated;
			struct iovec iov[2];
			u_short len;
			RES_UNC_T cp;

			/*
			 * Use virtual circuit;
			 * at most one attempt per server.
			 */
			try = _res.retry;
			truncated = 0;
			if ((s < 0) || (!vc)) {
				if (s >= 0)
					_res_close();

				s = socket(PF_INET, SOCK_STREAM, 0);
				if (s < 0) {
					terrno = errno;
					Perror(stderr, "socket(vc)", errno);
					return (-1);
				}
				errno = 0;
				if (connect(s, (struct sockaddr *)nsap,
					    sizeof(struct sockaddr)) < 0) {
					terrno = errno;
					Aerror(stderr, "connect/vc",
					       errno, *nsap);
					badns |= (1 << ns);
					_res_close();
					goto next_ns;
				}
				vc = 1;
			}
			/*
			 * Send length & message
			 */
			putshort((u_short)buflen, (u_char*)&len);
			iov[0].iov_base = (caddr_t)&len;
			iov[0].iov_len = INT16SZ;
			iov[1].iov_base = (caddr_t)buf;
			iov[1].iov_len = buflen;
			if (writev(s, iov, 2) != (INT16SZ + buflen)) {
				terrno = errno;
				Perror(stderr, "write failed", errno);
				badns |= (1 << ns);
				_res_close();
				goto next_ns;
			}
			/*
			 * Receive length & response
			 */
read_len:
			cp = ans;
			len = INT16SZ;
			while ((n = read(s, (char *)cp, (int)len)) > 0) {
				cp += n;
				if ((len -= n) <= 0)
					break;
			}
			if (n <= 0) {
				terrno = errno;
				Perror(stderr, "read failed", errno);
				_res_close();
				/*
				 * A long running process might get its TCP
				 * connection reset if the remote server was
				 * restarted.  Requery the server instead of
				 * trying a new one.  When there is only one
				 * server, this means that a query might work
				 * instead of failing.  We only allow one reset
				 * per query to prevent looping.
				 */
				if (terrno == ECONNRESET && !connreset) {
					connreset = 1;
					_res_close();
					goto same_ns;
				}
				_res_close();
				goto next_ns;
			}
			resplen = _getshort(ans);
			if (resplen > anssiz) {
				Dprint(_res.options & RES_DEBUG,
				       (stdout, ";; response truncated\n")
				       );
				truncated = 1;
				len = anssiz;
			} else
				len = resplen;
			cp = ans;
			while (len != 0 &&
			       (n = read(s, (char *)cp, (int)len)) > 0) {
				cp += n;
				len -= n;
			}
			if (n <= 0) {
				terrno = errno;
				Perror(stderr, "read(vc)", errno);
				_res_close();
				goto next_ns;
			}
			if (truncated) {
				/*
				 * Flush rest of answer
				 * so connection stays in synch.
				 */
				anhp->tc = 1;
				len = resplen - anssiz;
				while (len != 0) {
					char junk[PACKETSZ];

					n = (len > sizeof(junk)
					     ? sizeof(junk)
					     : len);
					if ((n = read(s, junk, n)) > 0)
						len -= n;
					else
						break;
				}
			}
			/*
			 * The calling applicating has bailed out of
			 * a previous call and failed to arrange to have
			 * the circuit closed or the server has got
			 * itself confused. Anyway drop the packet and
			 * wait for the correct one.
			 */
			if (hp->id != anhp->id) {
				DprintQ((_res.options & RES_DEBUG) ||
					(_res.pfcode & RES_PRF_REPLY),
					(stdout, ";; old answer (unexpected):\n"),
					ans, (resplen>anssiz)?anssiz:resplen);
				goto read_len;
			}
		} else {
			/*
			 * Use datagrams.
			 */
			struct timeval timeout;
			fd_set dsmask;
			struct sockaddr_in from;
			int fromlen;

			if ((s < 0) || vc) {
				if (vc)
					_res_close();
				s = socket(PF_INET, SOCK_DGRAM, 0);
				if (s < 0) {
#if !CAN_RECONNECT
 bad_dg_sock:
#endif
					terrno = errno;
					Perror(stderr, "socket(dg)", errno);
					return (-1);
				}
				connected = 0;
			}
			/*
			 * On a 4.3BSD+ machine (client and server,
			 * actually), sending to a nameserver datagram
			 * port with no nameserver will cause an
			 * ICMP port unreachable message to be returned.
			 * If our datagram socket is "connected" to the
			 * server, we get an ECONNREFUSED error on the next
			 * socket operation, and select returns if the
			 * error message is received.  We can thus detect
			 * the absence of a nameserver without timing out.
			 * If we have sent queries to at least two servers,
			 * however, we don't want to remain connected,
			 * as we wish to receive answers from the first
			 * server to respond.
			 */
			if (_res.nscount == 1 || (try == 0 && ns == 0)) {
				/*
				 * Connect only if we are sure we won't
				 * receive a response from another server.
				 */
				if (!connected) {
					if (connect(s, (struct sockaddr *)nsap,
						    sizeof(struct sockaddr)
						    ) < 0) {
						Aerror(stderr,
						       "connect(dg)",
						       errno, *nsap);
						badns |= (1 << ns);
						_res_close();
						goto next_ns;
					}
					connected = 1;
				}
				if (send(s, (char*)buf, buflen, 0) != buflen) {
					Perror(stderr, "send", errno);
					badns |= (1 << ns);
					_res_close();
					goto next_ns;
				}
			} else {
				/*
				 * Disconnect if we want to listen
				 * for responses from more than one server.
				 */
				if (connected) {
#if CAN_RECONNECT
					struct sockaddr_in no_addr;

					no_addr.sin_family = AF_INET;
					no_addr.sin_addr.s_addr = INADDR_ANY;
					no_addr.sin_port = 0;
					(void) connect(s,
						       (struct sockaddr *)
						        &no_addr,
						       sizeof(no_addr));
#else
					int s1 = socket(PF_INET, SOCK_DGRAM,0);
					if (s1 < 0)
						goto bad_dg_sock;
					(void) dup2(s1, s);
					(void) close(s1);
					Dprint(_res.options & RES_DEBUG,
					       (stdout, ";; new DG socket\n"))
#endif
					connected = 0;
					errno = 0;
				}
				if (sendto(s, (char*)buf, buflen, 0,
					   (struct sockaddr *)nsap,
					   sizeof(struct sockaddr))
				    != buflen) {
					Aerror(stderr, "sendto", errno, *nsap);
					badns |= (1 << ns);
					_res_close();
					goto next_ns;
				}
			}

			/*
			 * Wait for reply
			 */
			timeout.tv_sec = (_res.retrans << try);
			if (try > 0)
				timeout.tv_sec /= _res.nscount;
			if ((long) timeout.tv_sec <= 0)
				timeout.tv_sec = 1;
			timeout.tv_usec = 0;
    wait:
			FD_ZERO(&dsmask);
			FD_SET(s, &dsmask);
			n = select(s+1, &dsmask, (fd_set *)NULL,
				   (fd_set *)NULL, &timeout);
			if (n < 0) {
				if (errno == EINTR)
					goto wait;
				Perror(stderr, "select", errno);
				_res_close();
				goto next_ns;
			}
			if (n == 0) {
				/*
				 * timeout
				 */
				Dprint(_res.options & RES_DEBUG,
				       (stdout, ";; timeout\n"));
				gotsomewhere = 1;
				_res_close();
				goto next_ns;
			}
			errno = 0;
			fromlen = sizeof(struct sockaddr_in);
			resplen = recvfrom(s, (char*)ans, anssiz, 0,
					   (struct sockaddr *)&from, &fromlen);
			if (resplen <= 0) {
				Perror(stderr, "recvfrom", errno);
				_res_close();
				goto next_ns;
			}
			gotsomewhere = 1;
			if (hp->id != anhp->id) {
				/*
				 * response from old query, ignore it.
				 * XXX - potential security hazard could
				 *	 be detected here.
				 */
				DprintQ((_res.options & RES_DEBUG) ||
					(_res.pfcode & RES_PRF_REPLY),
					(stdout, ";; old answer:\n"),
					ans, (resplen>anssiz)?anssiz:resplen);
				goto wait;
			}
#if CHECK_SRVR_ADDR
			if (!(_res.options & RES_INSECURE1) &&
			    !res_isourserver(&from)) {
				/*
				 * response from wrong server? ignore it.
				 * XXX - potential security hazard could
				 *	 be detected here.
				 */
				DprintQ((_res.options & RES_DEBUG) ||
					(_res.pfcode & RES_PRF_REPLY),
					(stdout, ";; not our server:\n"),
					ans, (resplen>anssiz)?anssiz:resplen);
				goto wait;
			}
#endif
			if (!(_res.options & RES_INSECURE2) &&
			    !res_queriesmatch(buf, buf + buflen,
					      ans, ans + anssiz)) {
				/*
				 * response contains wrong query? ignore it.
				 * XXX - potential security hazard could
				 *	 be detected here.
				 */
				DprintQ((_res.options & RES_DEBUG) ||
					(_res.pfcode & RES_PRF_REPLY),
					(stdout, ";; wrong query name:\n"),
					ans, (resplen>anssiz)?anssiz:resplen);
				goto wait;
			}
			if (anhp->rcode == SERVFAIL ||
			    anhp->rcode == NOTIMP ||
			    anhp->rcode == REFUSED) {
				DprintQ(_res.options & RES_DEBUG,
					(stdout, "server rejected query:\n"),
					ans, (resplen>anssiz)?anssiz:resplen);
				badns |= (1 << ns);
				_res_close();
				/* don't retry if called from dig */
#if HAS_PFCODE
				if (!_res.pfcode)
#endif
					goto next_ns;
			}
			if (!(_res.options & RES_IGNTC) && anhp->tc) {
				/*
				 * get rest of answer;
				 * use TCP with same server.
				 */
				Dprint(_res.options & RES_DEBUG,
				       (stdout, ";; truncated answer\n"));
				v_circuit = 1;
				_res_close();
				goto same_ns;
			}
		} /*if vc/dg*/
		Dprint((_res.options & RES_DEBUG) ||
		       ((_res.pfcode & RES_PRF_REPLY) &&
			(_res.pfcode & RES_PRF_HEAD1)),
		       (stdout, ";; got answer:\n"));
		DprintQ((_res.options & RES_DEBUG) ||
			(_res.pfcode & RES_PRF_REPLY),
			(stdout, ""),
			ans, (resplen>anssiz)?anssiz:resplen);
		/*
		 * If using virtual circuits, we assume that the first server
		 * is preferred over the rest (i.e. it is on the local
		 * machine) and only keep that one open.
		 * If we have temporarily opened a virtual circuit,
		 * or if we haven't been asked to keep a socket open,
		 * close the socket.
		 */
		if ((v_circuit && (!(_res.options & RES_USEVC) || ns != 0)) ||
		    !(_res.options & RES_STAYOPEN)) {
			_res_close();
		}
#if !WITH_SENDMAIL
		if (Rhook) {
			int done = 0, loops = 0;

			do {
				res_sendhookact act;

				act = (*Rhook)(nsap, buf, buflen,
					       ans, anssiz, &resplen);
				switch (act) {
				case res_goahead:
				case res_done:
					done = 1;
					break;
				case res_nextns:
					_res_close();
					goto next_ns;
				case res_modified:
					/* give the hook another try */
					if (++loops < 42) /*doug adams*/
						break;
					/*FALLTHROUGH*/
				case res_error:
					/*FALLTHROUGH*/
				default:
					return (-1);
				}
			} while (!done);

		}
#endif
		return (resplen);
    next_ns: ;
	   } /*foreach ns*/
	} /*foreach retry*/
	_res_close();
	if (!v_circuit)
		if (!gotsomewhere)
			errno = ECONNREFUSED;	/* no nameservers found */
		else
			errno = ETIMEDOUT;	/* no answer obtained */
	else
		errno = terrno;
	return (-1);
#endif /* DO_CACHE */
}

/*
 * This routine is for closing the socket if a virtual circuit is used and
 * the program wants to close it.  This provides support for endhostent()
 * which expects to close the socket.
 *
 * This routine is not expected to be user visible.
 */
void
_res_close()
{
	if (s >= 0) {
		(void) close(s);
		s = -1;
		connected = 0;
		vc = 0;
	}
}

#if RESOLV_HACK
/*
 * res_cache()
 *	Non bocking query routine
 *
 * This routine is called if RES_NONBLOCK flag is set.
 * After of all queries, do res_sync() with RES_NONBLOCK flag.
 */
int
res_cache(buf, buflen, ans, anssiz)
	u_char		*buf;
	int		buflen;
	u_char		*ans;
	int		anssiz;
{
	static int	s = -1;
	static fd_set	dsmask;
	time_t		now, latest;
	struct sockaddr_in *nsap;
	struct timeval	timeout;
	struct sockaddr_in from;
	int		fromlen;
	int		resplen;
	HEADER		*qp, *ap;
	struct cache	*creq;
	int		n;
	int		pending = 0;
	int		syncing = 0;
	int		itvl;
	void		prefetch_related();
#ifdef LOG
	void		show_query();
#endif

	now = time(NULL);

	if (buf == NULL)
		syncing = 1;
	if (!syncing) {	/* non-block caching */
		for (creq = Caches; creq != NULL; creq = creq->next)
		{
			if (creq->request != NULL
			 && res_queriesmatch(buf, buf + buflen, creq->request,
					     creq->request+creq->reqlen) > 0)
				break; /* already registed */
		}

		if (creq == NULL) /* regist in cache */
		{
#ifdef LOG
			if (tTd(76, 65)) {
				show_query("res_cache: regist",
					buf, buf+buflen);
			}
#endif
			creq = (struct cache *)malloc(sizeof(struct cache));
			if (creq == NULL)
				return(-1);	/* allocation failed */
			bzero(creq, sizeof(struct cache));
			creq->request = (u_char *)malloc(buflen);
			if (creq->request == NULL)
				return(-1);	/* allocation failed */
			bcopy(buf, creq->request, buflen);
			creq->reqlen = buflen;
			creq->next = Caches;
			Caches = creq;
		} else {
#ifdef LOG
			if (tTd(76, 65))
				syslog(LOG_DEBUG, "res_cache: found the query in cache (nop)");
#endif
			return (0);
		}
	}

	if (s == -1) {
		s = socket(AF_INET, SOCK_DGRAM, PF_UNSPEC);
		if (s < 0) {
			Perror(stderr, "socket", errno);
			return (-1);
		}
	}

again:
	/* send request packets */
	for (creq = Caches; creq != NULL; creq = creq->next)
	{
		if (creq->try >= (u_char)_res.retry)
			continue;	/* timed out */
		if (creq->nocache)
			continue;	/* nocache required */
		if (creq->answer != NULL)
			continue;	/* already got */
		if (creq->time <= now)	/* the time to work */
		{
			if (creq->time != 0)	/* not the first time */
			{
				do {
					++creq->ns;
				} while (creq->badns & (1<<creq->ns));
				if (creq->ns >= (u_char)_res.nscount)
				{
					creq->ns = 0;
					while (creq->badns & (1<<creq->ns))
						creq->ns++;
					if (creq->ns >= (u_char)_res.nscount) {
						/* no valid ns */
						creq->nocache = 1;
						/* set status of timeout */
						creq->try = (u_char)_res.retry;
#ifdef LOG
						if (tTd(76, 70))
							syslog(LOG_DEBUG, "res_cache: no valid ns (%x)", creq->badns);
#endif
						continue;
					}
					if (creq->try < (u_char)_res.retry)
						creq->try++;
				}
			}
			itvl = _res.retrans << creq->try;
#ifdef LOG
			if (tTd(76, 70)) {
				syslog(LOG_DEBUG, "res_cache: waiting %d sec.",
					itvl);
			}
#endif
			if (creq->try > 0)
				itvl /= _res.nscount;
			if (itvl <= 0)
				itvl = 1;
			creq->time = now + itvl;
			nsap = &_res.NSADDR_LIST(creq->ns);
#ifdef LOG
			if (tTd(76, 65)) {
				syslog(LOG_DEBUG, "res_cache: send query (server is %s)", inet_ntoa(nsap->sin_addr));
				show_query("res_cache: send query",
					creq->request,
					creq->request+creq->reqlen);
			}
#endif
			if (sendto(s, creq->request, creq->reqlen, 0,
				   (struct sockaddr *)nsap,
				   sizeof(struct sockaddr)) != creq->reqlen)
			{
				creq->badns |= 1<<creq->ns;
#ifdef LOG
				if (tTd(76, 70))
					syslog(LOG_DEBUG, "res_cache: invalid ns");
#endif
			}
#if 0 /* HAVE_USLEEP */
			usleep(10000); /* XXX */
#else
			timeout.tv_sec = 0;
			timeout.tv_usec = 10000; /* XXX */
			(void)select(0, (fd_set *)NULL, (fd_set *)NULL,
				     (fd_set *)NULL, &timeout);
#endif
		}
	}

	do {
		latest = 0;

		if (syncing) {
			/* get next action time */
			for (creq = Caches; creq != NULL; creq = creq->next)
			{
				if (creq->try >= (u_char)_res.retry)
					continue;	/* timed out */
				if (creq->nocache)
					continue;	/* nocache required */
				if (creq->answer != NULL)
					continue;	/* already got */
				if (latest == 0 || creq->time < latest)
					latest = creq->time;
			}

			if (latest == 0)	/* no more pending queries */
				break;
			if (latest > now)
				timeout.tv_sec = latest - now;
			else
				timeout.tv_sec = 1;	/* XXX */
			timeout.tv_usec = 0;
		} else {
			timeout.tv_sec = 0;
			timeout.tv_usec = 0;
		}
#ifdef LOG
		if (tTd(76, 70))
			syslog(LOG_DEBUG, "res_cache: waiting %d sec in %s mode", timeout.tv_sec, syncing?"sync":"nosync");
#endif
		FD_ZERO(&dsmask);
		FD_SET(s, &dsmask);
		if ((n = select(s+1, &dsmask, (fd_set *)NULL, (fd_set *)NULL,
			   &timeout)) > 0)
		{
			/* packet arrived */
			fromlen = sizeof(struct sockaddr_in);
			resplen = recvfrom(s, ans, anssiz, 0,
					   (struct sockaddr *)&from, &fromlen);
#ifdef LOG
			if (tTd(76, 70)) {
				show_query("res_cache: answer received",
					ans, ans+anssiz);
			}
#endif
			now = time(NULL);

			if (resplen <= 0) {
#ifdef LOG
				if (tTd(76, 70))
					syslog(LOG_DEBUG, "res_cache: bad anssiz %d", resplen);
#endif
				continue;	/* error */
			}

#if CHECK_SRVR_ADDR
			if (!(_res.options & RES_INSECURE1) &&
			    !res_isourserver(&from)) {
#ifdef LOG
				if (tTd(76, 70))
					syslog(LOG_DEBUG, "res_cache: not from our server");
#endif
				continue;  /* not from our server */
			}
#endif

			ap = (HEADER *)ans;
			for (creq = Caches; creq != NULL; creq = creq->next)
			{
				qp = (HEADER *)creq->request;

				if (qp->id == ap->id
				 && res_queriesmatch(ans, ans + resplen,
						     creq->request,
						     creq->request+creq->reqlen)
				    > 0)
				{
					if (ap->tc) {
						creq->nocache = 1;
						break;
					}
					if (ap->rcode == SERVFAIL ||
					    ap->rcode == NOTIMP ||
					    ap->rcode == REFUSED) {
						creq->badns |= (1<<creq->ns);
#ifdef LOG
						if (tTd(76, 70))
							syslog(LOG_DEBUG, "res_cache: badnsF %x/%x", creq->badns, (1<<_res.nscount)-1);
#endif
						if (creq->badns != (1<<_res.nscount)-1)
							break;
					}
#ifdef LOG
					if (tTd(76, 65)) {
						show_query("res_cache: cache answer", ans, ans+resplen);
					}
#endif

					prefetch_related(ans, ans+resplen);

					creq->answer = (u_char*)malloc(resplen);
					if (creq->answer != NULL) {
						bcopy(ans, creq->answer,
						resplen);
					} else {
						/* error */
					}
					creq->anslen = resplen;
					creq->try = (u_char)_res.retry;
					creq->time = now + 3600; /* XXX */

					break;
				}
			}
			if (creq == NULL)
			{
				/* no associated query */
#ifdef LOG
				if (tTd(76, 70))
					syslog(LOG_DEBUG, "res_cache: what??");
#endif
				continue;
			}
		}
		if (n < 0) {
			/* error in select */
			break;
		}
	} while(n > 0);

	if (syncing) {
		pending = 0;
#ifdef LOG
		if (tTd(76, 80))
			syslog(LOG_DEBUG, "res_cache: get nearest timeout from %d", now);
#endif
		for (creq = Caches; creq != NULL; creq = creq->next)
		{
			if (creq->try >= (u_char)_res.retry)
				continue;	/* timed out */
			if (creq->nocache)
				continue;	/* nocache required */
			if (creq->answer != NULL)
				continue;

			pending++;
#ifdef LOG
			if (tTd(76, 80))
				syslog(LOG_DEBUG, "res_cache: event timeout=%d",
					creq->time);
#endif
		}
		if (pending)
		{
#ifdef LOG
			if (tTd(76, 65))
				syslog(LOG_DEBUG, "res_cache: retry sync");
#endif
			/* sleep(1); /* XXX */
			now = time(NULL);
			goto again;
		}
	}
	return (0);
}


/*
 * for sync operation
 */
/* void */
res_sync()
{
        char qbuf[PACKETSZ];
#ifdef LOG
	if (tTd(76, 80))
		syslog(LOG_DEBUG, "res_sync: requested");
#endif
	(void)res_send(NULL, 0, (RES_UNC_T)qbuf, PACKETSZ);
}


/* XXX additinal records should be considerd */
void
prefetch_related(b, e)
u_char *b, *e;
{
	char nbuf[MAXDNAME+1];
	char mxbuf[MAXDNAME*16], *mxp, *p;
	register int n;
	int type, class, pref;
	HEADER *hp;
	u_char *eom, *ap;
	struct hostent *hep;
	int ancount, qdcount, nscount, arcount;
        union
        {
                HEADER  qb1;
                char    qb2[PACKETSZ];
        } answer;

	hp = (HEADER *) b;
	ap = (u_char *) b + sizeof(HEADER);
	eom = (u_char *) e;

	for (qdcount = ntohs(hp->qdcount); qdcount--; )
	{
		n = dn_expand((u_char *) b, eom, ap, nbuf, sizeof nbuf);
		ap += n;
		GETSHORT(type, ap);
		GETSHORT(class, ap);
	}

	if (type != T_MX)
		return;

	if (ntohs(hp->ancount) == 0)
	{
#ifdef LOG
		if (tTd(76, 20))
			syslog(LOG_DEBUG, "prefetch: getting A RR for %s",
				nbuf);
#endif
		res_query(nbuf, C_IN, T_A, (RES_UNC_T)&answer, sizeof(answer));
		return;
	}

	mxp = mxbuf;
	mxbuf[0] = '\0';
	for (ancount = ntohs(hp->ancount); --ancount >= 0 && ap < eom;)
	{
		n = dn_expand((u_char *) b, eom, ap, nbuf, sizeof nbuf);
		if (n < 0)
			break;
		ap += n;
		GETSHORT(type, ap);
		GETSHORT(class, ap);
		ap += sizeof(long);
		GETSHORT(n, ap);
		if (type == T_MX) {
			GETSHORT(pref, ap);
			if ((n = dn_expand((u_char *) b, eom, ap,
					   nbuf, sizeof nbuf)) < 0)
				break;
			ap += n;
			if (mxp - mxbuf + strlen(nbuf) < sizeof(mxbuf)-1)
			{
				if (mxp != mxbuf)
					*mxp++ = ':';
				strcpy(mxp, nbuf);
				mxp += strlen(nbuf);
			}
		} else {
			ap += n;
		}
	}

#ifdef LOG
	if (tTd(76, 20))
		syslog(LOG_DEBUG, "prefetch: tempsig=%s", mxbuf);
#endif
	nscount = ntohs(hp->nscount);
	arcount = ntohs(hp->arcount);
	if (arcount == 0)
		goto noadditional;

	while (--ancount >= 0 && ap < eom)
	{
		if ((n = dn_skipname(ap, eom)) < 0)
			goto noadditional;
		ap += n;
		ap += INT16SZ + INT16SZ + INT32SZ;
		GETSHORT(n, ap);
		ap += n;
	}
	while (--nscount >= 0 && ap < eom)
	{
		if ((n = dn_skipname(ap, eom)) < 0)
			goto noadditional;
		ap += n;
 		ap += INT16SZ + INT16SZ + INT32SZ;
		GETSHORT(n, ap);
		ap += n;
	}
	while (--arcount >= 0 && ap < eom)
	{
		int addrsize;

		if ((n = dn_expand((u_char *) b, eom, ap,
				nbuf, sizeof nbuf)) < 0)
			break;
		ap += n;
		GETSHORT(type, ap);
 		ap += INT16SZ + INT32SZ;
		GETSHORT(addrsize, ap);
		if (type != T_A)
		{
			ap += addrsize;
			continue;
		}

		n = strlen(nbuf);
		if (nbuf[n-1] != '.')
		{
			nbuf[n++] = '.';
			nbuf[n] = '\0';
		}
#ifdef LOG
		if (tTd(76, 20))
			syslog(LOG_DEBUG, "prefetch: got additional A RR: %s",
				nbuf);
#endif
		mxp = mxbuf;
		while (mxp != NULL)
		{
			if ((p = strchr(mxp, ':')) != NULL)
				*p = '\0';
			if (strcmp(mxp, nbuf) == 0)
			{
#ifdef LOG
				if (tTd(76, 20))
					syslog(LOG_DEBUG, "prefetch: %s with additional A", mxp);
#endif
				if (p != NULL)
				{
					strcpy(mxp, p+1);
					p = mxp;
				}
				else if (mxp == mxbuf)
					*mxp = '\0';
				else
					*--mxp = '\0';
			}
			if (p != NULL && p != mxp)
			{
				*p++ = ':';
			}
			mxp = p;
		}

		ap += addrsize;
	}
  noadditional:

	mxp = mxbuf;
	while (mxp != NULL)
	{
		if ((p = strchr(mxp, ':')) != NULL)
			*p++ = '\0';
#ifdef LOG
		if (tTd(76, 20))
			syslog(LOG_DEBUG, "prefetch: getting A RR for %s",
				mxp);
#endif
		res_query(mxp, C_IN, T_A, (RES_UNC_T)&answer, sizeof(answer));
		mxp = p;
	}
}


#ifdef LOG
void
show_query(t, b, e)
u_char *t, *b, *e;
{
	char nbuf[MAXDNAME+1];
	register int n;
	int type, class, pref;
	HEADER *hp;
	u_char *eom, *ap;
	struct hostent *hep;
	int ancount, qdcount;

	hp = (HEADER *) b;
	ap = (u_char *) b + sizeof(HEADER);
	eom = (u_char *) e;

	/* skip question part of response -- we know what we asked */
	for (qdcount = ntohs(hp->qdcount); qdcount--; )
	{
		n = dn_expand((u_char *) b, eom, ap, nbuf, sizeof nbuf);
		ap += n;
		GETSHORT(type, ap);
		GETSHORT(class, ap);
		syslog(LOG_DEBUG, "%s: %s(%d,%d), rcode=%d",
			t, nbuf, class, type, ntohs(hp->rcode));
	}

	if (ntohs(hp->ancount) == 0)
		return;

	for (ancount = ntohs(hp->ancount); --ancount >= 0 && ap < eom;)
	{
		n = dn_expand((u_char *) b, eom, ap, nbuf, sizeof nbuf);
		if (n < 0)
			break;
		ap += n;
		GETSHORT(type, ap);
		GETSHORT(class, ap);
		ap += sizeof(long);
		GETSHORT(n, ap);
		if (type == T_MX) {
			GETSHORT(pref, ap);
			if ((n = dn_expand((u_char *) b, eom, ap,
					   nbuf, sizeof nbuf)) < 0)
				break;
			ap += n;
			syslog(LOG_DEBUG, "got MX pref=%d,host=(%s)",
				pref, nbuf);
#if 0 /* for debug */
			hep = gethostbyname(nbuf);
			if (hep == NULL) {
				syslog(LOG_DEBUG, "get A --  h_errno=%d",
					h_errno);
			} else {
				syslog(LOG_DEBUG, "get A -- OK");
			}
#endif
		} else {
			ap += n;
			/* syslog(LOG_DEBUG, "unexpected answer type: %d",
				type); */
		}
	}
}
#endif
#endif /* RES_NONBLOCK */
#endif /* RESOLV_HACK */
