/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/align.c,v 2.0 91/03/05 12:46:11 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "drawing.e"	/* RedrawAreas () */
#include "dup.e"	/* justDupped */
#include "grid.e"	/* GridXY () */
#include "mark.e"	/* HighLightForward (), HighLightReverse () */
#include "move.e"	/* MoveObj () */
#include "obj.e"	/* botObj */
#include "select.e"	/* topSel */
#include "setup.e"	/* fileModified */

int	horiAlign = ALIGN_L;
int	vertAlign = ALIGN_T;

void AlignSelObjs ()
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   register int			x = 0, y = 0;
   int				pivot_x = 0, pivot_y = 0;
   int				dx, dy, ltx, lty, rbx, rby;

   if (topSel == NULL) return;

   HighLightReverse ();
   switch (horiAlign)
   {
      case ALIGN_L : pivot_x = selObjLtX; break;
      case ALIGN_C : pivot_x = (selObjLtX + selObjRbX) / 2; break;
      case ALIGN_R : pivot_x = selObjRbX; break;
   }
   switch (vertAlign)
   {
      case ALIGN_T : pivot_y = selObjLtY; break;
      case ALIGN_M : pivot_y = (selObjLtY + selObjRbY) / 2; break;
      case ALIGN_B : pivot_y = selObjRbY; break;
   }

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      switch (horiAlign)
      {
         case ALIGN_L : x = obj_ptr->obbox.ltx; break;
         case ALIGN_C : x = (obj_ptr->obbox.ltx+obj_ptr->obbox.rbx) / 2; break;
         case ALIGN_R : x = obj_ptr->obbox.rbx; break;
      }
      switch (vertAlign)
      {
         case ALIGN_T : y = obj_ptr->obbox.lty; break;
         case ALIGN_M : y = (obj_ptr->obbox.lty+obj_ptr->obbox.rby) / 2; break;
         case ALIGN_B : y = obj_ptr->obbox.rby; break;
      }
      if (horiAlign == ALIGN_N) x = pivot_x;
      if (vertAlign == ALIGN_N) y = pivot_y;

      dx = pivot_x - x;
      dy = pivot_y - y;

      MoveObj (obj_ptr, dx, dy);
   }
   ltx = selLtX; lty = selLtY; rbx = selRbX, rby = selRbY;
   UpdSelBBox ();
#ifndef UC
   RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
         rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
         selLtY-(1<<zoomScale), selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
         rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
         selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   SetFileModified (TRUE);
   justDupped = FALSE;
}

void AlignSelToGrid ()
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   register int			x = 0, y = 0;
   int				grid_x, grid_y, dx, dy, ltx, lty, rbx, rby;

   if (topSel == NULL) return;

   HighLightReverse ();
   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      switch (horiAlign)
      {
         case ALIGN_L : x = obj_ptr->obbox.ltx; break;
         case ALIGN_C : x = (obj_ptr->obbox.ltx+obj_ptr->obbox.rbx) / 2; break;
         case ALIGN_R : x = obj_ptr->obbox.rbx; break;
      }
      switch (vertAlign)
      {
         case ALIGN_T : y = obj_ptr->obbox.lty; break;
         case ALIGN_M : y = (obj_ptr->obbox.lty+obj_ptr->obbox.rby) / 2; break;
         case ALIGN_B : y = obj_ptr->obbox.rby; break;
      }
      GridXY (x, y, &grid_x, &grid_y);
      if (horiAlign == ALIGN_N) x = grid_x;
      if (vertAlign == ALIGN_N) y = grid_y;

#ifndef UC
      dx = (grid_x - x) << zoomScale;
      dy = (grid_y - y) << zoomScale;
#else /* UC */
      dx = RealSize((grid_x - x), zoomScale);
      dy = RealSize((grid_y - y), zoomScale);
#endif /* UC */

      MoveObj (obj_ptr, dx, dy);
   }
   ltx = selLtX; lty = selLtY; rbx = selRbX, rby = selRbY;
   UpdSelBBox ();
#ifndef UC
   RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
         rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
         selLtY-(1<<zoomScale), selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
         rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
         selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   SetFileModified (TRUE);
   justDupped = FALSE;
}
