/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/animate.c,v 2.0 91/03/05 12:46:35 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "color.e"
#include "raster.e"
#include "select.e"
#include "setup.e"

#define SEND_SPEED 8

#define TOKEN_R 8

static XPoint	savedToken[5];

void AnimateSend (PolyPtr, Speed, Pixel)
   struct PolyRec	* PolyPtr;
   int			Speed, Pixel;
{
   register int		delta, i;
   register XPoint	* token;
   int			x, y, num_pts, j, x_dist, y_dist;
   XPoint		* v;
   struct BBRec		bbox;
   double		slope, delta_x, delta_y;
   XGCValues		values;

   values.foreground = Pixel;
   values.function = GXxor;
   values.line_style = FillSolid;
   values.line_width = 0;
   XChangeGC (mainDisplay, drawGC,
         GCForeground | GCFunction | GCLineStyle | GCLineWidth, &values);

   bbox.ltx = 0; bbox.lty = 0; bbox.rbx = 2*TOKEN_R; bbox.rby = 2*TOKEN_R;

   num_pts = PolyPtr->n;
   v = PolyPtr->vlist;
   token = (XPoint *) calloc (5, sizeof(XPoint));

   for (j = 0; j < num_pts-1; j++)
   {
      x = OFFSET_X(v[j].x);
      y = OFFSET_Y(v[j].y);
      token[0].x = (short)(x - TOKEN_R); token[0].y = (short)(y - TOKEN_R);
      token[1].x = (short)(x + TOKEN_R); token[1].y = (short)(y - TOKEN_R);
      token[2].x = (short)(x + TOKEN_R); token[2].y = (short)(y + TOKEN_R);
      token[3].x = (short)(x - TOKEN_R); token[3].y = (short)(y + TOKEN_R);
      token[4].x = (short)(x - TOKEN_R); token[4].y = (short)(y - TOKEN_R);
      XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
            CoordModeOrigin);
      if (v[j].x == v[j+1].x)
      {  /* moving vertical */
#ifndef UC
         if ((y_dist = (v[j+1].y-v[j].y)>>zoomScale) > 0)
#else /* UC */
         if ((y_dist = ScreenSize((v[j+1].y-v[j].y), zoomScale)) > 0)
#endif /* UC */
         {  /* moving down */
            for (delta = 0; delta < y_dist; delta += Speed)
            {
               XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
                     CoordModeOrigin);
               for (i = 0; i < 5; i++) token[i].y += Speed;
               XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
                     CoordModeOrigin);
            }
         }
         else
         {  /* moving up */
            for (delta = y_dist; delta < 0; delta += Speed)
            {
               XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
                     CoordModeOrigin);
               for (i = 0; i < 5; i++) token[i].y -= Speed;
               XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
                     CoordModeOrigin);
            }
         }
      }
      else if (v[j].y == v[j+1].y)
      {  /* moving horizontal */
#ifndef UC
         if ((x_dist = (v[j+1].x-v[j].x)>>zoomScale) > 0)
#else /* UC */
         if ((x_dist = ScreenSize((v[j+1].x-v[j].x), zoomScale)) > 0)
#endif /* UC */
         {  /* moving right */
            for (delta = 0; delta < x_dist; delta += Speed)
            {
               XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
                     CoordModeOrigin);
               for (i = 0; i < 5; i++) token[i].x += Speed;
               XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
                     CoordModeOrigin);
            }
         }
         else
         {  /* moving left */
            for (delta = x_dist; delta < 0; delta += Speed)
            {
               XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
                     CoordModeOrigin);
               for (i = 0; i < 5; i++) token[i].x -= Speed;
               XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
                     CoordModeOrigin);
            }
         }
      }
      else
      {  /* moving diagonally */
#ifndef UC
         x_dist = (v[j+1].x-v[j].x)>>zoomScale;
         y_dist = (v[j+1].y-v[j].y)>>zoomScale;
#else /* UC */
         x_dist = ScreenSize((v[j+1].x-v[j].x), zoomScale);
         y_dist = ScreenSize((v[j+1].y-v[j].y), zoomScale);
#endif /* UC */
         for (i = 0; i < 5; i++)
         {
            savedToken[i].x = token[i].x;
            savedToken[i].y = token[i].y;
         }
         if (abs (x_dist) > abs (y_dist))
         {  /* moving in the x direction */
            slope = (double)y_dist / (double)x_dist;
            if (x_dist > 0)
            {  /* moving right */
               for (delta = 0; delta < x_dist; delta += Speed)
               {
                  XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5,
                        Convex, CoordModeOrigin);
                  delta_y = slope * (double)delta;
                  for (i = 0; i < 5; i++)
                  {
                     token[i].x = savedToken[i].x + delta;
                     token[i].y = savedToken[i].y + delta_y;
                  }
                  XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5,
                        Convex, CoordModeOrigin);
               }
            }
            else
            {  /* moving left */
               for (delta = 0; delta > x_dist; delta -= Speed)
               {
                  XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5,
                        Convex, CoordModeOrigin);
                  delta_y = slope * (double)delta;
                  for (i = 0; i < 5; i++)
                  {
                     token[i].x = savedToken[i].x + delta;
                     token[i].y = savedToken[i].y + delta_y;
                  }
                  XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5,
                        Convex, CoordModeOrigin);
               }
            }
         }
         else
         {  /* moving in the y direction */
            slope = (double)x_dist / (double)y_dist;
            if (y_dist > 0)
            {  /* moving down */
               for (delta = 0; delta < y_dist; delta += Speed)
               {
                  XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5,
                        Convex, CoordModeOrigin);
                  delta_x = slope * (double)delta;
                  for (i = 0; i < 5; i++)
                  {
                     token[i].x = savedToken[i].x + delta_x;
                     token[i].y = savedToken[i].y + delta;
                  }
                  XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5,
                        Convex, CoordModeOrigin);
               }
            }
            else
            {  /* moving up */
               for (delta = 0; delta > y_dist; delta -= Speed)
               {
                  XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5,
                        Convex, CoordModeOrigin);
                  delta_x = slope * (double)delta;
                  for (i = 0; i < 5; i++)
                  {
                     token[i].x = savedToken[i].x + delta_x;
                     token[i].y = savedToken[i].y + delta;
                  }
                  XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5,
                        Convex, CoordModeOrigin);
               }
            }
         }
      }
      XFillPolygon (mainDisplay, drawWindow, drawGC, token, 5, Convex,
            CoordModeOrigin);
   }
   cfree (token);
}

void AnimateSel ()
{
   if (topSel != botSel || topSel == NULL || topSel->obj->type != OBJ_POLY)
   {
      Msg ("Please select only one POLY object.");
      return;
   }
   AnimateSend (topSel->obj->detail.p, SEND_SPEED,
         xorColorPixels[topSel->obj->color]);
}

void AnimateFlashColor(ObjPtr, ColorIndex)
   struct ObjRec	* ObjPtr;
   int			ColorIndex;
{
   int	saved_color_index = ObjPtr->color;

   ObjPtr->color = ColorIndex;
   DrawPolyObj (drawWindow, drawOrigX, drawOrigY, ObjPtr);
   ObjPtr->color = saved_color_index;
   DrawPolyObj (drawWindow, drawOrigX, drawOrigY, ObjPtr);
}

void FlashSelColor ()
{
   register int	i;

   if (topSel != botSel || topSel == NULL || topSel->obj->type != OBJ_POLY)
   {
      Msg ("Please select only one POLY object.");
      return;
   }
   for (i = 0; i < maxColors; i++)
      if (strcmp ("white", colorMenuItems[i]) == 0)
         break;
   AnimateFlashColor (topSel->obj, i);
}
