/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/attr.c,v 2.0 91/03/05 12:46:41 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "color.e"
#include "cursor.e"
#include "dialog.e"
#include "drawing.e"
#include "dup.e"
#include "file.e"
#include "font.e"
#include "mainloop.e"
#include "mark.e"
#include "menu.e"
#include "msg.e"
#include "obj.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "text.e"

#define PAINT 0
#define ERASE 1

static struct AttrRec	* topAttr = NULL, * botAttr = NULL;

void LinkInAttr (PrevPtr, NextPtr, AttrPtr)
   struct AttrRec	* PrevPtr, * NextPtr, * AttrPtr;
   /* add AttrPtr between PrevPtr and NextPtr */
{
   AttrPtr->prev = PrevPtr;
   AttrPtr->next = NextPtr;

   if (PrevPtr == NULL)
      topAttr = AttrPtr;
   else
      PrevPtr->next = AttrPtr;

   if (NextPtr == NULL)
      botAttr = AttrPtr;
   else
      NextPtr->prev = AttrPtr;
}

void FreeAttr (AttrPtr)
   struct AttrRec	* AttrPtr;
   /* This routine only frees the attribute record, not   */
   /*    the text record, which must be freed explicitly. */
{
   cfree (AttrPtr);
}

void UnlinkAttr (AttrPtr)
   struct AttrRec	* AttrPtr;
{
   struct ObjRec	* own_ptr;
   struct AttrRec	* * top_attr_ad;
   struct AttrRec	* * bot_attr_ad;

   own_ptr = AttrPtr->owner;
 
   top_attr_ad = &(own_ptr->fattr);
   bot_attr_ad = &(own_ptr->lattr);
     
   if (*top_attr_ad == AttrPtr)
      *top_attr_ad = AttrPtr->next;
   else
      AttrPtr->prev->next = AttrPtr->next;

   if (*bot_attr_ad == AttrPtr)
      *bot_attr_ad = AttrPtr->prev;
   else
      AttrPtr->next->prev = AttrPtr->prev;
}

static
char * FindEqual(s)
   register char	* s;
{
   while (*s != '=' && *s != '\0') s++;
   return ((*s == '=') ? (s) : (char *)NULL);
}

static
void ParseAttrStr(Str, name, s)
   char	* Str, * name, * s;
{
   char	* eq_ptr, * str_ptr, * ptr;

   if ((eq_ptr = FindEqual(Str)) != NULL)
   {
      eq_ptr++;
      ptr = name;
      str_ptr = Str;
      do
      {
         *ptr = *str_ptr; 
         ptr++;
         str_ptr++;
      } while (str_ptr != eq_ptr);
 
      *ptr = '\0';

      ptr = s;
      do 
      {
         *ptr = *str_ptr; 
         ptr++;
         str_ptr++;
      } while (*str_ptr != '\0');

      *ptr = '\0';
   }
   else
   {
      *name = '\0';
      strcpy (s, Str);
   }
} 

void UpdateAttr (TextPtr, AttrPtr)
   struct TextRec	* TextPtr;
   struct AttrRec	* AttrPtr;
   /* This routine updates the name and value in the AttrRec */
   /*   and its ObjRec after an attribute was edited.        */
{
   char	s[MAXSTRING+1], name[MAXSTRING+1];

   if (AttrPtr->nameshown)
   {
      ParseAttrStr (TextPtr->first->s, name, s);
      strcpy (AttrPtr->s, s);
      strcpy (AttrPtr->name, name);
   }
   else
   {
      strcpy (s, TextPtr->first->s);
      strcpy (AttrPtr->s, s);
   }

   if (!(AttrPtr->shown))
      TextPtr->first->s[0] = '\0';
   else
   {
      if (AttrPtr->nameshown)
      {
         strcat (name, s);
         strcpy (TextPtr->first->s, name);
      }
      else
          strcpy (TextPtr->first->s, s);
   }
   UpdTextBBox (AttrPtr->obj);
}

void DrawAttrs (Win, XOff, YOff, AttrPtr)
   Window		Win;
   int			XOff, YOff;
   struct AttrRec	* AttrPtr;
{
   struct AttrRec	* ptr;

   for (ptr = AttrPtr; ptr != NULL; ptr = ptr->next)
      if (ptr->shown)
         DrawTextObj(Win, XOff, YOff, ptr->obj);
}

void MoveAttrs (AttrPtr, Dx, Dy)
   int			Dx, Dy;
   struct AttrRec	* AttrPtr;
{
   struct AttrRec	* ptr;

   for (ptr = AttrPtr; ptr != NULL; ptr = ptr->next)
   {
      ptr->obj->x += Dx;
      ptr->obj->y += Dy;
      ptr->obj->bbox.ltx += Dx;
      ptr->obj->bbox.lty += Dy;
      ptr->obj->bbox.rbx += Dx;
      ptr->obj->bbox.rby += Dy;
      ptr->obj->obbox.ltx += Dx;
      ptr->obj->obbox.lty += Dy;
      ptr->obj->obbox.rbx += Dx;
      ptr->obj->obbox.rby += Dy;
   }
}

void DelAllAttrs (AttrPtr)
   struct AttrRec	* AttrPtr;
{
   struct AttrRec	* ptr;

   for (ptr = AttrPtr; ptr != NULL; ptr = ptr->next)
   {
      FreeTextObj(ptr->obj);
      FreeAttr(ptr);
   }
}

static
struct AttrRec	* NewAttr (OwnerObjPtr, ObjPtr, Inherited)
   struct ObjRec	* ObjPtr;
   struct ObjRec	* OwnerObjPtr;
   short		Inherited;
{
   struct AttrRec	* attr_ptr;
    
   attr_ptr = (struct AttrRec *) calloc (1, sizeof(struct AttrRec));
   attr_ptr->shown = TRUE;
   attr_ptr->nameshown = TRUE;
   attr_ptr->inherited = Inherited;
   attr_ptr->obj = ObjPtr;
   attr_ptr->next= attr_ptr->prev = NULL;
   attr_ptr->owner = OwnerObjPtr;
   ObjPtr->detail.t->attr = attr_ptr;

   return attr_ptr;
}

static
void DupAnAttr (FromAttrPtr, ToAttrPtr)
   register struct AttrRec	* FromAttrPtr, * ToAttrPtr;
{
   struct ObjRec	* text_obj_ptr;

   text_obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   DupObjBasics (FromAttrPtr->obj, text_obj_ptr);
   DupTextObj (FromAttrPtr->obj->detail.t, text_obj_ptr);

   strcpy(ToAttrPtr->name, FromAttrPtr->name);
   strcpy(ToAttrPtr->s, FromAttrPtr->s);
   ToAttrPtr->shown = FromAttrPtr->shown;
   ToAttrPtr->nameshown = FromAttrPtr->nameshown;
   ToAttrPtr->inherited = FromAttrPtr->inherited;
   ToAttrPtr->obj = text_obj_ptr;
   ToAttrPtr->next= ToAttrPtr->prev = NULL;
   text_obj_ptr->detail.t->attr = ToAttrPtr;
}

void DupAttrs (FromObjPtr, ToObjPtr)
   register struct ObjRec	* FromObjPtr, * ToObjPtr;
{
   register struct AttrRec	* to_attr_ptr, * from_attr_ptr;

   topAttr = botAttr = NULL;
   from_attr_ptr = FromObjPtr->fattr;
   for ( ; from_attr_ptr != NULL; from_attr_ptr = from_attr_ptr->next)
   {
      to_attr_ptr = (struct AttrRec *) calloc (1, sizeof(struct AttrRec));
      to_attr_ptr->owner = ToObjPtr;
      DupAnAttr (from_attr_ptr, to_attr_ptr);
      LinkInAttr (NULL, topAttr, to_attr_ptr);
   }
   ToObjPtr->fattr = topAttr;
   ToObjPtr->lattr = botAttr;
}

static
void AddAttr(ObjPtr, TextObjPtr)
   struct ObjRec	* ObjPtr, * TextObjPtr;
{
   struct AttrRec	* attr_ptr;
   struct TextRec	* text_ptr;
   char			name[MAXSTRING+1], value[MAXSTRING+1];

   text_ptr = TextObjPtr->detail.t; 

   ParseAttrStr(text_ptr->first->s, name, value);
   topAttr = ObjPtr->fattr;
   botAttr = ObjPtr->lattr;

   UnlinkObj (TextObjPtr);
   TextObjPtr->next = TextObjPtr->prev = NULL;
   attr_ptr = NewAttr (ObjPtr, TextObjPtr, FALSE); 
   UpdateAttr (text_ptr, attr_ptr); 
   LinkInAttr (NULL, topAttr, attr_ptr);

   ObjPtr->fattr = topAttr;
   ObjPtr->lattr = botAttr;
}

void AddAttrs ()
{
   struct ObjRec	* owner_ptr = NULL;
   struct SelRec	* sel_ptr;
   int			text_count = 0, sel_ltx, sel_lty, sel_rbx, sel_rby;

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      switch (sel_ptr->obj->type)
      {
         case OBJ_TEXT: text_count++; break;

         case OBJ_BOX:
         case OBJ_OVAL:
         case OBJ_POLYGON:
         case OBJ_POLY:
         case OBJ_SYM:
         case OBJ_GROUP:
         case OBJ_ICON:
         case OBJ_ARC:
         case OBJ_RCBOX:
         case OBJ_XBM:
            if (owner_ptr != NULL)
            {
               Msg("Two non-text objects selected.");
               return;
            }
            owner_ptr = sel_ptr->obj;
            break; 
      }
 
   if (text_count == 0)
   {
      Msg("No text objects selected to add as attributes.");
      return;
   }
   if (owner_ptr == NULL)
   {
      Msg("No objects (other than TEXT objects) selected.");
      return;
   }

   HighLightReverse ();
   sel_ltx = selLtX; sel_lty = selLtY;
   sel_rbx = selRbX; sel_rby = selRbY;

   for (sel_ptr = botSel;  sel_ptr != NULL; sel_ptr = sel_ptr->prev)
      if (sel_ptr->obj->type == OBJ_TEXT)
         AddAttr(owner_ptr, sel_ptr->obj);

   RemoveAllSel ();
   UnlinkObj (owner_ptr);
   AddObj (NULL, topObj, owner_ptr);
   topSel = botSel = (struct SelRec *) calloc (1, sizeof(struct SelRec));
   topSel->obj = owner_ptr;
   topSel->prev = NULL;
   botSel->next = NULL;
   AdjObjBBox (owner_ptr);
   UpdSelBBox ();
#ifndef UC
   RedrawAreas (botObj, sel_ltx-(1<<zoomScale), sel_lty-(1<<zoomScale),
         sel_rbx+(1<<zoomScale), sel_rby+(1<<zoomScale),
         selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
         selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAreas (botObj, sel_ltx-(RealSize(1, zoomScale)), sel_lty-(RealSize(1, zoomScale)),
         sel_rbx+(RealSize(1, zoomScale)), sel_rby+(RealSize(1, zoomScale)),
         selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
         selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   justDupped = FALSE;
}

static
void SaveAttr (FP, AttrPtr)
   FILE			* FP;
   struct AttrRec	* AttrPtr;
{
   fprintf (FP, "attr(\"");
   SaveString (FP, AttrPtr->name);
   fprintf (FP, "\", \"");
   SaveString (FP, AttrPtr->s);
   fprintf (FP, "\", %1d, %1d, %1d,\n",
         AttrPtr->shown, AttrPtr->nameshown, AttrPtr->inherited);
  
   SaveTextObj (FP, AttrPtr->obj);
   fprintf (FP, ")");         
}

void SaveAttrs (FP, BotAttrPtr)
   FILE			* FP;
   struct AttrRec	* BotAttrPtr;
{
 
   struct AttrRec       * ptr;

   fprintf (FP, "[\n");

   for (ptr = BotAttrPtr; ptr != NULL; ptr = ptr->prev)
     {
       SaveAttr (FP, ptr);
       if (ptr->prev != NULL)
         fprintf (FP, ",\n");
     }

   if (BotAttrPtr == NULL)
      fprintf (FP, "]");
   else
      fprintf (FP, "\n]");
}

static
char * ReadAttrString (Str)
   char	* Str;
{
   register char	* s = Str;

   for (s = Str; *s != '\0' && *s != '"'; s++)
      if (*s == '\\')
         s++;

   if (*s == '"') s++;
   return (s);
}

int ReadAttr (FP, AttrPtr, PRTGIF)
   FILE			* FP;
   struct AttrRec	* * AttrPtr;
   int			PRTGIF;
{
   struct ObjRec	* TextObj;
   char			inbuf[MAXSTRING+1], * s;
   char			name[MAXSTRING+1], value[MAXSTRING+1];
   int			len, shown, nameshown, inherited;
 
   fgets (inbuf, MAXSTRING, FP); 

   if (inbuf[0] == ']')  return (FALSE);

   *AttrPtr = (struct AttrRec *)  calloc (1, sizeof(struct AttrRec)); 

   len = strlen(inbuf) - 1;
   inbuf[len] = '\0';

   strcpy(name, FindChar ('"', inbuf));
   s = ReadAttrString (inbuf);
   s = FindChar (',', s);
   strcpy(value, FindChar ('"', s));
   s = ReadAttrString (value);
   s = FindChar (',', s);
   sscanf (s, "%d, %d, %d", &shown, &nameshown, &inherited);

   s = ReadString (name);
   *(--s) = '\0';
   strcpy ((*AttrPtr)->name, name);
   s = ReadString (value);
   *(--s) = '\0';
   strcpy ((*AttrPtr)->s, value);

   (*AttrPtr)->shown = shown;
   (*AttrPtr)->nameshown = nameshown;
   (*AttrPtr)->inherited = inherited;

   ReadObj (FP, &TextObj, PRTGIF);
   TextObj->detail.t->attr = *AttrPtr;
   (*AttrPtr)->obj = TextObj;

   return (TRUE);
}

static
int ShowAndUpdAttrNames (Force)
   int	Force;
   /* Force will force attribute name to be shown whether the attribute */
   /*    is inherited or not.                                           */
   /* returns TRUE if any attribute names are updated                   */
   /* This routine concatinate the 'name' and 's' first of every        */
   /*    attribute of the selected object and assign that to the        */
   /*    first line of the text object the attribute pointer points to. */
{
   struct SelRec	* sel_ptr;
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr;
   int			picture_changed = FALSE, obj_changed;
   int			len1, len2;
   char			* s, msg[80];

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      attr_ptr = obj_ptr->fattr;
      if (attr_ptr != NULL)
      {
         obj_changed = FALSE;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
         {
            if (!(attr_ptr->nameshown) && (Force || !(attr_ptr->inherited)))
            {
               s = attr_ptr->obj->detail.t->first->s;
               strcpy (s, attr_ptr->name);

               len1 = strlen (attr_ptr->name);
               len2 = strlen (attr_ptr->s);
               if (len1+len2 >= MAXSTRING)
               {
                  sprintf (msg, "String length exceeds %1d.  String truncated.",
                        MAXSTRING);
                  Msg (msg);
                  attr_ptr->s[MAXSTRING-len1] = '\0';
               }

               strcat (s, attr_ptr->s);
               attr_ptr->nameshown = TRUE;
               UpdTextBBox (attr_ptr->obj);
               if (attr_ptr->shown) obj_changed = picture_changed = TRUE;
            }
         }
         if (obj_changed) AdjObjBBox (obj_ptr);
      }
   }
   return (picture_changed);
}

void ShowAllAttrNames ()
{
   if (ShowAndUpdAttrNames (TRUE))
   {
      HighLightReverse ();
      UpdSelBBox ();
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
      SetFileModified (TRUE);
   }
}

static
int HideAndUpdAttrNames ()
   /* returns TRUE if any attribute names are updated */
   /* For all the first line of the selected object's attributes,    */
   /*    this routine change them to the 's' field of the attribute. */
{
   struct SelRec	* sel_ptr;
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr;
   int			picture_changed = FALSE, obj_changed;
   char			* s;

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      attr_ptr = obj_ptr->fattr;
      if (attr_ptr != NULL)
      {
         obj_changed = FALSE;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
         {
            if (attr_ptr->nameshown && *(attr_ptr->name) != '\0')
            {
               attr_ptr->nameshown = FALSE;
               s = attr_ptr->obj->detail.t->first->s;
               strcpy (s, attr_ptr->s);
               UpdTextBBox (attr_ptr->obj);
               if (attr_ptr->shown) obj_changed = picture_changed = TRUE;
            }
         }
         if (obj_changed) AdjObjBBox (obj_ptr);
      }
   }
   return (picture_changed);
}

void HideAllAttrNames ()
{
   int	sel_ltx, sel_lty, sel_rbx, sel_rby;

   sel_ltx = selLtX; sel_lty = selLtY; sel_rbx = selRbX; sel_rby = selRbY;

   if (HideAndUpdAttrNames ())
   {
      HighLightReverse ();
      UpdSelBBox ();
#ifndef UC
      RedrawAnArea (botObj, sel_ltx-(1<<zoomScale), sel_lty-(1<<zoomScale),
            sel_rbx+(1<<zoomScale), sel_rby+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, sel_ltx-(RealSize(1, zoomScale)), sel_lty-(RealSize(1, zoomScale)),
            sel_rbx+(RealSize(1, zoomScale)), sel_rby+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
      SetFileModified (TRUE);
   }
}

void DetachGroupAttrs (ObjPtr, TopSelPtr, BotSelPtr)
   struct ObjRec	* ObjPtr;
   struct SelRec	* * TopSelPtr, * * BotSelPtr;
{
   struct AttrRec	* attr_ptr = ObjPtr->fattr;
   struct SelRec	* new_sel_ptr;
   int			len1, len2;
   char			* s, msg[80];

   for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
   {
      if (!(attr_ptr->nameshown))
      {
         s = attr_ptr->obj->detail.t->first->s;
         strcpy (s, attr_ptr->name);

         len1 = strlen (attr_ptr->name);
         len2 = strlen (attr_ptr->s);
         if (len1+len2 >= MAXSTRING)
         {
            sprintf (msg, "String length exceeds %1d.  String truncated.",
                  MAXSTRING);
            Msg (msg);
            attr_ptr->s[MAXSTRING-len1] = '\0';
         }

         strcat (s, attr_ptr->s);
         UpdTextBBox (attr_ptr->obj);
      }

      attr_ptr->obj->detail.t->attr = NULL;

      attr_ptr->obj->prev = NULL;
      attr_ptr->obj->next = ObjPtr->detail.r->first;

      if (attr_ptr->obj->next == NULL)
         ObjPtr->detail.r->last = attr_ptr->obj;
      else
          attr_ptr->obj->next->prev = attr_ptr->obj;
      ObjPtr->detail.r->first = attr_ptr->obj;

      new_sel_ptr = (struct SelRec *) calloc (1, sizeof(struct SelRec));
      new_sel_ptr->obj = attr_ptr->obj;

      new_sel_ptr->prev = NULL;
      new_sel_ptr->next = *TopSelPtr;

      if (new_sel_ptr->next == NULL)
         *BotSelPtr = new_sel_ptr;
      else
         (*TopSelPtr)->prev = new_sel_ptr;
      *TopSelPtr = new_sel_ptr;

      cfree (attr_ptr);
   }
}

void DetachAttrs ()
{
   struct SelRec	* sel_ptr, * new_sel_ptr;
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr, * attr_ptr_next;
   int			picture_changed, obj_changed;

   HighLightReverse ();
   picture_changed = ShowAndUpdAttrNames (FALSE);

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      attr_ptr = obj_ptr->fattr;
      if (attr_ptr != NULL)
      {
         topAttr = botAttr = NULL;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr_next)
         {
            attr_ptr_next = attr_ptr->next;
            if (obj_ptr->type == OBJ_ICON && attr_ptr->inherited)
            {
               LinkInAttr (NULL, topAttr, attr_ptr);
               continue;
            }

            if (!(attr_ptr->shown)) obj_changed = picture_changed = TRUE;
            attr_ptr->obj->detail.t->attr = NULL;
            AddObj (obj_ptr->prev, obj_ptr, attr_ptr->obj);
            new_sel_ptr = (struct SelRec *) calloc (1, sizeof(struct SelRec));
            new_sel_ptr->obj = obj_ptr->prev;
            AddSel (sel_ptr->prev, sel_ptr, new_sel_ptr);
            cfree (attr_ptr);
         }
         obj_ptr->fattr = topAttr;
         obj_ptr->lattr = botAttr;
         AdjObjBBox (obj_ptr);
      }
   }
   if (picture_changed)
   {
      UpdSelBBox ();
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      SetFileModified (TRUE);
   }
   HighLightForward ();
}

void UpdAttr (AttrPtr)
   struct AttrRec	* AttrPtr;
   /* Update the text object's string value associated with AttrPtr */
{
   int	len1, len2;
   char	msg[80];

   if (AttrPtr->nameshown)
   {
      strcpy (AttrPtr->obj->detail.t->first->s, AttrPtr->name);

      len1 = strlen (AttrPtr->name);
      len2 = strlen (AttrPtr->s);
      if (len1+len2 >= MAXSTRING)
      {
         sprintf (msg, "String length exceeds %1d.  String truncated.",
               MAXSTRING);
         Msg (msg);
         AttrPtr->s[MAXSTRING-len1] = '\0';
      }

      strcat (AttrPtr->obj->detail.t->first->s, AttrPtr->s);
   }
   else
      strcpy (AttrPtr->obj->detail.t->first->s, AttrPtr->s);
   UpdTextBBox(AttrPtr->obj);
}

static
int MoveOneAttr (ObjPtr, AttrPtr)
   struct ObjRec	* ObjPtr;
   struct AttrRec	* AttrPtr;
{
   struct ObjRec	* text_obj_ptr;
   int          	x, y, grid_x, grid_y, dx, dy, placing = TRUE;
   int          	ltx, lty, rbx, rby, changed = FALSE, moved = FALSE;
   int			orig_x, orig_y, grid_orig_x, grid_orig_y;
   XEvent		input;

   text_obj_ptr = AttrPtr->obj;
   Msg ("LEFT--show and move.  MIDDLE--toggle name shown.  RIGHT--hide attr.");

   orig_x = OFFSET_X(text_obj_ptr->x);
   orig_y = OFFSET_Y(text_obj_ptr->y);
   GridXY (orig_x, orig_y, &grid_orig_x, &grid_orig_y);
   ltx = OFFSET_X(text_obj_ptr->bbox.ltx);
   lty = OFFSET_Y(text_obj_ptr->bbox.lty);
   rbx = OFFSET_X(text_obj_ptr->bbox.rbx)+1;
   rby = OFFSET_Y(text_obj_ptr->bbox.rby)+1;
   SelBox (drawWindow, revDefaultGC, ltx, lty, rbx, rby);

   XGrabPointer (mainDisplay, drawWindow, FALSE,
         PointerMotionMask | ButtonPressMask,
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
   XWarpPointer (mainDisplay, None, drawWindow, 0, 0, 0, 0, orig_x, orig_y);

   dx = dy = 0;
   grid_x = grid_orig_x; grid_y = grid_orig_y;

   while (placing)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == MotionNotify)
      {
         x = input.xmotion.x;
         y = input.xmotion.y;
         GridXY (x, y, &grid_x, &grid_y);

         if (moved = (grid_x != grid_orig_x+dx || grid_y != grid_orig_y+dy))
         {
            SelBox (drawWindow, revDefaultGC, ltx+dx, lty+dy, rbx+dx, rby+dy);
            MarkRulers (grid_x, grid_y);
         }

         dx = grid_x - grid_orig_x;
         dy = grid_y - grid_orig_y;

         if (moved)
            SelBox (drawWindow, revDefaultGC, ltx+dx, lty+dy, rbx+dx, rby+dy);
      }
      else if (input.type == ButtonPress)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         placing = FALSE;
         SelBox (drawWindow, revDefaultGC, ltx+dx, lty+dy, rbx+dx, rby+dy);
         Msg ("");
         switch (input.xbutton.button)
         {
            case Button1:
               if (!(AttrPtr->shown))
               {
                  changed = TRUE;
                  AttrPtr->shown = TRUE;
               }
               if (dx != 0 || dy != 0)
               {
#ifndef UC
                  MoveObj (text_obj_ptr, dx<<zoomScale, dy<<zoomScale);
#else /* UC */
                  MoveObj (text_obj_ptr, RealSize(dx, zoomScale), RealSize(dy, zoomScale));
#endif /* UC */
                  AdjObjBBox (ObjPtr);
                  return (TRUE);
               }
               else
               {
                  if (changed) AdjObjBBox (ObjPtr);
                  return (changed);
               }
               break;
            case Button2:
               if (!(AttrPtr->nameshown) || *(AttrPtr->name) != '\0')
                  AttrPtr->nameshown = !AttrPtr->nameshown;
               UpdAttr (AttrPtr);
               if (AttrPtr->shown)
               {
                  AdjObjBBox (ObjPtr);
                  return (TRUE);
               }
               return (FALSE);
            case Button3:
               if (AttrPtr->shown)
               {
                  AttrPtr->shown = FALSE;
                  AdjObjBBox (ObjPtr);
                  return (TRUE);
               }
               return (FALSE);
         }
      }
   }
}

static
int ChangeAttrJust (ObjPtr, AttrPtr)
   struct ObjRec	* ObjPtr;
   struct AttrRec	* AttrPtr;
{
   struct ObjRec	* text_obj_ptr;
   int          	x, y, grid_x, grid_y, dx, dy, placing = TRUE;
   int          	ltx, lty, rbx, rby, moved = FALSE;
   int			orig_x, orig_y, grid_orig_x, grid_orig_y;
   int			old_just = 0, new_just = 0;
   XEvent		input;

   text_obj_ptr = AttrPtr->obj;
   Msg ("LEFT--left, MIDDLE--center, RIGHT--right justified.");

   orig_x = OFFSET_X(text_obj_ptr->x);
   orig_y = OFFSET_Y(text_obj_ptr->y);
   GridXY (orig_x, orig_y, &grid_orig_x, &grid_orig_y);
   ltx = OFFSET_X(text_obj_ptr->bbox.ltx);
   lty = OFFSET_Y(text_obj_ptr->bbox.lty);
   rbx = OFFSET_X(text_obj_ptr->bbox.rbx)+1;
   rby = OFFSET_Y(text_obj_ptr->bbox.rby)+1;
   SelBox (drawWindow, revDefaultGC, ltx, lty, rbx, rby);

   XGrabPointer (mainDisplay, drawWindow, FALSE,
         PointerMotionMask | ButtonPressMask,
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
   XWarpPointer (mainDisplay, None, drawWindow, 0, 0, 0, 0, orig_x, orig_y);

   dx = dy = 0;
   grid_x = grid_orig_x; grid_y = grid_orig_y;

   while (placing)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == MotionNotify)
      {
         x = input.xmotion.x;
         y = input.xmotion.y;
         GridXY (x, y, &grid_x, &grid_y);

         if (moved = (grid_x != grid_orig_x+dx || grid_y != grid_orig_y+dy))
         {
            SelBox (drawWindow, revDefaultGC, ltx+dx, lty+dy, rbx+dx, rby+dy);
            MarkRulers (grid_x, grid_y);
         }

         dx = grid_x - grid_orig_x;
         dy = grid_y - grid_orig_y;

         if (moved)
            SelBox (drawWindow, revDefaultGC, ltx+dx, lty+dy, rbx+dx, rby+dy);
      }
      else if (input.type == ButtonPress)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         placing = FALSE;
         SelBox (drawWindow, revDefaultGC, ltx+dx, lty+dy, rbx+dx, rby+dy);
         Msg ("");
         old_just = text_obj_ptr->detail.t->just;
         switch (input.xbutton.button)
         {
            case Button1: new_just = JUST_L; break;
            case Button2: new_just = JUST_C; break;
            case Button3: new_just = JUST_R; break;
         }
         if (old_just != new_just)
         {
            text_obj_ptr->detail.t->just = new_just;
            UpdTextBBox (text_obj_ptr);
            AdjObjBBox (ObjPtr);
            return (TRUE);
         }
         return (FALSE);
      }
   }
}

void MoveAttr ()
{
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr, * attr_ptr1;
   int			num_attrs = 0, i, index, x, y;
   int			picture_changed, sel_ltx, sel_lty, sel_rbx, sel_rby;
   int			* fore_colors, * pixel_ptr, * valid, * flag_ptr;
   int			len1, len2;
   char			* * attrStrs, * s, buf[MAXSTRING], msg[80];
   unsigned int		button;

   if (topSel != botSel || topSel == NULL)
   { Msg ("Please select only ONE object."); return; }

   obj_ptr = topSel->obj;
   attr_ptr1 = attr_ptr = obj_ptr->fattr;

   for ( ; attr_ptr1 != NULL; attr_ptr1 = attr_ptr1->next, num_attrs++) ;

   if (num_attrs == 0)
   { Msg ("Selected object currently has NO attributes."); return; }

   attrStrs = (char * *) calloc (num_attrs, sizeof(char *));
   fore_colors = pixel_ptr = (int *) calloc (num_attrs, sizeof(int));
   valid = flag_ptr = (int *) calloc (num_attrs, sizeof(int));

   attr_ptr1 = attr_ptr;
   for (i = 0; i < num_attrs; i++, attr_ptr1 = attr_ptr1->next)
   {
      s = (char *) calloc (MAXSTRING, sizeof(char));
      attrStrs[i] = s;
      strcpy (s, attr_ptr1->name);

      len1 = strlen (attr_ptr1->name);
      len2 = strlen (attr_ptr1->s);
      if (len1+len2 >= MAXSTRING)
      {
         sprintf (msg, "String length exceeds %1d.  String truncated.",
               MAXSTRING);
         Msg (msg);
         attr_ptr1->s[MAXSTRING-len1] = '\0';
      }

      strcat (s, attr_ptr1->s);
      *pixel_ptr++ = colorPixels[attr_ptr1->obj->color];
      *flag_ptr++ = TRUE;
   }

   Msg ("Hold down left button to see attributes.");
   strcpy (buf, "Left button move/see attributes.  ");
   strcat (buf, "Middle button change attribute justifications.");
   Msg (buf);
   button = CornerLoop (&x, &y);
#ifndef UC
   index = TextMenuLoop (x, y, attrStrs, num_attrs, fore_colors, valid, True);
#else /* UC */
   index = TextMenuLoop (x, y, attrStrs, num_attrs, fore_colors, valid, True, MENU_NOINDEX);
#endif /* UC */
   if (index != INVALID)
   {
      attr_ptr1 = attr_ptr;
      for (i = 0; i < index; i++, attr_ptr1 = attr_ptr1->next) ;
      sel_ltx = selLtX; sel_lty = selLtY; sel_rbx = selRbX; sel_rby = selRbY;
      if (button == Button1)
      {
         if (picture_changed = MoveOneAttr (obj_ptr, attr_ptr1))
         {
            HighLightReverse ();
            UpdSelBBox ();
#ifndef UC
            RedrawAreas (botObj, sel_ltx-(1<<zoomScale), sel_lty-(1<<zoomScale),
                  sel_rbx+(1<<zoomScale), sel_rby+(1<<zoomScale),
                  selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
                  selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
            RedrawAreas (botObj, sel_ltx-(RealSize(1, zoomScale)), sel_lty-(RealSize(1, zoomScale)),
                  sel_rbx+(RealSize(1, zoomScale)), sel_rby+(RealSize(1, zoomScale)),
                  selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
                  selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
            SetFileModified (TRUE);
            HighLightForward ();
         }
      }
      else if (button == Button2)
      {
         if (picture_changed = ChangeAttrJust (obj_ptr, attr_ptr1))
         {
            HighLightReverse ();
            UpdSelBBox ();
#ifndef UC
            RedrawAreas (botObj, sel_ltx-(1<<zoomScale), sel_lty-(1<<zoomScale),
                  sel_rbx+(1<<zoomScale), sel_rby+(1<<zoomScale),
                  selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
                  selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
            RedrawAreas (botObj, sel_ltx-(RealSize(1, zoomScale)), sel_lty-(RealSize(1, zoomScale)),
                  sel_rbx+(RealSize(1, zoomScale)), sel_rby+(RealSize(1, zoomScale)),
                  selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
                  selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
            SetFileModified (TRUE);
            HighLightForward ();
         }
      }
   }

   for (i = 0; i < num_attrs; i++) cfree (attrStrs[i]);
   cfree (attrStrs);
   justDupped = FALSE;
}

void CopyAndUpdateAttrs (ToObjPtr, FromObjPtr)
   struct ObjRec	* ToObjPtr, * FromObjPtr;
{
   register struct AttrRec	* to_attr_ptr, * from_attr_ptr;

   topAttr = botAttr = NULL;
   from_attr_ptr = FromObjPtr->fattr;
   for ( ; from_attr_ptr != NULL; from_attr_ptr = from_attr_ptr->next)
   {
      to_attr_ptr = ToObjPtr->fattr;
      for ( ; to_attr_ptr != NULL; to_attr_ptr = to_attr_ptr->next)
      {
         if (from_attr_ptr->obj->color == to_attr_ptr->obj->color &&
               strcmp (from_attr_ptr->name, to_attr_ptr->name) == 0)
         {
            if (*(from_attr_ptr->s) != '\0')
            {
               strcpy (to_attr_ptr->s, from_attr_ptr->s);
               UpdAttr (to_attr_ptr);
            }
            break;
         }
      }
      if (to_attr_ptr == NULL)
      {  /* new attribute */
         to_attr_ptr = (struct AttrRec *) calloc (1, sizeof(struct AttrRec));
         to_attr_ptr->owner = ToObjPtr;
         DupAnAttr (from_attr_ptr, to_attr_ptr);
         LinkInAttr (NULL, topAttr, to_attr_ptr);
      }
   }
   if (topAttr != NULL)
   {
      topAttr->prev = NULL;
      botAttr->next = ToObjPtr->fattr;

      if (ToObjPtr->fattr != NULL) ToObjPtr->fattr->prev = botAttr;
      ToObjPtr->fattr = topAttr;
      if (ToObjPtr->lattr == NULL) ToObjPtr->lattr = botAttr;
      AdjObjBBox (ToObjPtr);
   }
}
