/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/box.c,v 2.0 91/03/05 12:46:45 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "color.e"
#include "cursor.e"
#include "file.e"
#include "grid.e"
#include "obj.e"
#include "pattern.e"
#include "poly.e"
#include "raster.e"
#include "ruler.e"
#include "setup.e"
#ifdef UC
#include "showsize.e"
#endif /* UC */

int	boxDrawn = FALSE;

static XPoint bv[5];

void MyBox (window, gc, x1, y1, x2, y2)
   /* Hollow box, solid outline with width=1 */
   Window	window;
   GC		gc;
   int		x1, y1, x2, y2;
{
   bv[0].x = (short)x1; bv[0].y = (short)y1;
   bv[1].x = (short)x1; bv[1].y = (short)y2;
   bv[2].x = (short)x2; bv[2].y = (short)y2;
   bv[3].x = (short)x2; bv[3].y = (short)y1;
   bv[4].x = (short)x1; bv[4].y = (short)y1;
   XDrawLines (mainDisplay, window, gc, bv, 5, CoordModeOrigin);
}
 
void DumpBoxObj (FP, ObjPtr)
   FILE			* FP;
   struct ObjRec	* ObjPtr;
{
   register int	ltx, lty, rbx, rby, i;
   int		fill, width, pen, dash, color_index;

   ltx = ObjPtr->obbox.ltx;
   lty = ObjPtr->obbox.lty;
   rbx = ObjPtr->obbox.rbx;
   rby = ObjPtr->obbox.rby;

   fill = ObjPtr->detail.b->fill;
   pen = ObjPtr->detail.b->pen;
   width = ObjPtr->detail.b->width;
   dash = ObjPtr->detail.b->dash;

   if (fill == NONEPAT && pen == NONEPAT) return;

   color_index = ObjPtr->color;
   if (colorDump)
      fprintf (FP, "%.3f %.3f %.3f setrgbcolor\n",
            ((float)tgifColors[color_index].red/maxRGB),
            ((float)tgifColors[color_index].green/maxRGB),
            ((float)tgifColors[color_index].blue/maxRGB));

   switch (fill)
   {
      case NONEPAT: break;
      case SOLIDPAT:
         /* solid black object */
         fprintf (FP, "newpath\n   %1d %1d moveto\n", ltx, lty);
         fprintf (FP, "   %1d %1d lineto\n", rbx, lty);
         fprintf (FP, "   %1d %1d lineto\n", rbx, rby);
         fprintf (FP, "   %1d %1d lineto\n", ltx, rby);
         fprintf (FP, "closepath fill\n");
         break;
      case BACKPAT:
         /* solid white object */
         fprintf (FP, "newpath\n   %1d %1d moveto\n", ltx, lty);
         fprintf (FP, "   %1d %1d lineto\n", rbx, lty);
         fprintf (FP, "   %1d %1d lineto\n", rbx, rby);
         fprintf (FP, "   %1d %1d lineto\n", ltx, rby);
         fprintf (FP, "closepath 1 setgray fill\n");
         if (colorDump)
            fprintf (FP, "%.3f %.3f %.3f setrgbcolor\n",
                  ((float)tgifColors[color_index].red/maxRGB),
                  ((float)tgifColors[color_index].green/maxRGB),
                  ((float)tgifColors[color_index].blue/maxRGB));
         else
            fprintf (FP, "0 setgray\n");
         break;
      default:
         /* patterned */
         fprintf (FP, "gsave\n");
         if (!colorDump)
            fprintf (FP, "   pat%1d 8 1 0 72 300 32 div div setpattern\n",
                  fill);
         fprintf (FP, "   newpath\n      %1d %1d moveto\n", ltx, lty);
         fprintf (FP, "      %1d %1d lineto\n", rbx, lty);
         fprintf (FP, "      %1d %1d lineto\n", rbx, rby);
         fprintf (FP, "      %1d %1d lineto\n", ltx, rby);
         if (colorDump)
         {
            fprintf (FP, "   closepath eoclip\n");
            DumpPatFill (FP, fill, 8, ObjPtr->bbox, "   ");
         }
         else
            fprintf (FP, "   closepath fill\n");
         fprintf (FP, "grestore\n");
         break;
   }

   fprintf (FP, "%1d setlinewidth\n", widthOfLine[width]);
   if (dash != 0)
   {
      fprintf (FP, "[");
      for (i = 0; i < dashListLength[dash]-1; i++)
         fprintf (FP, "%1d ", (int)(dashList[dash][i]));
      fprintf (FP, "%1d] 0 setdash\n",
            (int)(dashList[dash][dashListLength[dash]-1]));
   }

   switch (pen)
   {
      case NONEPAT: break;
      case SOLIDPAT:
         /* solid black object */
         fprintf (FP, "newpath\n   %1d %1d moveto\n", ltx, lty);
         fprintf (FP, "   %1d %1d lineto\n", rbx, lty);
         fprintf (FP, "   %1d %1d lineto\n", rbx, rby);
         fprintf (FP, "   %1d %1d lineto\n", ltx, rby);
         fprintf (FP, "closepath stroke\n");
         break;
      case BACKPAT:
         /* solid white object */
         fprintf (FP, "newpath\n   %1d %1d moveto\n", ltx, lty);
         fprintf (FP, "   %1d %1d lineto\n", rbx, lty);
         fprintf (FP, "   %1d %1d lineto\n", rbx, rby);
         fprintf (FP, "   %1d %1d lineto\n", ltx, rby);
         fprintf (FP, "closepath 1 setgray stroke 0 setgray\n");
         break;
      default:
         /* patterned */
         fprintf (FP, "gsave\n");
         if (!colorDump)
            fprintf (FP, "   pat%1d 8 1 0 72 300 32 div div setpattern\n", pen);
         fprintf (FP, "   newpath\n      %1d %1d moveto\n", ltx, lty);
         fprintf (FP, "      %1d %1d lineto\n", rbx, lty);
         fprintf (FP, "      %1d %1d lineto\n", rbx, rby);
         fprintf (FP, "      %1d %1d lineto\n", ltx, rby);
         if (colorDump)
         {
            fprintf (FP, "   closepath strokepath clip\n");
            DumpPatFill (FP, pen, 8, ObjPtr->bbox, "   ");
         }
         else
            fprintf (FP, "   closepath stroke\n");
         fprintf (FP, "grestore\n");
         break;
   }
   if (dash != 0) fprintf (FP, "[] 0 setdash\n");
   fprintf (FP, "1 setlinewidth\n\n");
}

void DrawBoxObj (win, XOff, YOff, ObjPtr)
   Window		win;
   struct ObjRec	* ObjPtr;
{
   struct BoxRec	* box_ptr = ObjPtr->detail.b;
   int			fill, pen, pixel, func, ltx, lty, rbx, rby, width, dash;
   int			real_x_off, real_y_off;
   XGCValues		values;

   pen = box_ptr->pen;
   fill = box_ptr->fill;
   width = box_ptr->width;
   dash = box_ptr->dash;
   pixel = colorPixels[ObjPtr->color];

   if (fill == 0 && pen == 0) return;

#ifndef UC
   real_x_off = (XOff >> zoomScale) << zoomScale;
   real_y_off = (YOff >> zoomScale) << zoomScale;
   ltx = (ObjPtr->obbox.ltx - real_x_off) >> zoomScale;
   lty = (ObjPtr->obbox.lty - real_y_off) >> zoomScale;
   rbx = (ObjPtr->obbox.rbx - real_x_off) >> zoomScale;
   rby = (ObjPtr->obbox.rby - real_y_off) >> zoomScale;
#else /* UC */
   real_x_off = RealSize((ScreenSize(XOff, zoomScale)), zoomScale);
   real_y_off = RealSize((ScreenSize(YOff, zoomScale)), zoomScale);
   ltx = ScreenSize((ObjPtr->obbox.ltx - real_x_off), zoomScale);
   lty = ScreenSize((ObjPtr->obbox.lty - real_y_off), zoomScale);
   rbx = ScreenSize((ObjPtr->obbox.rbx - real_x_off), zoomScale);
   rby = ScreenSize((ObjPtr->obbox.rby - real_y_off), zoomScale);
#endif /* UC */
   func = GXcopy;

   if (fill != 0)
   {
      values.foreground = (fill == 2) ? myBgPixel : pixel;
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[fill];
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple, &values);
      XFillRectangle (mainDisplay, win, drawGC, ltx, lty, rbx-ltx, rby-lty);
   }

   if (pen != 0)
   {
      values.foreground = (pen == 2) ? myBgPixel : pixel;
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[pen];
#ifndef UC
      values.line_width = widthOfLine[width] >> zoomScale;
#else /* UC */
      values.line_width = ScreenSize(widthOfLine[width], zoomScale);
#endif /* UC */
      if (dash != 0)
      {
         XSetDashes (mainDisplay, drawGC, 0, dashList[dash],
               dashListLength[dash]);
         values.line_style = LineOnOffDash;
      }
      else
         values.line_style = LineSolid;
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple | GCLineWidth |
            GCLineStyle, &values);
      XDrawRectangle (mainDisplay, win, drawGC, ltx, lty, rbx-ltx, rby-lty);
   }
}

static
void CreateBoxObj (X1, Y1, X2, Y2)
   int	X1, Y1, X2, Y2;
{
   struct BoxRec	* box_ptr;
   struct ObjRec	* obj_ptr;
   int			w, ltx, lty, rbx, rby;

   box_ptr = (struct BoxRec *) calloc (1, sizeof(struct BoxRec));
   box_ptr->fill = objFill;
   box_ptr->width = lineWidth;
   box_ptr->pen = penPat;
   box_ptr->dash = curDash;

   obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));

   if (X1 < X2)
      if (Y1 < Y2)
      {
         ltx = X1; lty = Y1; rbx = X2; rby = Y2;
      }
      else
      {
         ltx = X1; lty = Y2; rbx = X2; rby = Y1;
      }
   else
      if (Y1 < Y2)
      {
         ltx = X2; lty = Y1; rbx = X1; rby = Y2;
      }
      else
      {
         ltx = X2; lty = Y2; rbx = X1; rby = Y1;
      }

#ifndef UC
   obj_ptr->bbox.ltx = obj_ptr->obbox.ltx = obj_ptr->x = (ltx << zoomScale) +
         drawOrigX;
   obj_ptr->bbox.lty = obj_ptr->obbox.lty = obj_ptr->y = (lty << zoomScale) +
         drawOrigY;
   obj_ptr->bbox.rbx = obj_ptr->obbox.rbx = (rbx << zoomScale) + drawOrigX;
   obj_ptr->bbox.rby = obj_ptr->obbox.rby = (rby << zoomScale) + drawOrigY;
#else /* UC */
   obj_ptr->bbox.ltx = obj_ptr->obbox.ltx = obj_ptr->x = (RealSize(ltx ,  zoomScale)) +
         drawOrigX;
   obj_ptr->bbox.lty = obj_ptr->obbox.lty = obj_ptr->y = (RealSize(lty ,  zoomScale)) +
         drawOrigY;
   obj_ptr->bbox.rbx = obj_ptr->obbox.rbx = (RealSize(rbx ,  zoomScale)) + drawOrigX;
   obj_ptr->bbox.rby = obj_ptr->obbox.rby = (RealSize(rby ,  zoomScale)) + drawOrigY;
#endif /* UC */
   w = widthOfLine[lineWidth];
   obj_ptr->bbox.ltx -= w;
   obj_ptr->bbox.lty -= w;
   obj_ptr->bbox.rbx += w;
   obj_ptr->bbox.rby += w;
   obj_ptr->type = OBJ_BOX;
   obj_ptr->color = colorIndex;
   obj_ptr->id = objId++;
   obj_ptr->dirty = FALSE;
   obj_ptr->detail.b = box_ptr;
   obj_ptr->fattr = obj_ptr->lattr = NULL;
   AddObj (NULL, topObj, obj_ptr);
}
 
static
void ContinueBox (OrigX, OrigY)
   int 	OrigX, OrigY;
{
   int 		end_x, end_y, grid_x, grid_y, saved_x, saved_y;
   int 		done = FALSE;
   int		pixel, xor_pixel;
   XGCValues	values;
   XEvent	input;
   XMotionEvent	* motion_ev;
#ifdef UC
   register int	showsize = showSize;
   register int	hidedragcursor = hideDragCursor;
   register int cursordefined = FALSE;
#endif /* UC */

   pixel = colorPixels[colorIndex];
   xor_pixel = xorColorPixels[colorIndex];

   values.foreground = xor_pixel;
   values.function = GXxor;
   values.fill_style = FillSolid;
   values.line_width = 0;
   values.line_style = LineSolid;

   XChangeGC (mainDisplay, drawGC,
         GCForeground | GCFunction | GCFillStyle | GCLineWidth | GCLineStyle,
         &values);

   saved_x = grid_x = OrigX;
   saved_y = grid_y = OrigY; 
   XGrabPointer (mainDisplay, drawWindow, FALSE,
         PointerMotionMask | ButtonReleaseMask,
#ifndef UC
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
#else /* UC */
         GrabModeAsync, GrabModeAsync, None, ((hidedragcursor)? None:handCursor), CurrentTime);

#endif /* UC */
#ifdef UC
   if (showsize) showPoint (OrigX, OrigY, RIGHTUP);
#endif /* UC */
   
   while (!done)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonRelease)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         MyBox (drawWindow, drawGC, OrigX, OrigY, saved_x, saved_y);
#ifdef UC
	 if (showsize) eraseSizeString ();
	 if (hidedragcursor && cursordefined)
	 {
	     XDefineCursor (mainDisplay, drawWindow, drawCursor);
	     cursordefined = FALSE;
	     XFlush (mainDisplay);
	 }
#endif /* UC */
         done = TRUE;
      }
      else if (input.type == MotionNotify)
      {
         motion_ev = &(input.xmotion);
         end_x = motion_ev->x;
         end_y = motion_ev->y;
         GridXY (end_x, end_y, &grid_x, &grid_y);
#ifdef UC
	 if (hidedragcursor && !cursordefined && 
		(grid_x != OrigX && grid_y != OrigY))
	 {
	     XDefineCursor (mainDisplay, drawWindow, dragCursor);
	     cursordefined = TRUE;
	 }
#endif /* UC */
         if (grid_x != saved_x || grid_y != saved_y)
         {
            MyBox (drawWindow, drawGC, OrigX, OrigY, saved_x, saved_y);
#ifdef UC
	    if (showsize) eraseSizeString ();
#endif /* UC */
            saved_x = grid_x;
            saved_y = grid_y;
            MyBox (drawWindow, drawGC, OrigX, OrigY, saved_x, saved_y);
#ifdef UC
	    if (showsize) showHeightWidth (OrigX, OrigY, saved_x, saved_y, RIGHTDOWN);
#endif /* UC */
         }
         MarkRulers (grid_x, grid_y);
      }
   }
   if (OrigX != grid_x && OrigY != grid_y)
   {
      CreateBoxObj (OrigX, OrigY, grid_x, grid_y);
      DrawBoxObj (drawWindow, drawOrigX, drawOrigY, topObj);
      boxDrawn = TRUE;
      SetFileModified (TRUE);
   }
}

void DrawBox (input)
   XEvent	* input;
{
   XButtonEvent	* button_ev;
   int		mouse_x, mouse_y, grid_x, grid_y;

   if (input->type != ButtonPress) return;

   button_ev = &(input->xbutton);
   if (button_ev->button == Button1)
   {
      mouse_x = button_ev->x;
      mouse_y = button_ev->y;
      GridXY (mouse_x, mouse_y, &grid_x, &grid_y);
      ContinueBox (grid_x, grid_y);
   }
}

void SaveBoxObj (FP, ObjPtr)
   FILE			* FP;
   struct ObjRec	* ObjPtr;
{
   fprintf (FP, "box('%s',", colorMenuItems[ObjPtr->color]);
   fprintf (FP, "%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,", ObjPtr->obbox.ltx,
         ObjPtr->obbox.lty, ObjPtr->obbox.rbx, ObjPtr->obbox.rby,
         ObjPtr->detail.b->fill, ObjPtr->detail.b->width,
         ObjPtr->detail.b->pen, ObjPtr->id, ObjPtr->detail.b->dash);
   SaveAttrs (FP, ObjPtr->lattr);
   fprintf (FP, ")");
}

void ReadBoxObj (Inbuf, ObjPtr)
   char			* Inbuf;
   struct ObjRec	* * ObjPtr;
{
   struct BoxRec	* box_ptr;
   char			color_str[20], * s;
   int			ltx, lty, rbx, rby, fill, width, pen, dash, w;

   *ObjPtr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   s = FindChar ('(', Inbuf);
   s = ParseStr (s, ',', color_str);
   box_ptr = (struct BoxRec *) calloc (1, sizeof(struct BoxRec));

   if (fileVersion <= 5)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d",
            &ltx, &lty, &rbx, &rby, &fill, &width, &pen);
      switch (width)
      {
         case 1: width = 3; break;
         case 2: width = 6; break;
      }
      (*ObjPtr)->id = objId++;
      dash = 0;
   }
   else if (fileVersion <= 7)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d",
            &ltx, &lty, &rbx, &rby, &fill, &width, &pen);
      (*ObjPtr)->id = objId++;
      dash = 0;
   }
   else if (fileVersion <= 8)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d , %d",
            &ltx, &lty, &rbx, &rby, &fill, &width, &pen, &((*ObjPtr)->id));
      if ((*ObjPtr)->id >= objId) objId = (*ObjPtr)->id + 1;
      dash = 0;
   }
   else
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d , %d , %d",
            &ltx, &lty, &rbx, &rby, &fill, &width, &pen, &((*ObjPtr)->id),
            &dash);
      if ((*ObjPtr)->id >= objId) objId = (*ObjPtr)->id + 1;
   }

   box_ptr->fill = fill;
   box_ptr->width = width;
   box_ptr->pen = pen;
   box_ptr->dash = dash;
   (*ObjPtr)->x = ltx;
   (*ObjPtr)->y = lty;
   (*ObjPtr)->color = FindColorIndex (color_str);
   (*ObjPtr)->dirty = FALSE;
   (*ObjPtr)->type = OBJ_BOX;
   (*ObjPtr)->obbox.ltx = ltx;
   (*ObjPtr)->obbox.lty = lty;
   (*ObjPtr)->obbox.rbx = rbx;
   (*ObjPtr)->obbox.rby = rby;
   w = widthOfLine[width];
   (*ObjPtr)->bbox.ltx = ltx - w;
   (*ObjPtr)->bbox.lty = lty - w;
   (*ObjPtr)->bbox.rbx = rbx + w;
   (*ObjPtr)->bbox.rby = rby + w;
   (*ObjPtr)->detail.b = box_ptr;
}

void FreeBoxObj (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   cfree (ObjPtr->detail.b);
   cfree (ObjPtr);
}
