/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/button.c,v 2.0 91/03/05 12:46:48 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "box.e"
#include "cursor.e"
#include "font.e"
#include "mainloop.e"
#include "raster.e"
#include "rect.e"
#include "setup.e"

int ButtonWidth(Str, Len)
   char	* Str;
{
   return (defaultFontWidth * max(strlen (Str) + 2, Len));
}

void DisplayButton (Win, Str, Len, BBox, Normal)
   Window	Win;
   char		* Str;
   struct BBRec	* BBox;
   short	Normal;
   int		Len;
   /* display a button in Win at location ((*BBox).ltx,(*BBox).lty), Str is */
   /*    centered in the button.  The width of the button is the width of */
   /*    Str + 2 character widths or the width of Len number of characters, */
   /*    whichever is bigger.  *BBox will be set with the bounding */
   /*    box of the button. */
{
   int	button_w, button_h, len_of_str, left;

   len_of_str = strlen (Str);
   button_w = defaultFontWidth * max(len_of_str+2,Len);
   left = (button_w - defaultFontWidth * len_of_str) / 2;
   button_h = defaultFontHeight + 4;
   (*BBox).rbx = (*BBox).ltx + button_w - 1;
   (*BBox).rby = (*BBox).lty + button_h - 1;

   if (Normal)
   {
      XDrawRectangle (mainDisplay, Win, defaultGC, (*BBox).ltx, (*BBox).lty,
            button_w, button_h);
      XDrawString (mainDisplay, Win, defaultGC, (*BBox).ltx+left,
            (*BBox).lty+defaultFontAsc+2, Str, len_of_str);
   }
   else
   {
      XFillRectangle (mainDisplay, Win, revDefaultGC, (*BBox).ltx, (*BBox).lty,
            button_w, button_h);
   }
}

static char * confirmStr[] = { "YES", "NO", "CANCEL" };

#ifdef UC
#define MAXMSGLINES 3
#define MAXMSGCHAR 60
#endif /* UC */
int YesNoCancel (Str)
   char		* Str;
   /* Create a window with Str centered.  This window also has 3 buttons */
   /*    in it, labeled YES, NO, and CANCEL.  The window has an origin at */
   /*    (100,100) relative to the origin of RootWindow. */
{
   int		w, h, str_start, button_start, top;
   int		str_width, button_widths, dsp_w, dsp_h;
   Window	confirm_win;
   struct BBRec	button_bbox[MAX_CONFIRMS];
   XEvent	input;
   XButtonEvent	* button_ev;
   XKeyEvent	* key_ev;
   int		i, confirming = TRUE, choice = CONFIRM_YES;
   int		win_x, win_y;
   char		buf[80];
   KeySym	key_sym;
   XComposeStatus	c_stat;
   XSetWindowAttributes	win_attrs;
#ifdef UC
   int	msgLines = 0, c, done;
   int  msgLen = strlen (Str);
   char subMsg[MAXMSGLINES][MAXMSGCHAR + 1];
   register char * msg = Str, * s;

   if (msgLen >= MAXMSGCHAR)
   {
       msgLen = MAXMSGCHAR;
       done = 1;
       for (c = 0; c < MAXMSGLINES || done; c++)
       {
	   msgLines++;
	   s = &subMsg [c][0];
	   for(i = 0; i < MAXMSGCHAR; i++)
	   {
	       if (*msg != '\n' && *msg != '\0')
		   *s++ = *msg++;
	       else if (*msg == '\0')
	       {
		   done = 0; break;
	       }
	       else
	       {

		   msg++; break;
	       }
	   }
	   *s = '\0';
       }
   }
   else
       msgLines = 1;
#endif /* UC */

   top = defaultFontAsc+2;

   button_widths = ButtonWidth("YES", 8) + ButtonWidth("NO", 8) +
         ButtonWidth("CANCEL", 8) + 2 * defaultFontWidth;
#ifndef UC
   str_width = defaultFontWidth * strlen (Str);
#else /* UC */
   str_width = defaultFontWidth * msgLen;
#endif /* UC */

   if (str_width > button_widths)
   {
      w = str_width + 4 * defaultFontWidth;
      str_start = 2 * defaultFontWidth;
      button_start = (w - button_widths) / 2;
   }
   else
   {
      w = button_widths + 4 * defaultFontWidth;
      str_start = (w - str_width) / 2;
      button_start = 2 * defaultFontWidth;
   }

#ifndef UC
   h = 5 * defaultFontHeight;
#else /* UC */
   h = (4 + msgLines) * defaultFontHeight;
#endif /* UC */

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   win_x = (w > dsp_w) ? 0 : (dsp_w - w)/2;
   win_y = (h > dsp_h) ? 0 : (dsp_h - h)/3;

   if ((confirm_win = XCreateSimpleWindow (mainDisplay, rootWindow,
         win_x, win_y, w, h, brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create yes-no-okay window!\n"); /* fool safe */ EmergencySave (); }

   win_attrs.save_under = True;
   XChangeWindowAttributes (mainDisplay, confirm_win, CWSaveUnder, &win_attrs);

   XSetTransientForHint (mainDisplay, confirm_win, mainWindow);
   XMapWindow (mainDisplay, confirm_win);
   XSelectInput (mainDisplay, confirm_win,
         KeyPressMask | ButtonPressMask | ExposureMask);

   while (confirming)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == Expose)
      {
         XDrawRectangle (mainDisplay, confirm_win, defaultGC, 0, 0, w-1, h-1);
#ifndef UC
         XDrawString (mainDisplay, confirm_win, defaultGC, str_start,
               defaultFontHeight+top, Str, strlen(Str));

         button_bbox[0].lty = button_bbox[1].lty = button_bbox[2].lty =
               3 * defaultFontHeight;
#else /* UC */
	 if (msgLines > 1)
	     for (i = 0; i < msgLines ; i++)
		 XDrawString (mainDisplay, confirm_win, defaultGC, str_start,
			 (defaultFontHeight * (i+1))+top, &subMsg[i][0], strlen(&subMsg[i][0]));
	 else
	     XDrawString (mainDisplay, confirm_win, defaultGC, str_start,
			  defaultFontHeight+top, Str, strlen(Str));

         button_bbox[0].lty = button_bbox[1].lty = button_bbox[2].lty =
               (2 + msgLines) * defaultFontHeight;
#endif /* UC */
         button_bbox[CONFIRM_YES].ltx = button_start;
         DisplayButton (confirm_win, "YES", 8, &button_bbox[CONFIRM_YES],
               BUTTON_NORMAL);
         button_bbox[CONFIRM_NO].ltx =
               button_bbox[CONFIRM_YES].rbx + 1 + defaultFontWidth;
         DisplayButton (confirm_win, "NO", 8, &button_bbox[CONFIRM_NO],
               BUTTON_NORMAL);
         button_bbox[CONFIRM_CANCEL].ltx =
               button_bbox[CONFIRM_NO].rbx + 1 + defaultFontWidth;
         DisplayButton (confirm_win, "CANCEL", 8, &button_bbox[CONFIRM_CANCEL],
               BUTTON_NORMAL);

         continue;
      }
      else if (input.type == KeyPress)
      {
         key_ev = &(input.xkey);
         XLookupString (key_ev, buf, 80, &key_sym, &c_stat);

         if (buf[0] == 'c' || buf[0] == 'C' || buf[0] == '\033')
         {
            confirming = FALSE;
            choice = CONFIRM_CANCEL;
         }
         else if (buf[0]=='y' || buf[0]=='Y' || buf[0]=='\r' || buf[0]=='\n')
         {
            confirming = FALSE;
            choice = CONFIRM_YES;
         }
         else if (buf[0] == 'n' || buf[0] == 'N')
         {
            confirming = FALSE;
            choice = CONFIRM_NO;
         }
      }
      else if (input.type == ButtonPress)
      {
         button_ev = &(input.xbutton);
         for (i = 0; i < MAX_CONFIRMS; i++)
            if (PointInBBox (button_ev->x, button_ev->y, button_bbox[i]))
            {
               confirming = FALSE;
               choice = i;
            }
      }
   }

   DisplayButton (confirm_win, confirmStr[choice], 8, &button_bbox[choice],
         BUTTON_INVERT);

   XDestroyWindow (mainDisplay, confirm_win);
#ifndef UC
   XSync (mainDisplay, FALSE);
#else /* UC */
   XFlush (mainDisplay);
#endif /* UC */
   while (XCheckMaskEvent (mainDisplay, ExposureMask, &input)) ;
   return (choice);
}
#ifdef UC

#define QuitStr	"QUIT"
static int 		YesWithPolling = FALSE;
static Window 		yesWithPollWin;
static char 		prevMessage[MAXSTRING];
static int 		yesWithPollWin_w, yesWithPollWin_h;
static struct BBRec 	yWPbutton_bbox;

int YesWithPoll(Message)
char * Message;
{
    int		count = 0, len = strlen(Message);
    XEvent 	input;
    int 	str_x = 2 * defaultFontWidth;
    int 	str_y = defaultFontHeight + defaultFontAsc + 2;
    XSetWindowAttributes	win_attrs;
    
    if (len == 0)
    {
	/* for quting polling */
	if (YesWithPolling)
	    goto destroy;
	else
	    return (TRUE);
    }
    
    if (!YesWithPolling)
    {
	yesWithPollWin_w = defaultFontWidth * (len + 4);
	yesWithPollWin_h = 5 * defaultFontHeight;
	YesWithPolling = TRUE;
	strcpy (prevMessage, Message);
	
	if ((yesWithPollWin = XCreateSimpleWindow (mainDisplay, rootWindow,
	      DisplayWidth (mainDisplay, mainScreen)/3,
	      DisplayHeight (mainDisplay, mainScreen)/4,
	      yesWithPollWin_w, yesWithPollWin_h, brdrW,
	      myBorderPixel, myBgPixel))==0)
	{
	    printf ("Could not create YesWithPolling window!\n");
	    EmergencySave();
	}
	      
	XSelectInput (mainDisplay, yesWithPollWin, ButtonPressMask | ExposureMask);
	win_attrs.save_under = True;
	win_attrs.override_redirect = True;
	XChangeWindowAttributes (mainDisplay, yesWithPollWin,
				 CWSaveUnder | CWOverrideRedirect,  &win_attrs);

	XSetTransientForHint (mainDisplay, yesWithPollWin, mainWindow);
	XMapRaised (mainDisplay, yesWithPollWin);
	XWindowEvent (mainDisplay, yesWithPollWin, ExposureMask, &input);
	goto ExposeEvent;
    }
    if (count = XEventsQueued (mainDisplay, QueuedAfterReading))
    {
	while (count)
	{
	    count--;
	    XNextEvent (mainDisplay, &input);

	    if (input.xany.window == yesWithPollWin)
	    {
		if (input.type == Expose)
		{
		ExposeEvent:
		    XDrawRectangle (mainDisplay, yesWithPollWin, revDefaultGC2,
			    0, 0, yesWithPollWin_w-1, yesWithPollWin_h-1);
		    XDrawString(mainDisplay, yesWithPollWin, revDefaultGC2, 
			  str_x, str_y, prevMessage, strlen(prevMessage));
		    yWPbutton_bbox.lty = 3 * defaultFontHeight;
		    yWPbutton_bbox.ltx = (yesWithPollWin_w - ButtonWidth(QuitStr))/2;
		    DisplayButton (yesWithPollWin, QuitStr, 8,
				   &yWPbutton_bbox, BUTTON_NORMAL);
		}
		else if (input.type == ButtonPress)
		{
		    DisplayButton(yesWithPollWin,QuitStr,8,
				  &yWPbutton_bbox,BUTTON_INVERT);
		destroy:
		    XDestroyWindow (mainDisplay, yesWithPollWin);
		    XSync (mainDisplay, FALSE);
		    while (XCheckMaskEvent (mainDisplay, ExposureMask, &input));
		    YesWithPolling = FALSE;
		    return (TRUE);
		}
	    }
	}
    }
    XDrawString (mainDisplay, yesWithPollWin, revDefaultGC2, str_x, str_y, 
		 prevMessage, strlen (prevMessage));
    strcpy (prevMessage, Message);
    XDrawString (mainDisplay, yesWithPollWin, revDefaultGC2, str_x, str_y, Message, len);
    XFlush (mainDisplay);
    sleep (2);
    return (FALSE);
}
#endif /* UC */
