/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/choice.c,v 2.0 91/03/05 12:46:49 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "align.e"
#include "arc.e"
#include "box.e"
#include "color.e"
#include "cursor.e"
#include "font.e"
#include "grid.e"
#include "mark.e"
#include "msg.e"
#include "oval.e"
#include "pattern.e"
#include "poly.e"
#include "polygon.e"
#include "raster.e"
#include "rcbox.e"
#include "select.e"
#include "setup.e"
#include "text.e"
#ifdef KINPUT
#include "kconvert.e"
#endif /* KINPUT */
#ifdef KANJI
#include "file.e"
#endif /* KANJI */

int	curChoice = NOTHING;

static GC	choiceGC;
static Pixmap	choiceBackingPixmap;

void InitChoice ()
{
   XGCValues	values;

   values.foreground = 1;
   values.background = 0;
   values.font = defaultFontPtr->fid;
   choiceGC = XCreateGC (mainDisplay, choiceWindow,
         GCForeground | GCBackground | GCFont, &values);

   choiceBackingPixmap = XCreatePixmap (mainDisplay, choiceWindow,
         choiceWindowW, choiceWindowH, mainDepth);
}

void CleanUpChoices ()
{
   XFreeGC (mainDisplay, choiceGC);
   XFreePixmap (mainDisplay, choiceBackingPixmap);
}

void ShowMode ()
{
   XSetStipple (mainDisplay, rasterGC, choicePixmap[curChoice]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 0, 0, choiceImageW,
         choiceImageH);
}

void ShowWhereToPrint ()
{
   if (colorDump)
      XSetForeground (mainDisplay, rasterGC, colorPixels[colorIndex]);
   XSetStipple (mainDisplay, rasterGC, whereToPrintPixmap[whereToPrint]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 6*choiceImageW, 0,
         choiceImageW, choiceImageH);
   if (colorDump) XSetForeground (mainDisplay, rasterGC, myFgPixel);
}

void ShowColor (PropagateWhereToPrint)
   int	PropagateWhereToPrint;
{
   XGCValues	values;

   if (colorDisplay)
   {
      values.foreground = colorPixels[colorIndex];
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[1];
      XChangeGC (mainDisplay, patGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple, &values);

      XFillRectangle (mainDisplay, choiceWindow, patGC,
            0, choiceImageH, choiceImageW, choiceImageH);
   }
   if (PropagateWhereToPrint) ShowWhereToPrint ();
}

void ShowHoriAlign ()
{
   XSetStipple (mainDisplay, rasterGC, alignHoriPixmap[horiAlign]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, choiceImageW, 0,
         choiceImageW, choiceImageH);
}

void ShowVertAlign ()
{
   XSetStipple (mainDisplay, rasterGC, alignVertPixmap[vertAlign]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, choiceImageW,
         choiceImageH, choiceImageW, choiceImageH);
}

void ShowJust ()
{
   XSetStipple (mainDisplay, rasterGC, justPixmap[textJust]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 2*choiceImageW, 0,
         choiceImageW, choiceImageH);
}

void ShowCurFont ()
{
   int		x, y, w, h;
   XRectangle	recs[1];
   XGCValues	values;

   recs[0].x = 2*choiceImageW;
   recs[0].y = choiceImageH;
   recs[0].width = choiceImageW;
   recs[0].height = choiceImageH;

   w = XTextWidth (canvasFontPtr, "W", 1);
   h = canvasFontHeight;

   x = (w > choiceImageW) ?
         2*choiceImageW - (w-choiceImageW)/2 :
         2*choiceImageW + (choiceImageW-w)/2;
   y = (h > choiceImageH) ?
         choiceImageH + (canvasFontAsc-(h-choiceImageH)/2) :
         choiceImageH + (canvasFontAsc+(choiceImageH-h)/2);

   XClearArea (mainDisplay, choiceWindow, 2*choiceImageW, choiceImageH,
         choiceImageW, choiceImageH, FALSE);

   XSetFont (mainDisplay, choiceGC, canvasFontPtr->fid);
   XSetClipRectangles (mainDisplay, choiceGC, 0, 0, recs, 1, YXBanded);

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   XChangeGC (mainDisplay, choiceGC, GCForeground | GCBackground, &values);

   XDrawString (mainDisplay, choiceWindow, choiceGC, x, y, "W", 1);

   values.foreground = 1;
   values.background = 0;
   XChangeGC (mainDisplay, choiceGC, GCForeground | GCBackground, &values);

   recs[0].x = 0;
   recs[0].y = 0;
   recs[0].width = choiceWindowW;
   recs[0].height = choiceWindowH;
   XSetClipRectangles (mainDisplay, choiceGC, 0, 0, recs, 1, YXBanded);
}

void ShowRotate ()
{
   XSetStipple (mainDisplay, rasterGC, rotatePixmap[curRotate]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 3*choiceImageW, 0,
         choiceImageW, choiceImageH);
}

void ShowSpecial ()
{
   XSetStipple (mainDisplay, rasterGC, specialPixmap);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 3*choiceImageW,
         choiceImageH, choiceImageW, choiceImageH);
}

void ShowLineWidth ()
{
   XSetStipple (mainDisplay, rasterGC, shortLineWidthPixmap[lineWidth]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 4*choiceImageW, 0,
         choiceImageW, choiceImageH);
}

void ShowLineStyle ()
{
   XSetStipple (mainDisplay, rasterGC, shortLineStylePixmap[lineStyle]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 4*choiceImageW,
         choiceImageH, choiceImageW, choiceImageH);
}

void ShowLineType ()
{
   XSetStipple (mainDisplay, rasterGC, shortLineTypePixmap[curSpline]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 5*choiceImageW, 0,
         choiceImageW, choiceImageH);
}

void ShowDash ()
{
   XSetStipple (mainDisplay, rasterGC, shortDashPixmap[curDash]);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 5*choiceImageW,
         choiceImageH, choiceImageW, choiceImageH);
}

void ShowFile ()
{
   XSetStipple (mainDisplay, rasterGC, filePixmap);
   XFillRectangle (mainDisplay, choiceWindow, rasterGC, 6*choiceImageW,
         choiceImageH, choiceImageW, choiceImageH);
}

void ShowFill ()
{
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.function = GXcopy;
   values.fill_style = FillOpaqueStippled;
   values.stipple = patPixmap[objFill];
   XChangeGC (mainDisplay, patGC,
         GCForeground | GCBackground | GCFunction | GCFillStyle | GCStipple,
         &values);

   XFillRectangle (mainDisplay, choiceWindow, patGC,
         7*choiceImageW, 0, choiceImageW, choiceImageH);
}

void ShowPen ()
{
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.function = GXcopy;
   values.fill_style = FillOpaqueStippled;
   values.stipple = patPixmap[penPat];
   XChangeGC (mainDisplay, patGC,
         GCForeground | GCBackground | GCFunction | GCFillStyle | GCStipple,
         &values);

   XFillRectangle (mainDisplay, choiceWindow, patGC,
         7*choiceImageW, choiceImageH, choiceImageW, choiceImageH);
}

void SetCurChoice (NewChoice)
   int	NewChoice;
{
   if (curChoice == NewChoice) return;
#ifdef KINPUT
   if (curChoice == DRAWTEXT && kinputOn)
       EndKanjiConversion (mainDisplay, drawWindow);
#endif /* KINPUT */   

   switch (curChoice)
   {
      case NOTHING:
         if (topSel != NULL)
         {
            HighLightReverse ();
            RemoveAllSel ();
         }
         break;
      case DRAWTEXT:
         CreateTextObj ();
         if (NewChoice == NOTHING && textDrawn) HighLightJustDrawnText ();
         textDrawn = FALSE;
         SetDefaultCursor (drawWindow);
         textCursorShown = FALSE;
         break;
      case DRAWBOX:
         if (NewChoice == NOTHING && boxDrawn) SelectTopObj ();
         boxDrawn = FALSE;
         break;
      case DRAWCIRCLE:
         if (NewChoice == NOTHING && ovalDrawn) SelectTopObj ();
         ovalDrawn = FALSE;
         break;
      case DRAWPOLY:
         if (NewChoice == NOTHING && polyDrawn) SelectTopObj ();
         polyDrawn = FALSE;
         break;
      case DRAWPOLYGON:
         if (NewChoice == NOTHING && polygonDrawn) SelectTopObj ();
         polygonDrawn = FALSE;
         break;
      case DRAWARC:
         if (NewChoice == NOTHING && arcDrawn) SelectTopObj ();
         arcDrawn = FALSE;
         break;
      case DRAWRCBOX:
         if (NewChoice == NOTHING && rcBoxDrawn) SelectTopObj ();
         rcBoxDrawn = FALSE;
         break;
   }

   curChoice = NewChoice;

   if (curChoice == DRAWTEXT)
   {
      SetTextCursor (drawWindow);
      textCursorShown = FALSE;
   }
#ifdef UC
   else if (curChoice != NOTHING)
   {
      SetDrawCursor(drawWindow);
   }
   else SetDefaultCursor(drawWindow);
#endif /* UC */

   ShowMode ();
}

void ChoiceEventHandler (input)
   XEvent	* input;
{
   XEvent	ev;
   XButtonEvent	* button_ev;
   int		xindex, yindex, delta = 0, root_x, root_y, x = 0, y = 0;
   Window	root_win, child_win;
   unsigned int	status;
#ifdef KANJI
   static int Warning = FALSE;
#endif /* KANJI */   

   if (input->type == Expose)
   {
      XSync (mainDisplay, FALSE);
      while (XCheckWindowEvent (mainDisplay, choiceWindow, ExposureMask, &ev)) ;
      RedrawChoiceWindow ();
   }
   else if (input->type == ButtonPress)
   {
      button_ev = &(input->xbutton);
      switch (button_ev->button)
      {
         case Button1: delta = 1; break;
         case Button2:
            XQueryPointer (mainDisplay, rootWindow, &root_win, &child_win,
                  &root_x, &root_y, &x, &y, &status);
            break;
         case Button3: delta = -1; break;
         default: return;
      }
      xindex = (int)(button_ev->x / choiceImageW);
      yindex = (int)(button_ev->y / choiceImageH);
      switch (xindex)
      {
         case 0:
            if (yindex == 0)
            {
               if (delta == 0)
                  ModeMenu (x, y);
               else
                  SetCurChoice ((curChoice+MAXCHOICES+delta) % MAXCHOICES);
            }
            else if (colorDisplay)
            {
               if (delta == 0)
                  ColorMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  colorIndex = (colorIndex+maxColors+delta) % maxColors;
                  ShowColor (TRUE);
                  if (topSel != NULL) ChangeAllSelColor (colorIndex);
               }
            }
            break;
         case 1:
            if (yindex == 0)
            {
               if (delta == 0)
                  SizeMenu (x, y);
               else
               {
                  horiAlign = (horiAlign+MAXALIGNS+delta) % MAXALIGNS;
                  ShowHoriAlign ();
               }
            }
            else
            {
               if (delta == 0)
                  FontDPIMenu (x, y);
               else
               {
                  vertAlign = (vertAlign+MAXALIGNS+delta) % MAXALIGNS;
                  ShowVertAlign ();
               }
            }
            break;
         case 2:
            if (yindex == 0)
            {
               if (delta == 0)
                  StyleMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  textJust = (textJust+MAXJUSTS+delta) % MAXJUSTS;
                  ShowJust ();
                  if (topSel != NULL) ChangeFontJust (textJust);
               }
            }
            else
            {
               if (delta == 0)
                  FontMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
#ifndef KANJI
                  curFont = (curFont+MAXFONTS+delta) % MAXFONTS;
#else /* KANJI */
		  curFont = (curFont+MAXFONTS+delta) % MAXFONTSP;
		  if (!noKanji)
		  {
		      if (curFont == FONT_MIN || curFont == FONT_GOT)
			  if (curFontDPI != FONT_DPI_75 || curStyle != STYLE_NR)
			  {
			      if (curFontDPI != FONT_DPI_75)
				  Msg ("KANJI fonts don't support for 100 DPI font");
			      else
				  Msg ("KANJI fonts don't support for Bold, Italic, or Bold Italic");	       
			      
			      if (Warning)
			      {
				  Msg ("");
				  Warning = FALSE;
				  curFont = FONT_TIM;
			      }
			      else
			      {
				  Warning = TRUE;
				  curFont = FONT_SYM;
			      }
			  }
		  }
#endif /* KANJI */   
                  SetCanvasFont ();
                  ShowCurFont ();
                  if (topSel != NULL) ChangeFont (curFont);
               }
            }
            break;
         case 3:
            if (yindex == 0)
            {
               if (delta == 0)
                  ArrangeMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  curRotate = (curRotate+4+delta) % 4;
                  ShowRotate ();
                  if (topSel != NULL)
                  {
                     if (delta == 1)
                        RotateClockWise ();
                     else
                        RotateCounter ();
                  }
               }
            }
            else
            {
               if (delta == 0)
                  SpecialMenu (x, y);
            }
            break;
         case 4:
            if (yindex == 0)
            {
               if (delta == 0)
                  LineStyleMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  lineWidth = (lineWidth+MAXLINEWIDTHS+delta) % MAXLINEWIDTHS;
                  ShowLineWidth ();
                  if (topSel != NULL) ChangeAllSelLineWidth (lineWidth);
               }
            }
            else
            {
               if (delta == 0)
                  LineStyleMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  lineStyle = (lineStyle+MAXLINESTYLES+delta) % MAXLINESTYLES;
                  ShowLineStyle ();
                  if (topSel != NULL) ChangeAllSelLineStyle (lineStyle);
               }
            }
            break;
         case 5:
            if (yindex == 0)
            {
               if (delta == 0)
                  LineStyleMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  curSpline = (curSpline+MAXLINETYPES+delta) % MAXLINETYPES;
                  ShowLineType ();
                  if (topSel != NULL) ChangeAllSelLineType (curSpline);
               }
            }
            else
            {
               if (delta == 0)
                  LineStyleMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  curDash = (curDash+MAXDASHES+delta) % MAXDASHES;
                  ShowDash ();
                  if (topSel != NULL) ChangeAllSelDashes (curDash);
               }
            }
            break;
         case 6:
            if (yindex == 0)
            {
               if (delta == 0)
                  LayoutMenu (x, y);
               else
               {
                  whereToPrint = (whereToPrint+MAXWHERETOPRINT+delta) %
                        MAXWHERETOPRINT-1;
                  ToggleWhereToPrint ();
               }
            }
            else
            {
               if (delta == 0)
                  FileMenu (x, y);
            }
            break;
         case 7:
            if (yindex == 0)
            {
               if (delta == 0)
                  FillMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  objFill = (objFill+MAXPATTERNS+delta) % MAXPATTERNS;
                  ShowFill ();
                  if (topSel != NULL) ChangeAllSelFill (objFill);
               }
            }
            else
            {
               if (delta == 0)
                  PenMenu (x, y);
               else
               {
                  if (curChoice != NOTHING) SetCurChoice (NOTHING);
                  penPat = (penPat+MAXPATTERNS+delta) % MAXPATTERNS;
                  ShowPen ();
                  if (topSel != NULL) ChangeAllSelPen (penPat);
               }
            }
            break;
      }
   }
}
#ifdef UC
/* matsushita's modification */
void PushCurChoice ()
{
   static int prevChoice = NOTHING;
   
   if (curChoice == NOTHING)
   {
	SetCurChoice (prevChoice);
   }
   else
   {
 	prevChoice = curChoice;
 	SetCurChoice (NOTHING);
   }
}
#endif /* UC */
