/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/color.c,v 2.0 91/03/05 14:17:36 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "mark.e"
#include "menu.e"
#include "obj.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "text.e"

#define COLORSTRLEN 80

int	maxColors = MAXCOLORS;
#ifndef UC
int	defaultColorIndex = 4;
#else /* UC */
int	defaultColorIndex = 9;
#endif /* UC */
int	colorIndex = 0;
int	* colorPixels = NULL;
int	* xorColorPixels = NULL;
char	myFgColorStr[COLORSTRLEN];
char	myBgColorStr[COLORSTRLEN];
char	* * colorMenuItems = NULL;
XColor	* tgifColors;
int	maxRGB = 0;
int	colorDump = FALSE;

static int	allocatedMaxColors = MAXCOLORS;

static char	* defaultColorMenuItems[MAXCOLORS] =
{
   "magenta", "red", "green", "blue", "yellow", "pink", "cyan", "CadetBlue",
   "white", "DarkSlateGray"
};

void DefaultColorArrays (Entries, ForePixels, Valid)
   int	Entries, * * ForePixels, * * Valid;
{
   register int	i, * fore_pixels, pixel, * valid;

   pixel = myFgPixel;
   *ForePixels = fore_pixels = (int *) calloc (Entries, sizeof(int));
   *Valid = valid = (int *) calloc (Entries, sizeof(int));
   for (i = 0; i < Entries; i++)
   {
      *fore_pixels++ = pixel;
      *valid++ = TRUE;
   }
}

int FindColorIndex (s)
   char	* s;
{
   register int i;

   if (colorMenuItems == NULL) return (0);

   for (i = 0; i < maxColors; i++)
      if (strcmp(s, colorMenuItems[i]) == 0)
         break;
   if (i == maxColors)
   {
      printf ("Can not find color '%s', use '%s' instead.\n", s,
            colorMenuItems[defaultColorIndex]);
      return (defaultColorIndex);
   }
   return (i);
}

void InitColor ()
{
   register int	i, index;
   XColor	color, exact_def;
   char		buf[80], * c_ptr, fg_color[80], bg_color[80], brdr_color[80];
   int		num, color_in_x_default = FALSE;
   int		bg_allocated=FALSE, fg_allocated=FALSE, brdr_allocated=FALSE;
   int		tmp_max;

#ifndef UC
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "ReverseVideo")) != NULL)
#else /* UC */
   if (!reverseVideo &&
       (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "ReverseVideo")) != NULL)
#endif /* UC */
      reverseVideo = (strcmp (c_ptr, "on") == 0);

   if (colorDisplay)
   {
      if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "Foreground")) != NULL)
         strcpy (fg_color, c_ptr);
      else
         strcpy (fg_color, "black");
      if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "Background")) != NULL)
         strcpy (bg_color, c_ptr);
      else
         strcpy (bg_color, "white");
      if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "BorderColor")) != NULL)
         strcpy (brdr_color, c_ptr);
      else
         strcpy (brdr_color, "black");

      if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "MaxColors")) != NULL)
      {
         color_in_x_default = TRUE;
         maxColors = atoi (c_ptr);
         if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DefaultColorIndex"))
               != NULL)
         {
            num = atoi (c_ptr);
            if (num < maxColors)
               defaultColorIndex = num;
            else
            {
               printf ("Warning:  DefaultColorIndex >= MaxColors, ");
               printf ("Use 0 for DefaultColorIndex\n");
               defaultColorIndex = 0;
            }
         }
         else
            defaultColorIndex = 0;
      }
      else
      {
         if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DefaultColorIndex"))
               != NULL)
         {
            num = atoi (c_ptr);
            if (num < maxColors) defaultColorIndex = num;
         }
      }
   }
   else
   {
      if (reverseVideo)
      {
         strcpy (fg_color, "white");
         strcpy (bg_color, "black");
         strcpy (brdr_color, "white");
      }
      else
      {
         strcpy (fg_color, "black");
         strcpy (bg_color, "white");
         strcpy (brdr_color, "black");
      }
   }

   colorIndex = defaultColorIndex;
#ifdef UC
   if (reverseVideo)
       if (defaultColorIndex == 9)
	   colorIndex = 8;
#endif /* UC */
   
   colorPixels = (int *) calloc (maxColors, sizeof (int));
   xorColorPixels = (int *) calloc (maxColors, sizeof (int));
   colorMenuItems = (char * *) calloc (maxColors, sizeof (char *));

   tgifColors = (XColor *) calloc (maxColors, sizeof (XColor));

   allocatedMaxColors = maxColors;
   for (i = 0; i < allocatedMaxColors; i++)
      colorMenuItems[i] = (char *) calloc (COLORSTRLEN, sizeof(char));

   if (color_in_x_default)
   {
      for (i = 0; i < maxColors; i++)
      {
         sprintf (buf, "Color%1d", i);
         if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, buf)) != NULL)
            strcpy (colorMenuItems[i], c_ptr);
         else
         {
            printf ("Could not GetDefault %s*%s\n", TOOL_NAME, buf);
            /* fool safe */ EmergencySave ();
         }
      }
   }
   else
      for (i = 0; i < maxColors; i++)
         strcpy (colorMenuItems[i], defaultColorMenuItems[i]);

   if (colorDisplay)
   {
      index = 0;
      for (i = 0; i < maxColors; i++)
      {
         if (!XAllocNamedColor(mainDisplay, mainColormap, colorMenuItems[i],
               &color, &exact_def))
            continue;

         if (i != index) strcpy (colorMenuItems[index], colorMenuItems[i]);

         colorPixels[index] = color.pixel;

         tgifColors[index].red = color.red;
         tgifColors[index].green = color.green;
         tgifColors[index].blue = color.blue;
   
         if (strcmp (colorMenuItems[i], fg_color) == 0)
         {
            if (reverseVideo)
            {
               myBgPixel = color.pixel;
               strcpy (myBgColorStr, fg_color);
            }
            else
            {
               myFgPixel = color.pixel;
               strcpy (myFgColorStr, fg_color);
            }

            fg_allocated = TRUE;
         }
         if (strcmp (colorMenuItems[i], bg_color) == 0)
         {
            if (reverseVideo)
            {
               myFgPixel = color.pixel;
               strcpy (myFgColorStr, bg_color);
            }
            else
            {
               myBgPixel = color.pixel;
               strcpy (myBgColorStr, bg_color);
            }

            bg_allocated = TRUE;
         }
         if (strcmp (colorMenuItems[i], brdr_color) == 0)
         {
            myBorderPixel = color.pixel;
            brdr_allocated = TRUE;
         }
         index++;
      }

      maxColors = index;

      if (!fg_allocated)
      {
         XAllocNamedColor(mainDisplay, mainColormap, fg_color, &color,
               &exact_def);
         if (reverseVideo)
         {
            myBgPixel = color.pixel;
            strcpy (myBgColorStr, fg_color);
         }
         else
         {
            myFgPixel = color.pixel;
            strcpy (myFgColorStr, fg_color);
         }
      }
      if (!bg_allocated)
      {
         XAllocNamedColor(mainDisplay, mainColormap, bg_color, &color,
               &exact_def);
         if (reverseVideo)
         {
            myFgPixel = color.pixel;
            strcpy (myFgColorStr, bg_color);
         }
         else
         {
            myBgPixel = color.pixel;
            strcpy (myBgColorStr, bg_color);
         }
      }
      if (!brdr_allocated)
      {
         XAllocNamedColor(mainDisplay, mainColormap, brdr_color, &color,
               &exact_def);
            myBorderPixel = color.pixel;
      }

      for (i = 0; i < maxColors; i++)
         xorColorPixels[i] = colorPixels[i] ^ myBgPixel;
#ifdef UC
      if (strcmp (brdr_color, myBgColorStr) == 0)
	  myBorderPixel = myFgPixel;
#endif /* UC */
   }
   else
   {
      XAllocNamedColor(mainDisplay,mainColormap,fg_color,&color,&exact_def);
      myFgPixel = color.pixel;
      strcpy (myFgColorStr, fg_color);

      XAllocNamedColor(mainDisplay,mainColormap,bg_color,&color,&exact_def);
      myBgPixel = color.pixel;
      strcpy (myBgColorStr, bg_color);

      XAllocNamedColor(mainDisplay,mainColormap,brdr_color,&color,&exact_def);
      myBorderPixel = color.pixel;

      for (i = 0; i < maxColors; i++)
      {
         colorPixels[i] = myFgPixel;
         xorColorPixels[i] = myFgPixel ^ myBgPixel;
      }
      colorIndex = 0;
   }
   XAllocNamedColor(mainDisplay, mainColormap, "black", &color, &exact_def);
   tmp_max = max(color.red,max(color.green,color.blue));
   if (tmp_max > maxRGB) maxRGB = tmp_max;
   XAllocNamedColor(mainDisplay, mainColormap, "white", &color, &exact_def);
   tmp_max = max(color.red,max(color.green,color.blue));
   if (tmp_max > maxRGB) maxRGB = tmp_max;
   if (tmp_max == 0)
      printf ("Warning:  Unexpected maximum RGB intensity 0.");
}

static
int ChangeObjColor (ObjPtr, ColorIndex)
   struct ObjRec	* ObjPtr;
   int			ColorIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
         case OBJ_BOX:
         case OBJ_OVAL:
         case OBJ_TEXT:
         case OBJ_POLYGON:
         case OBJ_ARC:
         case OBJ_RCBOX:
         case OBJ_XBM:
            if (obj_ptr->color != ColorIndex)
            {
               obj_ptr->color = ColorIndex;
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
         case OBJ_ICON:
            if (ChangeObjColor (obj_ptr->detail.r->last, ColorIndex))
               changed = TRUE;
            break;
      }
   return (changed);
}

void ChangeAllSelColor (ColorIndex)
   int	ColorIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				text_obj_created = FALSE, text_cursor_shown;
   int				changed = FALSE;
   XGCValues			values;

   if (topSel == NULL)
   {
      text_cursor_shown = textCursorShown;
      text_obj_created = TieLooseEnds ();
      colorIndex = ColorIndex;
      ShowColor (TRUE);
      if (!text_obj_created && curChoice == DRAWTEXT && text_cursor_shown)
      {
         NewCurText ();
         RedrawCurText ();
      }
      else
         textCursorShown = FALSE;
      return;
   }

   values.foreground = colorPixels[ColorIndex];
   values.function = GXcopy;
   values.fill_style = FillSolid;
   XChangeGC (mainDisplay, drawGC,
         GCForeground | GCFunction | GCFillStyle, &values);

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
         case OBJ_BOX:
         case OBJ_OVAL:
         case OBJ_TEXT:
         case OBJ_POLYGON:
         case OBJ_ARC:
         case OBJ_RCBOX:
         case OBJ_XBM:
            if (obj_ptr->color != ColorIndex)
            {
               obj_ptr->color = ColorIndex;
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
         case OBJ_ICON:
            if (ChangeObjColor (obj_ptr->detail.r->last, ColorIndex))
               changed = TRUE;
            break;
      }
   }

   if (changed)
   {
      HighLightReverse ();
      SetFileModified (TRUE);
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
}

void ColorMenu (X, Y)
   int	X, Y;
{
   register int	i, index, * fore_colors;
   Pixmap	* pixmap;
   int		w;

   if (!colorDisplay) return;

   pixmap = (Pixmap *) calloc (maxColors, sizeof (Pixmap));
   fore_colors = (int *) calloc (maxColors, sizeof(int));
   for (i = 0; i < maxColors; i++)
   {
      pixmap[i] = patPixmap[1];
      fore_colors[i] = colorPixels[i];
   }
   if ((maxColors % 10) == 0)
      w = (int)(maxColors / 10);
   else
      w = (int)(maxColors / 10) + 1;
   if (maxColors <= 10)
      index = PxMpMenuLoop (X, Y, choiceImageW, choiceImageH, maxColors, w,
#ifndef UC
            maxColors, fore_colors, pixmap, MULTICOLOR);
#else /* UC */
            maxColors, fore_colors, pixmap, MULTICOLOR, MENU_COLOR);
#endif /* UC */
   else
      index = PxMpMenuLoop (X, Y, choiceImageW, choiceImageH, 10, w,
#ifndef UC
            maxColors, fore_colors, pixmap, MULTICOLOR);
#else /* UC */
            maxColors, fore_colors, pixmap, MULTICOLOR, MENU_COLOR);
#endif /* UC */

   if (index != INVALID) ChangeAllSelColor (index);
   cfree (pixmap);
}

void CleanUpColors ()
{
   register int	i;

   cfree (colorPixels);
   cfree (xorColorPixels);
   for (i = 0; i < allocatedMaxColors; i++) cfree (colorMenuItems[i]);
   cfree (colorMenuItems);

   maxColors = MAXCOLORS;
   defaultColorIndex = 4;
   colorIndex = 0;
}
