/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/cursor.c,v 2.0 91/03/05 12:46:56 william Exp $";
#endif

#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "setup.e"

#include "xbm/null.xbm"
#include "xbm/nullmask.xbm"
#ifndef SYSV
#include "xbm/text_cur_image.xbm"
#else /* SYSV */
#include "xbm/text_cur.xbm"
#endif /* SYSV */

Cursor	nullCursor;
Cursor	cornerCursor;
Cursor	defaultCursor;
Cursor	handCursor;
#ifdef UC
Cursor	watchCursor;
Cursor	drawCursor;
Cursor	dragCursor;
int hideDragCursor = FALSE;
/* int cursorDefined = FALSE;*/
#endif /* UC */

static GC	textCursorGC;
static Cursor	textCursor;
static Pixmap	textPixmap;
static Pixmap	nullPixmap;
static Pixmap	nullMaskPixmap;

static XImage	* textCursorImage;

void SetTextCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, textCursor);
}

void SetNullCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, nullCursor);
}

#ifdef UC
void SetDrawCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, drawCursor);
}
#endif /* UC */
void SetDefaultCursor (window)
   Window	window;
{
   XUndefineCursor (mainDisplay, window);
}

void ShowCursor ()
{
   if (curChoice == DRAWTEXT)
      SetTextCursor (drawWindow);
#ifndef UC
   else
#else /* UC */
   else if (curChoice == NOTHING)
#endif /* UC */
      SetDefaultCursor (drawWindow);
#ifdef UC
   else
      SetDrawCursor (drawWindow);
#endif /* UC */
}

void CreateCursor ()
{
   XGCValues	values;
   XColor	color;
#ifdef UC
   char * c_ptr;
   XColor cursorFgColor, cursorBgColor, exactColor;
   int	  defaultCurID = XC_top_left_arrow;
#endif /* UC */

   textPixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         text_cur_image_bits, text_cur_image_width, text_cur_image_height);

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillOpaqueStippled;
   values.stipple = textPixmap;
   textCursorGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle | GCStipple, &values);

   textCursorImage = XCreateImage (mainDisplay, mainVisual, 1, XYBitmap, 0,
         text_cur_image_bits, text_cur_image_width, text_cur_image_height, 8,
         2);
   textCursorImage->byte_order = LSBFirst;
   textCursorImage->bitmap_bit_order = LSBFirst;
   textCursorImage->data = text_cur_image_bits;

   textCursor = XCreateFontCursor (mainDisplay, XC_xterm);
   cornerCursor = XCreateFontCursor (mainDisplay, XC_ul_angle);
#ifndef UC
   defaultCursor = XCreateFontCursor (mainDisplay, XC_arrow);
#else /* UC */
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DefaultCursor"))!=NULL)
       if ((strcmp (c_ptr, "top_left_arrow") == 0))
	   defaultCurID = XC_top_left_arrow;
   
   defaultCursor = XCreateFontCursor (mainDisplay, defaultCurID);
   watchCursor = XCreateFontCursor (mainDisplay, XC_watch);

#define RecolorCursor(Cursor, ForeGround, BackGround)  \
        { \
	   XAllocNamedColor \
	       (mainDisplay, DefaultColormap (mainDisplay, mainScreen), \
			     ForeGround, &cursorFgColor, &exactColor); \
	   XAllocNamedColor \
	       (mainDisplay, DefaultColormap (mainDisplay, mainScreen), \
		     BackGround, &cursorBgColor, &exactColor); \
	   XRecolorCursor \
	       (mainDisplay, Cursor, &cursorFgColor, &cursorBgColor); \
	}
	      
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DrawCursor")) == NULL)
   {
       drawCursor = XCreateFontCursor (mainDisplay, defaultCurID);
       if (colorDisplay)
       {
	   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DrawCursorColor"))!=NULL)
	   {
	       RecolorCursor (drawCursor, c_ptr, "black");
	   }
	   else
	   {
	       RecolorCursor (drawCursor, "white", "black");
	   }
       }       
       else
       {
	   RecolorCursor (drawCursor, "white", "black");
       }
   }
   else if (strcmp (c_ptr, "dotbox") == 0)
   {
       drawCursor = XCreateFontCursor (mainDisplay, XC_dotbox);	   
       if (!colorDisplay)
	   if (reverseVideo)
	   {
	       RecolorCursor (drawCursor, "white", "black");
	   }
	   else
	   {
	       RecolorCursor (drawCursor, "black", "white");
	   }
   }
   else if (strcmp (c_ptr, "crosshair") == 0)
   {
       drawCursor = XCreateFontCursor (mainDisplay, XC_crosshair);
       if (!colorDisplay)
	   if (reverseVideo)
	   {
	       RecolorCursor (drawCursor, "white", "black");
	   }
	   else
	   {
	       RecolorCursor (drawCursor, "black", "white");
	   }
   }
#endif /* UC */
   handCursor = XCreateFontCursor (mainDisplay, XC_hand2);

   nullPixmap = XCreatePixmap (mainDisplay, mainWindow, null_width,
         null_height, 1);
   nullMaskPixmap = XCreatePixmap (mainDisplay, mainWindow, nullmask_width,
         nullmask_height, 1);
   nullCursor = XCreatePixmapCursor (mainDisplay, nullPixmap, nullMaskPixmap,
         &color, &color, 0, 0);
#ifdef UC
   if (hideDragCursor)
       dragCursor = nullCursor;
   else
       dragCursor = handCursor;
#endif /* UC */
}

void PutCursor (window, x, y, foreground)
   Window	window;
   int		x, y, foreground;
{
   XSetForeground (mainDisplay, textCursorGC, foreground);
   XPutImage (mainDisplay, window, textCursorGC, textCursorImage, 0, 0, x, y,
         text_cur_image_width, text_cur_image_height);
}

void CleanUpCursors ()
{
   XFreePixmap (mainDisplay, textPixmap);
   XFreeGC (mainDisplay, textCursorGC);
/* XDestroyImage (textCursorImage); */

   XFreeCursor (mainDisplay, textCursor);
   XFreeCursor (mainDisplay, cornerCursor);
   XFreeCursor (mainDisplay, defaultCursor);
   XFreeCursor (mainDisplay, handCursor);

   XFreePixmap (mainDisplay, nullPixmap);
   XFreePixmap (mainDisplay, nullMaskPixmap);
   XFreeCursor (mainDisplay, nullCursor);
}
