/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/dialog.c,v 2.0 91/03/05 12:46:58 william Exp $";
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"

#include "box.e"
#include "cursor.e"
#include "font.e"
#include "mainloop.e"
#include "raster.e"
#include "setup.e"

static int	curX, curY;
static Window	dialogWindow;

unsigned int CornerLoop (OrigX, OrigY)
   int	* OrigX, * OrigY;
{
   XEvent	input;

   XGrabPointer (mainDisplay, rootWindow, False, ButtonPressMask,
         GrabModeAsync, GrabModeAsync, None, cornerCursor, CurrentTime);

   for (;;)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonPress)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         *OrigX = input.xbutton.x;
         *OrigY = input.xbutton.y;
         return (input.xbutton.button);
      }
   }
}

#ifdef UC
#define MAXMSGLINES 4
#define MAXMSGCHAR 65
#endif /* UC */
void Dialog (Message, ReturnStr)
   char	* Message, * ReturnStr;
{
   int		w, h, str_w, left, top, fore_draw_pixel, fore_erase_pixel;
   XEvent	input;
   int		win_x, win_y;
   int		dialoging = TRUE, index = 0, dsp_w, dsp_h;
   char		buf[80];
   XKeyEvent	* key_ev;
   KeyCode	key_code;
   KeySym	key_sym;
   XComposeStatus	c_stat;
   XSetWindowAttributes	win_attrs;
#ifdef UC
   int	msgLines = 0, c, done, i;
   int  msgLen = strlen (Message);
   char subMsg[MAXMSGLINES][MAXMSGCHAR + 1];
   register char * msgs = Message, * s;

   if (msgLen >= MAXMSGCHAR)
   {
       msgLen = MAXMSGCHAR;
       done = 1;
       for (c = 0; c < MAXMSGLINES || done; c++)
       {
	   msgLines++;
	   s = &subMsg [c][0];
	   for(i = 0; i < MAXMSGCHAR; i++)
	   {
	       if (*msgs != '\n' && *msgs != '\0')
	       {
		   *s++ = *msgs++;
		   continue;
	       }
	       else if (*msgs == '\0')
	       {
		   done = 0; break;
	       }
	       else
	       {
		   msgs++; break;
	       }
	   }
	   *s = '\0';
       }
   }
   else
       msgLines = 1;
#endif /* UC */

#ifndef UC
   h = 7 * defaultFontHeight;
   str_w = defaultFontWidth * strlen (Str);
#else /* UC */
   h = (6 + msgLines) * defaultFontHeight;
   str_w = defaultFontWidth * msgLen;
#endif /* UC */
   w = max(str_w+6*defaultFontWidth,600);
   left = (w - str_w) / 2;
   top = 2 * defaultFontHeight;

   fore_draw_pixel = myFgPixel;
   fore_erase_pixel = myBgPixel;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   win_x = (w > dsp_w) ? 0 : (dsp_w - w)/2;
   win_y = (h > dsp_h) ? 0 : (dsp_h - h)/3;

   if (w > dsp_w-2*(brdrW+1)) w = dsp_w-2*(brdrW+1);

   if ((dialogWindow = XCreateSimpleWindow (mainDisplay, rootWindow, win_x,
         win_y, w, h, brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create dialog window!\n"); /* fool safe */ EmergencySave (); }

   win_attrs.save_under = True;
   XChangeWindowAttributes (mainDisplay, dialogWindow, CWSaveUnder, &win_attrs);

   XSetTransientForHint (mainDisplay, dialogWindow, mainWindow);
   XMapWindow (mainDisplay, dialogWindow);
   XSelectInput (mainDisplay, dialogWindow, KeyPressMask | ExposureMask);

#ifndef UC
   curX = 200;
   curY = 4 * defaultFontHeight;
#else /* UC */
   curX = 100;
   curY = (3 + msgLines) * defaultFontHeight;
#endif /* UC */

   while (dialoging)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == Expose)
      {
         XDrawRectangle (mainDisplay, dialogWindow, defaultGC, 0, 0, w-1, h-1);
         MyBox (dialogWindow, defaultGC, 10, 10, w-9, h-9);
         MyBox (dialogWindow, defaultGC, 11, 11, w-10, h-10);
         MyBox (dialogWindow, defaultGC, 12, 12, w-11, h-11);
#ifndef UC
         XDrawString (mainDisplay, dialogWindow, defaultGC, left, top, Message,
               strlen(Message));
#else /* UC */
	 if (msgLines > 1)
	     for (i = 0; i < msgLines ; i++)
		 XDrawString (mainDisplay, dialogWindow, defaultGC, left,
			 (defaultFontHeight * (i+1))+top,
			      &subMsg[i][0], strlen(&subMsg[i][0]));
	 else 
	     XDrawString (mainDisplay, dialogWindow, defaultGC, left, top,
			  Message, strlen(Message));
#endif /* UC */

         PutCursor (dialogWindow, curX, curY, fore_draw_pixel);

         continue;
      }
      if (input.type == KeyPress)
      {
         /* erase the old cursor */
         PutCursor (dialogWindow, curX, curY, fore_erase_pixel);

         key_ev = &(input.xkey);
         key_code = key_ev->keycode;
         XLookupString (key_ev, buf, 80, &key_sym, &c_stat);
         if ((buf[0]=='\033' && (key_sym & 0xff)=='\033') ||
               (buf[0]=='\r' && (key_sym & 0xff)=='\r') ||
               (buf[0]=='\n' && (key_sym & 0xff)=='\n') ||
               (buf[0]=='\b' && (key_sym & 0xff)=='\b') ||
               (buf[0]=='\b' && (key_sym & 0xff)=='h' &&
               (key_ev->state & ControlMask)) ||
               (buf[0]=='\177' && (key_sym & 0x7f)=='\177') ||
               (key_sym>='\040' && key_sym<='\177'))
         {
            switch (buf[0])
            {
               case '\033':
                  ReturnStr[0] = '\0';
                  dialoging = FALSE;
                  break;
               case '\r':
               case '\n':
                  ReturnStr[index] = '\0';
                  dialoging = FALSE;
                  break;
               case '\177': /* <DEL> */
               case '\b': /* <BS> */
                  if (index != 0)
                  {
                     index--;
                     curX -= defaultFontWidth + 1;
                     PutCursor (dialogWindow, curX, curY, fore_erase_pixel);
                  }
                  break;
               default:
                  if (buf[0] >= '\040' && index < 80)
                  {
                     XDrawString (mainDisplay, dialogWindow, defaultGC, curX,
                           curY+defaultFontAsc, buf, 1);
                     curX += defaultFontWidth + 1;
                     ReturnStr[index++] = buf[0];
                  }
                  break;
            }
         }
         PutCursor (dialogWindow, curX, curY, fore_draw_pixel);
      }
   }

   XDestroyWindow (mainDisplay, dialogWindow);
   XSync (mainDisplay, FALSE);
   while (XCheckMaskEvent (mainDisplay, ExposureMask, &input)) ;
}
