/*
 * Author:	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifdef UC
#include <math.h>
#include <X11/Xlib.h>
#include "const.h"

#define DELTA 6

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif


int 	xLibArc = FALSE;

static double sinTable[] =
{
    0.00000000000000000000, /*   0 */
    0.10452846326765345697, /*   6 */
    0.20791169081775931482, /*  12 */
    0.30901699437494739575, /*  18 */
    0.40673664307580015276, /*  24 */
    0.50000000000000000000, /*  30 */
    0.58778525229247313710, /*  36 */
    0.66913060635885823757, /*  42 */
    0.74314482547739424412, /*  48 */
    0.80901699437494745126, /*  54 */
    0.86602540378443859659, /*  60 */
    0.91354545764260086660, /*  66 */
    0.95105651629515353118, /*  72 */
    0.97814760073380557781, /*  78 */
    0.99452189536827328986, /*  84 */
    1.00000000000000000000, /*  90 */
    0.99452189536827340088, /*  96 */
    0.97814760073380568883, /* 102 */
    0.95105651629515364220, /* 108 */
    0.91354545764260097762, /* 114 */
    0.86602540378443870761, /* 120 */
    0.80901699437494745126, /* 126 */
    0.74314482547739424412, /* 132 */
    0.66913060635885845961, /* 138 */
    0.58778525229247324813, /* 144 */
    0.50000000000000000000, /* 150 */
    0.40673664307580043031, /* 156 */
    0.30901699437494750677, /* 162 */
    0.20791169081775931482, /* 168 */
    0.10452846326765373453, /* 174 */
    0.00000000000000000000, /* 180 */
    -0.10452846326765305451, /* 186 */
    -0.20791169081775906502, /* 192 */
    -0.30901699437494772882, /* 198 */
    -0.40673664307579981969, /* 204 */
    -0.50000000000000000000, /* 210 */
    -0.58778525229247302608, /* 216 */
    -0.66913060635885823757, /* 222 */
    -0.74314482547739402207, /* 228 */
    -0.80901699437494734024, /* 234 */
    -0.86602540378443837454, /* 240 */
    -0.91354545764260097762, /* 246 */
    -0.95105651629515353118, /* 252 */
    -0.97814760073380557781, /* 258 */
    -0.99452189536827340088, /* 264 */
    -1.00000000000000000000, /* 270 */
    -0.99452189536827340088, /* 276 */
    -0.97814760073380579986, /* 282 */
    -0.95105651629515364220, /* 288 */
    -0.91354545764260075558, /* 294 */
    -0.86602540378443859659, /* 300 */
    -0.80901699437494756229, /* 306 */
    -0.74314482547739457718, /* 312 */
    -0.66913060635885812655, /* 318 */
    -0.58778525229247335915, /* 324 */
    -0.50000000000000000000, /* 330 */
    -0.40673664307580015276, /* 336 */
    -0.30901699437494761780, /* 342 */
    -0.20791169081775986993, /* 348 */
    -0.10452846326765341534, /* 354 */
    };

#define D360 (360/DELTA)
#define D90 (90/DELTA)
#define MAXPOINTS (D360 + 2)
XPoint p[MAXPOINTS];

XPoint * myMakeOvalPoints (x, y, width, height, angle1, angle2, npoints)
int width, height, x, y, angle1, angle2, *npoints;
{
   register XPoint * points = p;
   register int i, a, angle;
   double w, h;
   int startAngle = angle1, endAngle;

   h = height / 2.0;
   w = width / 2.0;

   if (angle2 < 0)
   {
       startAngle = angle1 + angle2;
       angle2 = -1 * angle2;
   }

   endAngle = startAngle + angle2;
   * npoints =  (int) angle2 / 64 / DELTA + 2;

   p[0].x = (double)x + w + w * cos (startAngle * M_PI/180/64) + 0.5;
   p[0].y = (double)y + h - h * sin (startAngle * M_PI/180/64) + 0.5;
   p[*npoints - 1].x = (double)x + w + w * cos (endAngle * M_PI/180/64) + 0.5;
   p[*npoints - 1].y = (double)y + h - h * sin (endAngle * M_PI/180/64) + 0.5;

   angle =  (int)((startAngle + ((startAngle <0)? -1:1)*(DELTA -1)*64)/ 64 / DELTA + 0.5) % D360;
   for (i = 1 ; i < *npoints - 1 ; i ++)
   {
       points ++;
       a = abs (angle);
       points->y =
	   (double)y + h - h * ((angle < 0)? -1.: 1.)
	       * sinTable [a % D360] + 0.5;
       points->x =
	   (double)x + w + w * sinTable [(a + D90) % D360 ] + 0.5;
       angle++;
   }
   return (&p[0]);
}

void myXDrawArc (dpy, win, gc, x, y, width, height, angle1, angle2)
Display * dpy;
Window win;
GC gc;
int x, y;
unsigned int width, height;
int angle1, angle2;
{
   XPoint * points;
   int npoints;

   if (width == 0 && height == 0 || angle2 == 0)
       return;
   if (width>10000 || height>10000 || abs(angle2)< 2* DELTA || xLibArc)
   {
#undef XDrawArc
       XDrawArc (dpy, win, gc, x, y, width, height, angle1, angle2);
#define XDrawArc myXDrawArc
       return;
   }
   points = myMakeOvalPoints (x, y, width, height, angle1, angle2, &npoints);
   XDrawLines (dpy, win, gc, points, npoints, CoordModeOrigin);
}
#endif /* UC */

