/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/dup.c,v 2.0 91/03/05 12:47:04 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "attr.e"
#include "drawing.e"
#include "grid.e"
#include "obj.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "xbitmap.e"

extern struct ObjRec	* DupObj ();

int	justDupped = FALSE;
int	dupDx = INVALID, dupDy = INVALID;

void DupObjBasics (FromObjPtr, ToObjPtr)
   register struct ObjRec	* FromObjPtr, * ToObjPtr;
{
   ToObjPtr->x = FromObjPtr->x;
   ToObjPtr->y = FromObjPtr->y;
   ToObjPtr->color = FromObjPtr->color;
   ToObjPtr->id = objId++;
   ToObjPtr->dirty = FALSE;
   ToObjPtr->type = FromObjPtr->type;
   ToObjPtr->bbox.ltx = FromObjPtr->bbox.ltx;
   ToObjPtr->bbox.lty = FromObjPtr->bbox.lty;
   ToObjPtr->bbox.rbx = FromObjPtr->bbox.rbx;
   ToObjPtr->bbox.rby = FromObjPtr->bbox.rby;
   ToObjPtr->obbox.ltx = FromObjPtr->obbox.ltx;
   ToObjPtr->obbox.lty = FromObjPtr->obbox.lty;
   ToObjPtr->obbox.rbx = FromObjPtr->obbox.rbx;
   ToObjPtr->obbox.rby = FromObjPtr->obbox.rby;
}

static
void DupPolyObj (PolyPtr, ObjPtr)
   struct PolyRec	* PolyPtr;
   struct ObjRec	* ObjPtr;
{
   register int			i, num_pts;
   register struct PolyRec	* poly_ptr;
   register XPoint		* v;

   poly_ptr = (struct PolyRec *) calloc (1, sizeof(struct PolyRec));
   num_pts = poly_ptr->n = PolyPtr->n;
   v = (XPoint *) calloc (num_pts+1, sizeof(XPoint));
   for (i = 0; i < num_pts; i++)
   {
      v[i].x = PolyPtr->vlist[i].x;
      v[i].y = PolyPtr->vlist[i].y;
   }
   poly_ptr->vlist = v;
   poly_ptr->style = PolyPtr->style;
   poly_ptr->width = PolyPtr->width;
   poly_ptr->pen = PolyPtr->pen;
   poly_ptr->fill = PolyPtr->fill;
   if ((poly_ptr->curved = PolyPtr->curved) == LT_SPLINE)
   {
      poly_ptr->sn = num_pts = PolyPtr->sn;
      v = (XPoint *) calloc (num_pts+1, sizeof(XPoint));
      for (i = 0; i < num_pts; i++)
      {
         v[i].x = PolyPtr->svlist[i].x;
         v[i].y = PolyPtr->svlist[i].y;
      }
      poly_ptr->svlist = v;
   }
   poly_ptr->dash = PolyPtr->dash;

   ObjPtr->detail.p = poly_ptr;
}

static
void DupPolygonObj (PolygonPtr, ObjPtr)
   struct PolygonRec	* PolygonPtr;
   struct ObjRec	* ObjPtr;
{
   register int			i, num_pts;
   register struct PolygonRec	* polygon_ptr;
   XPoint			* v;

   polygon_ptr = (struct PolygonRec *) calloc (1, sizeof(struct PolygonRec));
   num_pts = polygon_ptr->n = PolygonPtr->n;
   v = (XPoint *) calloc (num_pts+1, sizeof(XPoint));
   for (i = 0; i < num_pts; i++)
   {
      v[i].x = PolygonPtr->vlist[i].x;
      v[i].y = PolygonPtr->vlist[i].y;
   }
   polygon_ptr->vlist = v;
   polygon_ptr->fill = PolygonPtr->fill;
   polygon_ptr->width = PolygonPtr->width;
   polygon_ptr->pen = PolygonPtr->pen;
   if ((polygon_ptr->curved = PolygonPtr->curved) == LT_SPLINE)
   {
      polygon_ptr->sn = num_pts = PolygonPtr->sn;
      v = (XPoint *) calloc (num_pts, sizeof(XPoint));
      for (i = 0; i < num_pts; i++)
      {
         v[i].x = PolygonPtr->svlist[i].x;
         v[i].y = PolygonPtr->svlist[i].y;
      }
      polygon_ptr->svlist = v;
   }
   polygon_ptr->dash = PolygonPtr->dash;

   ObjPtr->detail.g = polygon_ptr;
}

static
void DupOvalObj (OvalPtr, ObjPtr)
   struct OvalRec	* OvalPtr;
   struct ObjRec	* ObjPtr;
{
   register struct OvalRec	* oval_ptr;

   oval_ptr = (struct OvalRec *) calloc (1, sizeof(struct OvalRec));
   oval_ptr->fill = OvalPtr->fill;
   oval_ptr->width = OvalPtr->width;
   oval_ptr->pen = OvalPtr->pen;
   oval_ptr->dash = OvalPtr->dash;

   ObjPtr->detail.o = oval_ptr;
}

static
void DupBoxObj (BoxPtr, ObjPtr)
   struct BoxRec	* BoxPtr;
   struct ObjRec	* ObjPtr;
{
   register struct BoxRec	* box_ptr;

   box_ptr = (struct BoxRec *) calloc (1, sizeof(struct BoxRec));
   box_ptr->fill = BoxPtr->fill;
   box_ptr->width = BoxPtr->width;
   box_ptr->pen = BoxPtr->pen;
   box_ptr->dash = BoxPtr->dash;

   ObjPtr->detail.b = box_ptr;
}

static
void DupRCBoxObj (RCBoxPtr, ObjPtr)
   struct RCBoxRec	* RCBoxPtr;
   struct ObjRec	* ObjPtr;
{
   register struct RCBoxRec	* rcbox_ptr;

   rcbox_ptr = (struct RCBoxRec *) calloc (1, sizeof(struct RCBoxRec));
   rcbox_ptr->fill = RCBoxPtr->fill;
   rcbox_ptr->width = RCBoxPtr->width;
   rcbox_ptr->pen = RCBoxPtr->pen;
   rcbox_ptr->dash = RCBoxPtr->dash;
   rcbox_ptr->radius = RCBoxPtr->radius;

   ObjPtr->detail.rcb = rcbox_ptr;
}

static
void DupArcObj (ArcPtr, ObjPtr)
   struct ArcRec	* ArcPtr;
   struct ObjRec	* ObjPtr;
{
   register struct ArcRec	* arc_ptr;

   arc_ptr = (struct ArcRec *) calloc (1, sizeof(struct ArcRec));
   arc_ptr->fill = ArcPtr->fill;
   arc_ptr->width = ArcPtr->width;
   arc_ptr->pen = ArcPtr->pen;
   arc_ptr->dash = ArcPtr->dash;

   arc_ptr->xc = ArcPtr->xc;         arc_ptr->yc = ArcPtr->yc;
   arc_ptr->x1 = ArcPtr->x1;         arc_ptr->y1 = ArcPtr->y1;
   arc_ptr->x2 = ArcPtr->x2;         arc_ptr->y2 = ArcPtr->y2;
   arc_ptr->dir = ArcPtr->dir;
   arc_ptr->ltx = ArcPtr->ltx;       arc_ptr->lty = ArcPtr->lty;
   arc_ptr->w = ArcPtr->w;           arc_ptr->h = ArcPtr->h;
   arc_ptr->angle1 = ArcPtr->angle1; arc_ptr->angle2 = ArcPtr->angle2;

   ObjPtr->detail.a = arc_ptr;
}

static
void DupXBmObj (XBmPtr, ObjPtr)
   struct XBmRec	* XBmPtr;
   struct ObjRec	* ObjPtr;
{
   register struct XBmRec	* xbm_ptr;
   Pixmap			bitmap;
   int				w, h;

   w = ObjPtr->obbox.rbx - ObjPtr->obbox.ltx;
   h = ObjPtr->obbox.rby - ObjPtr->obbox.lty;

   bitmap = XCreatePixmap (mainDisplay, mainWindow, w, h, 1);
   XCopyArea (mainDisplay, XBmPtr->bitmap, bitmap, xbmGC, 0, 0, w, h, 0, 0);

   xbm_ptr = (struct XBmRec *) calloc (1, sizeof(struct XBmRec));
   xbm_ptr->bitmap = bitmap;
   xbm_ptr->data = NULL;
   xbm_ptr->fill = XBmPtr->fill;
   ObjPtr->detail.xbm = xbm_ptr;
}

void DupTextObj (TextPtr, ObjPtr)
   struct TextRec	* TextPtr;
   struct ObjRec	* ObjPtr;
{
   register int			i, num_lines;
   register struct TextRec	* text_ptr;
   struct StrRec		* first_str;
   struct StrRec		* from_str_ptr, * to_str_ptr;

   text_ptr = (struct TextRec *) calloc (1, sizeof(struct TextRec));
   text_ptr->just = TextPtr->just;
   num_lines = text_ptr->lines = TextPtr->lines;
   from_str_ptr = TextPtr->last;
   first_str = NULL;
   for (i = 0; i < num_lines; i++, from_str_ptr = from_str_ptr->prev)
   {
      to_str_ptr = (struct StrRec *) calloc (1, sizeof(struct StrRec));
      strcpy (to_str_ptr->s, from_str_ptr->s);
      to_str_ptr->next = first_str;
      if (first_str == NULL)
         text_ptr->last = to_str_ptr;
      else
         first_str->prev = to_str_ptr;
      first_str = to_str_ptr;
   }
   first_str->prev = NULL;
   text_ptr->first = first_str;

   text_ptr->font = TextPtr->font;
   text_ptr->dpi = TextPtr->dpi;
   text_ptr->style = TextPtr->style;
   text_ptr->size = TextPtr->size;
   text_ptr->rotate = TextPtr->rotate;
   text_ptr->pen = TextPtr->pen;
   text_ptr->asc = TextPtr->asc;
   text_ptr->des = TextPtr->des;

   ObjPtr->detail.t = text_ptr;
}

static
void DupGroupObj (GroupPtr, ObjPtr)
   struct GroupRec	* GroupPtr;
   struct ObjRec	* ObjPtr;
{
   register struct GroupRec	* group_ptr;
   struct ObjRec		* top_obj, * bot_obj;
   struct ObjRec		* from_obj_ptr, * to_obj_ptr;

   group_ptr = (struct GroupRec *) calloc (1, sizeof(struct GroupRec));
   top_obj = bot_obj = NULL;
   from_obj_ptr = GroupPtr->last;
   for ( ; from_obj_ptr != NULL; from_obj_ptr = from_obj_ptr->prev)
   {
      to_obj_ptr = DupObj (from_obj_ptr);
      to_obj_ptr->next = top_obj;
      if (top_obj == NULL)
         group_ptr->last = to_obj_ptr;
      else
         top_obj->prev = to_obj_ptr;
      top_obj = to_obj_ptr;
   }
   top_obj->prev = NULL;
   group_ptr->first = top_obj;

   ObjPtr->detail.r = group_ptr;
}

struct ObjRec * DupObj (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   struct ObjRec	* obj_ptr;

   obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   DupObjBasics (ObjPtr, obj_ptr);

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         DupPolyObj (ObjPtr->detail.p, obj_ptr);
         DupAttrs (ObjPtr, obj_ptr);
         break;
      case OBJ_BOX:
         DupBoxObj (ObjPtr->detail.b, obj_ptr);
         DupAttrs (ObjPtr, obj_ptr);
         break;
      case OBJ_OVAL:
         DupOvalObj (ObjPtr->detail.o, obj_ptr);
         DupAttrs (ObjPtr, obj_ptr);
         break;
      case OBJ_TEXT: DupTextObj (ObjPtr->detail.t, obj_ptr); break;
      case OBJ_POLYGON:
         DupPolygonObj (ObjPtr->detail.g, obj_ptr);
         DupAttrs (ObjPtr, obj_ptr);
         break;
      case OBJ_ARC:
         DupArcObj (ObjPtr->detail.a, obj_ptr);
         DupAttrs (ObjPtr, obj_ptr);
         break;
      case OBJ_RCBOX:
         DupRCBoxObj (ObjPtr->detail.rcb, obj_ptr);
         DupAttrs (ObjPtr, obj_ptr);
         break;
      case OBJ_XBM:
         DupXBmObj (ObjPtr->detail.xbm, obj_ptr);
         DupAttrs (ObjPtr, obj_ptr);
         break;
      case OBJ_SYM:
      case OBJ_GROUP:
      case OBJ_ICON:
         DupGroupObj (ObjPtr->detail.r, obj_ptr);
         DupAttrs (ObjPtr, obj_ptr);
         if (obj_ptr->type == OBJ_ICON)
            strcpy (obj_ptr->detail.r->s, ObjPtr->detail.r->s);
         break;
   }
   return (obj_ptr);
}

void DupSelObj ()
{
   struct SelRec	* sel_ptr, * sel_ptr1;
   struct ObjRec	* obj_ptr, * top_obj, * bot_obj;
   int			dx, dy;

   if (topSel == NULL) return;

   top_obj = bot_obj = NULL;
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = DupObj (sel_ptr->obj);
      obj_ptr->next = top_obj;
      if (top_obj == NULL)
         bot_obj = obj_ptr;
      else
         top_obj->prev = obj_ptr;
      top_obj = obj_ptr;
   }
   top_obj->prev = NULL;

   HighLightReverse ();

   sel_ptr = botSel;
   sel_ptr1 = sel_ptr->prev;
   for (obj_ptr = bot_obj; sel_ptr1 != NULL; obj_ptr = obj_ptr->prev)
   {
      sel_ptr->obj = obj_ptr;
      sel_ptr = sel_ptr1;
      sel_ptr1 = sel_ptr1->prev;
   }
   sel_ptr->obj = obj_ptr;

   bot_obj->next = topObj;
   topObj->prev = bot_obj;
   topObj = top_obj;

   if (justDupped)
   {
      dx = dupDx;
      dy = dupDy;
   }
   else
   {
      if (gridOn)
#ifndef UC
         dupDx = dupDy = dx = dy = xyGrid << zoomScale;
      else
         dupDx = dupDy = dx = dy = DEFAULT_GRID << zoomScale;
#else /* UC */
         dupDx = dupDy = dx = dy = RealSize(xyGrid ,  zoomScale);
      else
         dupDx = dupDy = dx = dy = RealSize(DEFAULT_GRID ,  zoomScale);
#endif /* UC */
      justDupped = TRUE;
   }

   selLtX += dx; selLtY += dy; selRbX += dx; selRbY += dy;
   selObjLtX += dx; selObjLtY += dy; selObjRbX += dx; selObjRbY += dy;

   MoveAllSel (dx, dy);
#ifndef UC
   RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
         selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
         selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   SetFileModified (TRUE);
}

void JustDupSelObj (NewTopSel, NewBotSel)
   struct SelRec	* * NewTopSel, * * NewBotSel;
{
   struct SelRec	* sel_ptr, * new_sel_ptr;
   struct ObjRec	* obj_ptr, * top_obj, * bot_obj;

   *NewTopSel = *NewBotSel = NULL;
   if (topSel == NULL) return;

   top_obj = bot_obj = NULL;
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = DupObj (sel_ptr->obj);
      obj_ptr->next = top_obj;
      new_sel_ptr = (struct SelRec *) calloc (1, sizeof (struct SelRec));
      new_sel_ptr->next = *NewTopSel;
      new_sel_ptr->obj = obj_ptr;
      if (top_obj == NULL)
      {
         bot_obj = obj_ptr;
         *NewBotSel = new_sel_ptr;
      }
      else
      {
         top_obj->prev = obj_ptr;
         (*NewTopSel)->prev = new_sel_ptr;
      }
      top_obj = obj_ptr;
      *NewTopSel = new_sel_ptr;
   }
   top_obj->prev = NULL;
   (*NewTopSel)->prev = NULL;
}
