/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/edit.c,v 2.0 91/03/05 12:47:06 william Exp $";
#endif

#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "align.e"
#include "color.e"
#include "copypaste.e"
#include "cursor.e"
#include "drawing.e"
#include "dup.e"
#include "font.e"
#include "group.e"
#include "mark.e"
#include "obj.e"
#include "poly.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "special.e"
#include "spline.e"
#include "stretch.e"
#include "xbitmap.e"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define MARK(X,Y) \
      XFillRectangle(mainDisplay,drawWindow,revDefaultGC,(X)-2,(Y)-2,5,5)
#define MyDashedLine(W,GC,V,N) XDrawLines (mainDisplay, W, GC, V, N, \
      CoordModeOrigin)

#define EDIT_REDRAW 0
#define EDIT_DUP 1
#define EDIT_DELETE 2
#define EDIT_SELALL 3
#define EDIT_UNDODEL 4
#define EDIT_DEL_POINT 5
#define EDIT_ADD_POINT 6
#define EDIT_COPY 7
#define EDIT_PASTE 8
#define EDIT_INV_XBM 9

#define MAXEDITMENUS 10
#ifdef UC
#define OFFSET 16
#endif /* UC */

static char * editMenuStr[] =
      { "Redraw         ^R",
        "Duplicate      ^D",
        "Delete         ^X",
        "SelectAll      ^A",
#ifndef UC
        "UndoDelete     #U",
#else /* UC */
        "Undo           #U",
#endif /* UC */
        "DeletePoint   ^#D",
        "AddPoint      ^#A",
        "Copy           ^Y",
        "Paste         ^#Y",
        "InvertXBitmap ^#F"
      };

void DeletePoint ()
{
   register int			i;
   register struct ObjRec	* obj_ptr;
   struct PolyRec		* poly_ptr = NULL;
   struct PolygonRec		* polygon_ptr = NULL;
   int				index, n, point_deleted, deleting = TRUE;
   int				root_x, root_y, old_x, old_y;
   unsigned int			status;
   Window			root_win, child_win;
   XEvent			input, ev;

   if (!(topSel != NULL && topSel == botSel &&
         (topSel->obj->type == OBJ_POLY || topSel->obj->type == OBJ_POLYGON)))
   {
      Msg ("Please select only one POLY or POLYGON object.");
      return;
   }

   obj_ptr = topSel->obj;
   switch (obj_ptr->type)
   {
      case OBJ_POLY: poly_ptr = obj_ptr->detail.p; break;
      case OBJ_POLYGON: polygon_ptr = obj_ptr->detail.g; break;
   }
   TwoLineMsg ("Click left mouse button to DELETE points.",
         "Click other buttons to quit.");

   XGrabPointer (mainDisplay, drawWindow, False,
         PointerMotionMask | ButtonPressMask,
         GrabModeAsync, GrabModeAsync, None, defaultCursor, CurrentTime);
   XQueryPointer (mainDisplay, drawWindow, &root_win, &child_win,
         &root_x, &root_y, &old_x, &old_y, &status);
   XSetFont (mainDisplay, revDefaultGC, defaultFontPtr->fid);
   XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
         old_x+4, old_y+defaultFontAsc, "DEL", 3);
#else /* UC */
         old_x+OFFSET, old_y+defaultFontAsc, "DEL", 3);
#endif /* UC */
   MarkRulers (old_x, old_y);

   while (deleting)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonPress)
      {
         if (input.xbutton.button == Button1)
         {
            point_deleted = FALSE;
            if (obj_ptr->type == OBJ_POLY &&
                  PtInPolyMark (input.xbutton.x, input.xbutton.y,
                  poly_ptr->n, poly_ptr->vlist, &index) ||
                  obj_ptr->type == OBJ_POLYGON &&
                  PtInPolyMark (input.xbutton.x, input.xbutton.y,
                  polygon_ptr->n-1, polygon_ptr->vlist, &index))
            {
               point_deleted = TRUE;
               HighLightReverse ();
               if (obj_ptr->type == OBJ_POLY && poly_ptr->n == 2 ||
                     obj_ptr->type == OBJ_POLYGON && polygon_ptr->n == 4)
               {
                  CopySelToCut ();
                  DelObj (obj_ptr);
                  deleting = FALSE;
                  obj_ptr = NULL;
                  cfree (topSel);
                  topSel = botSel = NULL;
               }
               else
               {
                  switch (obj_ptr->type)
                  {
                     case OBJ_POLY:
                        n = poly_ptr->n;
                        for (i = index+1; i < n; i++)
                           poly_ptr->vlist[i-1] = poly_ptr->vlist[i];
                        poly_ptr->n--;
                        if (poly_ptr->curved)
                        {
                           cfree (poly_ptr->svlist);
                           poly_ptr->svlist = MakeSplinePolyVertex (
                                 &(poly_ptr->sn), drawOrigX, drawOrigY,
                                 poly_ptr->n, poly_ptr->vlist);
                        }
                        UpdPolyBBox (obj_ptr, poly_ptr->n, poly_ptr->vlist);
                        break;
                     case OBJ_POLYGON:
                        n = polygon_ptr->n;
                        for (i = index+1; i < n; i++)
                           polygon_ptr->vlist[i-1] = polygon_ptr->vlist[i];
                        polygon_ptr->n--;
                        n--;
                        if (index == 0)
                           polygon_ptr->vlist[n-1] = polygon_ptr->vlist[0];
                        if (polygon_ptr->curved)
                        {
                           cfree (polygon_ptr->svlist);
                           polygon_ptr->svlist = MakeSplinePolygonVertex (
                                 &(polygon_ptr->sn), drawOrigX, drawOrigY,
                                 polygon_ptr->n, polygon_ptr->vlist);
                        }
                        UpdPolyBBox (obj_ptr, polygon_ptr->n,
                              polygon_ptr->vlist);
                        break;
                  }
                  AdjObjBBox (obj_ptr);
               }
            }
            if (point_deleted)
            {
#ifndef UC
               XDrawString (mainDisplay, drawWindow, revDefaultGC, old_x+4,
#else /* UC */
               XDrawString (mainDisplay, drawWindow, revDefaultGC, old_x+OFFSET,
#endif /* UC */
                     old_y+defaultFontAsc, "DEL", 3);
               old_x = input.xbutton.x;
               old_y = input.xbutton.y;
               RedrawAnArea (botObj,
#ifndef UC
                     selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
                     selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
                     selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
                     selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
               HighLightForward ();
               if (obj_ptr != NULL)
#ifndef UC
                  XDrawString (mainDisplay, drawWindow, revDefaultGC, old_x+4,
#else /* UC */
                  XDrawString (mainDisplay, drawWindow, revDefaultGC, old_x+OFFSET,
#endif /* UC */
                        old_y+defaultFontAsc, "DEL", 3);
               UpdSelBBox ();
               SetFileModified (TRUE);
            }
         }
         else
         {
            deleting = FALSE;
            XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
                  old_x+4, old_y+defaultFontAsc, "DEL", 3);
#else /* UC */
                  old_x+OFFSET, old_y+defaultFontAsc, "DEL", 3);
#endif /* UC */
         }
      }
      else if (input.type == MotionNotify)
      {
         XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
               old_x+4, old_y+defaultFontAsc, "DEL", 3);
#else /* UC */
               old_x+OFFSET, old_y+defaultFontAsc, "DEL", 3);
#endif /* UC */
         old_x = input.xmotion.x;
         old_y = input.xmotion.y;
         XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
               old_x+4, old_y+defaultFontAsc, "DEL", 3);
#else /* UC */
               old_x+OFFSET, old_y+defaultFontAsc, "DEL", 3);
#endif /* UC */
         MarkRulers (old_x, old_y);
         while (XCheckMaskEvent (mainDisplay, PointerMotionMask, &ev)) ;
      }
   }
   XUngrabPointer (mainDisplay, CurrentTime);
   Msg ("");
}

static
void ContinueAddPolyPoint (ObjPtr, MouseX, MouseY, Index, PolyPtr,
      LastMouseX, LastMouseY)
   struct ObjRec	* ObjPtr;
   int			MouseX, MouseY, Index;
   struct PolyRec	* PolyPtr;
   int			* LastMouseX, * LastMouseY;
   /* (MouseX,MouseY) is the mouse's origin in screen offsets */
{
   int		n = PolyPtr->n;
   int		already_moved = FALSE, done = FALSE, before = FALSE;
   XPoint	* vs = PolyPtr->vlist, v[3];
   int		prev_x, prev_y, x, y, next_x, next_y, new_x, new_y;
   int		orig_x, orig_y, grid_x, grid_y, new_mouse_x, new_mouse_y;
   int		sel_ltx, sel_lty, sel_rbx, sel_rby, num = 0, i;
   double	prev_angle, next_angle, new_angle, theta_1, theta_2;
   XEvent	input, ev;

   MARK(OFFSET_X(vs[Index].x), OFFSET_Y(vs[Index].y));

   sel_ltx =  selLtX; sel_lty = selLtY;
   sel_rbx =  selRbX; sel_rby = selRbY;

   x = vs[Index].x;
   y = vs[Index].y;

   if (Index == 0)
   {
      next_x = vs[1].x;    next_y = vs[1].y;
      prev_x = 2*x-next_x; prev_y = 2*y-next_y;
   }
   else if (Index == n-1)
   {
      prev_x = vs[n-2].x;  prev_y = vs[n-2].y;
      next_x = 2*x-prev_x; next_y = 2*y-prev_y;
   }
   else
   {
      prev_x = vs[Index-1].x; prev_y = vs[Index-1].y;
      next_x = vs[Index+1].x; next_y = vs[Index+1].y;
   }
   prev_angle = atan2 ((double)(prev_y-y), (double)(prev_x-x));
   next_angle = atan2 ((double)(next_y-y), (double)(next_x-x));

   GridXY (MouseX, MouseY, &orig_x, &orig_y);
   new_mouse_x = MouseX; new_mouse_y = MouseY;
#ifndef UC
   XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+4,
#else /* UC */
   XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+OFFSET,
#endif /* UC */
         new_mouse_y+defaultFontAsc, "ADD", 3);

   while (!done)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == MotionNotify)
      {
#ifndef UC
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+4,
#else /* UC */
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+OFFSET,
#endif /* UC */
               new_mouse_y+defaultFontAsc, "ADD", 3);
         new_mouse_x = input.xmotion.x;
         new_mouse_y = input.xmotion.y;
#ifndef UC
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+4,
#else /* UC */
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+OFFSET,
#endif /* UC */
               new_mouse_y+defaultFontAsc, "ADD", 3);

         GridXY (new_mouse_x, new_mouse_y, &grid_x, &grid_y);
#ifndef UC
         new_x = ((new_mouse_x-MouseX)<<zoomScale) + x;
         new_y = ((new_mouse_y-MouseY)<<zoomScale) + y;
#else /* UC */
         new_x = (RealSize((new_mouse_x-MouseX), zoomScale)) + x;
         new_y = (RealSize((new_mouse_y-MouseY), zoomScale)) + y;
#endif /* UC */
         if (!already_moved)
         {
            already_moved = TRUE;

#ifndef UC
            new_angle = atan2 ((double)(new_y-y), (double)(new_x-x));
#else /* UC */
	    if ((new_y-y)||(new_x-x))
		new_angle = atan2 ((double)(new_y-y), (double)(new_x-x));
	    else
		new_angle = 0.0;
#endif /* UC */
            theta_1 = fabs (prev_angle - new_angle);
            theta_2 = fabs (next_angle - new_angle);
            if (theta_1 > M_PI) theta_1 = 2*M_PI-theta_1;
            if (theta_2 > M_PI) theta_2 = 2*M_PI-theta_2;
            before = (theta_1 <= theta_2);

            if (before)
            {  /* Add a point between the current and the previous point */
               if (Index == 0)
               {
                  num = 2;
                  v[0].x = OFFSET_X(x); v[0].y = OFFSET_Y(y);
                  v[1].x = OFFSET_X(x); v[1].y = OFFSET_Y(y);
               }
               else
               {
                  num = 3;
                  v[0].x = OFFSET_X(prev_x); v[0].y = OFFSET_Y(prev_y);
                  v[1].x = OFFSET_X(x);      v[1].y = OFFSET_Y(y);
                  v[2].x = OFFSET_X(x);      v[2].y = OFFSET_Y(y);
               }
            }
            else
            {  /* Add a point between the current and the next point */
               if (Index == n-1)
               {
                  num = 2;
                  v[0].x = OFFSET_X(x);      v[0].y = OFFSET_Y(y);
                  v[1].x = OFFSET_X(x);      v[1].y = OFFSET_Y(y);
               }
               else
               {
                  num = 3;
                  v[0].x = OFFSET_X(x);      v[0].y = OFFSET_Y(y);
                  v[1].x = OFFSET_X(x);      v[1].y = OFFSET_Y(y);
                  v[2].x = OFFSET_X(next_x); v[2].y = OFFSET_Y(next_y);
               }
            }
            MyDashedLine (drawWindow, revDefaultGC, v, num);
         }
         else
         {
            MyDashedLine (drawWindow, revDefaultGC, v, num);
            v[1].x = OFFSET_X(x) + grid_x - orig_x;
            v[1].y = OFFSET_Y(y) + grid_y - orig_y;
            MyDashedLine (drawWindow, revDefaultGC, v, num);
            MarkRulers (grid_x, grid_y);
         }
         while (XCheckMaskEvent (mainDisplay, PointerMotionMask, &ev)) ;
      }
      else if (input.type == ButtonRelease)
      {
         done = TRUE;
         *LastMouseX = new_mouse_x; *LastMouseY = new_mouse_y;
         MARK(OFFSET_X(vs[Index].x), OFFSET_Y(vs[Index].y));
#ifndef UC
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+4,
#else /* UC */
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+OFFSET,
#endif /* UC */
               new_mouse_y+defaultFontAsc, "ADD", 3);

         if (!already_moved)
            continue;
         else
         {
            MyDashedLine (drawWindow, revDefaultGC, v, num);
            if (grid_x == orig_x && grid_y == orig_y)
               continue;
         }

         HighLightReverse ();
         vs = (XPoint *) realloc (vs, (n+2)*sizeof(XPoint));
         if (vs == NULL)
         {
            printf ("Can not realloc () in ContinueAddPolyPoint ().\n");
            /* fool safe */ EmergencySave ();
         }
         PolyPtr->vlist = vs;
         if (before)
         {
            for (i = n-1; i >= Index; i--) vs[i+1] = vs[i];
#ifndef UC
            vs[Index].x = x + ((grid_x-orig_x)<<zoomScale);
            vs[Index].y = y + ((grid_y-orig_y)<<zoomScale);
#else /* UC */
            vs[Index].x = x + (RealSize((grid_x-orig_x), zoomScale));
            vs[Index].y = y + (RealSize((grid_y-orig_y), zoomScale));
#endif /* UC */
         }
         else
         {
            for (i = n-1; i > Index; i--) vs[i+1] = vs[i];
#ifndef UC
            vs[Index+1].x = x + ((grid_x-orig_x)<<zoomScale);
            vs[Index+1].y = y + ((grid_y-orig_y)<<zoomScale);
#else /* UC */
            vs[Index+1].x = x + (RealSize((grid_x-orig_x), zoomScale));
            vs[Index+1].y = y + (RealSize((grid_y-orig_y), zoomScale));
#endif /* UC */
         }
         PolyPtr->n++;
         n++;
         if (PolyPtr->curved)
         {
            cfree (PolyPtr->svlist);
            PolyPtr->svlist = MakeSplinePolyVertex (&(PolyPtr->sn),
                  drawOrigX, drawOrigY, PolyPtr->n, PolyPtr->vlist);
         }
         UpdPolyBBox (ObjPtr, PolyPtr->n, PolyPtr->vlist);
         AdjObjBBox (ObjPtr);

         UpdSelBBox ();
         RedrawAreas (botObj,
#ifndef UC
               sel_ltx-(1<<zoomScale), sel_lty-(1<<zoomScale),
               sel_rbx+(1<<zoomScale), sel_rby+(1<<zoomScale),
               selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
               selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
               sel_ltx-(RealSize(1, zoomScale)), sel_lty-(RealSize(1, zoomScale)),
               sel_rbx+(RealSize(1, zoomScale)), sel_rby+(RealSize(1, zoomScale)),
               selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
               selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
         HighLightForward ();
         SetFileModified (TRUE);
      }
   }
}

static
void ContinueAddPolygonPoint (ObjPtr, MouseX, MouseY, Index, PolygonPtr,
      LastMouseX, LastMouseY)
   struct ObjRec	* ObjPtr;
   int			MouseX, MouseY, Index;
   struct PolygonRec	* PolygonPtr;
   int			* LastMouseX, * LastMouseY;
   /* (MouseX,MouseY) is the mouse's origin in screen offsets */
{
   int		n = PolygonPtr->n;
   int		already_moved = FALSE, done = FALSE, before = FALSE;
   XPoint	* vs = PolygonPtr->vlist, v[3];
   int		prev_x, prev_y, x, y, next_x, next_y, new_x, new_y;
   int		orig_x, orig_y, grid_x, grid_y, new_mouse_x, new_mouse_y;
   int		sel_ltx, sel_lty, sel_rbx, sel_rby, i;
   double	prev_angle, next_angle, new_angle, theta_1, theta_2;
   XEvent	input, ev;

   MARK(OFFSET_X(vs[Index].x), OFFSET_Y(vs[Index].y));

   sel_ltx =  selLtX; sel_lty = selLtY;
   sel_rbx =  selRbX; sel_rby = selRbY;

   x = vs[Index].x;
   y = vs[Index].y;

   if (Index == 0 || Index == n-1)
   {
      next_x = vs[1].x;   next_y = vs[1].y;
      prev_x = vs[n-2].x; prev_y = vs[n-2].y;
   }
   else
   {
      prev_x = vs[Index-1].x; prev_y = vs[Index-1].y;
      next_x = vs[Index+1].x; next_y = vs[Index+1].y;
   }
   prev_angle = atan2 ((double)(prev_y-y), (double)(prev_x-x));
   next_angle = atan2 ((double)(next_y-y), (double)(next_x-x));

   GridXY (MouseX, MouseY, &orig_x, &orig_y);
   new_mouse_x = MouseX; new_mouse_y = MouseY;
#ifndef UC
   XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+4,
#else /* UC */
   XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+OFFSET,
#endif /* UC */
         new_mouse_y+defaultFontAsc, "ADD", 3);

   while (!done)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == MotionNotify)
      {
#ifndef UC
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+4,
#else /* UC */
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+OFFSET,
#endif /* UC */
               new_mouse_y+defaultFontAsc, "ADD", 3);
         new_mouse_x = input.xmotion.x;
         new_mouse_y = input.xmotion.y;
#ifndef UC
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+4,
#else /* UC */
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+OFFSET,
#endif /* UC */
               new_mouse_y+defaultFontAsc, "ADD", 3);

         GridXY (new_mouse_x, new_mouse_y, &grid_x, &grid_y);
#ifndef UC
         new_x = ((new_mouse_x-MouseX)<<zoomScale) + x;
         new_y = ((new_mouse_y-MouseY)<<zoomScale) + y;
#else /* UC */
         new_x = (RealSize((new_mouse_x-MouseX), zoomScale)) + x;
         new_y = (RealSize((new_mouse_y-MouseY), zoomScale)) + y;
#endif /* UC */
         if (!already_moved)
         {
            already_moved = TRUE;

#ifndef UC
            new_angle = atan2 ((double)(new_y-y), (double)(new_x-x));
#else /* UC */
	    if ((new_y-y)||(new_x-x))
		new_angle = atan2 ((double)(new_y-y), (double)(new_x-x));
	    else
		new_angle = 0.0;
#endif /* UC */
            theta_1 = fabs (prev_angle - new_angle);
            theta_2 = fabs (next_angle - new_angle);
            if (theta_1 > M_PI) theta_1 = 2*M_PI-theta_1;
            if (theta_2 > M_PI) theta_2 = 2*M_PI-theta_2;
            before = (theta_1 <= theta_2);

            if (before)
            {  /* Add a point between the current and the previous point */
               v[0].x = OFFSET_X(prev_x); v[0].y = OFFSET_Y(prev_y);
               v[1].x = OFFSET_X(x);      v[1].y = OFFSET_Y(y);
               v[2].x = OFFSET_X(x);      v[2].y = OFFSET_Y(y);
            }
            else
            {  /* Add a point between the current and the next point */
               v[0].x = OFFSET_X(x);      v[0].y = OFFSET_Y(y);
               v[1].x = OFFSET_X(x);      v[1].y = OFFSET_Y(y);
               v[2].x = OFFSET_X(next_x); v[2].y = OFFSET_Y(next_y);
            }
            MyDashedLine (drawWindow, revDefaultGC, v, 3);
         }
         else
         {
            MyDashedLine (drawWindow, revDefaultGC, v, 3);
            v[1].x = OFFSET_X(x) + grid_x - orig_x;
            v[1].y = OFFSET_Y(y) + grid_y - orig_y;
            MyDashedLine (drawWindow, revDefaultGC, v, 3);
            MarkRulers (grid_x, grid_y);
         }
         while (XCheckMaskEvent (mainDisplay, PointerMotionMask, &ev)) ;
      }
      else if (input.type == ButtonRelease)
      {
         done = TRUE;
         *LastMouseX = new_mouse_x; *LastMouseY = new_mouse_y;
         MARK(OFFSET_X(vs[Index].x), OFFSET_Y(vs[Index].y));
#ifndef UC
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+4,
#else /* UC */
         XDrawString (mainDisplay, drawWindow, revDefaultGC, new_mouse_x+OFFSET,
#endif /* UC */
               new_mouse_y+defaultFontAsc, "ADD", 3);

         if (!already_moved)
            continue;
         else
         {
            MyDashedLine (drawWindow, revDefaultGC, v, 3);
            if (grid_x == orig_x && grid_y == orig_y)
               continue;
         }

         HighLightReverse ();
         vs = (XPoint *) realloc (vs, (n+2)*sizeof(XPoint));
         if (vs == NULL)
         {
            printf ("Can not realloc () in ContinueAddPolygonPoint ().\n");
            /* fool safe */ EmergencySave ();
         }
         PolygonPtr->vlist = vs;
         if (Index == 0 || Index == n-1)
         {
            if (before)
            {
               vs[n].x = vs[n-1].x;
               vs[n].y = vs[n-1].y;
#ifndef UC
               vs[n-1].x = x + ((grid_x-orig_x)<<zoomScale);
               vs[n-1].y = y + ((grid_y-orig_y)<<zoomScale);
#else /* UC */
               vs[n-1].x = x + (RealSize((grid_x-orig_x), zoomScale));
               vs[n-1].y = y + (RealSize((grid_y-orig_y), zoomScale));
#endif /* UC */
            }
            else
            {
               for (i = n-1; i > 0; i--) vs[i+1] = vs[i];
#ifndef UC
               vs[1].x = x + ((grid_x-orig_x)<<zoomScale);
               vs[1].y = y + ((grid_y-orig_y)<<zoomScale);
#else /* UC */
               vs[1].x = x + (RealSize((grid_x-orig_x), zoomScale));
               vs[1].y = y + (RealSize((grid_y-orig_y), zoomScale));
#endif /* UC */
            }
         }
         else
         {
            if (before)
            {
               for (i = n-1; i >= Index; i--) vs[i+1] = vs[i];
#ifndef UC
               vs[Index].x = x + ((grid_x-orig_x)<<zoomScale);
               vs[Index].y = y + ((grid_y-orig_y)<<zoomScale);
#else /* UC */
               vs[Index].x = x + (RealSize((grid_x-orig_x), zoomScale));
               vs[Index].y = y + (RealSize((grid_y-orig_y), zoomScale));
#endif /* UC */
            }
            else
            {
               for (i = n-1; i > Index; i--) vs[i+1] = vs[i];
#ifndef UC
               vs[Index+1].x = x + ((grid_x-orig_x)<<zoomScale);
               vs[Index+1].y = y + ((grid_y-orig_y)<<zoomScale);
#else /* UC */
               vs[Index+1].x = x + (RealSize((grid_x-orig_x), zoomScale));
               vs[Index+1].y = y + (RealSize((grid_y-orig_y), zoomScale));
#endif /* UC */
            }
         }
         PolygonPtr->n++;
         n++;
         if (PolygonPtr->curved)
         {
            cfree (PolygonPtr->svlist);
            PolygonPtr->svlist = MakeSplinePolygonVertex (&(PolygonPtr->sn),
                  drawOrigX, drawOrigY, PolygonPtr->n, PolygonPtr->vlist);
         }
         UpdPolyBBox (ObjPtr, PolygonPtr->n, PolygonPtr->vlist);
         AdjObjBBox (ObjPtr);

         UpdSelBBox ();
         RedrawAreas (botObj,
#ifndef UC
               sel_ltx-(1<<zoomScale), sel_lty-(1<<zoomScale),
               sel_rbx+(1<<zoomScale), sel_rby+(1<<zoomScale),
               selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
               selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
               sel_ltx-(RealSize(1, zoomScale)), sel_lty-(RealSize(1, zoomScale)),
               sel_rbx+(RealSize(1, zoomScale)), sel_rby+(RealSize(1, zoomScale)),
               selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
               selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
         HighLightForward ();
         SetFileModified (TRUE);
      }
   }
}

void AddPoint ()
{
   register struct ObjRec	* obj_ptr;
   struct PolyRec		* poly_ptr = NULL;
   struct PolygonRec		* polygon_ptr = NULL;
   int				index, adding = TRUE;
   int				root_x, root_y, old_x, old_y;
   unsigned int			status;
   Window			root_win, child_win;
   XEvent			input, ev;

   if (!(topSel != NULL && topSel == botSel &&
         (topSel->obj->type == OBJ_POLY || topSel->obj->type == OBJ_POLYGON)))
   {
      Msg ("Please select only one POLY or POLYGON object.");
      return;
   }

   obj_ptr = topSel->obj;
   switch (obj_ptr->type)
   {
      case OBJ_POLY: poly_ptr = obj_ptr->detail.p; break;
      case OBJ_POLYGON: polygon_ptr = obj_ptr->detail.g; break;
   }
   TwoLineMsg ("Drag left mouse button to ADD points.",
         "Click other buttons to quit.");

   XGrabPointer (mainDisplay, drawWindow, False,
         PointerMotionMask | ButtonPressMask | ButtonReleaseMask,
         GrabModeAsync, GrabModeAsync, None, defaultCursor, CurrentTime);
   XQueryPointer (mainDisplay, drawWindow, &root_win, &child_win,
         &root_x, &root_y, &old_x, &old_y, &status);
   XSetFont (mainDisplay, revDefaultGC, defaultFontPtr->fid);
   XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
         old_x+4, old_y+defaultFontAsc, "ADD", 3);
#else /* UC */
         old_x+OFFSET, old_y+defaultFontAsc, "ADD", 3);
#endif /* UC */
   MarkRulers (old_x, old_y);

   while (adding)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonPress)
      {
         if (input.xbutton.button == Button1)
         {
            XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
                  old_x+4, old_y+defaultFontAsc, "ADD", 3);
#else /* UC */
                  old_x+OFFSET, old_y+defaultFontAsc, "ADD", 3);
#endif /* UC */
            if (obj_ptr->type == OBJ_POLY &&
                  PtInPolyMark (input.xbutton.x, input.xbutton.y,
                  poly_ptr->n, poly_ptr->vlist, &index))
               ContinueAddPolyPoint (obj_ptr, input.xbutton.x, input.xbutton.y,
                     index, poly_ptr, &old_x, &old_y);
            else if (obj_ptr->type == OBJ_POLYGON &&
                  PtInPolyMark (input.xbutton.x, input.xbutton.y,
                  polygon_ptr->n-1, polygon_ptr->vlist, &index))
               ContinueAddPolygonPoint (obj_ptr, input.xbutton.x,
                     input.xbutton.y, index, polygon_ptr, &old_x, &old_y);
            XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
                  old_x+4, old_y+defaultFontAsc, "ADD", 3);
#else /* UC */
                  old_x+OFFSET, old_y+defaultFontAsc, "ADD", 3);
#endif /* UC */
         }
         else
         {
            adding = FALSE;
            XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
                  old_x+4, old_y+defaultFontAsc, "ADD", 3);
#else /* UC */
                  old_x+OFFSET, old_y+defaultFontAsc, "ADD", 3);
#endif /* UC */
         }
      }
      else if (input.type == MotionNotify)
      {
         XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
               old_x+4, old_y+defaultFontAsc, "ADD", 3);
#else /* UC */
               old_x+OFFSET, old_y+defaultFontAsc, "ADD", 3);
#endif /* UC */
         old_x = input.xmotion.x;
         old_y = input.xmotion.y;
         XDrawString (mainDisplay, drawWindow, revDefaultGC,
#ifndef UC
               old_x+4, old_y+defaultFontAsc, "ADD", 3);
#else /* UC */
               old_x+OFFSET, old_y+defaultFontAsc, "ADD", 3);
#endif /* UC */
         MarkRulers (old_x, old_y);
         while (XCheckMaskEvent (mainDisplay, PointerMotionMask, &ev)) ;
      }
   }
   XUngrabPointer (mainDisplay, CurrentTime);
   Msg ("");
}

void EditMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid;

   DefaultColorArrays (MAXEDITMENUS, &fore_colors, &valid);
   index = TextMenuLoop (X, Y, editMenuStr, MAXEDITMENUS, fore_colors, valid,
#ifndef UC
         SINGLECOLOR);
#else /* UC */
         SINGLECOLOR, MENU_EDIT);
#endif /* UC */

   switch (index)
   {
      case EDIT_REDRAW: ClearAndRedrawDrawWindow (); break;
      case EDIT_DUP: DupSelObj (); break;
      case EDIT_DELETE: DelAllSelObj (); break;
      case EDIT_SELALL: SelAllObj (); break;
      case EDIT_UNDODEL: UndoDelete (); break;
      case EDIT_DEL_POINT: DeletePoint (); break;
      case EDIT_ADD_POINT: AddPoint (); break;
      case EDIT_COPY: CopyToCutBuffer (); break;
      case EDIT_PASTE: PasteFromCutBuffer (); break;
      case EDIT_INV_XBM: InvertXBitmaps (); break;
   }
}

void FrontProc ()
{
   if (topSel != NULL)
   {
      HighLightReverse ();
      MoveSelToTop ();
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
      SetFileModified (TRUE);
   }
}

void BackProc ()
{
   if (topSel != NULL)
   {
      HighLightReverse ();
      MoveSelToBot ();
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
      SetFileModified (TRUE);
   }
}

#define ARRANGE_FRONT 0
#define ARRANGE_BACK 1
#define ARRANGE_GROUP 2
#define ARRANGE_UNGROUP 3
#define ARRANGE_ALIGNOBJ 4
#define ARRANGE_ALIGNGRID 5
#define FLIP_HORIZONTAL 6
#define FLIP_VERTICAL 7
#define ROTATE_CLOCKWISE 8
#define ROTATE_COUNTER 9
#define MAXARRANGEMENUS 10

static char * arrangeMenuStr[] =
      { "Front           ^F",
        "Back            ^B",
        "Group           ^G",
        "UnGroup         ^U",
        "AlignObjs       ^L",
        "AlignToGrid     ^T",
        "FlipHorizontal  #H",
        "FlipVertical    #V",
        "RotateClockWise #W",
        "RotateCounter   #C",
      };

void ArrangeMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid;

   DefaultColorArrays (MAXARRANGEMENUS, &fore_colors, &valid);
   index = TextMenuLoop (X, Y, arrangeMenuStr, MAXARRANGEMENUS, fore_colors,
#ifndef UC
         valid, SINGLECOLOR);
#else /* UC */
         valid, SINGLECOLOR, MENU_ARRANGE);
#endif /* UC */
   switch (index)
   {
      case ARRANGE_FRONT: FrontProc (); break;
      case ARRANGE_BACK: BackProc (); break;
      case ARRANGE_GROUP: GroupSelObj (); break;
      case ARRANGE_UNGROUP: UngroupSelObj (); break;
      case ARRANGE_ALIGNOBJ: AlignSelObjs (); break;
      case ARRANGE_ALIGNGRID: AlignSelToGrid (); break;
      case FLIP_HORIZONTAL: FlipHorizontal (); break;
      case FLIP_VERTICAL: FlipVertical (); break;
      case ROTATE_CLOCKWISE: RotateClockWise (); break;
      case ROTATE_COUNTER: RotateCounter (); break;
   }
}

static struct ObjRec	* tmpTopObj, * tmpBotObj;
static struct SelRec	* tmpTopSel, * tmpBotSel;

static
void PushTmpSel (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   struct SelRec	* sel_ptr;

   ObjPtr->next = tmpTopObj;
   ObjPtr->prev = NULL;

   sel_ptr = (struct SelRec *) calloc (1, sizeof (struct SelRec));
   sel_ptr->next = tmpTopSel;
   sel_ptr->prev = NULL;
   sel_ptr->obj = ObjPtr;

   if (tmpTopObj == NULL)
   {
      tmpBotObj = ObjPtr;
      tmpBotSel = sel_ptr;
   }
   else
   {
      tmpTopObj->prev = ObjPtr;
      tmpTopSel->prev = sel_ptr;
   }
   tmpTopObj = ObjPtr;
   tmpTopSel = sel_ptr;
}

void UpdateSymbols ()
{
   int			dx = 0, dy = 0, changed = FALSE;
   char			path_name[MAXPATHLENGTH], sym_name[MAXPATHLENGTH];
   struct ObjRec	* obj_ptr, * new_obj_ptr;
   struct SelRec	* sel_ptr;

   if (topSel == NULL) return;

   tmpTopObj = tmpBotObj = NULL;
   tmpTopSel = tmpBotSel = NULL;

   HighLightReverse ();

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      if (obj_ptr->type != OBJ_ICON) continue;

      strcpy (sym_name, obj_ptr->detail.r->s);
      if (GetSymbolPath (obj_ptr->detail.r->s, path_name))
      {
         if ((new_obj_ptr = GetObjRepresentation (path_name, sym_name)) != NULL)
         {
            switch (horiAlign)
            {
               case ALIGN_L:
                  dx = obj_ptr->obbox.ltx - new_obj_ptr->obbox.ltx;
                  break;
               case ALIGN_N:
               case ALIGN_C:
                  dx = (int)(((obj_ptr->obbox.ltx+obj_ptr->obbox.rbx) -
                        (new_obj_ptr->obbox.ltx+new_obj_ptr->obbox.rbx))/2);
                  break;
               case ALIGN_R:
                  dx = obj_ptr->obbox.rbx - new_obj_ptr->obbox.rbx;
                  break;
            }
            switch (vertAlign)
            {
               case ALIGN_T:
                  dy = obj_ptr->obbox.lty - new_obj_ptr->obbox.lty;
                  break;
               case ALIGN_N:
               case ALIGN_M:
                  dy = (int)(((obj_ptr->obbox.lty+obj_ptr->obbox.rby) -
                        (new_obj_ptr->obbox.lty+new_obj_ptr->obbox.rby))/2);
                  break;
               case ALIGN_B:
                  dy = obj_ptr->obbox.rby - new_obj_ptr->obbox.rby;
                  break;
            }
            MoveObj (new_obj_ptr, dx, dy);

            changed = TRUE;

            UnlinkObj (obj_ptr);
            PushTmpSel (obj_ptr);
            CopyAndUpdateAttrs (new_obj_ptr, obj_ptr);

            if (new_obj_ptr->bbox.ltx < selLtX) selLtX = new_obj_ptr->bbox.ltx;
            if (new_obj_ptr->bbox.lty < selLtY) selLtY = new_obj_ptr->bbox.lty;
            if (new_obj_ptr->bbox.rbx < selRbX) selRbX = new_obj_ptr->bbox.rbx;
            if (new_obj_ptr->bbox.rby < selRbY) selRbY = new_obj_ptr->bbox.rby;
            if (new_obj_ptr->obbox.ltx < selObjLtX)
                  selObjLtX = new_obj_ptr->obbox.ltx;
            if (new_obj_ptr->obbox.lty < selObjLtY)
                  selObjLtY = new_obj_ptr->obbox.lty;
            if (new_obj_ptr->obbox.rbx < selObjRbX)
                  selObjRbX = new_obj_ptr->obbox.rbx;
            if (new_obj_ptr->obbox.rby < selObjRbY)
                  selObjRbY = new_obj_ptr->obbox.rby;

            sel_ptr->obj = new_obj_ptr;
            AddObj (NULL, topObj, new_obj_ptr);
         }
      }
   }

   PushToCutBuffer (tmpTopSel, tmpBotSel);

   if (changed)
   {
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      UpdSelBBox ();
      SetFileModified (TRUE);
      justDupped = FALSE;
   }
   HighLightForward ();
}
