/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kna/tangram/u/william/X11/TGIF2/RCS/font.c,v 2.0 91/03/05 12:47:17 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "color.e"
#ifdef UC
#include "cursor.e"
#endif /* UC */
#include "drawing.e"
#include "mark.e"
#include "menu.e"
#include "obj.e"
#include "pattern.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "text.e"
#ifdef KINPUT
#include "kconvert.e"
#endif /* KINPUT */
#ifdef KANJI
#include "file.e"
#endif /* KANJI */

#ifndef KANJI
#define FONTS_PER_DPI (((MAXFONTS-1)*MAXFONTSTYLES+1)*MAXFONTSIZES)
#define FONTTABLESIZE (MAXFONTDPIS*FONTS_PER_DPI)
#else /* KANJI */
#define FONTS_PER_DPI (((MAXKANJIFONTS-3)*MAXFONTSTYLES+3)*MAXFONTSIZES)
#define FONTTABLESIZE (MAXFONTDPIS*FONTS_PER_DPI)
#endif /* KANJI */

#define COUR8R_75  FontIndex(FONT_DPI_75,FONT_COU,0,STYLE_NR)
#define COUR10R_75 FontIndex(FONT_DPI_75,FONT_COU,1,STYLE_NR)
#define COUR12R_75 FontIndex(FONT_DPI_75,FONT_COU,2,STYLE_NR)
#define COUR14R_75 FontIndex(FONT_DPI_75,FONT_COU,3,STYLE_NR)
#define COUR18R_75 FontIndex(FONT_DPI_75,FONT_COU,4,STYLE_NR)
#define COUR24R_75 FontIndex(FONT_DPI_75,FONT_COU,5,STYLE_NR)

#define COUR11R_100 FontIndex(FONT_DPI_100,FONT_COU,0,STYLE_NR)
#define COUR14R_100 FontIndex(FONT_DPI_100,FONT_COU,1,STYLE_NR)
#define COUR17R_100 FontIndex(FONT_DPI_100,FONT_COU,2,STYLE_NR)
#define COUR20R_100 FontIndex(FONT_DPI_100,FONT_COU,3,STYLE_NR)
#define COUR25R_100 FontIndex(FONT_DPI_100,FONT_COU,4,STYLE_NR)
#define COUR34R_100 FontIndex(FONT_DPI_100,FONT_COU,5,STYLE_NR)

#ifndef KANJI
struct MyFontRec {
   XFontStruct	* xfs;
   int		valid;
};
#else /* KANJI */
struct MyKanjiFontRec {
   XFontStruct	* xfs_kanji;
   XFontStruct	* xfs;
   int		valid, fake;
};

XFontStruct	* canvasKanjiFontPtr;
int		canvasKanjiFontIsFake = FALSE;

#define MINC8  0
#define MINC10 1
#define MINC12 2
#define MINC14 3
#define MINC18 4
#define MINC24 5

#define GOTH8  6
#define GOTH10 7
#define GOTH12 8
#define GOTH14 9
#define GOTH18 10
#define GOTH24 11

struct Use16as18Rec Use16as18 = {TRUE, TRUE};
int 		UseMinchoAsGothic[] = {TRUE, TRUE, TRUE, TRUE, TRUE, TRUE};
static int 	Warning = FALSE;
char		serverHostName [30];
#endif /* KANJI */

XFontStruct	* canvasFontPtr;
int	canvasFontHeight;
int	canvasFontAsc;
int	canvasFontDes;

int	canvasFontIndex;

XFontStruct	* rulerFontPtr;
int	rulerFontWidth;
int	rulerFontHeight;
int	rulerFontAsc;
int	rulerFontDes;

XFontStruct	* defaultFontPtr;
int	defaultFontWidth;
int	defaultFontHeight;
int	defaultFontAsc;
int	defaultFontDes;

int	* pointSize;
int	curFont = FONT_COU;
int	curSize = 4;
int	curStyle = STYLE_NR;
int	curFontDPI = FONT_DPI_75;
int	curRotate = ROTATE0;

int	pointSize75[] = { 8, 10, 12, 14, 18, 24 };
int	pointSize100[] = { 11, 14, 17, 20, 25, 34 };

#ifndef KANJI
static struct MyFontRec	myFontInfo[FONTTABLESIZE];
#else /* KANJI */
static struct MyKanjiFontRec	myFontInfo[FONTTABLESIZE];
#endif /* KANJI */

#ifndef KANJI
static char	* fontMenuStr[] =
{
   "Times", "Courier", "Helvetica", "NewCentury", "Symbol"
};
#else /* KANJI  */
static char	* fontMenuStr[] =
{
   "Times", "Courier", "Helvetica", "NewCentury", "Symbol"
};
static char	* kanjiFontMenuStr[] =
{
   "Times", "Courier", "Helvetica", "NewCentury", "Symbol", "Minchou", "Gothic"
};
#endif /* KANJI */
static char	* fontDPIMenuStr[] = { "75dpi", "100dpi" };
static char	* * sizeMenuStr;
static char	* sizeMenuStr75[] =
{
   "8  #0",
   "10 #1",
   "12 #2",
   "14 #3",
   "18 #4",
   "24 #5"
};
static char	* sizeMenuStr100[] =
{
   "11 #0",
   "14 #1",
   "17 #2",
   "20 #3",
   "25 #4",
   "34 #5"
};
static char	* styleMenuStr[] =
{
   "Roman      ^#O",
   "Bold       ^#B",
   "Italic     ^#T",
   "BoldItalic ^#P",
   "--------------",
   "Left       ^#L",
   "Center     ^#C",
   "Right      ^#R"
};

#ifdef KANJI
struct MyKanjiFontNameRec {
	char * kanjiFontName;
	char * ankFontName;
};

static struct MyKanjiFontNameRec kanjiFontNameStr[] =
{
/* 75 dpi */
/* MINCHO */
    "",
    "-adobe-times-medium-r-normal--8-80-75-75-p-44-iso8859-1",   /* 8 */
    "",
    "-adobe-times-medium-r-normal--10-100-75-75-p-54-iso8859-1", /* 10 */
    "",
    "-adobe-times-medium-r-normal--12-120-75-75-p-64-iso8859-1", /* 12 */
    "k14",
    "-adobe-times-medium-r-normal--14-140-75-75-p-74-iso8859-1", /* 14 */
    "neck16",
    "-adobe-times-medium-r-normal--18-180-75-75-p-94-iso8859-1", /* 18 */
    "neck24",
    "-adobe-times-medium-r-normal--24-240-75-75-p-124-iso8859-1",/* 24 */
/* GOTHIC */
    "",
    "-adobe-helvetica-medium-r-normal--8-80-75-75-p-46-iso8859-1",
    "",
    "-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1",
    "",
    "-adobe-helvetica-medium-r-normal--12-120-75-75-p-67-iso8859-1",
    "",
    "-adobe-helvetica-medium-r-normal--14-140-75-75-p-77-iso8859-1",
    "",
    "-adobe-helvetica-medium-r-normal--18-180-75-75-p-98-iso8859-1",
    "",
    "-adobe-helvetica-medium-r-normal--24-240-75-75-p-130-iso8859-1"
};
#endif /* KANJI */
static char	* fontNameStr[] =
{
/* 75 dpi fonts */
  "-adobe-times-medium-r-normal--8-80-75-75-p-44-iso8859-1",
  "-adobe-times-medium-r-normal--10-100-75-75-p-54-iso8859-1",
  "-adobe-times-medium-r-normal--12-120-75-75-p-64-iso8859-1",
  "-adobe-times-medium-r-normal--14-140-75-75-p-74-iso8859-1",
  "-adobe-times-medium-r-normal--18-180-75-75-p-94-iso8859-1",
  "-adobe-times-medium-r-normal--24-240-75-75-p-124-iso8859-1",
  "-adobe-times-bold-r-normal--8-80-75-75-p-47-iso8859-1",
  "-adobe-times-bold-r-normal--10-100-75-75-p-57-iso8859-1",
  "-adobe-times-bold-r-normal--12-120-75-75-p-67-iso8859-1",
  "-adobe-times-bold-r-normal--14-140-75-75-p-77-iso8859-1",
  "-adobe-times-bold-r-normal--18-180-75-75-p-99-iso8859-1",
  "-adobe-times-bold-r-normal--24-240-75-75-p-132-iso8859-1",
  "-adobe-times-medium-i-normal--8-80-75-75-p-42-iso8859-1",
  "-adobe-times-medium-i-normal--10-100-75-75-p-52-iso8859-1",
  "-adobe-times-medium-i-normal--12-120-75-75-p-63-iso8859-1",
  "-adobe-times-medium-i-normal--14-140-75-75-p-73-iso8859-1",
  "-adobe-times-medium-i-normal--18-180-75-75-p-94-iso8859-1",
  "-adobe-times-medium-i-normal--24-240-75-75-p-125-iso8859-1",
  "-adobe-times-bold-i-normal--8-80-75-75-p-47-iso8859-1",
  "-adobe-times-bold-i-normal--10-100-75-75-p-57-iso8859-1",
  "-adobe-times-bold-i-normal--12-120-75-75-p-68-iso8859-1",
  "-adobe-times-bold-i-normal--14-140-75-75-p-77-iso8859-1",
  "-adobe-times-bold-i-normal--18-180-75-75-p-98-iso8859-1",
  "-adobe-times-bold-i-normal--24-240-75-75-p-128-iso8859-1",

  "-adobe-courier-medium-r-normal--8-80-75-75-m-50-iso8859-1",
  "-adobe-courier-medium-r-normal--10-100-75-75-m-60-iso8859-1",
  "-adobe-courier-medium-r-normal--12-120-75-75-m-70-iso8859-1",
  "-adobe-courier-medium-r-normal--14-140-75-75-m-90-iso8859-1",
  "-adobe-courier-medium-r-normal--18-180-75-75-m-110-iso8859-1",
  "-adobe-courier-medium-r-normal--24-240-75-75-m-150-iso8859-1",
  "-adobe-courier-bold-r-normal--8-80-75-75-m-50-iso8859-1",
  "-adobe-courier-bold-r-normal--10-100-75-75-m-60-iso8859-1",
  "-adobe-courier-bold-r-normal--12-120-75-75-m-70-iso8859-1",
  "-adobe-courier-bold-r-normal--14-140-75-75-m-90-iso8859-1",
  "-adobe-courier-bold-r-normal--18-180-75-75-m-110-iso8859-1",
  "-adobe-courier-bold-r-normal--24-240-75-75-m-150-iso8859-1",
  "-adobe-courier-medium-o-normal--8-80-75-75-m-50-iso8859-1",
  "-adobe-courier-medium-o-normal--10-100-75-75-m-60-iso8859-1",
  "-adobe-courier-medium-o-normal--12-120-75-75-m-70-iso8859-1",
  "-adobe-courier-medium-o-normal--14-140-75-75-m-90-iso8859-1",
  "-adobe-courier-medium-o-normal--18-180-75-75-m-110-iso8859-1",
  "-adobe-courier-medium-o-normal--24-240-75-75-m-150-iso8859-1",
  "-adobe-courier-bold-o-normal--8-80-75-75-m-50-iso8859-1",
  "-adobe-courier-bold-o-normal--10-100-75-75-m-60-iso8859-1",
  "-adobe-courier-bold-o-normal--12-120-75-75-m-70-iso8859-1",
  "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1",
  "-adobe-courier-bold-o-normal--18-180-75-75-m-110-iso8859-1",
  "-adobe-courier-bold-o-normal--24-240-75-75-m-150-iso8859-1",

  "-adobe-helvetica-medium-r-normal--8-80-75-75-p-46-iso8859-1",
  "-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1",
  "-adobe-helvetica-medium-r-normal--12-120-75-75-p-67-iso8859-1",
  "-adobe-helvetica-medium-r-normal--14-140-75-75-p-77-iso8859-1",
  "-adobe-helvetica-medium-r-normal--18-180-75-75-p-98-iso8859-1",
  "-adobe-helvetica-medium-r-normal--24-240-75-75-p-130-iso8859-1",
  "-adobe-helvetica-bold-r-normal--8-80-75-75-p-50-iso8859-1",
  "-adobe-helvetica-bold-r-normal--10-100-75-75-p-60-iso8859-1",
  "-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1",
  "-adobe-helvetica-bold-r-normal--14-140-75-75-p-82-iso8859-1",
  "-adobe-helvetica-bold-r-normal--18-180-75-75-p-103-iso8859-1",
  "-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1",
  "-adobe-helvetica-medium-o-normal--8-80-75-75-p-47-iso8859-1",
  "-adobe-helvetica-medium-o-normal--10-100-75-75-p-57-iso8859-1",
  "-adobe-helvetica-medium-o-normal--12-120-75-75-p-67-iso8859-1",
  "-adobe-helvetica-medium-o-normal--14-140-75-75-p-78-iso8859-1",
  "-adobe-helvetica-medium-o-normal--18-180-75-75-p-98-iso8859-1",
  "-adobe-helvetica-medium-o-normal--24-240-75-75-p-130-iso8859-1",
  "-adobe-helvetica-bold-o-normal--8-80-75-75-p-50-iso8859-1",
  "-adobe-helvetica-bold-o-normal--10-100-75-75-p-60-iso8859-1",
  "-adobe-helvetica-bold-o-normal--12-120-75-75-p-69-iso8859-1",
  "-adobe-helvetica-bold-o-normal--14-140-75-75-p-82-iso8859-1",
  "-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1",
  "-adobe-helvetica-bold-o-normal--24-240-75-75-p-138-iso8859-1",

  "-adobe-new century schoolbook-medium-r-normal--8-80-75-75-p-50-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--10-100-75-75-p-60-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--12-120-75-75-p-70-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--14-140-75-75-p-82-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--18-180-75-75-p-103-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--24-240-75-75-p-137-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--8-80-75-75-p-56-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--10-100-75-75-p-66-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--12-120-75-75-p-77-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--14-140-75-75-p-87-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--18-180-75-75-p-113-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--24-240-75-75-p-149-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--8-80-75-75-p-50-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--10-100-75-75-p-60-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--12-120-75-75-p-70-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--14-140-75-75-p-81-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--18-180-75-75-p-104-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--24-240-75-75-p-136-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--8-80-75-75-p-56-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--10-100-75-75-p-66-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--12-120-75-75-p-76-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--14-140-75-75-p-88-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--18-180-75-75-p-111-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--24-240-75-75-p-148-iso8859-1",

  "-adobe-symbol-medium-r-normal--8-80-75-75-p-51-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--10-100-75-75-p-61-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--12-120-75-75-p-74-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--14-140-75-75-p-85-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--18-180-75-75-p-107-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--24-240-75-75-p-142-adobe-fontspecific",
#ifdef KANJI
  (char *) &kanjiFontNameStr[MINC8],
  (char *) &kanjiFontNameStr[MINC10],
  (char *) &kanjiFontNameStr[MINC12],
  (char *) &kanjiFontNameStr[MINC14],
  (char *) &kanjiFontNameStr[MINC18],
  (char *) &kanjiFontNameStr[MINC24],

  (char *) &kanjiFontNameStr[GOTH8],
  (char *) &kanjiFontNameStr[GOTH10],
  (char *) &kanjiFontNameStr[GOTH12],
  (char *) &kanjiFontNameStr[GOTH14],
  (char *) &kanjiFontNameStr[GOTH18],
  (char *) &kanjiFontNameStr[GOTH24],
#endif /* KANJI */

/* 100 dpi fonts */
  "-adobe-times-medium-r-normal--11-80-100-100-p-54-iso8859-1",
  "-adobe-times-medium-r-normal--14-100-100-100-p-74-iso8859-1",
  "-adobe-times-medium-r-normal--17-120-100-100-p-84-iso8859-1",
  "-adobe-times-medium-r-normal--20-140-100-100-p-96-iso8859-1",
  "-adobe-times-medium-r-normal--25-180-100-100-p-125-iso8859-1",
  "-adobe-times-medium-r-normal--34-240-100-100-p-170-iso8859-1",
  "-adobe-times-bold-r-normal--11-80-100-100-p-57-iso8859-1",
  "-adobe-times-bold-r-normal--14-100-100-100-p-76-iso8859-1",
  "-adobe-times-bold-r-normal--17-120-100-100-p-88-iso8859-1",
  "-adobe-times-bold-r-normal--20-140-100-100-p-100-iso8859-1",
  "-adobe-times-bold-r-normal--25-180-100-100-p-132-iso8859-1",
  "-adobe-times-bold-r-normal--34-240-100-100-p-177-iso8859-1",
  "-adobe-times-medium-i-normal--11-80-100-100-p-52-iso8859-1",
  "-adobe-times-medium-i-normal--14-100-100-100-p-73-iso8859-1",
  "-adobe-times-medium-i-normal--17-120-100-100-p-84-iso8859-1",
  "-adobe-times-medium-i-normal--20-140-100-100-p-94-iso8859-1",
  "-adobe-times-medium-i-normal--25-180-100-100-p-125-iso8859-1",
  "-adobe-times-medium-i-normal--34-240-100-100-p-168-iso8859-1",
  "-adobe-times-bold-i-normal--11-80-100-100-p-57-iso8859-1",
  "-adobe-times-bold-i-normal--14-100-100-100-p-77-iso8859-1",
  "-adobe-times-bold-i-normal--17-120-100-100-p-86-iso8859-1",
  "-adobe-times-bold-i-normal--20-140-100-100-p-98-iso8859-1",
  "-adobe-times-bold-i-normal--25-180-100-100-p-128-iso8859-1",
  "-adobe-times-bold-i-normal--34-240-100-100-p-170-iso8859-1",

  "-adobe-courier-medium-r-normal--11-80-100-100-m-60-iso8859-1",
  "-adobe-courier-medium-r-normal--14-100-100-100-m-90-iso8859-1",
  "-adobe-courier-medium-r-normal--17-120-100-100-m-100-iso8859-1",
  "-adobe-courier-medium-r-normal--20-140-100-100-m-110-iso8859-1",
  "-adobe-courier-medium-r-normal--25-180-100-100-m-150-iso8859-1",
  "-adobe-courier-medium-r-normal--34-240-100-100-m-200-iso8859-1",
  "-adobe-courier-bold-r-normal--11-80-100-100-m-60-iso8859-1",
  "-adobe-courier-bold-r-normal--14-100-100-100-m-90-iso8859-1",
  "-adobe-courier-bold-r-normal--17-120-100-100-m-100-iso8859-1",
  "-adobe-courier-bold-r-normal--20-140-100-100-m-110-iso8859-1",
  "-adobe-courier-bold-r-normal--25-180-100-100-m-150-iso8859-1",
  "-adobe-courier-bold-r-normal--34-240-100-100-m-200-iso8859-1",
  "-adobe-courier-medium-o-normal--11-80-100-100-m-60-iso8859-1",
  "-adobe-courier-medium-o-normal--14-100-100-100-m-90-iso8859-1",
  "-adobe-courier-medium-o-normal--17-120-100-100-m-100-iso8859-1",
  "-adobe-courier-medium-o-normal--20-140-100-100-m-110-iso8859-1",
  "-adobe-courier-medium-o-normal--25-180-100-100-m-150-iso8859-1",
  "-adobe-courier-medium-o-normal--34-240-100-100-m-200-iso8859-1",
  "-adobe-courier-bold-o-normal--11-80-100-100-m-60-iso8859-1",
  "-adobe-courier-bold-o-normal--14-100-100-100-m-90-iso8859-1",
  "-adobe-courier-bold-o-normal--17-120-100-100-m-100-iso8859-1",
  "-adobe-courier-bold-o-normal--20-140-100-100-m-110-iso8859-1",
  "-adobe-courier-bold-o-normal--25-180-100-100-m-150-iso8859-1",
  "-adobe-courier-bold-o-normal--34-240-100-100-m-200-iso8859-1",

  "-adobe-helvetica-medium-r-normal--11-80-100-100-p-56-iso8859-1",
  "-adobe-helvetica-medium-r-normal--14-100-100-100-p-76-iso8859-1",
  "-adobe-helvetica-medium-r-normal--17-120-100-100-p-88-iso8859-1",
  "-adobe-helvetica-medium-r-normal--20-140-100-100-p-100-iso8859-1",
  "-adobe-helvetica-medium-r-normal--25-180-100-100-p-130-iso8859-1",
  "-adobe-helvetica-medium-r-normal--34-240-100-100-p-176-iso8859-1",
  "-adobe-helvetica-bold-r-normal--11-80-100-100-p-60-iso8859-1",
  "-adobe-helvetica-bold-r-normal--14-100-100-100-p-82-iso8859-1",
  "-adobe-helvetica-bold-r-normal--17-120-100-100-p-92-iso8859-1",
  "-adobe-helvetica-bold-r-normal--20-140-100-100-p-105-iso8859-1",
  "-adobe-helvetica-bold-r-normal--25-180-100-100-p-138-iso8859-1",
  "-adobe-helvetica-bold-r-normal--34-240-100-100-p-182-iso8859-1",
  "-adobe-helvetica-medium-o-normal--11-80-100-100-p-57-iso8859-1",
  "-adobe-helvetica-medium-o-normal--14-100-100-100-p-78-iso8859-1",
  "-adobe-helvetica-medium-o-normal--17-120-100-100-p-88-iso8859-1",
  "-adobe-helvetica-medium-o-normal--20-140-100-100-p-98-iso8859-1",
  "-adobe-helvetica-medium-o-normal--25-180-100-100-p-130-iso8859-1",
  "-adobe-helvetica-medium-o-normal--34-240-100-100-p-176-iso8859-1",
  "-adobe-helvetica-bold-o-normal--11-80-100-100-p-60-iso8859-1",
  "-adobe-helvetica-bold-o-normal--14-100-100-100-p-82-iso8859-1",
  "-adobe-helvetica-bold-o-normal--17-120-100-100-p-92-iso8859-1",
  "-adobe-helvetica-bold-o-normal--20-140-100-100-p-103-iso8859-1",
  "-adobe-helvetica-bold-o-normal--25-180-100-100-p-138-iso8859-1",
  "-adobe-helvetica-bold-o-normal--34-240-100-100-p-182-iso8859-1",

  "-adobe-new century schoolbook-medium-r-normal--11-80-100-100-p-60-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--14-100-100-100-p-82-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--17-120-100-100-p-91-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--20-140-100-100-p-103-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--25-180-100-100-p-136-iso8859-1",
  "-adobe-new century schoolbook-medium-r-normal--34-240-100-100-p-181-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--11-80-100-100-p-66-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--14-100-100-100-p-87-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--17-120-100-100-p-99-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--20-140-100-100-p-113-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--25-180-100-100-p-149-iso8859-1",
  "-adobe-new century schoolbook-bold-r-normal--34-240-100-100-p-193-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--11-80-100-100-p-60-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--14-100-100-100-p-81-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--17-120-100-100-p-92-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--20-140-100-100-p-104-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--25-180-100-100-p-136-iso8859-1",
  "-adobe-new century schoolbook-medium-i-normal--34-240-100-100-p-182-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--11-80-100-100-p-66-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--14-100-100-100-p-88-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--17-120-100-100-p-99-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--20-140-100-100-p-111-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--25-180-100-100-p-148-iso8859-1",
  "-adobe-new century schoolbook-bold-i-normal--34-240-100-100-p-193-iso8859-1",

  "-adobe-symbol-medium-r-normal--11-80-100-100-p-61-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--14-100-100-100-p-85-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--17-120-100-100-p-95-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--20-140-100-100-p-107-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--25-180-100-100-p-142-adobe-fontspecific",
  "-adobe-symbol-medium-r-normal--34-240-100-100-p-191-adobe-fontspecific"
};

XFontStruct * GetFontStruct (font_index)
   register int	font_index;
{
   return (myFontInfo[font_index].xfs);
}

int FontIndex (dpi_index, font_index, size_index, style_index)
   register int	dpi_index, font_index, size_index, style_index;
{
   if (font_index == FONT_SYM)
      return (size_index+MAXFONTSIZES*(MAXFONTSTYLES*font_index) +
            dpi_index*FONTS_PER_DPI);
#ifdef KANJI
   else if (font_index == FONT_MIN)
      return (size_index+MAXFONTSIZES*(MAXFONTSTYLES*font_index - 3) +
            dpi_index*FONTS_PER_DPI);
   else if (font_index == FONT_GOT)
      return (size_index+MAXFONTSIZES*(MAXFONTSTYLES*font_index - 6) +
            dpi_index*FONTS_PER_DPI);
#endif /* KANJI */   
   else
      return (size_index+MAXFONTSIZES*(style_index+MAXFONTSTYLES*font_index) +
            dpi_index*FONTS_PER_DPI);
}

void SetCanvasFont ()
{
   register int	index, old_index;
#ifdef KANJI
   register int tmp_index = -1, fake_size;
   char * fontName;
#endif /* KANJI */

   index = FontIndex (curFontDPI, curFont, curSize, curStyle);
   if (!myFontInfo[index].valid)
   {
#ifdef UC
      XDefineCursor(mainDisplay, drawWindow, watchCursor);
#endif /* UC */
#ifdef KANJI
      if (curFont == FONT_MIN || curFont == FONT_GOT)
      {
	  if (curFont == FONT_GOT && UseMinchoAsGothic[curSize])
	      tmp_index = FontIndex (curFontDPI, FONT_MIN, curSize, curStyle);
	  else
	      tmp_index = index;
	  
	  fontName =
	   ((struct MyKanjiFontNameRec *)fontNameStr[tmp_index])->kanjiFontName;
         if ((strlen (fontName) == 0) ||
	     ((myFontInfo[index].xfs_kanji =
                XLoadQueryFont (mainDisplay, fontName)) == NULL))
         {
	    fake_size = 3;
	    
	    if (curFont == FONT_GOT && UseMinchoAsGothic[fake_size])
		tmp_index = FontIndex (curFontDPI, FONT_MIN, fake_size, curStyle);
	    else
		tmp_index = FontIndex (curFontDPI, curFont, fake_size, curStyle);
	  
	    fontName =
              ((struct MyKanjiFontNameRec *)fontNameStr[tmp_index])->kanjiFontName;
	    
	    if ((myFontInfo[index].xfs_kanji =
		 XLoadQueryFont (mainDisplay, fontName)) == NULL)
	    {
	        printf ("Can not open %s.  Abort.\n\n", fontName);
		/* fool safe */ EmergencySave ();
	    }
	    myFontInfo[index].fake = TRUE;
	    TwoLineMsg ("Can not open this size of Mincho or Gothic font,",
			"opened 14 point size instead.");
         }
	 SetFileModified (TRUE);
         if ((myFontInfo[index].xfs =
                XLoadQueryFont (mainDisplay,
		   ((struct MyKanjiFontNameRec * )
		     fontNameStr[index])->ankFontName)) == NULL)
         {
            printf ("Can not open %s.  Tgtif aborted.\n\n",
		      ((struct MyKanjiFontNameRec * )
		         fontNameStr[index])->ankFontName);
	    /* fool safe */ EmergencySave ();
         }
      }else
#endif /* KANJI */
      if ((myFontInfo[index].xfs =
            XLoadQueryFont (mainDisplay, fontNameStr[index])) == NULL)
      {
         old_index = index;
         curFontDPI = (curFontDPI==FONT_DPI_75) ? FONT_DPI_100 : FONT_DPI_75;
         index = FontIndex (curFontDPI, curFont, curSize, curStyle);
         if ((myFontInfo[index].xfs =
               XLoadQueryFont (mainDisplay, fontNameStr[index])) == NULL)
         {
            printf ("Can not open '%s' nor\n\t'%s'!  Tgif aborted!\n\n",
                  fontNameStr[old_index], fontNameStr[index]);
            /* fool safe */ EmergencySave ();
         }
         printf ("Warning:  can not open '%s' font,\n\tuse '%s' instead.\n",
               fontNameStr[old_index], fontNameStr[index]);
         SetFileModified (TRUE);
      }
      myFontInfo[index].valid = TRUE;
   }
#ifdef KANJI
   if (curFont == FONT_MIN || curFont == FONT_GOT)
      canvasKanjiFontPtr = myFontInfo[index].xfs_kanji;
   else
      canvasKanjiFontPtr = NULL;
   canvasKanjiFontIsFake = myFontInfo[index].fake;
#endif /* KANJI */

   canvasFontIndex = index;

   canvasFontPtr = myFontInfo[index].xfs;
   canvasFontAsc = canvasFontPtr->max_bounds.ascent;
   canvasFontDes = canvasFontPtr->max_bounds.descent;
   canvasFontHeight = canvasFontAsc + canvasFontDes;

   XSetFont (mainDisplay, drawGC, canvasFontPtr->fid);

   textCursorH = canvasFontHeight;

   pointSize = (curFontDPI==FONT_DPI_75) ? pointSize75 : pointSize100;
   sizeMenuStr = (curFontDPI==FONT_DPI_75) ? sizeMenuStr75 : sizeMenuStr100;
#ifdef UC
   ShowCursor();
#endif /* UC */
}

void InitFonts ()
{
   register int	i;
   int		ruler_index, default_index;
   int		old_ruler_index, old_default_index, len, dpi;
   char		* s;
#ifndef KANJI

   for (i = 0; i < FONTTABLESIZE; i++) myFontInfo[i].valid = FALSE;
#else /* KANJI */
   register char * kanjiFontName;
   int 		 flag = FALSE, menu_index, old_menu_index;
   int		 maxFonts = MAXKANJIFONTS;

   for (i = 0; i < FONTTABLESIZE; i++)
       myFontInfo[i].fake = myFontInfo[i].valid = FALSE;

#define ChangeKanjiFont(FontSize, NewFontName) \
	{ \
           kanjiFontName = (char *) malloc(strlen(NewFontName) + 1);\
           strcpy (kanjiFontName, NewFontName);\
	   kanjiFontNameStr[FontSize].kanjiFontName = kanjiFontName;\
	}

#define ChangeKanjiGothicFont(FontSize, NewFontName) \
        { \
	   ChangeKanjiFont(FontSize, NewFontName); \
   	   UseMinchoAsGothic[FontSize - GOTH8] = FALSE;\
	}

/* for future use */
   strcpy(serverHostName, DisplayString (mainDisplay));
   strtok (serverHostName, ":");
/* up to this line */
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiFontGetSkip")) != NULL)
      if ((strcmp (s, "on") == 0) || (strcmp (s, "On") == 0))
	  goto next;
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiGothic8")) != NULL)
       ChangeKanjiGothicFont (GOTH8, s);

   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiGothic10")) != NULL)
       ChangeKanjiGothicFont (GOTH10, s);
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiGothic12")) != NULL)
       ChangeKanjiGothicFont (GOTH12, s);
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiGothic14")) != NULL)
       ChangeKanjiGothicFont (GOTH14, s);
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiGothic16")) != NULL)
   {    
       ChangeKanjiFont (GOTH18, s);
       Use16as18.gothic = TRUE;       
   }
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiGothic18")) != NULL)
   {
       ChangeKanjiGothicFont (GOTH18, s);
       Use16as18.gothic = FALSE;
   }
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiGothic24")) != NULL)
       ChangeKanjiGothicFont (GOTH24, s);
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiMinchou8")) != NULL)
       ChangeKanjiFont (MINC8, s);
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiMinchou10")) != NULL)
       ChangeKanjiFont (MINC10, s);
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiMinchou12")) != NULL)
       ChangeKanjiFont (MINC12, s);
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiMinchou14")) != NULL)
       ChangeKanjiFont (MINC14, s);
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiMinchou16")) != NULL)
   {
       ChangeKanjiFont (MINC18, s);
       Use16as18.mincho = TRUE;
   }       
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiMinchou18")) != NULL)
   {
       ChangeKanjiFont (MINC18, s);
       Use16as18.mincho = FALSE;
   }
   
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "KanjiMinchou24")) != NULL)
       ChangeKanjiFont (MINC24, s);

 next:
#endif /* KANJI */

   curFont = FONT_COU;
   curStyle = STYLE_NR;
   curSize = 4;
   curFontDPI = FONT_DPI_75;

   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "InitialFontDPI")) != NULL)
   {
      dpi = atoi (s);
      switch (dpi)
      {
         case 75: curFontDPI = FONT_DPI_75; curSize = 4; break;
         case 100: curFontDPI = FONT_DPI_100; curSize = 2; break;
         default:
            printf ("Warning:  can not set InitialFontDPI to '%s'\n", s);
            break;
      }
   }

   default_index = FontIndex(curFontDPI, curFont, curSize, curStyle);
   if ((myFontInfo[default_index].xfs =
         XLoadQueryFont (mainDisplay, fontNameStr[default_index])) == NULL)
   {
      old_default_index = default_index;
      curSize = 2;
      curFontDPI = FONT_DPI_100;
      default_index = FontIndex(curFontDPI, curFont, curSize, curStyle);
      if ((myFontInfo[default_index].xfs =
            XLoadQueryFont (mainDisplay, fontNameStr[default_index])) == NULL)
      {
         printf ("Can not open '%s' nor\n\t'%s'!  Tgif aborted!\n\n",
               fontNameStr[old_default_index], fontNameStr[default_index]);
         /* fool safe */ EmergencySave ();
      }
   }
   myFontInfo[default_index].valid = TRUE;

   ruler_index = FontIndex(FONT_DPI_75, curFont, 1, curStyle);
   if ((myFontInfo[ruler_index].xfs =
         XLoadQueryFont (mainDisplay, fontNameStr[ruler_index])) == NULL)
   {
      old_ruler_index = ruler_index;
      ruler_index = FontIndex(FONT_DPI_100, curFont, 0, curStyle);
      if ((myFontInfo[ruler_index].xfs =
            XLoadQueryFont (mainDisplay, fontNameStr[ruler_index])) == NULL)
      {
         printf ("Can not open '%s' nor\n\t'%s'!  Tgif aborted!\n\n",
               fontNameStr[old_ruler_index], fontNameStr[ruler_index]);
         /* fool safe */ EmergencySave ();
      }
   }
   myFontInfo[ruler_index].valid = TRUE;

   defaultFontPtr = myFontInfo[default_index].xfs;
   defaultFontWidth = defaultFontPtr->max_bounds.width;
   defaultFontAsc = defaultFontPtr->max_bounds.ascent;
   defaultFontDes = defaultFontPtr->max_bounds.descent;
   defaultFontHeight = defaultFontAsc + defaultFontDes;

   rulerFontPtr = myFontInfo[ruler_index].xfs;
   rulerFontWidth = rulerFontPtr->max_bounds.width;
   rulerFontAsc = rulerFontPtr->max_bounds.ascent;
   rulerFontDes = rulerFontPtr->max_bounds.descent;
   rulerFontHeight = rulerFontAsc + rulerFontDes;

   pointSize = (curFontDPI==FONT_DPI_75) ? pointSize75 : pointSize100;
   sizeMenuStr = (curFontDPI==FONT_DPI_75) ? sizeMenuStr75 : sizeMenuStr100;

   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "InitialFont")) != NULL)
   {
#ifndef KANJI
      maxFonts = ((noKanji)?MAXFONTS: MAXKANJIFONTS);

      for (i = 0; i < MAXFONTS; i++)
         if (strcmp (s, fontMenuStr[i]) == 0)
#else /* KANJI */
      for (i = 0; i < maxFonts; i++)
         if (strcmp (s, kanjiFontMenuStr[i]) == 0)
#endif /* KANJI */
            break;
#ifndef KANJI
      if (i != MAXFONTS)
#else /* KANJI */
      if (i != maxFonts)
#endif /* KANJI */
         curFont = i;
      else
         printf ("Warning:  can not set InitialFont to '%s'\n", s);
   }
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "InitialFontStyle")) != NULL)
   {
      len = strlen (s);
      if (len < strlen (styleMenuStr[0]))
      {
         for (i = 0; i < MAXFONTSTYLES; i++)
            if (strncmp (s, styleMenuStr[i], len) == 0)
               break;
         if (i != MAXFONTSTYLES)
            curStyle = i;
         else
            printf ("Warning:  can not set InitialFontStyle to '%s'\n", s);
      }
      else
         printf ("Warning:  can not set InitialFontStyle to '%s'\n", s);
   }
   if ((s = XGetDefault (mainDisplay, TOOL_NAME, "InitialFontJust")) != NULL)
   {
      len = strlen (s);
      if (len < strlen (styleMenuStr[0]))
      {
         for (i = MAXFONTSTYLES+1; i < MAXFONTSTYLES+1+MAXJUSTS; i++)
            if (strncmp (s, styleMenuStr[i], len) == 0)
               break;
         if (i != MAXFONTSTYLES+1+MAXJUSTS)
            textJust = i-MAXFONTSTYLES-1;
         else
            printf ("Warning:  can not set InitialFontJust to '%s'\n", s);
      }
      else
         printf ("Warning:  can not set InitialFontJust to '%s'\n", s);
   }
   if ((s = XGetDefault (mainDisplay,TOOL_NAME,"InitialFontSizeIndex")) != NULL)
   {
      if (atoi (s) < MAXFONTSIZES)
         curSize = atoi (s);
      else
         printf ("Warning:  can not set InitialFontSizeIndex to '%s'\n", s);
   }
}

static
int ChangeObjTextStyle (ObjPtr, StyleIndex)
   register struct ObjRec	* ObjPtr;
   register int			StyleIndex;
{
   register struct ObjRec	* obj_ptr;
   register int			changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->style != StyleIndex)
            {
#ifdef KANJI
	      int font = obj_ptr->detail.t->font;
	      if (font == FONT_MIN || font == FONT_GOT)
		  continue;
#endif /* KANJI */
               obj_ptr->detail.t->style = StyleIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextStyle (obj_ptr->detail.r->last, StyleIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

static
int ChangeObjTextJust (ObjPtr, JustIndex)
   register struct ObjRec	* ObjPtr;
   register int			JustIndex;
{
   register struct ObjRec	* obj_ptr;
   register int			changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->just != JustIndex)
            {
               obj_ptr->detail.t->just = JustIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextJust (obj_ptr->detail.r->last, JustIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

void ChangeFontJust (JustIndex)
   int JustIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				ltx, lty, rbx, rby;
   int				text_obj_created, text_cursor_shown;
   int				changed = FALSE;

   if (JustIndex == INVALID) return;

   if (topSel == NULL)
   {
      text_cursor_shown = textCursorShown;
      text_obj_created = TieLooseEnds ();
      textJust = JustIndex;
      ShowJust ();
      if (!text_obj_created && curChoice == DRAWTEXT && text_cursor_shown)
      {
         NewCurText ();
         RedrawCurText ();
      }
      else
         textCursorShown = FALSE;
      return;
   }

   HighLightReverse ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->just != JustIndex)
            {
               obj_ptr->detail.t->just = JustIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;
         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextJust (obj_ptr->detail.r->last, JustIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
            selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      SetFileModified (TRUE);
   }
   HighLightForward ();
}

void ChangeFontStyle (StyleIndex)
   int	StyleIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				ltx, lty, rbx, rby, text_obj_created;
   int				changed = FALSE, text_cursor_shown;

   if (StyleIndex == INVALID) return;

   if (topSel == NULL)
   {
      text_cursor_shown = textCursorShown;
      text_obj_created = TieLooseEnds ();
      curStyle = StyleIndex;
      SetCanvasFont ();
      if (!text_obj_created && curChoice == DRAWTEXT && text_cursor_shown)
      {
         NewCurText ();
         RedrawCurText ();
      }
      else
         textCursorShown = FALSE;
      ShowCurFont ();
      return;
   }

   HighLightReverse ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->style != StyleIndex)
            {
#ifdef KANJI
	      int font = obj_ptr->detail.t->font;
	      if (font == FONT_MIN || font == FONT_GOT)
		  continue;
#endif /* KANJI */
               obj_ptr->detail.t->style = StyleIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;
         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextStyle (obj_ptr->detail.r->last, StyleIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
            selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      SetFileModified (TRUE);
   }
   HighLightForward ();
}

void StyleMenu (X, Y)
   int  X, Y;
{
   register int	index;
   int		* fore_colors, * valid;

   DefaultColorArrays (MAXFONTSTYLES+MAXJUSTS+1, &fore_colors, &valid);
   index = TextMenuLoop (X, Y, styleMenuStr, MAXFONTSTYLES+MAXJUSTS+1,
#ifndef UC
         fore_colors, valid, SINGLECOLOR);
#else /* UC */
         fore_colors, valid, SINGLECOLOR, MENU_STYLE);
#endif /* UC */

   if (index == INVALID) return;

   if (index < MAXFONTSTYLES)
#ifndef KANJI
      ChangeFontStyle (index);
#else /* KANJI */
   {
       if (topSel == NULL && (curFont == FONT_MIN || curFont == FONT_GOT) && (index != STYLE_NR))
       {
	   Msg ("KANJI fonts support only ROMAN style");
	   return;
       }
       else
	   ChangeFontStyle (index);
   }
#endif /* KANJI */
   else if (index > MAXFONTSTYLES)
      ChangeFontJust (index - MAXFONTSTYLES - 1);
}

static
int ChangeObjTextSize (ObjPtr, SizeIndex)
   register struct ObjRec	* ObjPtr;
   register int			SizeIndex;
{
   register struct ObjRec	* obj_ptr;
   register int			changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->size != SizeIndex)
            {
               obj_ptr->detail.t->size = SizeIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextSize (obj_ptr->detail.r->last, SizeIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

void ChangeFontSize (SizeIndex)
   int	SizeIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				ltx, lty, rbx, rby, text_obj_created;
   int				text_cursor_shown, changed = FALSE;

   if (SizeIndex == INVALID) return;

   if (topSel == NULL)
   {
      text_cursor_shown = textCursorShown;
      text_obj_created = TieLooseEnds ();
      curSize = SizeIndex;
      SetCanvasFont ();
      if (!text_obj_created && curChoice == DRAWTEXT && text_cursor_shown)
      {
         NewCurText ();
         RedrawCurText ();
      }
      else
         textCursorShown = FALSE;
      ShowCurFont ();
      return;
   }

   HighLightReverse ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->size != SizeIndex)
            {
               obj_ptr->detail.t->size = SizeIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;
      
         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextSize (obj_ptr->detail.r->last, SizeIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
            selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      SetFileModified (TRUE);
   }
   HighLightForward ();
}

void SizeMenu (X, Y)
   int  X, Y;
{
   register int			index;
   int				* fore_colors, * valid;

   DefaultColorArrays (MAXFONTSIZES, &fore_colors, &valid);

   index = TextMenuLoop (X, Y, sizeMenuStr, MAXFONTSIZES, fore_colors, valid,
#ifndef UC
         SINGLECOLOR);
#else /* UC */
         SINGLECOLOR, MENU_SIZE);
#endif /* UC */
   ChangeFontSize (index);
}

static
int ChangeObjTextFont (ObjPtr, FontIndex)
   register struct ObjRec	* ObjPtr;
   register int			FontIndex;
{
   register struct ObjRec	* obj_ptr;
   register int			changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->font != FontIndex)
            {
               obj_ptr->detail.t->font = FontIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextFont (obj_ptr->detail.r->last, FontIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

void ChangeFont (FontIndex)
   int	FontIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE, text_cursor_shown;
   int				ltx, lty, rbx, rby, text_obj_created;

   if (FontIndex == INVALID) return;

   if (topSel == NULL)
   {
      text_cursor_shown = textCursorShown;
      text_obj_created = TieLooseEnds ();
      curFont = FontIndex;
      SetCanvasFont ();
      if (!text_obj_created && curChoice == DRAWTEXT && text_cursor_shown)
      {
         NewCurText ();
         RedrawCurText ();
      }
      else
         textCursorShown = FALSE;
      ShowCurFont ();
      return;
   }

   HighLightReverse ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->font != FontIndex)
            {
#ifdef KANJI		   
		if (FontIndex == FONT_MIN || FontIndex == FONT_GOT)
		    if (obj_ptr->detail.t->dpi == FONT_DPI_100)
		    {
			Msg ("100 DPI KANJI Fonts are not supported, opened 75 DPI instead");
			curFontDPI = obj_ptr->detail.t->dpi = FONT_DPI_75;
		    }
#endif /* KANJI */		  
               obj_ptr->detail.t->font = FontIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextFont (obj_ptr->detail.r->last, FontIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
            selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      SetFileModified (TRUE);
   }
   HighLightForward ();
}

void FontMenu (X, Y)
   int  X, Y;
{
   register int			index;
   int				* fore_colors, * valid;

#ifndef KANJI
   DefaultColorArrays (MAXFONTS, &fore_colors, &valid);
   index = TextMenuLoop (X, Y, fontMenuStr, MAXFONTS, fore_colors, valid,
#ifndef UC
         SINGLECOLOR);
#else /* UC */
         SINGLECOLOR, MENU_FONT);
#endif /* UC */
#else /* KANJI */
   DefaultColorArrays (MAXFONTSP, &fore_colors, &valid);
   index = TextMenuLoop (X, Y, (noKanji)? fontMenuStr:kanjiFontMenuStr,
			 MAXFONTSP, fore_colors, valid,
#ifndef UC
         SINGLECOLOR);
#else /* UC */
         SINGLECOLOR, MENU_FONT);
#endif /* UC */
#endif /* KANJI */
#ifdef KANJI
   Msg ("");
   if (index == FONT_MIN || index == FONT_GOT)
   {
      if (curFontDPI == FONT_DPI_100)
      {
          Msg ("100 DPI KANJI Fonts are not supported");
	  curFontDPI = FONT_DPI_75;
      }
      if (curStyle != STYLE_NR)
      {
	 Msg ("KANJI fonts support only ROMAN style");
	 curStyle = STYLE_NR;
      }
  }
#ifdef KINPUT
  else if (kinputOn) EndKanjiConversion (mainDisplay, drawWindow);
#endif /* KINPUT */   
#endif /* KANJI */
   ChangeFont (index);
}

static
int ChangeObjTextFontDPI (ObjPtr, FontDPIIndex)
   register struct ObjRec	* ObjPtr;
   register int			FontDPIIndex;
{
   register struct ObjRec	* obj_ptr;
   register int			changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->dpi != FontDPIIndex)
            {
#ifdef KANJI		   
		if (FontDPIIndex == FONT_DPI_100)
		    if (obj_ptr->detail.t->font == FONT_MIN ||
			obj_ptr->detail.t->font == FONT_GOT)
		    {
			Msg ("100 DPI KANJI Fonts are not supported");
			continue;
		    }			
#endif /* KANJI */		  
               obj_ptr->detail.t->dpi = FontDPIIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextFontDPI (obj_ptr->detail.r->last, FontDPIIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

void ChangeFontDPI (FontDPIIndex)
   int	FontDPIIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE, text_cursor_shown;
   int				ltx, lty, rbx, rby, text_obj_created;

   if (FontDPIIndex == INVALID) return;

   if (topSel == NULL)
   {
#ifdef KANJI		   
       if (FontDPIIndex == FONT_DPI_100)
	   if (curFont == FONT_MIN || curFont == FONT_GOT)
	   {
	       Msg ("100 DPI KANJI Fonts are not supported");
	       return;
	   }			
#endif /* KANJI */
      text_cursor_shown = textCursorShown;
      text_obj_created = TieLooseEnds ();
      curFontDPI = FontDPIIndex;
      SetCanvasFont ();
      if (!text_obj_created && curChoice == DRAWTEXT && text_cursor_shown)
      {
         NewCurText ();
         RedrawCurText ();
      }
      else
         textCursorShown = FALSE;
      ShowCurFont ();

      pointSize = (curFontDPI==FONT_DPI_75) ? pointSize75 : pointSize100;
      sizeMenuStr = (curFontDPI==FONT_DPI_75) ? sizeMenuStr75 : sizeMenuStr100;
      return;
   }

   HighLightReverse ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_TEXT:
            if (obj_ptr->detail.t->dpi != FontDPIIndex)
            {
#ifdef KANJI		   
		if (FontDPIIndex == FONT_DPI_100)
		    if (obj_ptr->detail.t->font == FONT_MIN ||
			obj_ptr->detail.t->font == FONT_GOT)
		    {
			Msg ("100 DPI KANJI Fonts are not supported");
      			break;
		    }			
#endif /* KANJI */		  
               obj_ptr->detail.t->dpi = FontDPIIndex;
               UpdTextBBox (obj_ptr);
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjTextFont (obj_ptr->detail.r->last, FontDPIIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
            selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      SetFileModified (TRUE);
   }
   HighLightForward ();
}

void FontDPIMenu (X, Y)
   int  X, Y;
{
   register int			index;
   int				* fore_colors, * valid;

   DefaultColorArrays (MAXFONTDPIS, &fore_colors, &valid);
   index = TextMenuLoop (X, Y, fontDPIMenuStr, MAXFONTDPIS, fore_colors, valid,
#ifndef UC
         SINGLECOLOR);
#else /* UC */
         SINGLECOLOR, MENU_FONTDPI);
#endif /* UC */
#ifdef KANJI
/*   Msg ("");
   if ((curFont == FONT_MIN || curFont == FONT_GOT) && index == FONT_DPI_100)
   {
          Msg ("100 DPI KANJI Fonts are not supported");
          return;
   }*/
#endif /* KANJI */
   ChangeFontDPI (index);
}

static int	savedFont, savedSize, savedStyle, savedDPI;
static int	savedJust, savedRotate, savedPen;

void SaveCurFont ()
{
   savedFont = curFont;
   savedSize = curSize;
   savedStyle = curStyle;
   savedDPI = curFontDPI;
   savedJust = textJust;
   savedRotate = curRotate;
   savedPen = penPat;
}

void RestoreCurFont ()
{
   curFont = savedFont;
   curSize = savedSize;
   curStyle = savedStyle;
   curFontDPI = savedDPI;
   textJust = savedJust;
   curRotate = savedRotate;
   penPat = savedPen;

   SetCanvasFont ();
}

static int	pushedFont, pushedSize, pushedStyle, pushedDPI, pushedJust;
static int	pushedColorIndex, pushedRotate, pushedPen;

void PushCurFont ()
{
   pushedFont = curFont;
   pushedSize = curSize;
   pushedStyle = curStyle;
   pushedDPI = curFontDPI;
   pushedJust = textJust;
   pushedRotate = curRotate;
   pushedPen = penPat;
   pushedColorIndex = colorIndex;
}

void PopCurFont ()
{
   curFont = pushedFont;
   curSize = pushedSize;
   curStyle = pushedStyle;
   curFontDPI = pushedDPI;
   textJust = pushedJust;
   curRotate = pushedRotate;
   penPat = pushedPen;
   colorIndex = pushedColorIndex;

   SetCanvasFont ();
}

void CleanUpFonts ()
{
   register int	i;

   for (i = 0; i < FONTTABLESIZE; i++)
      if (myFontInfo[i].valid)
      {
         XFreeFont (mainDisplay, myFontInfo[i].xfs);
         myFontInfo[i].valid = FALSE;
      }
}

/* The following procedure is used to generate pdrawFontAsc[] and */
/*    pDrawFontDes[], to be used in ``prtgif.c''.  It is supposed */
/*    to be called within dbx and not tgif.                       */

/*
 * static
 * void GenerateFontInfo ()
 * {
 *    register int	i, j, num_rows;
 * 
 *    for (i = 0; i < FONTTABLESIZE; i++)
 *       if (!myFontInfo[i].valid)
 *       {
 *          if ((myFontInfo[i].xfs =
 *                XLoadQueryFont (mainDisplay, fontNameStr[i])) == NULL)
 *          {
 *             printf ("Can not open %s.  Abort.\n\n", fontNameStr[i]);
 *             exit (-1);
 *          }
 *          myFontInfo[i].valid = TRUE;
 *       }
 * 
 *    num_rows = FONTTABLESIZE / MAXFONTSIZES;
 *    printf ("short\tpDrawFontAsc[] =\n{\n");
 *    for (i = 0; i < num_rows; i++)
 *    {
 *       printf ("   ");
 *       for (j = 0; j < MAXFONTSIZES; j++)
 *          if (i == num_rows-1 && j == MAXFONTSIZES-1)
 *             printf ("%2d ",
 *                   (myFontInfo[i*MAXFONTSIZES+j].xfs)->max_bounds.ascent);
 *          else
 *             printf ("%2d, ",
 *                   (myFontInfo[i*MAXFONTSIZES+j].xfs)->max_bounds.ascent);
 *       printf ("\n");
 *    }
 *    printf ("};\n\n");
 * 
 *    printf ("short\tpDrawFontDes[] =\n{\n");
 *    for (i = 0; i < num_rows; i++)
 *    {
 *       printf ("   ");
 *       for (j = 0; j < MAXFONTSIZES; j++)
 *          if (i == num_rows-1 && j == MAXFONTSIZES-1)
 *             printf ("%2d ",
 *                   (myFontInfo[i*MAXFONTSIZES+j].xfs)->max_bounds.descent);
 *          else
 *             printf ("%2d, ",
 *                   (myFontInfo[i*MAXFONTSIZES+j].xfs)->max_bounds.descent);
 *       printf ("\n");
 *    }
 *    printf ("};\n");
 * }
 */
