/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/grid.c,v 2.0 91/03/05 12:47:23 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "color.e"
#include "drawing.e"
#include "dup.e"
#include "msg.e"
#include "obj.e"
#include "raster.e"
#include "ruler.e"
#include "scroll.e"
#include "select.e"
#include "setup.e"
#ifdef UC
#include "file.e"
#include "arc.e"
#include "showsize.e"
#endif /* UC */

int	gridOn = TRUE;
int	xyGrid = DEFAULT_GRID;
int	pageStyle = PORTRAIT;
int	whereToPrint = PRINTER;
#ifdef UC
int	dotOnGrid = FALSE;
int	cmUnit = FALSE;
int	xyCmGrid = DEFAULT_CM_GRID;
int	xyInchGrid = DEFAULT_GRID;
int	savedDrawWinW, savedDrawWinH;
#endif /* UC */

static int	gridShown = TRUE;

#ifdef UC
void ToggleUnit ()
{
	cmUnit = ! cmUnit;
	if (cmUnit)
	{
	    xyInchGrid = xyGrid;
	    xyGrid = xyCmGrid;
	}
	else
	{
	    xyCmGrid = xyGrid;
	    xyGrid = xyInchGrid;
	}
	UpdPageStyle (pageStyle);
	RedrawScrollBars ();
	RedrawRulers ();
	ClearAndRedrawDrawWindow ();
	SetFileModified (TRUE);
}
#endif /* UC */
#ifdef UC
void ToggleSaveWithEps ()
{
    saveWithEps = ! saveWithEps;
}

void ToggleDotOnGrid ()
{
	dotOnGrid = ! dotOnGrid;
	ClearAndRedrawDrawWindow();
}
void ToggleShowSize ()
{
	showSize = ! showSize;
}
#endif /* UC */
void MyHDotLine (Win, Y, XStart, XEnd, Pixel)
   Window	Win;
   int		Y, XStart, XEnd, Pixel;
{
   register int	x;

#ifndef UC
   for (x = XStart; x < XEnd; x += 8)
#else /* UC */
   int		inc = (cmUnit)? PIX_PER_CM_DOT:((dotOnGrid)? xyGrid: PIX_PER_INCH_DOT);

   for (x = XStart; x < XEnd; x += inc)
#endif /* UC */
#ifdef sun
      XDrawPoint (mainDisplay, Win, defaultGC, x, Y);
#else /* UC */
#ifdef ultrix
      XDrawPoint (mainDisplay, Win, defaultGC, x, Y);
#else /* UC */
      XDrawLine (mainDisplay, Win, defaultGC, x, Y, x, Y);
#endif
#endif
}

void MyVDotLine (Win, X, YStart, YEnd, Pixel)
   Window	Win;
   int		X, YStart, YEnd, Pixel;
{
   register int	y;

#ifndef UC
   for (y = YStart; y < YEnd; y += 8)
#else /* UC */
   int		inc = (cmUnit)? PIX_PER_CM_DOT:((dotOnGrid)?xyGrid:PIX_PER_INCH_DOT);

   for (y = YStart; y < YEnd; y += inc)
#endif /* UC */
#ifdef sun
      XDrawPoint (mainDisplay, Win, defaultGC, X, y);
#else /* UC */
#ifdef ultrix
      XDrawPoint (mainDisplay, Win, defaultGC, X, y);
#else /* UC */
      XDrawLine (mainDisplay, Win, defaultGC, X, y, X, y);
#endif
#endif
}

void RedrawGridLines ()
{
#ifndef UC
   register int	i, inc = HALF_INCH, abs_grid = HALF_INCH<<zoomScale;
#else /* UC */
   register int	i, abs_grid =
       RealSize(((dotOnGrid)? xyGrid: ((cmUnit)? ONE_CM:HALF_INCH)), zoomScale);
   register int inc = dotOnGrid ? xyGrid : (cmUnit)? ONE_CM:HALF_INCH;
   register int pixPerDot = (cmUnit)? PIX_PER_CM_DOT : PIX_PER_INCH_DOT;
#endif /* UC */
   int		x_start, y_start, x_end, y_end, x_grid_start, y_grid_start;
   int		pixel = myFgPixel;

   if (!gridShown) return;

   if (drawOrigX % abs_grid == 0)
      x_start = 0;
   else
      x_start = OFFSET_X(((int)(drawOrigX / abs_grid) + 1) * abs_grid);
   if (drawOrigY % abs_grid == 0)
      y_start = 0;
   else
      y_start = OFFSET_Y(((int)(drawOrigY / abs_grid) + 1) * abs_grid);

   x_end = min(OFFSET_X(paperWidth), OFFSET_X(drawOrigX+drawWinW));
   y_end = min(OFFSET_Y(paperHeight), OFFSET_Y(drawOrigY+drawWinH));

#ifndef UC
   if (drawOrigX % 8 == 0)
#else /* UC */
   if (drawOrigX % pixPerDot == 0)
#endif /* UC */
      x_grid_start = 0;
   else
#ifndef UC
      x_grid_start = ((int)(drawOrigX / 8) + 1) * 8 - drawOrigX;
#else /* UC */
      x_grid_start = ((int)(drawOrigX / pixPerDot) + 1) * pixPerDot - drawOrigX;
#endif /* UC */
#ifndef UC
   if (drawOrigY % 8 == 0)
#else /* UC */
   if (drawOrigY % pixPerDot == 0)
#endif /* UC */
      y_grid_start = 0;
   else
#ifndef UC
      y_grid_start = ((int)(drawOrigY / 8) + 1) * 8 - drawOrigY;
#else /* UC */
      y_grid_start = ((int)(drawOrigY / pixPerDot) + 1) * pixPerDot - drawOrigY;
#endif /* UC */

   for (i = x_start; i < x_end; i += inc)
      MyVDotLine (drawWindow, i, y_grid_start, y_end, pixel);
   for (i = y_start; i < y_end; i += inc)
      MyHDotLine (drawWindow, i, x_grid_start, x_end, pixel);
}

void DrawGridLines (Win, LtX, LtY, RbX, RbY)
   Window	Win;
   int 		LtX, LtY, RbX, RbY; /* absolute coordinates */
{
#ifndef UC
   register int	i, inc = HALF_INCH, abs_grid = HALF_INCH<<zoomScale;
#else /* UC */
   register int	i, abs_grid =
       RealSize(((dotOnGrid) ? xyGrid : ((cmUnit)? ONE_CM: HALF_INCH)), zoomScale);
   register int inc = dotOnGrid ? xyGrid : ((cmUnit)? ONE_CM:HALF_INCH);
   register int pixPerDot = (cmUnit)? PIX_PER_CM_DOT : PIX_PER_INCH_DOT;
#endif /* UC */
   int		x_start, y_start, x_end, y_end;
   int		x_grid_start, y_grid_start, x_grid_end, y_grid_end;
   int		pixel = myFgPixel;

   if (!gridShown) return;

   if (LtX > paperWidth || LtY > paperHeight) return;

   if (LtX % abs_grid == 0)
      x_start = OFFSET_X(LtX);
   else
      x_start = OFFSET_X(((int)(LtX / abs_grid) + 1) * abs_grid);
   if (LtY % abs_grid == 0)
      y_start = OFFSET_Y(LtY);
   else
      y_start = OFFSET_Y(((int)(LtY / abs_grid) + 1) * abs_grid);

   if (RbX % abs_grid == 0)
      x_end = min(OFFSET_X(paperWidth),OFFSET_X(RbX));
   else
      x_end = min(OFFSET_X(paperWidth),
            OFFSET_X(((int)(RbX / abs_grid) + 1) * abs_grid));
   if (RbY % abs_grid == 0)
      y_end = min(OFFSET_Y(paperHeight),OFFSET_Y(RbY));
   else
      y_end = min(OFFSET_Y(paperHeight),
            OFFSET_Y(((int)(RbY / abs_grid) + 1) * abs_grid));

#ifndef UC
   if (LtX % (8<<zoomScale) == 0)
#else /* UC */
   if (LtX % (RealSize(pixPerDot, zoomScale)) == 0)
#endif /* UC */
      x_grid_start = OFFSET_X(LtX);
   else
#ifndef UC
      x_grid_start = ((int)(OFFSET_X(LtX) / 8) + 1) * 8;
#else /* UC */
      x_grid_start = ((int)(OFFSET_X(LtX) / pixPerDot) + 1) * pixPerDot;
#endif /* UC */
#ifndef UC
   if (LtY % (8<<zoomScale) == 0)
#else /* UC */
   if (LtY % (RealSize(pixPerDot, zoomScale)) == 0)
#endif /* UC */
      y_grid_start = OFFSET_Y(LtY);
   else
#ifndef UC
      y_grid_start = ((int)(OFFSET_Y(LtY) / 8) + 1) * 8;
#else /* UC */
      y_grid_start = ((int)(OFFSET_Y(LtY) / pixPerDot) + 1) * pixPerDot;
#endif /* UC */

#ifndef UC
   if (RbX % (8<<zoomScale) == 0)
#else /* UC */
   if (RbX % (RealSize(pixPerDot, zoomScale)) == 0)
#endif /* UC */
      x_grid_end = min(OFFSET_X(paperWidth), OFFSET_X(RbX));
   else
#ifndef UC
      x_grid_end = min(OFFSET_X(paperWidth), ((int)(OFFSET_X(RbX)/8)+1)*8);
#else /* UC */
      x_grid_end = min(OFFSET_X(paperWidth), ((int)(OFFSET_X(RbX)/pixPerDot)+1)*pixPerDot);
#endif /* UC */
#ifndef UC
   if (RbY % (8<<zoomScale) == 0)
#else /* UC */
   if (RbY % (RealSize(pixPerDot, zoomScale)) == 0)
#endif /* UC */
      y_grid_end = min(OFFSET_Y(paperHeight), OFFSET_Y(RbY));
   else
#ifndef UC
      y_grid_end = min(OFFSET_Y(paperHeight), ((int)(OFFSET_Y(RbY)/8)+1)*8);
#else /* UC */
      y_grid_end = min(OFFSET_Y(paperHeight), ((int)(OFFSET_Y(RbY)/pixPerDot)+1)*pixPerDot);
#endif /* UC */

   for (i = x_start; i < x_end; i += inc)
      MyVDotLine (Win, i, y_grid_start, y_grid_end, pixel);
   for (i = y_start; i < y_end; i += inc)
      MyHDotLine (Win, i, x_grid_start, x_grid_end, pixel);
}

#ifndef UC
#define LAYOUT_INCGRID 0
#define LAYOUT_DECGRID 1
#define LAYOUT_GRID 2
#define LAYOUT_SNAP 3
#define LAYOUT_ZOOMIN 4
#define LAYOUT_ZOOMOUT 5
#define LAYOUT_LAND 6
#define LAYOUT_PORT 7
#define LAYOUT_HILAND 8
#define LAYOUT_HIPORT 9
#define LAYOUT_SLIDELAND 10
#define LAYOUT_SLIDEPORT 11
#define LAYOUT_TOGGLE_WHERE_TO_PRINT 12
#define LAYOUT_TOGGLE_COLOR_PS 13

#define MAXLAYOUTMENUS 14
#else /* UC */

#define MAXLAYOUTMENUS 18
#endif /* UC */

char * layoutMenuStr[] =
{  "+Grid      #I",
   "-Grid      #D",
   "ShowGrid   #G",
   "SnapOff   ^#G",
   "ZoomIn     #Z",
   "ZoomOut    #O",
   "Landscape",
   "Portrait",
   "HighLand",
   "HighPort",
   "SlideLand",
   "SlidePort",
   "Printer",
#ifndef UC
   "ColorPS"
#else /* UC */
   "ColorPS",       
   "DotOnGrid ^/",
   "ShowSize  #/",
   "SaveWithEPS"
   ,"Inch"      
#endif /* UC */
};
#define MAX_LAYOUT_STR 14 /* longest string length in layoutMenuStr[] */

static char showGridStr[]         = "ShowGrid   #G";
static char hideGridStr[]         = "HideGrid   #G";

static char snapOnStr[]           = "SnapOn    ^#G";
static char snapOffStr[]          = "SnapOff   ^#G";

static char printerStr[]          = "Printer   ^#X";
static char latexFigStr[]         = "LaTeXFig  ^#X";
static char psFileStr[]           = "RawPSFile ^#X";
static char xbmStr[]              = "XBitmap   ^#X";

static char bwPostScriptStr[]     = "BlkWhtPS  ^#K";
static char colorPostScriptStr[]  = "ColorPS   ^#K";
#ifdef UC

static char dotOnGridStr[]        = "DotOnGrid  ^/";
static char dotOffGridStr[]       = "DotOffGrid ^/";

static char showSizeStr[]         = "ShowSize   #/";
static char hideSizeStr[]         = "HideSize   #/";

static char saveWithEpsONStr[]    = "SaveWithEPS  ";
static char saveWithEpsOFFStr[]   = "SaveObjOnly  ";
static char inchUnitStr[]         = "Inch	  ";
static char cmUnitStr[]           = "CentiMeter   ";
#endif /* UC */

void IncGrid ()
{
   if (!gridOn)
      Msg ("Snap is not on, grid size not changed.");
   else if (xyGrid < HALF_INCH)
   {
      xyGrid *= 2;
      RedrawRulers ();
#ifdef UC
      if(dotOnGrid) ClearAndRedrawDrawWindow();
#endif /* UC */
   }
   else
      Msg ("Already at maximun grid, grid size not changed.");
}

void DecGrid ()
{
   if (!gridOn)
      Msg ("Snap is not on, grid size not changed.");
   else if (xyGrid > 4)
   {
      xyGrid /= 2;
      RedrawRulers ();
#ifdef UC
      if(dotOnGrid) ClearAndRedrawDrawWindow();
#endif /* UC */
   }
   else
      Msg ("Already at minimum grid, grid size not changed.");
}

void ToggleGridShown ()
{
   gridShown = !gridShown;
   ClearAndRedrawDrawWindow ();
}

void ToggleSnapOn ()
{
   gridOn = !gridOn;
   if (gridOn)
      Msg ("Snapping to grid point activated.");
   else
      Msg ("Snapping to grid point disabled.");
   RedrawRulers ();
}

void ToggleColorPostScript ()
{
   colorDump = !colorDump;
   if (colorDump)
      Msg ("PostScript file will print in color.");
   else
      Msg ("PostScript file will print in black-and-white.");
   ShowWhereToPrint ();
}

void ToggleWhereToPrint ()
{
   whereToPrint = (whereToPrint+1) % MAXWHERETOPRINT;
   switch (whereToPrint)
   {
      case PRINTER: Msg ("Print device set to printer."); break;
      case LATEX_FIG:
         Msg ("Will print Encapsulated PostScript (LaTeX-Figure) file.");
         break;
      case PS_FILE: Msg ("Will print raw PostScript file."); break;
      case XBM_FILE:
         if (colorDump)
            Msg ("Will print X11 Pitmap file.");
         else
            Msg ("Will print X11 Bitmap file.");
         break;
   }
   ShowWhereToPrint ();
}

void ZoomIn ()
{
#ifndef UC
   int	zoomed_half_inch = HALF_INCH<<zoomScale;
#else /* UC */
   int	zoomed_half_inch = RealSize(HALF_INCH, zoomScale);
#endif /* UC */

#ifndef UC
   if (zoomScale == 0)
#else /* UC */
   if (zoomScale == -2)
#endif /* UC */
   {
      Msg ("Already at highest magnification, can no longer zoom in.");
      return;
   }

   TieLooseEnds ();
   SetCurChoice (NOTHING);

   zoomScale--;
   drawWinW >>= 1;
   drawWinH >>= 1;

   if (topSel != NULL)
   {
#ifndef UC
      drawOrigX = min(max(0,
            ((int)((paperWidth-drawWinW)/zoomed_half_inch))*zoomed_half_inch),
            max(0, ((int)(selObjLtX/zoomed_half_inch))*zoomed_half_inch-
            (PIX_PER_INCH<<zoomScale)));
      drawOrigY = min(max(0,
            ((int)((paperHeight-drawWinH)/zoomed_half_inch))*zoomed_half_inch),
            max(0, ((int)(selObjLtY/zoomed_half_inch))*zoomed_half_inch-
            (PIX_PER_INCH<<zoomScale)));
#else /* UC */
      drawOrigX = min(max(0,
            ((int)((paperWidth-drawWinW)/zoomed_half_inch))*zoomed_half_inch),
            max(0, ((int)(selObjLtX/zoomed_half_inch))*zoomed_half_inch-
            (RealSize(PIX_PER_INCH, zoomScale))));
      drawOrigY = min(max(0,
            ((int)((paperHeight-drawWinH)/zoomed_half_inch))*zoomed_half_inch),
            max(0, ((int)(selObjLtY/zoomed_half_inch))*zoomed_half_inch-
            (RealSize(PIX_PER_INCH, zoomScale))));
#endif /* UC */
   }

   UpdDrawWinBBox ();
   AdjSplineVs ();
   ClearAndRedrawDrawWindow ();
   RedrawRulers ();
   RedrawScrollBars ();
   justDupped = FALSE;
}

void ZoomOut ()
{
#ifndef UC
   int	zoomed_half_inch = HALF_INCH<<zoomScale;
#else /* UC */
   int	zoomed_half_inch = RealSize(HALF_INCH, zoomScale);
#endif /* UC */

   if (paperWidth <= drawWinW && paperHeight <= drawWinH)
   {
      Msg ("Already at paper boundaries, can no longer zoom out.");
      return;
   }

   TieLooseEnds ();
   SetCurChoice (NOTHING);

   zoomScale++;
   drawWinW <<= 1;
   drawWinH <<= 1;

   if (topSel != NULL)
   {
#ifndef UC
      drawOrigX = min(max(0,
            ((int)((paperWidth-drawWinW)/zoomed_half_inch))*zoomed_half_inch),
            max(0, ((int)(selObjLtX/zoomed_half_inch))*zoomed_half_inch-
            (PIX_PER_INCH<<zoomScale)));
      drawOrigY = min(max(0,
            ((int)((paperHeight-drawWinH)/zoomed_half_inch))*zoomed_half_inch),
            max(0, ((int)(selObjLtY/zoomed_half_inch))*zoomed_half_inch-
            (PIX_PER_INCH<<zoomScale)));
#else /* UC */
      drawOrigX = min(max(0,
            ((int)((paperWidth-drawWinW)/zoomed_half_inch))*zoomed_half_inch),
            max(0, ((int)(selObjLtX/zoomed_half_inch))*zoomed_half_inch-
            (RealSize(PIX_PER_INCH, zoomScale))));
      drawOrigY = min(max(0,
            ((int)((paperHeight-drawWinH)/zoomed_half_inch))*zoomed_half_inch),
            max(0, ((int)(selObjLtY/zoomed_half_inch))*zoomed_half_inch-
            (RealSize(PIX_PER_INCH, zoomScale))));
#endif /* UC */
   }
   else
   {
      if (drawOrigX + drawWinW > paperWidth)
      {
         if (drawWinW > paperWidth)
            drawOrigX = 0;
         else
            drawOrigX = max(0,((int)(paperWidth-drawWinW)/zoomed_half_inch)*
                  zoomed_half_inch);
      }
      if (drawOrigY + drawWinH > paperHeight)
      {
         if (drawWinH > paperHeight)
            drawOrigY = 0;
         else
            drawOrigY = max(0,((int)(paperHeight-drawWinH)/zoomed_half_inch)*
                  zoomed_half_inch);
      }
   }

   UpdDrawWinBBox ();
   AdjSplineVs ();
   ClearAndRedrawDrawWindow ();
   RedrawRulers ();
   RedrawScrollBars ();
   justDupped = FALSE;
}

int UpdPageStyle (NewPageStyle)
   int	NewPageStyle;
{
   int	changed = FALSE, old_w = paperWidth, old_h = paperHeight;

   switch (NewPageStyle)
   {
      case LANDSCAPE:
         pageStyle = LANDSCAPE;
#ifndef UC
         paperWidth = 10 * PIX_PER_INCH;
         paperHeight = 7.5 * PIX_PER_INCH;
#else /* UC */
         paperWidth = psPageWidthInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
         paperHeight = psPageHeightInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
#endif /* UC */
         if (drawOrigX + drawWinW > paperWidth || drawOrigX + drawWinW > old_w)
         {
            if (drawOrigX + drawWinW > paperWidth)
               drawOrigX = max(0,paperWidth-drawWinW);
            changed = TRUE;
         }
         if (drawOrigY + drawWinH > paperHeight || drawOrigY + drawWinH > old_h)
         {
            if (drawOrigY + drawWinH > paperHeight)
               drawOrigY = max(0,paperHeight-drawWinH);
            changed = TRUE;
         }
         RedrawScrollBars ();
         break;
      case PORTRAIT:
         pageStyle = PORTRAIT;
#ifndef UC
         paperWidth = 7.5 * PIX_PER_INCH;
         paperHeight = 10 * PIX_PER_INCH;
#else /* UC */
         paperWidth = psPageWidthInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
         paperHeight = psPageHeightInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
#endif /* UC */
         if (drawOrigX + drawWinW > paperWidth || drawOrigX + drawWinW > old_w)
         {
            if (drawOrigX + drawWinW > paperWidth)
               drawOrigX = max(0,paperWidth-drawWinW);
            changed = TRUE;
         }
         if (drawOrigY + drawWinH > paperHeight || drawOrigY + drawWinH > old_h)
         {
            if (drawOrigY + drawWinH > paperHeight)
               drawOrigY = max(0,paperHeight-drawWinH);
            changed = TRUE;
         }
         RedrawScrollBars ();
         break;
      case HIGHLAND:
         pageStyle = HIGHLAND;
#ifndef UC
         paperWidth = 21 * PIX_PER_INCH;
         paperHeight = 15.5 * PIX_PER_INCH;
#else /* UC */
         paperWidth = psPageWidthInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
         paperHeight = psPageHeightInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
#endif /* UC */
         if (drawOrigX + drawWinW > paperWidth || drawOrigX + drawWinW > old_w)
         {
            if (drawOrigX + drawWinW > paperWidth)
               drawOrigX = max(0,paperWidth-drawWinW);
            changed = TRUE;
         }
         if (drawOrigY + drawWinH > paperHeight || drawOrigY + drawWinH > old_h)
         {
            if (drawOrigY + drawWinH > paperHeight)
               drawOrigY = max(0,paperHeight-drawWinH);
            changed = TRUE;
         }
         RedrawScrollBars ();
         break;
      case HIGHPORT:
         pageStyle = HIGHPORT;
#ifndef UC
         paperWidth = 15.5 * PIX_PER_INCH;
         paperHeight = 21 * PIX_PER_INCH;
#else /* UC */
         paperWidth = psPageWidthInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
         paperHeight = psPageHeightInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
#endif /* UC */
         if (drawOrigX + drawWinW > paperWidth || drawOrigX + drawWinW > old_w)
         {
            if (drawOrigX + drawWinW > paperWidth)
               drawOrigX = max(0,paperWidth-drawWinW);
            changed = TRUE;
         }
         if (drawOrigY + drawWinH > paperHeight || drawOrigY + drawWinH > old_h)
         {
            if (drawOrigY + drawWinH > paperHeight)
               drawOrigY = max(0,paperHeight-drawWinH);
            changed = TRUE;
         }
         RedrawScrollBars ();
         break;
      case SLIDELAND:
         pageStyle = SLIDELAND;
#ifndef UC
         paperWidth = 5 * PIX_PER_INCH;
         paperHeight = 3.75 * PIX_PER_INCH;
#else /* UC */
         paperWidth = psPageWidthInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
         paperHeight = psPageHeightInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
#endif /* UC */
         if (drawOrigX + drawWinW > paperWidth || drawOrigX + drawWinW > old_w)
         {
            if (drawOrigX + drawWinW > paperWidth)
               drawOrigX = max(0,paperWidth-drawWinW);
            changed = TRUE;
         }
         if (drawOrigY + drawWinH > paperHeight || drawOrigY + drawWinH > old_h)
         {
            if (drawOrigY + drawWinH > paperHeight)
               drawOrigY = max(0,paperHeight-drawWinH);
            changed = TRUE;
         }
         RedrawScrollBars ();
         break;
      case SLIDEPORT:
         pageStyle = SLIDEPORT;
#ifndef UC
         paperWidth = 3.75 * PIX_PER_INCH;
         paperHeight = 5 * PIX_PER_INCH;
#else /* UC */
         paperWidth = psPageWidthInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
         paperHeight = psPageHeightInInch[cmUnit][pageStyle] *
	     PIX_PER_INCH_OR_CM;
#endif /* UC */
         if (drawOrigX + drawWinW > paperWidth || drawOrigX + drawWinW > old_w)
         {
            if (drawOrigX + drawWinW > paperWidth)
               drawOrigX = max(0,paperWidth-drawWinW);
            changed = TRUE;
         }
         if (drawOrigY + drawWinH > paperHeight || drawOrigY + drawWinH > old_h)
         {
            if (drawOrigY + drawWinH > paperHeight)
               drawOrigY = max(0,paperHeight-drawWinH);
            changed = TRUE;
         }
         RedrawScrollBars ();
         break;
   }
   return (changed);
}

static void ChangePageStyle (NewPageStyle, PageStyleStr)
   int	NewPageStyle;
   char	* PageStyleStr;
{
   char msg[MAXSTRING];

   if (pageStyle != NewPageStyle)
   {
      if (UpdPageStyle (NewPageStyle))
      {
         UpdDrawWinBBox ();
         AdjSplineVs ();
         ClearAndRedrawDrawWindow ();
      }
      RedrawRulers ();
      SetFileModified (TRUE);
      sprintf (msg, "Page style changed to %s.", PageStyleStr);
      Msg (msg);
   }
}

void LayoutMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid;
   register int	i;
   char		* menu_strings[MAXLAYOUTMENUS], * str_ptr;

   str_ptr = (char *) calloc (MAX_LAYOUT_STR*MAXLAYOUTMENUS, sizeof(char));
   for (i = 0; i < MAXLAYOUTMENUS; i++, str_ptr += MAX_LAYOUT_STR)
   {
      menu_strings[i] = str_ptr;
      strcpy (menu_strings[i], layoutMenuStr[i]);
   }

   if (gridShown)
      strcpy (menu_strings[LAYOUT_GRID], hideGridStr);
   else
      strcpy (menu_strings[LAYOUT_GRID], showGridStr);
   if (gridOn)
      strcpy (menu_strings[LAYOUT_SNAP], snapOffStr);
   else
      strcpy (menu_strings[LAYOUT_SNAP], snapOnStr);
   switch (whereToPrint)
   {
      case PRINTER:
         strcpy (menu_strings[LAYOUT_TOGGLE_WHERE_TO_PRINT], latexFigStr);
         break;
      case LATEX_FIG:
         strcpy (menu_strings[LAYOUT_TOGGLE_WHERE_TO_PRINT], psFileStr);
         break;
      case PS_FILE:
         strcpy (menu_strings[LAYOUT_TOGGLE_WHERE_TO_PRINT], xbmStr);
         break;
      case XBM_FILE:
         strcpy (menu_strings[LAYOUT_TOGGLE_WHERE_TO_PRINT], printerStr);
         break;
   }
   if (colorDump)
      strcpy (menu_strings[LAYOUT_TOGGLE_COLOR_PS], bwPostScriptStr);
   else
      strcpy (menu_strings[LAYOUT_TOGGLE_COLOR_PS], colorPostScriptStr);
#ifdef UC
   if (dotOnGrid)
      strcpy (menu_strings[LAYOUT_TOGGLE_DOT_GRID], dotOffGridStr);
   else
      strcpy (menu_strings[LAYOUT_TOGGLE_DOT_GRID], dotOnGridStr);
   if (showSize)
      strcpy (menu_strings[LAYOUT_TOGGLE_SIZE], hideSizeStr);
   else
      strcpy (menu_strings[LAYOUT_TOGGLE_SIZE], showSizeStr);
   if (saveWithEps)
      strcpy (menu_strings[LAYOUT_TOGGLE_SWE], saveWithEpsOFFStr);
   else
      strcpy (menu_strings[LAYOUT_TOGGLE_SWE], saveWithEpsONStr);
   if (cmUnit)
      strcpy (menu_strings[LAYOUT_TOGGLE_UNIT], inchUnitStr);
   else
      strcpy (menu_strings[LAYOUT_TOGGLE_UNIT], cmUnitStr);
#endif /* UC */

   DefaultColorArrays (MAXLAYOUTMENUS, &fore_colors, &valid);
   index = TextMenuLoop (X, Y, menu_strings, MAXLAYOUTMENUS,
#ifndef UC
         fore_colors, valid, SINGLECOLOR);
#else /* UC */
         fore_colors, valid, SINGLECOLOR, MENU_LAYOUT);
#endif /* UC */

   cfree (menu_strings[0]);

   switch (index)
   {
      case LAYOUT_INCGRID: IncGrid (); break;
      case LAYOUT_DECGRID: DecGrid (); break;
      case LAYOUT_GRID: ToggleGridShown (); break;
      case LAYOUT_SNAP: ToggleSnapOn (); break;
      case LAYOUT_ZOOMIN: ZoomIn (); break;
      case LAYOUT_ZOOMOUT: ZoomOut (); break;
      case LAYOUT_LAND: ChangePageStyle (LANDSCAPE, "LandScape"); break;
      case LAYOUT_PORT: ChangePageStyle (PORTRAIT, "Portrait"); break;
      case LAYOUT_HILAND: ChangePageStyle (HIGHLAND, "HighLand"); break;
      case LAYOUT_HIPORT: ChangePageStyle (HIGHPORT, "HighPort"); break;
      case LAYOUT_SLIDELAND: ChangePageStyle (SLIDELAND, "SlideLand"); break;
      case LAYOUT_SLIDEPORT: ChangePageStyle (SLIDEPORT, "SlidePort"); break;
      case LAYOUT_TOGGLE_WHERE_TO_PRINT: ToggleWhereToPrint (); break;
      case LAYOUT_TOGGLE_COLOR_PS: ToggleColorPostScript (); break;
#ifdef UC
      case LAYOUT_TOGGLE_DOT_GRID: ToggleDotOnGrid (); break;
      case LAYOUT_TOGGLE_SIZE: ToggleShowSize (); break;
      case LAYOUT_TOGGLE_SWE: ToggleSaveWithEps (); break;	  
      case LAYOUT_TOGGLE_UNIT: ToggleUnit (); break;	  
#endif /* UC */
   }
}

void GridXY (X, Y, GridX, GridY)
   int	X, Y, * GridX, * GridY;
{
   register int	dx, dy;

   if (gridOn)
   {
      dx = (X+drawOrigX) % xyGrid;
      if (dx < xyGrid / 2)
         *GridX = X - dx;
      else
         *GridX = X - dx + xyGrid;
      dy = (Y+drawOrigY) % xyGrid;
      if (dy < xyGrid / 2)
         *GridY = Y - dy;
      else
         *GridY = Y - dy + xyGrid;
   }
   else
   {
      *GridX = X;
      *GridY = Y;
   }
}

void CleanUpGrids ()
{
}
