/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/group.c,v 2.0 91/03/05 12:47:26 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "attr.e"
#include "dup.e"
#include "file.e"
#include "obj.e"
#include "select.e"
#include "setup.e"

static struct SelRec	* tmpTopSel, * tmpBotSel;

void CreateGroupObj (TopObjPtr, BotObjPtr)
   struct ObjRec	* TopObjPtr, * BotObjPtr;
{
   struct GroupRec	* group_ptr;
   struct ObjRec	* obj_ptr;

   group_ptr = (struct GroupRec *) calloc (1, sizeof(struct GroupRec));
   group_ptr->first = TopObjPtr;
   group_ptr->last = BotObjPtr;
   obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   obj_ptr->x = selObjLtX; /* note:  selLtX, selLtY are absolute */
   obj_ptr->y = selObjLtY;
   obj_ptr->type = OBJ_GROUP;
   obj_ptr->bbox.ltx = selLtX;
   obj_ptr->bbox.lty = selLtY;
   obj_ptr->bbox.rbx = selRbX;
   obj_ptr->bbox.rby = selRbY;
   obj_ptr->obbox.ltx = selObjLtX;
   obj_ptr->obbox.lty = selObjLtY;
   obj_ptr->obbox.rbx = selObjRbX;
   obj_ptr->obbox.rby = selObjRbY;
   obj_ptr->detail.r = group_ptr;
   obj_ptr->fattr = obj_ptr->lattr = NULL;
   AddObj (NULL, topObj, obj_ptr);
}

void SaveGroupObj (FP, ObjPtr, Level)
   FILE			* FP;
   struct ObjRec	* ObjPtr;
   int			Level;
{
   fprintf (FP, "group([\n");
   Save (FP, ObjPtr->detail.r->last, Level+1);
   fprintf (FP, "],");
   SaveAttrs (FP, ObjPtr->lattr);
   fprintf (FP, ")");
}

void SaveCompObj (FP, ObjPtr, Level)
   FILE			* FP;
   struct ObjRec	* ObjPtr;
   int			Level;
{
   fprintf (FP, "sym([\n");
   Save (FP, ObjPtr->detail.r->last, Level+1);
   fprintf (FP, "],");
   SaveAttrs (FP, ObjPtr->lattr);
   fprintf (FP, ")");
}

void SaveIconObj (FP, ObjPtr, Level)
   FILE			* FP;
   struct ObjRec	* ObjPtr;
   int			Level;
{
   fprintf (FP, "icon([\n");
   Save (FP, ObjPtr->detail.r->last, Level+1);
   fprintf (FP, "],\n");
   fprintf (FP, "\"%s\",%1d,", ObjPtr->detail.r->s,ObjPtr->id);
   SaveAttrs (FP, ObjPtr->lattr);
   fprintf (FP, ")");
}

void ReadGroupObj (FP, ObjPtr, PRTGIF)
   FILE			* FP;
   struct ObjRec	* * ObjPtr;
   int			PRTGIF;
{
   struct GroupRec	* group_ptr;
   struct ObjRec	* top_obj = NULL, * bot_obj = NULL, * obj_ptr;
   int			ltx, lty, rbx, rby;
   int			obj_ltx, obj_lty, obj_rbx, obj_rby;

   * ObjPtr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));

   while (ReadObj (FP, &obj_ptr, PRTGIF))
   {
      obj_ptr->next = top_obj;
      if (top_obj == NULL)
         bot_obj = obj_ptr;
      else
         top_obj->prev = obj_ptr;
      top_obj = obj_ptr;
   }
   top_obj->prev = NULL;

   group_ptr = (struct GroupRec *) calloc (1, sizeof(struct GroupRec));
   group_ptr->first = top_obj;
   group_ptr->last = bot_obj;

   ltx = top_obj->bbox.ltx;
   lty = top_obj->bbox.lty;
   rbx = top_obj->bbox.rbx;
   rby = top_obj->bbox.rby;
   obj_ltx = top_obj->obbox.ltx;
   obj_lty = top_obj->obbox.lty;
   obj_rbx = top_obj->obbox.rbx;
   obj_rby = top_obj->obbox.rby;
   for (obj_ptr = top_obj->next; obj_ptr != NULL; obj_ptr = obj_ptr->next)
   {
      if (obj_ptr->bbox.ltx < ltx) ltx = obj_ptr->bbox.ltx;
      if (obj_ptr->bbox.lty < lty) lty = obj_ptr->bbox.lty;
      if (obj_ptr->bbox.rbx > rbx) rbx = obj_ptr->bbox.rbx;
      if (obj_ptr->bbox.rby > rby) rby = obj_ptr->bbox.rby;
      if (obj_ptr->obbox.ltx < obj_ltx) obj_ltx = obj_ptr->obbox.ltx;
      if (obj_ptr->obbox.lty < obj_lty) obj_lty = obj_ptr->obbox.lty;
      if (obj_ptr->obbox.rbx > obj_rbx) obj_rbx = obj_ptr->obbox.rbx;
      if (obj_ptr->obbox.rby > obj_rby) obj_rby = obj_ptr->obbox.rby;
   }
   
   (*ObjPtr)->x = obj_ltx;
   (*ObjPtr)->y = obj_lty;
   (*ObjPtr)->type = OBJ_GROUP;
   (*ObjPtr)->bbox.ltx = ltx;
   (*ObjPtr)->bbox.lty = lty;
   (*ObjPtr)->bbox.rbx = rbx;
   (*ObjPtr)->bbox.rby = rby;
   (*ObjPtr)->obbox.ltx = obj_ltx;
   (*ObjPtr)->obbox.lty = obj_lty;
   (*ObjPtr)->obbox.rbx = obj_rbx;
   (*ObjPtr)->obbox.rby = obj_rby;
   (*ObjPtr)->detail.r = group_ptr;
}

void FreeGroupObj (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register struct ObjRec	* ptr;

   for (ptr = ObjPtr->detail.r->first; ptr != NULL; ptr = ptr->next)
      FreeObj (ptr);

   cfree (ObjPtr->detail.r);
   cfree (ObjPtr);
}

static
void UngroupObj (ObjPtr)
   struct ObjRec	* ObjPtr;
   /* ungroup the grouped object ObjPtr to a list of objects   */
   /* when returns, a list of select pointers will be created, */
   /*    tmpTopSel will point to the top of the list, and      */
   /*    tmpBotSel will point to the bottom of the list.       */
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr = ObjPtr->detail.r->last;

   tmpTopSel = tmpBotSel = NULL;

   for ( ; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
   {
      sel_ptr = (struct SelRec *) calloc (1, sizeof(struct SelRec));
      sel_ptr->obj = obj_ptr;
      sel_ptr->next = tmpTopSel;
      if (tmpTopSel == NULL)
         tmpBotSel = sel_ptr;
      else
         tmpTopSel->prev = sel_ptr;
      tmpTopSel = sel_ptr;
   }
   tmpTopSel->prev = NULL;
}

void UngroupSelObj ()
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				sel_ltx, sel_lty, sel_rbx, sel_rby;

   if (topSel == NULL) return;

   sel_ltx = selLtX; sel_lty = selLtY;
   sel_rbx = selRbX; sel_rby = selRbY;

   HighLightReverse ();
   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      if (obj_ptr->type == OBJ_GROUP)
      {
         UngroupObj (obj_ptr);
         DetachGroupAttrs (obj_ptr, &tmpTopSel, &tmpBotSel);

         obj_ptr->detail.r->first->prev = obj_ptr->prev;
         if (obj_ptr->prev == NULL)
            topObj = obj_ptr->detail.r->first;
         else
            obj_ptr->prev->next = obj_ptr->detail.r->first;
         obj_ptr->detail.r->last->next = obj_ptr->next;
         if (obj_ptr->next == NULL)
            botObj = obj_ptr->detail.r->last;
         else
            obj_ptr->next->prev = obj_ptr->detail.r->last;

         tmpTopSel->prev = sel_ptr->prev;
         if (sel_ptr->prev == NULL)
            topSel = tmpTopSel;
         else
            sel_ptr->prev->next = tmpTopSel;
         tmpBotSel->next = sel_ptr->next;
         if (sel_ptr->next == NULL)
            botSel = tmpBotSel;
         else
            sel_ptr->next->prev = tmpBotSel;

         cfree (sel_ptr);
         cfree (obj_ptr);
      }
   }
   UpdSelBBox ();
#ifndef UC
   RedrawAreas (botObj,
         sel_ltx-(1<<zoomScale), sel_lty-(1<<zoomScale),
         sel_rbx+(1<<zoomScale), sel_rby+(1<<zoomScale),
         selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
         selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#endif /* UC */
   HighLightForward ();
   SetFileModified (TRUE);
   justDupped = FALSE;
}
