/*
 * Author:	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */

#ifdef KANJI
#include <stdio.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "types.h"
#include "const.h"

#include "file.e"
#include "mainloop.e"
#include "menu.e"
#include "setup.e"
#include "raster.e"
#include "font.e"
#include "kconvert.e"

#define FONT_SIZE_18 4
#define MAX_TEXT 1000
/* WOOPS! for neck16 */
#define DELTA 2

unsigned char stack_text[MAX_TEXT];
XTextItem16 stack_item[MAX_TEXT];

char * Malloc(size)
unsigned int size;
{
    char * p;

    if ((p = (char *)calloc (size)) == NULL)
    {
	exitNormally = FALSE;
	EmergencySave ();
	exit (0);
    }
    return(p);
}

void InitKanji()
{
	init_kanji ();
	init_kconvert ();
}
	
void XDrawEucString(dpy, d, gc, x, y, buf, len, afont, kfont)
Display  	*dpy;
Drawable  	d;
GC  		gc;
int 		x, y;
unsigned char 	*buf;
int 		len;
XFontStruct 	*afont, *kfont;
{
    register unsigned char *p, *endp, *r;
    register XTextItem16 *ri;
    unsigned char *text;    
    XTextItem16 *item;    
    int maxtext, i;
    int xx = x, yy = y;
    int nkanji= 0;

    if (len < MAX_TEXT) {
	text = stack_text;
	maxtext = MAX_TEXT;
	item = stack_item;
    } else {
	text = (unsigned char *)Malloc((unsigned int)len);  
	item = (XTextItem16 *)Malloc((unsigned int)len * sizeof (XTextItem16)); 
	maxtext = len;
    }

    if (!kfont) {
        p = buf; r = text; i = len;
	while(i--)
	     *r++ = *p++ & 0x7f;
	XDrawString(dpy, d, gc, xx, yy, (char *)text, len );
	if (text != stack_text)
	    cfree(text);
	if (item != stack_item)
	    cfree(item);
	return;
    }
    for(p = buf, endp = buf + len; p < endp; )
    {
	if (0x80 & *p)
	{
	    if (!canvasKanjiFontIsFake && curSize == FONT_SIZE_18 &&
		    ((curFont == FONT_MIN && Use16as18.mincho) || (curFont == FONT_GOT && Use16as18.gothic)))
	    {
		/* The followings are a program for FAKE KANJI FONT */
		for (r = text, ri = item ; p < endp && (0x80 & *p) && r - text < maxtext ; p += 2, r += 2)
		{
		    ri->chars = (XChar2b *)r; ri->nchars = 1;
		    if (p != buf)
			ri->delta = DELTA;	
		    else
		    { 
			ri->delta = 0;
			nkanji = DELTA;
		    }
		    ri->font = None; ri++;
		    *r = 0x7f & *p;
		    *(r+1) = 0x7f & *(p+1);
		}
		XSetFont(dpy, gc, kfont->fid); 
		XDrawText16(dpy, d, gc, xx, yy, (XTextItem16 *)item, (r - text)/2); 
		if (curFont == FONT_GOT && UseMinchoAsGothic[curSize])
		    XDrawText16(dpy, d, gc, xx+1, yy, (XTextItem16 *)item, (r - text)/2);
		xx += XTextWidth16(kfont, (XChar2b *)text, (r - text)/2) + (r - text - nkanji);
	    }
	    else
	    {
		for (r = text; p < endp && (0x80 & *p) && r - text < maxtext; p += 2, r += 2) {
		    *r = 0x7f & *p;
		    *(r+1) = 0x7f & *(p+1);
		}
		XSetFont(dpy, gc, kfont->fid);
		XDrawString16(dpy, d, gc, xx, yy, (XChar2b *)text, (r - text)/2);
		if (curFont == FONT_GOT && UseMinchoAsGothic[curSize])
		    XDrawString16(dpy, d, gc, xx+1, yy, (XChar2b *)text, (r - text)/2);
		xx += XTextWidth16(kfont, (XChar2b *)text, (r - text)/2);
	    }		
	}
	else
	{
	    for (r = p;  p < endp && !(0x80 & *p); p++)
		;
	    XSetFont(dpy, gc, afont->fid); 
	    XDrawString(dpy, d, gc, xx, yy, (char *)r,p-r-(isprint(*(p-1))?0:1));
	    xx += XTextWidth(afont, (char *)r, p - r);
	}
    }
    XSetFont(dpy, gc, afont->fid); 

    if (text != stack_text)
	cfree(text);
    if (item != stack_item)
	cfree(item);
}

void XDrawEucImageString(dpy, d, gc, x, y, buf, len, afont, kfont)
Display  *dpy;
Drawable  d;
GC  gc;
int x, y;
unsigned char *buf;
int len;
XFontStruct *afont, *kfont;
{
    register unsigned char *p, *endp, *r, *text;
    int maxtext, i;
    int xx = x, yy = y;	

    if (len <= MAX_TEXT) {
	text = stack_text;
	maxtext = MAX_TEXT;
    } else {
	text = (unsigned char *)Malloc((unsigned int)len);
	maxtext = len;
    }

    if (!kfont) {
        p = buf; r = text; i = len;
	while(i--)
	     *r++ = *p++ & 0x7f;
	XDrawImageString(dpy, d, gc, xx, yy, (char *)text, len );

	if (text != stack_text)
	    cfree(text);
	return;
    }

    for(p = buf, endp = buf + len; p < endp; )
    {
	if (0x80 & *p)
	{
	    for (r = text ; p < endp && (0x80 & *p) && r - text < maxtext ; p += 2, r += 2)
	    {
		*r = 0x7f & *p;
		*(r+1) = 0x7f & *(p+1);
	    }
	    XSetFont(dpy, gc, kfont->fid); 
	    XDrawImageString16(dpy, d, gc, xx, yy, (XChar2b *)text, (r - text)/2);
	    xx += XTextWidth16(kfont, (XChar2b *)text, (r - text)/2);
	} else {
	    for (r = p;  p < endp && !(0x80 & *p); p++)
		;
	    XSetFont(dpy, gc, afont->fid); 
	    XDrawImageString(dpy, d, gc, xx, yy, (char *)r,
			     p-r-(isprint(*(p-1))?0:1));
	    xx += XTextWidth(afont, (char *)r, p - r);
	}
    }
    XSetFont(dpy, gc, afont->fid);

    if (text != stack_text)
	cfree(text);
}

int XEucTextWidth(afont, kfont, string, num_string, fakeFont)
XFontStruct 	* afont, *kfont;
unsigned char 	* string;
int 		num_string;
int 		fakeFont;
{
    register unsigned char *p, *endp, *r, *text;
    int i, len = 0, maxtext;

    if (num_string <= MAX_TEXT) {
	text = stack_text;
	maxtext = MAX_TEXT;
    } else {
	text = (unsigned char*)Malloc((unsigned int)num_string);
	maxtext = num_string;
    }

    if (! kfont) {
    	p = string; r = text; i = num_string;
	while (i--)
	    *r++ = 0x7f & *p++;

        len = XTextWidth(afont, (char *)text, num_string);

	if (text != stack_text)
		cfree(text);

	return (len);
    }

    for(p = string, endp = string + num_string; p < endp; )
    {
	if (0x80 & *p) {
	    for (r = text; p < endp && (0x80 & *p) && r - text < maxtext; p += 2, r += 2) {
		*r = 0x7f & *p;
		*(r+1) = 0x7f & *(p+1);
	    }
	    if (fakeFont)
		len += (((r - text)/2) * pointSize75[curSize]);
	    else
		len += XTextWidth16(kfont, (XChar2b *)text, (r - text)/2);
	    if (! canvasKanjiFontIsFake && curSize == FONT_SIZE_18)
	    {
		if ((curFont == FONT_MIN && Use16as18.mincho) || (curFont == FONT_GOT && Use16as18.gothic))
		    len += r - text;
	    }
	}
	else
	{
	    for (r = p;  p < endp && !(0x80 & *p); p++)
		;
	    len += XTextWidth(afont, (char *)r, p - r);
	}
    }
    
    if (text != stack_text)
	cfree(text);

    return (len);
}


/* The followings are From Nemacs-3.3 */

#define ESC_CODE 033
#define JIS_P(c) (jcode_table[(unsigned char)c] & 2)
#define EUC_P(c) (jcode_table[(unsigned char)c] & 4)

unsigned char jcode_table[256];

init_kanji()
{
  int i;

  bzero(jcode_table, 256);
  for (i = 0x80; i <= 0x9f; i++) jcode_table[i] |= 1;
  for (i = 0xe0; i <= 0xef; i++) jcode_table[i] |= 1;
  for (i = 0x21; i < 0x7f; i++) jcode_table[i] |= 2;
  for (i = 0xa1; i < 0xff; i++) jcode_table[i] |= 4;
}

to_ascii(buf)
     unsigned char *buf;
{
  return (*buf++ == ESC_CODE &&
	  *buf++ == '(' &&
	  (*buf == 'J' || *buf == 'B' || *buf == 'H'));
}

to_kanji(buf)
     unsigned char *buf;
{
  return (*buf++ == ESC_CODE &&
	  *buf++ == '$' &&
	  (*buf == '@' || *buf == 'B'));
}

j2e(n, jbuf, ebuf)
     int n;
     unsigned char *jbuf, *ebuf;
{
  unsigned char *endp = jbuf + n - 2;
  unsigned char *startp = ebuf;
  int kanji = 0;

  while (jbuf < endp) {
    if (to_kanji(jbuf)) {
      kanji = 1; jbuf += 3;
    } else if (to_ascii(jbuf)) {
      kanji = 0; jbuf += 3;
    } else if (kanji && JIS_P(*jbuf) && JIS_P(*(jbuf + 1)) ) {
      *ebuf++ = *jbuf++ | 0x80;
      *ebuf++ = *jbuf++ | 0x80;
    } else
      *ebuf++ = *jbuf++;
  }
  if (jbuf == endp) {
    if (kanji && JIS_P(*jbuf) && JIS_P(*(jbuf + 1)) ) {
      *ebuf++ = *jbuf++ | 0x80;
      *ebuf++ = *jbuf++ | 0x80;
    } else {
      *ebuf++ = *jbuf++;
      *ebuf++ = *jbuf++;
    }
  } else if (jbuf == endp + 1)
    *ebuf++ = *jbuf++;
  return (ebuf - startp);
}

e2j(n, ebuf, jbuf, to_kanji_code, to_ascii_code)
     int n;
     unsigned char *ebuf, *jbuf, to_kanji_code, to_ascii_code;
{
  unsigned char *endp = ebuf + n - 1;
  unsigned char *startp = jbuf;
  int kanji = 0;

  while (ebuf < endp) {
    if (kanji) {
      if (EUC_P(*ebuf)) {
	*jbuf++ = *ebuf++ & 0x7f;
	*jbuf++ = *ebuf++ & 0x7f;
      } else {
	*jbuf++ = ESC_CODE; *jbuf++ = '('; *jbuf++ = to_ascii_code;
	*jbuf++ = *ebuf++;
	kanji = 0;
      }
    } else {
      if (EUC_P(*ebuf)) {
	*jbuf++ = ESC_CODE; *jbuf++ = '$'; *jbuf++ = to_kanji_code;
	*jbuf++ = *ebuf++ & 0x7f;
	*jbuf++ = *ebuf++ & 0x7f;
	kanji = 1;
      } else
	*jbuf++ = *ebuf++;
    }
  }
  if (kanji) {
    *jbuf++ = ESC_CODE; *jbuf++ = '('; *jbuf++ = to_ascii_code;
  }
  if (ebuf == endp) *jbuf++ = *ebuf++;
  return (jbuf - startp);
}
#endif /* KANJI */
