#ifdef KINPUT
/*
 * Modified By:	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */

/*
 * Copyright (c) 1989  Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * Author:  Makoto Ishisone, Software Research Associates, Inc., Japan
 *		ishisone@sra.co.jp
 */
#include "const.h"
#include "kconvert.h"

#include "text.e"
#include "setup.e"
#include "mainloop.e"
    
int fid [2];

#define COMMAND "kinput"
#define CCDEFOP "-ccdef"
#define JSERVEROP "-jserver"

#define READPIPE 0
#define WRITEPIPE 1

#ifdef SYSV
#define MAXPATHLEN 1024
#define MAXHOSTNAMELEN 64    
#endif /* SYSV */

extern char * getenv ();
static char * kinputCommand [9];
static char   ccdefStr [MAXPATHLEN];
static char   jserverHostStr [MAXHOSTNAMELEN];

int	kinputOn = FALSE;
int	autoKinput = FALSE;
int     kinputStatus = RETRY;

int	kinputPid = 0;

#ifndef LCHAR_T
#define LCHAR_T
typedef unsigned short	lchar_t;
#endif

extern void	_beginConversion();
extern int	convCTtoJWS();
extern int	convWStoEUC();
extern int	convWStoSJIS();
extern int	convWStoJIS();
extern int	convEUCtoWS();

static Atom	japanese_conversion_atom;	/* JAPANESE_CONVERSION */
static Atom	compound_text_atom;		/* COMPOUND_TEXT */
static int	atominitialized;

static void
inputString(w, selection, type, format, size, str, client_data)
Widget		w;
Atom		selection;
Atom		type;
int		format;
unsigned long	size;
unsigned char	*str;
caddr_t		client_data;
{
	unsigned char	lbuf[256 + 1];
	unsigned char	*lstr, *p, *lp;
	int		n;
	int		(*convfunc)();

	if (str == NULL)
		return;

	if (type == compound_text_atom && format == 8) {
		lchar_t		wbuf[256 + 1];
		lchar_t		*ws;
		n = convCTtoJWS(str, size, NULL);
		ws = (n > 256) ? (lchar_t *)XtMalloc((n+1) * sizeof(lchar_t))
			       : wbuf;
		(void)convCTtoJWS(str, size, ws);
		convfunc = convWStoEUC;
		n = (*convfunc)(ws, NULL);
		lstr = (n > 256) ? (unsigned char *)XtMalloc(n + 1) : lbuf;
		(void)(*convfunc)(ws, lstr);
		if (ws != wbuf) XtFree(ws);
	} else {
		/* ignore unknown type */
		XtFree(str);
		return;
	}
	/*
	 * insert KANJI string into tgif text object
	 */
	
	/* WOOP! Is this my misunderstanding? */
	if (n != 1)
	    *(lstr + n) = '\0';
	
	myInsertTextObj (lstr);

	XtFree(str);
	if (lstr != lbuf) XtFree(lstr);
}

void
BeginConversion(w, event, params, nparams)
Widget	w;
XEvent	*event;
String	*params;
Cardinal	*nparams;
{
	Atom	catom;

	if (!atominitialized) {
		japanese_conversion_atom =
		    XInternAtom(XtDisplay(w), "JAPANESE_CONVERSION", False);
		compound_text_atom =
		    XInternAtom(XtDisplay(w), "COMPOUND_TEXT", False);
		atominitialized = 1;
	}

	catom = japanese_conversion_atom;

	_beginConversion(w, catom, compound_text_atom, inputString, NULL);
}

/* By Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp) */
void
EndConversion(w, params, nparams)
Widget	w;
String	*params;
Cardinal	*nparams;
{
	Atom	catom;

	if (!atominitialized) {
		japanese_conversion_atom =
		    XInternAtom(XtDisplay(w), "JAPANESE_CONVERSION", False);
		compound_text_atom =
		    XInternAtom(XtDisplay(w), "COMPOUND_TEXT", False);
		atominitialized = 1;
	}

	catom = japanese_conversion_atom;

	_endConversion(w, catom, TRUE);
}
/*
 * The below routines are for tgif+'s kinput facility.
 *
 * Author: Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 */



/*
 * Initialize routine
 */

XWindowAttributes drawWwa;

void init_kconvert ()
{
    if (! XGetWindowAttributes (mainDisplay, drawWindow, &drawWwa))
       {
	   fprintf (stderr, "XGetWindowAttributes error\n");
	   exit (1);
       }
}


/*
 * routines for execing kinput automatically
 */

#define MAXMSG 180
#define CONNECTIONFAIL "can't connect to jserver"

int MyStrStr (str1, str2)
char * str1, *str2;
{
    register char * s1 = str1, *s2 = str2;

    while (*s1++ != *s2 && *s1 != '\0')
    {
	continue;
    }
    if (*s1 =='\0') return (FALSE);
    s2++;
    if (*s1 != *s2)
	return (FALSE);
    if (strncmp (s1, s2, sizeof(s2))==0)
	return (TRUE);
    return (FALSE);
}

void
MyExecError()
{
    char	errMsg[MAXMSG+1];
    int		count, retry = FALSE;

#ifndef SYSV
    signal (SIGCHLD, SIG_DFL);
#else /* SYSV */
    signal (SIGCLD, SIG_DFL);
#endif /* SYSV */
    kinputPid = 0;
    
    if ((count = read (fid[READPIPE], errMsg, MAXMSG-60)) < 0)
    {
	Msg("PIPE read error");
	kinputCommand[0] = (char * ) NULL;
	kinputStatus = FAIL;
    }
    else if (count > 0)
    {
	errMsg[count] = '\0';
	if (retry = MyStrStr (&errMsg[0], CONNECTIONFAIL))
	{
	    strcat(&errMsg[count],
		   "\nEnter Another Jserver Host Name? (return to quit)");
	    Dialog (&errMsg[0], jserverHostStr);
	    if (jserverHostStr[0] != '\0')
		kinputStatus = RETRY;
	    else
	    {
		kinputCommand[0] = (char * ) NULL;
		kinputStatus = FAIL;
	    }
	}
	else
	{
	    YesNoCancel(&errMsg[0]);
	    kinputCommand[0] = (char * ) NULL;
	    kinputStatus = FAIL;
	}
    }
    else
    {
	kinputCommand[0] = (char * ) NULL;
	kinputStatus = FAIL;
    }
    close (fid[READPIPE]);
}

/*
 * if successed, pid is retuened
 */
int MyExec (cmd, args)
char * cmd, ** args;
{
    int pid;
    
    if (pipe (fid) < 0)
    {
	switch(YesNoCancel("pipe creation error"))
	{
	   case CONFIRM_YES: break;
	   case CONFIRM_NO: break;
	   case CONFIRM_CANCEL:break;
	}
	return(FALSE);
    }
#ifdef SYSV
    signal (SIGCLD, MyExecError);
    if ((pid = fork()) == 0)
#else /* SYSV */
    signal (SIGCHLD, MyExecError);
    if ((pid = vfork()) == 0)
#endif /* SYSV */	
    {
	close (1); dup (fid [WRITEPIPE]);
	close (2); dup (fid [WRITEPIPE]);
	close (0);
	close (fid [WRITEPIPE]);
	close (fid [READPIPE]);
	execvp (cmd, args);perror("");
	exit (1);

    }
    close (fid [WRITEPIPE]);
    if (pid < 0)
    {
	close (fid[READPIPE]);
	switch(YesNoCancel("fork() failed"))
	{
	   case CONFIRM_YES: break;
	   case CONFIRM_NO: break;
	   case CONFIRM_CANCEL:break;
	}
	return (FALSE);
    }
    return (pid);
}

int CheckCcdefFile (ccdefFile)
char * ccdefFile;
{
    int		i;
    int		done = 1;
    FILE	* fp;
    char	msg[MAXPATHLEN + 70];
    char	usCcdef[MAXPATHLEN];

    strcpy (usCcdef, ccdefFile);
    while (done)
    {
	if ((fp = fopen (usCcdef, "r")) == NULL)
	{
	    sprintf (msg, "CCDEF (%s) not found\nPlease Enter CCDEF File Name(retrn to quit kinput)", usCcdef);
	    Dialog (&msg[0], &usCcdef[0]);
	    if (usCcdef[0] == '\0')
		done = 0;
	    continue;
	}
	strcpy (&ccdefStr[0], &usCcdef[0]);
	fclose (fp);
	return (TRUE);
    }
    return (FALSE);    
}

/*
 * if successed, return kinpt's pid
 */
int ExecKinput ()
{
    int 	i = 0, pid;
    char 	* c_ptr;
    
    if ((kinputCommand[0]) != NULL)
	goto exec;

    if ((c_ptr = getenv ("CC_DEF")) != NULL)
    {
	strcpy(ccdefStr, c_ptr);
    }
    else
    {
	strcpy(ccdefStr, CCDEF);
    }

    if (CheckCcdefFile (ccdefStr) == FALSE)
	    return (FALSE);

    if ((c_ptr = getenv ("JSERVER")) != NULL)
    {
	strcpy(jserverHostStr, c_ptr);
    }
    else
    {
	strcpy(jserverHostStr, JSERVERHOST);
    }

    kinputCommand[i] = COMMAND; i++;
    kinputCommand[i] = CCDEFOP; i++;
    kinputCommand[i] = ccdefStr; i++;
    kinputCommand[i] = JSERVEROP; i++;
    kinputCommand[i] = jserverHostStr; i++;
    if (displayName != NULL)
    {
	kinputCommand[i] = "-display"; i++;
	kinputCommand[i] = displayName; i++;
    }
    kinputCommand[i] = (char * ) NULL;

 exec:
    kinputStatus = FAIL;
    
    if (pid = MyExec (COMMAND, kinputCommand))
    {
	kinputStatus = EXECING;
	sleep (3);
	return (kinputPid = pid);
    }
    else if (kinputStatus == RETRY)
	goto exec;

    return (kinputStatus);
}



/*
 * The followings are fake Xt libraries.
 */

/*
 * Mask for Event handling
 */
int enableNoEventMask = FALSE, enablePropertyChangeMask = FALSE;
int enableClientMessage = FALSE;

void XtAddEventHandler(widget, eventMask, other, proc, closure)
    Widget	    widget;
    EventMask       eventMask;
    Boolean         other;
    XtEventHandler  proc;
    XtPointer	    closure;
{
    EventMask newMask;
    
    switch (eventMask)
    {
       case NoEventMask: 	enableNoEventMask = TRUE; 	break;
       case PropertyChangeMask:
	   enablePropertyChangeMask = TRUE;
	   newMask = drawWwa.your_event_mask | PropertyChangeMask;
	   if (newMask != drawWwa.your_event_mask)
	       XSelectInput (XtDisplay (widget), XtWindow (widget), newMask);
	   break;
    }
    if (other)
       enableClientMessage = TRUE;
}

void XtRemoveEventHandler(widget, eventMask, other, proc, closure)
    Widget	    widget;
    EventMask       eventMask;
    Boolean         other;
    XtEventHandler  proc;
    XtPointer	    closure;
{
    EventMask newMask;
    
    switch (eventMask)
    {
       case NoEventMask: 	enableNoEventMask = FALSE; 	break;
       case PropertyChangeMask:
	   newMask = drawWwa.your_event_mask ^ PropertyChangeMask;
	   if (newMask != drawWwa.your_event_mask)
	       XSelectInput (XtDisplay (widget), XtWindow (widget), newMask);
	   enablePropertyChangeMask = FALSE;
	   break;
    }
    if (other)
       enableClientMessage = FALSE;
}    

WidgetRec widgetRec;

void BeginKanjiConversion (display, window, event)
Display * display;
Window window;
XEvent * event;
{
    Widget widget = &widgetRec;

    widget->window = window;
    widget->display = display;

    BeginConversion (widget, event, "JAPANESE_CONVERSION", 1);
}

void EndKanjiConversion (display, window)
Display * display;
Window window;
{
    Widget widget = &widgetRec;

    widget->window = window;
    widget->display = display;

    EndConversion (widget, "JAPANESE_CONVERSION", 1);
}

void kconvertEventHandler (eventFlag, display, window, event)
int eventFlag;
Display * display;
Window window;
XEvent * event;
{
    Widget widget = &widgetRec;

    widget->window = window;
    widget->display = display;

    switch (event->type)
    {
        case PropertyNotify:
	case ClientMessage:
	    getConv(widget, NULL, event);
	    break;
    }

    if (eventFlag == NoEventMask) {
	recvConvAck (widget, NULL, event);
	kinputOn = TRUE;
	RedrawTitleWindow ();
	return;
    }
}      
#endif /* KINPUT */
