/*
 * Author:	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifdef KINPUT
#include <sys/param.h>
#ifndef SYSV
#include <signal.h>
#else /* SYSV */
#include <sys/signal.h>
#endif /* SYSV */
#include <stdio.h>
#include <X11/Xlib.h>
#include "button.e"

/*
 * internal Widget structure
 */
typedef struct _WidgetRec {
    Display *display;
    Window  window;
} WidgetRec;

#define XtDisplay(w) w->display
#define XtWindow(w) w->window

/*
 * Following are from <X11/Intrinsics.h>
 */
  
typedef struct _WidgetRec 	* Widget;
typedef unsigned int		Cardinal;
typedef char			Boolean;
typedef char 			* String;
typedef unsigned long 		EventMask;
typedef char			* XtPointer;

typedef void (*XtEventHandler)(
#if NeedFunctionPrototypes
    Widget 		/* widget */,
    XtPointer 		/* closure */,
    XEvent*		/* event */,
    Boolean*		/* continue_to_dispatch */
#endif
);

#ifndef NULL
#define NULL 0
#endif

/*
 * Defines are for Alloc.c of Xt library
 */

#define XtNew(type) ((type *) XtMalloc((unsigned) sizeof(type)))
#define XtMalloc(size) malloc(size)
#define XtRealloc(ptr, size) realloc(ptr, size)
#define XtFree(ptr) free(ptr)
#define XtWarning(str) fprintf(stderr, str)
#endif /* KINPUT */
