/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/mainloop.c,v 2.0 91/03/05 12:47:27 william Exp $";
#endif

#include <stdio.h>
#include <signal.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "animate.e"
#include "choice.e"
#include "color.e"
#include "copypaste.e"
#include "cursor.e"
#include "dialog.e"
#include "drawing.e"
#include "file.e"
#include "font.e"
#include "grid.e"
#include "menu.e"
#include "msg.e"
#include "names.e"
#include "obj.e"
#include "raster.e"
#include "ruler.e"
#include "scroll.e"
#include "select.e"
#include "setup.e"
#include "stk.e"
#include "text.e"
#include "version.e"
#include "xbitmap.e"
#ifdef UC
#include "mainmenu.e"
#endif /* UC */

int	geometrySpecified = FALSE;
int	exitNormally = FALSE;
char	geometrySpec[80];
char	initMsg1[80], initMsg2[80];

static int	quitDraw = TRUE;
#ifdef UC
char 	* displayName = NULL;
#endif /* UC */

static
void ExecWithFile (CmdName, FileName)
   char	* CmdName, * FileName;
{
   int	pid;
   char	s[255];

   sprintf (s, "xterm -bd red -e %s %s", CmdName, FileName);
   pid = fork ();
   if (pid == 0)
   {
      system (s);
      exit (0);
   }
}

void DeallocStrings (FStr, Str1, Menu1, Str2, Menu2, Str3, Menu3)
   char	* * FStr, * * Str1, * * Menu1, * * Str2, * * Menu2, * * Str3, * * Menu3;
{
   cfree (*FStr);
   cfree (*Str1);
   cfree (*Menu1);
   cfree (*Str2);
   cfree (*Menu2);
   cfree (*Str3);
   cfree (*Menu3);
}

static
void AllocStrings (FStr, Str1, Menu1, Str2, Menu2, Str3, Menu3)
   char	* * FStr, * * Str1, * * Menu1, * * Str2, * * Menu2, * * Str3, * * Menu3;
{
   char		* s;

   if((s = (char *) calloc (80, sizeof(char))) == NULL)
      { printf ("calloc fails!\n"); exit(-1); }
   *FStr =  s;
   if((s = (char *) calloc (80, sizeof(char))) == NULL)
      { printf ("calloc fails!\n"); exit(-1); }
   *Str1 =  s;
   if((s = (char *) calloc (80, sizeof(char))) == NULL)
      { printf ("calloc fails!\n"); exit(-1); }
   *Menu1 = s;
   if((s = (char *) calloc (80, sizeof(char))) == NULL)
      { printf ("calloc fails!\n"); exit(-1); }
   *Str2 =  s;
   if((s = (char *) calloc (80, sizeof(char))) == NULL)
      { printf ("calloc fails!\n"); exit(-1); }
   *Menu2 = s;
   if((s = (char *) calloc (80, sizeof(char))) == NULL)
      { printf ("calloc fails!\n"); exit(-1); }
   *Str3 =  s;
   if((s = (char *) calloc (80, sizeof(char))) == NULL)
      { printf ("calloc fails!\n"); exit(-1); }
   *Menu3 = s;
}

/* 
 * static
 * int MyErrorHandler (display, event)
 *    Display	* display;
 *    XErrorEvent	* event;
 * {
 *    if (event->type == 0) return (TRUE);
 *    printf ("\tError: type -- %1d\n", event->type);
 *    exit (-1);
 * }
 */

void CleanUp ()
{
   CleanUpDrawingWindow ();
   CleanUpStk ();
   CleanUpChoices ();

   CleanUpScrolls ();
   CleanUpCursors ();

   CleanUpRuler ();
   CleanUpRasters ();
   CleanUpFonts ();
   CleanUpMenu ();
   CleanUpNames ();
   CleanUpText ();
   CleanUpColors ();
   CleanUpFiles ();
   CleanUpGrids ();
   CleanUpCutBuffer ();
   CleanUpXBm ();
   CleanUpMsg ();

   DelAllCutSel ();

   XDestroyWindow (mainDisplay, mainWindow);
   if (iconWindowCreated)
   {
      XDestroyWindow (mainDisplay, iconBaseWindow);
      iconWindowCreated = FALSE;
   }
   printf ("%s terminated normally.\n", TOOL_NAME);
}

void MainLoop (Op, FileName, FuncStr, Str1, Menu1, Str2, Menu2, Str3, Menu3)
   char	* Op, * FileName, * * FuncStr;
   char	* * Str1, * * Menu1, * * Str2, * * Menu2, * * Str3, * * Menu3;
{
   XEvent		input;
   char			* c_ptr, file_name[MAXPATHLENGTH], s[MAXPATHLENGTH];
   char			full_name[MAXPATHLENGTH];
   int			shorthand_rc, draw_rc, len;
   struct ObjRec	* obj_ptr;
   FILE			* fp;
#ifdef UC
   int			i, find = 0, mainmenu_rc;
#endif /* UC */

/* printf ("--> MainLoop (%s, %s, ...)\n", Op, FileName); */

   if (strcmp (Op, "init") == 0)
   {
      sprintf (initMsg1, "%s Version %s", TOOL_NAME, version_string);
      sprintf (initMsg2, "Copyright (C) 1990, 1991, William Chia-Wei Cheng");
      printf ("%s\n", initMsg1);
      printf ("%s\n", initMsg2);

      exitNormally = FALSE;
#ifndef UC
      if ((mainDisplay = XOpenDisplay (NULL)) == 0)
#else /* UC */
      if ((mainDisplay = XOpenDisplay (displayName)) == 0)
#endif /* UC */
      {
         printf ("Could not open the default display!  Abort!\n"); /* fool safe */ exit(-1);
      }
      mainScreen = DefaultScreen (mainDisplay);
      mainColormap = DefaultColormap (mainDisplay, mainScreen);
      mainDepth = DefaultDepth (mainDisplay, mainScreen);
      mainVisual = DefaultVisual (mainDisplay, mainScreen);
      rootWindow = RootWindow (mainDisplay, mainScreen);

#ifndef DEBUG
      XSetErrorHandler (EmergencySaveForX);
      XSetIOErrorHandler (EmergencySaveForX);
      signal (SIGHUP, EmergencySave);
      signal (SIGFPE, EmergencySave);
      signal (SIGBUS, EmergencySave);
      signal (SIGSEGV, EmergencySave);
#endif /* DEBUG */

      Setup ();
      TwoLineMsg (initMsg1, initMsg2);
      quitDraw = FALSE;

      if (FileName[0] != '\0')
      {
         len = strlen (FileName);
         if (len >= 4 && strcmp (&FileName[len-4], ".obj") == 0)
            strcpy (file_name, FileName);
         else
            sprintf (file_name, "%s.obj", FileName);

         if ((fp = fopen (file_name, "r")) == NULL)
         {
            sprintf (s, "Can not open '%s'.", file_name);
            Msg (s);
         }
         else
         {
            sprintf (s, "Loading '%s' ...", file_name);
            Msg (s);

            while (ReadObj (fp, &obj_ptr, FALSE))
               if (obj_ptr != NULL)
                  AddObj (NULL, topObj, obj_ptr);

            fclose (fp);

            if (*file_name == '/')
               strcat (full_name, file_name);
            else
               sprintf (full_name, "%s/%s", curDir, file_name);

            SetCurDir (full_name);
            *curSymDir = '\0';
            curFileDefined = TRUE;

            SetFileModified (FALSE);
            sprintf (s, "Current file is '%s'.", file_name);
            Msg (s);
         }
      }
      UpdateDirInfo ();
   }
   SaveDrawWinInfo ();

   if (strcmp (Op, "vi") == 0)
      ExecWithFile ("vi", FileName);

   if (strcmp (Op, "less") == 0)
      ExecWithFile ("less", FileName);

   if (strcmp (Op, "quit") == 0)
   {
      CleanUp ();
      quitDraw = TRUE;
      XSync (mainDisplay, TRUE);
      exitNormally = TRUE;
      AllocStrings (FuncStr, Str1, Menu1, Str2, Menu2, Str3, Menu3);
      strcpy (*FuncStr, "Quit");
      strcpy (*Str1, "");
      return;
   }

   if (strcmp (Op, "msg") == 0)
   {
      Msg (FileName);
      AllocStrings (FuncStr, Str1, Menu1, Str2, Menu2, Str3, Menu3);
      strcpy (*FuncStr, "");
      return;
   }

   if (strcmp (Op, "dialog") == 0)
   {
      Dialog (FileName, file_name);
      AllocStrings (FuncStr, Str1, Menu1, Str2, Menu2, Str3, Menu3);
      strcpy (*FuncStr, file_name);
      strcpy (*Str1, "");
      return;
   }

   if (strcmp (Op, "mainmenu") == 0 && quitDraw)
   {
      AllocStrings (FuncStr, Str1, Menu1, Str2, Menu2, Str3, Menu3);
      strcpy (*FuncStr, "Fail");
      strcpy (*Str1, "");
      return;
   }

   while (TRUE)
   {
      XNextEvent (mainDisplay, &input);

      if (input.type == KeyPress)
      {
         shorthand_rc = ShortHand (&input);
         switch (shorthand_rc)
         {
            case BAD: /* <CONTROL> or <META> */ continue;
            case INVALID: break;
            default:
               AllocStrings (FuncStr, Str1, Menu1, Str2, Menu2, Str3, Menu3);
               strcpy (*FuncStr, fileMenuStr[shorthand_rc]);
               strcpy (*Str1, curDomainName);
               strcpy (*Menu1, "tmpmodel.obj");
               strcpy (*Str2, "");
               for (c_ptr = *FuncStr; *c_ptr != '\0'; c_ptr++)
                  if (*c_ptr == ' ')
                  {
                     *c_ptr = '\0';
                     break;
                  }
               return;
         }
      }

      if (input.xany.window == choiceWindow)
         ChoiceEventHandler (&input);
      else if (input.xany.window == drawWindow)
      {
         if ((draw_rc = DrawingEventHandler (&input)) != INVALID)
         {
            AllocStrings (FuncStr, Str1, Menu1, Str2, Menu2, Str3, Menu3);
            strcpy (*FuncStr, fileMenuStr[draw_rc]);
            strcpy (*Str1, curDomainName);
            strcpy (*Menu1, "tmpmodel.obj");
            strcpy (*Str2, "");
            for (c_ptr = *FuncStr; *c_ptr != '\0'; c_ptr++)
               if (*c_ptr == ' ')
               {
                  *c_ptr = '\0';
                  break;
               }
            return;
         }
      }
      else if (input.xany.window == mainWindow)
         mainWinEventHandler (&input);
      else if (input.xany.window == vRuleWindow)
         RedrawVRuler (&input);
      else if (input.xany.window == hRuleWindow)
         RedrawHRuler (&input);
      else if (input.xany.window == iconWindow ||
            input.xany.window == iconBaseWindow)
         IconEventHandler (&input);
      else if (input.xany.window == titleWindow)
         TitleEventHandler (&input);
      else if (input.xany.window == msgWindow)
         MsgEventHandler (&input);
      else if (input.xany.window == vSBarWindow ||
            input.xany.window == hSBarWindow)
         ScrollEventHandler (&input);
      else if (input.xany.type == MappingNotify)
         XRefreshKeyboardMapping (&(input.xmapping));
#ifdef UC
      else if (mainMenuWiredDown)
      {
	 for (i = 0; i < MAINMENUS; i++)
	 {
	     if(input.xany.window == mainMenuWin[i].window)
	     {
		find++;
		break;
	    }
	 }
         if (find && ((mainmenu_rc = MainMenuEventHandler (&input, i)) != INVALID))
         {
            AllocStrings (FuncStr, Str1, Menu1, Str2, Menu2, Str3, Menu3);
            strcpy (*FuncStr, fileMenuStr[mainmenu_rc]);
            strcpy (*Str1, curDomainName);
            strcpy (*Menu1, "tmpmodel.obj");
            strcpy (*Str2, "");
            for (c_ptr = *FuncStr; *c_ptr != '\0'; c_ptr++)
               if (*c_ptr == ' ')
               {
                  *c_ptr = '\0';
                  break;
               }
            return;
	}
     }
#endif /* UC */
   }
}

static
void HandleSimpleEvent (input)
   XEvent	input;
{
#ifdef UC
   int i, find = 0;
#endif /* UC */
   if ((input.type & (PointerMotionMask | EnterWindowMask | LeaveWindowMask))
         != 0) return;

   if (input.xany.window == drawWindow)
      DrawingEventHandler (&input);
   else if (input.xany.window == choiceWindow)
      ChoiceEventHandler (&input);
   else if (input.xany.window==iconWindow || input.xany.window==iconBaseWindow)
      IconEventHandler (&input);
   else if (input.xany.window == titleWindow)
      TitleEventHandler (&input);
   else if (input.xany.window == msgWindow)
      MsgEventHandler (&input);
   else if (input.xany.window==vSBarWindow || input.xany.window==hSBarWindow)
      ScrollEventHandler (&input);
   else if (input.xany.window == hRuleWindow)
      RedrawHRuler ();
   else if (input.xany.window == vRuleWindow)
      RedrawVRuler ();
#ifdef UC
   else if (mainMenuWiredDown)
   {
	 for (i = 0; i < MAINMENUS; i++)
	 {
	     if(input.xany.window == mainMenuWin[i].window)
	     {
		 find++;
		 break;
	     }
	 }
	 if (find) MainMenuEventHandler (&input, i);
   }
#endif /* UC */
}

static
void AllocReturnStr (ReturnStr)
   char	* * ReturnStr;
{
   if((*ReturnStr = (char *) calloc (80, sizeof(char))) == NULL)
      { printf ("calloc fails!\n"); exit(-1); }
}

void Animate (TypeStr, PolyId, SpeedStr, ColorStr, ReturnStr)
   char		* TypeStr, * PolyId, * SpeedStr, * ColorStr;
   char		* * ReturnStr;
{
   struct ObjRec	* obj_ptr;
   char			s[80];
   int			i, poly_id, speed, pixel, clicked = FALSE;
   XEvent		input;
   XButtonEvent		* button_event;

   AllocReturnStr (ReturnStr);
   strcpy (*ReturnStr, "");

   while (XPending (mainDisplay) != 0)
   {
      XPeekEvent (mainDisplay, &input);
      if ((input.type & (PointerMotionMask | ExposureMask | EnterWindowMask |
            LeaveWindowMask)) != 0)
      {
         XNextEvent (mainDisplay, &input);
         HandleSimpleEvent (input);
      }
      else
      {
         if (input.type == ButtonPress) clicked = TRUE;
         strcpy (*ReturnStr, "Interrupt");
         break;
      }
   }

   printf ("--> Animate (%s, %s, %s, %s)\n",TypeStr,PolyId,SpeedStr,ColorStr);
   if (strcmp (TypeStr, "waitclick") == 0)
   {
      Msg ("Left:step.  Middle:run.  Right:stop.");
      if (!clicked)
      {
         while(TRUE)
            if (XPending (mainDisplay) != 0)
            {
               XNextEvent (mainDisplay, &input);
               if (input.type == ButtonPress)
                  break;
            }
      }
      else
         XNextEvent (mainDisplay, &input);

      button_event = &(input.xbutton);
      switch (button_event->button)
      {
         case Button1 : strcpy (*ReturnStr, "Left"); break;
         case Button2 : strcpy (*ReturnStr, "Middle"); break;
         case Button3 : strcpy (*ReturnStr, "Right"); break;
      }
      Msg ("");
   }
   else
   {
      poly_id = atoi (PolyId);
      for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
         if (obj_ptr->type == OBJ_POLY && obj_ptr->id == poly_id)
            break;

      if (obj_ptr == NULL)
      {
         sprintf (s, "Can not find poly id = %1d.", poly_id);
         Msg (s);
      }
      else if (strcmp (TypeStr, "send") == 0)
      {
         speed = atoi (SpeedStr);
         pixel = (colorDisplay) ? xorColorPixels[obj_ptr->color] : 1;
         AnimateSend (obj_ptr->detail.p, speed, pixel);
      }
      else if (strcmp (TypeStr, "flash") == 0)
      {
         if (colorDisplay)
            strcpy (s, ColorStr);
         else
            strcpy (s, "white");
         for (i = 0; i < maxColors; i++)
            if (strcmp (colorMenuItems[i], s) == 0)
            {
               AnimateFlashColor (obj_ptr, i);
               break;
            }
      }
   }
}

static
void MyFormat (Str)
   char	* Str;
{
   register char	* c_ptr = Str, * period_ptr = NULL;
   register int		i;

   for ( ; *c_ptr != '\0'; c_ptr++)
      if (*c_ptr >= '0' && *c_ptr <= '9')
         continue;
      else if (*c_ptr == '.')
      {
         if (period_ptr != NULL) return;
         period_ptr = c_ptr;
         continue;
      }
      else
         return;

   if (period_ptr == NULL) return;
   for (c_ptr = period_ptr, i = 0; *c_ptr != '\0' && i < 7; c_ptr++, i++) ;
   if (*c_ptr != '\0') *c_ptr = '\0';
}

void UpdAttrVal (ObjId, AttrName, AttrColor, AttrVal, ReturnStr)
   char		* ObjId, * AttrName, * AttrColor, * AttrVal;
   char		* * ReturnStr;
{
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr;
   char			s[80];
   int			obj_id, clicked = FALSE;
   XEvent		input;
   XButtonEvent		* button_event;

   AllocReturnStr (ReturnStr);
   strcpy (*ReturnStr, "");

   while (XPending (mainDisplay) != 0)
   {
      XPeekEvent (mainDisplay, &input);
      if ((input.type & (PointerMotionMask | ExposureMask | EnterWindowMask |
            LeaveWindowMask)) != 0)
      {
         XNextEvent (mainDisplay, &input);
         HandleSimpleEvent (input);
      }
      else
      {
         if (input.type == ButtonPress)
            clicked = TRUE;
         strcpy (*ReturnStr, "Interrupt");
         button_event = &(input.xbutton);
         switch (button_event->button)
         {
            case Button1 : strcpy (*ReturnStr, "Left"); break;
            case Button2 : strcpy (*ReturnStr, "Middle"); break;
            case Button3 : strcpy (*ReturnStr, "Right"); break;
         }
         break;
      }
   }

   printf ("--> UpdAttrVal (%s, %s, %s, %s)\n", ObjId, AttrName,
         AttrColor, AttrVal);

   obj_id = atoi (ObjId);

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
      if (obj_ptr->id == obj_id)
         break;

   if (obj_ptr == NULL)
   {
      sprintf (s, "Can not find obj id = %1d.", obj_id);
      Msg (s);
   }
   else
   {
      attr_ptr = obj_ptr->fattr;
      for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
      {
         if (strcmp (AttrName, attr_ptr->name) == 0 &&
               strcmp (AttrColor, colorMenuItems[attr_ptr->obj->color]) == 0)
            break;
      }
      if (attr_ptr == NULL)
      {
         sprintf (s, "Can not find attr name '%s' and color '%s'.",
               AttrName, AttrColor);
         Msg (s);
      }
      else
      {
         strcpy (attr_ptr->s, AttrVal);
         MyFormat(attr_ptr->s);
         if (attr_ptr->nameshown)
            sprintf (s, "%s%s", attr_ptr->name, attr_ptr->s);
         else
            strcpy (s, attr_ptr->s);

         if (attr_ptr->shown) RepaintFirstStr (attr_ptr->obj, s);

         strcpy (attr_ptr->obj->detail.t->first->s, s);
      }
   }
}
