#ifdef UC
/*
 * Author:	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "cursor.e"
#include "font.e"
#include "menu.e"
#include "raster.e"
#include "setup.e"
#endif /* UC */
#if defined(UC)
char	* mainMenuStr[MAXMENUS] =
{
   "Mode", "File", "Edit", "TextStyle", "TextSize", "Font", "FontDPI",
   "Layout", "Arrange", "Fill", "LineStyle", "Pen", "Color", "Special"
};
#endif /* UC */    
#ifdef UC
#define PERMANENT_WIN_BORDER 4
#define PERMANENT	0

struct MainMenuWinRec mainMenuWin[MAINMENUS];

int 	mainMenuWiredDown = FALSE;
/* int 	createdMainMenu = FALSE; */
int	last = PERMANENT;
int 	savedMainWin_x, savedMainWin_y;

void MapMainMenuWindows ()
{
    int i;
    
    for (i = 0; i < last ; i++)
	XMapRaised (mainDisplay, mainMenuWin[i].window);
}

void LowerMainMenuWindows ()
{
    int i;
    
    for (i = 0; i < last ; i++)
	XLowerWindow (mainDisplay, mainMenuWin[i].window);
}

void UnmapMainMenuWindows ()
{
    int i;
    
    for (i = 0; i < last ; i++)
	XUnmapWindow (mainDisplay, mainMenuWin[i].window);
}


void SaveMainWinPosition (mainWin_x, mainWin_y)
unsigned int mainWin_x, mainWin_y;
{
    savedMainWin_x = mainWin_x;
    savedMainWin_y = mainWin_y;
}

void MoveMainMenuWindow (newMainWin_x, newMainWin_y)
unsigned int newMainWin_x, newMainWin_y;
{
    int i;
    
    if ((newMainWin_x == savedMainWin_x)&& (newMainWin_y == savedMainWin_y))
	return;
    
    for (i = 0; i <last; i++)
    {
	mainMenuWin[i].x += newMainWin_x - savedMainWin_x;
	mainMenuWin[i].y += newMainWin_y - savedMainWin_y;

	XMoveWindow (mainDisplay, mainMenuWin[i].window,
		     mainMenuWin[i].x, mainMenuWin[i].y);
	XRaiseWindow (mainDisplay, mainMenuWin[i].window);
	XFlush (mainDisplay);
    }
    savedMainWin_x = newMainWin_x;
    savedMainWin_y = newMainWin_y;
}
    
void RedrawMainMenuWindow (which)
int which;
{
    int i, y;
    int * fore_colors, *valid;

    y = defaultFontAsc;
    DefaultColorArrays (MAXMENUS, &fore_colors, &valid);

    XSetForeground (mainDisplay, textMenuGC, fore_colors[0]);
	
    XClearWindow (mainDisplay, mainMenuWin[which].window);
    for (i = 0; i < MAXMENUS; i++, y += defaultFontHeight)
	XDrawString (mainDisplay, mainMenuWin[which].window, textMenuGC, 0, y,
			 mainMenuStr[i], strlen(mainMenuStr[i]));
   cfree (fore_colors);
   cfree (valid);
}
#endif /* UC */
int MainMenu (Input)
   XButtonEvent	* Input;
{
   int		rc = INVALID, index, * fore_colors, * valid, x, y;
   Window	root_win, child_win;
   unsigned int	status;
   int		root_x, root_y;

   Msg ("");
#ifndef UC
   XQueryPointer (mainDisplay, rootWindow, &root_win, &child_win, &root_x,
         &root_y, &x, &y, &status);
#else /* UC */
   x = Input->x_root;
   y = Input->y_root;
#endif /* UC */
   
   DefaultColorArrays (MAXMENUS, &fore_colors, &valid);
   index = TextMenuLoop (x, y, mainMenuStr, MAXMENUS, fore_colors, valid,
         SINGLECOLOR, MENU_MAIN);

   if (index == INVALID) return (INVALID);

   if (index == MENU_COLOR && !colorDisplay)
   {
      Msg ("No color menu available for non-color displays.");
      return (INVALID);
   }

   CornerLoop (&x, &y);
   switch (index)
   {
      case MENU_MODE: ModeMenu (x, y); break;
      case MENU_FILE: rc = FileMenu (x, y); break;
      case MENU_EDIT: EditMenu (x, y); break;
      case MENU_STYLE: StyleMenu (x, y); break;
      case MENU_SIZE: SizeMenu (x, y); break;
      case MENU_FONT: FontMenu (x, y); break;
      case MENU_FONTDPI: FontDPIMenu (x, y); break;
      case MENU_LAYOUT: LayoutMenu (x, y); break;
      case MENU_ARRANGE: ArrangeMenu (x, y); break;
      case MENU_FILL: FillMenu (x, y); break;
      case MENU_LINESTYLE: LineStyleMenu (x, y); break;
      case MENU_PEN: PenMenu (x, y); break;
      case MENU_SPECIAL: SpecialMenu (x, y); break;
      case MENU_COLOR: ColorMenu (x, y); break;
   }
   return (rc);
}
#ifdef UC
MainMenuEventHandler (input, which)
   XEvent	* input;
   int		which;
{
   XEvent	ev;
   XButtonEvent	* button_ev;
   int		index, rc = INVALID;
   register int	moving, saved_x, saved_y, x, y, w, h;
   register int	i, j;
   
   if (!mainMenuWiredDown)
	return;

   if (input->type == Expose)
   {
       XSync (mainDisplay, FALSE);
       while (XCheckWindowEvent (mainDisplay, mainMenuWin[which].window,
				 ExposureMask, &ev)) ;
       RedrawMainMenuWindow (which);
       return (INVALID);
   }
   else  if (input->type == ButtonPress)
   {
       button_ev = &(input->xbutton);
       
       switch (button_ev->button)
       {
	    case Button1: 
		   break;
	    case Button2:
		   XDestroyWindow (mainDisplay, mainMenuWin[which].window);
		   for (i = which, j = which + 1; j < last; i++, j++)
		   {
		       mainMenuWin[i].window = mainMenuWin[j].window;
		       mainMenuWin[i].x = mainMenuWin[j].x;
		       mainMenuWin[i].y = mainMenuWin[j].y;
		       mainMenuWin[i].w = mainMenuWin[j].w;
		       mainMenuWin[i].h = mainMenuWin[j].h;
		   }
		   last = i;

		   if (last == PERMANENT)
		       mainMenuWiredDown = FALSE;
		   else if (which == PERMANENT)
		       XSetWindowBorderWidth
			   (mainDisplay,mainMenuWin[which].window, PERMANENT_WIN_BORDER);
		   
		   return(INVALID);
	    case Button3:
		   XGrabPointer (mainDisplay, mainMenuWin [which].window, FALSE,
			 PointerMotionMask | ButtonPressMask | ButtonReleaseMask,
		         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
		   moving = 1;
		   XSetSubwindowMode (mainDisplay, revDefaultGC, IncludeInferiors);
		   
		   saved_x = mainMenuWin[which].x;
		   saved_y = mainMenuWin[which].y;
		   x = button_ev->x_root;
		   y = button_ev->y_root;
		   w = mainMenuWin[which].w;
		   h = mainMenuWin[which].h;
		   
		   XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
					   saved_x, saved_y, w, h);
		   while (moving)
		   {
		       XNextEvent (mainDisplay, &ev);
		       if (ev.type == ButtonRelease)
		       {
			   XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
					   saved_x, saved_y, w, h);
			   XUngrabPointer (mainDisplay, CurrentTime);
 			   
			   XMoveWindow (mainDisplay, mainMenuWin[which].window,
					saved_x, saved_y);
			   XRaiseWindow (mainDisplay, mainMenuWin[which].window);
			   mainMenuWin[which].x = saved_x;
			   mainMenuWin[which].y = saved_y;
			   moving = 0;
			   XSetSubwindowMode (mainDisplay, revDefaultGC, ClipByChildren);
		       }
		       else if (ev.type == MotionNotify)
		       {
			   XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
					   saved_x, saved_y, w, h);
			   saved_x += (ev.xbutton.x_root - x);
			   saved_y += (ev.xbutton.y_root - y);
			   x = ev.xbutton.x_root;
			   y = ev.xbutton.y_root;
			   XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
					   saved_x, saved_y, w, h);
		       }
		   }
	    default: return (INVALID);
	}
   }
   else if (input->type == KeyPress)
   {
       XSendEvent (mainDisplay, drawWindow, False, KeyPressMask, input);
       return (INVALID);		   
   }
   else	   
   {
       return (INVALID);
   }
   
   index = button_ev->y/defaultFontHeight;
   
   x = button_ev->x_root;
   y = button_ev->y_root;
    switch (index)
    {
	case MENU_MODE: ModeMenu (x, y); break;
	case MENU_FILE: rc = FileMenu (x, y); break;
	case MENU_EDIT: EditMenu (x, y); break;
	case MENU_STYLE: StyleMenu (x, y); break;
	case MENU_SIZE: SizeMenu (x, y); break;
	case MENU_FONT: FontMenu (x, y); break;
	case MENU_FONTDPI: FontDPIMenu(x, y); break;
	case MENU_LAYOUT: LayoutMenu (x, y); break;
	case MENU_ARRANGE: ArrangeMenu (x, y); break;
	case MENU_FILL: FillMenu (x, y); break;
	case MENU_LINESTYLE: LineStyleMenu (x, y); break;
	case MENU_PEN: PenMenu (x, y); break;
	case MENU_COLOR: ColorMenu (x, y); break;
	case MENU_SPECIAL: SpecialMenu (x, y); break;
    }
    RedrawMainMenuWindow (which);
    return (rc);
}


void SaveMainMenuWindow (window, x, y, w, h)
Window window;
int x, y, w, h;
{
    if (last == MAINMENUS)
    {
	last--;
	XDestroyWindow (mainDisplay, mainMenuWin[last].window);
    }
    XSelectInput (mainDisplay, window, KeyPressMask | ButtonPressMask | ExposureMask);
    XDefineCursor (mainDisplay, window, defaultCursor);
    if (last == PERMANENT)
	XSetWindowBorderWidth (mainDisplay, window, PERMANENT_WIN_BORDER);
    mainMenuWiredDown = TRUE;
    mainMenuWin[last].window = window;
    mainMenuWin[last].x = x;
    mainMenuWin[last].y = y;
    mainMenuWin[last].w = w;
    mainMenuWin[last].h = h;
    RedrawMainMenuWindow(last);
    XSetTransientForHint (mainDisplay, window, mainWindow);
/*    createdMainMenu = TRUE; */
    last++;
}
#endif /* UC */

