/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/mark.c,v 2.0 91/03/05 12:47:31 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "raster.e"
#include "setup.e"
#include "select.e"

#define FORWARD 0
#define REVERSE 1

#define Mark(X,Y) \
      XFillRectangle(mainDisplay,drawWindow,revDefaultGC,(X)-2,(Y)-2,5,5)

static
void MarkPoly (NumPts, V)
   int		NumPts;
   XPoint	* V;
{
   register int	i;

   for (i = 0; i < NumPts; i++)
      Mark (OFFSET_X(V[i].x), OFFSET_Y(V[i].y));
}

static
void Mark4Corners (BBox)
   struct BBRec	BBox;
{
   Mark (OFFSET_X(BBox.ltx), OFFSET_Y(BBox.lty));
   Mark (OFFSET_X(BBox.ltx), OFFSET_Y(BBox.rby));
   Mark (OFFSET_X(BBox.rbx), OFFSET_Y(BBox.lty));
   Mark (OFFSET_X(BBox.rbx), OFFSET_Y(BBox.rby));
}

static
void Mark8Places (BBox)
   struct BBRec	BBox;
{
   register int	xmid, ymid;

#ifndef UC
   if ((BBox.rbx - BBox.ltx) >> zoomScale >= 10)
#else /* UC */
   if (ScreenSize((BBox.rbx - BBox.ltx),  zoomScale) >= 10)
#endif /* UC */
   {
      xmid = (BBox.ltx+BBox.rbx) / 2;
      Mark (OFFSET_X(xmid), OFFSET_Y(BBox.lty));
      Mark (OFFSET_X(xmid), OFFSET_Y(BBox.rby));
   }
#ifndef UC
   if ((BBox.rby - BBox.lty) >> zoomScale >= 10)
#else /* UC */
   if (ScreenSize((BBox.rby - BBox.lty),  zoomScale) >= 10)
#endif /* UC */
   {
      ymid = (BBox.lty+BBox.rby) / 2;
      Mark (OFFSET_X(BBox.ltx), OFFSET_Y(ymid));
      Mark (OFFSET_X(BBox.rbx), OFFSET_Y(ymid));
   }
   Mark4Corners (BBox);
}

void HighLightAnObj (ObjPtr)
   register struct ObjRec	* ObjPtr;
{
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         MarkPoly (ObjPtr->detail.p->n, ObjPtr->detail.p->vlist); break;
      case OBJ_POLYGON:
         MarkPoly (ObjPtr->detail.g->n-1, ObjPtr->detail.g->vlist); break;

      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_ARC:
      case OBJ_RCBOX:
      case OBJ_GROUP:
      case OBJ_SYM: Mark8Places (ObjPtr->obbox); break;

      case OBJ_TEXT:
      case OBJ_XBM:
      case OBJ_ICON: Mark4Corners (ObjPtr->obbox); break;
   }
}

static
void HighLight (Dir)
   int	Dir;
{
   register struct SelRec	* sel_ptr = NULL;
   register struct ObjRec	* obj_ptr;

   switch (Dir)
   {
      case FORWARD: sel_ptr = botSel; break;
      case REVERSE: sel_ptr = topSel; break;
   }
   while (sel_ptr != NULL)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            MarkPoly (obj_ptr->detail.p->n, obj_ptr->detail.p->vlist);
            break;
         case OBJ_POLYGON:
            MarkPoly (obj_ptr->detail.g->n-1, obj_ptr->detail.g->vlist);
            break;

         case OBJ_BOX:
         case OBJ_OVAL:
         case OBJ_GROUP:
         case OBJ_ARC:
         case OBJ_RCBOX:
         case OBJ_SYM: Mark8Places (obj_ptr->obbox); break;

         case OBJ_TEXT:
         case OBJ_XBM:
         case OBJ_ICON: Mark4Corners (obj_ptr->obbox); break;
      }
      switch (Dir)
      {
         case FORWARD: sel_ptr = sel_ptr->prev; break;
         case REVERSE: sel_ptr = sel_ptr->next; break;
      }
   }
}

void HighLightForward ()
{
   HighLight (FORWARD);
}
 
void HighLightReverse ()
{
   HighLight (REVERSE);
}
