/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/menu.c,v 2.0 91/03/05 12:47:32 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "box.e"
#include "choice.e"
#include "color.e"
#include "cursor.e"
#include "dialog.e"
#include "drawing.e"
#include "edit.e"
#include "file.e"
#include "font.e"
#include "grid.e"
#include "msg.e"
#include "names.e"
#include "obj.e"
#include "pattern.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "special.e"
#include "text.e"
#include "version.e"
#ifdef KINPUT
#include "kconvert.e"
#endif /* KINPUT */
#ifdef UC
#include "mainmenu.e"
#define OFFSET_X_WIRED 40
#define OFFSET_Y_WIRED 40
#endif /* UC */

int	iconWindowCreated = FALSE;
int	iconWindowShown = FALSE;

extern char	* getenv ();

static int	savedZoomScale = 0, savedDrawOrigX = 0, savedDrawOrigY = 0;
static int	savedDrawWinW = 0, savedDrawWinH = 0, savedFileModified = FALSE;

#ifdef UC
static GC	textMenuReverseGC;
#endif /* UC */
#ifndef UC
static GC	textMenuGC;
#else /* UC */
GC	textMenuGC;
#endif /* UC */
static GC	pixmapMenuGC;

#ifdef UC
/*
 * TextMenuCurrentSelection() checks current drawing status for text menus
 * and returns it in currentSelection and currentSelection2.
 *
 * Author: 	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 */
void TextMenuCurrentSelection
    (TextMenuIndex, currentSelection, currentSelection2)
int TextMenuIndex;
int * currentSelection, * currentSelection2;
{
   switch (TextMenuIndex)
   {
      case MENU_FONTDPI:
           if (topSel == NULL)
	       *currentSelection = curFontDPI;
           else
	       switch (topSel->obj->type)
	       {
	          case OBJ_TEXT:
                     *currentSelection = topSel->obj->detail.t->dpi;
		     break;
	          default:
		     *currentSelection = curFontDPI;
		     break;
	       }
	   break;
      case MENU_FONT: 	
	   if (topSel == NULL)
	      *currentSelection = curFont;
	   else 
	       switch (topSel->obj->type)
	       {
	          case OBJ_TEXT:
                     *currentSelection = topSel->obj->detail.t->font;
		     break;
	          default:
		     *currentSelection = curFont;
		     break;
	       }
	   break;
      case MENU_STYLE:
	   if (topSel == NULL) {
	      *currentSelection = curStyle; 
	      *currentSelection2 = textJust + 5;
           } else 
	       switch (topSel->obj->type)
	       {
	          case OBJ_TEXT:
                     *currentSelection = topSel->obj->detail.t->style;
                     *currentSelection2 = topSel->obj->detail.t->just + 5;
		     break;
	          default:
		     *currentSelection = curStyle; 
		     *currentSelection2 = textJust + 5;
		     break;
	       }
           break;
      case MENU_SIZE: 	
	   if (topSel == NULL)
	     * currentSelection = curSize;
	   else
	      switch (topSel->obj->type)
	      {
	         case OBJ_TEXT:
		      *currentSelection = topSel->obj->detail.t->size; 
		      break;
	         default:
		      *currentSelection = curSize;
		      break;
	      }
	   break;
      case MENU_LAYOUT: 	
	   switch (pageStyle) 
	   {
		   /* woops! */
	       case PORTRAIT:
		   *currentSelection = LAYOUT_PORT; break;
	       case LANDSCAPE:
		   *currentSelection = LAYOUT_LAND; break;
	       case HIGHPORT:
		   *currentSelection = LAYOUT_HIPORT; break;
	       case HIGHLAND:
		   *currentSelection = LAYOUT_HILAND; break;
	       case SLIDEPORT:
		   *currentSelection = LAYOUT_SLIDEPORT; break;
	       case SLIDELAND:
		   *currentSelection = LAYOUT_SLIDELAND; break;
	   }
   }
}
#endif /* UC */
#ifndef UC
int TextMenuLoop (OrigX, OrigY, Strings, Entries, ForeColors, Valid, MultiColor)
#else /* UC */
int TextMenuLoop (OrigX, OrigY, Strings, Entries, ForeColors, Valid, MultiColor, TextMenuIndex)
   int 		TextMenuIndex;
#endif /* UC */
   int		OrigX, OrigY, Entries, * ForeColors, * Valid, MultiColor;
   char		* Strings[];
{
   Window	window, root_win, child_win;
   register int	i, max_len, menuing = TRUE;
   int		x, y, rc = INVALID, old_selected, new_selected;
   int		* len, dsp_w, dsp_h, menu_w, menu_h;
   unsigned int	status;
   int		root_x, root_y;
   XEvent	input;
   XSetWindowAttributes	win_attrs;
#ifdef UC
   int currentSelection = -1, currentSelection2 = -1;
#endif /* UC */
#ifdef UC
   register int	wired = 0, saved_root_x, saved_root_y;
#endif /* UC */

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   len = (int *) calloc (Entries, sizeof(int));
   for(i = 0, max_len = 0; i < Entries; i++)
   {
      len[i] = strlen (Strings[i]);
      if (len[i] > max_len) max_len = len[i];
   }
   menu_w = defaultFontWidth * max_len + 1;
   menu_h = defaultFontHeight * Entries;

   if (OrigX+menu_w >= dsp_w-1-2*brdrW)
      OrigX = dsp_w - 1 - 2*brdrW - menu_w;
   if (OrigY+menu_h >= dsp_h-1-2*brdrW)
      OrigY = dsp_h - 1 - 2*brdrW - menu_h;

   if ((window = XCreateSimpleWindow (mainDisplay, rootWindow, OrigX, OrigY,
         menu_w, menu_h, 2*brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create desired menu window!\n"); /* fool safe */ EmergencySave (); }

   win_attrs.save_under = True;
   win_attrs.override_redirect = True;
   XChangeWindowAttributes (mainDisplay, window,
         CWSaveUnder | CWOverrideRedirect, &win_attrs);

   old_selected = INVALID;

   XSetTransientForHint (mainDisplay, window, mainWindow);
   XMapWindow (mainDisplay, window);
   XSelectInput (mainDisplay, window, ExposureMask);
   XWarpPointer (mainDisplay, None, rootWindow, 0, 0, 0, 0, OrigX-2, OrigY-2);

   XSync (mainDisplay, False);

   XQueryPointer (mainDisplay, window, &root_win, &child_win, &root_x,
         &root_y, &x, &y, &status);
   if (!(menuing = ((status & BUTTONSMASK) != 0)))
      while (XCheckWindowEvent (mainDisplay, window, ExposureMask, &input)) ;
 
#ifdef UC
   TextMenuCurrentSelection
       (TextMenuIndex, &currentSelection, &currentSelection2);
#endif /* UC */
   y = defaultFontAsc;
   if (MultiColor)
   {
      for (i = 0; i < Entries; i++, y += defaultFontHeight)
      {
         XSetForeground (mainDisplay, textMenuGC, ForeColors[i]);
         XDrawString (mainDisplay, window, textMenuGC, 0, y,
               Strings[i], len[i]);
      }
   }
   else
   {
#ifndef UC
      XSetForeground (mainDisplay, textMenuGC, ForeColors[0]);
#else /* UC */
      XSetForeground (mainDisplay, textMenuGC, ForeColors[0]);
      XSetBackground (mainDisplay, textMenuReverseGC, ForeColors[0]);
#endif /* UC */
      for (i = 0; i < Entries; i++, y += defaultFontHeight)
#ifndef UC
         XDrawString (mainDisplay, window, textMenuGC, 0, y,
               Strings[i], len[i]);
#else /* UC */
         if (i == currentSelection || i == currentSelection2 ) 
            XDrawImageString (mainDisplay, window, textMenuReverseGC, 0, y,
                  Strings[i], len[i]);
         else
            XDrawString (mainDisplay, window, textMenuGC, 0, y,
                  Strings[i], len[i]);
#endif /* UC */
   }
   XGrabPointer (mainDisplay, window, FALSE, None,
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);

   while (menuing)
   {
      XQueryPointer (mainDisplay, window, &root_win, &child_win, &root_x,
            &root_y, &x, &y, &status);
      if ((status & BUTTONSMASK) == 0)
      {
         menuing = FALSE;
#ifdef UC
	 if (wired)
	 {
	     XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
			  saved_root_x, saved_root_y, menu_w, menu_h);
	     XSetSubwindowMode (mainDisplay, revDefaultGC, ClipByChildren);
	     
	     saved_root_x = root_x; saved_root_y = root_y;
	     XMoveWindow (mainDisplay, window, saved_root_x, saved_root_y);
	     rc = INVALID;
	 }
#endif /* UC */
         if (x >= 0 && x < menu_w && y >= 0 && y < menu_h)
         {
            rc = (int)(y / defaultFontHeight);
            if (!Valid[rc]) rc = INVALID;
         }
         else
            rc = INVALID;
         XUngrabPointer (mainDisplay, CurrentTime);
         break;
      }
#ifdef UC
      else if (wired)
      {
	  XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
			  saved_root_x, saved_root_y, menu_w, menu_h);
	  saved_root_x = root_x; saved_root_y = root_y;
	  XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
			  saved_root_x, saved_root_y, menu_w, menu_h);
	  continue;
      }
#endif /* UC */
      else if (x >= 0 && x < menu_w && y >=0 && y < menu_h)
      {
         new_selected = (int)(y / defaultFontHeight);
         if (old_selected != new_selected )
         {
            if (old_selected != INVALID && Valid[old_selected])
            {
               XSetForeground (mainDisplay, textMenuGC, myBgPixel);
               XFillRectangle (mainDisplay, window, textMenuGC, 0,
                     old_selected*defaultFontHeight, menu_w, defaultFontHeight);
               XSetForeground (mainDisplay, textMenuGC,
                     ForeColors[old_selected]);
               XDrawString (mainDisplay, window, textMenuGC, 0,
                     defaultFontAsc+old_selected*defaultFontHeight,
                     Strings[old_selected], len[old_selected]);
            }
            if (Valid[new_selected])
            {
               XSetForeground (mainDisplay, textMenuGC,
                     ForeColors[new_selected]);
               XFillRectangle (mainDisplay, window, textMenuGC, 0,
                     new_selected*defaultFontHeight, menu_w, defaultFontHeight);
               XSetForeground (mainDisplay, textMenuGC, myBgPixel);
               XDrawString (mainDisplay, window, textMenuGC, 0,
                     defaultFontAsc+new_selected*defaultFontHeight,
                     Strings[new_selected], len[new_selected]);
            }
            old_selected = new_selected;
         }
      }
#ifdef UC
      else if ((TextMenuIndex == MENU_MAIN) &&(!wired)&& 
	       (x < -(OFFSET_X_WIRED) || y < -(OFFSET_Y_WIRED) ||
		x > (menu_w + OFFSET_X_WIRED)||y > (menu_h + OFFSET_Y_WIRED))) 
      {
	  saved_root_x = root_x; saved_root_y = root_y; 
	  XSetSubwindowMode (mainDisplay, revDefaultGC, IncludeInferiors);
	  XDrawRectangle (mainDisplay, rootWindow, revDefaultGC,
			  saved_root_x, saved_root_y, menu_w, menu_h);
	  wired = TRUE;
      }
#endif /* UC */
      else if (old_selected != INVALID)
      {
         if (Valid[old_selected])
         {
            XSetForeground (mainDisplay, textMenuGC, myBgPixel);
            XFillRectangle (mainDisplay, window, textMenuGC, 0,
                  old_selected*defaultFontHeight, menu_w, defaultFontHeight);
            XSetForeground (mainDisplay, textMenuGC, ForeColors[old_selected]);
            XDrawString (mainDisplay, window, textMenuGC, 0,
                  defaultFontAsc+old_selected*defaultFontHeight,
                  Strings[old_selected], len[old_selected]);
         }
         old_selected = INVALID;
      }
   }
   cfree (len);
   cfree (ForeColors);
   cfree (Valid);
#ifndef UC
   XDestroyWindow (mainDisplay, window);
#else /* UC */
   if (TextMenuIndex == MENU_MAIN && wired)
   {
       SaveMainMenuWindow (window, saved_root_x, saved_root_y, menu_w, menu_h);
   }
   else
       XDestroyWindow (mainDisplay, window);
#endif /* UC */

   XSync (mainDisplay, False);
   return (rc);
}

#ifdef UC
/*
 * PxMpMenuCurrentSelection() checks current drawing status for pixmap menus
 * and returns it in currentSelection, currentSelection2, currentSelection3,
 * and currentSelection4.
 *
 * Author: 	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 */
void PxMpMenuCurrentSelection
    (PxMpMenuIndex,
     currentSelection, currentSelection2, currentSelection3, currentSelection4)
int PxMpMenuIndex;
int * currentSelection, * currentSelection2, * currentSelection3, * currentSelection4;
{
   switch (PxMpMenuIndex)
   {
      case MENU_LINESTYLE:
       if (topSel == NULL)
       {
	   *currentSelection = lineWidth;
	   *currentSelection2 = MAXLINEWIDTHS + curSpline;
	   *currentSelection3 = MAXLINEWIDTHS + MAXLINETYPES + curDash;
	   *currentSelection4 = MAXLINEWIDTHS + MAXLINETYPES + MAXDASHES + lineStyle;
	   break;
       } else {
	   switch (topSel->obj->type)
	   {
	      case OBJ_BOX:
	      case OBJ_ARC:
	      case OBJ_RCBOX:	   
	      case OBJ_OVAL:
	       *currentSelection = topSel->obj->detail.b->width;
	       *currentSelection2 = MAXLINEWIDTHS + MAXLINETYPES + topSel->obj->detail.b->dash;
	       break;
	      case OBJ_POLYGON:		      
	       *currentSelection = topSel->obj->detail.g->width;
	       *currentSelection2 = MAXLINEWIDTHS + topSel->obj->detail.g->curved;
	       *currentSelection3 = MAXLINEWIDTHS + MAXLINETYPES + topSel->obj->detail.g->dash;
	       break;
	      case OBJ_POLY:
	       *currentSelection = topSel->obj->detail.p->width;
	       *currentSelection2 = MAXLINEWIDTHS + topSel->obj->detail.p->curved;
	       *currentSelection3 = MAXLINEWIDTHS + MAXLINETYPES + topSel->obj->detail.p->dash;
	       *currentSelection4 = MAXLINEWIDTHS + MAXLINETYPES + MAXDASHES + topSel->obj->detail.p->style;
	       break;
	      default:
	       *currentSelection = lineWidth;
	       *currentSelection2 = MAXLINEWIDTHS + curSpline;
	       *currentSelection3 = MAXLINEWIDTHS + MAXLINETYPES + curDash;
	       *currentSelection4 = MAXLINEWIDTHS + MAXLINETYPES + MAXDASHES + lineStyle;
	       break;
	   }
       }
       break;
   case MENU_MODE: *currentSelection = curChoice; break;
   default: break;
   }
}
#endif /* UC */
int PxMpMenuLoop (OrigX, OrigY, W, H, Rows, Cols, Entries, ForeColors, PxMp,
#ifndef UC
      MultiColor)
#else /* UC */
      MultiColor, PxMpMenuIndex)
   int PxMpMenuIndex;
#endif /* UC */
   int		OrigX, OrigY, W, H, Rows, Cols, Entries;
   int		* ForeColors, MultiColor;
   Pixmap	PxMp[];
{
   register int	i, j, menuing = TRUE;
   Window	window, root_win, child_win;
   int		x, y, old_selected, new_selected, menu_w, menu_h;
   int		rc = INVALID, old_i = 0, old_j = 0, k, toggle = 0, dsp_w, dsp_h;
   unsigned int	status;
   int		root_x, root_y;
   XGCValues	values;
   XEvent	input;
   XSetWindowAttributes	win_attrs;
#ifdef UC
   int		currentSelection = -1, currentSelection2 = -1, currentSelection3 = -1, currentSelection4 = -1;
#endif /* UC */

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   menu_w = W * Cols;
   menu_h = H * Rows;

   if (OrigX+menu_w >= dsp_w-1-2*brdrW)
      OrigX = dsp_w - 1 - 2*brdrW - menu_w;
   if (OrigY+menu_h >= dsp_h-1-2*brdrW)
      OrigY = dsp_h - 1 - 2*brdrW - menu_h;

   if ((window = XCreateSimpleWindow (mainDisplay, rootWindow, OrigX, OrigY,
         menu_w, menu_h, 2*brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create desired menu window!\n"); /* fool safe */ EmergencySave (); }

   win_attrs.save_under = True;
   win_attrs.override_redirect = True;
   XChangeWindowAttributes (mainDisplay, window,
         CWSaveUnder | CWOverrideRedirect, &win_attrs);

   old_selected = INVALID;

   XSetTransientForHint (mainDisplay, window, mainWindow);
   XMapWindow (mainDisplay, window);
   XSelectInput (mainDisplay, window, ExposureMask);
   XWarpPointer (mainDisplay, None, rootWindow, 0, 0, 0, 0, OrigX-2, OrigY-2);

   XSync (mainDisplay, False);

   XQueryPointer (mainDisplay, window, &root_win, &child_win, &root_x,
         &root_y, &x, &y, &status);
   if (!(menuing = ((status & BUTTONSMASK) != 0)))
      while (XCheckWindowEvent (mainDisplay, window, ExposureMask, &input)) ;
#ifdef UC
   PxMpMenuCurrentSelection
       (PxMpMenuIndex, &currentSelection, &currentSelection2, &currentSelection3, &currentSelection4);
#endif /* UC */

   for (i = 0; i < Rows; i++)
      for (j = 0; j < Cols; j++)
      {
         k = i + j * Rows;
         if (MultiColor)
         {
            if (k >= Entries)
               values.foreground = myBgPixel;
            else
               values.foreground = ForeColors[k];
            values.stipple = patPixmap[1];
            XChangeGC (mainDisplay, rasterGC,
                  GCForeground | GCStipple, &values);
            XFillRectangle (mainDisplay, window, rasterGC, j*W, i*H, W, H);
         }
         else
         {
#ifndef UC
            XSetStipple (mainDisplay, rasterGC, PxMp[k]);
            XFillRectangle (mainDisplay, window, rasterGC, j*W, i*H, W, H);
#else /* UC */
	    if (i == currentSelection || i == currentSelection2 || i == currentSelection3 || i == currentSelection4)
	    {
	       XSetStipple (mainDisplay, rasterReverseGC, PxMp[k]);
	       XFillRectangle (mainDisplay, window, rasterReverseGC, j*W, i*H, W, H);
            } else {
               XSetStipple (mainDisplay, rasterGC, PxMp[k]);
	       XFillRectangle (mainDisplay, window, rasterGC, j*W, i*H, W, H);
            }
#endif /* UC */
         }
      }

   XGrabPointer (mainDisplay, window, FALSE, ButtonReleaseMask,
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);

   while (menuing)
   {
      XQueryPointer (mainDisplay, window, &root_win, &child_win, &root_x,
            &root_y, &x, &y, &status);
      if ((status & BUTTONSMASK) == 0)
      {
         menuing = FALSE;
         if (x >= 0 && x < menu_w && y >= 0 && y < menu_h)
         {
            i = (int)(y / H);
            j = (int)(x / W);
            rc = i + j * Rows;
            if (rc >= Entries) rc = INVALID;
         }
         else
            rc = INVALID;
         XUngrabPointer (mainDisplay, CurrentTime);
         break;
      }
      else if (x >= 0 && x < menu_w && y >=0 && y < menu_h)
      {
         i = (int)(y / H);
         j = (int)(x / W);
         new_selected = i + j * Rows;
         if (old_selected != new_selected )
         {
            if (old_selected != INVALID)
            {
               if (MultiColor)
               {
                  if (old_selected >= Entries)
                     values.foreground = myBgPixel;
                  else
                     values.foreground = ForeColors[old_selected];
                  values.stipple = patPixmap[1];
                  XChangeGC (mainDisplay, rasterGC,
                        GCForeground | GCStipple, &values);
                  XFillRectangle (mainDisplay, window, rasterGC,
                        old_j*W, old_i*H, W, H);
               }
               else
               {
                  values.foreground = myFgPixel;
                  values.stipple = PxMp[old_selected];
                  XChangeGC (mainDisplay, rasterGC,
                        GCForeground | GCStipple, &values);
                  XFillRectangle (mainDisplay, window, rasterGC,
                        old_j*W, old_i*H, W, H);
               }
            }
            toggle = 0;
            old_selected = new_selected;
            old_i = i;
            old_j = j;
         }
         else
         {
            toggle = !toggle;
            values.foreground = toggle;
            values.stipple = patPixmap[1];
            XChangeGC (mainDisplay, rasterGC,
                  GCForeground | GCStipple, &values);
            MyBox (window, rasterGC, j*W, i*H, (j+1)*W-1, (i+1)*H-1);
         }
      }
      else if (old_selected != INVALID)
      {
         if (MultiColor)
         {
            if (old_selected >= Entries)
               values.foreground = myBgPixel;
            else
               values.foreground = ForeColors[old_selected];
            values.stipple = patPixmap[1];
            XChangeGC (mainDisplay, rasterGC,
                  GCForeground | GCStipple, &values);
            XFillRectangle (mainDisplay, window, rasterGC,
                  old_j*W, old_i*H, W, H);
         }
         else
         {
            values.foreground = myFgPixel;
            values.stipple = PxMp[old_selected];
            XChangeGC (mainDisplay, rasterGC,
                  GCForeground | GCStipple, &values);
            XFillRectangle (mainDisplay, window, rasterGC,
                  old_j*W, old_i*H, W, H);
         }
         old_selected = INVALID;
      }
   }
   values.foreground = myFgPixel;
   XChangeGC (mainDisplay, rasterGC, GCForeground, &values);

   cfree (ForeColors);
   XDestroyWindow (mainDisplay, window);

   XSync (mainDisplay, False);
   return (rc);
}

static char * opStr[] =
{
   "more", "update", "vi", "init", "quit", "mainmenu", "animate",
   "upd_attr_val", "green", "yellow"
};
#define MAXOP 10

void Prompt (PromptStr, OpName, FileName)
   char	* PromptStr, * OpName, * FileName;
{
   char	inbuf[80];
 
   while (TRUE)
   {
      printf (PromptStr);
      fgets (inbuf, 80, stdin);
      sscanf (inbuf, "%s%s", OpName, FileName);
      return;
   }
}

#ifndef UC
#define MENU_MODE 0
#define MENU_FILE 1
#define MENU_EDIT 2
#define MENU_STYLE 3
#define MENU_SIZE 4
#define MENU_FONT 5
#define MENU_FONTDPI 6
#define MENU_LAYOUT 7
#define MENU_ARRANGE 8
#define MENU_FILL 9
#define MENU_LINESTYLE 10
#define MENU_PEN 11
#define MENU_COLOR 12
#define MENU_SPECIAL 13

#define MAXMENUS 14
#endif /* UC */

#ifndef UC
static char	* mainMenuStr[MAXMENUS] =
{
   "Mode", "File", "Edit", "TextStyle", "TextSize", "Font", "FontDPI",
   "Layout", "Arrange", "Fill", "LineStyle", "Pen", "Color", "Special"
};
#else /* UC */
/* These statements were moved to mainmenu.c */
#endif /* UC */

#ifndef UC
int MainMenu (Input)
   XButtonEvent	* Input;
{
   int		rc = INVALID, index, * fore_colors, * valid, x, y;
   Window	root_win, child_win;
   unsigned int	status;
   int		root_x, root_y;

   Msg ("");
   XQueryPointer (mainDisplay, rootWindow, &root_win, &child_win, &root_x,
         &root_y, &x, &y, &status);

   DefaultColorArrays (MAXMENUS, &fore_colors, &valid);
   index = TextMenuLoop (x, y, mainMenuStr, MAXMENUS, fore_colors, valid,
         SINGLECOLOR, MAIN_MENU);

   if (index == INVALID) return (INVALID);

   if (index == MENU_COLOR && !colorDisplay)
   {
      Msg ("No color menu available for non-color displays.");
      return (INVALID);
   }

   CornerLoop (&x, &y);
   switch (index)
   {
      case MENU_MODE: ModeMenu (x, y); break;
      case MENU_FILE: rc = FileMenu (x, y); break;
      case MENU_EDIT: EditMenu (x, y); break;
      case MENU_STYLE: StyleMenu (x, y); break;
      case MENU_SIZE: SizeMenu (x, y); break;
      case MENU_FONT: FontMenu (x, y); break;
      case MENU_FONTDPI: FontDPIMenu (x, y); break;
      case MENU_LAYOUT: LayoutMenu (x, y); break;
      case MENU_ARRANGE: ArrangeMenu (x, y); break;
      case MENU_FILL: FillMenu (x, y); break;
      case MENU_LINESTYLE: LineStyleMenu (x, y); break;
      case MENU_PEN: PenMenu (x, y); break;
      case MENU_SPECIAL: SpecialMenu (x, y); break;
      case MENU_COLOR: ColorMenu (x, y); break;
   }
   return (rc);
}
#else /* UC */
	/* This routine was moved to mainmenu.c */
#endif /* UC */

void RedrawTitleWindow ()
{
   int	y, len, amount, left;
   char	s[MAXPATHLENGTH];

   strcpy (s, TOOL_NAME);
   strcat (s, "-");
   strcat (s, version_string);

   len = strlen (s);
   amount = defaultFontWidth * len;
   left = (titleWindowW - amount) / 2;

   XDrawString (mainDisplay, titleWindow, defaultGC, left, defaultFontAsc+2, s,
         len);

   for (y = 4; y < titleWindowH/2-4; y += 2)
   {
      XDrawLine (mainDisplay, titleWindow, defaultGC, 2, y,
            left-defaultFontWidth, y);
      XDrawLine (mainDisplay, titleWindow, defaultGC,
            left+amount+defaultFontWidth, y, titleWindowW-3, y);
   }

   s[0] = '\0';
   XClearArea (mainDisplay, titleWindow, 0, titleWindowH/2, titleWindowW,
         titleWindowH/2, FALSE);
   if (curFileDefined)
   {
      if (*curSymDir == '\0')
         sprintf (s, "%s:%s/%s", curDomainName, curDir, curFileName);
      else
         sprintf (s, "%s:%s/%s", curDomainName, curSymDir, curFileName);
   }
   else
      sprintf (s, "%s:[Unnamed]", curDomainName);

   if (fileModified) strcat (s, " [Modified]");
#ifdef KINPUT
   if (kinputOn) strcat (s, " *KINPUT*");
#endif /* KINPUT */

   if (s[0] != '\0')
   {
      len = strlen (s);
      XDrawString (mainDisplay, titleWindow, defaultGC, 2,
            titleWindowH/2+defaultFontAsc+2, s, len);
   }
}

static struct ObjRec	* iconTopObj = NULL, * iconBotObj = NULL;

void RedrawIconWindow ()
{
   register struct ObjRec	* obj_ptr;

   for (obj_ptr = iconBotObj; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      DrawObj (iconWindow, obj_ptr);
}

static char iconFileName[] = "tgificon";

static
void InitIcon ()
{
   struct ObjRec	* obj_ptr;
   char			s[MAXPATHLENGTH], * c_ptr;
   FILE			* fp;
   int			ltx = 0, lty = 0, rbx = 0, rby = 0, seen_obj = FALSE;
   int			dx, dy, w, h;

   strcpy (s, drawPath);
   strcat (s, "/");
   if ((c_ptr = getenv ("TGIFICON")) == NULL)
      strcat (s, iconFileName);
   else
      if (strlen (c_ptr) >= 200)
         /* too long, must be an error */
         strcat (s, iconFileName);
      else if (*c_ptr == '/')
         strcpy (s, c_ptr);
      else
         strcat (s, c_ptr);
   strcat (s, ".obj");

   if ((fp = fopen (s, "r")) == NULL)
   {
      Msg ("Can not open the tangram icon file.");
      return;
   }

   importingFile = TRUE; /* ignore the 'state' predicate */
   while (ReadObj (fp, &obj_ptr, FALSE))
      if (obj_ptr != NULL)
      {
         AddObj (NULL, topObj, obj_ptr);
         if (!seen_obj)
         {
            seen_obj = TRUE;
            ltx = obj_ptr->bbox.ltx; lty = obj_ptr->bbox.lty;
            rbx = obj_ptr->bbox.rbx; rby = obj_ptr->bbox.rby;
         }
         else
         {
            if (obj_ptr->bbox.ltx < ltx) ltx = obj_ptr->bbox.ltx;
            if (obj_ptr->bbox.lty < lty) lty = obj_ptr->bbox.lty;
            if (obj_ptr->bbox.rbx > rbx) rbx = obj_ptr->bbox.rbx;
            if (obj_ptr->bbox.rby > rby) rby = obj_ptr->bbox.rby;
         }
      }
   importingFile = FALSE;

   fclose (fp);

   w = rbx - ltx;
   h = rby - lty;
   if (w > iconWindowW)
   {
      dx = -ltx;
      iconWindowW = w;
   }
   else
      dx = -ltx+(iconWindowW-w)/2;

   if (h > iconWindowH)
   {
      dy = -lty;
      iconWindowH = h;
   }
   else
      dy = -lty+(iconWindowH-h)/2;

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
      MoveObj (obj_ptr, dx, dy);

   iconTopObj = topObj;
   iconBotObj = botObj;
   topObj = botObj = NULL;
}

void InitTitle ()
{
   InitIcon ();
}

void InitMenu ()
{
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillSolid;
   values.font = defaultFontPtr->fid;
   textMenuGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);

   values.fill_style = FillStippled;
   pixmapMenuGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle, &values);
#ifdef UC
   values.foreground = myBgPixel;
   values.background = myFgPixel;

   textMenuReverseGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);
#endif /* UC */
}

void CleanUpMenu ()
{
   XFreeGC (mainDisplay, textMenuGC);
   XFreeGC (mainDisplay, pixmapMenuGC);
}

void SaveDrawWinInfo ()
{
   savedZoomScale = zoomScale;
   savedDrawOrigX = drawOrigX;
   savedDrawOrigY = drawOrigY;
   savedDrawWinW = drawWinW;
   savedDrawWinH = drawWinH;
   savedFileModified = fileModified;
}

void UnIconify ()
{
   if (!iconWindowShown) return;

   XUnmapWindow (mainDisplay, iconBaseWindow);
   iconWindowShown = FALSE;

   zoomScale = savedZoomScale;
   drawOrigX = savedDrawOrigX;
   drawOrigY = savedDrawOrigY;
   drawWinW = savedDrawWinW;
   drawWinH = savedDrawWinH;
   fileModified = savedFileModified;
   UpdDrawWinBBox ();
   XMapWindow (mainDisplay, mainWindow);
   SetDefaultDrawWinClipRecs ();
}

void Iconify ()
{
   XSizeHints	sizehints;
   char		* c_ptr;
   int		x, y, bitmask;
   unsigned int	w, h;

   if (iconWindowShown) return;
   XUnmapWindow (mainDisplay, mainWindow);
#ifdef UC
   if (mainMenuWiredDown) UnmapMainMenuWindows ();
#endif /* UC */

   if (!iconWindowCreated)
   {
      sizehints.flags = PPosition | PSize | PMinSize | PMaxSize;
      sizehints.x = 0;
      sizehints.y = 0;
      sizehints.width = sizehints.min_width = sizehints.max_width =
            iconWindowW+2*brdrW;
      sizehints.height = sizehints.min_height = sizehints.max_height =
            iconWindowH+2*brdrW;

      if ((c_ptr = XGetDefault (mainDisplay, "Tgif", "IconGeometry")) != NULL)
      {
         bitmask = XParseGeometry (c_ptr, &x, &y, &w, &h);
         if (bitmask & (XValue | YValue))
         {
            sizehints.flags |= USPosition;
            if (bitmask & XValue) sizehints.x = x;
            if (bitmask & YValue) sizehints.y = y;
            if (bitmask & XNegative) sizehints.x += DisplayWidth (mainDisplay,
                  mainScreen) - iconWindowW - 2*brdrW - 1;
            if (bitmask & YNegative) sizehints.y += DisplayHeight (mainDisplay,
                  mainScreen) - iconWindowH - 2*brdrW - 1;
         }
      }

      if ((iconBaseWindow = XCreateSimpleWindow (mainDisplay, rootWindow,
            sizehints.x, sizehints.y, iconWindowW+2*brdrW, iconWindowH+2*brdrW,
            brdrW, myBorderPixel, myBgPixel)) == 0)
      { printf ("Could not create icon window!\n"); /* fool safe */ EmergencySave (); }

      if ((iconWindow = XCreateSimpleWindow (mainDisplay, iconBaseWindow, 0, 0,
            iconWindowW, iconWindowH, brdrW, myBorderPixel, myBgPixel)) == 0)
      { printf ("Could not create icon window!\n"); /* fool safe */ EmergencySave (); }

      XSetNormalHints (mainDisplay, iconBaseWindow, &sizehints);

      XSetTransientForHint (mainDisplay, iconBaseWindow, mainWindow);
      iconWindowCreated = TRUE;
   }

   SaveDrawWinInfo ();
   zoomScale = 0;
   drawOrigX = 0;
   drawOrigY = 0;
   drawWinW = iconWindowW;
   drawWinH = iconWindowH;
   UpdDrawWinBBox ();

   XMapWindow (mainDisplay, iconBaseWindow);
   XSelectInput (mainDisplay, iconBaseWindow, StructureNotifyMask);
   XMapWindow (mainDisplay, iconWindow);
   XSelectInput (mainDisplay, iconWindow, ButtonPressMask | ExposureMask);
   XSync (mainDisplay, False);
   iconWindowShown = TRUE;

   SetDefaultIconWinClipRecs ();
}

void IconEventHandler (input)
   XEvent	* input;
{
   XEvent	ev;

   if ((input->xany.window == iconBaseWindow && input->type == UnmapNotify) ||
         (input->xany.window == iconWindow && input->type == ButtonPress))
      UnIconify ();
   else if (input->xany.window == iconBaseWindow && input->type == MapNotify)
      Iconify ();
   else if (input->xany.window == iconWindow && input->type == Expose)
   {
      XSync (mainDisplay, False);
      while (XCheckWindowEvent (mainDisplay, iconWindow, ExposureMask, &ev)) ;
      while (XCheckWindowEvent (mainDisplay, iconBaseWindow,
            StructureNotifyMask, &ev)) ;
      RedrawIconWindow ();
   }
}

void TitleEventHandler (input)
   XEvent	* input;
{
   XEvent	ev;

   if (input->type == Expose)
   {
      XSync (mainDisplay, False);
      while (XCheckWindowEvent (mainDisplay, titleWindow, ExposureMask, &ev)) ;
      RedrawTitleWindow ();
   }
}
