/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */

#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/move.c,v 2.0 91/03/05 12:47:35 william Exp $";
#endif
#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "arc.e"
#include "attr.e"
#include "cursor.e"
#include "drawing.e"
#include "dup.e"
#include "grid.e"
#include "obj.e"
#include "oval.e"
#include "raster.e"
#include "rcbox.e"
#include "ruler.e"
#include "select.e"
#include "setup.e"
#ifdef UC
extern void DoMoveAllSel();
#endif /* UC */

static
void MovePoly (ObjPtr, Dx, Dy)
   struct ObjRec	* ObjPtr;
   int			Dx, Dy;
{
   register int	i;

   for (i = 0; i < ObjPtr->detail.p->n; i++)
   {
      ObjPtr->detail.p->vlist[i].x += Dx;
      ObjPtr->detail.p->vlist[i].y += Dy;
   }
   if (ObjPtr->detail.p->curved)
      for (i = 0; i < ObjPtr->detail.p->sn; i++)
      {
#ifndef UC
         ObjPtr->detail.p->svlist[i].x += (Dx>>zoomScale);
         ObjPtr->detail.p->svlist[i].y += (Dy>>zoomScale);
#else /* UC */
         ObjPtr->detail.p->svlist[i].x += (ScreenSize(Dx, zoomScale));
         ObjPtr->detail.p->svlist[i].y += (ScreenSize(Dy, zoomScale));
#endif /* UC */
      }
}

static
void MovePolygon (ObjPtr, Dx, Dy)
   struct ObjRec	* ObjPtr;
   int			Dx, Dy;
{
   register int	i;

   for (i = 0; i < ObjPtr->detail.g->n; i++)
   {
      ObjPtr->detail.g->vlist[i].x += Dx;
      ObjPtr->detail.g->vlist[i].y += Dy;
   }
   if (ObjPtr->detail.g->curved)
      for (i = 0; i < ObjPtr->detail.g->sn; i++)
      {
#ifndef UC
         ObjPtr->detail.g->svlist[i].x += (Dx>>zoomScale);
         ObjPtr->detail.g->svlist[i].y += (Dy>>zoomScale);
#else /* UC */
         ObjPtr->detail.g->svlist[i].x += (ScreenSize(Dx, zoomScale));
         ObjPtr->detail.g->svlist[i].y += (ScreenSize(Dy, zoomScale));
#endif /* UC */
      }
}

static
void MoveArc (ObjPtr, Dx, Dy)
   struct ObjRec	* ObjPtr;
   register int		Dx, Dy;
{
   register struct ArcRec	* arc_ptr = ObjPtr->detail.a;

   arc_ptr->xc += Dx;  arc_ptr->yc += Dy;
   arc_ptr->x1 += Dx;  arc_ptr->y1 += Dy;
   arc_ptr->x2 += Dx;  arc_ptr->y2 += Dy;
   arc_ptr->ltx += Dx; arc_ptr->lty += Dy;
}

void MoveObj (ObjPtr, Dx, Dy)
   struct ObjRec	* ObjPtr;
   int			Dx, Dy;
{
   struct ObjRec	* ptr;

   ObjPtr->x += Dx;
   ObjPtr->y += Dy;
   ObjPtr->bbox.ltx += Dx;
   ObjPtr->bbox.lty += Dy;
   ObjPtr->bbox.rbx += Dx;
   ObjPtr->bbox.rby += Dy;
   ObjPtr->obbox.ltx += Dx;
   ObjPtr->obbox.lty += Dy;
   ObjPtr->obbox.rbx += Dx;
   ObjPtr->obbox.rby += Dy;
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         MoveAttrs(ObjPtr->fattr, Dx, Dy);
         MovePoly (ObjPtr, Dx, Dy); 
         break;
      case OBJ_BOX : MoveAttrs(ObjPtr->fattr, Dx, Dy); break;
      case OBJ_OVAL: MoveAttrs(ObjPtr->fattr, Dx, Dy); break;
      case OBJ_TEXT: break;
      case OBJ_POLYGON:
         MoveAttrs(ObjPtr->fattr, Dx, Dy);
         MovePolygon (ObjPtr, Dx, Dy);
         break;
      case OBJ_ARC:
         MoveAttrs(ObjPtr->fattr, Dx, Dy);
         MoveArc(ObjPtr, Dx, Dy);
         break;
      case OBJ_RCBOX: MoveAttrs(ObjPtr->fattr, Dx, Dy); break;
      case OBJ_XBM: MoveAttrs(ObjPtr->fattr, Dx, Dy); break;
      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP:
         MoveAttrs(ObjPtr->fattr, Dx, Dy);
         for (ptr = ObjPtr->detail.r->first; ptr != NULL; ptr = ptr->next)
            MoveObj (ptr, Dx, Dy);
         break;
   }
}

void MoveAllSel (Dx, Dy)
   register int	Dx, Dy;
{
   register struct SelRec	* sel_ptr;

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      MoveObj (sel_ptr->obj, Dx, Dy);
}

void MoveSel (OrigX, OrigY, ObjPtr)
   int 			OrigX, OrigY;
   struct ObjRec	* ObjPtr;
{
   register int		i, num_pts = 0;
   struct OvalRec	* oval_ptr;
   struct PolyRec	* poly_ptr;
   struct PolygonRec	* polygon_ptr;
   struct ArcRec	* arc_ptr = NULL;
   struct ObjRec	* arc_obj_ptr = NULL;
   struct BBRec		bbox, o_bbox;
   XPoint		* v = NULL;
   int 			ltx = 0, lty = 0, rbx = 0, rby = 0;
   int			sel_ltx, sel_lty, sel_rbx, sel_rby;
   int			x, y, moving = TRUE, dx, dy;
   int			w = 0, h = 0, angle1 = 0, angle2 = 0;
   int			xc = 0, yc = 0, x1 = 0, y1 = 0, x2 = 0, y2 = 0;
   int			grid_x = OrigX, grid_y = OrigY, radius = 0;
   int			saved_xc = 0, saved_yc = 0, saved_x1 = 0, saved_y1 = 0;
   int			saved_x2 = 0, saved_y2 = 0;
   int			saved_ltx = 0, saved_lty = 0;
   XEvent		input;
#ifdef UC
   register int		hidedragcursor = hideDragCursor;
   register int		cursordefined = FALSE;
#endif /* UC */

   sel_ltx = OFFSET_X(selLtX) - 1; sel_lty = OFFSET_Y(selLtY) - 1;
   sel_rbx = OFFSET_X(selRbX) + 1; sel_rby = OFFSET_Y(selRbY) + 1;

   SelBox (drawWindow, revDefaultGC, sel_ltx, sel_lty, sel_rbx, sel_rby);

   switch (ObjPtr->type)
   {
      case OBJ_BOX:
      case OBJ_XBM:
      case OBJ_TEXT:
         ltx = OFFSET_X(ObjPtr->obbox.ltx); lty = OFFSET_Y(ObjPtr->obbox.lty);
         rbx = OFFSET_X(ObjPtr->obbox.rbx); rby = OFFSET_Y(ObjPtr->obbox.rby);
         SelBox (drawWindow, revDefaultGC, ltx, lty, rbx, rby);
         break;
      case OBJ_RCBOX:
         ltx = OFFSET_X(ObjPtr->obbox.ltx); lty = OFFSET_Y(ObjPtr->obbox.lty);
         rbx = OFFSET_X(ObjPtr->obbox.rbx); rby = OFFSET_Y(ObjPtr->obbox.rby);
         radius = ObjPtr->detail.rcb->radius;
         SetRCBoxVertex (ltx, lty, rbx, rby, radius);
         MyRCBox (drawWindow, revDefaultGC, ltx, lty, rbx, rby, radius);
         break;
      case OBJ_ARC:
         arc_obj_ptr = DupObj (ObjPtr);
         arc_ptr = arc_obj_ptr->detail.a;
         ltx = OFFSET_X(arc_ptr->ltx); lty = OFFSET_Y(arc_ptr->lty);
#ifndef UC
         w = (arc_ptr->w)>>zoomScale; h = (arc_ptr->h)>>zoomScale;
#else /* UC */
         w = ScreenSize((arc_ptr->w), zoomScale); h = ScreenSize((arc_ptr->h), zoomScale);
#endif /* UC */
         angle1 = arc_ptr->angle1; angle2 = arc_ptr->angle2;
         xc = OFFSET_X(arc_ptr->xc); yc = OFFSET_Y(arc_ptr->yc);
         x1 = OFFSET_X(arc_ptr->x1); y1 = OFFSET_Y(arc_ptr->y1);
         ArcRealX2Y2 (arc_ptr, &x2, &y2);
         x2 = OFFSET_X(x2); y2 = OFFSET_Y(y2);
         saved_xc = xc; saved_yc = yc;
         saved_x1 = x1; saved_y1 = y1;
         saved_x2 = x2; saved_y2 = y2;
         saved_ltx = ltx; saved_lty = lty;
         if (arc_ptr->fill != NONEPAT)
         {
            XDrawLine (mainDisplay, drawWindow, revDefaultGC, xc, yc, x1, y1);
            XDrawLine (mainDisplay, drawWindow, revDefaultGC, xc, yc, x2, y2);
         }
         XDrawArc (mainDisplay, drawWindow, revDefaultGC, ltx, lty, w, h,
               angle1, angle2);
         break;
      case OBJ_OVAL:
         oval_ptr = ObjPtr->detail.o;
         num_pts = 13;
         bbox.ltx = OFFSET_X(ObjPtr->obbox.ltx);
         bbox.lty = OFFSET_Y(ObjPtr->obbox.lty);
         bbox.rbx = OFFSET_X(ObjPtr->obbox.rbx);
         bbox.rby = OFFSET_Y(ObjPtr->obbox.rby);
         MyOval (drawWindow, revDefaultGC, bbox);
         break;
      case OBJ_POLY:
         poly_ptr = ObjPtr->detail.p;
         num_pts = poly_ptr->n;
         v = (XPoint *) calloc (poly_ptr->n, sizeof(XPoint));
         for (i = 0; i < num_pts; i++)
         {
            v[i].x = OFFSET_X(poly_ptr->vlist[i].x);
            v[i].y = OFFSET_Y(poly_ptr->vlist[i].y);
         }
         XDrawLines (mainDisplay, drawWindow, revDefaultGC, v, num_pts,
               CoordModeOrigin);
         break;
      case OBJ_POLYGON:
         polygon_ptr = ObjPtr->detail.g;
         num_pts = polygon_ptr->n;
         v = (XPoint *) calloc (polygon_ptr->n, sizeof(XPoint));
         for (i = 0; i < num_pts; i++)
         {
            v[i].x = OFFSET_X(polygon_ptr->vlist[i].x);
            v[i].y = OFFSET_Y(polygon_ptr->vlist[i].y);
         }
         XDrawLines (mainDisplay, drawWindow, revDefaultGC, v, num_pts,
               CoordModeOrigin);
         break;
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         ltx = OFFSET_X(ObjPtr->obbox.ltx); lty = OFFSET_Y(ObjPtr->obbox.lty);
         rbx = OFFSET_X(ObjPtr->obbox.rbx); rby = OFFSET_Y(ObjPtr->obbox.rby);
         SelBox (drawWindow, revDefaultGC, ltx, lty, rbx, rby);
         break;
   }

   XGrabPointer (mainDisplay, drawWindow, FALSE,
         PointerMotionMask | ButtonReleaseMask,
#ifndef UC
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
#else /* UC */
         GrabModeAsync, GrabModeAsync, None,
         ((hidedragcursor)? None:handCursor), CurrentTime);
#endif /* UC */

   dx = dy = 0;

   while (moving)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonRelease)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
#ifdef UC
	 if (hidedragcursor && cursordefined)
	 {
	     XDefineCursor (mainDisplay, drawWindow, defaultCursor);
	     cursordefined = FALSE;
	     XFlush (mainDisplay);
	 }
#endif /* UC */
         MarkRulers (grid_x, grid_y);
         moving = FALSE;

         switch (ObjPtr->type)
         {
            case OBJ_BOX:
            case OBJ_XBM:
            case OBJ_TEXT:
               SelBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy);
               break;
            case OBJ_RCBOX:
               MyRCBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy,
                     radius);
               break;
            case OBJ_OVAL:
               o_bbox.ltx = bbox.ltx + dx; o_bbox.lty = bbox.lty + dy;
               o_bbox.rbx = bbox.rbx + dx; o_bbox.rby = bbox.rby + dy;
               MyOval (drawWindow, revDefaultGC, o_bbox);
               break;
            case OBJ_ARC:
               XDrawArc (mainDisplay, drawWindow, revDefaultGC, ltx, lty, w, h,
                     angle1, angle2);
               if (arc_ptr->fill != NONEPAT)
               {
                  XDrawLine (mainDisplay,drawWindow,revDefaultGC,xc,yc,x1,y1);
                  XDrawLine (mainDisplay,drawWindow,revDefaultGC,xc,yc,x2,y2);
               }
               break;
            case OBJ_POLY:
            case OBJ_POLYGON:
               for (i = 0; i < num_pts; i++)
               {
                  v[i].x += dx;
                  v[i].y += dy;
               }
               XDrawLines (mainDisplay, drawWindow, revDefaultGC, v, num_pts,
                     CoordModeOrigin);
               for (i = 0; i < num_pts; i++)
               {
                  v[i].x -= dx;
                  v[i].y -= dy;
               }
               break;
            case OBJ_GROUP:
            case OBJ_SYM:
            case OBJ_ICON:
               SelBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy);
               break;
         }
         SelBox (drawWindow, revDefaultGC, sel_ltx+dx, sel_lty+dy, sel_rbx+dx,
               sel_rby+dy);

         dx = grid_x - OrigX;
         dy = grid_y - OrigY;

         switch (ObjPtr->type)
         {
            case OBJ_ARC: FreeArcObj (arc_obj_ptr); break;
            case OBJ_POLY:
            case OBJ_POLYGON: cfree(v); break;
         }
         if (dx != 0 || dy != 0)
         {
#ifndef UC
            HighLightReverse ();
            dx = RealSize(dx, zoomScale);
            dy = RealSize(dy, zoomScale);
            MoveAllSel (dx, dy);
            RedrawAreas (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
                  selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)),
                  selLtX-(RealSize(1, zoomScale))+dx, selLtY-(RealSize(1, zoomScale))+dy,
                  selRbX+(RealSize(1, zoomScale))+dx, selRbY+(RealSize(1, zoomScale))+dy);
            HighLightForward ();
            UpdSelBBox ();
            if (justDupped)
            {
               dupDx += dx;
               dupDy += dy;
            }
            SetFileModified (TRUE);
#else /* UC */
	    DoMoveAllSel (dx, dy);
#endif /* UC */
         }
      }
      else if (input.type == MotionNotify)
      {
         x = input.xmotion.x;
         y = input.xmotion.y;
         GridXY (x, y, &grid_x, &grid_y);

#ifdef UC
	 if (hidedragcursor && (! cursordefined) && (dx != 0 || dy != 0))
	 {
	     cursordefined = TRUE;
	     XDefineCursor (mainDisplay, drawWindow, dragCursor);
	 }
#endif /* UC */
         switch (ObjPtr->type)
         {
            case OBJ_BOX:
            case OBJ_XBM:
            case OBJ_TEXT:
               SelBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy);
               break;
            case OBJ_RCBOX:
               MyRCBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy,
                     radius);
               break;
            case OBJ_ARC:
               XDrawArc (mainDisplay, drawWindow, revDefaultGC, ltx, lty, w, h,
                     angle1, angle2);
               if (arc_ptr->fill != NONEPAT)
               {
                  XDrawLine (mainDisplay,drawWindow,revDefaultGC,xc,yc,x1,y1);
                  XDrawLine (mainDisplay,drawWindow,revDefaultGC,xc,yc,x2,y2);
               }
               break;
            case OBJ_OVAL:
               o_bbox.ltx = bbox.ltx + dx; o_bbox.lty = bbox.lty + dy;
               o_bbox.rbx = bbox.rbx + dx; o_bbox.rby = bbox.rby + dy;
               MyOval (drawWindow, revDefaultGC, o_bbox);
               break;
            case OBJ_POLY:
            case OBJ_POLYGON:
               for (i = 0; i < num_pts; i++)
               {
                  v[i].x += dx;
                  v[i].y += dy;
               }
               XDrawLines (mainDisplay, drawWindow, revDefaultGC, v, num_pts,
                     CoordModeOrigin);
               for (i = 0; i < num_pts; i++)
               {
                  v[i].x -= dx;
                  v[i].y -= dy;
               }
               break;
            case OBJ_GROUP:
            case OBJ_SYM:
            case OBJ_ICON:
               SelBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy);
               break;
         }
         SelBox (drawWindow, revDefaultGC, sel_ltx+dx, sel_lty+dy, sel_rbx+dx,
               sel_rby+dy);

         dx = grid_x - OrigX;
         dy = grid_y - OrigY;

         MarkRulers (grid_x, grid_y);
         SelBox (drawWindow, revDefaultGC, sel_ltx+dx, sel_lty+dy, sel_rbx+dx,
               sel_rby+dy);
         switch (ObjPtr->type)
         {
            case OBJ_BOX:
            case OBJ_XBM:
            case OBJ_TEXT:
               SelBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy);
               break;
            case OBJ_RCBOX:
               SetRCBoxVertex (ltx+dx, lty+dy, rbx+dx, rby+dy, radius);
               MyRCBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy,
                     radius);
               break;
            case OBJ_OVAL:
               o_bbox.ltx = bbox.ltx + dx; o_bbox.lty = bbox.lty + dy;
               o_bbox.rbx = bbox.rbx + dx; o_bbox.rby = bbox.rby + dy;
               MyOval (drawWindow, revDefaultGC, o_bbox);
               break;
            case OBJ_ARC:
               xc = saved_xc+dx; yc = saved_yc+dy;
               x1 = saved_x1+dx; y1 = saved_y1+dy;
               x2 = saved_x2+dx; y2 = saved_y2+dy;
               ltx = saved_ltx+dx; lty = saved_lty+dy;
               if (arc_ptr->fill != NONEPAT)
               {
                  XDrawLine (mainDisplay,drawWindow,revDefaultGC,xc,yc,x1,y1);
                  XDrawLine (mainDisplay,drawWindow,revDefaultGC,xc,yc,x2,y2);
               }
               XDrawArc (mainDisplay, drawWindow, revDefaultGC, ltx, lty, w, h,
                     angle1, angle2);
               break;
            case OBJ_POLY:
            case OBJ_POLYGON:
               for (i = 0; i < num_pts; i++)
               {
                  v[i].x += dx;
                  v[i].y += dy;
               }
               XDrawLines (mainDisplay, drawWindow, revDefaultGC, v, num_pts,
                     CoordModeOrigin);
               for (i = 0; i < num_pts; i++)
               {
                  v[i].x -= dx;
                  v[i].y -= dy;
               }
               break;
            case OBJ_GROUP:
            case OBJ_SYM:
            case OBJ_ICON:
               SelBox (drawWindow,revDefaultGC,ltx+dx,lty+dy,rbx+dx,rby+dy);
               break;
         }
      }
   }
}
#ifdef UC
void DoMoveAllSel (dx, dy)
int dx, dy;
{
/* #ifdef UC */    
    undo.operation = MOVE;
    undo.info.m.dx = dx;
    undo.info.m.dy = dy;	    
/* #endif UC */    
    HighLightReverse ();
    dx = RealSize(dx, zoomScale);
    dy = RealSize(dy, zoomScale);
    MoveAllSel (dx, dy);
    RedrawAreas (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
		 selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)),
		 selLtX-(RealSize(1, zoomScale))+dx, selLtY-(RealSize(1, zoomScale))+dy,
		 selRbX+(RealSize(1, zoomScale))+dx, selRbY+(RealSize(1, zoomScale))+dy);
    HighLightForward ();
    UpdSelBBox ();
    if (justDupped)
    {
	dupDx += dx;
	dupDy += dy;
    }
    SetFileModified (TRUE);
}
#endif /* UC */
