/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/msg.c,v 2.0 91/03/05 14:17:49 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "font.e"
#include "raster.e"
#include "setup.e"

#define MSG_ROWS 2

struct MsgRec {
   char			* s;
   struct MsgRec	* next, * prev;
};

static struct MsgRec	* topMsg = NULL, * botMsg = NULL;
static struct MsgRec	* mostRecentTopMsgPtr = NULL;
static int		msgCount = 0;
static int		topMsgNumber = 0, mostRecentTopMsgNumber = INVALID;

static
void AddMsg (Msg)
   char	* Msg;
{
   char			* s;
   struct MsgRec	* msg_ptr;

   if (*Msg == '\0') { topMsgNumber = msgCount; return; }

   s = (char *) calloc (strlen (Msg) + 1, sizeof(char));
   msg_ptr = (struct MsgRec *) calloc (1, sizeof(struct MsgRec));

   strcpy (s, Msg);
   msg_ptr->s = s;

   ++msgCount;
   if (msgCount > topMsgNumber+MSG_ROWS) topMsgNumber = msgCount-MSG_ROWS;

   msg_ptr->prev = botMsg;
   msg_ptr->next = NULL;

   if (botMsg == NULL)
      topMsg = msg_ptr;
   else
      botMsg->next = msg_ptr;

   botMsg = msg_ptr;
}

void CleanUpMsg ()
{
   register struct MsgRec	* msg_ptr;

   for (msg_ptr = botMsg; msg_ptr != NULL; msg_ptr = msg_ptr->prev)
   {
      cfree (msg_ptr->s);
      cfree (msg_ptr);
   }
   topMsg = botMsg = mostRecentTopMsgPtr = NULL;
   msgCount = topMsgNumber = 0;
   mostRecentTopMsgNumber = INVALID;
}

static
struct MsgRec * FindMsg (Number)
   int	Number;
{
   register int			i;
   register struct MsgRec	* ptr = NULL;

   if (Number >= msgCount)
      return (botMsg);
   else if (Number < 0)
      return (topMsg);
   else if (Number > (int)(msgCount/2))
      for (i = msgCount-1, ptr = botMsg; i != Number; i--, ptr = ptr->prev) ;
   else
      for (i = 0, ptr = topMsg; i != Number; i++, ptr = ptr->next) ;

   return (ptr);
}

void RedrawMsg ()
{
   int			i, x, y;
   XEvent       	ev;
   struct MsgRec	* msg_ptr;

   XClearWindow (mainDisplay, msgWindow);
#ifndef UC
   XSync (mainDisplay, FALSE);
#else /* UC */
   XFlush (mainDisplay);
#endif /* UC */   
   while (XCheckWindowEvent (mainDisplay, msgWindow, ExposureMask, &ev)) ;

   if (topMsgNumber == msgCount) return;

   x = 2;
   y = 2 + defaultFontAsc;

   mostRecentTopMsgPtr = msg_ptr = (topMsgNumber == mostRecentTopMsgNumber) ?
         mostRecentTopMsgPtr : FindMsg (topMsgNumber);
   mostRecentTopMsgNumber = topMsgNumber;

   for (i = topMsgNumber; i < min(msgCount,topMsgNumber+MSG_ROWS); i++)
   {
      XDrawString (mainDisplay, msgWindow, defaultGC, x, y, msg_ptr->s,
            strlen(msg_ptr->s));
      msg_ptr = msg_ptr->next;
      y += defaultFontHeight;
   }
#ifndef UC
   XSync (mainDisplay, FALSE);
#else /* UC */
   XFlush (mainDisplay);
#endif /* UC */
}

void Msg (Message)
   char	* Message;
{
   AddMsg (Message);
   RedrawMsg ();
}

void TwoLineMsg (Msg1, Msg2)
   char	* Msg1, * Msg2;
{
   AddMsg (Msg1);
   AddMsg (Msg2);
   RedrawMsg ();
}

void MsgEventHandler (input)
   XEvent	* input;
{
   XButtonEvent	* button_ev;
   double	frac;

   if (input->type == Expose)
      RedrawMsg ();
   else if (input->type == ButtonPress)
   {
      button_ev = &(input->xbutton);
      if (button_ev->button == Button1)
      {
         if (topMsgNumber+1 >= msgCount) return;

         topMsgNumber++;
         RedrawMsg ();
      }
      else if (button_ev->button == Button2)
      {
         frac = ((double)button_ev->y) / ((double)msgWindowH);
         topMsgNumber = max(0,round (msgCount * frac));
         RedrawMsg ();
      }
      else if (button_ev->button == Button3)
      {
         if (topMsgNumber == 0) return;

         topMsgNumber--;
         RedrawMsg ();
      }
   }
}
