/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/names.c,v 2.0 91/03/05 12:47:39 william Exp $";
#endif

#ifdef SYSV
#include <stdio.h>
#endif /* SYSV */

#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "box.e"
#include "button.e"
#include "cursor.e"
#include "file.e"
#include "font.e"
#include "mainloop.e"
#include "raster.e"
#include "scroll.e"
#include "setup.e"

#include "xbm/uparrow.xbm"
#include "xbm/downarrow.xbm"

#define ITEM_DSPED 10
#define ITEM_LEN 30
#define ROW_HEIGHT (defaultFontHeight+1)
#define BUTTON_OK 0
#define BUTTON_SETDIR 1
#define BUTTON_CANCEL 2
#define MAXBUTTONS 3

typedef struct _DspList {
   char			itemstr[MAXPATHLENGTH+1];
   char			pathstr[MAXPATHLENGTH+1];
   int			directory;
   struct _DspList	* next;
} DspList;

extern char	* getenv ();

char	curDomainName[MAXPATHLENGTH];
char	curDomainPath[MAXPATHLENGTH];
char	curDir[MAXPATHLENGTH];
char	curImportDir[MAXPATHLENGTH];
char	curSymDir[MAXPATHLENGTH];

static Window		nameBaseWin;
static Window		nameDspWin;
static Window		nameScrollWin;
static int		nameEntries;
static char		* * nameDspPtr;
static int		nameFirst;
static int		nameMarked;
static struct BBRec	buttonBBox[MAXBUTTONS];
static int		numButtons = 2;
static char		buttonStr[MAXBUTTONS][8];

static int	nameDspH;		/* height of display area */
static int	nameDspW;		/* width of display area */
static int	nameDspWinH;		/* height of display window */
static int	nameDspWinW;		/* width of display window */
static int	nameScrollAreaH;	/* heighr of the grey scroll area */

static int	doubleClickInterval;

static GC	nameGC;
static GC	revNameGC;

static DspList	* symbolList = NULL;
static int	numSymbols;
static DspList	* dirList = NULL;
static int	numDirEntries;

static DspList	* topOfSymLinkList = NULL;
static DspList	* topOfDirLinkList = NULL;

#ifdef	SYSV
#include <stdio.h>

static struct {
    struct direct	dir;
    char		eos;
} dir_buf = {
    {	0,	'\0',	},
    '\0'
};

#define opendir(path)	fopen(path, "r")
#define	readdir(dirp)	fread(&dir_buf.dir, sizeof(struct direct), 1, dirp) ? \
				&dir_buf.dir : (struct direct *)0
#define	closedir(dirp)	fclose(dirp)
#define	DIR		FILE
#endif /* SYSV */
static
char * ReadPath (path_str, dir_str)
   char * path_str, * dir_str;
{
   register char        * s1, * s2;

   s1 = path_str;
   if (*s1 == '~')
   {
      strcpy (dir_str, homeDir);
      s2 = &dir_str[strlen(dir_str)];
      s1++;
   }
   else
      s2 = dir_str;

   for ( ; *s1 != '\0' && *s1 != ':'; s1++)
      if (*s1 == '\\')
         strcpy (s1, s1+1);
      else
         *s2++ = *s1;

   *s2 = '\0';
   if (*s1 == ':') s1++;
   return (s1);
}

void ParseSymPath (path_str)
   char * path_str;
{
   register char        * s;
   register int         i;
   char                 dir_str[MAXPATHLENGTH];

   for (i = 0, s = path_str; *s != '\0'; )
   {
      s = ReadPath (s, dir_str);
      if (dir_str != '\0') i++;
   }
   symPath = (char * *) calloc (i, sizeof (char *));
   symPathNumEntries = i;
   for (i = 0, s = path_str; *s != '\0'; )
   {
      s = ReadPath (s, dir_str);
      if (dir_str != '\0')
      {
         symPath[i] = (char *) calloc (MAXPATHLENGTH, sizeof (char));
         strcpy (symPath[i], dir_str);
         i++;
      }
   }
   strcpy (curDomainPath, path_str);
}

static
DspList * SymbolListing ()
{
   int			len, path_index, count = 0, reject;
   char			path[MAXPATHLENGTH];
   DspList		* dsp_ptr = NULL, * head_ptr, * tail_ptr, * p, * p1;
#ifdef SYSV
   FILE  		* dirp;
#else /* SYSV */
   DIR			* dirp;
#endif /* SYSV */
   struct direct	* d;

   head_ptr = tail_ptr = NULL;
   for (path_index = 0; path_index < symPathNumEntries; path_index++)
   {
      strcpy (path, symPath[path_index]);
      if (strcmp (".", path) == 0) strcpy (path, curDir);

#ifdef SYSV
      d = (struct direct *) malloc(sizeof(struct direct));
      if ((dirp = fopen (path, "r")) == NULL)
         continue;
#else /* SYSV */
      if ((dirp = opendir (path)) == NULL)
         continue;
#endif /* SYSV */

#ifdef SYSV
      while ((fread (d, sizeof(struct direct), 1, dirp)) != NULL)
      {
	  if (d->d_ino == 0) continue;
#else /* SYSV */
      while ((d = readdir (dirp)) != NULL)
      {
#endif /* SYSV */
         len = strlen (d->d_name);
         if (len > 4 && (strcmp (".sym", &d->d_name[len-4]) == 0))
            d->d_name[len-4] = '\0';
         else
            continue;

         if (head_ptr == NULL)
         {
            head_ptr = tail_ptr = (DspList *) calloc (1, sizeof(DspList));
            strcpy (head_ptr->itemstr, d->d_name);
            strcpy (head_ptr->pathstr, path);
         }
         else
         {
            p1 = NULL;
            reject = FALSE;
            for (p = head_ptr; p != NULL; p = p->next)
            {
               if (strcmp (d->d_name, p->itemstr) == 0)
               {
                  reject = TRUE;
                  break;
               }
               else if (LargerStr (d->d_name, p->itemstr))
                  p1 = p;
               else
               {
                  dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
                  strcpy (dsp_ptr->itemstr, d->d_name);
                  strcpy (dsp_ptr->pathstr, path);
                  break;
               }
            }
            if (reject) continue;
   
            dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
            dsp_ptr->next = p;
            strcpy (dsp_ptr->itemstr, d->d_name);
            strcpy (dsp_ptr->pathstr, path);

            if (p == NULL)
            {  /* dsp_ptr has the largest element */
               tail_ptr->next = dsp_ptr;
               tail_ptr = dsp_ptr;
            }
            else if (p1 == NULL)
               head_ptr = dsp_ptr;
            else
               p1->next = dsp_ptr;
         }
         count++;
      }
      closedir (dirp);
   }
   numSymbols = count;
   return (head_ptr);
}

static
void BuildSymbolList ()
{
   register int		i;
   register DspList	* dsp_ptr;

   if (symbolList != NULL) cfree (symbolList);

   symbolList = (DspList *) calloc (numSymbols, sizeof (DspList));
   dsp_ptr = topOfSymLinkList;
   for (i = 0; i < numSymbols; i++, dsp_ptr = dsp_ptr->next)
   {
      strcpy (symbolList[i].itemstr, dsp_ptr->itemstr);
      strcpy (symbolList[i].pathstr, dsp_ptr->pathstr);
      symbolList[i].next = &symbolList[i+1];
      cfree (dsp_ptr);
   }
   symbolList[numSymbols-1].next = NULL;
   topOfSymLinkList = NULL;
}

static
DspList * DirListing (Path, ExtStr)
   char	* Path, * ExtStr;
{
   DspList		* dsp_ptr = NULL, * head_ptr, * tail_ptr, * p, * p1;
   DIR			* dirp;
   struct direct	* d;
   int			len, ext_len, count = 0;
   char			path[MAXPATHLENGTH], s[MAXPATHLENGTH];
   char			ext_str[MAXPATHLENGTH];
   struct stat		stat_buf;

   if (*Path == '\0')
   {
      strcpy (path, "/");
      if ((dirp = opendir (path)) == NULL) return (NULL);
   }
   else
   {
      strcpy (path, Path);
      if ((dirp = opendir (path)) == NULL) return (NULL);
      strcat (path, "/");
   }

   sprintf (ext_str, ".%s", ExtStr);
   ext_len = strlen (ext_str);

   head_ptr = tail_ptr = NULL;

   while ((d = readdir (dirp)) != NULL)
   {
      len = strlen (d->d_name);
      if (len > ext_len && (strcmp (ext_str, &d->d_name[len-ext_len]) == 0))
      {
         d->d_name[len-ext_len] = '\0';
         dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
         dsp_ptr->directory = FALSE;
         strcpy (dsp_ptr->itemstr, d->d_name);
      }
      else if (strcmp (d->d_name, ".") == 0)
         continue;
      else
      {
         sprintf (s, "%s%s", path, d->d_name);
         stat (s, &stat_buf);
         if (stat_buf.st_mode & S_IFDIR)
         {
            dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
            dsp_ptr->directory = TRUE;
            strcat (d->d_name, "/");
            strcpy (dsp_ptr->itemstr, d->d_name);
         }
         else
            continue;
      }
      if (head_ptr == NULL)
         head_ptr = tail_ptr = dsp_ptr;
      else
      {
         p1 = NULL;
         for (p = head_ptr; p != NULL; p = p->next)
            if (LargerStr (d->d_name, p->itemstr))
               p1 = p;
            else
               break;

         dsp_ptr->next = p;
         if (p == NULL)
         {  /* dsp_ptr has the largest element */
            tail_ptr->next = dsp_ptr;
            tail_ptr = dsp_ptr;
         }
         else if (p1 == NULL)
            head_ptr = dsp_ptr;
         else
            p1->next = dsp_ptr;
      }
      count++;
   }

   closedir (dirp);
   numDirEntries = count;
   return (head_ptr);
}

static
void BuildDirList ()
{
   register int		i;
   register DspList	* dsp_ptr;

   if (topOfDirLinkList != NULL)
   {
      if (dirList != NULL) cfree (dirList);

      dirList = (DspList *) calloc (numDirEntries, sizeof (DspList));
      dsp_ptr = topOfDirLinkList;
      for (i = 0; i < numDirEntries; i++, dsp_ptr = dsp_ptr->next)
      {
         strcpy (dirList[i].itemstr, dsp_ptr->itemstr);
         strcpy (dirList[i].pathstr, dsp_ptr->pathstr);
         dirList[i].directory = dsp_ptr->directory;
         dirList[i].next = &dirList[i+1];
         cfree (dsp_ptr);
      }
      dirList[numDirEntries-1].next = NULL;
      topOfDirLinkList = NULL;
   }
}

void InitNames ()
{
   int		default_found = FALSE;
   char		* c_ptr, domain_str[20], sym_path[80];
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillSolid;
   values.font = defaultFontPtr->fid;
   nameGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);

   values.foreground = myBgPixel;
   values.background = myFgPixel;
   revNameGC = XCreateGC (mainDisplay, rootWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);

   nameDspW = ITEM_LEN * defaultFontWidth;
   nameDspH = ITEM_DSPED * ROW_HEIGHT;
   nameDspWinW = nameDspW + 2 * brdrW;
   nameDspWinH = nameDspH + 2 * brdrW;
   nameScrollAreaH = nameDspH - 2 * uparrow_height;

   *curDomainName = '\0';
   *curDomainPath = '\0';
   *curSymDir = '\0';
   strcpy (curDir, bootDir);
   strcpy (curImportDir, bootDir);

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DoubleClickInterval")) !=
         NULL)
      doubleClickInterval = atoi (c_ptr);
   else
      doubleClickInterval = 300;

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DefaultDomain")) != NULL)
   {
      sprintf (domain_str, "Domain%s", c_ptr);
      if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, domain_str)) != NULL)
      {
         if (*c_ptr != '\0')
         {
            strcpy (curDomainName, c_ptr);
            sprintf (sym_path, "TGIF_%s", c_ptr);
            default_found = TRUE;
         }
      }
   }

   if (!default_found || (c_ptr = getenv (sym_path)) == NULL)
      ParseSymPath (".");
   else
      if (strlen (c_ptr) >= MAXPATHLENGTH-1)
         ParseSymPath (".");
      else 
         ParseSymPath (c_ptr);
   if ((topOfSymLinkList = SymbolListing ()) != NULL) BuildSymbolList ();
}

void UpdateDirInfo ()
{
   if ((topOfDirLinkList = DirListing (curDir, "obj")) != NULL) BuildDirList ();
}

void UpdateSymInfo ()
{
   if ((topOfSymLinkList = SymbolListing ()) != NULL) BuildSymbolList ();
}

void CleanUpNames ()
{
   XFreeGC (mainDisplay, nameGC);
   XFreeGC (mainDisplay, revNameGC);

   if (symbolList != NULL) cfree (symbolList);
   if (dirList != NULL) cfree (dirList);
}

static
void RedrawNameScrollWin ()
{
   double        frac, start_frac;
   int          block_h, block_start;
   XGCValues	values;
   XEvent	ev;

   XSync (mainDisplay, FALSE);
   while (XCheckWindowEvent (mainDisplay, vSBarWindow, ExposureMask, &ev)) ;

   start_frac = (nameEntries > 0) ?
         (double)((double)(nameFirst)/(double)(nameEntries)) : (double)(0);
   block_start = (int)(nameScrollAreaH * start_frac); /* starting pixel */

   if (nameEntries > ITEM_DSPED)
      frac = (double)((double)ITEM_DSPED / (double)(nameEntries));
   else
      frac = 1.0;

   block_h = (int)(nameScrollAreaH * frac); /* number of pixels */

   values.foreground = myBgPixel;
   values.background = myFgPixel;
   values.function = GXcopy;
   values.fill_style = FillSolid;
   XChangeGC (mainDisplay, scrollGC,
         GCForeground | GCBackground | GCFunction | GCFillStyle, &values);
   XFillRectangle (mainDisplay, nameScrollWin, scrollGC, 0, scrollBarW,
         scrollBarW, nameScrollAreaH);

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillOpaqueStippled;
   values.stipple = patPixmap[SCROLLPAT];
   XChangeGC (mainDisplay, scrollGC,
         GCForeground | GCBackground | GCFillStyle | GCStipple, &values);
   XFillRectangle (mainDisplay, nameScrollWin, scrollGC, 0,
         scrollBarW+block_start, scrollBarW, block_h);

   scrollImage->data = upData;
   XPutImage (mainDisplay, nameScrollWin, scrollGC, scrollImage, 0, 0, 0, 0,
         scrollBarW, scrollBarW);
   scrollImage->data = downData;
   XPutImage (mainDisplay, nameScrollWin, scrollGC, scrollImage, 0, 0,
         0, scrollBarW+nameScrollAreaH, scrollBarW, scrollBarW);
}

static
void RedrawDspWindow ()
{
   register int	i;
   int		top, len, end;

   top = defaultFontAsc+1;

   if (nameFirst+ITEM_DSPED > nameEntries)
      end = nameEntries;
   else
      end = nameFirst + ITEM_DSPED;

   XFillRectangle (mainDisplay, nameDspWin, revNameGC, 0, 0,
         ITEM_LEN*defaultFontWidth, ITEM_DSPED*ROW_HEIGHT);

   for (i = nameFirst; i < end; i++)
   {
      len = strlen (nameDspPtr[i]);
      if (i == nameMarked)
      {
         XFillRectangle (mainDisplay, nameDspWin, nameGC,
               0, (i-nameFirst)*ROW_HEIGHT, ITEM_LEN*defaultFontWidth,
               ROW_HEIGHT);
         XDrawString (mainDisplay, nameDspWin, revNameGC,
               0, (i-nameFirst)*ROW_HEIGHT+top, nameDspPtr[i], len);
      }
      else
      {
         XFillRectangle (mainDisplay, nameDspWin, revNameGC,
               0, (i-nameFirst)*ROW_HEIGHT, ITEM_LEN*defaultFontWidth,
               ROW_HEIGHT);
         XDrawString (mainDisplay, nameDspWin, nameGC,
               0, (i-nameFirst)*ROW_HEIGHT+top, nameDspPtr[i], len);
      }
   }
}

static
void RedrawNamePath (Path, X, Y)
   char	* Path;
   int	X, Y;
{
   int	len = strlen (Path), cursor_x, cursor_y;
   char	* c_ptr;

   cursor_y = Y-defaultFontAsc;

   XClearArea (mainDisplay, nameBaseWin, X, Y-defaultFontAsc,
         ITEM_LEN*defaultFontWidth+4, defaultFontHeight+4, False);
   XDrawRectangle (mainDisplay, nameBaseWin, nameGC, X, cursor_y-2,
         ITEM_LEN*defaultFontWidth+8, defaultFontHeight+4);

   if (len > ITEM_LEN)
   {
      c_ptr = &(Path[len-ITEM_LEN]);
      len = ITEM_LEN;
   }
   else
      c_ptr = Path;

   cursor_x = X+2+len*defaultFontWidth;
   XDrawString (mainDisplay, nameBaseWin, nameGC, X+2, Y, c_ptr, len);
   XDrawLine (mainDisplay, nameBaseWin, nameGC, cursor_x,
         cursor_y, cursor_x, cursor_y+defaultFontHeight);
}

static
void RedrawNameBaseWindow (Str, Path, str_start, path_start, button_start, W, H)
   char	* Str, * Path;
   int	str_start, path_start, button_start, W, H;
{
   int	i, top = defaultFontAsc+2, left;

   XDrawRectangle (mainDisplay, nameBaseWin, nameGC, 0, 0, W-1, H-1);
   XDrawString (mainDisplay, nameBaseWin, nameGC, str_start,
         ROW_HEIGHT+top, Str, strlen(Str));
   RedrawNamePath (Path, path_start, 3*ROW_HEIGHT+top);

   left = button_start;
   for (i = 0; i < numButtons; i++)
   {
      buttonBBox[i].lty = (ITEM_DSPED+6) * ROW_HEIGHT;
      buttonBBox[i].ltx = left;
      DisplayButton (nameBaseWin, buttonStr[i], 8, &(buttonBBox[i]),
            BUTTON_NORMAL);
      left = buttonBBox[i].rbx + 1 + defaultFontWidth;
   }
}

static
char * * MakeNameDspItemArray (Entries, DLPtr)
   int		Entries;
   DspList	* DLPtr;
{
   register int	i, j, len;
   char		* * dsp_ptr, * c_ptr;

   if (Entries == 0) return (NULL);

   dsp_ptr = (char * *) calloc (Entries, sizeof(char *));
   c_ptr = (char *) calloc (Entries*MAXPATHLENGTH, sizeof(char));
   for (i = 0; i < Entries; i++, DLPtr = DLPtr->next)
   {
      dsp_ptr[i] = c_ptr;
      len = strlen (DLPtr->itemstr);
      if (!DLPtr->directory)
      {
         for (j = len; j >= 0 && DLPtr->itemstr[j] != '/'; j--) ;
         if (j >= 0)
            strcpy (c_ptr, (&(DLPtr->itemstr[j]))+1);
         else
            strcpy (c_ptr, DLPtr->itemstr);
      }
      else
         strcpy (c_ptr, DLPtr->itemstr);

      c_ptr += MAXPATHLENGTH;
   }
   return (dsp_ptr);
}

static
int GetNameEntryNum (RowOffset)
   int		RowOffset;
{
   register int	index;

   index = nameFirst + RowOffset;
   if (index >= nameEntries) return (INVALID);
   return (index);
}

static
void NameScrollHandler (button_ev)
   XButtonEvent	* button_ev;
{
   double	frac, start_frac;
   int		block_h, block_start;

   if (button_ev->y < scrollBarW)
   {
      /* clicked in the uparrow */
      if (nameFirst != 0)
      {
         nameFirst--;
         RedrawNameScrollWin ();
         RedrawDspWindow ();
         return;
      }
   }
   else if (button_ev->y >= scrollBarW+nameScrollAreaH)
   {
      /* clicked in the downarrow */
      if (nameEntries <= ITEM_DSPED) return;

      if (nameFirst+ITEM_DSPED != nameEntries)
      {
         nameFirst++;
         RedrawNameScrollWin ();
         RedrawDspWindow ();
         return;
      }
   }
   else /* clicked in the middle region */
   {
      if (nameEntries <= ITEM_DSPED) return;

      frac = (double)((double)ITEM_DSPED / (double)(nameEntries));
      block_h = (int)(nameScrollAreaH * frac);
      block_start = button_ev->y - scrollBarW;
      start_frac = (double)((double)(block_start)/(double)(nameScrollAreaH));
      if (block_start+block_h >= nameScrollAreaH)
      {
         nameFirst = nameEntries - ITEM_DSPED;
         RedrawNameScrollWin ();
         RedrawDspWindow ();
         return;
      }
      else
      {
         nameFirst = (int)(nameEntries * start_frac);
         RedrawNameScrollWin ();
         RedrawDspWindow ();
         return;
      }
   }
}

static Time	lastClickTime;
static int	justClicked;
static int	lastNameMarked;

static
int NameDspHandler (button_ev)
   XButtonEvent	* button_ev;
{
   int	row_offset, len, top;
   Time	click_time;

   top = defaultFontAsc+1;

   row_offset = (int)(button_ev->y / ROW_HEIGHT);

   if (nameMarked != INVALID &&
         nameMarked >= nameFirst && nameMarked < nameFirst+ITEM_DSPED)
   {
      len = strlen (nameDspPtr[nameMarked]);
      XFillRectangle (mainDisplay, nameDspWin, revNameGC, 0,
            (nameMarked - nameFirst)*ROW_HEIGHT,
            ITEM_LEN*defaultFontWidth, ROW_HEIGHT);
      XDrawString (mainDisplay, nameDspWin, nameGC, 0,
            (nameMarked - nameFirst)*ROW_HEIGHT+top,
            nameDspPtr[nameMarked], len);
   }

   nameMarked = GetNameEntryNum (row_offset);
   if (nameMarked != INVALID)
   {
      len = strlen (nameDspPtr[nameMarked]);
      XFillRectangle (mainDisplay, nameDspWin, nameGC, 0,
            (nameMarked - nameFirst)*ROW_HEIGHT,
            ITEM_LEN*defaultFontWidth, ROW_HEIGHT);
      XDrawString (mainDisplay, nameDspWin, revNameGC, 0,
            (nameMarked - nameFirst)*ROW_HEIGHT+top,
            nameDspPtr[nameMarked], len);
   }

   click_time = button_ev->time;
   if (justClicked && nameMarked != INVALID && lastNameMarked == nameMarked &&
         (click_time-lastClickTime) < doubleClickInterval)
      return (TRUE);

   justClicked = TRUE;
   lastClickTime = click_time;
   lastNameMarked = nameMarked;
   return (INVALID);
}

static char * okCancelStr[] = { "OK", "CANCEL" };

static
int LargerStr (S1, S2)
   register char	* S1, * S2;
   /* returns TRUE if S1 > S2 */
{
   while (*S1 == *S2 && *S1 != '\0' && *S2 != '\0') { S1++; S2++; }

   return (*S1 > *S2);
}

static
int DirNames (TopStr, ExtStr, SelStr, JustSetDir)
   char	* TopStr, * ExtStr, * SelStr;
   int	*JustSetDir;
{
   int			button_widths, str_width, graph_width;
   int			str_start, button_start, graph_start, index = 0;
   int			dsp_w, dsp_h, w, h, i, exposure = 0;
   int			button_selected = INVALID, change_to_root;
   int			faking_dot_dot;
   XEvent		input;
   int			looping = TRUE, changing, name_index, pop_from_root;
   char			buf[80], name[MAXPATHLENGTH], full_name[MAXPATHLENGTH];
   char			dir_name[MAXPATHLENGTH], sel_str[MAXPATHLENGTH];
   char			saved_dir_name[MAXPATHLENGTH], saved_name[MAXSTRING];
   XKeyEvent		* key_ev;
   XButtonEvent		* button_ev;
   KeySym		key_sym;
   XComposeStatus	c_stat;
   XSetWindowAttributes	win_attrs;
   int			win_x, win_y;
   DspList		* dsp_ptr;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   button_widths = ButtonWidth("OK", 8) + ButtonWidth("CANCEL", 8) +
         ButtonWidth("SETDIR", 8) + defaultFontWidth;
   numButtons = 3;
   strcpy (buttonStr[0], "OK");
   strcpy (buttonStr[1], "SETDIR");
   strcpy (buttonStr[2], "CANCEL");

   str_width = defaultFontWidth * strlen (TopStr);
   graph_width = nameDspWinW + scrollBarW + 2 * brdrW;

   if (str_width > graph_width)
   {
      w = str_width + 4 * defaultFontWidth;
      str_start = 2 * defaultFontWidth;
      graph_start = (w - graph_width) / 2;
   }
   else
   {
      w = graph_width + 4 * defaultFontWidth;
      str_start = (w - str_width) / 2;
      graph_start = 2 * defaultFontWidth;
   }
   button_start = (w - button_widths) / 2;
   h = (8 + ITEM_DSPED) * ROW_HEIGHT;

   win_x = (w > dsp_w) ? 0 : (dsp_w - w)/2;
   win_y = (h > dsp_h) ? 0 : (dsp_h - h)/3;

   if ((nameBaseWin = XCreateSimpleWindow (mainDisplay, rootWindow,
         win_x, win_y, w, h, brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create desired popup window!\n"); /* fool safe */ EmergencySave (); }

   XDefineCursor (mainDisplay, nameBaseWin, defaultCursor);

   if ((nameDspWin = XCreateSimpleWindow (mainDisplay, nameBaseWin, graph_start,
         5*ROW_HEIGHT, nameDspW, nameDspH, brdrW, myBorderPixel,
         myBgPixel)) == 0)
   { printf ("Could not create desired popup window!\n"); /* fool safe */ EmergencySave (); }

   if ((nameScrollWin = XCreateSimpleWindow (mainDisplay, nameBaseWin,
         graph_start+nameDspWinW, 5*ROW_HEIGHT, scrollBarW, nameDspH,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create desired popup scroll window!\n"); /* fool safe */ EmergencySave (); }

   win_attrs.save_under = True;
   XChangeWindowAttributes (mainDisplay, nameBaseWin, CWSaveUnder, &win_attrs);

   XSetTransientForHint (mainDisplay, nameBaseWin, mainWindow);

   XMapWindow (mainDisplay, nameBaseWin);
   XSelectInput (mainDisplay, nameBaseWin,
         KeyPressMask | ButtonPressMask | ExposureMask);

   XMapWindow (mainDisplay, nameDspWin);
   XSelectInput (mainDisplay, nameDspWin,
         KeyPressMask | ButtonPressMask | ExposureMask);

   XMapWindow (mainDisplay, nameScrollWin);
   XSelectInput (mainDisplay, nameScrollWin,
         KeyPressMask | ButtonPressMask | ExposureMask);

   if (importingFile)
      strcpy (dir_name, curImportDir);
   else
      strcpy (dir_name, curDir);

   dsp_ptr = topOfDirLinkList;
   for ( ; dsp_ptr != NULL; dsp_ptr = dsp_ptr->next) cfree (dsp_ptr);
   topOfDirLinkList = NULL;

   Msg ("Generating list of file names, please wait ...");
   if ((topOfDirLinkList = DirListing (dir_name, ExtStr)) == NULL)
   {
      *sel_str = '\0';
      looping = FALSE;
   }

   justClicked = FALSE;
   *saved_dir_name = '\0';
   faking_dot_dot = FALSE;
   while (looping)
   {
      nameEntries = numDirEntries;
      if (topOfDirLinkList == NULL)
         nameDspPtr = MakeNameDspItemArray (nameEntries, dirList);
      else
         nameDspPtr = MakeNameDspItemArray (nameEntries, topOfDirLinkList);
      nameFirst = 0;
      nameMarked = 0;

      if (faking_dot_dot)
      {
         name_index = strlen (saved_name);
         for (i = 0; i < nameEntries; i++)
            if (strncmp (nameDspPtr[i], saved_name, name_index) == 0)
            {
               strcpy (name, saved_name);
               if (i >= ITEM_DSPED)
               {
                  if (i < nameEntries-ITEM_DSPED)
                     nameFirst = i;
                  else
                     nameFirst = nameEntries-ITEM_DSPED;
               }
               nameMarked = i;
               break;
            }

         if (i == nameEntries)
         {
            name[0] = '\0';
            name_index = 0;
         }
      }
      else
      {
         name[0] = '\0';
         name_index = 0;
      }

      sprintf (full_name, "%s/%s", dir_name, name);

      if (exposure >= 3)
      {
         XClearWindow (mainDisplay, nameBaseWin);
         XClearWindow (mainDisplay, nameDspWin);
         XClearWindow (mainDisplay, nameScrollWin);
         RedrawNameBaseWindow (TopStr, full_name, str_start, graph_start,
               button_start, w, h);
         RedrawNameScrollWin ();
         RedrawDspWindow ();
      }

      changing = TRUE;
      change_to_root = FALSE;
      pop_from_root = FALSE;
      faking_dot_dot = FALSE;
      while (changing)
      {
         XNextEvent (mainDisplay, &input);
         if (input.type == Expose)
         {
            if (input.xany.window == nameBaseWin)
            {
               RedrawNameBaseWindow (TopStr, full_name, str_start, graph_start,
                     button_start, w, h);
               exposure++;
            }
            else if (input.xany.window == nameScrollWin)
            {
               RedrawNameScrollWin ();
               exposure++;
            }
            else if (input.xany.window == nameDspWin)
            {
               RedrawDspWindow ();
               exposure++;
            }

            continue;
         }
         else if (input.type == KeyPress)
         {
            key_ev = &(input.xkey);
            XLookupString (key_ev, buf, 80, &key_sym, &c_stat);

            if ((buf[0]=='\r' && (key_sym & 0xff)=='\r') ||
                (buf[0]=='\n' && (key_sym & 0xff)=='\n'))
            {
               changing = FALSE;
               index = nameMarked;
               button_selected = BUTTON_OK;
            }
            else if (buf[0]=='\033' && (key_sym & 0xff)=='\033')
            {
               looping = FALSE;
               changing = FALSE;
               index = INVALID;
               button_selected = BUTTON_CANCEL;
            }
            else if ((buf[0]=='\b' && (key_sym & 0xff)=='\b') ||
                  (buf[0]=='\b' && (key_sym & 0xff)=='h') ||
                  (buf[0]=='\177' && (key_sym & 0x7f)=='\177'))
            {
               if (name_index != 0)
               {
                  name[--name_index] = '\0';

                  sprintf (full_name, "%s/%s", dir_name, name);

                  for (i = 0; i < nameEntries; i++)
                     if (strncmp (nameDspPtr[i], name, name_index) == 0)
                        break;

                  if (i < nameEntries)
                  {
                     if (i < nameFirst)
                        nameFirst = i;
                     else if (i >= nameFirst+ITEM_DSPED)
                     {
                        if (i < nameEntries-ITEM_DSPED)
                           nameFirst = i;
                        else
                           nameFirst = nameEntries-ITEM_DSPED;
                     }
                     nameMarked = i;
                     RedrawNamePath (full_name, graph_start,
                           3*ROW_HEIGHT+defaultFontAsc+2);
                     RedrawNameScrollWin ();
                     RedrawDspWindow ();
                  }
               }
               else if (*dir_name == '\0' && *saved_dir_name != '\0')
               {
                  changing = FALSE;
                  pop_from_root = TRUE;
                  index = INVALID;
                  break;
               }
               else
               {  /* fake as if "../" is selected */
                  strcpy (name, "../");
                  name_index = strlen (name);
                  for (i = 0; i < nameEntries; i++)
                     if (strncmp (nameDspPtr[i], name, name_index) == 0)
                        break;
                  if (i != nameEntries)
                  {
                     changing = FALSE;
                     faking_dot_dot = TRUE;
                     index = nameMarked = i;
                  }
               }
            }
            else if (key_sym>='\040' && key_sym<='\177')
            {
               if (buf[0] == '$')
               {
                  i = (nameEntries == 0) ? 0 : nameEntries-1;
                  strcpy (name, nameDspPtr[i]);
               }
               else if (name_index == 0 && buf[0] == '/')
               {
                  if (*saved_dir_name == '\0')
                     strcpy (saved_dir_name, dir_name);
                  changing = FALSE;
                  change_to_root = TRUE;
                  index = INVALID;
                  break;
               }
               else
               {
                  name[name_index++] = buf[0];
                  name[name_index] = '\0';
                  for (i = 0; i < nameEntries; i++)
                     if (strncmp (nameDspPtr[i], name, name_index) == 0)
                        break;
               }

               if (i < nameEntries)
               {
                  if (buf[0] == '/')
                  {
                     changing = FALSE;
                     index = nameMarked = i;
                  }
                  else
                  {
                     if (i < nameFirst)
                        nameFirst = i;
                     else if (i >= nameFirst+ITEM_DSPED)
                     {
                        if (i < nameEntries-ITEM_DSPED)
                           nameFirst = i;
                        else
                           nameFirst = nameEntries-ITEM_DSPED;
                     }
                     nameMarked = i;

                     sprintf (full_name, "%s/%s", dir_name, name);

                     RedrawNamePath (full_name, graph_start,
                           3*ROW_HEIGHT+defaultFontAsc+2);
                     RedrawNameScrollWin ();
                     RedrawDspWindow ();
                  }
               }
               else
                  name[--name_index] = '\0';
            }
         }
         else if (input.type == ButtonPress)
         {
            button_ev = &(input.xbutton);
            if (button_ev->window == nameBaseWin)
            {
               if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[0]))
               {
                  changing = FALSE;
                  index = nameMarked;
                  button_selected = BUTTON_OK;
               }
               else if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[1]))
               {
                  looping = FALSE;
                  changing = FALSE;
                  index = INVALID;
                  button_selected = BUTTON_SETDIR;
               }
               else if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[2]))
               {
                  looping = FALSE;
                  changing = FALSE;
                  index = INVALID;
                  button_selected = BUTTON_CANCEL;
               }
            }
            else if (button_ev->window == nameScrollWin)
               NameScrollHandler (button_ev);
            else if (button_ev->window == nameDspWin)
            {
               if (NameDspHandler (button_ev) != INVALID)
               {
                  changing = FALSE;
                  index = nameMarked;
               }
               else if (nameMarked != INVALID)
               {
                  strcpy (name, nameDspPtr[nameMarked]);
                  sprintf (full_name, "%s/%s", dir_name, name);
                  RedrawNamePath (full_name, graph_start,
                        3*ROW_HEIGHT+defaultFontAsc+2);
               }
            }
         }
      }

      if (index != INVALID) strcpy (sel_str, nameDspPtr[index]);

      if (nameDspPtr != NULL)
      {
         cfree (*nameDspPtr);
         cfree (nameDspPtr);
      }

      if (index == INVALID && !change_to_root && !pop_from_root) break;

      if (change_to_root)
         *dir_name = '\0';
      else if (pop_from_root)
      {
         strcpy (dir_name, saved_dir_name);
         *saved_dir_name = '\0';
      }
      else if (sel_str[strlen(sel_str)-1] == '/')
      {
         sel_str[strlen(sel_str)-1] = '\0';
         if (strcmp (sel_str, "..") == 0)
         {
            for (i = strlen(dir_name)-1; i>=0 && dir_name[i]!='/'; i--) ;
            if (i < 0)
            {
               strcpy (saved_name, dir_name);
               dir_name[0] = '\0';
            }
            else
            {
               strcpy (saved_name, &dir_name[i+1]);
               dir_name[i] = '\0';
            }
         }
         else
         {
            strcat (dir_name, "/");
            strcat (dir_name, sel_str);
         }
      }
      else
         break;

      dsp_ptr = topOfDirLinkList;
      for ( ; dsp_ptr != NULL; dsp_ptr = dsp_ptr->next) cfree (dsp_ptr);
      topOfDirLinkList = NULL;

      Msg ("Generating list of file names, please wait ...");
      if ((topOfDirLinkList = DirListing (dir_name, ExtStr)) == NULL)
      {
         *sel_str = '\0';
         break;
      }
      if (importingFile)
         Msg ("Click on 'SETDIR' to set importing directory.");
      else
         Msg ("Click on 'SETDIR' to set current directory.");
   }

   DisplayButton (nameBaseWin, buttonStr[button_selected], 8,
         &buttonBBox[button_selected], BUTTON_INVERT);
   if (button_selected == BUTTON_SETDIR)
   {
      sprintf (SelStr, "%s", dir_name);
      *JustSetDir = TRUE;
   }
   else
   {
      sprintf (SelStr, "%s/%s", dir_name, sel_str);
      *JustSetDir = FALSE;
   }

   XDestroyWindow (mainDisplay, nameBaseWin);
   XSync (mainDisplay, FALSE);
   while (XCheckMaskEvent (mainDisplay, ExposureMask, &input)) ;
   return (index);
}

static
int ChooseAName (TopStr, SelStr)
   char	* TopStr, * SelStr;
{
   int			button_widths, str_width, graph_width;
   int			str_start, button_start, graph_start, index = 0;
   int			dsp_w, dsp_h, w, h, i, button_selected = INVALID;
   XEvent		input;
   int			changing = TRUE, name_index;
   char			buf[80], name[MAXPATHLENGTH];
   XKeyEvent		* key_ev;
   XButtonEvent		* button_ev;
   KeySym		key_sym;
   XComposeStatus	c_stat;
   XSetWindowAttributes	win_attrs;
   int			win_x, win_y;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   button_widths = ButtonWidth("OK", 8) + ButtonWidth("CANCEL", 8) +
         defaultFontWidth;
   numButtons = 2;
   strcpy (buttonStr[0], "OK");
   strcpy (buttonStr[1], "CANCEL");

   str_width = defaultFontWidth * strlen (TopStr);
   graph_width = nameDspWinW + scrollBarW + 2 * brdrW;

   if (str_width > graph_width)
   {
      w = str_width + 4 * defaultFontWidth;
      str_start = 2 * defaultFontWidth;
      graph_start = (w - graph_width) / 2;
   }
   else
   {
      w = graph_width + 4 * defaultFontWidth;
      str_start = (w - str_width) / 2;
      graph_start = 2 * defaultFontWidth;
   }
   button_start = (w - button_widths) / 2;
   h = (8 + ITEM_DSPED) * ROW_HEIGHT;

   win_x = (w > dsp_w) ? 0 : (dsp_w - w)/2;
   win_y = (h > dsp_h) ? 0 : (dsp_h - h)/3;

   if ((nameBaseWin = XCreateSimpleWindow (mainDisplay, rootWindow,
         win_x, win_y, w, h, brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create desired popup window!\n"); /* fool safe */ EmergencySave (); }

   XDefineCursor (mainDisplay, nameBaseWin, defaultCursor);

   if ((nameDspWin = XCreateSimpleWindow (mainDisplay, nameBaseWin, graph_start,
         5*ROW_HEIGHT, nameDspW, nameDspH, brdrW, myBorderPixel,
         myBgPixel)) == 0)
   { printf ("Could not create desired popup window!\n"); /* fool safe */ EmergencySave (); }

   if ((nameScrollWin = XCreateSimpleWindow (mainDisplay, nameBaseWin,
         graph_start+nameDspWinW, 5*ROW_HEIGHT, scrollBarW, nameDspH,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create desired popup scroll window!\n"); /* fool safe */ EmergencySave (); }

   win_attrs.save_under = True;
   XChangeWindowAttributes (mainDisplay, nameBaseWin, CWSaveUnder, &win_attrs);

   XSetTransientForHint (mainDisplay, nameBaseWin, mainWindow);

   XMapWindow (mainDisplay, nameBaseWin);
   XSelectInput (mainDisplay, nameBaseWin,
         KeyPressMask | ButtonPressMask | ExposureMask);

   XMapWindow (mainDisplay, nameDspWin);
   XSelectInput (mainDisplay, nameDspWin,
         KeyPressMask | ButtonPressMask | ExposureMask);

   XMapWindow (mainDisplay, nameScrollWin);
   XSelectInput (mainDisplay, nameScrollWin,
         KeyPressMask | ButtonPressMask | ExposureMask);

   justClicked = FALSE;

   Msg ("");

   name[0] = '\0';
   name_index = 0;
   nameMarked = INVALID;

   while (changing)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == Expose)
      {
         if (input.xany.window == nameBaseWin)
            RedrawNameBaseWindow (TopStr, name, str_start, graph_start,
                  button_start, w, h);
         else if (input.xany.window == nameScrollWin)
            RedrawNameScrollWin ();
         else if (input.xany.window == nameDspWin)
            RedrawDspWindow ();

         continue;
      }
      else if (input.type == KeyPress)
      {
         key_ev = &(input.xkey);
         XLookupString (key_ev, buf, 80, &key_sym, &c_stat);

         if ((buf[0]=='\r' && (key_sym & 0xff)=='\r') ||
             (buf[0]=='\n' && (key_sym & 0xff)=='\n'))
         {
            changing = FALSE;
            index = nameMarked;
            button_selected = BUTTON_OK;
         }
         else if (buf[0]=='\033' && (key_sym & 0xff)=='\033')
         {
            changing = FALSE;
            index = INVALID;
            button_selected = 1;
         }
         else if (buf[0] == '\b' || buf[0] == '\177')
         {
            if (name_index != 0)
            {
               name[--name_index] = '\0';
               for (i = 0; i < nameEntries; i++)
                  if (strncmp (nameDspPtr[i], name, name_index) == 0)
                     break;

               if (i < nameEntries)
               {
                  if (i < nameFirst)
                     nameFirst = i;
                  else if (i >= nameFirst+ITEM_DSPED)
                  {
                     if (i < nameEntries-ITEM_DSPED)
                        nameFirst = i;
                     else
                        nameFirst = nameEntries-ITEM_DSPED;
                  }
                  nameMarked = i;
                  RedrawNamePath (name, graph_start,
                        3*ROW_HEIGHT+defaultFontAsc+2);
                  RedrawNameScrollWin ();
                  RedrawDspWindow ();
               }
            }
         }
         else if (key_sym>='\040' && key_sym<='\177')
         {
            if (buf[0] == '$')
            {
               i = (nameEntries == 0) ? 0 : nameEntries-1;
               strcpy (name, nameDspPtr[i]);
            }
            else
            {
               name[name_index++] = buf[0];
               name[name_index] = '\0';
               for (i = 0; i < nameEntries; i++)
                  if (strncmp (nameDspPtr[i], name, name_index) == 0)
                     break;
            }

            if (i < nameEntries)
            {
               if (i < nameFirst)
                  nameFirst = i;
               else if (i >= nameFirst+ITEM_DSPED)
               {
                  if (i < nameEntries-ITEM_DSPED)
                     nameFirst = i;
                  else
                     nameFirst = nameEntries-ITEM_DSPED;
               }
               nameMarked = i;

               RedrawNamePath (name, graph_start,
                     3*ROW_HEIGHT+defaultFontAsc+2);
               RedrawNameScrollWin ();
               RedrawDspWindow ();
            }
            else
               name[--name_index] = '\0';
         }
      }
      else if (input.type == ButtonPress)
      {
         button_ev = &(input.xbutton);
         if (button_ev->window == nameBaseWin)
         {
            if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[0]))
            {
               changing = FALSE;
               index = nameMarked;
               button_selected = BUTTON_OK;
            }
            else if (PointInBBox (button_ev->x, button_ev->y, buttonBBox[1]))
            {
               changing = FALSE;
               index = INVALID;
               button_selected = 1;
            }
         }
         else if (button_ev->window == nameScrollWin)
            NameScrollHandler (button_ev);
         else if (button_ev->window == nameDspWin)
         {
            if (NameDspHandler (button_ev) != INVALID)
            {
               changing = FALSE;
               index = nameMarked;
            }
            else if (nameMarked != INVALID)
            {
               strcpy (name, nameDspPtr[nameMarked]);
               name_index = strlen (name);
               RedrawNamePath (name, graph_start,
                     3*ROW_HEIGHT+defaultFontAsc+2);
            }
         }
      }
   }

   DisplayButton (nameBaseWin, buttonStr[button_selected], 8,
         &buttonBBox[button_selected], BUTTON_INVERT);

   XDestroyWindow (mainDisplay, nameBaseWin);
   XSync (mainDisplay, FALSE);
   while (XCheckMaskEvent (mainDisplay, ExposureMask, &input)) ;
   return (index);
}

int SelectFileName (MsgStr, SelStr)
   char	* MsgStr, * SelStr;
{
   int		index = INVALID, saved_num_dir_entries, just_set_dir;
   DspList	* dsp_ptr;
   char		saved_cur_dir[MAXPATHLENGTH];

   strcpy (saved_cur_dir, curDir);
   saved_num_dir_entries = numDirEntries;
   if ((index = DirNames (MsgStr, "obj", SelStr, &just_set_dir)) == INVALID)
   {
      if (just_set_dir)
      {
         strcpy (curDir, SelStr);
         BuildDirList ();
         if (strcmp (saved_cur_dir, curDir) != 0 && DirInSymPath ("."))
            UpdateSymInfo ();
         RedrawTitleWindow ();
         Msg ("");
      }
      else
      {
         numDirEntries = saved_num_dir_entries;
         dsp_ptr = topOfDirLinkList;
         for ( ; dsp_ptr != NULL; dsp_ptr = dsp_ptr->next) cfree (dsp_ptr);
         topOfDirLinkList = NULL;
      }
      *SelStr = '\0';
      return (INVALID);
   }
   BuildDirList ();
   Msg ("");
   return (index);
}

int SelectFileNameToImport (MsgStr, ExtStr, SelStr)
   char	* MsgStr, * ExtStr, * SelStr;
{
   int		index = INVALID, saved_num_dir_entries, just_set_dir;
   DspList	* dsp_ptr;
   char		msg[MAXPATHLENGTH];

   saved_num_dir_entries = numDirEntries;
   if ((index = DirNames (MsgStr, ExtStr, SelStr, &just_set_dir)) == INVALID)
   {
      if (just_set_dir)
      {
         strcpy (curImportDir, SelStr);
         sprintf (msg, "Changing importing directory to %s.", curImportDir);
      }
      *SelStr = '\0';
   }
   else
      Msg ("");

   numDirEntries = saved_num_dir_entries;
   dsp_ptr = topOfDirLinkList;
   for ( ; dsp_ptr != NULL; dsp_ptr = dsp_ptr->next) cfree (dsp_ptr);
   topOfDirLinkList = NULL;

   return (index);
}

int SelectSymbolName (SelSymName, PathName)
   char	* SelSymName, * PathName;
{
   register int	index = INVALID;
   char		s[MAXPATHLENGTH], msg[MAXSTRING];

   sprintf (s,
         "Generating a list of symbol names in '%s' domain, please wait ...",
         curDomainName);
   Msg (s);

   nameEntries = numSymbols;
   nameDspPtr = MakeNameDspItemArray (nameEntries, symbolList);
   nameFirst = 0;
   nameMarked = 0;

   sprintf (msg, "Please select a symbol to INSTANTIATE in the '%s' domain ...",
         curDomainName);
   if ((index = ChooseAName (msg, SelSymName)) == INVALID)
   {
      *SelSymName = '\0';
      *PathName = '\0';
   }
   else
   {
      strcpy (SelSymName, nameDspPtr[index]);
      strcpy (PathName, symbolList[index].pathstr);
   }
   if (nameDspPtr != NULL)
   {
      cfree (*nameDspPtr);
      cfree (nameDspPtr);
   }

   Msg ("");
   return (index);
}

int GetSymbolPath (SymName, PathName)
   char	* SymName, * PathName;
{
   register int	i;

   for (i = 0; i < numSymbols; i++)
      if (strcmp (SymName, symbolList[i].itemstr) == 0)
      {
         strcpy (PathName, symbolList[i].pathstr);
         return (TRUE);
      }
   return (FALSE);
}

int NameInCurDir (FileName)
   char	* FileName;
{
   register int	i;

   for (i = 0; i < numDirEntries; i++)
      if (dirList[i].directory && strcmp (FileName, dirList[i].itemstr) == 0)
         return (TRUE);

   return (FALSE);
}

int DirInSymPath (DirName)
   char	* DirName;
{
   register int	i;

   for (i = 0; i < symPathNumEntries; i++)
      if (strcmp (DirName, symPath[i]) == 0)
         return (TRUE);

   return (FALSE);
}

static
DspList * DomainListing (Entries)
   int	* Entries;
{
   register int	i;
   char		s[MAXSTRING], * c_ptr;
   DspList	* dsp_ptr = NULL, * head_ptr, * tail_ptr, * p, * p1;

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "MaxDomains")) == NULL)
      return (NULL);

   *Entries = atoi (c_ptr);

   head_ptr = tail_ptr = NULL;
   for (i = 0; i < *Entries; i++)
   {
      sprintf (s, "Domain%1d", i);
      if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, s)) == NULL)
      {
         for ( ; head_ptr != NULL; head_ptr = head_ptr->next) cfree (head_ptr);
         return (NULL);
      }

      dsp_ptr = (DspList *) calloc (1, sizeof(DspList));
      strcpy (dsp_ptr->itemstr, c_ptr);
      if (head_ptr == NULL)
         head_ptr = tail_ptr = dsp_ptr;
      else
      {
         p1 = NULL;
         for (p = head_ptr; p != NULL; p = p->next)
            if (LargerStr (dsp_ptr->itemstr, p->itemstr))
               p1 = p;
            else
               break;

         dsp_ptr->next = p;
         if (p == NULL)
         {  /* dsp_ptr has the largest element */
            tail_ptr->next = dsp_ptr;
            tail_ptr = dsp_ptr;
         }
         else if (p1 == NULL)
            head_ptr = dsp_ptr;
         else
            p1->next = dsp_ptr;
      }
   }
   return (head_ptr);
}

int SelectDomain (SelStr)
   char	* SelStr;
{
   int		index;
   char		s[MAXPATHLENGTH];
   DspList	* dsp_ptr;

   Msg ("Generating list of domain names, please wait ...");

   if ((dsp_ptr = DomainListing (&nameEntries)) == NULL)
   {
      Msg ("No domain names found.");
      *SelStr = '\0';
      return (INVALID);
   }

   nameDspPtr = MakeNameDspItemArray (nameEntries, dsp_ptr);
   nameFirst = 0;
   nameMarked = 0;

   if ((index = ChooseAName ("Please select a new DOMAIN ...", "")) == INVALID)
      *SelStr = '\0';
   else
      strcpy (SelStr, nameDspPtr[index]);

   for ( ; dsp_ptr != NULL; dsp_ptr = dsp_ptr->next) cfree (dsp_ptr);
   if (nameDspPtr != NULL)
   {
      cfree (*nameDspPtr);
      cfree (nameDspPtr);
   }

   s[0] = '\0';
   Msg (s);

   return (index);
}

void SetCurDir (FileName)
   char	* FileName;
{
   register int	i;
   char		file_name[MAXPATHLENGTH];

   strcpy (file_name, FileName);

   for (i = strlen(file_name)-1; i>=0 && file_name[i]!='/'; i--) ;

   if (i < 0)
   {
      TwoLineMsg ("Error:  No '/' found in SetCurDir ().",
                  "        curDir set to '.'.");
      strcpy (curDir, ".");
      strcpy (curFileName, FileName);
   }
   else
   {
      strcpy (curFileName, &file_name[i+1]);
      file_name[i] = '\0';
      strcpy (curDir, file_name);
   }
}
