/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/obj.c,v 2.0 91/03/05 12:47:46 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "arc.e"
#include "attr.e"
#include "box.e"
#include "group.e"
#include "oval.e"
#include "poly.e"
#include "polygon.e"
#include "rcbox.e"
#include "setup.e"
#include "spline.e"
#include "text.e"
#include "xbitmap.e"

struct ObjRec	* topObj = NULL, * botObj = NULL;

void AddObj (PrevPtr, NextPtr, ObjPtr)
   struct ObjRec	* PrevPtr, * NextPtr, * ObjPtr;
   /* add ObjPtr between PrevPtr and NextPtr */
{
   ObjPtr->prev = PrevPtr;
   ObjPtr->next = NextPtr;

   if (PrevPtr == NULL)
      topObj = ObjPtr;
   else
      PrevPtr->next = ObjPtr;

   if (NextPtr == NULL)
      botObj = ObjPtr;
   else
      NextPtr->prev = ObjPtr;
}

void UnlinkObj (ObjPtr)
   struct ObjRec	*ObjPtr;
{
   if (topObj == ObjPtr)
      topObj = ObjPtr->next;
   else
      ObjPtr->prev->next = ObjPtr->next;

   if (botObj == ObjPtr)
      botObj = ObjPtr->prev;
   else
      ObjPtr->next->prev = ObjPtr->prev;
}

void FreeObj (ObjPtr)
   register struct ObjRec	* ObjPtr;
{
   switch (ObjPtr->type)
   {
      case OBJ_POLY: DelAllAttrs(ObjPtr->fattr); FreePolyObj (ObjPtr); break;
      case OBJ_BOX: DelAllAttrs(ObjPtr->fattr); FreeBoxObj (ObjPtr); break;
      case OBJ_OVAL: DelAllAttrs(ObjPtr->fattr); FreeOvalObj (ObjPtr); break;
      case OBJ_TEXT: FreeTextObj (ObjPtr); break;
      case OBJ_POLYGON: DelAllAttrs(ObjPtr->fattr); FreePolygonObj (ObjPtr);
         break;
      case OBJ_ARC: DelAllAttrs(ObjPtr->fattr); FreeArcObj (ObjPtr); break;
      case OBJ_RCBOX: DelAllAttrs(ObjPtr->fattr); FreeRCBoxObj (ObjPtr); break;
      case OBJ_XBM: DelAllAttrs(ObjPtr->fattr); FreeXBmObj (ObjPtr); break;
      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP: DelAllAttrs(ObjPtr->fattr); FreeGroupObj (ObjPtr); break;
   }
}

void DelObj (ObjPtr)
   struct ObjRec	*ObjPtr;
{
   if (topObj == ObjPtr)
      topObj = ObjPtr->next;
   else
      ObjPtr->prev->next = ObjPtr->next;

   if (botObj == ObjPtr)
      botObj = ObjPtr->prev;
   else
      ObjPtr->next->prev = ObjPtr->prev;

   FreeObj (ObjPtr);
}

void DelAllObj ()
{
   register struct ObjRec	* ptr;

   if (topObj == NULL) return;

   for (ptr = topObj; ptr != NULL; ptr = ptr->next)
      FreeObj (ptr);

   topObj = botObj = NULL;
}

void AdjObjBBox (ObjPtr)
   struct ObjRec        * ObjPtr;
{
   register int			w = 0;
   register struct ObjRec	* obj_ptr;
   register struct AttrRec	* attr_ptr;
   int				ltx, lty, rbx, rby;
   int				oltx, olty, orbx, orby;

   switch (ObjPtr->type)
   {
      case OBJ_POLY: w = arrowHeadH[ObjPtr->detail.p->width]; break;
      case OBJ_POLYGON: w = widthOfLine[ObjPtr->detail.g->width]; break;
      case OBJ_BOX: w = widthOfLine[ObjPtr->detail.b->width]; break;
      case OBJ_OVAL: w = widthOfLine[ObjPtr->detail.o->width]; break;
      case OBJ_ARC: w = widthOfLine[ObjPtr->detail.a->width]; break;
      case OBJ_RCBOX: w = widthOfLine[ObjPtr->detail.rcb->width]; break;
      case OBJ_XBM: break;

      case OBJ_SYM:
      case OBJ_GROUP:
      case OBJ_ICON:
         obj_ptr = ObjPtr->detail.r->last;
         ltx = obj_ptr->bbox.ltx; lty = obj_ptr->bbox.lty;
         rbx = obj_ptr->bbox.rbx; rby = obj_ptr->bbox.rby;
         oltx = obj_ptr->obbox.ltx; olty = obj_ptr->obbox.lty;
         orbx = obj_ptr->obbox.rbx; orby = obj_ptr->obbox.rby;
         for (obj_ptr = obj_ptr->prev; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
         {
            if (obj_ptr->bbox.ltx < ltx) ltx = obj_ptr->bbox.ltx;
            if (obj_ptr->bbox.lty < lty) lty = obj_ptr->bbox.lty;
            if (obj_ptr->bbox.rbx > rbx) rbx = obj_ptr->bbox.rbx;
            if (obj_ptr->bbox.rby > rby) rby = obj_ptr->bbox.rby;
            if (obj_ptr->obbox.ltx < oltx) oltx = obj_ptr->obbox.ltx;
            if (obj_ptr->obbox.lty < olty) olty = obj_ptr->obbox.lty;
            if (obj_ptr->obbox.rbx > orbx) orbx = obj_ptr->obbox.rbx;
            if (obj_ptr->obbox.rby > orby) orby = obj_ptr->obbox.rby;
         }
         ObjPtr->bbox.ltx = ltx; ObjPtr->bbox.lty = lty;
         ObjPtr->bbox.rbx = rbx; ObjPtr->bbox.rby = rby;
         ObjPtr->obbox.ltx = oltx; ObjPtr->obbox.lty = olty;
         ObjPtr->obbox.rbx = orbx; ObjPtr->obbox.rby = orby;
         break;
   }
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
      case OBJ_POLYGON:
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_ARC:
      case OBJ_RCBOX:
      case OBJ_XBM:
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - w;
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - w;
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + w;
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + w;
         break;
      case OBJ_TEXT:
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - 2;
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - 2;
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + 2;
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + 2;
         break;
   }

   attr_ptr = ObjPtr->fattr;

   ltx = ObjPtr->bbox.ltx;
   lty = ObjPtr->bbox.lty;
   rbx = ObjPtr->bbox.rbx;
   rby = ObjPtr->bbox.rby;
   for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
   {
      if (attr_ptr->shown)
      {
         if (attr_ptr->obj->bbox.ltx < ltx) ltx = attr_ptr->obj->bbox.ltx;
         if (attr_ptr->obj->bbox.lty < lty) lty = attr_ptr->obj->bbox.lty;
         if (attr_ptr->obj->bbox.rbx > rbx) rbx = attr_ptr->obj->bbox.rbx;
         if (attr_ptr->obj->bbox.rby > rby) rby = attr_ptr->obj->bbox.rby;
      }
   }
   ObjPtr->bbox.ltx = ltx;
   ObjPtr->bbox.lty = lty;
   ObjPtr->bbox.rbx = rbx;
   ObjPtr->bbox.rby = rby;

   if (ObjPtr->type == OBJ_SYM)
   {
      if (ObjPtr->obbox.ltx-QUARTER_INCH < ObjPtr->bbox.ltx)
         ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - QUARTER_INCH;
      if (ObjPtr->obbox.lty-QUARTER_INCH < ObjPtr->bbox.lty)
         ObjPtr->bbox.lty = ObjPtr->obbox.lty - QUARTER_INCH;
      if (ObjPtr->obbox.rbx+QUARTER_INCH > ObjPtr->bbox.rbx)
         ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + QUARTER_INCH;
      if (ObjPtr->obbox.rby+QUARTER_INCH > ObjPtr->bbox.rby)
         ObjPtr->bbox.rby = ObjPtr->obbox.rby + QUARTER_INCH;
   }
}

static
void AdjObjSplineVs (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register struct ObjRec	* ptr;

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         if (ObjPtr->detail.p->curved)
         {
            cfree (ObjPtr->detail.p->svlist);
            ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
                  &(ObjPtr->detail.p->sn), drawOrigX, drawOrigY,
                  ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
         }
         break;
      case OBJ_POLYGON:
         if (ObjPtr->detail.g->curved)
         {
            cfree (ObjPtr->detail.g->svlist);
            ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
                  &(ObjPtr->detail.g->sn), drawOrigX, drawOrigY,
                  ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
         }
         break;
      case OBJ_SYM:
      case OBJ_ICON:
      case OBJ_GROUP:
         for (ptr = ObjPtr->detail.r->first; ptr != NULL; ptr = ptr->next)
            AdjObjSplineVs (ptr);
         break;
   }
}

void AdjSplineVs ()
{
   register struct ObjRec	* obj_ptr, * ptr;

   if (topObj == NULL) return;

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
         case OBJ_POLYGON:
            AdjObjSplineVs (obj_ptr);
            break;
         case OBJ_SYM:
         case OBJ_ICON:
         case OBJ_GROUP:
            for (ptr = obj_ptr->detail.r->first; ptr != NULL; ptr = ptr->next)
               AdjObjSplineVs (ptr);
            break;
      }
}
