/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/oval.c,v 2.0 91/03/05 12:47:48 william Exp $";
#endif

#include <math.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "color.e"
#include "cursor.e"
#include "file.e"
#include "grid.e"
#include "obj.e"
#include "pattern.e"
#include "poly.e"
#include "raster.e"
#include "ruler.e"
#include "select.e"
#include "setup.e"
#ifdef UC
#include "showsize.e"
#endif /* UC */

int	ovalDrawn = FALSE;

#ifdef UC
extern void MyOval ();
#else /* UC */
void MyOval (window, gc, bbox)
   Window	window;
   GC		gc;
   struct BBRec	bbox;
{
   register int		ltx, lty, w, h;

   if (bbox.ltx > bbox.rbx)
   {
      ltx = bbox.rbx; w = bbox.ltx - ltx;
   }
   else
   {
      ltx = bbox.ltx; w = bbox.rbx - ltx;
   }

   if (bbox.lty > bbox.rby)
   {
      lty = bbox.rby; h = bbox.lty - lty;
   }
   else
   {
      lty = bbox.lty; h = bbox.rby - lty;
   }

   XDrawArc (mainDisplay, window, gc, ltx, lty, w, h, 0, 360*64);
}
#endif /* UC */
 
void DumpOvalObj (FP, ObjPtr)
   FILE			* FP;
   struct ObjRec	* ObjPtr;
{
   int	ltx, lty, rbx, rby, xc, yc, a, b, i;
   int	fill, width, pen, dash, color_index;

   ltx = ObjPtr->obbox.ltx; lty = ObjPtr->obbox.lty;
   rbx = ObjPtr->obbox.rbx; rby = ObjPtr->obbox.rby;
   a = (rbx - ltx) / 2; xc = ltx + a;
   b = (rby - lty) / 2; yc = lty + b;

   fill = ObjPtr->detail.o->fill;
   width = ObjPtr->detail.o->width;
   pen = ObjPtr->detail.o->pen;
   dash = ObjPtr->detail.o->dash;

   if (fill == NONEPAT && pen == NONEPAT) return;

   color_index = ObjPtr->color;
   if (colorDump)
      fprintf (FP, "%.3f %.3f %.3f setrgbcolor\n",
            ((float)tgifColors[color_index].red/maxRGB),
            ((float)tgifColors[color_index].green/maxRGB),
            ((float)tgifColors[color_index].blue/maxRGB));

   switch (fill)
   {
      case NONEPAT: break;
      case SOLIDPAT:
         /* solid black oval */
         fprintf (FP, "newpath %1d %1d %1d %1d ellipse fill\n", xc, yc, a, b);
         break;
      case BACKPAT:
         /* solid white oval */
         fprintf (FP, "newpath %1d %1d %1d %1d ellipse\n", xc, yc, a, b);
         fprintf (FP, "closepath 1 setgray fill\n");
         if (colorDump)
            fprintf (FP, "%.3f %.3f %.3f setrgbcolor\n",
                  ((float)tgifColors[color_index].red/maxRGB),
                  ((float)tgifColors[color_index].green/maxRGB),
                  ((float)tgifColors[color_index].blue/maxRGB));
         else
            fprintf (FP, "0 setgray\n");
         break;
      default:
         /* patterned */
         fprintf (FP, "gsave\n");
         if (colorDump)
         {
            fprintf (FP, "   newpath %1d %1d %1d %1d ellipse\n", xc, yc, a, b);
            fprintf (FP, "   closepath eoclip\n");
            DumpPatFill (FP, fill, 8, ObjPtr->bbox, "   ");
         }
         else
         {
            fprintf (FP, "   pat%1d 8 1 0 72 300 32 div div setpattern\n",fill);
            fprintf (FP, "   newpath %1d %1d %1d %1d ellipse fill\n",
                  xc, yc, a, b);
         }
         fprintf (FP, "grestore\n");
         break;
   }

   fprintf (FP, "%1d setlinewidth\n", widthOfLine[width]);
   if (dash != 0)
   {
      fprintf (FP, "[");
      for (i = 0; i < dashListLength[dash]-1; i++)
         fprintf (FP, "%1d ", (int)(dashList[dash][i]));
      fprintf (FP, "%1d] 0 setdash\n",
            (int)(dashList[dash][dashListLength[dash]-1]));
   }

   switch (pen)
   {
      case NONEPAT: break;
      case SOLIDPAT:
         fprintf (FP, "newpath %1d %1d %1d %1d ellipse stroke\n", xc, yc, a, b);
         break;
      case BACKPAT:
         fprintf (FP, "newpath %1d %1d %1d %1d ellipse\n", xc, yc, a, b);
         fprintf (FP, "closepath 1 setgray stroke 0 setgray\n");
         break;
      default:
         fprintf (FP, "gsave\n");
         if (colorDump)
         {
            fprintf (FP, "   newpath %1d %1d %1d %1d ellipse\n", xc, yc, a, b);
            fprintf (FP, "   strokepath clip\n");
            DumpPatFill (FP, pen, 8, ObjPtr->bbox, "   ");
         }
         else
         {
            fprintf (FP, "   pat%1d 8 1 0 72 300 32 div div setpattern\n", pen);
            fprintf (FP, "   newpath %1d %1d %1d %1d ellipse stroke\n",
                  xc, yc, a, b);
         }
         fprintf (FP, "grestore\n");
         break;
   }
   if (dash != 0) fprintf (FP, "[] 0 setdash\n");
   fprintf (FP, "1 setlinewidth\n\n");
}
 
void DrawOvalObj (window, XOff, YOff, ObjPtr)
   Window		window;
   int			XOff, YOff;
   struct ObjRec	* ObjPtr;
{
   int			fill, width, pen, dash, pixel, real_x_off, real_y_off;
   struct BBRec		bbox;
   XGCValues		values;

#ifndef UC
   real_x_off = (XOff >> zoomScale) << zoomScale;
   real_y_off = (YOff >> zoomScale) << zoomScale;
   bbox.ltx = (ObjPtr->obbox.ltx - real_x_off) >> zoomScale;
   bbox.lty = (ObjPtr->obbox.lty - real_y_off) >> zoomScale;
   bbox.rbx = (ObjPtr->obbox.rbx - real_x_off) >> zoomScale;
   bbox.rby = (ObjPtr->obbox.rby - real_y_off) >> zoomScale;
#else /* UC */
   real_x_off = RealSize((ScreenSize(XOff,  zoomScale)),  zoomScale);
   real_y_off = RealSize((ScreenSize(YOff,  zoomScale)),  zoomScale);
   bbox.ltx = ScreenSize((ObjPtr->obbox.ltx - real_x_off),  zoomScale);
   bbox.lty = ScreenSize((ObjPtr->obbox.lty - real_y_off),  zoomScale);
   bbox.rbx = ScreenSize((ObjPtr->obbox.rbx - real_x_off),  zoomScale);
   bbox.rby = ScreenSize((ObjPtr->obbox.rby - real_y_off),  zoomScale);
#endif /* UC */

   fill = ObjPtr->detail.o->fill;
   width = ObjPtr->detail.o->width;
   pen = ObjPtr->detail.o->pen;
   dash = ObjPtr->detail.o->dash;
   pixel = colorPixels[ObjPtr->color];

   if (fill != 0)
   {
      values.foreground = (fill == 2) ? myBgPixel : pixel;
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[fill];
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple, &values);
      XFillArc (mainDisplay, window, drawGC, bbox.ltx, bbox.lty,
            bbox.rbx-bbox.ltx, bbox.rby-bbox.lty, 0, 360*64);
   }
   if (pen != 0)
   {
      values.foreground = (pen == 2) ? myBgPixel : pixel;
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[pen];
#ifndef UC
      values.line_width = widthOfLine[width] >> zoomScale;
#else /* UC */
      values.line_width = ScreenSize(widthOfLine[width],  zoomScale);
#endif /* UC */
      if (dash != 0)
      {
         XSetDashes (mainDisplay, drawGC, 0, dashList[dash],
               dashListLength[dash]);
         values.line_style = LineOnOffDash;
      }
      else
         values.line_style = LineSolid;
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple | GCLineWidth |
            GCLineStyle, &values);
      XDrawArc (mainDisplay, window, drawGC, bbox.ltx, bbox.lty,
            bbox.rbx-bbox.ltx, bbox.rby-bbox.lty, 0, 360*64);
   }
}

static
void CreateOvalObj (BBox)
   struct BBRec	BBox;
{
   struct OvalRec	* oval_ptr;
   struct ObjRec	* obj_ptr;
   int			w;

   oval_ptr = (struct OvalRec *) calloc (1, sizeof(struct OvalRec));
   oval_ptr->fill = objFill;
   oval_ptr->width = lineWidth;
   oval_ptr->pen = penPat;
   oval_ptr->dash = curDash;

   obj_ptr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));

   obj_ptr->bbox.ltx = obj_ptr->obbox.ltx = obj_ptr->x =
#ifndef UC
         (BBox.ltx << zoomScale) + drawOrigX;
   obj_ptr->bbox.lty = obj_ptr->obbox.lty = obj_ptr->y =
         (BBox.lty << zoomScale) + drawOrigY;
   obj_ptr->bbox.rbx = obj_ptr->obbox.rbx = (BBox.rbx << zoomScale) + drawOrigX;
   obj_ptr->bbox.rby = obj_ptr->obbox.rby = (BBox.rby << zoomScale) + drawOrigY;
#else /* UC */
         (RealSize(BBox.ltx,  zoomScale)) + drawOrigX;
   obj_ptr->bbox.lty = obj_ptr->obbox.lty = obj_ptr->y =
         (RealSize(BBox.lty,  zoomScale)) + drawOrigY;
   obj_ptr->bbox.rbx = obj_ptr->obbox.rbx = (RealSize(BBox.rbx,  zoomScale)) + drawOrigX;
   obj_ptr->bbox.rby = obj_ptr->obbox.rby = (RealSize(BBox.rby,  zoomScale)) + drawOrigY;
#endif /* UC */
   w = widthOfLine[lineWidth];
   obj_ptr->bbox.ltx -= w;
   obj_ptr->bbox.lty -= w;
   obj_ptr->bbox.rbx += w;
   obj_ptr->bbox.rby += w;
   obj_ptr->type = OBJ_OVAL;
   obj_ptr->color = colorIndex;
   obj_ptr->id = objId++;
   obj_ptr->dirty = FALSE;
   obj_ptr->detail.o = oval_ptr;
   obj_ptr->fattr = obj_ptr->lattr = NULL;
   AddObj (NULL, topObj, obj_ptr);
}
 
static
void ContinueOval (OrigX, OrigY)
   int	OrigX, OrigY;
{
   int 		end_x, end_y, grid_x, grid_y;
   int 		done = FALSE;
   int		pixel, xor_pixel;
   struct BBRec	bbox;
   XGCValues	values;
   XEvent	input;
   XMotionEvent	* motion_ev;
#ifdef UC
   register int	showsize = showSize;
   register int hidedragcursor = hideDragCursor;
   register int cursordefined = FALSE;
#endif /* UC */

   bbox.ltx = bbox.rbx = OrigX;
   bbox.lty = bbox.rby = OrigY;

   pixel = colorPixels[colorIndex];
   xor_pixel = xorColorPixels[colorIndex];

   values.foreground = xor_pixel;
   values.function = GXxor;
   values.fill_style = FillSolid;
   values.line_width = 0;
   values.line_style = LineSolid;
   XChangeGC (mainDisplay, drawGC,
         GCForeground | GCFunction | GCFillStyle | GCLineWidth | GCLineStyle,
         &values);

   grid_x = end_x = OrigX;
   grid_y = end_y = OrigY; 
   XGrabPointer (mainDisplay, drawWindow, FALSE,
         PointerMotionMask | ButtonReleaseMask,
#ifndef UC
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
#else /* UC */
         GrabModeAsync, GrabModeAsync, None, ((hidedragcursor)? None: handCursor), CurrentTime);

#endif /* UC */
#ifdef UC
   if (showsize) showPoint (OrigX, OrigY, RIGHTUP);
#endif /* UC */
   
   while (!done)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonRelease)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         MyOval (drawWindow, drawGC, bbox);
#ifdef UC
	 if (showsize) eraseSizeString ();
	 if (hidedragcursor && cursordefined)
	 {
	     XDefineCursor (mainDisplay, drawWindow, drawCursor);
	     cursordefined = FALSE;
	     XFlush (mainDisplay);
	 }
#endif /* UC */
         done = TRUE;
      }
      else if (input.type == MotionNotify)
      {
         motion_ev = &(input.xmotion);
         end_x = motion_ev->x;
         end_y = motion_ev->y;
         GridXY (end_x, end_y, &grid_x, &grid_y);
#ifdef UC
	 if (hidedragcursor && !cursordefined &&
		(grid_x != OrigX && grid_y != OrigY))
	 {
	     XDefineCursor (mainDisplay, drawWindow, dragCursor);
	     cursordefined = TRUE;
	 }
#endif /* UC */
         if (grid_x != bbox.rbx || grid_y != bbox.rby)
         {
            MyOval (drawWindow, drawGC, bbox);
#ifdef UC
	    if (showsize) eraseSizeString ();
#endif /* UC */
            bbox.rbx = grid_x;
            bbox.rby = grid_y;
            MyOval (drawWindow, drawGC, bbox);
#ifdef UC
	    if (showsize) showHeightWidth (OrigX, OrigY, bbox.rbx, bbox.rby, RIGHTDOWN);
#endif /* UC */
         }
         MarkRulers (grid_x, grid_y);
      }
   }
   if (OrigX != grid_x && OrigY != grid_y)
   {
      if (bbox.ltx > bbox.rbx)
      {
         end_x = bbox.ltx; bbox.ltx = bbox.rbx; bbox.rbx = end_x;
      }
      if (bbox.lty > bbox.rby)
      {
         end_y = bbox.lty; bbox.lty = bbox.rby; bbox.rby = end_y;
      }
      CreateOvalObj (bbox);
      DrawOvalObj (drawWindow, drawOrigX, drawOrigY, topObj);
      ovalDrawn = TRUE;
      SetFileModified (TRUE);
   }
}

void DrawOval (input)
   XEvent	* input;
{
   XButtonEvent	* button_ev;
   int		mouse_x, mouse_y, grid_x, grid_y;

   if (input->type != ButtonPress) return;

   button_ev = &(input->xbutton);
   if (button_ev->button == Button1)
   {
      mouse_x = button_ev->x;
      mouse_y = button_ev->y;
      GridXY (mouse_x, mouse_y, &grid_x, &grid_y);
      ContinueOval (grid_x, grid_y);
   }
}

void SaveOvalObj (FP, ObjPtr)
   FILE			* FP;
   struct ObjRec	* ObjPtr;
{
   fprintf (FP, "oval('%s',", colorMenuItems[ObjPtr->color]);
   fprintf (FP, "%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,", ObjPtr->obbox.ltx,
         ObjPtr->obbox.lty, ObjPtr->obbox.rbx, ObjPtr->obbox.rby,
         ObjPtr->detail.o->fill, ObjPtr->detail.o->width,
         ObjPtr->detail.o->pen, ObjPtr->id, ObjPtr->detail.o->dash);
   SaveAttrs (FP, ObjPtr->lattr);
   fprintf (FP, ")");
}

void ReadOvalObj (Inbuf, ObjPtr)
   char			* Inbuf;
   struct ObjRec	* * ObjPtr;
{
   struct OvalRec	* oval_ptr;
   char			color_str[20], * s;
   int			ltx, lty, rbx, rby, fill, width, pen, dash, w;

   * ObjPtr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   s = FindChar ('(', Inbuf);
   s = ParseStr (s, ',', color_str);
   oval_ptr = (struct OvalRec *) calloc (1, sizeof(struct OvalRec));

   if (fileVersion <= 5)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d",
            &ltx, &lty, &rbx, &rby, &fill, &width, &pen);
      switch (width)
      {
         case 1: width = 3; break;
         case 2: width = 6; break;
      }
      (*ObjPtr)->id = objId++;
      dash = 0;
   }
   else if (fileVersion <= 7)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d",
            &ltx, &lty, &rbx, &rby, &fill, &width, &pen);
      (*ObjPtr)->id = objId++;
      dash = 0;
   }
   else if (fileVersion <= 8)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d , %d",
            &ltx, &lty, &rbx, &rby, &fill, &width, &pen, &((*ObjPtr)->id));
      if ((*ObjPtr)->id >= objId) objId = (*ObjPtr)->id + 1;
      dash = 0;
   }
   else
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d , %d , %d",
            &ltx, &lty, &rbx, &rby, &fill, &width, &pen, &((*ObjPtr)->id),
            &dash);
      if ((*ObjPtr)->id >= objId) objId = (*ObjPtr)->id + 1;
   }

   oval_ptr->fill = fill;
   oval_ptr->width = width;
   oval_ptr->pen = pen;
   oval_ptr->dash = dash;
   (*ObjPtr)->x = ltx;
   (*ObjPtr)->y = lty;
   (*ObjPtr)->color = FindColorIndex (color_str);
   (*ObjPtr)->dirty = FALSE;
   (*ObjPtr)->type = OBJ_OVAL;
   (*ObjPtr)->obbox.ltx = ltx;
   (*ObjPtr)->obbox.lty = lty;
   (*ObjPtr)->obbox.rbx = rbx;
   (*ObjPtr)->obbox.rby = rby;
   if (width == 0)
   {
      (*ObjPtr)->bbox.ltx = ltx;
      (*ObjPtr)->bbox.lty = lty;
      (*ObjPtr)->bbox.rbx = rbx;
      (*ObjPtr)->bbox.rby = rby;
   }
   else
   {
      w = widthOfLine[width];
      (*ObjPtr)->bbox.ltx = ltx - w;
      (*ObjPtr)->bbox.lty = lty - w;
      (*ObjPtr)->bbox.rbx = rbx + w;
      (*ObjPtr)->bbox.rby = rby + w;
   }
   (*ObjPtr)->detail.o = oval_ptr;
}

void FreeOvalObj (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   cfree (ObjPtr->detail.o);
   cfree (ObjPtr);
}

#ifdef UC
#undef XDrawArc
void MyOval (window, gc, bbox)
   Window	window;
   GC		gc;
   struct BBRec	bbox;
{
   register int		ltx, lty, w, h;

   if (bbox.ltx > bbox.rbx)
   {
      ltx = bbox.rbx; w = bbox.ltx - ltx;
   }
   else
   {
      ltx = bbox.ltx; w = bbox.rbx - ltx;
   }

   if (bbox.lty > bbox.rby)
   {
      lty = bbox.rby; h = bbox.lty - lty;
   }
   else
   {
      lty = bbox.lty; h = bbox.rby - lty;
   }

   XDrawArc (mainDisplay, window, gc, ltx, lty, w, h, 0, 360*64);
}
#endif /* UC */
