/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/pattern.c,v 2.0 91/03/05 12:47:50 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "arc.e"
#include "choice.e"
#include "drawing.e"
#include "mark.e"
#include "menu.e"
#include "obj.e"
#include "poly.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "spline.e"

int     objFill = NONEPAT;
int     lineStyle = LS_RIGHT;
int     lineWidth = 0;
int     penPat = SOLIDPAT;
int     curSpline = LT_STRAIGHT;
int     curDash = 0;

void ModeMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, *valid;

   DefaultColorArrays (MAXCHOICES, &fore_colors, &valid);
   cfree (valid);
   index = PxMpMenuLoop (X, Y, choiceImageW, choiceImageH, MAXCHOICES, 1,
#ifndef UC
         MAXCHOICES, fore_colors, choicePixmap, SINGLECOLOR);
#else /* UC */
         MAXCHOICES, fore_colors, choicePixmap, SINGLECOLOR, MENU_MODE);
#endif /* UC */

   if (index != INVALID) SetCurChoice (index);
}

static
int ChangeObjFill (ObjPtr, FillIndex)
   struct ObjRec	* ObjPtr;
   int			FillIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_BOX:
            if (obj_ptr->detail.b->fill != FillIndex)
            {
               obj_ptr->detail.b->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_OVAL:
            if (obj_ptr->detail.o->fill != FillIndex)
            {
               obj_ptr->detail.o->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_POLY:
            if (obj_ptr->detail.p->fill != FillIndex)
            {
               obj_ptr->detail.p->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_POLYGON:
            if (obj_ptr->detail.g->fill != FillIndex)
            {
               obj_ptr->detail.g->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_ARC:
            if (obj_ptr->detail.a->fill != FillIndex)
            {
               if (obj_ptr->detail.a->fill == NONEPAT || FillIndex == NONEPAT)
               {
                  obj_ptr->detail.a->fill = FillIndex;
                  UpdArcBBox (obj_ptr);
               }
               else
                  obj_ptr->detail.a->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_RCBOX:
            if (obj_ptr->detail.rcb->fill != FillIndex)
            {
               obj_ptr->detail.rcb->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_XBM:
            if (obj_ptr->detail.xbm->fill != FillIndex)
            {
               obj_ptr->detail.xbm->fill = FillIndex;
               changed = TRUE;
            }
            break;

         case OBJ_SYM:
         case OBJ_GROUP:
            if (ChangeObjFill (obj_ptr->detail.r->last, FillIndex))
               changed = TRUE;
            break;
      }
   return (changed);
}

void ChangeAllSelFill (FillIndex)
   int	FillIndex;
{
   register struct SelRec	* sel_ptr;
   int				changed = FALSE, ltx, lty, rbx, rby;

   if (topSel == NULL)
   {
      objFill = FillIndex;
      ShowFill ();
      return;
   }

   HighLightReverse ();
   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
      switch (sel_ptr->obj->type)
      {
         case OBJ_BOX:
            if (sel_ptr->obj->detail.b->fill != FillIndex)
            {
               sel_ptr->obj->detail.b->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_OVAL:
            if (sel_ptr->obj->detail.o->fill != FillIndex)
            {
               sel_ptr->obj->detail.o->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_POLY:
            if (sel_ptr->obj->detail.p->fill != FillIndex)
            {
               sel_ptr->obj->detail.p->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_POLYGON:
            if (sel_ptr->obj->detail.g->fill != FillIndex)
            {
               sel_ptr->obj->detail.g->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_ARC:
            if (sel_ptr->obj->detail.a->fill != FillIndex)
            {
               if (sel_ptr->obj->detail.a->fill==NONEPAT || FillIndex==NONEPAT)
               {
                  sel_ptr->obj->detail.a->fill = FillIndex;
                  UpdArcBBox (sel_ptr->obj);
               }
               else
                  sel_ptr->obj->detail.a->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_RCBOX:
            if (sel_ptr->obj->detail.rcb->fill != FillIndex)
            {
               sel_ptr->obj->detail.rcb->fill = FillIndex;
               changed = TRUE;
            }
            break;
         case OBJ_XBM:
            if (sel_ptr->obj->detail.xbm->fill != FillIndex)
            {
               sel_ptr->obj->detail.xbm->fill = FillIndex;
               changed = TRUE;
            }
            break;

         case OBJ_SYM:
         case OBJ_GROUP:
            if (ChangeObjFill (sel_ptr->obj->detail.r->last, FillIndex))
               changed = TRUE;
            break;
      }

   if (changed)
   {
      SetFileModified (TRUE);
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
            selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   }
   HighLightForward ();
}

void FillMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid;

   DefaultColorArrays (MAXPATTERNS, &fore_colors, &valid);
   cfree (valid);
   index = PxMpMenuLoop (X, Y, choiceImageW, choiceImageH, 4, 5, MAXPATTERNS,
#ifndef UC
         fore_colors, patPixmap, SINGLECOLOR);
#else /* UC */
         fore_colors, patPixmap, SINGLECOLOR, MENU_FILL);
#endif /* UC */

   if (index != INVALID) ChangeAllSelFill (index);
}

static
int ChangeObjLineStyle (ObjPtr, StyleIndex)
   struct ObjRec	* ObjPtr;
   int			StyleIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->style != StyleIndex)
            {
               obj_ptr->detail.p->style = StyleIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjLineStyle (obj_ptr->detail.r->last, StyleIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

void ChangeAllSelLineStyle (StyleIndex)
   int	StyleIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				ltx, lty, rbx, rby, changed = FALSE;

   if (topSel == NULL)
   {
      lineStyle = StyleIndex;
      ShowLineStyle ();
      return;
   }

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->style != StyleIndex)
            {
               obj_ptr->detail.p->style = StyleIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjLineStyle (obj_ptr->detail.r->last, StyleIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      SetFileModified (TRUE);
      HighLightReverse ();
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
            selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
}

static
int ChangeObjLineType (ObjPtr, TypeIndex)
   struct ObjRec	* ObjPtr;
   int			TypeIndex;
{
   register struct ObjRec       * obj_ptr;
   int				changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->curved != TypeIndex)
            {
               if ((obj_ptr->detail.p->curved = TypeIndex) == LT_SPLINE)
                  obj_ptr->detail.p->svlist = MakeSplinePolyVertex (
                        &(obj_ptr->detail.p->sn), drawOrigX, drawOrigY,
                        obj_ptr->detail.p->n, obj_ptr->detail.p->vlist);
               else
                  cfree (obj_ptr->detail.p->svlist);
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_POLYGON:
            if (obj_ptr->detail.g->curved != TypeIndex)
            {
               if ((obj_ptr->detail.g->curved = TypeIndex) == LT_SPLINE)
                  obj_ptr->detail.g->svlist = MakeSplinePolygonVertex (
                        &(obj_ptr->detail.g->sn), drawOrigX, drawOrigY,
                        obj_ptr->detail.g->n, obj_ptr->detail.g->vlist);
               else
                  cfree (obj_ptr->detail.g->svlist);
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjLineType (obj_ptr->detail.r->last, TypeIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

void ChangeAllSelLineType (TypeIndex)
   int	TypeIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				ltx, lty, rbx, rby, changed = FALSE;

   if (topSel == NULL)
   {
      curSpline = TypeIndex;
      ShowLineType ();
      return;
   }

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->curved != TypeIndex)
            {
               if ((obj_ptr->detail.p->curved = TypeIndex) == LT_SPLINE)
                  obj_ptr->detail.p->svlist = MakeSplinePolyVertex (
                        &(obj_ptr->detail.p->sn), drawOrigX, drawOrigY,
                        obj_ptr->detail.p->n, obj_ptr->detail.p->vlist);
               else
                  cfree (obj_ptr->detail.p->svlist);
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_POLYGON:
            if (obj_ptr->detail.g->curved != TypeIndex)
            {
               if ((obj_ptr->detail.g->curved = TypeIndex) == LT_SPLINE)
                  obj_ptr->detail.g->svlist = MakeSplinePolygonVertex (
                        &(obj_ptr->detail.g->sn), drawOrigX, drawOrigY,
                        obj_ptr->detail.g->n, obj_ptr->detail.g->vlist);
               else
                  cfree (obj_ptr->detail.g->svlist);
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjLineType (obj_ptr->detail.r->last, TypeIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      SetFileModified (TRUE);
      HighLightReverse ();
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
            selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
}

static
int ChangeObjLineWidth (ObjPtr, WidthIndex)
   struct ObjRec	* ObjPtr;
   int			WidthIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->width != WidthIndex)
            {
               obj_ptr->detail.p->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_BOX:
            if (obj_ptr->detail.b->width != WidthIndex)
            {
               obj_ptr->detail.b->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_OVAL:
            if (obj_ptr->detail.o->width != WidthIndex)
            {
               obj_ptr->detail.o->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_POLYGON:
            if (obj_ptr->detail.g->width != WidthIndex)
            {
               obj_ptr->detail.g->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_ARC:
            if (obj_ptr->detail.a->width != WidthIndex)
            {
               obj_ptr->detail.a->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_RCBOX:
            if (obj_ptr->detail.rcb->width != WidthIndex)
            {
               obj_ptr->detail.rcb->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjLineWidth (obj_ptr->detail.r->last, WidthIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

void ChangeAllSelLineWidth (WidthIndex)
   int	WidthIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				ltx, lty, rbx, rby, changed = FALSE;

   if (topSel == NULL)
   {
      lineWidth = WidthIndex;
      ShowLineWidth ();
      return;
   }

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->width != WidthIndex)
            {
               obj_ptr->detail.p->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_BOX:
            if (obj_ptr->detail.b->width != WidthIndex)
            {
               obj_ptr->detail.b->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_OVAL:
            if (obj_ptr->detail.o->width != WidthIndex)
            {
               obj_ptr->detail.o->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_POLYGON:
            if (obj_ptr->detail.g->width != WidthIndex)
            {
               obj_ptr->detail.g->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_ARC:
            if (obj_ptr->detail.a->width != WidthIndex)
            {
               obj_ptr->detail.a->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
         case OBJ_RCBOX:
            if (obj_ptr->detail.rcb->width != WidthIndex)
            {
               obj_ptr->detail.rcb->width = WidthIndex;
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjLineWidth (obj_ptr->detail.r->last, WidthIndex))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      SetFileModified (TRUE);
      HighLightReverse ();
      ltx = selLtX; lty = selLtY; rbx = selRbX; rby = selRbY;
      UpdSelBBox ();
#ifndef UC
      RedrawAreas (botObj, ltx-(1<<zoomScale), lty-(1<<zoomScale),
            rbx+(1<<zoomScale), rby+(1<<zoomScale), selLtX-(1<<zoomScale),
            selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
            selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
            rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)), selLtX-(RealSize(1, zoomScale)),
            selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
		   selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
}

static
int ChangeObjDashes (ObjPtr, DashIndex)
   struct ObjRec	* ObjPtr;
   int			DashIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->dash != DashIndex)
            {
               obj_ptr->detail.p->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_BOX:
            if (obj_ptr->detail.b->dash != DashIndex)
            {
               obj_ptr->detail.b->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_OVAL:
            if (obj_ptr->detail.o->dash != DashIndex)
            {
               obj_ptr->detail.o->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_POLYGON:
            if (obj_ptr->detail.g->dash != DashIndex)
            {
               obj_ptr->detail.g->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_ARC:
            if (obj_ptr->detail.a->dash != DashIndex)
            {
               obj_ptr->detail.a->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_RCBOX:
            if (obj_ptr->detail.rcb->dash != DashIndex)
            {
               obj_ptr->detail.rcb->dash = DashIndex;
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjLineWidth (obj_ptr->detail.r->last, DashIndex))
               changed = TRUE;
            break;
      }
   return (changed);
}

void ChangeAllSelDashes (DashIndex)
   int	DashIndex;
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE;

   if (topSel == NULL)
   {
      curDash = DashIndex;
      ShowLineWidth ();
      return;
   }

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->dash != DashIndex)
            {
               obj_ptr->detail.p->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_BOX:
            if (obj_ptr->detail.b->dash != DashIndex)
            {
               obj_ptr->detail.b->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_OVAL:
            if (obj_ptr->detail.o->dash != DashIndex)
            {
               obj_ptr->detail.o->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_POLYGON:
            if (obj_ptr->detail.g->dash != DashIndex)
            {
               obj_ptr->detail.g->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_ARC:
            if (obj_ptr->detail.a->dash != DashIndex)
            {
               obj_ptr->detail.a->dash = DashIndex;
               changed = TRUE;
            }
            break;
         case OBJ_RCBOX:
            if (obj_ptr->detail.rcb->dash != DashIndex)
            {
               obj_ptr->detail.rcb->dash = DashIndex;
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjDashes (obj_ptr->detail.r->last, DashIndex))
               changed = TRUE;
            break;
      }
   }

   if (changed)
   {
      SetFileModified (TRUE);
      HighLightReverse ();
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
}

void LineStyleMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid;

   DefaultColorArrays (MAXLINEWIDTHS+MAXLINETYPES+MAXDASHES+MAXLINESTYLES,
         &fore_colors, &valid);
   cfree (valid);
   index = PxMpMenuLoop (X, Y, menuImageW, menuImageH,
         MAXLINEWIDTHS+MAXLINETYPES+MAXDASHES+MAXLINESTYLES, 1,
         MAXLINEWIDTHS+MAXLINETYPES+MAXDASHES+MAXLINESTYLES,
#ifndef UC
         fore_colors, lineStylePixmap, SINGLECOLOR);
#else /* UC */
         fore_colors, lineStylePixmap, SINGLECOLOR, MENU_LINESTYLE);
#endif /* UC */
   if (index == INVALID) return;

   if (index < MAXLINEWIDTHS)
      ChangeAllSelLineWidth (index);
   else if (index < MAXLINEWIDTHS+MAXLINETYPES)
      ChangeAllSelLineType (index - MAXLINEWIDTHS);
   else if (index < MAXLINEWIDTHS+MAXLINETYPES+MAXDASHES)
      ChangeAllSelDashes (index - MAXLINEWIDTHS - MAXLINETYPES);
   else
      ChangeAllSelLineStyle (index - MAXLINEWIDTHS - MAXLINETYPES - MAXDASHES);
}

static
int ChangeObjPen (ObjPtr, PenIndex)
   struct ObjRec	* ObjPtr;
   int			PenIndex;
{
   register struct ObjRec	* obj_ptr;
   int				changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (obj_ptr->detail.p->pen != PenIndex)
            {
               obj_ptr->detail.p->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_TEXT:
            if (obj_ptr->detail.t->pen != PenIndex)
            {
               obj_ptr->detail.t->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_BOX:
            if (obj_ptr->detail.b->pen != PenIndex)
            {
               obj_ptr->detail.b->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_OVAL:
            if (obj_ptr->detail.o->pen != PenIndex)
            {
               obj_ptr->detail.o->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_POLYGON:
            if (obj_ptr->detail.g->pen != PenIndex)
            {
               obj_ptr->detail.g->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_ARC:
            if (obj_ptr->detail.a->pen != PenIndex)
            {
               obj_ptr->detail.a->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_RCBOX:
            if (obj_ptr->detail.rcb->pen != PenIndex)
            {
               obj_ptr->detail.rcb->pen = PenIndex;
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjPen (obj_ptr->detail.r->last, PenIndex))
               changed = TRUE;
            break;
      }
   return (changed);
}

void ChangeAllSelPen (PenIndex)
   int	PenIndex;
{
   register struct SelRec	* sel_ptr;
   int				changed = FALSE;

   if (topSel == NULL)
   {
      penPat = PenIndex;
      ShowPen ();
      return;
   }

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
      switch (sel_ptr->obj->type)
      {
         case OBJ_POLY:
            if (sel_ptr->obj->detail.p->pen != PenIndex)
            {
               sel_ptr->obj->detail.p->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_TEXT:
            if (sel_ptr->obj->detail.t->pen != PenIndex)
            {
               sel_ptr->obj->detail.t->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_BOX:
            if (sel_ptr->obj->detail.b->pen != PenIndex)
            {
               sel_ptr->obj->detail.b->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_OVAL:
            if (sel_ptr->obj->detail.o->pen != PenIndex)
            {
               sel_ptr->obj->detail.o->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_POLYGON:
            if (sel_ptr->obj->detail.g->pen != PenIndex)
            {
               sel_ptr->obj->detail.g->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_ARC:
            if (sel_ptr->obj->detail.a->pen != PenIndex)
            {
               sel_ptr->obj->detail.a->pen = PenIndex;
               changed = TRUE;
            }
            break;
         case OBJ_RCBOX:
            if (sel_ptr->obj->detail.rcb->pen != PenIndex)
            {
               sel_ptr->obj->detail.rcb->pen = PenIndex;
               changed = TRUE;
            }
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ChangeObjPen (sel_ptr->obj->detail.r->last, PenIndex))
               changed = TRUE;
            break;
      }

   if (changed)
   {
      SetFileModified (TRUE);
      HighLightReverse ();
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
}

void PenMenu (X, Y)
   int	X, Y;
{
   int		index, * fore_colors, * valid;

   DefaultColorArrays (MAXPATTERNS, &fore_colors, &valid);
   cfree (valid);
   index = PxMpMenuLoop (X, Y, choiceImageW, choiceImageH, 4, 5, MAXPATTERNS,
#ifndef UC
         fore_colors, patPixmap, SINGLECOLOR);
#else /* UC */
         fore_colors, patPixmap, SINGLECOLOR, MENU_PEN);
#endif /* UC */

   if (index != INVALID) ChangeAllSelPen (index);
}

static
int ToggleObjLineType (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register struct ObjRec       * obj_ptr;
   register int			changed = FALSE;

   for (obj_ptr = ObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            obj_ptr->detail.p->curved = !obj_ptr->detail.p->curved;
            if (obj_ptr->detail.p->curved == LT_SPLINE)
               obj_ptr->detail.p->svlist = MakeSplinePolyVertex (
                     &(obj_ptr->detail.p->sn), drawOrigX, drawOrigY,
                     obj_ptr->detail.p->n, obj_ptr->detail.p->vlist);
            else
               cfree (obj_ptr->detail.p->svlist);
            changed = TRUE;
            AdjObjBBox (obj_ptr);
            break;
         case OBJ_POLYGON:
            obj_ptr->detail.g->curved = !obj_ptr->detail.g->curved;
            if (obj_ptr->detail.g->curved == LT_SPLINE)
               obj_ptr->detail.g->svlist = MakeSplinePolygonVertex (
                     &(obj_ptr->detail.g->sn), drawOrigX, drawOrigY,
                     obj_ptr->detail.g->n, obj_ptr->detail.g->vlist);
            else
               cfree (obj_ptr->detail.g->svlist);
            changed = TRUE;
            AdjObjBBox (obj_ptr);
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ToggleObjLineType (obj_ptr->detail.r->last))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   return (changed);
}

void ToggleAllSelLineType ()
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;
   register int			changed = FALSE;

   if (topSel == NULL)
   {
      curSpline = !curSpline;
      ShowLineType ();
      return;
   }

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            obj_ptr->detail.p->curved = !(obj_ptr->detail.p->curved);
            if (obj_ptr->detail.p->curved == LT_SPLINE)
            obj_ptr->detail.p->svlist = MakeSplinePolyVertex (
                     &(obj_ptr->detail.p->sn), drawOrigX, drawOrigY,
                     obj_ptr->detail.p->n, obj_ptr->detail.p->vlist);
            else
               cfree (obj_ptr->detail.p->svlist);
            changed = TRUE;
            AdjObjBBox (obj_ptr);
            break;
         case OBJ_POLYGON:
            obj_ptr->detail.g->curved = !(obj_ptr->detail.g->curved);
            if (obj_ptr->detail.g->curved == LT_SPLINE)
               obj_ptr->detail.g->svlist = MakeSplinePolygonVertex (
                     &(obj_ptr->detail.g->sn), drawOrigX, drawOrigY,
                     obj_ptr->detail.g->n, obj_ptr->detail.g->vlist);
            else
               cfree (obj_ptr->detail.g->svlist);
            changed = TRUE;
            AdjObjBBox (obj_ptr);
            break;

         case OBJ_GROUP:
         case OBJ_SYM:
            if (ToggleObjLineType (obj_ptr->detail.r->last))
            {
               changed = TRUE;
               AdjObjBBox (obj_ptr);
            }
            break;
      }
   }

   if (changed)
   {
      SetFileModified (TRUE);
      HighLightReverse ();
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
}
