/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/prtgif.c,v 2.0 91/03/05 12:48:03 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "file.e"
#include "grid.e"
#include "obj.e"
#include "setup.e"
#ifdef KANJI
#include "file.e"
#endif /* KANJI */

#define PRTGIF (TRUE)

extern char	* getenv ();
/* extern int	malloc_debug (); */

int	lastFile = TRUE;

short   pDrawFontAsc[] =
{
    8, 10, 12, 14, 17, 22, 
    8, 10, 12, 14, 17, 22, 
    8, 10, 12, 14, 17, 23, 
    8, 10, 12, 14, 17, 22, 
    8,  9, 11, 13, 15, 19, 
    7,  9, 11, 12, 15, 20, 
    7,  9, 11, 13, 15, 19, 
    7,  9, 11, 12, 15, 20, 
    9, 11, 12, 14, 18, 24, 
    9, 11, 12, 14, 17, 24, 
    9, 11, 12, 14, 17, 24, 
    9, 11, 12, 14, 17, 24, 
    8, 11, 12, 14, 18, 23, 
    8, 11, 12, 15, 18, 24, 
    8, 11, 12, 14, 16, 23, 
    8, 11, 12, 14, 16, 24, 
    8, 10, 12, 14, 18, 24, 
    9, 14, 15, 18, 23, 30, 
   10, 14, 16, 17, 23, 30, 
    9, 13, 15, 17, 22, 30, 
    9, 13, 15, 18, 22, 30, 
    9, 12, 14, 15, 19, 26, 
    9, 12, 14, 15, 21, 26, 
    9, 12, 14, 15, 19, 26, 
    9, 12, 14, 15, 20, 26, 
   11, 14, 16, 18, 24, 31, 
   11, 14, 16, 18, 24, 31, 
   11, 14, 16, 18, 24, 31, 
   11, 14, 16, 18, 24, 31, 
   11, 14, 16, 19, 24, 32, 
   11, 15, 16, 19, 24, 33, 
   11, 14, 16, 18, 23, 32, 
   11, 15, 16, 19, 24, 32, 
   11, 12, 13, 14, 19, 27 
};

short   pDrawFontDes[] =
{
    2,  3,  3,  4,  4,  6, 
    2,  3,  3,  4,  4,  6, 
    2,  3,  3,  4,  5,  6, 
    2,  3,  3,  3,  4,  6, 
    2,  2,  3,  3,  4,  5, 
    2,  2,  3,  4,  5,  5, 
    2,  2,  3,  3,  4,  5, 
    2,  2,  3,  4,  5,  5, 
    2,  2,  3,  3,  4,  5, 
    2,  2,  3,  3,  5,  5, 
    2,  2,  3,  3,  5,  5, 
    2,  2,  3,  3,  5,  5, 
    2,  2,  3,  3,  4,  5, 
    2,  2,  3,  3,  4,  5, 
    2,  2,  3,  3,  6,  5, 
    2,  2,  3,  3,  6,  5, 
    3,  4,  4,  6,  7,  8, 
    3,  3,  4,  4,  6,  7, 
    3,  3,  4,  4,  6,  7, 
    3,  4,  4,  5,  6,  7, 
    3,  3,  4,  4,  6,  7, 
    2,  3,  3,  4,  5,  6, 
    2,  4,  3,  5,  5,  7, 
    2,  3,  4,  4,  5,  6, 
    2,  4,  4,  5,  5,  7, 
    2,  3,  4,  4,  5,  7, 
    2,  3,  4,  5,  5,  7, 
    2,  3,  4,  5,  5,  7, 
    2,  3,  4,  5,  5,  7, 
    2,  3,  3,  4,  5,  7, 
    2,  3,  3,  4,  5,  7, 
    2,  3,  3,  4,  5,  7, 
    2,  3,  3,  4,  5,  7, 
    4,  3,  4,  5,  5,  7 
};

static
int PrTgifLoad (FileName)
   char	* FileName;
{
   struct ObjRec	* obj_ptr;
   char 		full_name[MAXPATHLENGTH];
   int			len;
   FILE			* fp;

   len = strlen (FileName);
   if (len >= 4 && strcmp (&FileName[len-4], ".obj") == 0)
      strcpy (full_name, FileName);
   else
      sprintf (full_name, "%s.obj", FileName);

   if ((fp = fopen (full_name, "r")) == NULL)
   {
      printf ("Can not open '%s'.\n", full_name);
      return (FALSE);
   }

   printf ("Reading '%s' ...\n", full_name);

   while (ReadObj (fp, &obj_ptr, PRTGIF))
      if (obj_ptr != NULL)
         AddObj (NULL, topObj, obj_ptr);

   fclose (fp);
   return (TRUE);
}

main (argc, argv)
   int	argc;
   char	* argv[];
{
   char	inbuf[MAXSTRING+1];
   char	* c_ptr;
   int	len, file_name_found;

/* malloc_debug (1); */

   if ((c_ptr = getenv ("TGIFPATH")) == NULL)
      strcpy (drawPath, TGIF_PATH);
   else
      if (strlen (c_ptr) >= MAXSTRING)
         /* must be an error */
         strcpy (drawPath, TGIF_PATH);
      else
         strcpy (drawPath, c_ptr);

   strcpy (printCommand, "lpr");

   c_ptr = printCommand;
   c_ptr += strlen ("lpr");
   file_name_found = FALSE;
   for (argc--, argv++; argc > 0; argc--, argv++)
   {
      if (**argv == '-')
      {
#ifdef KANJI
	 if (!strcmp ("-euc", *argv))
	 {
	     noEuc = FALSE;
	 }
	 else if (!strcmp ("-nokanji", *argv))
	 {
	     noKanji = TRUE;
	 }
#endif /* KANJI */
         if ((strcmp (*argv, "-p") == 0) || (strcmp (*argv, "-eps") == 0))
            whereToPrint = LATEX_FIG;
         else if ((strcmp (*argv, "-f") == 0) || (strcmp (*argv, "-ps") == 0))
            whereToPrint = PS_FILE;
         else
         {
            strcat (c_ptr++, " ");
            strcat (c_ptr, *argv);
            c_ptr += strlen (*argv);
         }
      }
      else
         break;
   }

   switch (argc)
   {
      case 0:
         printf ("\nTgif File Name to Print> ");
         while (fgets (inbuf, MAXSTRING, stdin) != NULL)
         {
            len = strlen (inbuf);
            if (len > 0)
            {
               if (inbuf[--len] == '\n') inbuf[len] = '\0';
               if (PrTgifLoad (inbuf))
               {
                  Dump (PRTGIF, inbuf);
                  DelAllObj ();
               }
            }
            printf ("\nTgif File Name to Print> ");
         }
         break;
      default:
         for ( ; argc > 0; argc--, argv++)
         {
            lastFile = (argc == 1);
            if (PrTgifLoad (*argv))
            {
               Dump (PRTGIF, *argv);
               DelAllObj ();
            }
         }
   }
   printf ("\n");
   exit (0);
}
