/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/raster.c,v 2.0 91/03/05 12:48:04 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "color.e"
#include "font.e"
#include "pattern.e"
#include "setup.e"

#include "xbm/arrow.xbm"
#include "xbm/text.xbm"
#include "xbm/box.xbm"
#include "xbm/oval.xbm"
#include "xbm/poly.xbm"
#include "xbm/polygon.xbm"
#include "xbm/arc.xbm"
#include "xbm/rcbox.xbm"

#include "xbm/pat0.xbm"
#include "xbm/pat1.xbm"
#include "xbm/pat2.xbm"
#include "xbm/pat3.xbm"
#include "xbm/pat4.xbm"
#include "xbm/pat5.xbm"
#include "xbm/pat6.xbm"
#include "xbm/pat7.xbm"
#include "xbm/pat8.xbm"
#include "xbm/pat9.xbm"
#include "xbm/pat10.xbm"
#include "xbm/pat11.xbm"
#include "xbm/pat12.xbm"
#include "xbm/pat13.xbm"
#include "xbm/pat14.xbm"
#include "xbm/pat15.xbm"
#include "xbm/pat16.xbm"
#include "xbm/pat17.xbm"
#include "xbm/pat18.xbm"
#include "xbm/pat19.xbm"
#include "xbm/pat20.xbm"

#include "xbm/just_l.xbm"
#include "xbm/just_c.xbm"
#include "xbm/just_r.xbm"

#include "xbm/align_n.xbm"

#include "xbm/align_l.xbm"
#include "xbm/align_c.xbm"
#include "xbm/align_r.xbm"

#include "xbm/align_t.xbm"
#include "xbm/align_m.xbm"
#include "xbm/align_b.xbm"

#include "xbm/lw0.xbm"
#include "xbm/lw1.xbm"
#include "xbm/lw2.xbm"
#include "xbm/lw3.xbm"
#include "xbm/lw4.xbm"
#include "xbm/lw5.xbm"
#include "xbm/lw6.xbm"

#include "xbm/lt0.xbm"
#include "xbm/lt1.xbm"

#include "xbm/ls0.xbm"
#include "xbm/ls1.xbm"
#include "xbm/ls2.xbm"
#include "xbm/ls3.xbm"

#include "xbm/ld0.xbm"
#include "xbm/ld1.xbm"
#include "xbm/ld2.xbm"
#include "xbm/ld3.xbm"
#include "xbm/ld4.xbm"

#include "xbm/lw0s.xbm"
#include "xbm/lw1s.xbm"
#include "xbm/lw2s.xbm"
#include "xbm/lw3s.xbm"
#include "xbm/lw4s.xbm"
#include "xbm/lw5s.xbm"
#include "xbm/lw6s.xbm"

#include "xbm/lt0s.xbm"
#include "xbm/lt1s.xbm"

#include "xbm/ls0s.xbm"
#include "xbm/ls1s.xbm"
#include "xbm/ls2s.xbm"
#include "xbm/ls3s.xbm"

#include "xbm/ld0s.xbm"
#include "xbm/ld1s.xbm"
#include "xbm/ld2s.xbm"
#include "xbm/ld3s.xbm"
#include "xbm/ld4s.xbm"

#include "xbm/printer.xbm"
#include "xbm/latex.xbm"
#include "xbm/psfile.xbm"
#include "xbm/xbm.xbm"

#include "xbm/file.xbm"
#include "xbm/special.xbm"

#include "xbm/rotate_0.xbm"
#include "xbm/rotate_90.xbm"
#include "xbm/rotate_180.xbm"
#include "xbm/rotate_270.xbm"

GC	rasterGC;
#ifdef UC
GC	rasterReverseGC;
#endif /* UC */

Pixmap	patPixmap[MAXPATTERNS+1];
GC	patGC;

GC	drawGC = NULL;
GC	defaultGC;
GC	revDefaultGC;
#ifdef UC
GC	revDefaultGC2;
#endif /* UC */

Pixmap	choicePixmap[MAXCHOICES];
Pixmap	lineWidthPixmap[MAXLINEWIDTHS];
Pixmap	lineTypePixmap[MAXLINETYPES];
Pixmap	dashPixmap[MAXDASHES];
Pixmap	lineStylePixmap[MAXLINEWIDTHS+MAXLINETYPES+MAXDASHES+MAXLINESTYLES];
Pixmap	justPixmap[MAXJUSTS];
Pixmap	alignHoriPixmap[MAXALIGNS];
Pixmap	alignVertPixmap[MAXALIGNS];
Pixmap	shortLineWidthPixmap[MAXLINEWIDTHS];
Pixmap	filePixmap;
Pixmap	specialPixmap;
Pixmap	rotatePixmap[4];
Pixmap	whereToPrintPixmap[MAXWHERETOPRINT];
Pixmap	shortLineTypePixmap[MAXLINETYPES];
Pixmap	shortLineStylePixmap[MAXLINESTYLES];
Pixmap	shortDashPixmap[MAXDASHES];

int	pat_w[MAXPATTERNS+1], pat_h[MAXPATTERNS+1];
int	dashListLength[MAXDASHES] = { 0, 2, 2, 2, 4 };
char	* dashList[MAXDASHES] =
      {"","\004\014","\010\010","\014\004","\024\004\004\004"};

static char	* patData[MAXPATTERNS+1];

void InitPattern ()
{
   register int	i;
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillOpaqueStippled;

   rasterGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle, &values);

   values.fill_style = FillOpaqueStippled;
   patGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle, &values);

   values.join_style = JoinBevel;
   values.background = myBgPixel;
   drawGC = XCreateGC (mainDisplay, mainWindow,
         GCBackground | GCJoinStyle, &values);

   values.font = defaultFontPtr->fid;
   defaultGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFont, &values);

   values.foreground = 1;
   values.background = 0;
   values.function = GXxor;
   revDefaultGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFunction, &values);
#ifdef UC
   values.foreground = 1;
   values.background = 0;
   revDefaultGC2 = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFunction | GCFont, &values);
#endif /* UC */
#ifdef UC
   values.foreground = myBgPixel;
   values.background = myFgPixel;
   values.fill_style = FillOpaqueStippled;

   rasterReverseGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle, &values);
#endif /* UC */
   pat_w[0] = pat0_width; pat_h[0] = pat0_height; patData[0] = pat0_bits;
   pat_w[1] = pat1_width; pat_h[1] = pat1_height; patData[1] = pat1_bits;
   pat_w[2] = pat2_width; pat_h[2] = pat2_height; patData[2] = pat2_bits;
   pat_w[3] = pat3_width; pat_h[3] = pat3_height; patData[3] = pat3_bits;
   pat_w[4] = pat4_width; pat_h[4] = pat4_height; patData[4] = pat4_bits;
   pat_w[5] = pat5_width; pat_h[5] = pat5_height; patData[5] = pat5_bits;
   pat_w[6] = pat6_width; pat_h[6] = pat6_height; patData[6] = pat6_bits;
   pat_w[7] = pat7_width; pat_h[7] = pat7_height; patData[7] = pat7_bits;
   pat_w[8] = pat8_width; pat_h[8] = pat8_height; patData[8] = pat8_bits;
   pat_w[9] = pat9_width; pat_h[9] = pat9_height; patData[9] = pat9_bits;
   pat_w[10] = pat10_width; pat_h[10] = pat10_height; patData[10] = pat10_bits;
   pat_w[11] = pat11_width; pat_h[11] = pat11_height; patData[11] = pat11_bits;
   pat_w[12] = pat12_width; pat_h[12] = pat12_height; patData[12] = pat12_bits;
   pat_w[13] = pat13_width; pat_h[13] = pat13_height; patData[13] = pat13_bits;
   pat_w[14] = pat14_width; pat_h[14] = pat14_height; patData[14] = pat14_bits;
   pat_w[15] = pat15_width; pat_h[15] = pat15_height; patData[15] = pat15_bits;
   pat_w[16] = pat16_width; pat_h[16] = pat16_height; patData[16] = pat16_bits;
   pat_w[17] = pat17_width; pat_h[17] = pat17_height; patData[17] = pat17_bits;
   pat_w[18] = pat18_width; pat_h[18] = pat18_height; patData[18] = pat18_bits;
   pat_w[19] = pat19_width; pat_h[19] = pat19_height; patData[19] = pat19_bits;
   pat_w[20] = pat20_width; pat_h[20] = pat20_height; patData[20] = pat20_bits;

   for (i = 0; i < MAXPATTERNS+1; i++)
      patPixmap[i] = XCreateBitmapFromData (mainDisplay, mainWindow,
            patData[i], pat_w[i], pat_h[i]);

   justPixmap[JUST_L] = XCreateBitmapFromData (mainDisplay, mainWindow,
         just_l_bits, just_l_width, just_l_height);
   justPixmap[JUST_C] = XCreateBitmapFromData (mainDisplay, mainWindow,
         just_c_bits, just_c_width, just_c_height);
   justPixmap[JUST_R] = XCreateBitmapFromData (mainDisplay, mainWindow,
         just_r_bits, just_r_width, just_r_height);

   alignHoriPixmap[ALIGN_N] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_n_bits, align_n_width, align_n_height);
   alignHoriPixmap[ALIGN_L] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_l_bits, align_l_width, align_l_height);
   alignHoriPixmap[ALIGN_C] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_c_bits, align_c_width, align_c_height);
   alignHoriPixmap[ALIGN_R] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_r_bits, align_r_width, align_r_height);

   alignVertPixmap[ALIGN_N] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_n_bits, align_n_width, align_n_height);
   alignVertPixmap[ALIGN_T] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_t_bits, align_t_width, align_t_height);
   alignVertPixmap[ALIGN_M] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_m_bits, align_m_width, align_m_height);
   alignVertPixmap[ALIGN_B] = XCreateBitmapFromData (mainDisplay, mainWindow,
         align_b_bits, align_b_width, align_b_height);

   lineWidthPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw0_bits, lw0_width, lw0_height);
   lineWidthPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw1_bits, lw1_width, lw1_height);
   lineWidthPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw2_bits, lw2_width, lw2_height);
   lineWidthPixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw3_bits, lw3_width, lw3_height);
   lineWidthPixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw4_bits, lw4_width, lw4_height);
   lineWidthPixmap[5] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw5_bits, lw5_width, lw5_height);
   lineWidthPixmap[6] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw6_bits, lw6_width, lw6_height);

   lineTypePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt0_bits, lt0_width, lt0_height);
   lineTypePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt1_bits, lt1_width, lt1_height);

   dashPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld0_bits, ld0_width, ld0_height);
   dashPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld1_bits, ld1_width, ld1_height);
   dashPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld2_bits, ld2_width, ld2_height);
   dashPixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld3_bits, ld3_width, ld3_height);
   dashPixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld4_bits, ld4_width, ld4_height);

   lineStylePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw0_bits, lw0_width, lw0_height);
   lineStylePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw1_bits, lw1_width, lw1_height);
   lineStylePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw2_bits, lw2_width, lw2_height);
   lineStylePixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw3_bits, lw3_width, lw3_height);
   lineStylePixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw4_bits, lw4_width, lw4_height);
   lineStylePixmap[5] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw5_bits, lw5_width, lw5_height);
   lineStylePixmap[6] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw6_bits, lw6_width, lw6_height);

   lineStylePixmap[7] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt0_bits, lt0_width, lt0_height);
   lineStylePixmap[8] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt1_bits, lt1_width, lt1_height);

   lineStylePixmap[9] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld0_bits, ld0_width, ld0_height);
   lineStylePixmap[10] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld1_bits, ld1_width, ld1_height);
   lineStylePixmap[11] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld2_bits, ld2_width, ld2_height);
   lineStylePixmap[12] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld3_bits, ld3_width, ld3_height);
   lineStylePixmap[13] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld4_bits, ld4_width, ld4_height);

   lineStylePixmap[14] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls0_bits, ls0_width, ls0_height);
   lineStylePixmap[15] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls1_bits, ls1_width, ls1_height);
   lineStylePixmap[16] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls2_bits, ls2_width, ls2_height);
   lineStylePixmap[17] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls3_bits, ls3_width, ls3_height);

   shortLineStylePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls0s_bits, ls0s_width, ls0s_height);
   shortLineStylePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls1s_bits, ls1s_width, ls1s_height);
   shortLineStylePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls2s_bits, ls2s_width, ls2s_height);
   shortLineStylePixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ls3s_bits, ls3s_width, ls3s_height);

   filePixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         file_bits, file_width, file_height);

   specialPixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         special_bits, special_width, special_height);

   rotatePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rotate_0_bits, rotate_0_width, rotate_0_height);
   rotatePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rotate_90_bits, rotate_90_width, rotate_90_height);
   rotatePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rotate_180_bits, rotate_180_width, rotate_180_height);
   rotatePixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rotate_270_bits, rotate_270_width, rotate_270_height);

   whereToPrintPixmap[PRINTER] = XCreateBitmapFromData (mainDisplay, mainWindow,
         printer_bits, printer_width, printer_height);
   whereToPrintPixmap[LATEX_FIG] = XCreateBitmapFromData (mainDisplay,
         mainWindow, latex_bits, latex_width, latex_height);
   whereToPrintPixmap[PS_FILE] = XCreateBitmapFromData (mainDisplay,
         mainWindow, psfile_bits, psfile_width, psfile_height);
   whereToPrintPixmap[XBM_FILE] = XCreateBitmapFromData (mainDisplay,
         mainWindow, xbm_bits, xbm_width, xbm_height);

   shortLineTypePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt0s_bits, lt0s_width, lt0s_height);
   shortLineTypePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lt1s_bits, lt1s_width, lt1s_height);

   shortDashPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld0s_bits, ld0s_width, ld0s_height);
   shortDashPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld1s_bits, ld1s_width, ld1s_height);
   shortDashPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld2s_bits, ld2s_width, ld2s_height);
   shortDashPixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld3s_bits, ld3s_width, ld3s_height);
   shortDashPixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         ld4s_bits, ld4s_width, ld4s_height);

   shortLineWidthPixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw0s_bits, lw0s_width, lw0s_height);
   shortLineWidthPixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw1s_bits, lw1s_width, lw1s_height);
   shortLineWidthPixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw2s_bits, lw2s_width, lw2s_height);
   shortLineWidthPixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw3s_bits, lw3s_width, lw3s_height);
   shortLineWidthPixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw4s_bits, lw4s_width, lw4s_height);
   shortLineWidthPixmap[5] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw5s_bits, lw5s_width, lw5s_height);
   shortLineWidthPixmap[6] = XCreateBitmapFromData (mainDisplay, mainWindow,
         lw6s_bits, lw6s_width, lw6s_height);

   choicePixmap[0] = XCreateBitmapFromData (mainDisplay, mainWindow,
         arrow_bits, arrow_width, arrow_height);
   choicePixmap[1] = XCreateBitmapFromData (mainDisplay, mainWindow,
         text_bits, text_width, text_height);
   choicePixmap[2] = XCreateBitmapFromData (mainDisplay, mainWindow,
         box_bits, box_width, box_height);
   choicePixmap[3] = XCreateBitmapFromData (mainDisplay, mainWindow,
         oval_bits, oval_width, oval_height);
   choicePixmap[4] = XCreateBitmapFromData (mainDisplay, mainWindow,
         poly_bits, poly_width, poly_height);
   choicePixmap[5] = XCreateBitmapFromData (mainDisplay, mainWindow,
         polygon_bits, polygon_width, polygon_height);
   choicePixmap[6] = XCreateBitmapFromData (mainDisplay, mainWindow,
         arc_bits, arc_width, arc_height);
   choicePixmap[7] = XCreateBitmapFromData (mainDisplay, mainWindow,
         rcbox_bits, rcbox_width, rcbox_height);
}

void RedrawChoiceWindow ()
{
   ShowMode ();
   ShowColor (FALSE);
   ShowHoriAlign ();
   ShowVertAlign ();
   ShowJust ();
   ShowCurFont ();
   ShowRotate ();
   ShowSpecial ();
   ShowLineWidth ();
   ShowLineStyle ();
   ShowLineType ();
   ShowDash ();
   ShowWhereToPrint ();
   ShowFile ();
   ShowFill ();
   ShowPen ();
}

void CleanUpRasters ()
{
   register int	i;

   for (i = 0; i < MAXCHOICES; i++) XFreePixmap (mainDisplay, choicePixmap[i]);
   for (i = 0; i < MAXPATTERNS+1; i++) XFreePixmap (mainDisplay, patPixmap[i]);
   for (i = 0; i < MAXLINEWIDTHS; i++)
      XFreePixmap (mainDisplay, lineWidthPixmap[i]);
   for (i = 0; i < MAXLINEWIDTHS+MAXLINETYPES+MAXLINESTYLES; i++)
      XFreePixmap (mainDisplay, lineStylePixmap[i]);
   for (i = 0; i < MAXLINETYPES; i++)
      XFreePixmap (mainDisplay, lineTypePixmap[i]);
   for (i = 0; i < MAXDASHES; i++)
      XFreePixmap (mainDisplay, dashPixmap[i]);
   for (i = 0; i < MAXJUSTS; i++) XFreePixmap (mainDisplay, justPixmap[i]);
   XFreePixmap (mainDisplay, alignHoriPixmap[0]);
   for (i = 1; i < MAXALIGNS; i++)
      XFreePixmap (mainDisplay, alignHoriPixmap[i]);
   for (i = 1; i < MAXALIGNS; i++)
      XFreePixmap (mainDisplay, alignVertPixmap[i]);
   for (i = 0; i < MAXLINEWIDTHS; i++)
      XFreePixmap (mainDisplay, shortLineWidthPixmap[i]);
   XFreePixmap (mainDisplay, filePixmap);
   XFreePixmap (mainDisplay, specialPixmap);
   for (i = 0; i < 4; i++)
      XFreePixmap (mainDisplay, rotatePixmap[i]);
   for (i = 0; i < MAXWHERETOPRINT; i++)
      XFreePixmap (mainDisplay, whereToPrintPixmap[i]);
   for (i = 0; i < MAXLINETYPES; i++)
      XFreePixmap (mainDisplay, shortLineTypePixmap[i]);
   for (i = 0; i < MAXLINESTYLES; i++)
      XFreePixmap (mainDisplay, shortLineStylePixmap[i]);
   for (i = 0; i < MAXDASHES; i++)
      XFreePixmap (mainDisplay, shortDashPixmap[i]);

   XFreeGC (mainDisplay, rasterGC);
   XFreeGC (mainDisplay, patGC);
   XFreeGC (mainDisplay, drawGC); drawGC = NULL;
   XFreeGC (mainDisplay, defaultGC);
   XFreeGC (mainDisplay, revDefaultGC);
}
