/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/ruler.c,v 2.0 91/03/05 12:48:16 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "font.e"
#include "grid.e"
#include "raster.e"
#include "setup.e"

#define INCH_H 8
#define HALF_INCH_H 6
#define QUARTER_INCH_H 4
#define MIN_INCH_H 2

static GC	rulerGC;

static int	oldXOff = 0;
static int	oldYOff = 0;

void InitRuler ()
{
   XGCValues	values;

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillSolid;
   values.font = rulerFontPtr->fid;

   rulerGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle | GCFont, &values);
}

void CleanUpRuler ()
{
   XFreeGC (mainDisplay, rulerGC);
}

void RedrawHRuler ()
{
   register int	i, pos, len, index;
   int		inc, abs_inc, start;
   char		s[5];
   XEvent	ev;
#ifdef UC
   int		oneInch, halfInch, quarterInch;

   oneInch = (cmUnit)? ONE_CM : ONE_INCH;
   halfInch = (cmUnit)? HALF_CM : HALF_INCH;
   quarterInch = (cmUnit)? QUARTER_CM : QUARTER_INCH;
#endif /* UC */

   XClearWindow (mainDisplay, hRuleWindow);

   XSync (mainDisplay, FALSE);
   while (XCheckWindowEvent (mainDisplay, hRuleWindow, ExposureMask, &ev)) ;

   inc = xyGrid;
#ifndef UC
   abs_inc = (xyGrid<<zoomScale);
#else /* UC */
   abs_inc = (RealSize(xyGrid, zoomScale));
#endif /* UC */

   start = ((int)(drawOrigX / abs_inc)) * abs_inc;
   for (pos = 0, i = start; i < drawOrigX+drawWinW; i += abs_inc, pos += inc)
   {
#ifndef UC
      if ((i>>zoomScale) % ONE_INCH == 0)
#else /* UC */
      if ((ScreenSize(i, zoomScale)) % oneInch == 0)
#endif /* UC */
      {
#ifndef UC
         index = (int)((i>>zoomScale) / ONE_INCH);
#else /* UC */
         index = (int)((ScreenSize(i, zoomScale)) / oneInch);
#endif /* UC */
         if (pageStyle == SLIDELAND || pageStyle == SLIDEPORT)
#ifndef UC
            sprintf (s, "%1d", (index<<zoomScale)<<1);
         else
            sprintf (s, "%1d", index<<zoomScale);
#else /* UC */
        {
	    if (zoomScale < 0)
		sprintf (s, "%3.1f", ((double)(index<<1)/(1<<(-zoomScale))));
	    else
		sprintf (s, "%1d", (index<<zoomScale)<<1);
	 }
         else
	 {
	     if (zoomScale < 0)
		 sprintf (s, "%3.1f", (double)index/(1<<(-zoomScale)));
	     else
		 sprintf (s, "%1d", index<<zoomScale);
	 }
#endif /* UC */
         len = strlen (s);
         XDrawString (mainDisplay, hRuleWindow, rulerGC, pos-rulerFontWidth/2,
               rulerW-INCH_H-rulerFontDes, s, len);
         XDrawLine (mainDisplay, hRuleWindow, defaultGC, pos, rulerW,
               pos, rulerW-INCH_H);
      }
#ifndef UC
      else if ((i>>zoomScale) % HALF_INCH == 0)
#else /* UC */
      else if ((ScreenSize(i, zoomScale)) % halfInch == 0)
#endif /* UC */
      {
         XDrawLine (mainDisplay, hRuleWindow, defaultGC, pos, rulerW,
               pos, rulerW-HALF_INCH_H);
      }
#ifndef UC
      else if ((i>>zoomScale) % QUARTER_INCH == 0)
#else /* UC */
      else if ((ScreenSize(i, zoomScale)) % quarterInch == 0)
#endif /* UC */
      {
         XDrawLine (mainDisplay, hRuleWindow, defaultGC, pos, rulerW,
               pos, rulerW-QUARTER_INCH_H);
      }
      else
         XDrawLine (mainDisplay, hRuleWindow, defaultGC, pos, rulerW,
               pos, rulerW-MIN_INCH_H);
   }
   oldXOff = 0;
   XDrawLine (mainDisplay, hRuleWindow, revDefaultGC, oldXOff, 0,
         oldXOff, rulerW-1);
}

void RedrawVRuler ()
{
   register int	i, pos, len, index;
   int		inc, abs_inc, start;
   char		s[5];
   XEvent	ev;
#ifdef UC
   int		oneInch, halfInch, quarterInch;

   oneInch = (cmUnit)? ONE_CM : ONE_INCH;
   halfInch = (cmUnit)? HALF_CM : HALF_INCH;
   quarterInch = (cmUnit)? QUARTER_CM : QUARTER_INCH;
#endif /* UC */

   XClearWindow (mainDisplay, vRuleWindow);

   XSync (mainDisplay, FALSE);
   while (XCheckWindowEvent (mainDisplay, vRuleWindow, ExposureMask, &ev)) ;

   inc = xyGrid;
#ifndef UC
   abs_inc = (xyGrid<<zoomScale);
#else /* UC */
   abs_inc = (RealSize(xyGrid, zoomScale));
#endif /* UC */

   start = ((int)(drawOrigY / abs_inc)) * abs_inc;
   for (pos = 0, i = start; i < drawOrigY+drawWinH; i += abs_inc, pos += inc)
   {
#ifndef UC
      if ((i>>zoomScale) % ONE_INCH == 0)
#else /* UC */
      if ((ScreenSize(i, zoomScale)) % oneInch == 0)
#endif /* UC */
      {
#ifndef UC
         index = (int)((i>>zoomScale) / ONE_INCH);
#else /* UC */
         index = (int)((ScreenSize(i, zoomScale)) / oneInch);
#endif /* UC */
         if (pageStyle == SLIDELAND || pageStyle == SLIDEPORT)
#ifndef UC
            sprintf (s, "%1d", (index<<zoomScale)<<1);
         else
            sprintf (s, "%1d", index<<zoomScale);
#else /* UC */
	    if (zoomScale < 0)
		sprintf (s, "%3.1f", ((double)(index<<1)/(1<<(-zoomScale))));
	    else
		sprintf (s, "%1d", (index<<zoomScale)<<1);
         else
	     if (zoomScale < 0)
		 sprintf (s, "%3.1f", (double)index/(1<<(-zoomScale)));
	     else
		 sprintf (s, "%1d", index<<zoomScale);
#endif /* UC */
         len = strlen (s);
         XDrawString (mainDisplay, vRuleWindow, rulerGC, 1,
               pos-rulerFontHeight/2+rulerFontAsc, s, len);
         XDrawLine (mainDisplay, vRuleWindow, defaultGC, rulerW, pos,
               rulerW-INCH_H, pos);
      }
#ifndef UC
      else if ((i>>zoomScale) % HALF_INCH == 0)
#else /* UC */
      else if ((ScreenSize(i, zoomScale)) % halfInch == 0)
#endif /* UC */
      {
         XDrawLine (mainDisplay, vRuleWindow, defaultGC, rulerW, pos,
               rulerW-HALF_INCH_H, pos);
      }
#ifndef UC
      else if ((i>>zoomScale) % QUARTER_INCH == 0)
#else /* UC */
      else if ((ScreenSize(i, zoomScale)) % quarterInch == 0)
#endif /* UC */
      {
         XDrawLine (mainDisplay, vRuleWindow, defaultGC, rulerW, pos,
               rulerW-QUARTER_INCH_H, pos);
      }
      else
         XDrawLine (mainDisplay, vRuleWindow, defaultGC, rulerW, pos,
               rulerW-MIN_INCH_H, pos);
   }
   oldYOff = 0;
   XDrawLine (mainDisplay, vRuleWindow, revDefaultGC, 0, oldYOff,
         rulerW-1, oldYOff);
}

void MarkRulers (XOff, YOff)
   int	XOff, YOff;
{
   XDrawLine (mainDisplay, hRuleWindow, revDefaultGC, oldXOff, 0,
         oldXOff, rulerW-1);
   XDrawLine (mainDisplay, vRuleWindow, revDefaultGC, 0, oldYOff,
         rulerW-1, oldYOff);
   XDrawLine (mainDisplay, hRuleWindow, revDefaultGC, XOff, 0,
         XOff, rulerW-1);
   XDrawLine (mainDisplay, vRuleWindow, revDefaultGC, 0, YOff,
         rulerW-1, YOff);

   oldXOff = XOff;
   oldYOff = YOff;
}

void RedrawRulers ()
{
   RedrawHRuler ();
   RedrawVRuler ();
}
