/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/scroll.c,v 2.0 91/03/05 12:48:17 william Exp $";
#endif

#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "drawing.e"
#include "msg.e"
#include "obj.e"
#include "raster.e"
#include "ruler.e"
#include "setup.e"
#include "text.e"

#include "xbm/uparrow.xbm"
#include "xbm/downarrow.xbm"
#include "xbm/rightarrow.xbm"
#include "xbm/leftarrow.xbm"

char	* upData, * downData, * rightData, * leftData;

GC	scrollGC;
Pixmap	scrollPixmap;
XImage	* scrollImage;

static int	scrollAreaH, scrollAreaW;

void UpdScrollWinWH ()
{
   scrollAreaH = vSBarH - 2 * scrollBarW;
   scrollAreaW = hSBarW - 2 * scrollBarW;
}

void InitScroll ()
{
   XGCValues	values;

   upData = uparrow_bits;
   downData = downarrow_bits;
   rightData = rightarrow_bits;
   leftData = leftarrow_bits;

   UpdScrollWinWH ();

   scrollPixmap = XCreatePixmap (mainDisplay, mainWindow, scrollBarW,
         scrollBarW, mainDepth);
   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillTiled;
   values.tile = scrollPixmap;
   scrollGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle | GCTile, &values);
   scrollImage = XCreateImage (mainDisplay, mainVisual, 1, XYBitmap,
         0, uparrow_bits, scrollBarW, scrollBarW, 8, 2);
   scrollImage->byte_order = LSBFirst;
   scrollImage->bitmap_bit_order = LSBFirst;
}

static
void RedrawVScrollWindow ()
{
   double	frac, start_frac;
   int		block_h, block_start;
   XGCValues	values;
   XEvent	ev;

   XSync (mainDisplay, FALSE);
   while (XCheckWindowEvent (mainDisplay, vSBarWindow, ExposureMask, &ev)) ;

   start_frac = (double)((double)(drawOrigY)/(double)(paperHeight));
   block_start = (int)(scrollAreaH * start_frac);

   if (paperHeight > drawWinH)
      frac = (double)((double)drawWinH / (double)(paperHeight));
   else
      frac = 1.0;

   block_h = (int)(scrollAreaH * frac);

   values.foreground = myBgPixel;
   values.background = myFgPixel;
   values.function = GXcopy;
   values.fill_style = FillSolid;
   XChangeGC (mainDisplay, scrollGC,
         GCForeground | GCBackground | GCFunction | GCFillStyle,
         &values);
   XFillRectangle (mainDisplay, vSBarWindow, scrollGC, 0, scrollBarW,
         scrollBarW, scrollAreaH);

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillOpaqueStippled;
   values.stipple = patPixmap[SCROLLPAT];
   XChangeGC (mainDisplay, scrollGC,
         GCForeground | GCBackground | GCFillStyle | GCStipple,
         &values);
   XFillRectangle (mainDisplay, vSBarWindow, scrollGC, 0,
         scrollBarW+block_start, scrollBarW, block_h);

   scrollImage->data = upData;
   XPutImage (mainDisplay, vSBarWindow, scrollGC, scrollImage, 0, 0, 0, 0,
         scrollBarW, scrollBarW);
   scrollImage->data = downData;
   XPutImage (mainDisplay, vSBarWindow, scrollGC, scrollImage, 0, 0,
         0, scrollBarW+scrollAreaH, scrollBarW, scrollBarW);
}

static
void RedrawHScrollWindow ()
{
   double	frac, start_frac;
   int		block_w, block_start;
   XGCValues	values;
   XEvent	ev;

   XSync (mainDisplay, FALSE);
   while (XCheckWindowEvent (mainDisplay, hSBarWindow, ExposureMask, &ev)) ;

   start_frac = (double)((double)(drawOrigX)/(double)(paperWidth));
   block_start = (int)(scrollAreaW * start_frac);

   if (paperWidth > drawWinW)
      frac = (double)((double)drawWinW / (double)(paperWidth));
   else
      frac = 1.0;

   block_w = (int)(scrollAreaW * frac);

   values.foreground = myBgPixel;
   values.background = myFgPixel;
   values.function = GXcopy;
   values.fill_style = FillSolid;
   XChangeGC (mainDisplay, scrollGC,
         GCForeground | GCBackground | GCFunction | GCFillStyle,
         &values);
   XFillRectangle (mainDisplay, hSBarWindow, scrollGC, scrollBarW, 0,
         scrollAreaW, scrollBarW);

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillOpaqueStippled;
   values.stipple = patPixmap[SCROLLPAT];
   XChangeGC (mainDisplay, scrollGC,
         GCForeground | GCBackground | GCFillStyle | GCStipple,
         &values);
   XFillRectangle (mainDisplay, hSBarWindow, scrollGC, scrollBarW+block_start,
         0, block_w, scrollBarW);

   scrollImage->data = leftData;
   XPutImage (mainDisplay, hSBarWindow, scrollGC, scrollImage, 0, 0, 0, 0,
         scrollBarW, scrollBarW);
   scrollImage->data = rightData;
   XPutImage (mainDisplay, hSBarWindow, scrollGC, scrollImage, 0, 0,
         scrollBarW+scrollAreaW, 0, scrollBarW, scrollBarW);
}

void RedrawScrollBars ()
{
   RedrawVScrollWindow ();
   RedrawHScrollWindow ();
}

void ScrollUp ()
{
   if (drawOrigY != 0)
   {
#ifndef UC
      drawOrigY -= HALF_INCH<<zoomScale;
#else /* UC */
      drawOrigY -= RealSize(HALF_INCH, zoomScale);
#endif /* UC */
      RedrawVScrollWindow ();
      UpdDrawWinBBox ();
      AdjSplineVs ();
      AdjustCurText (0, HALF_INCH);
      ClearAndRedrawDrawWindow ();
      XClearWindow (mainDisplay, vRuleWindow);
      RedrawVRuler ();
   }
}

void ScrollDown ()
{
   if (paperHeight <= drawWinH) return;

   if (drawOrigY+drawWinH < paperHeight)
   {
#ifndef UC
      drawOrigY += HALF_INCH<<zoomScale;
#else /* UC */
      drawOrigY += RealSize(HALF_INCH, zoomScale);
#endif /* UC */
      RedrawVScrollWindow ();
      UpdDrawWinBBox ();
      AdjSplineVs ();
      AdjustCurText (0, -HALF_INCH);
      ClearAndRedrawDrawWindow ();
      XClearWindow (mainDisplay, vRuleWindow);
      RedrawVRuler ();
   }
}

static
void VSBarHandler (button_ev)
   XButtonEvent	* button_ev;
{
   double	frac, start_frac;
   int		block_h, block_start, adjustment, new_start, saved_y;

   if (button_ev->button == Button1)
   {
      if (button_ev->y < scrollBarW)
         ScrollUp (); /* clicked in the uparrow */
      else if (button_ev->y >= scrollBarW+scrollAreaH)
         ScrollDown (); /* clicked in the downarrow */
      else /* clicked in the middle region */
      {
         frac = (double)((double)drawWinH / (double)(paperHeight));
         if (frac > 1.0) frac = 1.0;
         block_h = (int)(scrollAreaH * frac);
         block_start = button_ev->y - scrollBarW;
         start_frac = (double)((double)(block_start)/(double)(scrollAreaH));
         if (block_start+block_h >= scrollAreaH)
         {
            saved_y = drawOrigY;

            if (paperHeight <= drawWinH)
               drawOrigY = 0;
            else
            {
#ifndef UC
               if ((paperHeight-drawWinH) % (HALF_INCH<<zoomScale) == 0)
#else /* UC */
               if ((paperHeight-drawWinH) % (RealSize(HALF_INCH, zoomScale)) == 0)
#endif /* UC */
                  drawOrigY = paperHeight-drawWinH;
               else
                  drawOrigY = ((int)((paperHeight-drawWinH)/
#ifndef UC
                        (HALF_INCH<<zoomScale)) + 1) *
                        (HALF_INCH<<zoomScale);
#else /* UC */
                        (RealSize(HALF_INCH, zoomScale))) + 1) *
                        (RealSize(HALF_INCH, zoomScale));
#endif /* UC */
            }

            adjustment = drawOrigY - saved_y;
            if (adjustment != 0)
            {
               RedrawVScrollWindow ();
               UpdDrawWinBBox ();
               AdjSplineVs ();
               AdjustCurText (0, adjustment);
               ClearAndRedrawDrawWindow ();
               RedrawVRuler ();
            }
            return;
         }
         else
         {
#ifndef UC
            new_start = ((int)(paperHeight*start_frac/(HALF_INCH<<zoomScale)))*
                  (HALF_INCH<<zoomScale);
#else /* UC */
            new_start = ((int)(paperHeight*start_frac/(RealSize(HALF_INCH, zoomScale))))*
                  (RealSize(HALF_INCH, zoomScale));
#endif /* UC */
            adjustment = drawOrigY - new_start;
            if (adjustment != 0)
            {
               drawOrigY = new_start;
               RedrawVScrollWindow ();
               UpdDrawWinBBox ();
               AdjSplineVs ();
               AdjustCurText (0, adjustment);
               ClearAndRedrawDrawWindow ();
               RedrawVRuler ();
            }
            return;
         }
      }
   }
}

void ScrollLeft ()
{
   if (drawOrigX != 0)
   {
#ifndef UC
      drawOrigX -= HALF_INCH<<zoomScale;
#else /* UC */
      drawOrigX -= RealSize(HALF_INCH, zoomScale);
#endif /* UC */
      RedrawHScrollWindow ();
      UpdDrawWinBBox ();
      AdjSplineVs ();
      AdjustCurText (HALF_INCH, 0);
      ClearAndRedrawDrawWindow ();
      XClearWindow (mainDisplay, hRuleWindow);
      RedrawHRuler ();
   }
}

void ScrollRight ()
{
   if (paperWidth <= drawWinW) return;

   if (drawOrigX+drawWinW < paperWidth)
   {
#ifndef UC
      drawOrigX += HALF_INCH<<zoomScale;
#else /* UC */
      drawOrigX += RealSize(HALF_INCH, zoomScale);
#endif /* UC */
      RedrawHScrollWindow ();
      UpdDrawWinBBox ();
      AdjSplineVs ();
      AdjustCurText (-HALF_INCH, 0);
      ClearAndRedrawDrawWindow ();
      XClearWindow (mainDisplay, hRuleWindow);
      RedrawHRuler ();
   }
}

static
void HSBarHandler (button_ev)
   XButtonEvent	* button_ev;
{
   double	frac, start_frac;
   int		block_w, block_start, adjustment, new_start, saved_x;

   if (button_ev->button == Button1)
   {
      if (button_ev->x < scrollBarW)
         ScrollLeft (); /* clicked in the leftarrow */
      else if (button_ev->x >= scrollBarW+scrollAreaW)
         ScrollRight (); /* clicked in the rightarrow */
      else /* clicked in the middle region */
      {
         frac = (double)((double)drawWinW / (double)(paperWidth));
         if (frac > 1.0) frac = 1.0;
         block_w = (int)(scrollAreaW * frac);
         block_start = button_ev->x - scrollBarW;
         start_frac = (double)((double)(block_start)/(double)(scrollAreaW));
         if (block_start+block_w >= scrollAreaW)
         {
            saved_x = drawOrigX;

            if (paperWidth <= drawWinW)
                drawOrigX = 0;
            {
#ifndef UC
               if ((paperWidth-drawWinW) % (HALF_INCH<<zoomScale) == 0)
#else /* UC */
               if ((paperWidth-drawWinW) % (RealSize(HALF_INCH, zoomScale)) == 0)
#endif /* UC */
                  drawOrigX = paperWidth-drawWinW;
               else
                  drawOrigX = ((int)((paperWidth-drawWinW)/
#ifndef UC
                        (HALF_INCH<<zoomScale)) + 1) *
                        (HALF_INCH<<zoomScale);
#else /* UC */
                        (RealSize(HALF_INCH, zoomScale))) + 1) *
                        (RealSize(HALF_INCH, zoomScale));
#endif /* UC */
            }

            adjustment = drawOrigX - saved_x;
            if (adjustment != 0)
            {
               RedrawHScrollWindow ();
               UpdDrawWinBBox ();
               AdjSplineVs ();
               AdjustCurText (adjustment, 0);
               ClearAndRedrawDrawWindow ();
               RedrawHRuler ();
            }
            return;
         }
         else
         {
#ifndef UC
            new_start = ((int)(paperWidth*start_frac/(HALF_INCH<<zoomScale)))*
                  (HALF_INCH<<zoomScale);
#else /* UC */
            new_start = ((int)(paperWidth*start_frac/(RealSize(HALF_INCH, zoomScale))))*
                  (RealSize(HALF_INCH, zoomScale));
#endif /* UC */
            adjustment = drawOrigX - new_start;
            if (adjustment != 0)
            {
               drawOrigX = new_start;
               RedrawHScrollWindow ();
               UpdDrawWinBBox ();
               AdjSplineVs ();
               AdjustCurText (adjustment, 0);
               ClearAndRedrawDrawWindow ();
               RedrawHRuler ();
            }
            return;
         }
      }
   }
}

void ScrollEventHandler (input)
   XEvent	* input;
{
   if (input->xany.window == vSBarWindow)
   {
      if (input->type == Expose)
      {
         XSync (mainDisplay, FALSE);
         RedrawVScrollWindow ();
         return;
      }

      Msg (""); 
      VSBarHandler (&(input->xbutton));
      return;
   }
   else if (input->xany.window == hSBarWindow)
   {
      if (input->type == Expose)
      {
         XSync (mainDisplay, FALSE);
         RedrawHScrollWindow ();
         return;
      }

      Msg (""); 
      HSBarHandler (&(input->xbutton));
      return;
   }
}

void CleanUpScrolls ()
{
   XFreePixmap (mainDisplay, scrollPixmap);
   XFreeGC (mainDisplay, scrollGC);
/* XDestroyImage (scrollImage); */
}
