/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/select.c,v 2.0 91/03/05 12:48:20 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "cursor.e"
#include "drawing.e"
#include "dup.e"
#include "grid.e"
#include "group.e"
#include "mark.e"
#include "move.e"
#include "obj.e"
#include "raster.e"
#include "rect.e"
#include "ruler.e"
#include "setup.e"
#include "stretch.e"

#define FORWARD 0
#define REVERSE 1

int		selLtX, selLtY, selRbX, selRbY;
int		selObjLtX, selObjLtY, selObjRbX, selObjRbY;
struct SelRec	* topSel = NULL, * botSel = NULL;
#ifdef UC
extern void 	CopySelToCut();
extern void 	DelAllSelObj ();
extern void 	DelAllCutSel ();
#endif /* UC */

static struct SelRec	* topCutSel = NULL, * botCutSel = NULL;

void CalcBBox (X1, Y1, X2, Y2, LtX, LtY, RbX, RbY)
   int X1, Y1, X2, Y2, * LtX, * LtY, * RbX, * RbY;
{
   if (X1 < X2)
      if (Y1 < Y2)
      {
         *LtX = X1; *LtY = Y1; *RbX = X2; *RbY = Y2;
      }
      else
      {
         *LtX = X1; *LtY = Y2; *RbX = X2; *RbY = Y1;
      }
   else
      if (Y1 < Y2)
      {
         *LtX = X2; *LtY = Y1; *RbX = X1; *RbY = Y2;
      }
      else
      {
         *LtX = X2; *LtY = Y2; *RbX = X1; *RbY = Y1;
      }
}

void RemoveAllSel ()
{
   while (topSel != NULL)
   {
      cfree (topSel);
      topSel = topSel->next;
   }
   botSel = NULL;
}

static
struct ObjRec * FindAnObj (X, Y)
   int	X, Y;
   /* X and Y are absolute coordinates */
{
   register struct ObjRec	* obj_ptr;

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
#ifndef UC
      if (X >= obj_ptr->bbox.ltx-(3<<zoomScale) &&
            X <= obj_ptr->bbox.rbx+(3<<zoomScale) &&
            Y >= obj_ptr->bbox.lty-(3<<zoomScale) &&
            Y <= obj_ptr->bbox.rby+(3<<zoomScale))
#else /* UC */
      if (X >= obj_ptr->bbox.ltx-(RealSize(3, zoomScale)) &&
            X <= obj_ptr->bbox.rbx+(RealSize(3, zoomScale)) &&
            Y >= obj_ptr->bbox.lty-(RealSize(3, zoomScale)) &&
            Y <= obj_ptr->bbox.rby+(RealSize(3, zoomScale)))
#endif /* UC */
      {
         switch (obj_ptr->type)
         {
            case OBJ_TEXT: return (obj_ptr);
            case OBJ_XBM: return (obj_ptr);
            case OBJ_BOX:
#ifdef DEBUG
		printf ("BOX\n");
#endif /* DEBUG */
               if (FindGoodBox (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_OVAL:
#ifdef DEBUG
		printf ("OVAL\n");
#endif /* DEBUG */
#ifndef DEBUG
               if (FindGoodOval (X, Y, obj_ptr)) return (obj_ptr); break;
#else /* UC */
               if (FindGoodOval (X, Y, obj_ptr))
		   {
		       printf ("GET!\n");return (obj_ptr);} break;
#endif /* DEBUG */
            case OBJ_POLY:
               if (FindGoodPoly (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_POLYGON:
               if (FindGoodPolygon (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_ARC:
               if (FindGoodArc (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_RCBOX:
               if (FindGoodRCBox (X, Y, obj_ptr)) return (obj_ptr); break;

            case OBJ_GROUP:
            case OBJ_SYM:
            case OBJ_ICON:
               if (FindGoodObj (X, Y, obj_ptr->detail.r->first))
                  return (obj_ptr);
         }
      }
   return (NULL);
}

static
struct SelRec * AlreadySelected (ObjPtr)
   register struct ObjRec	* ObjPtr;
{
   register struct SelRec	* sel_ptr;

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      if (sel_ptr->obj == ObjPtr)
         return (sel_ptr);
   return (NULL);
}

void AddSel (PrevPtr, NextPtr, SelPtr)
   struct SelRec	* PrevPtr, * NextPtr, * SelPtr;
   /* add SelPtr between PrevPtr and NextPtr */
{
   SelPtr->prev = PrevPtr;
   SelPtr->next = NextPtr;

   if (PrevPtr == NULL)
      topSel = SelPtr;
   else
      PrevPtr->next = SelPtr;

   if (NextPtr == NULL)
      botSel = SelPtr;
   else
      NextPtr->prev = SelPtr;
}

void AddNewSelObj (ObjPtr)
   register struct ObjRec	* ObjPtr;
{
   register struct ObjRec	* obj_ptr = topObj;
   register struct SelRec	* sel_ptr = topSel, * new_sel_ptr;

   new_sel_ptr = (struct SelRec *) calloc (1, sizeof(struct SelRec));
   new_sel_ptr->obj = ObjPtr;

   for ( ; sel_ptr != NULL && obj_ptr != ObjPtr; obj_ptr = obj_ptr->next)
      if (obj_ptr == sel_ptr->obj)
         sel_ptr = sel_ptr->next;

   if (sel_ptr == NULL)
   {  /* the object is below the last selected object */
      if (botSel == NULL)
         topSel = new_sel_ptr;
      else
         botSel->next = new_sel_ptr;

      new_sel_ptr->prev = botSel;
      new_sel_ptr->next = NULL;
      botSel = new_sel_ptr;
   }
   else
   {  /* the object is between sel_ptr and sel_ptr->prev */
      if (sel_ptr->prev == NULL)
         topSel = new_sel_ptr;
      else
         sel_ptr->prev->next = new_sel_ptr;

      new_sel_ptr->next = sel_ptr;
      new_sel_ptr->prev = sel_ptr->prev;
      sel_ptr->prev = new_sel_ptr;
   }
}

void UpdSelBBox ()
   /* update selLtX, selLtY, selRbX, selRbY */
{
   register struct ObjRec	* obj_ptr;
   register struct SelRec	* sel_ptr;

   if ((sel_ptr = topSel) == NULL) return;

   selLtX = sel_ptr->obj->bbox.ltx;
   selLtY = sel_ptr->obj->bbox.lty;
   selRbX = sel_ptr->obj->bbox.rbx;
   selRbY = sel_ptr->obj->bbox.rby;
   selObjLtX = sel_ptr->obj->obbox.ltx;
   selObjLtY = sel_ptr->obj->obbox.lty;
   selObjRbX = sel_ptr->obj->obbox.rbx;
   selObjRbY = sel_ptr->obj->obbox.rby;

   for (sel_ptr = topSel->next; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      if (obj_ptr->bbox.ltx < selLtX) selLtX = obj_ptr->bbox.ltx;
      if (obj_ptr->bbox.lty < selLtY) selLtY = obj_ptr->bbox.lty;
      if (obj_ptr->bbox.rbx > selRbX) selRbX = obj_ptr->bbox.rbx;
      if (obj_ptr->bbox.rby > selRbY) selRbY = obj_ptr->bbox.rby;
      if (obj_ptr->obbox.ltx < selObjLtX) selObjLtX = obj_ptr->obbox.ltx;
      if (obj_ptr->obbox.lty < selObjLtY) selObjLtY = obj_ptr->obbox.lty;
      if (obj_ptr->obbox.rbx > selObjRbX) selObjRbX = obj_ptr->obbox.rbx;
      if (obj_ptr->obbox.rby > selObjRbY) selObjRbY = obj_ptr->obbox.rby;
   }
}
 
static
struct SelRec * SelectOneObj (X, Y)
   int	X, Y;
   /* X and Y are absolute coordinates */
{
   register struct ObjRec	* obj_ptr;

   RemoveAllSel ();
   if ((obj_ptr = FindAnObj (X, Y)) == NULL) return (NULL);

   topSel = (struct SelRec *) calloc (1, sizeof(struct SelRec));
   topSel->next = NULL;
   topSel->obj = obj_ptr;
   topSel->prev = NULL;
   botSel = topSel;
   UpdSelBBox ();

   return (topSel);
}

static
struct SelRec * FindObjects (X1, Y1, X2, Y2, TopSel, BotSel)
   int	X1, Y1, X2, Y2;
   struct SelRec	* * TopSel, * * BotSel;
   /* X1, Y1, X2, Y2 are absolute coordinates */
{
   register struct ObjRec	* obj_ptr;
   register struct SelRec	* sel_ptr;

   *TopSel = *BotSel = NULL;

   for (obj_ptr = botObj; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
      if (X1 <= obj_ptr->bbox.ltx && X2 >= obj_ptr->bbox.rbx &&
            Y1 <= obj_ptr->bbox.lty && Y2 >= obj_ptr->bbox.rby)
      {
         sel_ptr = (struct SelRec *) calloc (1, sizeof(struct SelRec));
         sel_ptr->next = *TopSel;
         sel_ptr->obj = obj_ptr;
         sel_ptr->prev = NULL;
         if (*TopSel == NULL)
            *BotSel = sel_ptr;
         else
            (*TopSel)->prev = sel_ptr;
         *TopSel = sel_ptr;
      }

   return (*TopSel);
}
 
static XPoint sv[5];

void SelBox (window, gc, x1, y1, x2, y2)
   Window	window;
   GC		gc;
   int		x1, y1, x2, y2;
{
#ifndef UC
   sv[0].x = (short)x1; sv[0].y = (short)y1;
   sv[1].x = (short)x1; sv[1].y = (short)y2;
   sv[2].x = (short)x2; sv[2].y = (short)y2;
   sv[3].x = (short)x2; sv[3].y = (short)y1;
   sv[4].x = (short)x1; sv[4].y = (short)y1;
   XDrawLines (mainDisplay, window, gc, sv, 5, CoordModeOrigin);
#else /* UC */
   if (x1 == x2 || y1 == y2)
       XDrawLine (mainDisplay, window, gc, x1, y1, x2, y2);
   else
   {
       sv[0].x = (short)x1; sv[0].y = (short)y1;
       sv[1].x = (short)x1; sv[1].y = (short)y2;
       sv[2].x = (short)x2; sv[2].y = (short)y2;
       sv[3].x = (short)x2; sv[3].y = (short)y1;
       sv[4].x = (short)x1; sv[4].y = (short)y1;
       XDrawLines (mainDisplay, window, gc, sv, 5, CoordModeOrigin);
   }
#endif /* UC */
}

static
struct ObjRec * PtInObjList (X, Y, FirstObjPtr)
   int			X, Y;
   struct ObjRec	* FirstObjPtr;
   /* X and Y are absolute coordinates */
{
   register struct ObjRec	* obj_ptr, * obj_ptr1;

   for (obj_ptr = FirstObjPtr; obj_ptr != NULL; obj_ptr = obj_ptr->next)
   {
#ifndef UC
      if (X >= obj_ptr->bbox.ltx-(3<<zoomScale) &&
            X <= obj_ptr->bbox.rbx+(3<<zoomScale) &&
            Y >= obj_ptr->bbox.lty-(3<<zoomScale) &&
            Y <= obj_ptr->bbox.rby+(3<<zoomScale))
#else /* UC */
      if (X >= obj_ptr->bbox.ltx-(RealSize(3, zoomScale)) &&
            X <= obj_ptr->bbox.rbx+(RealSize(3, zoomScale)) &&
            Y >= obj_ptr->bbox.lty-(RealSize(3, zoomScale)) &&
            Y <= obj_ptr->bbox.rby+(RealSize(3, zoomScale)))
#endif /* UC */
      {
         switch (obj_ptr->type)
         {
            case OBJ_TEXT: return (obj_ptr);
            case OBJ_XBM: return (obj_ptr);
            case OBJ_BOX:
               if (FindGoodBox (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_OVAL:
               if (FindGoodOval (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_POLY:
               if (FindGoodPoly (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_POLYGON:
               if (FindGoodPolygon (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_ARC:
               if (FindGoodArc (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_RCBOX:
               if (FindGoodRCBox (X, Y, obj_ptr)) return (obj_ptr); break;

            case OBJ_GROUP:
            case OBJ_SYM:
            case OBJ_ICON:
               obj_ptr1 = PtInObjList (X, Y, obj_ptr->detail.r->first);
               if (obj_ptr1 != NULL) return (obj_ptr1);
               break;
         }
      }
   }
   return (NULL);
}

static
struct ObjRec * PtInSelected (X, Y)
   int	X, Y;
   /* X and Y are absolute coordinates */
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr, * obj_ptr1;

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
#ifndef UC
      if (X >= obj_ptr->bbox.ltx-(3<<zoomScale) &&
            X <= obj_ptr->bbox.rbx+(3<<zoomScale) &&
            Y >= obj_ptr->bbox.lty-(3<<zoomScale) &&
            Y <= obj_ptr->bbox.rby+(3<<zoomScale))
#else /* UC */
      if (X >= obj_ptr->bbox.ltx-(RealSize(3, zoomScale)) &&
            X <= obj_ptr->bbox.rbx+(RealSize(3, zoomScale)) &&
            Y >= obj_ptr->bbox.lty-(RealSize(3, zoomScale)) &&
            Y <= obj_ptr->bbox.rby+(RealSize(3, zoomScale)))
#endif /* UC */
      {
         switch (obj_ptr->type)
         {
            case OBJ_TEXT: return (obj_ptr);
            case OBJ_XBM: return (obj_ptr);
            case OBJ_BOX:
               if (FindGoodBox (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_OVAL:
               if (FindGoodOval (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_POLY:
               if (FindGoodPoly (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_POLYGON:
               if (FindGoodPolygon (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_ARC:
               if (FindGoodArc (X, Y, obj_ptr)) return (obj_ptr); break;
            case OBJ_RCBOX:
               if (FindGoodRCBox (X, Y, obj_ptr)) return (obj_ptr); break;

            case OBJ_GROUP:
            case OBJ_SYM:
            case OBJ_ICON:
               obj_ptr1 = PtInObjList (X, Y, obj_ptr->detail.r->first);
               if (obj_ptr1 != NULL) return (obj_ptr1);
               break;
         }
      }
   }
   return (NULL);
}

static
void ToggleSelectedObjIfSelectedAlready (ObjPtr)
   register struct ObjRec	* ObjPtr;
{
   register struct SelRec	* sel_ptr;

   if ((sel_ptr = AlreadySelected (ObjPtr)) != NULL)
   {  /* de-select an object */
      HighLightAnObj (ObjPtr);

      if (sel_ptr->prev == NULL)
         topSel = sel_ptr->next;
      else
         sel_ptr->prev->next = sel_ptr->next;

      if (sel_ptr->next == NULL)
         botSel = sel_ptr->prev;
      else
         sel_ptr->next->prev = sel_ptr->prev;

      cfree (sel_ptr);
   }
   else
   {  /* add a newly selected object */
      AddNewSelObj (ObjPtr);
      HighLightAnObj (ObjPtr);
   }
}

static
void ContinueSel (XOff, YOff, ShiftKeyDown)
   int 	XOff, YOff, ShiftKeyDown;
   /* XOff and YOff are screen offsets, and they are not on grid */
{
   int 			end_x, end_y;
   int 			done = FALSE, ltx, lty, rbx, rby, dx, dy;
   int 			new_end_x, new_end_y;
   XEvent		input;
   XMotionEvent		* motion_ev;
   struct SelRec	* sel_ptr, * top_sel_ptr, * bot_sel_ptr;
   struct ObjRec	* obj_ptr;
#ifdef UC
   register int		hidedragcursor = hideDragCursor;
   register int		cursordefined = FALSE;
#endif /* UC */

   end_x = XOff;
   end_y = YOff; 

   SelBox (drawWindow, revDefaultGC, XOff, YOff, end_x, end_y);
   XGrabPointer (mainDisplay, drawWindow, False,
         PointerMotionMask | ButtonReleaseMask,
#ifndef UC
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
#else /* UC */
         GrabModeAsync, GrabModeAsync, None, (hidedragcursor)? None: handCursor, CurrentTime);
#endif /* UC */
   
   while (!done)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonRelease)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         SelBox (drawWindow, revDefaultGC, XOff, YOff, end_x, end_y);
#ifdef UC
	 if (hidedragcursor && cursordefined)
	 {
	     XDefineCursor (mainDisplay, drawWindow, defaultCursor);
	     cursordefined = FALSE;
	     XFlush( mainDisplay);
	 }
#endif /* UC */
         done = TRUE;
      }
      else if (input.type == MotionNotify)
      {
         motion_ev = &(input.xmotion);
         new_end_x = motion_ev->x;
         new_end_y = motion_ev->y;

#ifdef UC
	 if (hidedragcursor && !cursordefined && new_end_x!=end_x && new_end_y!=end_y)
	 {
	     XDefineCursor (mainDisplay, drawWindow, dragCursor);
	     cursordefined = TRUE;
	 }
#endif /* UC */
         SelBox (drawWindow, revDefaultGC, XOff, YOff, end_x, end_y);
         end_x = new_end_x; end_y = new_end_y;
         SelBox (drawWindow, revDefaultGC, XOff, YOff, end_x, end_y);

         MarkRulers (end_x, end_y);
      }
   }

   dx = abs (XOff - end_x);
   dy = abs (YOff - end_y);
   if (dx <= 2 && dy <= 2)
   {
      if (ShiftKeyDown)
      {
#ifndef UC
         obj_ptr = FindAnObj ((XOff<<zoomScale)+drawOrigX,
               (YOff<<zoomScale)+drawOrigY);
#else /* UC */
         obj_ptr = FindAnObj ((RealSize(XOff, zoomScale))+drawOrigX,
               (RealSize(YOff, zoomScale))+drawOrigY);
#endif /* UC */
         if (obj_ptr != NULL)
         {
            ToggleSelectedObjIfSelectedAlready (obj_ptr);
            UpdSelBBox ();
         }
      }
      else
      {
         if (topSel != NULL) HighLightReverse ();

#ifndef UC
         if (SelectOneObj ((XOff<<zoomScale)+drawOrigX,
               (YOff<<zoomScale)+drawOrigY) != NULL)
#else /* UC */
         if (SelectOneObj ((RealSize(XOff, zoomScale))+drawOrigX,
               (RealSize(YOff, zoomScale))+drawOrigY) != NULL)
#endif /* UC */
            HighLightForward ();
      }
   }
   else
   {
      CalcBBox (XOff, YOff, end_x, end_y, &ltx, &lty, &rbx, &rby);
      if (ShiftKeyDown)
      {
#ifndef UC
         if (FindObjects ((ltx<<zoomScale)+drawOrigX,
               (lty<<zoomScale)+drawOrigY, (rbx<<zoomScale)+drawOrigX,
               (rby<<zoomScale)+drawOrigY, &top_sel_ptr, &bot_sel_ptr) != NULL)
#else /* UC */
         if (FindObjects ((RealSize(ltx, zoomScale))+drawOrigX,
               (RealSize(lty, zoomScale))+drawOrigY, (RealSize(rbx, zoomScale))+drawOrigX,
               (RealSize(rby, zoomScale))+drawOrigY, &top_sel_ptr, &bot_sel_ptr) != NULL)
#endif /* UC */
         {
            for (sel_ptr=top_sel_ptr; sel_ptr!=NULL; sel_ptr=sel_ptr->next)
            {
               obj_ptr = sel_ptr->obj;
               ToggleSelectedObjIfSelectedAlready (obj_ptr);
               cfree(sel_ptr);
            }
            UpdSelBBox ();
         }
      }
      else
      {
         if (topSel != NULL) HighLightReverse ();
         RemoveAllSel ();
#ifndef UC
         if (FindObjects ((ltx<<zoomScale)+drawOrigX,
               (lty<<zoomScale)+drawOrigY, (rbx<<zoomScale)+drawOrigX,
               (rby<<zoomScale)+drawOrigY, &top_sel_ptr, &bot_sel_ptr) != NULL)
#else /* UC */
         if (FindObjects ((RealSize(ltx, zoomScale))+drawOrigX,
               (RealSize(lty, zoomScale))+drawOrigY, (RealSize(rbx, zoomScale))+drawOrigX,
               (RealSize(rby, zoomScale))+drawOrigY, &top_sel_ptr, &bot_sel_ptr) != NULL)
#endif /* UC */
         {
            topSel = top_sel_ptr;
            botSel = bot_sel_ptr;
            UpdSelBBox ();
            HighLightForward ();
         }
      }
   }
}

void Select (input)
   XEvent	* input;
{
   XButtonEvent		* button_ev;
   struct SelRec	* sel_ptr;
   struct ObjRec	* obj_ptr;
   int			mouse_x, mouse_y, grid_x, grid_y, corner;

   if (input->type != ButtonPress) return;

   button_ev = &(input->xbutton);
   if (button_ev->button == Button1)
   {
      mouse_x = button_ev->x;
      mouse_y = button_ev->y;
      GridXY (mouse_x, mouse_y, &grid_x, &grid_y);

      if (button_ev->state & ShiftMask)
      {
         ContinueSel (mouse_x, mouse_y, TRUE);
         justDupped = FALSE;
         return;
      }
      if (topSel != NULL)
      {
         if ((sel_ptr = PtInSelMark (mouse_x, mouse_y, &corner)) != NULL)
         {
#ifdef UC
/*	    DelAllCutSel ();
	    CopySelToCut ();*/
	    undo.operation = STRETCH;
#endif /* UC */
            StretchSel (grid_x, grid_y, sel_ptr->obj, corner);
            justDupped = FALSE;
            return;
         }
#ifndef UC
         else if ((obj_ptr = PtInSelected ((mouse_x<<zoomScale)+drawOrigX,
               (mouse_y<<zoomScale)+drawOrigY)) != NULL)
#else /* UC */
         else if ((obj_ptr = PtInSelected ((RealSize(mouse_x, zoomScale))+drawOrigX,
               (RealSize(mouse_y, zoomScale))+drawOrigY)) != NULL)
#endif /* UC */
         {
#ifdef UC
/*	    DelAllCutSel ();
	    CopySelToCut (); */
#endif /* UC */
            MoveSel (grid_x, grid_y, obj_ptr);
            return;
         }
      }
      ContinueSel (mouse_x, mouse_y, FALSE);
      justDupped = FALSE;
#ifdef UC
      undo.operation = NOP;
/*      DelAllCutSel ();*/
#endif /* UC */
   }
}

void SelAllObj ()
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;

   TieLooseEnds ();
   SetCurChoice (NOTHING);

   if (topSel != NULL)
   {
      HighLightReverse ();
      RemoveAllSel ();
   }
   for (obj_ptr = botObj; obj_ptr != NULL; obj_ptr = obj_ptr->prev)
   {
      sel_ptr = (struct SelRec *) calloc (1, sizeof(struct SelRec));
      sel_ptr->next = topSel;
      sel_ptr->obj = obj_ptr;
      sel_ptr->prev = NULL;
      if (topSel == NULL)
         botSel = sel_ptr;
      else
         topSel->prev = sel_ptr;
      topSel = sel_ptr;
   }
   UpdSelBBox ();
   HighLightForward ();
   justDupped = FALSE;
}

static struct ObjRec	* tmpTopObj, * tmpBotObj;

static
void PushTmpObj (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   ObjPtr->next = tmpTopObj;
   ObjPtr->prev = NULL;

   if (tmpBotObj == NULL)
      tmpBotObj = ObjPtr;
   else
      tmpTopObj->prev = ObjPtr;

   tmpTopObj = ObjPtr;
}

static
#ifndef UC
void BreakSel ()
#else /* UC */
int BreakSel ()
#endif /* UC */
   /* break off selected objects from the main stream objects           */
   /* when returns, tmpTopObj points to the top of the selected objects */
   /*    and tmpBotObj points to the bottom of the selected objects     */
{
   register struct SelRec	* sel_ptr;
#ifdef UC
   register int sandWiched = ((topSel->obj->prev != NULL)? TRUE: FALSE);
#endif /* UC */

   for (sel_ptr = botSel; sel_ptr != NULL; sel_ptr = sel_ptr->prev)
   {
#ifdef UC
      if (! sandWiched && sel_ptr->prev != NULL &&
	  sel_ptr->prev->obj->next != sel_ptr->obj)
	  sandWiched = TRUE;
#endif /* UC */
      UnlinkObj (sel_ptr->obj);
      PushTmpObj (sel_ptr->obj);
   }
#ifdef UC
   return (sandWiched);
#endif /* UC */
}

void MoveSelToTop ()
{
   if (topSel == NULL) return;

   tmpTopObj = tmpBotObj = NULL;

   BreakSel ();
   tmpBotObj->next = topObj;
   if (topObj == NULL)
      botObj = tmpBotObj;
   else
      topObj->prev = tmpBotObj;
   topObj = tmpTopObj;
}

void MoveSelToBot ()
{
   if (topSel == NULL) return;

   tmpTopObj = tmpBotObj = NULL;

   BreakSel ();
   tmpTopObj->prev = botObj;
   if (topObj == NULL)
      topObj = tmpTopObj;
   else
      botObj->next = tmpTopObj;
   botObj = tmpBotObj;
}

void DelAllCutSel ()
{
   register struct SelRec	* sel_ptr;

   while (topCutSel != NULL)
   {
      for (sel_ptr = topCutSel->next; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      {
         FreeObj (sel_ptr->obj);
         cfree (sel_ptr);
      }
      topCutSel = topCutSel->prev; /* prev is used as the stack chaser */
      botCutSel = botCutSel->prev; /* prev is used as the stack chaser */
   }
}

void UndoDelete ()
{
#ifdef UC
/*   struct SelRec		* topNext, * botNext;*/
#endif /* UC */
#ifndef UC
   if (topCutSel == NULL)
#else /* UC */
   if (undo.operation == NOP && topCutSel == NULL)
#endif /* UC */
   {
      Msg ("Un-delete buffer empty!");
      return;
   }

   HighLightReverse ();
#ifndef UC
   RemoveAllSel ();

   topSel = topCutSel->next;
   botSel = botCutSel->next;

   botSel->obj->next = topObj;
   if (topObj == NULL)
      botObj = botSel->obj;
   else
      topObj->prev = botSel->obj;
   topObj = topSel->obj;

   cfree (topCutSel);
   cfree (botCutSel);
   topCutSel = topCutSel->prev; /* prev is used as the stack chaser */
   botCutSel = botCutSel->prev; /* prev is used as the stack chaser */

   UpdSelBBox ();
   RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
         selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
   HighLightForward ();
#else /* UC */
   switch (undo.operation)
   {
      case DELETE:
         RemoveAllSel ();

	 topSel = topCutSel->next;
	 botSel = botCutSel->next;

	 botSel->obj->next = topObj;
	 if (topObj == NULL)
	     botObj = botSel->obj;
	 else
	     topObj->prev = botSel->obj;
	 topObj = topSel->obj;
	 
	 cfree (topCutSel);
	 cfree (botCutSel);
	 topCutSel = topCutSel->prev; /* prev is used as the stack chaser */
	 botCutSel = botCutSel->prev; /* prev is used as the stack chaser */
	 undo.operation = NOP;

	 UpdSelBBox ();
	 RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
		       selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
	 HighLightForward ();
	 break;
      case MOVE:
	 undo.info.m.dx = -(undo.info.m.dx);
	 undo.info.m.dy = -(undo.info.m.dy);
	 DoMoveAllSel (undo.info.m.dx, undo.info.m.dy);
	 break;
      case STRETCH:
	 switch (undo.object)
	 {
	    case OBJ_BOX:
	        UndoStretchBox ();
		break;
	    case OBJ_POLY:
	    case OBJ_POLYGON:		
	        UndoStretchPoly ();
		break;
	 }
	 break;
   }
/*   topNext = topCutSel->next;
   botNext = botCutSel->next;
   cfree (topCutSel);
   cfree (botCutSel);
   topCutSel = topCutSel->prev; /_* prev is used as the stack chaser *_/
   botCutSel = botCutSel->prev; /_* prev is used as the stack chaser *_/

   DelAllSelObj ();
      
   topSel = topNext;
   botSel = botNext;

   botSel->obj->next = topObj;
   if (topObj == NULL)
      botObj = botSel->obj;
   else
      topObj->prev = botSel->obj;
   topObj = topSel->obj;
*/
#endif /* UC */
   SetCurChoice (NOTHING);
   SetFileModified (TRUE);
   justDupped = FALSE;
}

void PushToCutBuffer (TopSelPtr, BotSelPtr)
   struct SelRec	* TopSelPtr, * BotSelPtr;
{
   register struct SelRec	* top_cut_ptr, * bot_cut_ptr;

   top_cut_ptr = (struct SelRec *) calloc (2, sizeof (struct SelRec));
   bot_cut_ptr = &top_cut_ptr[1];
   top_cut_ptr->next = TopSelPtr; bot_cut_ptr->next = BotSelPtr;
   top_cut_ptr->prev = topCutSel; bot_cut_ptr->prev = botCutSel;
   topCutSel = top_cut_ptr; botCutSel = bot_cut_ptr;
}

void CopySelToCut ()
{
   struct SelRec	* top_sel_ptr, * bot_sel_ptr;

   if (topSel == NULL) return;

   JustDupSelObj (&top_sel_ptr, &bot_sel_ptr);
   PushToCutBuffer (top_sel_ptr, bot_sel_ptr);
}

void DelAllSelObj ()
{
   if (topSel == NULL) { Msg ("No object selected!"); return; }

   HighLightReverse ();
   tmpTopObj = tmpBotObj = NULL;
   BreakSel ();

   PushToCutBuffer (topSel, botSel);

   topSel = botSel = NULL;
#ifndef UC
   RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
         selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
         selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   SetFileModified (TRUE);
   justDupped = FALSE;
#ifdef UC
   undo.operation = DELETE;
#endif /* UC */
}

void GroupSelObj ()
{
#ifdef UC
   int sandWiched;

#endif /* UC */
   if (topSel == NULL) { Msg ("No object to group!"); return; }
   if (topSel == botSel)
   {
      Msg ("Can not group a single object!  Abort!");
      return;
   }

   tmpTopObj = tmpBotObj = NULL;

   HighLightReverse ();
#ifndef UC
   BreakSel ();
#else /* UC */
   sandWiched = BreakSel ();
#endif /* UC */

   CreateGroupObj (tmpTopObj, tmpBotObj);

   RemoveAllSel ();
   topSel = botSel = (struct SelRec *) calloc (1, sizeof(struct SelRec));
   topSel->obj = topObj;
   topSel->next = topSel->prev = NULL;

#ifndef UC
   if (sandWiched)
       RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
		     selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
   if (sandWiched)
       RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
		     selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   SetFileModified (TRUE);
   justDupped = FALSE;
}

void SelectTopObj ()
{
   if (topObj == NULL) return;

   topSel = botSel = (struct SelRec *) calloc (1, sizeof(struct SelRec));
   topSel->obj = topObj;
   topSel->next = topSel->prev = NULL;
   UpdSelBBox ();

   HighLightForward ();
   justDupped = FALSE;
}
