/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/setup.c,v 2.0 91/03/05 12:48:23 william Exp $";
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "color.e"
#include "cursor.e"
#include "drawing.e"
#include "font.e"
#ifdef UC
#include "file.e"
#include "grid.e"
#include "drawarc.e"
#include "pattern.e"
#endif /* UC */
#include "mainloop.e"
#include "menu.e"
#include "names.e"
#include "raster.e"
#include "ruler.e"
#include "scroll.e"
#include "stk.e"
#include "xbitmap.e"
#ifdef UC
#include "mainmenu.e"
#endif /* UC */
#ifdef KINPUT
#include "kconvert.e"
#endif /* KINPUT */

extern	char	* getenv ();
#ifdef UC
extern void SetFileModified ();
int	defaultDir = FALSE;
char * 	defaultDirStr;
#endif /* UC */

#define MENU_IMAGE_W 64
#define MENU_IMAGE_H 20
#define CHOICE_IMAGE_W 32
#define CHOICE_IMAGE_H 20
#define SCROLLBAR_W 16
#define RULER_W 20
#define BRDR_W 1

#define DRAW_WINDOW_W (5*PIX_PER_INCH)
#define DRAW_WINDOW_H (5*PIX_PER_INCH)
#define CHOICE_WINDOW_W (8*CHOICE_IMAGE_W)
#define CHOICE_WINDOW_H (2*CHOICE_IMAGE_H)
#define VSBAR_H (DRAW_WINDOW_H+RULER_W+2*BRDR_W)
#define HSBAR_W (DRAW_WINDOW_W+RULER_W+2*BRDR_W)
#define TITLE_WINDOW_W (HSBAR_W+SCROLLBAR_W+2*BRDR_W)
#define TITLE_WINDOW_H (MENU_IMAGE_H*2)
#define TOOL_WINDOW_W (TITLE_WINDOW_W+2*BRDR_W)
#define TOOL_WINDOW_H (TITLE_WINDOW_H+CHOICE_WINDOW_H+VSBAR_H+SCROLLBAR_W+8*BRDR_W)
#define MSG_WINDOW_W (TITLE_WINDOW_W-CHOICE_WINDOW_W-2*BRDR_W)
#define MSG_WINDOW_H (CHOICE_WINDOW_H)
#define ICON_WINDOW_W 64
#define ICON_WINDOW_H 80

unsigned int	mainWinW = 0;
unsigned int	mainWinH = 0;
int	vSBarH = VSBAR_H;
int	hSBarW = HSBAR_W;
int	scrollBarW = SCROLLBAR_W;
int	rulerW = RULER_W;
int	brdrW = BRDR_W;
int	msgWindowW = MSG_WINDOW_W;
int	msgWindowH = MSG_WINDOW_H;
int	choiceImageW = CHOICE_IMAGE_W;
int	choiceImageH = CHOICE_IMAGE_H;
int	choiceWindowW = CHOICE_WINDOW_W;
int	choiceWindowH = CHOICE_WINDOW_H;
int	menuImageW = MENU_IMAGE_W;
int	menuImageH = MENU_IMAGE_H;
int	titleWindowW = TITLE_WINDOW_W;
int	titleWindowH = TITLE_WINDOW_H;
int	iconWindowW = ICON_WINDOW_W;
int	iconWindowH = ICON_WINDOW_H;

Display		* mainDisplay;
Colormap	mainColormap;
unsigned int	mainDepth;
int		mainScreen;
Visual		* mainVisual;

Window	rootWindow;
Window	mainWindow;
Window	drawWindow;
Window	choiceWindow;
Window	titleWindow;
Window	msgWindow;
Window	vSBarWindow;
Window	hSBarWindow;
Window	vRuleWindow;
Window	hRuleWindow;
Window	iconWindow;
Window	iconBaseWindow;

int	paperWidth = (75*PIX_PER_INCH)/10;
int	paperHeight = 10*PIX_PER_INCH;
int	drawOrigX = 0;
int	drawOrigY = 0;
int	drawWinW = DRAW_WINDOW_W;
int	drawWinH = DRAW_WINDOW_H;

int	zoomScale = 0;

struct BBRec	drawWinBBox;

int	colorDisplay;
int	fileModified = FALSE;
int	objId = 0;

int	myBgPixel;
int	myFgPixel;
int	myBorderPixel;
int	reverseVideo = FALSE;

char	drawPath[MAXPATHLENGTH];
char	bootDir[MAXPATHLENGTH];
char	homeDir[MAXPATHLENGTH];

int	symPathNumEntries = INVALID;
char	* * symPath;

int	initDrawWinW, initDrawWinH;

static Window	dummyWindow1, dummyWindow2;

void UpdDrawWinWH ()
{
#ifndef UC
   drawWinW = initDrawWinW << zoomScale;
   drawWinH = initDrawWinH << zoomScale;
#else /* UC */
   drawWinW = RealSize(initDrawWinW ,  zoomScale);
   drawWinH = RealSize(initDrawWinH ,  zoomScale);
#endif /* UC */
}

void UpdDrawWinBBox ()
{
   drawWinBBox.ltx = drawOrigX;
   drawWinBBox.lty = drawOrigY;
   drawWinBBox.rbx = drawOrigX + drawWinW-1;
   drawWinBBox.rby = drawOrigY + drawWinH-1;
}

static
void InitWinSizes ()
{
   initDrawWinW = drawWinW;
   initDrawWinH = drawWinH;
   hSBarW = drawWinW+rulerW+2*brdrW;
   vSBarH = drawWinH+rulerW+2*brdrW;
   titleWindowW = hSBarW+scrollBarW+2*brdrW;
   msgWindowW = titleWindowW-choiceWindowW-2*brdrW;
   mainWinW = titleWindowW+2*brdrW;
   mainWinH = titleWindowH+choiceWindowH+vSBarH+scrollBarW+8*brdrW;
}

static
void InverseInitWinSizes ()
   /* derive other win sizes from mainWinW and mainWinH */
{
   titleWindowW = mainWinW-2*brdrW;
   msgWindowW = titleWindowW-choiceWindowW-2*brdrW;
   vSBarH = mainWinH-titleWindowH-choiceWindowH-scrollBarW-8*brdrW;
   hSBarW = titleWindowW-scrollBarW-2*brdrW;
   drawWinH = initDrawWinH = vSBarH-rulerW-2*brdrW;
   drawWinW = initDrawWinW = hSBarW-rulerW-2*brdrW;
}

void mainWinEventHandler (input)
   XEvent	* input;
{
   Window	root_win;
   int		win_x, win_y;
   unsigned int	win_w, win_h, win_brdr_w, win_d;

   if (input->type == UnmapNotify)
      Iconify ();
   else if (input->type == MapNotify)
   {
      if (iconWindowShown) UnIconify ();
   }
   else if (input->type == ConfigureNotify)
   {
      XGetGeometry (mainDisplay, mainWindow, &root_win, &win_x, &win_y, &win_w,
            &win_h, &win_brdr_w, &win_d);
#ifndef UC
      if (win_w == mainWinW && win_h == mainWinH) return;
#else /* UC */
#ifdef DEBUG
      printf ("%d, %d, %d, %d\n" ,win_x, win_y, input->xconfigure.x, input->xconfigure.y);
#endif /* DEBUG */      
      if (win_w == mainWinW && win_h == mainWinH)
      {
	  if (mainMenuWiredDown)
	      MoveMainMenuWindow (input->xconfigure.x, input->xconfigure.y);
	  else
	      SaveMainWinPosition (input->xconfigure.x, input->xconfigure.y);
	  return;
      }
      if (mainMenuWiredDown) MapMainMenuWindows();
#endif /* UC */

      mainWinW = win_w;
      mainWinH = win_h;
      initDrawWinW = mainWinW - rulerW - scrollBarW - 6*brdrW;
      initDrawWinH = mainWinH - titleWindowH - choiceWindowH - rulerW -
            scrollBarW - 10*brdrW;
      drawWinW = initDrawWinW;
      drawWinH = initDrawWinH;
      hSBarW = initDrawWinW + rulerW + 2*brdrW;
      vSBarH = initDrawWinH + rulerW + 2*brdrW;
      titleWindowW = hSBarW + scrollBarW + 2*brdrW;
      msgWindowW = titleWindowW - choiceWindowW - 2*brdrW;
      XResizeWindow (mainDisplay, titleWindow, titleWindowW, titleWindowH);
      XResizeWindow (mainDisplay, msgWindow, msgWindowW, msgWindowH);
      XMoveWindow (mainDisplay, choiceWindow, msgWindowW+2*brdrW,
            titleWindowH+2*brdrW);
      XResizeWindow (mainDisplay, hRuleWindow, drawWinW, rulerW);
      XResizeWindow (mainDisplay, vRuleWindow, rulerW, drawWinH);
      XResizeWindow (mainDisplay, drawWindow, drawWinW, drawWinH);
      XMoveResizeWindow (mainDisplay, vSBarWindow, drawWinW+rulerW+4*brdrW,
            titleWindowH+choiceWindowH+4*brdrW, scrollBarW, vSBarH);
      XMoveResizeWindow (mainDisplay, hSBarWindow, 0,
            titleWindowH+choiceWindowH+rulerW+drawWinH+8*brdrW, hSBarW,
            scrollBarW);
      XMoveWindow (mainDisplay, dummyWindow1, drawWinW+rulerW+4*brdrW,
         titleWindowH+choiceWindowH+rulerW+drawWinH+8*brdrW);
      UpdDrawWinWH ();
      UpdDrawWinBBox ();
      UpdScrollWinWH ();
      SetDefaultDrawWinClipRecs ();
   }
#ifdef UC
  else if (mainMenuWiredDown && (input->type == VisibilityNotify))
  {
      if (input->xvisibility.state == VisibilityUnobscured)
	  MapMainMenuWindows ();
  }
#endif /* UC */
}

void Setup ()
{
   int		bitmask = 0;
   char		* c_ptr;
   Window	root_win;
   int		win_x, win_y;
   unsigned int	win_brdr_w, win_d;
   XWMHints	wmhints;
   XSizeHints	sizehints;

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "Synchronize")) != NULL)
      if ((strcmp (c_ptr, "on") == 0) || (strcmp (c_ptr, "On") == 0))
         XSynchronize (mainDisplay, True);

   colorDisplay = (DisplayPlanes (mainDisplay, mainScreen) == 1) ? FALSE : TRUE;

   InitColor ();

   if ((c_ptr = getenv ("TGIFPATH")) == NULL)
      strcpy (drawPath, TGIF_PATH);
   else
      if (strlen (c_ptr) >= 255)
         strcpy (drawPath, TGIF_PATH);
      else
         strcpy (drawPath, c_ptr);

   if ((c_ptr = getenv ("HOME")) == NULL)
      strcpy (homeDir, "/");
   else
      if (strlen (c_ptr) >= MAXPATHLENGTH-1)
         strcpy (homeDir, "/");
      else
         strcpy (homeDir, c_ptr);

#ifndef UC
#ifndef SYSV
   if (getwd (bootDir) == NULL) strcpy (bootDir, ".");
#else /* SYSV */
   if (getcwd (bootDir,sizeof(bootDir)) == NULL) strcpy (bootDir, ".");
#endif /* SYSV */
#else /* UC */
   if (defaultDir ||
       ((defaultDirStr = XGetDefault (mainDisplay, TOOL_NAME, "CurrentDirectory")) != NULL) ||
       ((defaultDirStr = XGetDefault (mainDisplay, TOOL_NAME, "DefaultDirectory")) != NULL))
   {
       if (defaultDirStr[0] == '~')
       {
	   sprintf (bootDir, "%s%s", homeDir, &defaultDirStr[1]);
       }
       else
       {
	   strcpy (bootDir, &defaultDirStr[0]);
       }
#ifndef R_OK
#define R_OK 0
#endif /* R_OK */       
       if (access(&bootDir[0], R_OK)<0)
       {
	   printf ("Current Directory: %s not found\n", &defaultDirStr[0]);
	   exit (-1);
       }
   }
   else
   {
#ifndef SYSV
       if (getwd (bootDir) == NULL) strcpy (bootDir, ".");
#else /* SYSV */
       if (getcwd (bootDir,sizeof(bootDir)) == NULL) strcpy (bootDir, ".");
#endif /* SYSV */
   }
#endif /* UC */
   
   sizehints.flags = PPosition | PSize | PMinSize;
   sizehints.x = 0;
   sizehints.y = 0;
   sizehints.width = mainWinW;
   sizehints.height = mainWinH;

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "Geometry")) != NULL)
   {
      bitmask = XParseGeometry (c_ptr, &(sizehints.x), &(sizehints.y),
            (unsigned int *)&(sizehints.width),
            (unsigned int *)&(sizehints.height));
      if (bitmask & (XValue | YValue)) sizehints.flags |= USPosition;
      if (bitmask & (WidthValue | HeightValue))
      {
         sizehints.flags |= USSize;
         drawWinW = sizehints.width;
         drawWinH = sizehints.height;
      }
   }

   if (geometrySpecified && *geometrySpec != '\0')
   {
      bitmask = XParseGeometry (geometrySpec, &(sizehints.x), &(sizehints.y),
            (unsigned int *)&(sizehints.width),
            (unsigned int *)&(sizehints.height));
      if (bitmask & (XValue | YValue)) sizehints.flags |= USPosition;
      if (bitmask & (WidthValue | HeightValue))
      {
         sizehints.flags |= USSize;
         drawWinW = sizehints.width;
         drawWinH = sizehints.height;
      }
   }
#ifdef KINPUT
   if (!autoKinput && (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "AutoKinput")) != NULL)
      autoKinput = (strcmp (c_ptr, "on") == 0 || strcmp (c_ptr, "On") == 0);
#endif /* KINPUT */
#ifdef KANJI
   if (noEuc && (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "Euc")) != NULL)
      noEuc = !(strcmp (c_ptr, "on") == 0 || strcmp (c_ptr, "On") == 0);
   if (noKanji && (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "NoKanji")) != NULL)
      noKanji = !(strcmp (c_ptr, "on") == 0 || strcmp (c_ptr, "On") == 0);
#endif /* KANJI */   
#ifdef UC
   if (lineStyle == LS_RIGHT &&
       (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "LineStyle")) != NULL)
   {
       if (strcmp (c_ptr, "PLAIN") == 0)
	   lineStyle = LS_PLAIN;
       else if (strcmp (c_ptr, "LEFT") == 0)
	   lineStyle = LS_LEFT;
       else if (strcmp (c_ptr, "DOUBLE") == 0)
	   lineStyle = LS_DOUBLE;
       else
	   printf ("Warning: unknown line style\n");
   }
   if (!lineWidth &&
       (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "LineWidth")) != NULL)
   {
       if ((lineWidth = atoi(c_ptr)) >= MAXLINEWIDTHS)
       {
	   printf("Warning: line width %d too large. \n", lineWidth);
	   lineWidth = 0;
       }
   }
   if (whereToPrint != LATEX_FIG &&
        (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "WhereToPrint")) != NULL)
      if (strcmp (c_ptr, "LaTeXFigure") == 0)
	  whereToPrint = LATEX_FIG;
   if (!saveWithEps &&
       (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "SaveWithEPS")) != NULL)
       saveWithEps = (strcmp (c_ptr, "on") == 0 || strcmp (c_ptr, "On") == 0);
   if (hideDragCursor && (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "ShowDragCursor")) != NULL)
       hideDragCursor = !(strcmp (c_ptr, "on") == 0 || strcmp (c_ptr, "On") == 0);
   if (!xLibArc && (c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "XLibArc")) != NULL)
      xLibArc = (strcmp (c_ptr, "on") == 0 || strcmp (c_ptr, "On") == 0);
#endif /* UC */

   InitWinSizes ();
   InitFonts ();

   sizehints.min_width = choiceWindowW+4*brdrW+defaultFontWidth;
   sizehints.min_height =
         titleWindowH+choiceWindowH+PIX_PER_INCH+rulerW+scrollBarW+10*brdrW;
   if (mainWinW > sizehints.min_width)
      sizehints.width = mainWinW;
   else
      mainWinW = sizehints.width = sizehints.min_width;
   if (mainWinH > sizehints.min_height)
      sizehints.height = mainWinH;
   else
      mainWinH = sizehints.height = sizehints.min_height;

   InverseInitWinSizes ();

   if (bitmask & XNegative)
      sizehints.x += DisplayWidth (mainDisplay, mainScreen) - mainWinW - 1;
   if (bitmask & YNegative)
      sizehints.y += DisplayHeight (mainDisplay, mainScreen) - mainWinH - 1;

   if ((mainWindow = XCreateSimpleWindow (mainDisplay, rootWindow,
         sizehints.x, sizehints.y, sizehints.width, sizehints.height,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create main window!\n"); exit(1); }

   XSetNormalHints (mainDisplay, mainWindow, &sizehints);
   XStoreName (mainDisplay, mainWindow, TOOL_NAME);
   XGetGeometry (mainDisplay, mainWindow, &root_win, &win_x, &win_y, &mainWinW,
         &mainWinH, &win_brdr_w, &win_d);

   CreateCursor ();
   InitScroll ();
   InitPattern ();
   InitRuler ();
   InitMenu ();
   InitNames ();
   InitStk ();
   InitXBm ();

   if ((titleWindow = XCreateSimpleWindow (mainDisplay, mainWindow, 0, 0,
         titleWindowW, titleWindowH, brdrW, myBorderPixel, myBgPixel)) == 0) 
   { printf ("Could not create menu window!\n"); exit(1); }

   if ((msgWindow = XCreateSimpleWindow (mainDisplay, mainWindow, 0,
         titleWindowH+2*brdrW, msgWindowW, msgWindowH, brdrW, myBorderPixel,
         myBgPixel)) == 0)
   { printf ("Could not create message window!\n"); exit(1); }

   if ((choiceWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
         msgWindowW+2*brdrW, titleWindowH+2*brdrW, choiceWindowW, choiceWindowH,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create choice window!\n"); exit(1); }

   InitChoice ();

   if ((hRuleWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
         rulerW+2*brdrW, titleWindowH+choiceWindowH+4*brdrW, drawWinW, rulerW,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create horizontal ruler window!\n"); exit(1); }

   if ((vRuleWindow = XCreateSimpleWindow (mainDisplay, mainWindow, 0,
         titleWindowH+rulerW+choiceWindowH+6*brdrW, rulerW, drawWinH,
         brdrW, myBorderPixel, myBgPixel)) == 0)
   { printf ("Could not create vertical ruler window!\n"); exit(1); }

   if ((drawWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
         rulerW+2*brdrW, titleWindowH+rulerW+choiceWindowH+6*brdrW,
         drawWinW, drawWinH, brdrW, myBorderPixel, myBgPixel)) == 0) 
   { printf ("Could not create draw window!\n"); exit(1); }

   if ((vSBarWindow = XCreateSimpleWindow (mainDisplay, mainWindow,
         4*brdrW+rulerW+drawWinW, titleWindowH+choiceWindowH+4*brdrW,
         scrollBarW, vSBarH, brdrW, myBorderPixel, myBgPixel)) == 0) 
   { printf ("Could not create vertical scrollbar window!\n"); exit(1); }

   if ((hSBarWindow = XCreateSimpleWindow (mainDisplay, mainWindow, 0,
         titleWindowH+rulerW+drawWinH+choiceWindowH+8*brdrW,
         hSBarW, scrollBarW, brdrW, myBorderPixel, myBgPixel)) == 0) 
   { printf ("Could not create horizontal scrollbar window!\n"); exit(1); }

   if ((dummyWindow1 = XCreateSimpleWindow (mainDisplay, mainWindow,
         rulerW+drawWinW+4*brdrW,
         titleWindowH+choiceWindowH+rulerW+drawWinH+8*brdrW,
         scrollBarW, scrollBarW, brdrW, myBorderPixel, myBgPixel)) == 0) 
   { printf ("Could not create dummy window!\n"); exit(1); }

   if ((dummyWindow2 = XCreateSimpleWindow (mainDisplay, mainWindow, 0,
         titleWindowH+choiceWindowH+4*brdrW, rulerW, rulerW,
         brdrW, myBorderPixel, myBgPixel)) == 0) 
   { printf ("Could not create dummy window!\n"); exit(1); }

   UpdDrawWinBBox ();
   InitTitle ();
   SetCanvasFont ();
#ifdef UC
   SetFileModified (FALSE);
#endif /* UC */

   XMapWindow (mainDisplay, mainWindow);
#ifndef UC
   XSelectInput (mainDisplay, mainWindow, KeyPressMask | StructureNotifyMask);
#else /* UC */
   XSelectInput (mainDisplay, mainWindow, KeyPressMask | StructureNotifyMask
		 | VisibilityChangeMask);
#endif /* UC */
   XDefineCursor (mainDisplay, mainWindow, defaultCursor);

   XMapWindow (mainDisplay, titleWindow);
   XSelectInput (mainDisplay, titleWindow, ExposureMask);

   XMapWindow (mainDisplay, msgWindow);
   XSelectInput (mainDisplay, msgWindow, ButtonPressMask | ExposureMask);

   XMapWindow (mainDisplay, choiceWindow);
   XSelectInput (mainDisplay, choiceWindow,
         ButtonReleaseMask | ButtonPressMask | ExposureMask);

   XMapWindow (mainDisplay, hRuleWindow);
   XSelectInput (mainDisplay, hRuleWindow, ExposureMask);
   XMapWindow (mainDisplay, vRuleWindow);
   XSelectInput (mainDisplay, vRuleWindow, ExposureMask);

   XMapWindow (mainDisplay, drawWindow); 
   XSelectInput (mainDisplay, drawWindow, ButtonReleaseMask |
         ButtonPressMask | PointerMotionMask | KeyPressMask | ExposureMask);

   XMapWindow (mainDisplay, vSBarWindow);
   XSelectInput (mainDisplay, vSBarWindow, ButtonPressMask | ExposureMask);
   XMapWindow (mainDisplay, hSBarWindow);
   XSelectInput (mainDisplay, hSBarWindow, ButtonPressMask | ExposureMask);
   XMapWindow (mainDisplay, dummyWindow1);
   XMapWindow (mainDisplay, dummyWindow2);

   wmhints.flags = InputHint;
   wmhints.input = True;
   XSetWMHints (mainDisplay, mainWindow, &wmhints);
   XSetWMHints (mainDisplay, drawWindow, &wmhints);
#ifdef KANJI
  InitKanji ();
#endif /* KANJI */
}

int TieLooseEnds ()
   /* returns TRUE if something got created */
   /* returns FALSE otherwise */
{
   if (curChoice == DRAWTEXT) return (CreateTextObj ());
   return (FALSE);
}

void SetFileModified (modified)
   int	modified;
{
   if (modified != fileModified)
   {
      fileModified = modified;
      RedrawTitleWindow ();
   }
}
