#ifdef UC
/*
 * Author:	Kou1 Ma2da (matsuda@ccs.mt.nec.co.jp)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#include <math.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "grid.e"
#include "raster.e"
#include "setup.e"

#define	SIZESTRINGLEN 20

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

 int	showSize = FALSE;
char	savedSizeString[SIZESTRINGLEN + 1];
int 	strLen = SIZESTRINGLEN;
int	prevX, prevY;

struct XYOffsetRec
{
    int x, y;
};

struct XYOffsetRec XYOffset[] =
    /*   LEFTUP,     UP,       RIGHTUP,    RIGHT, */
	{-10, -10,   0, -10,   10, -10,    10, 0,
    /*   RIGHTDOWN,  DOWN,     LEFTDOWN,   LEFT */	     
	  10, 0,     0, -10,   10, -10,    10, 0};

void eraseSizeString ()
{
    XDrawString (mainDisplay, drawWindow, revDefaultGC2, prevX, prevY,
		 savedSizeString, strLen);
}

void showAngle (x, y, angle2)
int x, y, angle2;
{
    double angle = (double) abs (angle2) / 64.0;
    
    sprintf (savedSizeString, "%5.1f(%5.1f%%)",
	     angle, angle * 100.0 / 360.0);
    strLen = strlen(savedSizeString);
    prevX = x; prevY = y;
    XDrawString (mainDisplay, drawWindow, revDefaultGC2,
		 prevX, prevY, savedSizeString, SIZESTRINGLEN);
}

void showLength (x1, y1, x2, y2, corner)
int x1, y1, x2, y2, corner;
{
    double angle;
    double dx = RealSize((x2 - x1), zoomScale), dy = RealSize((y2 - y1), zoomScale);

    angle = (dx||dy)?(atan2(dy, dx)*180/M_PI):0.0;
    angle = (angle>=0.0)?((angle)?360-angle:0.0):(-angle);
    sprintf(savedSizeString, "%6.3f(%5.1f)",
	    sqrt (dx * dx + dy * dy) / PIX_PER_INCH_OR_CM, angle);
    strLen = strlen(savedSizeString);
    prevX = x2 + XYOffset[corner].x; prevY = y2 + XYOffset[corner].y;    
    XDrawString (mainDisplay, drawWindow, revDefaultGC2, prevX, prevY,
		 savedSizeString, strLen);
}

void showPoint (x, y, corner)
int x, y, corner;
{
    sprintf (savedSizeString, "(%5.2f,%5.2f)",
	     ((double)(RealSize(x, zoomScale)))/PIX_PER_INCH_OR_CM,
	     ((double)(RealSize(y, zoomScale)))/PIX_PER_INCH_OR_CM);
    strLen = strlen(savedSizeString);
    prevX = x + XYOffset[corner].x; prevY = y  + XYOffset[corner].y;
    XDrawString (mainDisplay, drawWindow, revDefaultGC2, prevX, prevY,
		 savedSizeString, strLen);
}    

void showHeightWidth (x1, y1, x2, y2, corner)
int x1, y1, x2, y2, corner;
{
    double dx = ((double)(RealSize((x2 - x1), zoomScale)))/PIX_PER_INCH_OR_CM; 
    double dy = ((double)(RealSize((y2 - y1), zoomScale)))/PIX_PER_INCH_OR_CM; 
    
    sprintf(savedSizeString, "%6.3fx%6.3f", fabs(dy), fabs(dx));
    strLen = strlen(savedSizeString);
    prevX = x2 + XYOffset[corner].x; prevY = y2 + XYOffset[corner].y;    
    XDrawString (mainDisplay, drawWindow, revDefaultGC2, prevX, prevY,
		 savedSizeString, strLen);
}    
#endif /* UC */
