/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/special.c,v 2.0 91/03/05 12:48:26 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "animate.e"
#include "attr.e"
#include "choice.e"
#include "color.e"
#include "cursor.e"
#include "dialog.e"
#include "drawing.e"
#include "dup.e"
#include "edit.e"
#include "file.e"
#include "grid.e"
#include "group.e"
#include "mark.e"
#include "msg.e"
#include "move.e"
#include "names.e"
#include "obj.e"
#include "raster.e"
#include "select.e"
#include "setup.e"
#include "stk.e"
#ifdef KINPUT
#include "kconvert.e"
#endif /* KINPUT */

#define SPECIAL_SYM 0
#define SPECIAL_UNSYM 1
#define SPECIAL_INST 2
#define SPECIAL_ICON 3
#define SPECIAL_UNICON 4
#define SPECIAL_PUSH 5
#define SPECIAL_POP 6
#define SPECIAL_ADDATTR 7
#define SPECIAL_DETACHATTR 8
#define SPECIAL_SHOWATTRNAME 9
#define SPECIAL_HIDEATTRNAME 10
#define SPECIAL_MOVEATTR 11
#define SPECIAL_ANIMATESEND 12
#define SPECIAL_ANIMATEFLASH 13
#define SPECIAL_UPDATESYMS 14
#ifndef KINPUT
#define MAXSPECIALMENUS 15
#else /* KINPUT */
#define SPECIAL_AUTOKINPUT 15

#define MAXSPECIALMENUS 16
#endif /* KINPUT */

static char * specialMenuStr[] =
{
   "MakeSymbolic   ^#M",
   "UnMakeSymbolic ^#N",
   "Instantiate     ^I",
   "MakeIconic     ^#I",
   "UnMakeIconic   ^#J",
   "Push            ^V",
   "Pop             ^K",
   "AddAttr         #A",
   "DetachAttrs     #T",
   "ShowAttrName    #N",
   "HideAttrName    #J",
   "MoveAttr        #M",
   "AnimateSend     #E",
   "AnimateFlash    #F",
#ifndef KINPUT
   "UpdateSymbols  ^#U"
#else /* UC */
   "UpdateSymbols  ^#U",
   "AutoKinput ON   ^;"
#endif /* KINPUT */
};

#ifdef KINPUT
void ToggleAutoKinput ()
{
     
	autoKinput = ! autoKinput;
}
#endif /* KINPUT */
struct ObjRec * ReadSymbol (FP)
   FILE	* FP;
{
   register struct AttrRec	* attr_ptr;
   struct ObjRec		* obj_ptr;

   importingFile = TRUE; /* ignore 'state' info but set fileVersion */
   while (ReadObj (FP, &obj_ptr, FALSE))
      if (obj_ptr != NULL)
      {
         if (obj_ptr->type == OBJ_SYM)
         {
            obj_ptr->type = OBJ_ICON;
            attr_ptr = obj_ptr->lattr;
            for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->prev)
               attr_ptr->inherited = TRUE;
            importingFile = FALSE;
            return (obj_ptr);
         }
         else
            FreeObj (obj_ptr);
      }
   importingFile = FALSE;
   return (NULL);
}

struct ObjRec * GetObjRepresentation (PathName, SymName)
   char	* PathName, * SymName;
{
   char			file_name[MAXPATHLENGTH];
   struct ObjRec	* obj_ptr;
   FILE			* fp;

   sprintf (file_name, "%s/%s.sym", PathName, SymName);
   if ((fp = fopen (file_name, "r")) == NULL)
   { printf ("Can not open '%s'\n", file_name); return (NULL); }

   if ((obj_ptr = ReadSymbol (fp)) != NULL)
   {
      obj_ptr->id = objId++;
      obj_ptr->dirty = FALSE;
      strcpy (obj_ptr->detail.r->s, SymName);
      AdjObjBBox (obj_ptr);
   }
   fclose (fp);
   return (obj_ptr);
}

void PlaceTopObj ()
{
   int		x, y, grid_x, grid_y, dx, dy, placing = TRUE;
   int		cursor_x, cursor_y, orig_x, orig_y;
   int		obj_ltx, obj_lty, obj_rbx, obj_rby;
   int		grid_obj_ltx, grid_obj_lty, grid_dx, grid_dy;
   Window	root_win, child_win;
   int		root_x, root_y;
   unsigned int	status;
   XEvent	input;

   while (TRUE)
   {
      XQueryPointer (mainDisplay, drawWindow, &root_win, &child_win,
            &root_x, &root_y, &cursor_x, &cursor_y, &status);
      if (!(status & (Button1Mask | Button2Mask | Button3Mask))) break;
   }

   GridXY (cursor_x, cursor_y, &orig_x, &orig_y);
   obj_ltx = OFFSET_X(topObj->obbox.ltx); obj_lty = OFFSET_Y(topObj->obbox.lty);
   obj_rbx = OFFSET_X(topObj->obbox.rbx); obj_rby = OFFSET_Y(topObj->obbox.rby);
   GridXY (obj_ltx, obj_lty, &grid_obj_ltx, &grid_obj_lty);
   grid_dx = orig_x-grid_obj_ltx; grid_dy = orig_y-grid_obj_lty;
   SelBox (drawWindow, revDefaultGC, obj_ltx+grid_dx, obj_lty+grid_dy,
         obj_rbx+grid_dx, obj_rby+grid_dy);

   dx = dy = 0;
   XGrabPointer (mainDisplay, drawWindow, FALSE,
         PointerMotionMask | ButtonPressMask,
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);

   while (placing)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonPress)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         placing = FALSE;
         SelBox (drawWindow, revDefaultGC, obj_ltx+grid_dx+dx,
               obj_lty+grid_dy+dy, obj_rbx+grid_dx+dx, obj_rby+grid_dy+dy);
#ifndef UC
         grid_dx = (grid_dx+dx)<<zoomScale;
         grid_dy = (grid_dy+dy)<<zoomScale;
#else /* UC */
         grid_dx = RealSize((grid_dx+dx), zoomScale);
         grid_dy = RealSize((grid_dy+dy), zoomScale);
#endif /* UC */
         MoveObj (topObj, grid_dx, grid_dy);
         DrawObj (drawWindow, topObj);
      }
      else if (input.type == MotionNotify)
      {
         x = input.xmotion.x;
         y = input.xmotion.y;
         GridXY (x, y, &grid_x, &grid_y);
         SelBox (drawWindow, revDefaultGC, obj_ltx+grid_dx+dx,
               obj_lty+grid_dy+dy, obj_rbx+grid_dx+dx, obj_rby+grid_dy+dy);
         dx = grid_x - orig_x;
         dy = grid_y - orig_y;
         SelBox (drawWindow, revDefaultGC, obj_ltx+grid_dx+dx,
               obj_lty+grid_dy+dy, obj_rbx+grid_dx+dx, obj_rby+grid_dy+dy);
         MarkRulers (grid_x, grid_y);
      }
   }
   XSync (mainDisplay, True);
}

void Instantiate ()
{
   char			file_name[MAXPATHLENGTH];
   char			sym_name[MAXPATHLENGTH], path_name[MAXPATHLENGTH];
   struct ObjRec	* obj_ptr;
   FILE			* fp;

   if (SelectSymbolName (sym_name, path_name) == INVALID) return;

   TieLooseEnds ();
   SetCurChoice (NOTHING);

   sprintf (file_name, "%s/%s.sym", path_name, sym_name);
   if ((fp = fopen (file_name, "r")) == NULL)
   { printf ("Can not open %s\n", file_name); return; }

   if ((obj_ptr = ReadSymbol (fp)) != NULL)
   {
      if (topSel != NULL)
      {
         HighLightReverse ();
         RemoveAllSel ();
      }
      SetNullCursor (drawWindow);

      obj_ptr->id = objId++;
      obj_ptr->dirty = FALSE;
      strcpy (obj_ptr->detail.r->s, sym_name);
      AddObj (NULL, topObj, obj_ptr);
      AdjObjBBox (obj_ptr);

      PlaceTopObj ();
      SelectTopObj ();
      SetFileModified (TRUE);
      justDupped = FALSE;
      ShowCursor ();
   }
   fclose (fp);
}

void MakeSymbolic ()
{
   if (topSel!=NULL && topSel==botSel &&
      (topSel->obj->type==OBJ_GROUP || topSel->obj->type==OBJ_ICON))
   {
      HighLightReverse ();
      topSel->obj->type = OBJ_SYM;
      Msg ("Selected GROUP object is now SYMBOLIC.");
      SetFileModified (TRUE);
      AdjObjBBox (topSel->obj);
      UpdSelBBox ();
      RedrawAnArea (botObj,
#ifndef UC
            botSel->obj->obbox.ltx-QUARTER_INCH-(1<<zoomScale),
            botSel->obj->obbox.lty-QUARTER_INCH-(1<<zoomScale),
            botSel->obj->obbox.rbx+QUARTER_INCH+(1<<zoomScale),
            botSel->obj->obbox.rby+QUARTER_INCH+(1<<zoomScale));
#else /* UC */
            botSel->obj->obbox.ltx-QUARTER_INCH-(RealSize(1, zoomScale)),
            botSel->obj->obbox.lty-QUARTER_INCH-(RealSize(1, zoomScale)),
            botSel->obj->obbox.rbx+QUARTER_INCH+(RealSize(1, zoomScale)),
            botSel->obj->obbox.rby+QUARTER_INCH+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
   else
      Msg ("Please select one GROUP or ICON object to make it Symbolic.");
}

void UnMakeSymbolic ()
{
   register struct ObjRec	* obj_ptr;
   register int			ltx = 0, lty = 0, rbx = 0, rby = 0;
   struct SelRec		* sel_ptr = topSel;
   int				modified = FALSE;

   for ( ; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      if (obj_ptr->type == OBJ_SYM)
      {
         obj_ptr->type = OBJ_GROUP;
         AdjObjBBox (obj_ptr);
         if (modified)
         {
            if (ltx < obj_ptr->bbox.ltx) ltx = obj_ptr->bbox.ltx;
            if (lty < obj_ptr->bbox.lty) lty = obj_ptr->bbox.lty;
            if (rbx > obj_ptr->bbox.rbx) rbx = obj_ptr->bbox.rbx;
            if (rby > obj_ptr->bbox.rby) rby = obj_ptr->bbox.rby;
         }
         else
         {
            ltx = obj_ptr->bbox.ltx; lty = obj_ptr->bbox.lty;
            rbx = obj_ptr->bbox.rbx; rby = obj_ptr->bbox.rby;
            modified = TRUE;
         }
      }
   }
   if (modified)
   {
      HighLightReverse ();
      SetFileModified (TRUE);
      UpdSelBBox ();
      RedrawAnArea (botObj,
#ifndef UC
            ltx-QUARTER_INCH-(1<<zoomScale), lty-QUARTER_INCH-(1<<zoomScale),
            rbx+QUARTER_INCH+(1<<zoomScale), rby+QUARTER_INCH+(1<<zoomScale));
#else /* UC */
            ltx-QUARTER_INCH-(RealSize(1, zoomScale)), lty-QUARTER_INCH-(RealSize(1, zoomScale)),
            rbx+QUARTER_INCH+(RealSize(1, zoomScale)), rby+QUARTER_INCH+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
}

void MakeIconic ()
{
   char 		icon_name[MAXPATHLENGTH], file_name[MAXPATHLENGTH];
   char 		s[MAXPATHLENGTH], icon_full_name[MAXPATHLENGTH];
   FILE			* fp;
   struct ObjRec	* saved_obj_ptr;
   int			len;

   if (topSel!=NULL && topSel==botSel && topSel->obj->type==OBJ_GROUP)
   {
      Dialog ("Please Enter Name of the Icon:", icon_name);
      len = strlen (icon_name);
      if (*icon_name == '\0')
      {
         Msg ("Name not specified, icon not created.");
         return;
      }

      if (strlen (icon_name) >= 4)
      {
         if (strcmp (&icon_name[len-4], ".obj") == 0)
         {
            Msg ("Can not save as a .obj file, icon not created.");
            return;
         }
         else if (strcmp (&icon_name[len-4], ".sym") != 0)
         {
            strcpy (icon_full_name, icon_name);
            strcat (icon_full_name, ".sym");
         }

         if (strlen (icon_full_name) == 4)
         {
            Msg ("No file name specified.  File not saved.");
            return;
         }
      }
      else
      {
         strcpy (icon_full_name, icon_name);
         strcat (icon_full_name, ".sym");
      }

      if (*curDomainName != '\0')
         sprintf (file_name, "%s/%s", curDomainName, icon_full_name);
      else
         sprintf (file_name, "%s", icon_full_name);
      if (!OkayToCreateFile (file_name)) return;
      if ((fp = fopen (file_name, "w")) == NULL)
      {
         sprintf (s, "Can not create '%s', icon not created.", file_name);
         Msg (s);
         return;
      }
      sprintf (s, "Creating '%s' ...", file_name);
      Msg (s);
      topSel->obj->type = OBJ_SYM;
      strcpy (topSel->obj->detail.r->s, icon_name);

      saved_obj_ptr = topSel->obj->prev;
      topSel->obj->prev = NULL;
      Save (fp, topSel->obj, 0);
      topSel->obj->prev = saved_obj_ptr;

      sprintf (s, "File '%s' created.", file_name);
      Msg (s);
      fclose (fp);

      HighLightReverse ();
      topSel->obj->type = OBJ_ICON;
      topSel->obj->id = objId++;
      Msg ("Selected GROUP object is now ICONIC.");
      SetFileModified (TRUE);
      AdjObjBBox (topSel->obj);
      UpdSelBBox ();
      RedrawAnArea (botObj,
#ifndef UC
            botSel->obj->bbox.ltx-(1<<zoomScale),
            botSel->obj->bbox.lty-(1<<zoomScale),
            botSel->obj->bbox.rbx+(1<<zoomScale),
            botSel->obj->bbox.rby+(1<<zoomScale));
#else /* UC */
            botSel->obj->bbox.ltx-(RealSize(1, zoomScale)),
            botSel->obj->bbox.lty-(RealSize(1, zoomScale)),
            botSel->obj->bbox.rbx+(RealSize(1, zoomScale)),
            botSel->obj->bbox.rby+(RealSize(1, zoomScale)));
#endif /* UC */
      HighLightForward ();
   }
   else
      Msg ("Please select one GROUP object to make it ICONIC.");
}

void UnMakeIconic ()
{
   register struct ObjRec	* obj_ptr;
   struct SelRec		* sel_ptr;
   struct AttrRec		* attr_ptr;
   int				modified = FALSE;

   HighLightReverse ();
   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      if (obj_ptr->type == OBJ_ICON)
      {
         obj_ptr->type = OBJ_GROUP;
         AdjObjBBox (obj_ptr);
         modified = TRUE;
         attr_ptr = obj_ptr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            attr_ptr->inherited = FALSE;
      }
   }
   if (modified)
   {
      Msg ("Selected ICONIC objects are GROUP objects now.");
      SetFileModified (TRUE);
      UpdSelBBox ();
#ifndef UC
      RedrawAnArea (botObj, selLtX-(1<<zoomScale), selLtY-(1<<zoomScale),
            selRbX+(1<<zoomScale), selRbY+(1<<zoomScale));
#else /* UC */
      RedrawAnArea (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
            selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   }
   HighLightForward ();
}

void SpecialMenu (X, Y)
   int	X, Y;
{
   register int	index;
   int		* fore_colors, * valid;

#ifdef KINPUT
   if (autoKinput)
       strcpy (&specialMenuStr[SPECIAL_AUTOKINPUT][0],
	       "AutoKinput OFF  ^;");
   else
       strcpy (&specialMenuStr[SPECIAL_AUTOKINPUT][0],
	       "AutoKinput ON   ^;");
#endif /* KINPUT */
   DefaultColorArrays (MAXSPECIALMENUS, &fore_colors, &valid);
   index = TextMenuLoop (X, Y, specialMenuStr, MAXSPECIALMENUS, fore_colors,
#ifndef UC
         valid, SINGLECOLOR);
#else /* UC */
         valid, SINGLECOLOR, MENU_SPECIAL);
#endif /* UC */
   switch (index)
   {
      case SPECIAL_SYM: MakeSymbolic (); break;
      case SPECIAL_UNSYM: UnMakeSymbolic (); break;
      case SPECIAL_INST: Instantiate (); break;
      case SPECIAL_ICON: MakeIconic (); break;
      case SPECIAL_UNICON: UnMakeIconic (); break;
      case SPECIAL_PUSH: PushIcon (); break;
      case SPECIAL_POP: PopIcon (); break;
      case SPECIAL_ADDATTR: AddAttrs (); break;
      case SPECIAL_SHOWATTRNAME: ShowAllAttrNames (); break;
      case SPECIAL_HIDEATTRNAME: HideAllAttrNames (); break;
      case SPECIAL_DETACHATTR: DetachAttrs (); break;
      case SPECIAL_MOVEATTR: MoveAttr (); break;
      case SPECIAL_ANIMATESEND: AnimateSel (); break;
      case SPECIAL_ANIMATEFLASH: FlashSelColor (); break;
      case SPECIAL_UPDATESYMS: UpdateSymbols (); break;
#ifdef KINPUT
      case SPECIAL_AUTOKINPUT: ToggleAutoKinput (); break;
#endif /* KINPUT */
   }
}
