/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/spline.c,v 2.0 91/03/05 12:48:28 william Exp $";
#endif

#include <math.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "poly.e"
#include "raster.e"
#include "rect.e"
#include "setup.e"

#define SPLINE_TOL 9

void Spline (Win, Pixel, Func, X1, Y1, X2, Y2, X3, Y3, X4, Y4)
   Window	Win;
   int		Pixel, Func;
   double	X1, Y1, X2, Y2, X3, Y3, X4, Y4;
   /* X1, Y1, X2, Y2, X3, Y3, X4, Y4 are screen offsets */
{
   double	x, y;

   x = (X2 + X3) / 2.0;
   y = (Y2 + Y3) / 2.0;
   if (fabs (X1 - x) < SPLINE_TOL && fabs (Y1 - y) < SPLINE_TOL)
      XDrawLine (mainDisplay, Win, drawGC, round(X1), round(Y1), round(x),
            round(y));
   else
      Spline (Win, Pixel, Func, X1, Y1, ((X1+X2)/2.0), ((Y1+Y2)/2.0),
            ((3.0*X2+X3)/4.0), ((3.0*Y2+Y3)/4.0), x, y);

   if (fabs (x - X4) < SPLINE_TOL && fabs (y - Y4) < SPLINE_TOL)
      XDrawLine (mainDisplay, Win, drawGC, round(x), round(y), round(X4),
            round(Y4));
   else
      Spline (Win, Pixel, Func, x, y, ((X2+3.0*X3)/4.0), ((Y2+3.0*Y3)/4.0),
            ((X3+X4)/2.0), ((Y3+Y4)/2.0), X4, Y4);
}

static XPoint	* splineVs;

int AddSplinePt(N, MaxN, X, Y)
   int		* N, * MaxN, X, Y;
{
   if (*N == *MaxN)
   {
      splineVs = (XPoint *) realloc (splineVs, (*MaxN)*2*sizeof(XPoint));
      if (splineVs == NULL)
      {
         printf ("Can not realloc() in AddSplinePt ()\n");
         return (FALSE);
      }
      *MaxN = (*MaxN) * 2;
   }
   splineVs[*N].x = X;
   splineVs[*N].y = Y;
   (*N)++;
}

static
void SetSplineVs (N, MaxN, X1, Y1, X2, Y2, X3, Y3, X4, Y4)
   int		* N, * MaxN;
   double	X1, Y1, X2, Y2, X3, Y3, X4, Y4;
   /* X1, Y1, X2, Y2, X3, Y3, X4, Y4 are screen offsets */
{
   double	x, y;

   x = (X2 + X3) / 2.0;
   y = (Y2 + Y3) / 2.0;
   if (fabs (X1 - x) < SPLINE_TOL && fabs (Y1 - y) < SPLINE_TOL)
      AddSplinePt (N, MaxN, round(x), round(y));
   else
      SetSplineVs (N, MaxN, X1, Y1, ((X1+X2)/2.0), ((Y1+Y2)/2.0),
            ((3.0*X2+X3)/4.0), ((3.0*Y2+Y3)/4.0), x, y);

   if (fabs (x - X4) < SPLINE_TOL && fabs (y - Y4) < SPLINE_TOL)
      AddSplinePt (N, MaxN, round(X4), round(Y4));
   else
      SetSplineVs (N, MaxN, x, y, ((X2+3.0*X3)/4.0), ((Y2+3.0*Y3)/4.0),
            ((X3+X4)/2.0), ((Y3+Y4)/2.0), X4, Y4);
}

XPoint * MakeSplinePolyVertex (N, XOff, YOff, NumVs, Vs)
   int		* N, XOff, YOff, NumVs;
   XPoint	* Vs;
{
   double	mx1, my1, mx2, my2, mx3, my3, mx4, my4, x1, y1, x2, y2;
   int		i, x_off, y_off, max_n;

#ifndef UC
   x_off = (XOff >> zoomScale) << zoomScale;
   y_off = (YOff >> zoomScale) << zoomScale;
#else /* UC */
   x_off = RealSize((ScreenSize(XOff ,  zoomScale)) ,  zoomScale);
   y_off = RealSize((ScreenSize(YOff ,  zoomScale)) ,  zoomScale);
#endif /* UC */

   switch (NumVs)
   {
      case 0:
      case 1:
         break;
      case 2:
         splineVs = (XPoint *) calloc (3, sizeof (XPoint));
#ifndef UC
         splineVs[0].x = (Vs[0].x-x_off)>>zoomScale;
         splineVs[0].y = (Vs[0].y-y_off)>>zoomScale;
         splineVs[1].x = (Vs[1].x-x_off)>>zoomScale;
         splineVs[1].y = (Vs[1].y-y_off)>>zoomScale;
#else /* UC */
         splineVs[0].x = ScreenSize((Vs[0].x-x_off), zoomScale);
         splineVs[0].y = ScreenSize((Vs[0].y-y_off), zoomScale);
         splineVs[1].x = ScreenSize((Vs[1].x-x_off), zoomScale);
         splineVs[1].y = ScreenSize((Vs[1].y-y_off), zoomScale);
#endif /* UC */
         *N = 2;
         break;
      case 3:
#ifndef UC
         mx1 = (Vs->x-x_off)>>zoomScale; my1 = ((Vs++)->y-y_off)>>zoomScale;
         x1 = (Vs->x-x_off)>>zoomScale;  y1 = ((Vs++)->y-y_off)>>zoomScale;
         mx2 = (mx1+x1)/2.0;            my2 = (my1+y1)/2.0;
         mx4 = (Vs->x-x_off)>>zoomScale; my4 = (Vs->y-y_off)>>zoomScale;
#else /* UC */
         mx1 = ScreenSize((Vs->x-x_off), zoomScale); my1 = ScreenSize(((Vs++)->y-y_off), zoomScale);
         x1 = ScreenSize((Vs->x-x_off), zoomScale);  y1 = ScreenSize(((Vs++)->y-y_off), zoomScale);
         mx2 = (mx1+x1)/2.0;            my2 = (my1+y1)/2.0;
         mx4 = ScreenSize((Vs->x-x_off), zoomScale); my4 = ScreenSize((Vs->y-y_off), zoomScale);
#endif /* UC */
         mx3 = (x1+mx4)/2.0;            my3 = (y1+my4)/2.0;
         max_n = 100;
         splineVs = (XPoint *) calloc (max_n, sizeof (XPoint));
         splineVs[0].x = mx1;
         splineVs[0].y = my1;
         *N = 1;
         SetSplineVs (N, &max_n, mx1, my1, mx2, my2, mx3, my3, mx4, my4);
         break;
      default:
#ifndef UC
         mx1 = (Vs->x-x_off)>>zoomScale; my1 = ((Vs++)->y-y_off)>>zoomScale;
         x1 = (Vs->x-x_off)>>zoomScale;  y1 = ((Vs++)->y-y_off)>>zoomScale;
         x2 = (Vs->x-x_off)>>zoomScale;  y2 = ((Vs++)->y-y_off)>>zoomScale;
#else /* UC */
         mx1 = ScreenSize((Vs->x-x_off), zoomScale); my1 = ScreenSize(((Vs++)->y-y_off), zoomScale);
         x1 = ScreenSize((Vs->x-x_off), zoomScale);  y1 = ScreenSize(((Vs++)->y-y_off), zoomScale);
         x2 = ScreenSize((Vs->x-x_off), zoomScale);  y2 = ScreenSize(((Vs++)->y-y_off), zoomScale);
#endif /* UC */
         mx2 = (mx1+x1)/2.0;            my2 = (my1+y1)/2.0;
         mx3 = (3.0*x1+x2)/4.0;         my3 = (3.0*y1+y2)/4.0;
         mx4 = (x1+x2)/2.0;             my4 = (y1+y2)/2.0;
         max_n = 100;
         splineVs = (XPoint *) calloc (max_n, sizeof (XPoint));
         splineVs[0].x = mx1;
         splineVs[0].y = my1;
         *N = 1;
         SetSplineVs (N, &max_n, mx1, my1, mx2, my2, mx3, my3, mx4, my4);
      
         for (i = 2; i < NumVs-2; i++, Vs++)
         {
            mx1 = mx4;                    my1 = my4;
            mx2 = (x1 + 3.0*x2) / 4.0;    my2 = (y1 + 3.0*y2) / 4.0;
            x1 = x2;                      y1 = y2;
#ifndef UC
            x2 = (Vs->x-x_off)>>zoomScale; y2 = (Vs->y-y_off)>>zoomScale;
#else /* UC */
            x2 = ScreenSize((Vs->x-x_off), zoomScale); y2 = ScreenSize((Vs->y-y_off), zoomScale);
#endif /* UC */
            mx3 = (3.0*x1 + x2) / 4.0;    my3 = (3.0*y1 + y2) / 4.0;
            mx4 = (x1 + x2) / 2.0;        my4 = (y1 + y2) / 2.0;
            SetSplineVs (N, &max_n, mx1, my1, mx2, my2, mx3, my3, mx4, my4);
         }
         mx1 = mx4;                     my1 = my4;
         mx2 = (x1 + 3.0*x2) / 4.0;     my2 = (y1 + 3.0*y2) / 4.0;
         x1 = x2;                       y1 = y2;
#ifndef UC
         mx4 = (Vs->x-x_off)>>zoomScale; my4 = (Vs->y-y_off)>>zoomScale;
#else /* UC */
         mx4 = ScreenSize((Vs->x-x_off), zoomScale); my4 = ScreenSize((Vs->y-y_off), zoomScale);
#endif /* UC */
         mx3 = (x1 + mx4) / 2.0;        my3 = (y1 + my4) / 2.0;
         SetSplineVs (N, &max_n, mx1, my1, mx2, my2, mx3, my3, mx4, my4);
         break;
   }
   return (splineVs);
}

static XPoint arrow_v[4];

void DrawSplinePolyObj (Win, XOff, YOff, Fill, Width, Pen, Dash, Pixel, PolyPtr)
   Window		Win;
   int			XOff, YOff, Fill, Width, Pen, Dash, Pixel;
   struct PolyRec	* PolyPtr;
{
   XPoint	* sv = PolyPtr->svlist, * v;
   double	dx, dy, len, sin, cos;
   int		ah, aw, x_off, y_off, sn = PolyPtr->sn;
   XGCValues	values;

#ifndef UC
   x_off = (XOff >> zoomScale) << zoomScale;
   y_off = (YOff >> zoomScale) << zoomScale;
#else /* UC */
   x_off = RealSize((ScreenSize(XOff,  zoomScale)),  zoomScale);
   y_off = RealSize((ScreenSize(YOff,  zoomScale)),  zoomScale);
#endif /* UC */

   if (Fill != 0)
   {
      sv[sn].x = sv[0].x; sv[sn].y = sv[0].y;
      values.foreground = (Fill == 2) ? myBgPixel : Pixel;
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[Fill];
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple, &values);

      XFillPolygon (mainDisplay, Win, drawGC, sv, sn+1, Complex,
            CoordModeOrigin);
   }

   if (Pen != 0)
   {
      values.foreground = (Pen == 2) ? myBgPixel : Pixel;
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[Pen];
#ifndef UC
      values.line_width = widthOfLine[Width] >> zoomScale;
#else /* UC */
      values.line_width = ScreenSize(widthOfLine[Width],  zoomScale);
#endif /* UC */
      if (Dash != 0)
      {
         XSetDashes (mainDisplay, drawGC, 0, dashList[Dash],
               dashListLength[Dash]);
         values.line_style = LineOnOffDash;
      }
      else
         values.line_style = LineSolid;
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple | GCLineWidth |
            GCLineStyle, &values);

      XDrawLines (mainDisplay, Win, drawGC, sv, sn, CoordModeOrigin);

#ifndef UC
      ah = arrowHeadH[Width] >> zoomScale; if (ah == 0) ah = 1;
      aw = arrowHeadW[Width] >> zoomScale; if (aw == 0) aw = 1;
#else /* UC */
      ah = ScreenSize(arrowHeadH[Width], zoomScale); if (ah == 0) ah = 1;
      aw = ScreenSize(arrowHeadW[Width], zoomScale); if (aw == 0) aw = 1;
#endif /* UC */
      if (PolyPtr->style & LS_LEFT)
      {
         v = PolyPtr->vlist;
#ifndef UC
         arrow_v[0].x = arrow_v[3].x = (v->x-x_off)>>zoomScale;
         arrow_v[0].y = arrow_v[3].y = (v->y-y_off)>>zoomScale;
#else /* UC */
         arrow_v[0].x = arrow_v[3].x = ScreenSize((v->x-x_off), zoomScale);
         arrow_v[0].y = arrow_v[3].y = ScreenSize((v->y-y_off), zoomScale);
#endif /* UC */
         dx = (double)(v[1].x - v[0].x);
         dy = (double)(v[1].y - v[0].y);
         len = (double) sqrt (dx * dx + dy * dy);
         sin = dy / len;
         cos = dx / len;
#ifndef UC
         arrow_v[1].x = round(((int)(v->x-x_off)>>zoomScale)+aw*cos-ah*sin);
         arrow_v[1].y = round(((int)(v->y-y_off)>>zoomScale)+aw*sin+ah*cos);
         arrow_v[2].x = round(((int)(v->x-x_off)>>zoomScale)+aw*cos+ah*sin);
         arrow_v[2].y = round(((int)(v->y-y_off)>>zoomScale)+aw*sin-ah*cos);
#else /* UC */
         arrow_v[1].x = round((ScreenSize((int)(v->x-x_off), zoomScale))+aw*cos-ah*sin);
         arrow_v[1].y = round((ScreenSize((int)(v->y-y_off), zoomScale))+aw*sin+ah*cos);
         arrow_v[2].x = round((ScreenSize((int)(v->x-x_off), zoomScale))+aw*cos+ah*sin);
         arrow_v[2].y = round((ScreenSize((int)(v->y-y_off), zoomScale))+aw*sin-ah*cos);
#endif /* UC */

         XFillPolygon (mainDisplay, Win, drawGC, arrow_v, 4, Convex,
               CoordModeOrigin);
      }
      if (PolyPtr->style & LS_RIGHT)
      {
         v = &(PolyPtr->vlist[PolyPtr->n-2]);
#ifndef UC
         arrow_v[0].x = arrow_v[3].x = (v[1].x-x_off)>>zoomScale;
         arrow_v[0].y = arrow_v[3].y = (v[1].y-y_off)>>zoomScale;
#else /* UC */
         arrow_v[0].x = arrow_v[3].x = ScreenSize((v[1].x-x_off), zoomScale);
         arrow_v[0].y = arrow_v[3].y = ScreenSize((v[1].y-y_off), zoomScale);
#endif /* UC */
         dx = (double)(v[1].x - v[0].x);
         dy = (double)(v[1].y - v[0].y);
         len = (double) sqrt (dx * dx + dy * dy);
         sin = dy / len;
         cos = dx / len;
#ifndef UC
         arrow_v[1].x = round(((int)(v[1].x-x_off)>>zoomScale)-aw*cos+ah*sin);
         arrow_v[1].y = round(((int)(v[1].y-y_off)>>zoomScale)-aw*sin-ah*cos);
         arrow_v[2].x = round(((int)(v[1].x-x_off)>>zoomScale)-aw*cos-ah*sin);
         arrow_v[2].y = round(((int)(v[1].y-y_off)>>zoomScale)-aw*sin+ah*cos);
#else /* UC */
         arrow_v[1].x = round((ScreenSize((int)(v[1].x-x_off), zoomScale))-aw*cos+ah*sin);
         arrow_v[1].y = round((ScreenSize((int)(v[1].y-y_off), zoomScale))-aw*sin-ah*cos);
         arrow_v[2].x = round((ScreenSize((int)(v[1].x-x_off), zoomScale))-aw*cos-ah*sin);
         arrow_v[2].y = round((ScreenSize((int)(v[1].y-y_off), zoomScale))-aw*sin+ah*cos);
#endif /* UC */

         XFillPolygon (mainDisplay, Win, drawGC, arrow_v, 4, Convex,
               CoordModeOrigin);
      }
   }
}

XPoint * MakeSplinePolygonVertex (N, XOff, YOff, NumVs, Vs)
   int		* N, XOff, YOff, NumVs;
   XPoint	* Vs;
{
   double	mx1, my1, mx2, my2, mx3, my3, mx4, my4, x1, y1, x2, y2;
   int		i, max_n, x_off, y_off;

#ifndef UC
   x_off = (XOff >> zoomScale) << zoomScale;
   y_off = (YOff >> zoomScale) << zoomScale;
#else /* UC */
   x_off = RealSize((ScreenSize(XOff ,  zoomScale)), zoomScale);
   y_off = RealSize((ScreenSize(YOff ,  zoomScale)), zoomScale);
#endif /* UC */

   Vs[NumVs].x = Vs[1].x; Vs[NumVs].y = Vs[1].y;
#ifndef UC
   x1 = (Vs->x-x_off)>>zoomScale; y1 = ((Vs++)->y-y_off)>>zoomScale;
   x2 = (Vs->x-x_off)>>zoomScale; y2 = ((Vs++)->y-y_off)>>zoomScale;
#else /* UC */
   x1 = ScreenSize((Vs->x-x_off), zoomScale); y1 = ScreenSize(((Vs++)->y-y_off), zoomScale);
   x2 = ScreenSize((Vs->x-x_off), zoomScale); y2 = ScreenSize(((Vs++)->y-y_off), zoomScale);
#endif /* UC */
   mx4 = (x1 + x2) / 2.0;         my4 = (y1 + y2) / 2.0;

   max_n = 100;
   splineVs = (XPoint *) calloc (max_n, sizeof (XPoint));
   splineVs[0].x = mx4;
   splineVs[0].y = my4;
   *N = 1;

   for (i = 1; i < NumVs; i++, Vs++)
   {
      mx1 = mx4;                     my1 = my4;
      mx2 = (x1+3.0*x2)/4.0;         my2 = (y1+3.0*y2)/4.0;
      x1 = x2;                       y1 = y2;
#ifndef UC
      x2 = (Vs->x-x_off)>>zoomScale; y2 = (Vs->y-y_off)>>zoomScale;
#else /* UC */
      x2 = ScreenSize((Vs->x-x_off), zoomScale); y2 = ScreenSize((Vs->y-y_off), zoomScale);
#endif /* UC */
      mx3 = (3.0*x1+x2)/4.0;         my3 = (3.0*y1+y2)/4.0;
      mx4 = (x1+x2)/2.0;             my4 = (y1+y2)/2.0;
      SetSplineVs (N, &max_n, mx1, my1, mx2, my2, mx3, my3, mx4, my4);
   }
   return (splineVs);
}

void DrawSplinePolygonObj (Win,XOff,YOff,Fill,Width,Pen,Dash,Pixel,PolygonPtr)
   Window		Win;
   int			XOff, YOff, Fill, Width, Pen, Dash, Pixel;
   struct PolygonRec	* PolygonPtr;
{
   XPoint	* sv = PolygonPtr->svlist;
   int		sn = PolygonPtr->sn;
   XGCValues	values;

   if (Fill != 0)
   {
      values.foreground = (Fill == 2) ? myBgPixel : Pixel;
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[Fill];
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple, &values);

      XFillPolygon (mainDisplay, Win, drawGC, sv, sn, Complex, CoordModeOrigin);
   }
   if (Pen != 0)
   {
      values.foreground = (Pen == 2) ? myBgPixel : Pixel;
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[Pen];
#ifndef UC
      values.line_width = widthOfLine[Width] >> zoomScale;
#else /* UC */
      values.line_width = ScreenSize(widthOfLine[Width] ,  zoomScale);
#endif /* UC */
      if (Dash != 0)
      {
         XSetDashes (mainDisplay, drawGC, 0, dashList[Dash],
               dashListLength[Dash]);
         values.line_style = LineOnOffDash;
      }
      else
         values.line_style = LineSolid;
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle | GCStipple | GCLineWidth |
            GCLineStyle, &values);

      XDrawLines (mainDisplay, Win, drawGC, sv, sn, CoordModeOrigin);
   }
}

void DumpCurvedPolyPoints (FP, NumPts, V, Indent)
   FILE			* FP;
   int			NumPts, Indent;
   register XPoint	* V;
{
   register int	j, i;
   double	x1, y1, x2, y2;
   double	mx1, my1, mx2, my2, mx3, my3, mx4, my4;

   switch (NumPts)
   {
      case 0:
      case 1:
      case 2:
         break;
      case 3:
         mx1 = V->x; my1 = (V++)->y;
         x1 = V->x; y1 = (V++)->y;
         x2 = V->x; y2 = (V++)->y;
         mx2 = (mx1 + 2.0*x1) / 3.0; my2 = (my1 + 2.0*y1) / 3.0;
         mx3 = (2.0*x1 + x2) / 3.0; my3 = (2.0*y1 + y2) / 3.0;
         for (j = 0; j < Indent; j++) fprintf (FP, " ");
         fprintf (FP, "%.2f %.2f %.2f %.2f\n", mx2, my2, mx3, my3);
         break;
      default:
         mx1 = V->x; my1 = (V++)->y;
         x1 = V->x; y1 = (V++)->y;
         x2 = V->x; y2 = (V++)->y;
         mx2 = (mx1 + 2.0*x1) / 3.0; my2 = (my1 + 2.0*y1) / 3.0;
         mx3 = (5.0*x1 + x2) / 6.0; my3 = (5.0*y1 + y2) / 6.0;
         mx4 = (x1 + x2) / 2.0; my4 = (y1 + y2) / 2.0;
         for (j = 0; j < Indent; j++) fprintf (FP, " ");
         fprintf (FP, "%.2f %.2f %.2f %.2f %.2f %.2f curveto\n",
               mx2, my2, mx3, my3, mx4, my4);
      
         for (i = 2; i < NumPts-2; i++, V++)
         {
            mx1 = mx4; my1 = my4;
            mx2 = (x1 + 5.0*x2) / 6.0; my2 = (y1 + 5.0*y2) / 6.0;
            x1 = x2; y1 = y2;
            x2 = V->x; y2 = V->y;
            mx3 = (5.0*x1 + x2) / 6.0; my3 = (5.0*y1 + y2) / 6.0;
            mx4 = (x1 + x2) / 2.0; my4 = (y1 + y2) / 2.0;
            for (j = 0; j < Indent; j++) fprintf (FP, " ");
            fprintf (FP, "%.2f %.2f %.2f %.2f %.2f %.2f curveto\n",
                  mx2, my2, mx3, my3, mx4, my4);
         }
         mx1 = mx4; my1 = my4;
         mx2 = (x1 + 5.0*x2) / 6.0; my2 = (y1 + 5.0*y2) / 6.0;
         x1 = x2; y1 = y2;
         mx3 = (2.0*x1 + V->x) / 3.0; my3 = (2.0*y1 + V->y) / 3.0;
         for (j = 0; j < Indent; j++) fprintf (FP, " ");
         fprintf (FP, "%.2f %.2f %.2f %.2f\n", mx2, my2, mx3, my3);
         break;
   }
}

void DumpCurvedPolygonPoints (FP, NumPts, V, Indent)
   FILE			* FP;
   int			NumPts, Indent;
   register XPoint	* V;
{
   register int	j;
   double	mx1, my1, mx2, my2, mx3, my3, mx4, my4, x1, y1, x2, y2;
   int		i;

   V[NumPts].x = V[1].x; V[NumPts].y = V[1].y;
   x1 = V->x;             y1 = (V++)->y;
   x2 = V->x;             y2 = (V++)->y;
   mx4 = (x1 + x2) / 2.0; my4 = (y1 + y2) / 2.0;
   for (j = 0; j < Indent; j++) fprintf (FP, " ");
   fprintf (FP, "%.2f %.2f moveto\n", mx4, my4);

   for (i = 1; i < NumPts; i++, V++)
   {
      mx1 = mx4;             my1 = my4;
      mx2 = (x1+5.0*x2)/6.0; my2 = (y1+5.0*y2)/6.0;
      x1 = x2;               y1 = y2;
      x2 = V->x;             y2 = V->y;
      mx3 = (5.0*x1+x2)/6.0; my3 = (5.0*y1+y2)/6.0;
      mx4 = (x1+x2)/2.0;     my4 = (y1+y2)/2.0;
      for (j = 0; j < Indent; j++) fprintf (FP, " ");
      fprintf (FP, "%.2f %.2f %.2f %.2f %.2f %.2f curveto\n",
            mx2, my2, mx3, my3, mx4, my4);
   }
}

static
int PointInSpline (PX, PY, W, X1, Y1, X2, Y2, X3, Y3, X4, Y4)
   int		PX, PY, W;
   double	X1, Y1, X2, Y2, X3, Y3, X4, Y4;
   /* X and Y are absolute coordinates */
{
   register double	x, y;

   x = (X2 + X3) / 2.0;
   y = (Y2 + Y3) / 2.0;
   if (fabs (X1 - x) < SPLINE_TOL && fabs (Y1 - y) < SPLINE_TOL)
      return (PX > min(X1,x)-W && PX < max(X1,x)+W &&
            PY > min(Y1,y)-W && PY < max(Y1,y)+W);
   else
      if (PointInSpline  (PX, PY, W, X1, Y1, (X1+X2)/2.0, (Y1+Y2)/2.0,
            (3.0*X2+X3)/4.0, (3.0*Y2+Y3)/4.0, x, y))
         return (TRUE);

   if (fabs (x - X4) < SPLINE_TOL && fabs (y - Y4) < SPLINE_TOL)
      return (PX > min(X4,x)-W && PX < max(X4,x)+W &&
            PY > min(Y4,y)-W && PY < max(Y4,y)+W);
   else
      return (PointInSpline (PX, PY, W, x, y, (X2+3.0*X3)/4.0, (Y2+3.0*Y3)/4.0,
            (X3+X4)/2.0, (Y3+Y4)/2.0, X4, Y4));
}

int PointInSplinePoly (X, Y, PolyPtr, W)
   int			X, Y, W;
   struct PolyRec	* PolyPtr;
   /* X and Y are absolute coordinates */
{
   double	mx1, my1, mx2, my2, mx3, my3, mx4, my4, x1, y1, x2, y2;
   int		i, in_region, sn, num_pts = PolyPtr->n;
   XPoint	* v = PolyPtr->vlist, * sv;
   Region	region;

   if (PolyPtr->fill != NONEPAT)
   {
      sv = PolyPtr->svlist;
      sn = PolyPtr->sn;
      sv[sn].x = sv[0].x; sv[sn].y = sv[0].y;
      region = XPolygonRegion (sv, sn+1, EvenOddRule);
#ifndef UC
      in_region = XPointInRegion (region, (X-drawOrigX)>>zoomScale,
            (Y-drawOrigY)>>zoomScale);
#else /* UC */
      in_region = XPointInRegion (region, ScreenSize((X-drawOrigX), zoomScale),
            ScreenSize((Y-drawOrigY), zoomScale));
#endif /* UC */
      XDestroyRegion (region);
      if (in_region) return (TRUE);
   }

   switch (num_pts)
   {
      case 2:
         return (PointInPoly (X, Y, num_pts, v, W));
      case 3:
         mx1 = v->x;             my1 = (v++)->y;
         x1 = v->x;              y1 = (v++)->y;
         mx4 = v->x;             my4 = v->y;
         mx2 = (mx1 + x1) / 2.0; my2 = (my1 + y1) / 2.0;
         mx3 = (x1 + mx4) / 2.0; my3 = (y1 + my4) / 2.0;
         return (PointInSpline (X, Y, W, mx1, my1, mx2, my2, mx3, my3, mx4, my4));
      default:
         mx1 = v->x;            my1 = (v++)->y;
         x1 = v->x;             y1 = (v++)->y;
         x2 = v->x;             y2 = (v++)->y;
         mx2 = (mx1+x1)/2.0;    my2 = (my1+y1)/2.0;
         mx3 = (3.0*x1+x2)/4.0; my3 = (3.0*y1+y2)/4.0;
         mx4 = (x1+x2)/2.0;     my4 = (y1+y2)/2.0;
         if (PointInSpline (X, Y, W, mx1, my1, mx2, my2, mx3, my3, mx4, my4))
            return (TRUE);
      
         for (i = 2; i < num_pts-2; i++, v++)
         {
            mx1 = mx4;             my1 = my4;
            mx2 = (x1+3.0*x2)/4.0; my2 = (y1+3.0*y2)/4.0;
            x1 = x2;               y1 = y2;
            x2 = v->x;             y2 = v->y;
            mx3 = (3.0*x1+x2)/4.0; my3 = (3.0*y1+y2)/4.0;
            mx4 = (x1+x2)/2.0;     my4 = (y1+y2)/2.0;
            if (PointInSpline (X, Y, W, mx1, my1, mx2, my2, mx3, my3, mx4, my4))
               return (TRUE);
         }
         mx1 = mx4;             my1 = my4;
         mx2 = (x1+3.0*x2)/4.0; my2 = (y1+3.0*y2)/4.0;
         x1 = x2;               y1 = y2;
         mx4 = v->x;            my4 = v->y;
         mx3 = (x1+mx4)/2.0;    my3 = (y1+my4)/2.0;
         return (PointInSpline (X, Y, W, mx1, my1, mx2, my2, mx3, my3, mx4, my4));
   }
}

int PointInSplinePolygon (X, Y, PolygonPtr, W)
   int			X, Y, W;
   struct PolygonRec	* PolygonPtr;
   /* X and Y are absolute coordinates */
{
   double	mx1, my1, mx2, my2, mx3, my3, mx4, my4, x1, y1, x2, y2;
   int		i, in_region, num_pts = PolygonPtr->n;
   XPoint	* v = PolygonPtr->vlist;
   Region	region;

   if (PolygonPtr->fill != NONEPAT)
   {
      region = XPolygonRegion (PolygonPtr->svlist, PolygonPtr->sn, EvenOddRule);
#ifndef UC
      in_region = XPointInRegion (region, (X-drawOrigX)>>zoomScale,
            (Y-drawOrigY)>>zoomScale);
#else /* UC */
      in_region = XPointInRegion (region, ScreenSize((X-drawOrigX), zoomScale),
            ScreenSize((Y-drawOrigY), zoomScale));
#endif /* UC */
      XDestroyRegion (region);
      if (in_region) return (TRUE);
   }

   v[num_pts].x = v[1].x; v[num_pts].y = v[1].y;
   x1 = v->x;             y1 = (v++)->y;
   x2 = v->x;             y2 = (v++)->y;
   mx4 = (x1+x2)/2.0;     my4 = (y1+y2)/2.0;

   for (i = 1; i < num_pts; i++, v++)
   {
      mx1 = mx4;             my1 = my4;
      mx2 = (x1+3.0*x2)/4.0; my2 = (y1+3.0*y2)/4.0;
      x1 = x2;               y1 = y2;
      x2 = v->x;             y2 = v->y;
      mx3 = (3.0*x1+x2)/4.0; my3 = (3.0*y1+y2)/4.0;
      mx4 = (x1+x2)/2.0;     my4 = (y1+y2)/2.0;
      if (PointInSpline (X, Y, W, mx1, my1, mx2, my2, mx3, my3, mx4, my4))
         return (TRUE);
   }
   return (FALSE);
}
