/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/stk.c,v 2.0 91/03/05 12:48:31 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "align.e"
#include "button.e"
#include "choice.e"
#include "color.e"
#include "dup.e"
#include "file.e"
#include "font.e"
#include "grid.e"
#include "mark.e"
#include "menu.e"
#include "msg.e"
#include "names.e"
#include "obj.e"
#include "pattern.e"
#include "ruler.e"
#include "scroll.e"
#include "select.e"
#include "setup.e"
#include "text.e"

static struct StkRec	* topStk = NULL;

int AncesterModified ()
{
   struct StkRec	* stk_ptr;

   for (stk_ptr = topStk; stk_ptr != NULL; stk_ptr = stk_ptr->next)
      if (stk_ptr->file_mod) return (TRUE);
   return (FALSE);
}

void InitStk ()
{
   curSymDir[0] = '\0';
}

void PushIcon ()
{
   struct StkRec	* stk_ptr;
   struct ObjRec	* obj_ptr;
   char			sym_name[MAXPATHLENGTH], path_name[MAXPATHLENGTH];
   char			file_name[MAXPATHLENGTH], s[MAXPATHLENGTH];
   FILE			* fp;

   if (topSel == NULL || topSel != botSel || topSel->obj->type != OBJ_ICON)
   {
      Msg ("Please select one ICON object to push into.");
      return;
   }

   strcpy (sym_name, topSel->obj->detail.r->s);
   if (!GetSymbolPath (sym_name, path_name))
   {
      sprintf (s, "Can not find '%s.sym' in %s", sym_name, curDomainPath);
      Msg (s);
      return;
   }

   strcat (sym_name, ".sym");
   sprintf (file_name, "%s/%s", path_name, sym_name);

   if ((fp = fopen (file_name, "r")) == NULL)
   {
      sprintf (s, "Can not open '%s', icon not pushed into.", file_name);
      Msg (s);
      return;
   }

   HighLightReverse ();

   stk_ptr = (struct StkRec *) calloc (1, sizeof(struct StkRec));
   stk_ptr->next = topStk;
   stk_ptr->sel = topSel->obj;
   stk_ptr->first = topObj;
   stk_ptr->last = botObj;
   stk_ptr->file_mod = fileModified;
   stk_ptr->id = objId;
   stk_ptr->page_style = pageStyle;

   stk_ptr->orig_x = drawOrigX;
   stk_ptr->orig_y = drawOrigY;
   stk_ptr->zoom = zoomScale;
   stk_ptr->grid = xyGrid;
   stk_ptr->grid_on = gridOn;
   stk_ptr->color = colorIndex;
   stk_ptr->h_align = horiAlign;
   stk_ptr->v_align = vertAlign;
   stk_ptr->line_w = lineWidth;
   stk_ptr->line_s = lineStyle;
   stk_ptr->fill = objFill;
   stk_ptr->pen = penPat;
   stk_ptr->just = textJust;
   stk_ptr->font = curFont;
   stk_ptr->f_style = curStyle;
   stk_ptr->f_size = curSize;
   stk_ptr->f_dpi = curFontDPI;

   topObj = botObj = NULL;

   strcpy (stk_ptr->dir, curDir);
   if (stk_ptr->name_valid = curFileDefined)
      strcat (stk_ptr->name, curFileName);
   strcpy (stk_ptr->sym_dir, curSymDir);
   strcpy (stk_ptr->domain, curDomainName);

   topStk = stk_ptr;

   sprintf (s, "Pushing into '%s' ...", file_name);
   Msg (s);
   CleanUpDrawingWindow ();
   XClearWindow (mainDisplay, drawWindow);
   SetFileModified (FALSE);

   while (ReadObj (fp, &obj_ptr, FALSE))
      if (obj_ptr != NULL)
      {
         AddObj (NULL, topObj, obj_ptr);
         if (PointInBBox (obj_ptr->x, obj_ptr->y, drawWinBBox) ||
               BBoxIntersect (obj_ptr->bbox, drawWinBBox))
            DrawObj (drawWindow, obj_ptr);
      }

   if (topObj == NULL)
   {
      DrawPaperBoundary ();
      RedrawGridLines ();
   }

   fclose (fp);
   strcpy (curFileName, sym_name);
   strcpy (curSymDir, path_name);
   curFileDefined = TRUE;

   sprintf (s, "Current file is '%s'.", file_name);
   Msg (s);

   RedrawTitleWindow ();
}

void PopIcon ()
{
   char	dummy[MAXPATHLENGTH];

   if (topStk == NULL)
   {
      Msg ("Already at top level.");
      return;
   }
   if (fileModified)
   {
      switch (YesNoCancel ("File modified, save file before quit? [ync](y)"))
      {
         case CONFIRM_YES: SaveFile (); break;
         case CONFIRM_NO: break;
         case CONFIRM_CANCEL: return;
      }
   }
   fileModified = topStk->file_mod;
   objId = topStk->id;

   CleanUpDrawingWindow ();

   drawOrigX = topStk->orig_x;
   drawOrigY = topStk->orig_y;
   zoomScale = topStk->zoom;
   xyGrid = topStk->grid;
   gridOn = topStk->grid_on;
   colorIndex = topStk->color;
   horiAlign = topStk->h_align;
   vertAlign = topStk->v_align;
   lineWidth = topStk->line_w;
   lineStyle = topStk->line_s;
   objFill = topStk->fill;
   penPat = topStk->pen;
   textJust = topStk->just;
   curFont = topStk->font;
   curStyle = topStk->f_style;
   curFontDPI = topStk->f_dpi;

   topObj = topStk->first;
   botObj = topStk->last;
   strcpy (curDomainName, topStk->domain);
   strcpy (curSymDir, topStk->sym_dir);
   if (curFileDefined = topStk->name_valid)
   {
      strcpy (curFileName, topStk->name);
      if (*curSymDir == '\0')
         sprintf (dummy, "Poping back to '%s/%s'.", topStk->dir, curFileName);
      else
         sprintf (dummy, "Poping back to '%s/%s'.", curSymDir, curFileName);
      Msg (dummy);
   }
   else
   {
      sprintf (dummy, "Poping back to parent level.  Current file undefined.");
      Msg (dummy);
   }
   if (strcmp (curDir, topStk->dir) != 0)
   {
      strcpy (curDir, topStk->dir);
      UpdateDirInfo ();
   }
   else
      strcpy (curDir, topStk->dir);

   topSel = botSel = (struct SelRec *) calloc (1, sizeof(struct SelRec));
   topSel->next = NULL;
   topSel->prev = NULL;
   topSel->obj = topStk->sel;
   UpdSelBBox ();

   if (pageStyle != topStk->page_style) UpdPageStyle (topStk->page_style);
   UpdDrawWinWH ();
   SetCanvasFont ();
   RedrawRulers ();
   if (pageStyle == topStk->page_style) RedrawScrollBars ();
   RedrawChoiceWindow ();
   RedrawTitleWindow ();
   UpdDrawWinBBox ();

   cfree (topStk);
   topStk = topStk->next;
   ClearAndRedrawDrawWindow ();
   XSync (mainDisplay, TRUE);
   justDupped = FALSE;
}

void CleanUpStk ()
{
   for ( ; topStk != NULL; topStk = topStk->next)
   {
      topObj = topStk->first;
      botObj = topStk->last;
      DelAllObj ();
      cfree (topStk);
   }
   curSymDir[0] = '\0';
}
