/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/stretch.c,v 2.0 91/03/05 12:48:33 william Exp $";
#endif

#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "arc.e"
#include "choice.e"
#include "color.e"
#include "cursor.e"
#include "drawing.e"
#include "dup.e"
#include "font.e"
#include "grid.e"
#include "move.e"
#include "obj.e"
#include "poly.e"
#include "raster.e"
#include "ruler.e"
#include "select.e"
#include "setup.e"
#include "spline.e"
#include "text.e"
#include "xbitmap.e"
#ifdef UC
#include "showsize.e"
#endif /* UC */

#define PtInMark(PtX,PtY,MarkX,MarkY) ((PtX) >= (MarkX)-2 && \
      (PtY) >= (MarkY)-2 && (PtX) <= (MarkX)+2 && (PtY) <= (MarkY)+2)
#define MyDashedLine(W,GC,V,N) XDrawLines (mainDisplay, W, GC, V, N, \
      CoordModeOrigin)

#ifdef UC
extern void DoStretchBox ();
extern void UndoStretchBox ();
extern void DoStretchPoly ();
extern void UndoStretchPoly ();
#endif /* UC */
static
int PtIn4Corners (XOff, YOff, BBox, Corner)
   int		XOff, YOff, * Corner;
   struct BBRec	BBox;
{
   if (PtInMark (XOff, YOff, OFFSET_X(BBox.ltx), OFFSET_Y(BBox.lty)))
   {
      *Corner = 1;
      return(TRUE);
   }
   if (PtInMark (XOff, YOff, OFFSET_X(BBox.ltx), OFFSET_Y(BBox.rby)))
   {
      *Corner = 7;
      return(TRUE);
   }
   if (PtInMark (XOff, YOff, OFFSET_X(BBox.rbx), OFFSET_Y(BBox.lty)))
   {
      *Corner = 3;
      return(TRUE);
   }
   if (PtInMark (XOff, YOff, OFFSET_X(BBox.rbx), OFFSET_Y(BBox.rby)))
   {
      *Corner = 5;
      return(TRUE);
   }
   return (FALSE);
}

static
int PtIn8Places (XOff, YOff, BBox, Corner)
   int		XOff, YOff, * Corner;
   struct BBRec	BBox;
{
   register int	xmid, ymid;

   if (BBox.rbx - BBox.ltx >= 10)
   {
      xmid = (BBox.ltx+BBox.rbx) / 2;
      if (PtInMark (XOff, YOff, OFFSET_X(xmid), OFFSET_Y(BBox.lty)))
      {
         *Corner = 2;
         return(TRUE);
      }
      if (PtInMark (XOff, YOff, OFFSET_X(xmid), OFFSET_Y(BBox.rby)))
      {
         *Corner = 6;
         return(TRUE);
      }
   }
   if (BBox.rby - BBox.lty >= 10)
   {
      ymid = (BBox.lty+BBox.rby) / 2;
      if (PtInMark (XOff, YOff, OFFSET_X(BBox.ltx), OFFSET_Y(ymid)))
      {
         *Corner = 8;
         return(TRUE);
      }
      if (PtInMark (XOff, YOff, OFFSET_X(BBox.rbx), OFFSET_Y(ymid)))
      {
         *Corner = 4;
         return(TRUE);
      }
   }
   return (PtIn4Corners (XOff, YOff, BBox, Corner));
}

int PtInPolyMark (XOff, YOff, NumPts, V, Index)
   int		XOff, YOff, NumPts, * Index;
   XPoint	* V;
{
   register int	i;

   for (i = 0; i < NumPts; i++)
      if (PtInMark (XOff, YOff, OFFSET_X(V[i].x), OFFSET_Y(V[i].y)))
      {
         *Index = i;
         return (TRUE);
      }
   return (FALSE);
}

struct SelRec * PtInSelMark (XOff, YOff, Corner)
   int	XOff, YOff, * Corner;
   /* XOff and YOff are screen offsets */
   /* 1 2 3 */
   /* 8   4 */
   /* 7 6 5 */
{
   register struct SelRec	* sel_ptr;
   register struct ObjRec	* obj_ptr;

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
   {
      obj_ptr = sel_ptr->obj;
      switch (obj_ptr->type)
      {
         case OBJ_POLY:
            if (PtInPolyMark (XOff, YOff, obj_ptr->detail.p->n,
                  obj_ptr->detail.p->vlist, Corner))
               return (sel_ptr);
            break;
         case OBJ_POLYGON:
            if (PtInPolyMark (XOff, YOff, obj_ptr->detail.g->n-1,
                  obj_ptr->detail.g->vlist, Corner))
               return (sel_ptr);
            break;
         case OBJ_BOX:
         case OBJ_GROUP:
         case OBJ_SYM:
         case OBJ_OVAL:
         case OBJ_ARC:
         case OBJ_RCBOX:
            if (PtIn8Places (XOff, YOff, obj_ptr->obbox, Corner))
               return (sel_ptr);
            break;
         case OBJ_TEXT:
         case OBJ_XBM:
         case OBJ_ICON:
            if (PtIn4Corners (XOff, YOff, obj_ptr->obbox, Corner))
               return (sel_ptr);
            break;
      }
   }
   return (NULL);
}

static XPoint v[5];

static
void StretchPoly (XGridOff, YGridOff, ObjPtr, NumPts, V, Index)
   int			XGridOff, YGridOff, NumPts, Index;
   XPoint		* V;
   struct ObjRec	* ObjPtr;
{
   int		x, y, dx, dy, num = 0, stretching = TRUE;
   int		ltx, lty, rbx, rby, curved;
   int		grid_x = XGridOff, grid_y = YGridOff;
   XEvent	input;
#ifdef UC
   register int showsize = showSize;
   register int hidedragcursor = hideDragCursor;
   register int cursordefined = FALSE;
#endif /* UC */

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         curved = ObjPtr->detail.p->curved;
         if (Index == 0 || Index == NumPts-1)
         {
            num = 2;
            if (Index == 0)
            {
               v[0].x = OFFSET_X(V[1].x); v[0].y = OFFSET_Y(V[1].y);
               v[1].x = OFFSET_X(V[0].x); v[1].y = OFFSET_Y(V[0].y);
            }
            else
            {
               v[0].x = OFFSET_X(V[NumPts-2].x);
               v[0].y = OFFSET_Y(V[NumPts-2].y);
               v[1].x = OFFSET_X(V[NumPts-1].x);
               v[1].y = OFFSET_Y(V[NumPts-1].y);
            }
         }
         else
         {
            num = 3;
            v[0].x = OFFSET_X(V[Index-1].x); v[0].y = OFFSET_Y(V[Index-1].y);
            v[1].x = OFFSET_X(V[Index].x);   v[1].y = OFFSET_Y(V[Index].y);
            v[2].x = OFFSET_X(V[Index+1].x); v[2].y = OFFSET_Y(V[Index+1].y);
         }
         break;
      case OBJ_POLYGON:
         curved = ObjPtr->detail.g->curved;
         num = 3;
         if (Index == 0 || Index == NumPts-1)
         {
            v[0].x = OFFSET_X(V[1].x); v[0].y = OFFSET_Y(V[1].y);
            v[1].x = OFFSET_X(V[0].x); v[1].y = OFFSET_Y(V[0].y);
            v[2].x = OFFSET_X(V[NumPts-2].x); v[2].y = OFFSET_Y(V[NumPts-2].y);
         }
         else
         {
            v[0].x = OFFSET_X(V[Index-1].x); v[0].y = OFFSET_Y(V[Index-1].y);
            v[1].x = OFFSET_X(V[Index].x);   v[1].y = OFFSET_Y(V[Index].y);
            v[2].x = OFFSET_X(V[Index+1].x); v[2].y = OFFSET_Y(V[Index+1].y);
         }
         break;
   }

   ltx = ObjPtr->bbox.ltx;
   lty = ObjPtr->bbox.lty;
   rbx = ObjPtr->bbox.rbx;
   rby = ObjPtr->bbox.rby;

   XGrabPointer (mainDisplay, drawWindow, FALSE,
         PointerMotionMask | ButtonReleaseMask,
#ifndef UC
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
#else /* UC */
         GrabModeAsync, GrabModeAsync, None, ((hidedragcursor)?None:handCursor), CurrentTime);
#endif /* UC */
#ifdef UC
   if (showsize) showLength (v[0].x, v[0].y, v[1].x, v[1].y, RIGHTUP);
#endif /* UC */

   MyDashedLine (drawWindow, revDefaultGC, v, num);
   dx = dy = 0;
   while (stretching)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonRelease)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         stretching = FALSE;
#ifdef UC
	 if (showsize) eraseSizeString ();
	 if (hidedragcursor && cursordefined)
	 {
	     XDefineCursor (mainDisplay, drawWindow, defaultCursor);
	     cursordefined = FALSE;
	     XFlush (mainDisplay);
	 }
#endif /* UC */

         MyDashedLine (drawWindow, revDefaultGC, v, num);
         HighLightReverse ();

         if (dx != 0 || dy != 0)
         {
#ifndef UC
            dx <<= zoomScale;
            dy <<= zoomScale;
#else /* UC */
            dx = RealSize(dx, zoomScale);
            dy = RealSize(dy, zoomScale);
#endif /* UC */
#ifndef UC
            switch (ObjPtr->type)
            {
               case OBJ_POLY:
                  V[Index].x += dx; V[Index].y += dy;
                  if (ObjPtr->detail.p->curved)
                  {
                     cfree (ObjPtr->detail.p->svlist);
                     ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
                           &(ObjPtr->detail.p->sn), drawOrigX, drawOrigY,
                           ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
                  }
                  break;
               case OBJ_POLYGON:
                  V[Index].x += dx; V[Index].y += dy;
                  if (Index == 0)
                  {
                     V[NumPts-1].x += dx; V[NumPts-1].y += dy;
                  }
                  else if (Index == NumPts-1)
                  {
                     V[0].x += dx; V[0].y += dy;
                  }
                  if (ObjPtr->detail.g->curved)
                  {
                     cfree (ObjPtr->detail.g->svlist);
                     ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
                           &(ObjPtr->detail.g->sn), drawOrigX, drawOrigY,
                           ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
                  }
                  break;
            }
            UpdPolyBBox (ObjPtr, NumPts, V);

            UpdSelBBox ();
            RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
                  rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)),
                  ObjPtr->bbox.ltx-(RealSize(1, zoomScale)),
                  ObjPtr->bbox.lty-(RealSize(1, zoomScale)),
                  ObjPtr->bbox.rbx+(RealSize(1, zoomScale)),
                  ObjPtr->bbox.rby+(RealSize(1, zoomScale)));
            SetFileModified (TRUE);
         }
#else /* UC */
	    DoStretchPoly (ObjPtr->type, ObjPtr, NumPts, V, Index, dx, dy);
	 }
#endif /* UC */
         HighLightForward ();
      }
      else if (input.type == MotionNotify)
      {
         x = input.xmotion.x;
         y = input.xmotion.y;
         GridXY (x, y, &grid_x, &grid_y);
#ifdef UC
	 if (hidedragcursor && !cursordefined &&(dx != 0 || dy != 0))
	 {
	     cursordefined = TRUE;
	     XDefineCursor (mainDisplay, drawWindow, dragCursor);
	 }
#endif /* UC */

         MyDashedLine (drawWindow, revDefaultGC, v, num);
#ifdef UC
	 if (showsize) eraseSizeString();
#endif /* UC */

         dx = grid_x - XGridOff;
         dy = grid_y - YGridOff;
         v[1].x = OFFSET_X(V[Index].x) + dx;
         v[1].y = OFFSET_Y(V[Index].y) + dy;
         MarkRulers (grid_x, grid_y);

         MyDashedLine (drawWindow, revDefaultGC, v, num);
#ifdef UC
	 if (showsize) showLength (v[0].x, v[0].y, v[1].x, v[1].y, RIGHTUP);
#endif /* UC */
      }
   }
}

static double	multX, multY;
static int	pivotX, pivotY, changeX, changeY, moveX, moveY;

static
void StretchedXY (X, Y, NewX, NewY)
   int	X, Y, * NewX, * NewY; /* screen offsets */
{
   register int	dx, dy;

   dx = round ((double)((double)(X - pivotX) * multX));
   dy = round ((double)((double)(Y - pivotY) * multY));
   *NewX = pivotX + dx;
   *NewY = pivotY + dy;
}

static
void SetPivot (Corner, OBBox)
   int		Corner;
   struct BBRec OBBox;
   /* pivotX, pivotY, moveX, moveY will be set to screen offsets */
{
   switch (Corner)
   {
      case 1:
         pivotX = OBBox.rbx; pivotY = OBBox.rby;
         moveX = OBBox.ltx; moveY = OBBox.lty;
         changeX = changeY = TRUE;
         break;
      case 2:
         pivotX = moveX = (OBBox.ltx+OBBox.rbx)/2; pivotY = OBBox.rby;
         moveY = OBBox.lty;
         changeX = FALSE; changeY = TRUE;
         break;
      case 3:
         pivotX = OBBox.ltx; pivotY = OBBox.rby;
         moveX = OBBox.rbx; moveY = OBBox.lty;
         changeX = changeY = TRUE;
         break;
      case 4:
         pivotX = OBBox.ltx; pivotY = moveY = (OBBox.ltx+OBBox.rby)/2;
         moveX = OBBox.rbx;
         changeX = TRUE; changeY = FALSE;
         break;
      case 5:
         pivotX = OBBox.ltx; pivotY = OBBox.lty;
         moveX = OBBox.rbx; moveY = OBBox.rby;
         changeX = changeY = TRUE;
         break;
      case 6:
         pivotX = moveX = (OBBox.ltx+OBBox.rbx)/2; pivotY = OBBox.lty;
         moveY = OBBox.rby;
         changeX = FALSE; changeY = TRUE;
         break;
      case 7:
         pivotX = OBBox.rbx; pivotY = OBBox.lty;
         moveX = OBBox.ltx; moveY = OBBox.rby;
         changeX = changeY = TRUE;
         break;
      case 8:
         pivotX = OBBox.rbx; pivotY = moveY = (OBBox.lty+OBBox.rby)/2;
         moveX = OBBox.ltx;
         changeX = TRUE; changeY = FALSE;
         break;
   }
   multX = 1.0;
   multY = 1.0;
   pivotX = OFFSET_X(pivotX);
   pivotY = OFFSET_Y(pivotY);
   moveX = OFFSET_X(moveX);
   moveY = OFFSET_Y(moveY);
}

static
void StretchObj (ObjPtr, Corner)
   struct ObjRec	* ObjPtr;
   int			Corner;
{
   register int			i;
   register struct ObjRec	* ptr;
   struct AttrRec		* attr_ptr;
   struct ArcRec		* arc_ptr;
   int				x, y, dx, dy, old_x, old_y, w, h;
   int				ltx, lty, rbx, rby;
   int				real_ltx, real_lty, real_rbx, real_rby;

   StretchedXY (OFFSET_X(ObjPtr->obbox.ltx), OFFSET_Y(ObjPtr->obbox.lty),
         &ltx, &lty);
   StretchedXY (OFFSET_X(ObjPtr->obbox.rbx), OFFSET_Y(ObjPtr->obbox.rby),
         &rbx, &rby);
   CalcBBox (ltx, lty, rbx, rby, &real_ltx, &real_lty, &real_rbx, &real_rby);

   StretchedXY (OFFSET_X(ObjPtr->x), OFFSET_Y(ObjPtr->y), &x, &y);
#ifndef UC
   w = (ObjPtr->obbox.rbx - ObjPtr->obbox.ltx) << zoomScale;
   h = (ObjPtr->obbox.rby - ObjPtr->obbox.lty) << zoomScale;
#else /* UC */
   w = RealSize((ObjPtr->obbox.rbx - ObjPtr->obbox.ltx) ,  zoomScale);
   h = RealSize((ObjPtr->obbox.rby - ObjPtr->obbox.lty) ,  zoomScale);
#endif /* UC */

   switch (ObjPtr->type)
   {
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_POLY:
      case OBJ_POLYGON:
      case OBJ_ARC:
      case OBJ_RCBOX:
      case OBJ_SYM:
      case OBJ_GROUP:
#ifndef UC
         ObjPtr->obbox.ltx = ObjPtr->x = (real_ltx << zoomScale) + drawOrigX;
         ObjPtr->obbox.lty = ObjPtr->y = (real_lty << zoomScale) + drawOrigY;
         ObjPtr->obbox.rbx = (real_rbx << zoomScale) + drawOrigX;
         ObjPtr->obbox.rby = (real_rby << zoomScale) + drawOrigY;
#else /* UC */
         ObjPtr->obbox.ltx = ObjPtr->x = (RealSize(real_ltx ,  zoomScale)) + drawOrigX;
         ObjPtr->obbox.lty = ObjPtr->y = (RealSize(real_lty ,  zoomScale)) + drawOrigY;
         ObjPtr->obbox.rbx = (RealSize(real_rbx ,  zoomScale)) + drawOrigX;
         ObjPtr->obbox.rby = (RealSize(real_rby ,  zoomScale)) + drawOrigY;
#endif /* UC */
         break;
      case OBJ_TEXT:
#ifndef UC
         ObjPtr->x = (x << zoomScale) + drawOrigX;
         ObjPtr->y = (y << zoomScale) + drawOrigY;
#else /* UC */
         ObjPtr->x = (RealSize(x ,  zoomScale)) + drawOrigX;
         ObjPtr->y = (RealSize(y ,  zoomScale)) + drawOrigY;
#endif /* UC */
         if (multX < 0)
            ObjPtr->detail.t->just = MAXJUSTS - 1 - ObjPtr->detail.t->just;
         if (multY < 0) ObjPtr->y -= h;
         UpdTextBBox (ObjPtr);
         break;
      case OBJ_ICON:
      case OBJ_XBM:
         old_x = ObjPtr->x;
         old_y = ObjPtr->y;
#ifndef UC
         ObjPtr->x = (x << zoomScale) + drawOrigX;
         ObjPtr->y = (y << zoomScale) + drawOrigY;
#else /* UC */
         ObjPtr->x = (RealSize(x,  zoomScale)) + drawOrigX;
         ObjPtr->y = (RealSize(y,  zoomScale)) + drawOrigY;
#endif /* UC */
         if (multX < 0) ObjPtr->x -= w;
         if (multY < 0) ObjPtr->y -= h;
         dx = ObjPtr->x - old_x;
         dy = ObjPtr->y - old_y;
         MoveObj (ObjPtr, dx, dy);
         break;
   }

   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         for (i = 0; i < ObjPtr->detail.p->n; i++)
         {
            StretchedXY (OFFSET_X(ObjPtr->detail.p->vlist[i].x),
                  OFFSET_Y(ObjPtr->detail.p->vlist[i].y), &x, &y);
#ifndef UC
            ObjPtr->detail.p->vlist[i].x = (x << zoomScale) + drawOrigX;
            ObjPtr->detail.p->vlist[i].y = (y << zoomScale) + drawOrigY;
#else /* UC */
            ObjPtr->detail.p->vlist[i].x = (RealSize(x ,  zoomScale)) + drawOrigX;
            ObjPtr->detail.p->vlist[i].y = (RealSize(y ,  zoomScale)) + drawOrigY;
#endif /* UC */
         }
         if (ObjPtr->detail.p->curved)
         {
            cfree (ObjPtr->detail.p->svlist);
            ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
                  &(ObjPtr->detail.p->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            StretchObj (attr_ptr->obj, Corner);
         break;
      case OBJ_ARC:
         arc_ptr =  ObjPtr->detail.a;

         StretchedXY (OFFSET_X(arc_ptr->xc), OFFSET_Y(arc_ptr->yc), &x, &y);
#ifndef UC
         arc_ptr->xc = ObjPtr->x = (x<<zoomScale)+drawOrigX;
         arc_ptr->yc = ObjPtr->y = (y<<zoomScale)+drawOrigY;
         StretchedXY (OFFSET_X(arc_ptr->x1), OFFSET_Y(arc_ptr->y1), &x, &y);
         arc_ptr->x1 = (x<<zoomScale)+drawOrigX;
         arc_ptr->y1 = (y<<zoomScale)+drawOrigY;
         StretchedXY (OFFSET_X(arc_ptr->x2), OFFSET_Y(arc_ptr->y2), &x, &y);
         arc_ptr->x2 = (x<<zoomScale)+drawOrigX;
         arc_ptr->y2 = (y<<zoomScale)+drawOrigY;
         StretchedXY (OFFSET_X(arc_ptr->ltx), OFFSET_Y(arc_ptr->lty), &x, &y);
         arc_ptr->w = 2*abs((x<<zoomScale)+drawOrigX-arc_ptr->xc);
         arc_ptr->h = 2*abs((y<<zoomScale)+drawOrigY-arc_ptr->yc);
#else /* UC */
         arc_ptr->xc = ObjPtr->x = (RealSize(x, zoomScale))+drawOrigX;
         arc_ptr->yc = ObjPtr->y = (RealSize(y, zoomScale))+drawOrigY;
         StretchedXY (OFFSET_X(arc_ptr->x1), OFFSET_Y(arc_ptr->y1), &x, &y);
         arc_ptr->x1 = (RealSize(x, zoomScale))+drawOrigX;
         arc_ptr->y1 = (RealSize(y, zoomScale))+drawOrigY;
         StretchedXY (OFFSET_X(arc_ptr->x2), OFFSET_Y(arc_ptr->y2), &x, &y);
         arc_ptr->x2 = (RealSize(x, zoomScale))+drawOrigX;
         arc_ptr->y2 = (RealSize(y, zoomScale))+drawOrigY;
         StretchedXY (OFFSET_X(arc_ptr->ltx), OFFSET_Y(arc_ptr->lty), &x, &y);
         arc_ptr->w = 2*abs((RealSize(x, zoomScale))+drawOrigX-arc_ptr->xc);
         arc_ptr->h = 2*abs((RealSize(y, zoomScale))+drawOrigY-arc_ptr->yc);
#endif /* UC */
         arc_ptr->ltx = arc_ptr->xc-(arc_ptr->w/2);
         arc_ptr->lty = arc_ptr->yc-(arc_ptr->h/2);

         if (multX < 0)
         {
            if (arc_ptr->angle1 > 0)
               arc_ptr->angle1 = (180*64) - arc_ptr->angle1;
            else
               arc_ptr->angle1 = (-180)*64 - arc_ptr->angle1;
            arc_ptr->angle2 = -(arc_ptr->angle2);
         }
         if (multY < 0)
         {
            arc_ptr->angle1 = -(arc_ptr->angle1);
            arc_ptr->angle2 = -(arc_ptr->angle2);
         }

         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            StretchObj (attr_ptr->obj, Corner);
         break;
      case OBJ_RCBOX:
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            StretchObj (attr_ptr->obj, Corner);
         break;
      case OBJ_BOX:
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            StretchObj (attr_ptr->obj, Corner);
         break;
      case OBJ_OVAL:
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            StretchObj (attr_ptr->obj, Corner);
         break;
      case OBJ_TEXT: break;
      case OBJ_POLYGON:
         for (i = 0; i < ObjPtr->detail.g->n; i++)
         {
            StretchedXY (OFFSET_X(ObjPtr->detail.g->vlist[i].x),
                  OFFSET_Y(ObjPtr->detail.g->vlist[i].y), &x, &y);
#ifndef UC
            ObjPtr->detail.g->vlist[i].x = (x << zoomScale) + drawOrigX;
            ObjPtr->detail.g->vlist[i].y = (y << zoomScale) + drawOrigY;
#else /* UC */
            ObjPtr->detail.g->vlist[i].x = (RealSize(x ,  zoomScale)) + drawOrigX;
            ObjPtr->detail.g->vlist[i].y = (RealSize(y ,  zoomScale)) + drawOrigY;
#endif /* UC */
         }
         if (ObjPtr->detail.g->curved)
         {
            cfree (ObjPtr->detail.g->svlist);
            ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
                  &(ObjPtr->detail.g->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            StretchObj (attr_ptr->obj, Corner);
         break;
      case OBJ_SYM:
      case OBJ_GROUP:
         for (ptr = ObjPtr->detail.r->first; ptr != NULL; ptr = ptr->next)
            StretchObj (ptr, Corner);
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            StretchObj (attr_ptr->obj, Corner);
         break;
      case OBJ_ICON: break;
      case OBJ_XBM: break;
   }
   AdjObjBBox (ObjPtr);
}

static
void StretchAllSel (Corner)
   int	Corner;
{
   struct SelRec	* sel_ptr;

   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      StretchObj (sel_ptr->obj, Corner);
}

static
void StretchBox (XGridOff, YGridOff, ObjPtr, Corner)
   int			XGridOff, YGridOff, Corner;
   struct ObjRec	* ObjPtr;
{
   int		x, y, stretching = TRUE;
   int		ltx, lty, rbx, rby, sel_ltx, sel_lty, sel_rbx, sel_rby;
   int		stretched_ltx, stretched_lty, stretched_rbx, stretched_rby;
   int		stretched_sel_ltx, stretched_sel_lty, stretched_sel_rbx;
   int		stretched_sel_rby;
   double	obj_w, obj_h;
   int		grid_x = XGridOff, grid_y = YGridOff;
   XEvent	input;
#ifdef UC
   register int showsize = showSize;
   register int hidedragcursor = hideDragCursor;
   register int cursordefined = FALSE;
#endif /* UC */

   SetPivot (Corner, ObjPtr->obbox);

   stretched_sel_ltx = sel_ltx = OFFSET_X(selLtX);
   stretched_sel_lty = sel_lty = OFFSET_Y(selLtY);
   stretched_sel_rbx = sel_rbx = OFFSET_X(selRbX);
   stretched_sel_rby = sel_rby = OFFSET_Y(selRbY);
   SelBox (drawWindow, revDefaultGC, stretched_sel_ltx-1, stretched_sel_lty-1,
         stretched_sel_rbx+1, stretched_sel_rby+1);

   stretched_ltx = ltx = OFFSET_X(ObjPtr->obbox.ltx);
   stretched_lty = lty = OFFSET_Y(ObjPtr->obbox.lty);
   stretched_rbx = rbx = OFFSET_X(ObjPtr->obbox.rbx);
   stretched_rby = rby = OFFSET_Y(ObjPtr->obbox.rby);
   SelBox (drawWindow, revDefaultGC, stretched_ltx, stretched_lty,
         stretched_rbx, stretched_rby);
#ifdef UC
   if (showsize)
       switch (Corner)
       {
          case 1: /* changeX && changeY && move left up*/
	   showHeightWidth (stretched_rbx, stretched_rby, stretched_ltx, stretched_lty, LEFTUP);
	   break;
          case 2: /* chagneY && move up */
	   showHeightWidth (XGridOff - (stretched_rbx - stretched_ltx),
			    stretched_rby, XGridOff, stretched_lty, UP);
	   break;
          case 3: /* changeX && changeY && move right up */
	   showHeightWidth (stretched_ltx, stretched_rby, stretched_rbx, stretched_lty, RIGHTUP);
	   break;
          case 4: /* changeX && move right */
	   showHeightWidth (stretched_ltx, YGridOff-(stretched_rby - stretched_lty),
			    stretched_rbx, YGridOff, RIGHT);
	   break;
          case 5: /* changeX && changeY && move right down */
	   showHeightWidth (stretched_ltx, stretched_lty, stretched_rbx, stretched_rby, RIGHTDOWN);
	   break;
          case 6: /* changeY && move down */
	   showHeightWidth (XGridOff - (stretched_rbx - stretched_ltx),
			    stretched_lty, XGridOff, stretched_rby, DOWN);
	   break;
          case 7: /* changeX && changeY && move left down */
	   showHeightWidth (stretched_rbx, stretched_lty, stretched_ltx, stretched_rby, LEFTDOWN);
	   break;
          case 8: /* changeX && move left */
	   showHeightWidth (stretched_rbx, YGridOff-(stretched_rby - stretched_lty),
			    stretched_ltx, YGridOff, LEFT);
	   break;
       }
#endif /* UC */

   if (ltx == rbx)
   {
      Msg ("Can not stretch!  Object has ZERO width!");
      SelBox (drawWindow, revDefaultGC, stretched_ltx, stretched_lty,
            stretched_rbx, stretched_rby);
      SelBox (drawWindow, revDefaultGC, stretched_sel_ltx-1,
            stretched_sel_lty-1, stretched_sel_rbx+1, stretched_sel_rby+1);
      return;
   }
   else if (lty == rby)
   {
      Msg ("Can not stretch!  Object has ZERO height!");
      SelBox (drawWindow, revDefaultGC, stretched_ltx, stretched_lty,
            stretched_rbx, stretched_rby);
      SelBox (drawWindow, revDefaultGC, stretched_sel_ltx-1,
            stretched_sel_lty-1, stretched_sel_rbx+1, stretched_sel_rby+1);
      return;
   }

   obj_w = (double)(moveX - pivotX);
   obj_h = (double)(moveY - pivotY);

   XGrabPointer (mainDisplay, drawWindow, FALSE,
         PointerMotionMask | ButtonReleaseMask,
#ifndef UC
         GrabModeAsync, GrabModeAsync, None, handCursor, CurrentTime);
#else /* UC */
         GrabModeAsync, GrabModeAsync, None,((hidedragcursor)? None:handCursor), CurrentTime);
#endif /* UC */

   while (stretching)
   {
      XNextEvent (mainDisplay, &input);
      if (input.type == ButtonRelease)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
#ifdef UC
	 if (hidedragcursor && cursordefined)
	 {
	     XDefineCursor (mainDisplay, drawWindow, defaultCursor);
	     cursordefined = FALSE;
	 }
#endif /* UC */
#ifdef UC
	 if (showsize) eraseSizeString ();
#endif /* UC */
         stretching = FALSE;

         SelBox (drawWindow, revDefaultGC, stretched_ltx, stretched_lty,
               stretched_rbx, stretched_rby);
         SelBox (drawWindow, revDefaultGC, stretched_sel_ltx-1,
               stretched_sel_lty-1, stretched_sel_rbx+1, stretched_sel_rby+1);

         if (multX != (double)1.0 || multY != (double)1.0)
         {
#ifndef UC
            HighLightReverse ();
            StretchAllSel (Corner);
            CalcBBox (stretched_sel_ltx, stretched_sel_lty, stretched_sel_rbx,
                  stretched_sel_rby, &ltx, &lty, &rbx, &rby);
            RedrawAreas (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
                  selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)),
                  (RealSize((ltx-1), zoomScale))+drawOrigX,
                  (RealSize((lty-1), zoomScale))+drawOrigY,
                  (RealSize((rbx+1), zoomScale))+drawOrigX,
                  (RealSize((rby+1), zoomScale))+drawOrigY);
            HighLightForward ();
            UpdSelBBox ();
            SetFileModified (TRUE);
#else /* UC */
	    DoStretchBox (Corner, stretched_sel_ltx, stretched_sel_lty,
			  stretched_sel_rbx, stretched_sel_rby);
#endif /* UC */
         }
      }
      else if (input.type == MotionNotify)
      {
#ifdef UC
	 if (showsize) eraseSizeString ();
#endif /* UC */
         x = input.xmotion.x;
         y = input.xmotion.y;
         GridXY (x, y, &grid_x, &grid_y);
         MarkRulers (grid_x, grid_y);

         SelBox (drawWindow, revDefaultGC, stretched_ltx, stretched_lty,
               stretched_rbx, stretched_rby);
         SelBox (drawWindow, revDefaultGC, stretched_sel_ltx-1,
               stretched_sel_lty-1, stretched_sel_rbx+1, stretched_sel_rby+1);

         if (changeX)
            multX = (double)(moveX + grid_x - XGridOff - pivotX) / obj_w;
         else
            multX = (double)1.0;
         if (changeY)
            multY = (double)(moveY + grid_y - YGridOff - pivotY) / obj_h;
         else
            multY = (double)1.0;
#ifdef UC
	 if (hidedragcursor &&
	     (multX != 1.0 || multY != 1.0) && !cursordefined)
	 {
	     XDefineCursor (mainDisplay, drawWindow, dragCursor);
	     cursordefined = TRUE;
	 }
#endif /* UC */

         StretchedXY (sel_ltx, sel_lty, &stretched_sel_ltx, &stretched_sel_lty);
         StretchedXY (sel_rbx, sel_rby, &stretched_sel_rbx, &stretched_sel_rby);
         StretchedXY (ltx, lty, &stretched_ltx, &stretched_lty);
         StretchedXY (rbx, rby, &stretched_rbx, &stretched_rby);
         SelBox (drawWindow, revDefaultGC, stretched_sel_ltx-1,
               stretched_sel_lty-1, stretched_sel_rbx+1, stretched_sel_rby+1);
         SelBox (drawWindow, revDefaultGC, stretched_ltx, stretched_lty,
               stretched_rbx, stretched_rby);
#ifdef UC
	 if (showsize)
	     switch (Corner)
	     {
		case 1: /* changeX && changeY && move left up*/
		    showHeightWidth (stretched_rbx, stretched_rby, stretched_ltx, stretched_lty, LEFTUP);
		    break;
		case 2: /* chagneY && move up */
		    showLength (XGridOff, stretched_rby, XGridOff, stretched_lty, UP);
		    break;
		case 3: /* changeX && changeY && move right up */
		    showHeightWidth (stretched_ltx, stretched_rby, stretched_rbx, stretched_lty, RIGHTUP);
		    break;
		case 4: /* changeX && move right */
		    showLength (stretched_ltx, YGridOff, stretched_rbx, YGridOff, RIGHT);
		    break;
		case 5: /* changeX && changeY && move right down */
		    showHeightWidth (stretched_ltx, stretched_lty, stretched_rbx, stretched_rby, RIGHTDOWN);
		    break;
		case 6: /* changeY && move down */
		    showLength (XGridOff, stretched_lty, XGridOff, stretched_rby, DOWN);
		    break;
		case 7: /* changeX && changeY && move left down */
		    showHeightWidth (stretched_rbx, stretched_lty, stretched_ltx, stretched_rby, LEFTDOWN);
		    break;
		case 8: /* changeX && move left */
		    showLength (stretched_rbx, YGridOff, stretched_ltx, YGridOff, LEFT);
		    break;
	    }
#endif /* UC */
      }
   }
}

void StretchSel (XGridOff, YGridOff, ObjPtr, Corner)
   int			XGridOff, YGridOff, Corner;
   struct ObjRec	* ObjPtr;
{
   switch (ObjPtr->type)
   {
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_GROUP:
      case OBJ_ARC:
      case OBJ_RCBOX:
      case OBJ_SYM:
      case OBJ_TEXT:
         StretchBox (XGridOff, YGridOff, ObjPtr, Corner);
         break;
      case OBJ_POLY:
         StretchPoly (XGridOff, YGridOff, ObjPtr, ObjPtr->detail.p->n,
               ObjPtr->detail.p->vlist, Corner);
         break;
      case OBJ_POLYGON:
         StretchPoly (XGridOff, YGridOff, ObjPtr, ObjPtr->detail.g->n,
               ObjPtr->detail.g->vlist, Corner);
         break;
      case OBJ_ICON: break;
      case OBJ_XBM: break;
   }
}

static
void FlipObjHorizontal (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register XPoint	* v;
   register int		i, two_x_pivot;
   int			new_obj_ltx, new_obj_rbx, num_pts;
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr;
   struct ArcRec	* arc_ptr;

   SetFileModified (TRUE);
   two_x_pivot = selObjLtX + selObjRbX;
   new_obj_ltx = two_x_pivot - ObjPtr->obbox.rbx;
   new_obj_rbx = two_x_pivot - ObjPtr->obbox.ltx;
   switch (ObjPtr->type)
   {
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_POLY:
      case OBJ_POLYGON:
      case OBJ_ARC:
      case OBJ_RCBOX:
      case OBJ_XBM:
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         if (ObjPtr->type == OBJ_XBM) FlipXBmHorizontal (ObjPtr);
         ObjPtr->obbox.ltx = ObjPtr->x = new_obj_ltx;
         ObjPtr->obbox.rbx = new_obj_rbx;
         break;
      case OBJ_TEXT:
         switch (ObjPtr->detail.t->rotate)
         {
            case ROTATE0:
            case ROTATE180:
               ObjPtr->x = two_x_pivot - ObjPtr->x;
               ObjPtr->detail.t ->just = MAXJUSTS - 1 - ObjPtr->detail.t->just;
               break;
            case ROTATE90: ObjPtr->x = new_obj_rbx; break;
            case ROTATE270: ObjPtr->x = new_obj_ltx; break;
         }
         UpdTextBBox (ObjPtr);
         break;
/*    case OBJ_ICON: */
/*       dx = new_obj_ltx - ObjPtr->x; */
/*       MoveObj (ObjPtr, dx, 0); */
/*       break; */
   }
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         num_pts = ObjPtr->detail.p->n;
         v = ObjPtr->detail.p->vlist;
         for (i = 0; i < num_pts; i++, v++) (*v).x = two_x_pivot - (*v).x;
         if (ObjPtr->detail.p->curved)
         {
            cfree (ObjPtr->detail.p->svlist);
            ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
                  &(ObjPtr->detail.p->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjHorizontal (attr_ptr->obj);
         break;
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_RCBOX:
      case OBJ_XBM:
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjHorizontal (attr_ptr->obj);
         break;
      case OBJ_TEXT: break;
      case OBJ_POLYGON:
         num_pts = ObjPtr->detail.g->n;
         v = ObjPtr->detail.g->vlist;
         for (i = 0; i < num_pts; i++, v++) (*v).x = two_x_pivot - (*v).x;
         if (ObjPtr->detail.g->curved)
         {
            cfree (ObjPtr->detail.g->svlist);
            ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
                  &(ObjPtr->detail.g->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjHorizontal (attr_ptr->obj);
         break;
      case OBJ_ARC:
         arc_ptr = ObjPtr->detail.a;
         arc_ptr->xc = two_x_pivot - arc_ptr->xc;
         arc_ptr->x1 = two_x_pivot - arc_ptr->x1;
         arc_ptr->x2 = two_x_pivot - arc_ptr->x2;
         arc_ptr->dir = !(arc_ptr->dir);
         arc_ptr->ltx = two_x_pivot - arc_ptr->ltx - arc_ptr->w;
         if (arc_ptr->angle1 > 0)
            arc_ptr->angle1 = (180*64) - arc_ptr->angle1;
         else
            arc_ptr->angle1 = (-180)*64 - arc_ptr->angle1;
         arc_ptr->angle2 = -(arc_ptr->angle2);
         UpdArcBBox (ObjPtr);
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjHorizontal (attr_ptr->obj);
         break;
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         obj_ptr = ObjPtr->detail.r->first;
         for ( ; obj_ptr != NULL; obj_ptr = obj_ptr->next)
            FlipObjHorizontal (obj_ptr);
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjHorizontal (attr_ptr->obj);
         break;
/*    case OBJ_ICON: break; */
   }
   AdjObjBBox (ObjPtr);
}

static
void FlipObjVertical (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register XPoint	* v;
   register int		i, two_x_pivot;
   int			new_obj_lty, new_obj_rby, num_pts;
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr;
   struct ArcRec	* arc_ptr;

   SetFileModified (TRUE);
   two_x_pivot = selObjLtY + selObjRbY;
   new_obj_lty = two_x_pivot - ObjPtr->obbox.rby;
   new_obj_rby = two_x_pivot - ObjPtr->obbox.lty;
   switch (ObjPtr->type)
   {
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_POLY:
      case OBJ_POLYGON:
      case OBJ_ARC:
      case OBJ_RCBOX:
      case OBJ_XBM:
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         if (ObjPtr->type == OBJ_XBM) FlipXBmVertical (ObjPtr);
         ObjPtr->obbox.lty = ObjPtr->y = new_obj_lty;
         ObjPtr->obbox.rby = new_obj_rby;
         break;
      case OBJ_TEXT:
         switch (ObjPtr->detail.t->rotate)
         {
            case ROTATE0: ObjPtr->y = new_obj_lty; break;
            case ROTATE180: ObjPtr->y = new_obj_rby; break;
            case ROTATE90:
            case ROTATE270:
               ObjPtr->y = two_x_pivot - ObjPtr->y;
               ObjPtr->detail.t ->just = MAXJUSTS - 1 - ObjPtr->detail.t->just;
               break;
         }
         UpdTextBBox (ObjPtr);
         break;
/*    case OBJ_ICON: */
/*       dy = new_obj_lty - ObjPtr->y; */
/*       MoveObj (ObjPtr, 0, dy); */
/*       break; */
   }
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         num_pts = ObjPtr->detail.p->n;
         v = ObjPtr->detail.p->vlist;
         for (i = 0; i < num_pts; i++, v++) (*v).y = two_x_pivot - (*v).y;
         if (ObjPtr->detail.p->curved)
         {
            cfree (ObjPtr->detail.p->svlist);
            ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
                  &(ObjPtr->detail.p->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjVertical (attr_ptr->obj);
         break;
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_RCBOX:
      case OBJ_XBM:
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjVertical (attr_ptr->obj);
         break;
      case OBJ_TEXT: break;
      case OBJ_POLYGON:
         num_pts = ObjPtr->detail.g->n;
         v = ObjPtr->detail.g->vlist;
         for (i = 0; i < num_pts; i++, v++) (*v).y = two_x_pivot - (*v).y;
         if (ObjPtr->detail.g->curved)
         {
            cfree (ObjPtr->detail.g->svlist);
            ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
                  &(ObjPtr->detail.g->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjVertical (attr_ptr->obj);
         break;
      case OBJ_ARC:
         arc_ptr = ObjPtr->detail.a;
         arc_ptr->yc = two_x_pivot - arc_ptr->yc;
         arc_ptr->y1 = two_x_pivot - arc_ptr->y1;
         arc_ptr->y2 = two_x_pivot - arc_ptr->y2;
         arc_ptr->dir = !(arc_ptr->dir);
         arc_ptr->lty = two_x_pivot - arc_ptr->lty - arc_ptr->h;
         arc_ptr->angle1 = -(arc_ptr->angle1);
         arc_ptr->angle2 = -(arc_ptr->angle2);
         UpdArcBBox (ObjPtr);
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjVertical (attr_ptr->obj);
         break;
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         obj_ptr = ObjPtr->detail.r->first;
         for ( ; obj_ptr != NULL; obj_ptr = obj_ptr->next)
            FlipObjVertical (obj_ptr);
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            FlipObjVertical (attr_ptr->obj);
         break;
/*    case OBJ_ICON: break; */
   }
   AdjObjBBox (ObjPtr);
}

static int	rotatePivotX;
static int	rotatePivotY;

static
void SetRotatePivot ()
{
   if (topSel != NULL && topSel == botSel && topSel->obj->type == OBJ_TEXT)
   {
      rotatePivotX = topSel->obj->x;
      rotatePivotY = topSel->obj->y;
   }
   else
   {
      rotatePivotX = (selObjLtX + selObjRbX) / 2;
      rotatePivotY = (selObjLtY + selObjRbY) / 2;
   }
}

static
void RotatePtClockWise (X, Y, NewX, NewY)
   int	X, Y, * NewX, * NewY;
{
   *NewX = rotatePivotX + rotatePivotY - Y;
   *NewY = rotatePivotY - rotatePivotX + X;
}

static
void RotateObjClockWise (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register XPoint	* v;
   register int		i;
   int			x, y, ltx, lty, rbx, rby, num_pts, new_h;
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr;
   struct ArcRec	* arc_ptr;

   SetFileModified (TRUE);
   switch (ObjPtr->type)
   {
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_POLY:
      case OBJ_POLYGON:
      case OBJ_ARC:
      case OBJ_RCBOX:
      case OBJ_XBM:
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         if (ObjPtr->type == OBJ_XBM) RotateXBmClockWise (ObjPtr);
         RotatePtClockWise (ObjPtr->obbox.ltx, ObjPtr->obbox.rby, &ltx, &lty);
         RotatePtClockWise (ObjPtr->obbox.rbx, ObjPtr->obbox.lty, &rbx, &rby);
         ObjPtr->obbox.ltx = ObjPtr->x = ltx;
         ObjPtr->obbox.lty = ObjPtr->y = lty;
         ObjPtr->obbox.rbx = rbx;
         ObjPtr->obbox.rby = rby;
         break;
      case OBJ_TEXT:
         RotatePtClockWise (ObjPtr->x, ObjPtr->y, &x, &y);
         ObjPtr->x = x;
         ObjPtr->y = y;
         ObjPtr->detail.t->rotate = (ObjPtr->detail.t->rotate+1) & 0x3;
         UpdTextBBox (ObjPtr);
         break;
/*    case OBJ_ICON: */
/*       RotatePtClockWise (ObjPtr->obbox.ltx, ObjPtr->obbox.lty, &ltx, &lty);*/
/*       dx = ltx - ObjPtr->obbox.ltx; */
/*       dy = lty - ObjPtr->obbox.lty; */
/*       MoveObj (ObjPtr, dx, dy); */
/*       break; */
   }
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         num_pts = ObjPtr->detail.p->n;
         v = ObjPtr->detail.p->vlist;
         for (i = 0; i < num_pts; i++, v++)
         {
            RotatePtClockWise ((*v).x, (*v).y, &x, &y);
            (*v).x = x;
            (*v).y = y;
         }
         if (ObjPtr->detail.p->curved)
         {
            cfree (ObjPtr->detail.p->svlist);
            ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
                  &(ObjPtr->detail.p->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjClockWise (attr_ptr->obj);
         break;
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_RCBOX:
      case OBJ_XBM:
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjClockWise (attr_ptr->obj);
         break;
      case OBJ_TEXT: break;
      case OBJ_POLYGON:
         num_pts = ObjPtr->detail.g->n;
         v = ObjPtr->detail.g->vlist;
         for (i = 0; i < num_pts; i++, v++)
         {
            RotatePtClockWise ((*v).x, (*v).y, &x, &y);
            (*v).x = x;
            (*v).y = y;
         }
         if (ObjPtr->detail.g->curved)
         {
            cfree (ObjPtr->detail.g->svlist);
            ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
                  &(ObjPtr->detail.g->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjClockWise (attr_ptr->obj);
         break;
      case OBJ_ARC:
         arc_ptr = ObjPtr->detail.a;

         RotatePtClockWise (arc_ptr->xc, arc_ptr->yc, &x, &y);
         arc_ptr->xc = ObjPtr->x = x; arc_ptr->yc = ObjPtr->y = y;
         RotatePtClockWise (arc_ptr->x1, arc_ptr->y1, &x, &y);
         arc_ptr->x1 = x; arc_ptr->y1 = y;
         RotatePtClockWise (arc_ptr->x2, arc_ptr->y2, &x, &y);
         arc_ptr->x2 = x; arc_ptr->y2 = y;
         RotatePtClockWise (arc_ptr->ltx, arc_ptr->lty+arc_ptr->h, &x, &y);
         arc_ptr->ltx = x; arc_ptr->lty = y;
         new_h = arc_ptr->w;
         arc_ptr->w = arc_ptr->h; arc_ptr->h = new_h;
         arc_ptr->angle1 -= (arc_ptr->angle1 < (-90*64)) ? (-270*64) : (90*64);
         UpdArcBBox (ObjPtr);

         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjClockWise (attr_ptr->obj);
         break;
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         obj_ptr = ObjPtr->detail.r->first;
         for ( ; obj_ptr != NULL; obj_ptr = obj_ptr->next)
            RotateObjClockWise (obj_ptr);
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjClockWise (attr_ptr->obj);
         break;
/*    case OBJ_ICON: break; */
   }
   AdjObjBBox (ObjPtr);
}

static
void RotatePtCounter (X, Y, NewX, NewY)
   int	X, Y, * NewX, * NewY;
{
   *NewX = rotatePivotX - rotatePivotY + Y;
   *NewY = rotatePivotY + rotatePivotX - X;
}

static
void RotateObjCounter (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register XPoint	* v;
   register int		i;
   int			x, y, ltx, lty, rbx, rby, num_pts, new_h;
   struct ObjRec	* obj_ptr;
   struct AttrRec	* attr_ptr;
   struct ArcRec	* arc_ptr;

   SetFileModified (TRUE);
   switch (ObjPtr->type)
   {
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_POLY:
      case OBJ_POLYGON:
      case OBJ_ARC:
      case OBJ_RCBOX:
      case OBJ_XBM:
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         if (ObjPtr->type == OBJ_XBM) RotateXBmCounter (ObjPtr);
         RotatePtCounter (ObjPtr->obbox.rbx, ObjPtr->obbox.lty, &ltx, &lty);
         RotatePtCounter (ObjPtr->obbox.ltx, ObjPtr->obbox.rby, &rbx, &rby);
         ObjPtr->obbox.ltx = ObjPtr->x = ltx;
         ObjPtr->obbox.lty = ObjPtr->y = lty;
         ObjPtr->obbox.rbx = rbx;
         ObjPtr->obbox.rby = rby;
         break;
      case OBJ_TEXT:
         RotatePtCounter (ObjPtr->x, ObjPtr->y, &x, &y);
         ObjPtr->x = x;
         ObjPtr->y = y;
         ObjPtr->detail.t->rotate = (ObjPtr->detail.t->rotate+3) & 0x3;
         UpdTextBBox (ObjPtr);
         break;
/*    case OBJ_ICON: */
/*       RotatePtCounter (ObjPtr->obbox.ltx, ObjPtr->obbox.lty, &ltx, &lty); */
/*       dx = ltx - ObjPtr->obbox.ltx; */
/*       dy = lty - ObjPtr->obbox.lty; */
/*       MoveObj (ObjPtr, dx, dy); */
/*       break; */
   }
   switch (ObjPtr->type)
   {
      case OBJ_POLY:
         num_pts = ObjPtr->detail.p->n;
         v = ObjPtr->detail.p->vlist;
         for (i = 0; i < num_pts; i++, v++)
         {
            RotatePtCounter ((*v).x, (*v).y, &x, &y);
            (*v).x = x;
            (*v).y = y;
         }
         if (ObjPtr->detail.p->curved)
         {
            cfree (ObjPtr->detail.p->svlist);
            ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
                  &(ObjPtr->detail.p->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjCounter (attr_ptr->obj);
         break;
      case OBJ_BOX:
      case OBJ_OVAL:
      case OBJ_RCBOX:
      case OBJ_XBM:
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjCounter (attr_ptr->obj);
         break;
      case OBJ_TEXT: break;
      case OBJ_POLYGON:
         num_pts = ObjPtr->detail.g->n;
         v = ObjPtr->detail.g->vlist;
         for (i = 0; i < num_pts; i++, v++)
         {
            RotatePtCounter ((*v).x, (*v).y, &x, &y);
            (*v).x = x;
            (*v).y = y;
         }
         if (ObjPtr->detail.g->curved)
         {
            cfree (ObjPtr->detail.g->svlist);
            ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
                  &(ObjPtr->detail.g->sn), drawOrigX,
                  drawOrigY, ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
         }
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjCounter (attr_ptr->obj);
         break;
      case OBJ_ARC:
         arc_ptr = ObjPtr->detail.a;

         RotatePtCounter (arc_ptr->xc, arc_ptr->yc, &x, &y);
         arc_ptr->xc = ObjPtr->x = x; arc_ptr->yc = ObjPtr->y = y;
         RotatePtCounter (arc_ptr->x1, arc_ptr->y1, &x, &y);
         arc_ptr->x1 = x; arc_ptr->y1 = y;
         RotatePtCounter (arc_ptr->x2, arc_ptr->y2, &x, &y);
         arc_ptr->x2 = x; arc_ptr->y2 = y;
         RotatePtCounter (arc_ptr->ltx+arc_ptr->w, arc_ptr->lty, &x, &y);
         arc_ptr->ltx = x; arc_ptr->lty = y;
         new_h = arc_ptr->w;
         arc_ptr->w = arc_ptr->h; arc_ptr->h = new_h;
         arc_ptr->angle1 += (arc_ptr->angle1 > 90*64) ? (-270*64) : (90*64);
         UpdArcBBox (ObjPtr);

         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjCounter (attr_ptr->obj);
         break;
      case OBJ_GROUP:
      case OBJ_SYM:
      case OBJ_ICON:
         obj_ptr = ObjPtr->detail.r->first;
         for ( ; obj_ptr != NULL; obj_ptr = obj_ptr->next)
            RotateObjCounter (obj_ptr);
         attr_ptr = ObjPtr->fattr;
         for ( ; attr_ptr != NULL; attr_ptr = attr_ptr->next)
            RotateObjCounter (attr_ptr->obj);
         break;
/*    case OBJ_ICON: break; */
   }
   AdjObjBBox (ObjPtr);
}

void FlipHorizontal ()
{
   register struct SelRec	* sel_ptr;
   int				saved_ltx, saved_lty, saved_rbx, saved_rby;

   if (topSel == NULL) return;

   saved_ltx = selLtX; saved_lty = selLtY;
   saved_rbx = selRbX; saved_rby = selRbY;
   HighLightReverse ();
   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      FlipObjHorizontal (sel_ptr->obj);
   UpdSelBBox ();
#ifndef UC
   RedrawAreas (botObj, saved_ltx-(1<<zoomScale), saved_lty-(1<<zoomScale),
         saved_rbx+(1<<zoomScale), saved_rby+(1<<zoomScale),
         selLtX-(1<<zoomScale), selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
         selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAreas (botObj, saved_ltx-(RealSize(1, zoomScale)), saved_lty-(RealSize(1, zoomScale)),
         saved_rbx+(RealSize(1, zoomScale)), saved_rby+(RealSize(1, zoomScale)),
         selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
         selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   justDupped = FALSE;
}

void FlipVertical ()
{
   register struct SelRec	* sel_ptr;
   int				saved_ltx, saved_lty, saved_rbx, saved_rby;

   if (topSel == NULL) return;

   saved_ltx = selLtX; saved_lty = selLtY;
   saved_rbx = selRbX; saved_rby = selRbY;
   HighLightReverse ();
   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      FlipObjVertical (sel_ptr->obj);
   UpdSelBBox ();
#ifndef UC
   RedrawAreas (botObj, saved_ltx-(1<<zoomScale), saved_lty-(1<<zoomScale),
         saved_rbx+(1<<zoomScale), saved_rby+(1<<zoomScale),
         selLtX-(1<<zoomScale), selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
         selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAreas (botObj, saved_ltx-(RealSize(1, zoomScale)), saved_lty-(RealSize(1, zoomScale)),
         saved_rbx+(RealSize(1, zoomScale)), saved_rby+(RealSize(1, zoomScale)),
         selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
         selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   justDupped = FALSE;
}

void RotateClockWise ()
{
   register struct SelRec	* sel_ptr;
   int				saved_ltx, saved_lty, saved_rbx, saved_rby;
   int				text_obj_created, text_cursor_shown;

   if  (topSel == NULL)
   {
      text_cursor_shown = textCursorShown;
      text_obj_created = TieLooseEnds ();
      curRotate = (curRotate+1) & 0x3;
      ShowRotate ();
      if (!text_obj_created && curChoice == DRAWTEXT && text_cursor_shown)
      {
         NewCurText ();
         RedrawCurText ();
      }
      else
         textCursorShown = FALSE;
      return;
   }

   saved_ltx = selLtX; saved_lty = selLtY;
   saved_rbx = selRbX; saved_rby = selRbY;
   HighLightReverse ();
   SetRotatePivot ();
   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      RotateObjClockWise (sel_ptr->obj);
   UpdSelBBox ();
#ifndef UC
   RedrawAreas (botObj, saved_ltx-(1<<zoomScale), saved_lty-(1<<zoomScale),
         saved_rbx+(1<<zoomScale), saved_rby+(1<<zoomScale),
         selLtX-(1<<zoomScale), selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
         selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAreas (botObj, saved_ltx-(RealSize(1, zoomScale)), saved_lty-(RealSize(1, zoomScale)),
         saved_rbx+(RealSize(1, zoomScale)), saved_rby+(RealSize(1, zoomScale)),
         selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
         selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   justDupped = FALSE;
}

void RotateCounter ()
{
   register struct SelRec	* sel_ptr;
   int				saved_ltx, saved_lty, saved_rbx, saved_rby;
   int				text_obj_created, text_cursor_shown;

   if  (topSel == NULL)
   {
      text_cursor_shown = textCursorShown;
      text_obj_created = TieLooseEnds ();
      curRotate = (curRotate+3) & 0x3;
      ShowRotate ();
      if (!text_obj_created && curChoice == DRAWTEXT && text_cursor_shown)
      {
         NewCurText ();
         RedrawCurText ();
      }
      else
         textCursorShown = FALSE;
      return;
   }

   saved_ltx = selLtX; saved_lty = selLtY;
   saved_rbx = selRbX; saved_rby = selRbY;
   HighLightReverse ();
   SetRotatePivot ();
   for (sel_ptr = topSel; sel_ptr != NULL; sel_ptr = sel_ptr->next)
      RotateObjCounter (sel_ptr->obj);
   UpdSelBBox ();
#ifndef UC
   RedrawAreas (botObj, saved_ltx-(1<<zoomScale), saved_lty-(1<<zoomScale),
         saved_rbx+(1<<zoomScale), saved_rby+(1<<zoomScale),
         selLtX-(1<<zoomScale), selLtY-(1<<zoomScale), selRbX+(1<<zoomScale),
         selRbY+(1<<zoomScale));
#else /* UC */
   RedrawAreas (botObj, saved_ltx-(RealSize(1, zoomScale)), saved_lty-(RealSize(1, zoomScale)),
         saved_rbx+(RealSize(1, zoomScale)), saved_rby+(RealSize(1, zoomScale)),
         selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)), selRbX+(RealSize(1, zoomScale)),
         selRbY+(RealSize(1, zoomScale)));
#endif /* UC */
   HighLightForward ();
   justDupped = FALSE;
}
#ifdef UC
void UndoStretchBox ()
{
   int	stretched_sel_ltx, stretched_sel_lty;
   int	stretched_sel_rbx, stretched_sel_rby;
   
   multX = undo.info.b.multX = (1.0/undo.info.b.multX);
   multY = undo.info.b.multY = (1.0/undo.info.b.multY);

   StretchedXY (undo.info.b.bbox.ltx, undo.info.b.bbox.lty,
		&stretched_sel_ltx, &stretched_sel_lty);
   StretchedXY (undo.info.b.bbox.rbx, undo.info.b.bbox.rby,
		&stretched_sel_rbx, &stretched_sel_rby);
   
   DoStretchBox (undo.info.b.corner,
		 stretched_sel_ltx, stretched_sel_lty,
		 stretched_sel_rbx, stretched_sel_rby);

}
void DoStretchBox (Corner, stretched_sel_ltx, stretched_sel_lty, stretched_sel_rbx, stretched_sel_rby)
int	Corner;
int	stretched_sel_ltx, stretched_sel_lty;
int	stretched_sel_rbx, stretched_sel_rby;
{
   int	ltx, lty, rbx, rby;

   if (multX == 0.0 || multY == 0.0)
   {
       Msg ("Objects can not be reduced to ZERO size");
       return;
   }
   
/* #ifdef UC2 */
   undo.operation = STRETCH;
   undo.object = OBJ_BOX;
   undo.info.b.bbox.ltx = stretched_sel_ltx;
   undo.info.b.bbox.lty = stretched_sel_lty;
   undo.info.b.bbox.rbx = stretched_sel_rbx;
   undo.info.b.bbox.rby = stretched_sel_rby;
   undo.info.b.multX = multX;
   undo.info.b.multY = multY;
   undo.info.b.corner = Corner;
/* #endif /_* UC2 *_/ */
    
    HighLightReverse ();
    StretchAllSel (Corner);
    CalcBBox (stretched_sel_ltx, stretched_sel_lty, stretched_sel_rbx,
	      stretched_sel_rby, &ltx, &lty, &rbx, &rby);
    RedrawAreas (botObj, selLtX-(RealSize(1, zoomScale)), selLtY-(RealSize(1, zoomScale)),
		 selRbX+(RealSize(1, zoomScale)), selRbY+(RealSize(1, zoomScale)),
		 (RealSize((ltx-1), zoomScale))+drawOrigX,
		 (RealSize((lty-1), zoomScale))+drawOrigY,
		 (RealSize((rbx+1), zoomScale))+drawOrigX,
		 (RealSize((rby+1), zoomScale))+drawOrigY);
    HighLightForward ();
    UpdSelBBox ();
    SetFileModified (TRUE);
}


void UndoStretchPoly ()
{
    register struct ObjRec	* objPtr;
    if (undo.operation != STRETCH)
    {
	Msg ("Bad UNDO %d", undo.operation);
	return;
    }
    switch (undo.object)
    {
       case OBJ_POLY:
	  undo.info.p.dx = -(undo.info.p.dx);
	  undo.info.p.dy = -(undo.info.p.dy);
	  objPtr = undo.info.p.objPtr;
	  DoStretchPoly (OBJ_POLY, objPtr, objPtr->detail.p->n,
			 objPtr->detail.p->vlist, undo.info.p.index,
			 undo.info.p.dx, undo.info.p.dy);
	  break;
       case OBJ_POLYGON:
	  undo.info.g.dx = -(undo.info.g.dx);
	  undo.info.g.dy = -(undo.info.g.dy);
	  objPtr = undo.info.g.objPtr;
	  DoStretchPoly (OBJ_POLYGON, objPtr, objPtr->detail.g->n,
			 objPtr->detail.g->vlist, undo.info.g.index,
			 undo.info.g.dx, undo.info.g.dy);
	  break;

     }
    HighLightForward ();
}

void DoStretchPoly (type, ObjPtr, NumPts, V, Index, dx, dy)
int type;
struct ObjRec 	* ObjPtr;
XPoint		* V;
int		Index, dx, dy, NumPts;
{
    int ltx, lty, rbx, rby;

    ltx = ObjPtr->bbox.ltx;
    lty = ObjPtr->bbox.lty;
    rbx = ObjPtr->bbox.rbx;
    rby = ObjPtr->bbox.rby;
	
    undo.operation = STRETCH;
    undo.object = type;
    
    switch (type)
    {
      case OBJ_POLY:
	  V[Index].x += dx; V[Index].y += dy;
	  if (Index == 0)
	  {
	      if (V[0].x == V[1].x && V[0].y == V[1].y)
		  goto bad;
	  }
	  else if (Index == NumPts-1)
	  {
	      if (V[Index].x == V[Index-1].x && V[Index].y == V[Index-1].y)
		  goto bad;
	  }
	  else
	  {
	      if ((V[Index].x == V[Index-1].x && V[Index].y == V[Index-1].y)||
		  (V[Index].x == V[Index+1].x && V[Index].y == V[Index+1].y))
		  goto bad;
	  }
	  if (ObjPtr->detail.p->curved)
	  {
	      cfree (ObjPtr->detail.p->svlist);
	      ObjPtr->detail.p->svlist = MakeSplinePolyVertex (
			  &(ObjPtr->detail.p->sn), drawOrigX, drawOrigY,
                           ObjPtr->detail.p->n, ObjPtr->detail.p->vlist);
	  }
	  break;
      case OBJ_POLYGON:
	  V[Index].x += dx; V[Index].y += dy;
	  if (Index == 0)
	  {
	      if ((V[0].x == V[1].x && V[0].y == V[1].y)||
		  (V[0].x == V[NumPts-2].x && V[0].y == V[NumPts-2].y))
		  goto bad;

	      V[NumPts-1].x += dx; V[NumPts-1].y += dy;
	  }
	  else if (Index == NumPts-1)
	  {
	      if ((V[Index].x == V[1].x && V[Index].y == V[1].y)||
		  (V[Index].x == V[Index-1].x && V[Index].y == V[Index-1].y))
		  goto bad;

	      V[0].x += dx; V[0].y += dy;
	  }
	  else
	  {
	      if ((V[Index].x == V[Index+1].x && V[Index].y == V[Index+1].y)||
		  (V[Index].x == V[Index-1].x && V[Index].y == V[Index-1].y))
		  goto bad;
	  }
	  if (ObjPtr->detail.g->curved)
	  {
	      cfree (ObjPtr->detail.g->svlist);
	      ObjPtr->detail.g->svlist = MakeSplinePolygonVertex (
			 &(ObjPtr->detail.g->sn), drawOrigX, drawOrigY,
                           ObjPtr->detail.g->n, ObjPtr->detail.g->vlist);
	  }
	  break;
    }
    undo.info.p.dx = dx;
    undo.info.p.dy = dy;
    undo.info.p.index = Index;
    undo.info.p.objPtr = ObjPtr;

    UpdPolyBBox (ObjPtr, NumPts, V);

    UpdSelBBox ();
    RedrawAreas (botObj, ltx-(RealSize(1, zoomScale)), lty-(RealSize(1, zoomScale)),
		 rbx+(RealSize(1, zoomScale)), rby+(RealSize(1, zoomScale)),
		 ObjPtr->bbox.ltx-(RealSize(1, zoomScale)),
		 ObjPtr->bbox.lty-(RealSize(1, zoomScale)),
		 ObjPtr->bbox.rbx+(RealSize(1, zoomScale)),
		 ObjPtr->bbox.rby+(RealSize(1, zoomScale)));
    SetFileModified (TRUE);
    return;
 bad:	      
    V[Index].x -= dx; V[Index].y -= dy; 
    Msg ("Line Objects can not be reduced to ZERO size");
}
#endif /* UC */
