/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/text.c,v 2.0 91/03/05 12:48:39 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "attr.e"
#include "choice.e"
#include "color.e"
#include "cursor.e"
#include "dup.e"
#include "file.e"
#include "font.e"
#include "grid.e"
#include "obj.e"
#include "pattern.e"
#include "poly.e"
#include "prtgif.e"
#include "raster.e"
#include "ruler.e"
#include "setup.e"
#ifdef KINPUT
#include "kconvert.e"
#endif /* KINPUT */
#ifdef KANJI
#include "kanji.e"

/* defines for drawing KANJI strings */
#define XTextWidth(canvasFontPtr, Str, Strlen) \
	XEucTextWidth(canvasFontPtr, canvasKanjiFontPtr, Str, Strlen, 0)
#define XTextFakeWidth(canvasFontPtr, Str, Strlen) \
	XEucTextWidth(canvasFontPtr, canvasKanjiFontPtr, Str, Strlen, canvasKanjiFontIsFake)
#define XDrawString(mainDisplay, drawWindow, drawGC, LtX, LtY, Str, Strlen) \
	XDrawEucString(mainDisplay, drawWindow, drawGC, LtX, LtY, Str, Strlen, \
			 canvasFontPtr, canvasKanjiFontPtr)
#define XDrawImageString(mainDisplay, drawWindow, drawGC, LtX, LtY, Str, Strlen) \
	XDrawEucImageString(mainDisplay, drawWindow, drawGC, LtX, LtY, Str, Strlen, \
			 canvasFontPtr, canvasKanjiFontPtr)
#endif /* KANJI */

#define PAINT 1
#define FRONT_HIGHLIGHT 2
#define MID_HIGHLIGHT 4
#define BACK_HIGHLIGHT 8

#define ERASE 0
#define PAINT_NORM (PAINT)
#define PAINT_INV (PAINT|FRONT_HIGHLIGHT|MID_HIGHLIGHT|BACK_HIGHLIGHT)
#define PAINT_NORM_INV (PAINT|MID_HIGHLIGHT|BACK_HIGHLIGHT)
#define PAINT_INV_NORM (PAINT|FRONT_HIGHLIGHT)
#define PAINT_NORM_INV_NORM (PAINT|MID_HIGHLIGHT)

int		textDrawn = FALSE;

int		textJust = JUST_L;
int		textCursorShown = FALSE;
int		textCursorH; /* UNSCALED height of the text cursor */
struct ObjRec	* curTextObj = NULL;

static struct ObjRec	* justDrawnTextObj = NULL;

static struct StrRec	* firstStr = NULL, * lastStr = NULL, * curStr = NULL;

static int	textOrigX = 20, textOrigY = 20, textCurX = 20, textCurY = 20;
		/* textOrigX, textOrigY, textCurX, textCurY */
		/*   are UNSCALED screen offsets */
static int	textW, textH; /* absolute for the current text font */
static int	textAbsX = INVALID, textAbsY = INVALID;
		/* textAbsX and textAbsY are absolute coordinates */
static int	textCurIndex = 0;
static int	curStrW = 0; /* UNSCALED width of the current string */
static int	editingText = FALSE;
static int      lowGreekMap[] = { 11, 12, 31, 14, 15, 30, 13, 17, 19, 125, 20,
                                21, 22, 23, -1, 25, 18, 26, 27, 28, 29, -1,
                                124, 24, 123, 16 };
static int     upperGreekMap[] = { -1, -1, -1, 1, -1, 8, -1, -1, -1, -1, -1, 3,
                                  -1, -1, -1, 5, 2, -1, 6, -1, -1, -1, 10,
                                  4, 9, -1 };

static int	savedTextLtX, savedTextLtY, savedTextRbX, savedTextRbY;

static int	tmpAdjX, tmpAdjY;

/* the following static variables are for handling text highlight */
static int		textEndX, textEndY, textEndIndex, textHighlight = FALSE;
static int		endStrW;
static struct StrRec	* endStr = NULL;

#define BLUR 20

extern void	RedrawCurText ();
extern void	DrawTextObj ();

static
void BlurText (Win, gc, Just, Rotate, XOff, YOff, W, H)
   Window	Win;
   GC		gc;
   int		Just, Rotate, XOff, YOff, W, H;
   /* XOff and YOff are screen offsets (scaled and translated) */
{
   XPoint	v[5];

   v[0].x = (short)XOff; v[0].y = (short)YOff;
   v[1].x = (short)XOff; v[1].y = (short)YOff+H+1;
   v[2].x = (short)XOff+W+1; v[2].y = (short)YOff+H+1;
   v[3].x = (short)XOff+W+1; v[3].y = (short)YOff;
   v[4].x = (short)XOff; v[4].y = (short)YOff;

   XFillPolygon (mainDisplay, Win, gc, v, 5, Convex, CoordModeOrigin);
}

static
void AddStr (PrevPtr, NextPtr, StrPtr)
   struct StrRec	* PrevPtr, * NextPtr, * StrPtr;
{
   StrPtr->prev = PrevPtr;
   StrPtr->next = NextPtr;

   if (PrevPtr == NULL)
      firstStr = StrPtr;
   else
      PrevPtr->next = StrPtr;

   if (NextPtr == NULL)
      lastStr = StrPtr;
   else
      NextPtr->prev = StrPtr;
}

static Pixmap	textBackingPixmap;
static int	textBackingPixmapSize = INVALID;
static GC	rotateGC = NULL;

void CleanUpText ()
{
   if (textBackingPixmapSize != INVALID)
   {
      XFreePixmap (mainDisplay, textBackingPixmap);
      textBackingPixmapSize = INVALID;
   }
   if (rotateGC != NULL) XFreeGC (mainDisplay, rotateGC);
}

static
void PaintText (Win, gc, Str, Just, Rotate, XOff, YOff, xfs, ColorIndex, Pen,
      Mode, FirstIndex, SecondIndex)
   register int	XOff, YOff;
   Window	Win;
   GC		gc;
   char		* Str;
   int		Just, Rotate, ColorIndex, Pen, Mode, FirstIndex, SecondIndex;
   XFontStruct	* xfs;
   /* XOff and YOff are UNSCALED screen offset */
{
   register int		i, j;
   register XImage	* from_image;
   int			w, h, left, right, len;
   XGCValues		values;

#ifndef UC
   XOff >>= zoomScale;
   YOff >>= zoomScale;
#else /* UC */
   XOff = ScreenSize(XOff, zoomScale);
   YOff = ScreenSize(YOff, zoomScale);
#endif /* UC */

   len = strlen (Str);

#ifndef UC
   w = XTextWidth (xfs, Str, len) >> zoomScale;
   h = canvasFontHeight >> zoomScale;
#else /* UC */
   w = ScreenSize(XTextWidth (xfs, Str, len) ,  zoomScale);
   h = ScreenSize(canvasFontHeight ,  zoomScale);
#endif /* UC */

   switch (Just)
   {
      case JUST_L: break;
      case JUST_C:
         switch (Rotate)
         {
            case ROTATE0: XOff -= w/2; break;
            case ROTATE90: YOff -= w/2; break;
            case ROTATE180: XOff += w/2; break;
            case ROTATE270: YOff += w/2; break;
         }
         break;
      case JUST_R:
         switch (Rotate)
         {
            case ROTATE0: XOff -= w; break;
            case ROTATE90: YOff -= w; break;
            case ROTATE180: XOff += w; break;
            case ROTATE270: YOff += w; break;
         }
         break;
   }

   if (Mode & PAINT)
   {
      if (Pen == NONEPAT) return;

#ifndef UC
      if (zoomScale != 0)
#else /* UC */
      if (zoomScale > 0)
#endif /* UC */
      {
         values.foreground = colorPixels[ColorIndex];
         values.function = GXcopy;
         values.fill_style = FillOpaqueStippled;
         values.stipple = patPixmap[BLUR];
         XChangeGC (mainDisplay, gc,
               GCForeground | GCFunction | GCFillStyle | GCStipple, &values);

         switch (Rotate)
         {
            case ROTATE0:
               BlurText (Win, gc, Just, Rotate, XOff, YOff, w, h); break;
            case ROTATE90:
               BlurText (Win, gc, Just, Rotate, XOff-h, YOff, h, w); break;
            case ROTATE180:
               BlurText (Win, gc, Just, Rotate, XOff-w, YOff-h, w, h); break;
            case ROTATE270:
               BlurText (Win, gc, Just, Rotate, XOff, YOff-w, h, w); break;
         }
      }
      else if (Rotate == ROTATE0)
      {
         values.foreground = colorPixels[ColorIndex];
         values.function = GXcopy;
         values.fill_style = FillOpaqueStippled;
         values.stipple = patPixmap[Pen];
         XChangeGC (mainDisplay, gc,
               GCForeground | GCFunction | GCFillStyle | GCStipple, &values);
         XDrawString (mainDisplay, Win, gc, XOff, YOff+canvasFontAsc, Str, len);

         switch (Mode)
         {
            case PAINT_NORM: break;
            case PAINT_INV:
               XSetForeground (mainDisplay, revDefaultGC,
                     xorColorPixels[ColorIndex]);
               XFillRectangle (mainDisplay, Win, revDefaultGC, XOff, YOff,
                     w, h);
               XSetForeground (mainDisplay, revDefaultGC, 1);
               break;
            case PAINT_NORM_INV:
               left = XTextWidth (xfs, Str, FirstIndex);
               XSetForeground (mainDisplay, revDefaultGC,
                     xorColorPixels[ColorIndex]);
               XFillRectangle (mainDisplay, Win, revDefaultGC, XOff+left, YOff,
                     w-left, h);
               XSetForeground (mainDisplay, revDefaultGC, 1);
               break;
            case PAINT_INV_NORM:
               left = XTextWidth (xfs, Str, FirstIndex);
               XSetForeground (mainDisplay, revDefaultGC,
                     xorColorPixels[ColorIndex]);
               XFillRectangle (mainDisplay, Win, revDefaultGC, XOff, YOff,
                     left, h);
               XSetForeground (mainDisplay, revDefaultGC, 1);
               break;
            case PAINT_NORM_INV_NORM:
               left = XTextWidth (xfs, Str, FirstIndex);
               right = XTextWidth (xfs, Str, SecondIndex);
               XSetForeground (mainDisplay, revDefaultGC,
                     xorColorPixels[ColorIndex]);
               XFillRectangle (mainDisplay, Win, revDefaultGC, XOff+left, YOff,
                     right-left, h);
               XSetForeground (mainDisplay, revDefaultGC, 1);
               break;
         }
      }
      else if (w != 0)
      {
         if (w > textBackingPixmapSize || h > textBackingPixmapSize)
         {
            if (textBackingPixmapSize != INVALID)
               XFreePixmap (mainDisplay, textBackingPixmap);

            textBackingPixmap = XCreatePixmap (mainDisplay, mainWindow,
                  max(w,h), max(w,h), mainDepth);
            textBackingPixmapSize = max(w,h);
         }
         if (rotateGC == NULL)
         {
            values.foreground = 1;
            values.background = 0;
            values.fill_style = FillSolid;
            values.function = GXcopy;
            rotateGC = XCreateGC (mainDisplay, drawWindow,
                  GCForeground | GCBackground | GCFillStyle | GCFunction,
                  &values);
         }

         XSetForeground (mainDisplay, rotateGC, 0);
         XFillRectangle (mainDisplay, textBackingPixmap, rotateGC, 0, 0, w, h);
         XSetForeground (mainDisplay, rotateGC, 1);

         XSetFont (mainDisplay, rotateGC, canvasFontPtr->fid);
         XDrawString (mainDisplay, textBackingPixmap, rotateGC, 0,
               canvasFontAsc, Str, len);
         from_image = XGetImage (mainDisplay, textBackingPixmap, 0, 0, w, h, 1,
               ZPixmap);

         values.foreground = colorPixels[ColorIndex];
         values.function = GXcopy;
         values.fill_style = FillOpaqueStippled;
         values.stipple = patPixmap[Pen];
         values.line_width = 0;
         XChangeGC (mainDisplay, gc, GCForeground | GCFunction | GCFillStyle |
               GCStipple | GCLineWidth, &values);

         switch (Rotate)
         {
            case ROTATE90:
               for (i = 0; i < w; i++)
                  for (j = 0; j < h; j++)
                     if (XGetPixel (from_image, i, j) == 1)
#ifdef sun
                        XDrawPoint (mainDisplay, Win, gc, XOff-j, YOff+i);
#else /* UC */
#ifdef ultrix
                        XDrawPoint (mainDisplay, Win, gc, XOff-j, YOff+i);
#else /* UC */
                        XDrawLine (mainDisplay, Win, gc, XOff-j, YOff+i,
                              XOff-j, YOff+i);
#endif
#endif
               break;
            case ROTATE180:
               for (i = 0; i < w; i++)
                  for (j = 0; j < h; j++)
                     if (XGetPixel (from_image, i, j) == 1)
#ifdef sun
                        XDrawPoint (mainDisplay, Win, gc, XOff-i, YOff-j);
#else /* UC */
#ifdef ultrix
                        XDrawPoint (mainDisplay, Win, gc, XOff-i, YOff-j);
#else /* UC */
                        XDrawLine (mainDisplay, Win, gc, XOff-i, YOff-j,
                              XOff-i, YOff-j);
#endif
#endif
               break;
            case ROTATE270:
               for (i = 0; i < w; i++)
                  for (j = 0; j < h; j++)
                     if (XGetPixel (from_image, i, j) == 1)
#ifdef sun
                        XDrawPoint (mainDisplay, Win, gc, XOff+j, YOff-i);
#else /* UC */
#ifdef ultrix
                        XDrawPoint (mainDisplay, Win, gc, XOff+j, YOff-i);
#else /* UC */
                        XDrawLine (mainDisplay, Win, gc, XOff+j, YOff-i,
                              XOff+j, YOff-i);
#endif
#endif
               break;
         }

         XDestroyImage (from_image);
      }
   }
   else
   {
      values.foreground = myBgPixel;
      values.function = GXcopy;
      values.fill_style = FillSolid;
      XChangeGC (mainDisplay, gc,
            GCForeground | GCFunction | GCFillStyle, &values);

      XFillRectangle (mainDisplay, Win, gc, XOff-1, YOff, w+1, h);
   }
}

static
void PaintCurText (Win, gc, Str, Just, XOff, YOff, xfs, ColorIndex, Pen,
      Mode, FirstIndex, SecondIndex)
   register int	XOff, YOff;
   Window	Win;
   GC		gc;
   char		* Str;
   int		Just, ColorIndex, Pen, Mode, FirstIndex, SecondIndex;
   XFontStruct	* xfs;
   /* XOff and YOff are UNSCALED screen offset */
{
   int		w, h, left, right, len;
   XGCValues	values;

   len = strlen (Str);

   w = XTextWidth (xfs, Str, len);
   h = canvasFontHeight;

   switch (Just)
   {
      case JUST_L: break;
      case JUST_C: XOff -= w/2; break;
      case JUST_R: XOff -= w; break;
   }

   if (Mode & PAINT)
   {
      if (Pen == NONEPAT) return;

      values.foreground = colorPixels[ColorIndex];
      values.function = GXcopy;
      values.fill_style = FillOpaqueStippled;
      values.stipple = patPixmap[Pen];
      XChangeGC (mainDisplay, gc,
            GCForeground | GCFunction | GCFillStyle | GCStipple, &values);
      XDrawString (mainDisplay, Win, gc, XOff, YOff+canvasFontAsc, Str, len);

      switch (Mode)
      {
         case PAINT_NORM: break;
         case PAINT_INV:
            XSetForeground (mainDisplay, revDefaultGC,
                  xorColorPixels[ColorIndex]);
            XFillRectangle (mainDisplay, Win, revDefaultGC, XOff, YOff,
                  w, h);
            XSetForeground (mainDisplay, revDefaultGC, 1);
            break;
         case PAINT_NORM_INV:
            left = XTextWidth (xfs, Str, FirstIndex);
            XSetForeground (mainDisplay, revDefaultGC,
                  xorColorPixels[ColorIndex]);
            XFillRectangle (mainDisplay, Win, revDefaultGC, XOff+left, YOff,
                  w-left, h);
            XSetForeground (mainDisplay, revDefaultGC, 1);
            break;
         case PAINT_INV_NORM:
            left = XTextWidth (xfs, Str, FirstIndex);
            XSetForeground (mainDisplay, revDefaultGC,
                  xorColorPixels[ColorIndex]);
            XFillRectangle (mainDisplay, Win, revDefaultGC, XOff, YOff,
                  left, h);
            XSetForeground (mainDisplay, revDefaultGC, 1);
            break;
         case PAINT_NORM_INV_NORM:
            left = XTextWidth (xfs, Str, FirstIndex);
            right = XTextWidth (xfs, Str, SecondIndex);
            XSetForeground (mainDisplay, revDefaultGC,
                  xorColorPixels[ColorIndex]);
            XFillRectangle (mainDisplay, Win, revDefaultGC, XOff+left, YOff,
                  right-left, h);
            XSetForeground (mainDisplay, revDefaultGC, 1);
            break;
      }
   }
   else
   {
      values.foreground = myBgPixel;
      values.function = GXcopy;
      values.fill_style = FillSolid;
      XChangeGC (mainDisplay, gc,
            GCForeground | GCFunction | GCFillStyle, &values);

      XFillRectangle (mainDisplay, Win, gc, XOff-1, YOff, w+1, h);
   }
}

void PutTextCursor ()
{
   XDrawLine (mainDisplay, drawWindow, defaultGC, textCurX,
         textCurY, textCurX, textCurY+textCursorH);
}

void EraseTextCursor ()
{
   XSetForeground (mainDisplay, revDefaultGC, myFgPixel^myBgPixel);
   XDrawLine (mainDisplay, drawWindow, revDefaultGC, textCurX,
         textCurY, textCurX, textCurY+textCursorH);
   XSetForeground (mainDisplay, revDefaultGC, 1);
}

void NewCurText ()
{
   struct TextRec	* text_ptr;

   firstStr = lastStr = curStr =
         (struct StrRec *) calloc (1, sizeof(struct StrRec));

   text_ptr = (struct TextRec *) calloc (1, sizeof(struct TextRec));
   text_ptr->font = curFont;
   text_ptr->dpi = curFontDPI;
   text_ptr->style = curStyle;
   text_ptr->attr = NULL;
   text_ptr->size = curSize;
   text_ptr->just = textJust;
   text_ptr->rotate = curRotate;
   text_ptr->pen = penPat;
   text_ptr->asc = canvasFontAsc;
   text_ptr->des = canvasFontDes;
   text_ptr->lines = 1;
   text_ptr->first = firstStr;
   text_ptr->last = lastStr;

   curTextObj = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   curTextObj->x = textAbsX;
   curTextObj->y = textAbsY;
   curTextObj->type = OBJ_TEXT;
   curTextObj->color = colorIndex;
   curTextObj->id = objId++;
   curTextObj->dirty = FALSE;
   curTextObj->detail.t = text_ptr;
   curTextObj->fattr = curTextObj->lattr = NULL;
   AddObj (NULL, topObj, curTextObj);

   textW = 0;
   textH = textCursorH;

   textCursorShown = TRUE;
   textHighlight = FALSE;
}

void SetTextBBox (ObjPtr, Just, W, H, Rotate)
   struct ObjRec	* ObjPtr;
   int			Just, W, H, Rotate;
{
   register int	mw2, pw2;

   switch (Just)
   {
      case JUST_L:
         switch (Rotate)
         {
            case ROTATE0:
               ObjPtr->obbox.ltx = ObjPtr->x; ObjPtr->obbox.rbx = ObjPtr->x+W;
               ObjPtr->obbox.lty = ObjPtr->y; ObjPtr->obbox.rby = ObjPtr->y+H;
               break;
            case ROTATE90:
               ObjPtr->obbox.ltx = ObjPtr->x-H; ObjPtr->obbox.rbx = ObjPtr->x;
               ObjPtr->obbox.lty = ObjPtr->y; ObjPtr->obbox.rby = ObjPtr->y+W;
               break;
            case ROTATE180:
               ObjPtr->obbox.ltx = ObjPtr->x-W; ObjPtr->obbox.rbx = ObjPtr->x;
               ObjPtr->obbox.lty = ObjPtr->y-H; ObjPtr->obbox.rby = ObjPtr->y;
               break;
            case ROTATE270:
               ObjPtr->obbox.ltx = ObjPtr->x; ObjPtr->obbox.rbx = ObjPtr->x+H;
               ObjPtr->obbox.lty = ObjPtr->y-W; ObjPtr->obbox.rby = ObjPtr->y;
               break;
         }
         break;
      case JUST_C:
         mw2 = W/2;
         pw2 = W-W/2;
         switch (Rotate)
         {
            case ROTATE0:
               ObjPtr->obbox.ltx = ObjPtr->x-mw2;
               ObjPtr->obbox.rbx = ObjPtr->x+pw2;
               ObjPtr->obbox.lty = ObjPtr->y; ObjPtr->obbox.rby = ObjPtr->y+H;
               break;
            case ROTATE90:
               ObjPtr->obbox.ltx = ObjPtr->x-H;
               ObjPtr->obbox.rbx = ObjPtr->x;
               ObjPtr->obbox.lty = ObjPtr->y-mw2;
               ObjPtr->obbox.rby = ObjPtr->y+pw2;
               break;
            case ROTATE180:
               ObjPtr->obbox.ltx = ObjPtr->x-pw2;
               ObjPtr->obbox.rbx = ObjPtr->x+mw2;
               ObjPtr->obbox.lty = ObjPtr->y-H;
               ObjPtr->obbox.rby = ObjPtr->y;
               break;
            case ROTATE270:
               ObjPtr->obbox.ltx = ObjPtr->x;
               ObjPtr->obbox.rbx = ObjPtr->x+H;
               ObjPtr->obbox.lty = ObjPtr->y-pw2;
               ObjPtr->obbox.rby = ObjPtr->y+mw2;
               break;
         }
         break;
      case JUST_R:
         switch (Rotate)
         {
            case ROTATE0:
               ObjPtr->obbox.ltx = ObjPtr->x-W; ObjPtr->obbox.rbx = ObjPtr->x;
               ObjPtr->obbox.lty = ObjPtr->y; ObjPtr->obbox.rby = ObjPtr->y+H;
               break;
            case ROTATE90:
               ObjPtr->obbox.ltx = ObjPtr->x-H; ObjPtr->obbox.rbx = ObjPtr->x;
               ObjPtr->obbox.lty = ObjPtr->y-W; ObjPtr->obbox.rby = ObjPtr->y;
               break;
            case ROTATE180:
               ObjPtr->obbox.ltx = ObjPtr->x; ObjPtr->obbox.rbx = ObjPtr->x+W;
               ObjPtr->obbox.lty = ObjPtr->y-H; ObjPtr->obbox.rby = ObjPtr->y;
               break;
            case ROTATE270:
               ObjPtr->obbox.ltx = ObjPtr->x; ObjPtr->obbox.rbx = ObjPtr->x+H;
               ObjPtr->obbox.lty = ObjPtr->y; ObjPtr->obbox.rby = ObjPtr->y+W;
               break;
         }
         break;
   }
   ObjPtr->bbox.ltx = ObjPtr->obbox.ltx - 2;
   ObjPtr->bbox.rbx = ObjPtr->obbox.rbx + 2;
   ObjPtr->bbox.lty = ObjPtr->obbox.lty - 2;
   ObjPtr->bbox.rby = ObjPtr->obbox.rby + 2;
}

void UpdTextBBox (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register int		num_lines;
   struct StrRec	* s_ptr = ObjPtr->detail.t->first;
   int			max_len = 0, w;

   SaveCurFont ();
   curFont = ObjPtr->detail.t->font;
   curFontDPI = ObjPtr->detail.t->dpi;
   curStyle = ObjPtr->detail.t->style;
   curSize = ObjPtr->detail.t->size;
   textJust = ObjPtr->detail.t->just;
   SetCanvasFont ();

   for (num_lines = 0; s_ptr != NULL; s_ptr = s_ptr->next, num_lines++)
   {
#ifndef KANJI
      w = XTextWidth (canvasFontPtr, s_ptr->s, strlen (s_ptr->s));
#else /* KANJI */
      w = XTextFakeWidth (canvasFontPtr, s_ptr->s, strlen (s_ptr->s));
#endif /* KANJI */      
      if (w > max_len) max_len = w;
   }

   ObjPtr->detail.t->asc = canvasFontAsc;
   ObjPtr->detail.t->des = canvasFontDes;

   SetTextBBox (ObjPtr, textJust, max_len, num_lines*textCursorH,
         ObjPtr->detail.t->rotate);

   RestoreCurFont ();
}

void FreeTextObj (ObjPtr)
   struct ObjRec	* ObjPtr;
{
   register struct StrRec	* s_ptr;

   for (s_ptr = ObjPtr->detail.t->first; s_ptr != NULL; s_ptr = s_ptr->next)
      cfree (s_ptr);

   cfree (ObjPtr->detail.t);
   cfree (ObjPtr);
}

int CreateTextObj ()
   /* returns TRUE if something got created */
   /* returns FALSE otherwise */
{
   register int		i;
   struct StrRec	* s_ptr;
   struct AttrRec	* attr_ptr;
   int			max_len = 0, w = 0, ltx = 0, lty = 0, rbx = 0, rby = 0;
   int			scr_ltx = 0, scr_lty = 0;

   if (!textCursorShown) return (FALSE);
   EraseTextCursor ();

   if (firstStr == lastStr && curStr->s[0] == '\0')
   {  /* no text entered or all text erased */
      if ((attr_ptr = curTextObj->detail.t->attr) != NULL)
      {  /* the text being edited is an attribute */
         if (attr_ptr->nameshown)
         {
            UnlinkAttr (attr_ptr);
            FreeTextObj (curTextObj);
            FreeAttr (attr_ptr);
         }
         else
            UpdateAttr(curTextObj->detail.t, attr_ptr);

         AdjObjBBox (attr_ptr->owner);
      }
      else
         DelObj (curTextObj);

      switch (textJust)
      {
         case JUST_L: scr_ltx = OFFSET_X(textAbsX)-2; break;
         case JUST_C: scr_ltx = OFFSET_X(textAbsX)-textW/2-2; break;
         case JUST_R: scr_ltx = OFFSET_X(textAbsX)-textW-2; break;
      }
      scr_lty = OFFSET_Y(textAbsY)-2;

#ifndef UC
      ltx = (scr_ltx<<zoomScale)+drawOrigX;
      lty = (scr_lty<<zoomScale)+drawOrigY;
      rbx = ltx+((textW+5)<<zoomScale);
      rby = lty+((textH+5)<<zoomScale);
#else /* UC */
      ltx = (RealSize(scr_ltx, zoomScale))+drawOrigX;
      lty = (RealSize(scr_lty, zoomScale))+drawOrigY;
      rbx = ltx+(RealSize((textW+5), zoomScale));
      rby = lty+(RealSize((textH+5), zoomScale));
#endif /* UC */

      if (editingText)
      {
         XClearArea (mainDisplay, drawWindow, scr_ltx, scr_lty,
               textW+5, textH+5, FALSE);
#ifndef UC
         RedrawAreas (botObj, savedTextLtX-(1<<zoomScale),
               savedTextLtY-(1<<zoomScale), savedTextRbX+(1<<zoomScale),
               savedTextRbY+(1<<zoomScale), ltx, lty, rbx, rby);
#else /* UC */
         RedrawAreas (botObj, savedTextLtX-(RealSize(1, zoomScale)),
               savedTextLtY-(RealSize(1, zoomScale)), savedTextRbX+(RealSize(1, zoomScale)),
               savedTextRbY+(RealSize(1, zoomScale)), ltx, lty, rbx, rby);
#endif /* UC */
      }
      else
         RedrawAnArea (botObj, ltx, lty, rbx, rby);

      firstStr = lastStr = curStr = NULL;
      textCursorShown = FALSE;
      curTextObj = NULL;
      if (editingText)
      {
         PopCurFont ();
         ShowJust ();
         ShowColor (FALSE);
         ShowCurFont ();
         editingText = FALSE;
      }
      textDrawn = FALSE;
      justDrawnTextObj = NULL;
      textHighlight = FALSE;
      return (FALSE);
   }

   for (s_ptr = firstStr, i = 0; s_ptr != NULL; s_ptr = s_ptr->next, i++)
   {
#ifndef KANJI
      w = XTextWidth (canvasFontPtr, s_ptr->s, strlen (s_ptr->s));
#else /* KANJI */
      w = XTextFakeWidth (canvasFontPtr, s_ptr->s, strlen (s_ptr->s));
#endif /* KANJI */
      if (w > max_len) max_len = w;
   }

   curTextObj->detail.t->last = lastStr;
   curTextObj->detail.t->lines = i;

   curTextObj->x = textAbsX-tmpAdjX;
   curTextObj->y = textAbsY-tmpAdjY;

   SetTextBBox (curTextObj, textJust, max_len, i*textCursorH, curRotate);

   switch (textJust)
   {
      case JUST_L: scr_ltx = OFFSET_X(textAbsX)-2; break;
      case JUST_C: scr_ltx = OFFSET_X(textAbsX)-textW/2-2; break;
      case JUST_R: scr_ltx = OFFSET_X(textAbsX)-textW-2; break;
   }
   scr_lty = OFFSET_Y(textAbsY)-2;

#ifndef UC
   ltx = (scr_ltx<<zoomScale)+drawOrigX;
   lty = (scr_lty<<zoomScale)+drawOrigY;
   rbx = ltx+((textW+5)<<zoomScale);
   rby = lty+((textH+5)<<zoomScale);
#else /* UC */
   ltx = (RealSize(scr_ltx, zoomScale))+drawOrigX;
   lty = (RealSize(scr_lty, zoomScale))+drawOrigY;
   rbx = ltx+(RealSize((textW+5), zoomScale));
   rby = lty+(RealSize((textH+5), zoomScale));
#endif /* UC */

   if ((attr_ptr = curTextObj->detail.t->attr) != NULL)
   {
      UpdateAttr(curTextObj->detail.t, attr_ptr);
      textDrawn = FALSE;
      justDrawnTextObj = NULL;
      AdjObjBBox (attr_ptr->owner);
   }
   else
   {
      textDrawn = TRUE;
      justDrawnTextObj = curTextObj;
   }

   firstStr = lastStr = curStr = NULL;
   textCursorShown = FALSE;
   textCurIndex = 0;

   if (editingText)
   {
      XClearArea (mainDisplay, drawWindow, scr_ltx, scr_lty,
            textW+5, textH+5, FALSE);
#ifndef UC
      RedrawAreas (botObj, savedTextLtX-(1<<zoomScale),
            savedTextLtY-(1<<zoomScale), savedTextRbX+(1<<zoomScale),
            savedTextRbY+(1<<zoomScale), ltx, lty, rbx, rby);
#else /* UC */
      RedrawAreas (botObj, savedTextLtX-(RealSize(1, zoomScale)),
            savedTextLtY-(RealSize(1, zoomScale)), savedTextRbX+(RealSize(1, zoomScale)),
            savedTextRbY+(RealSize(1, zoomScale)), ltx, lty, rbx, rby);
#endif /* UC */
      if (curRotate != ROTATE0)
         DrawTextObj (drawWindow, drawOrigX, drawOrigY, curTextObj);
   }
   else
   {
      RedrawAnArea (botObj, ltx, lty, rbx, rby);
      if (curRotate != ROTATE0)
         DrawTextObj (drawWindow, drawOrigX, drawOrigY, curTextObj);
   }

#ifndef UC
   textOrigX = textOrigY = textCurX = textCurY = 20<<zoomScale;
#else /* UC */
   textOrigX = textOrigY = textCurX = textCurY = RealSize(20, zoomScale);
#endif /* UC */
   curStrW = 0;
   textW = textH = 0;
   textCurIndex = 0;
   textAbsX = textOrigX + drawOrigX;
   textAbsY = textOrigY + drawOrigY;
   curTextObj = NULL;

   if (editingText)
   {
      PopCurFont ();
      ShowJust ();
      ShowColor (FALSE);
      ShowCurFont ();
      editingText = FALSE;
   }
   textHighlight = FALSE;
   return (TRUE);
}

void HighLightJustDrawnText ()
{
   AddNewSelObj (justDrawnTextObj);
   UpdSelBBox ();
   HighLightAnObj (justDrawnTextObj);
   justDupped = FALSE;
}

static
struct ObjRec * FindTextObj (X, Y)
   int  X, Y;
   /* X and Y are absolute coordinates */
{
   register struct ObjRec       * obj_ptr;
   register struct AttrRec      * attr_ptr;

   for (obj_ptr = topObj; obj_ptr != NULL; obj_ptr = obj_ptr->next)
      if (obj_ptr->type == OBJ_TEXT &&
            X >= obj_ptr->bbox.ltx && X <= obj_ptr->bbox.rbx &&
            Y >= obj_ptr->bbox.lty && Y <= obj_ptr->bbox.rby)
         return (obj_ptr);
      else
      {
         attr_ptr = obj_ptr->fattr;
         for (; attr_ptr != NULL;  attr_ptr = attr_ptr->next)
            if (X>=attr_ptr->obj->bbox.ltx && X<=attr_ptr->obj->bbox.rbx &&
                  Y>=attr_ptr->obj->bbox.lty && Y<=attr_ptr->obj->bbox.rby &&
                  attr_ptr->shown == TRUE)
               return (attr_ptr->obj);
      }
   return (NULL);
}

static
void SetTextCurX ()
   /* set textCurX according to textCurIndex */
{
   register int	left = 0, w;
   char		s[MAXSTRING+1];

   strcpy (s, curStr->s);
   s[textCurIndex] = '\0';

   w = XTextWidth (canvasFontPtr, s, strlen (s));

   switch (textJust)
   {
      case JUST_L: left = textOrigX; break;
      case JUST_C: left = textOrigX-curStrW/2; break;
      case JUST_R: left = textOrigX-curStrW; break;
   }
   textCurX = left + w;
}

static
void HandleButton (Button_Ev)
   XButtonEvent	* Button_Ev;
{
   int			grid_x, grid_y, x_off, y_off, amount, dx, dy;
   int                  left, pressed_in_same_text = FALSE, x = 0;
   int                  abs_x, abs_y, tmp_x, tmp_y;
   struct ObjRec	* obj_ptr = NULL;
   struct AttrRec       * attr_ptr;
#ifndef KANJI
   char			* c_ptr, s[2];
#else /* KANJI */
   char			* c_ptr, s[3];
   int			len;
#endif /* KANJI */

   if (Button_Ev->button == Button1)
   {
#ifndef UC
      x_off = Button_Ev->x; abs_x = (x_off<<zoomScale) + drawOrigX;
      y_off = Button_Ev->y; abs_y = (y_off<<zoomScale) + drawOrigY;
#else /* UC */
      x_off = Button_Ev->x; abs_x = (RealSize(x_off, zoomScale)) + drawOrigX;
      y_off = Button_Ev->y; abs_y = (RealSize(y_off, zoomScale)) + drawOrigY;
#endif /* UC */

      if (textCursorShown)
      {
         switch (textJust)
         {
            case JUST_L: x = textOrigX-2; break;
            case JUST_C: x = textOrigX-textW/2-2; break;
            case JUST_R: x = textOrigX-textW-2; break;
         }
         if (x_off >= x && x_off <= x+textW+4 &&
               y_off >= textOrigY-2 && y_off <= textOrigY+textH+2)
            pressed_in_same_text = TRUE;
         else
            CreateTextObj (); /* end editing on the old text */
      }
      else
         editingText = FALSE;

      if (!pressed_in_same_text &&
            (obj_ptr = FindTextObj (abs_x, abs_y)) == NULL)
      {  /* cursor not within any existing text object */
         GridXY (x_off, y_off, &grid_x, &grid_y);

         textOrigX = textCurX = grid_x;
         textOrigY = textCurY = grid_y;
#ifndef UC
         textAbsX = (grid_x<<zoomScale) + drawOrigX;
         textAbsY = (grid_y<<zoomScale) + drawOrigY;
#else /* UC */
         textAbsX = (RealSize(grid_x, zoomScale)) + drawOrigX;
         textAbsY = (RealSize(grid_y, zoomScale)) + drawOrigY;
#endif /* UC */
         tmpAdjX = tmpAdjY = 0;
         NewCurText ();
         RedrawCurText ();
#ifdef KINPUT
	 if ((curFont == FONT_MIN || curFont == FONT_GOT) &&
	     !kinputOn && autoKinput)
	     BeginKanjiConversion (mainDisplay, drawWindow, Button_Ev);
#endif /* KINPUT */
      }
      else
      {  /* cursor inside an existing text object */
         if (pressed_in_same_text)
         {
            obj_ptr = curTextObj;
            curStr = obj_ptr->detail.t->first;
         }
         else
         {
            curTextObj = obj_ptr;
            savedTextLtX = obj_ptr->bbox.ltx;
            savedTextLtY = obj_ptr->bbox.lty;
            savedTextRbX = obj_ptr->bbox.rbx;
            savedTextRbY = obj_ptr->bbox.rby;

            PushCurFont ();
            editingText = TRUE;

            curFont = obj_ptr->detail.t->font;
            curFontDPI = obj_ptr->detail.t->dpi;
            curStyle = obj_ptr->detail.t->style;
            curSize = obj_ptr->detail.t->size;
            textJust = obj_ptr->detail.t->just;
            curRotate = obj_ptr->detail.t->rotate;
            penPat = obj_ptr->detail.t->pen;
            SetCanvasFont ();
            ShowJust ();
            ShowPen ();
            colorIndex = obj_ptr->color;
            ShowColor (FALSE);
            ShowCurFont ();

            firstStr = curStr = obj_ptr->detail.t->first;
            lastStr = obj_ptr->detail.t->last;

            textAbsX = obj_ptr->x;
            textAbsY = obj_ptr->y;
            textOrigX = OFFSET_X(obj_ptr->x);
            textOrigY = OFFSET_Y(obj_ptr->y);

            switch (curRotate)
            {
               case ROTATE0:
                  textW = obj_ptr->obbox.rbx - obj_ptr->obbox.ltx;
                  textH = obj_ptr->obbox.rby - obj_ptr->obbox.lty;
                  switch (textJust)
                  {
#ifndef UC
                     case JUST_L: tmpAdjX = (textW-(textW<<zoomScale))/2; break;
                     case JUST_C: tmpAdjX = 0; break;
                     case JUST_R: tmpAdjX = ((textW<<zoomScale)-textW)/2; break;
                  }
                  tmpAdjY = (textH-(textH<<zoomScale))/2;
#else /* UC */
                     case JUST_L: tmpAdjX = (textW-(RealSize(textW, zoomScale)))/2; break;
                     case JUST_C: tmpAdjX = 0; break;
                     case JUST_R: tmpAdjX = ((RealSize(textW, zoomScale))-textW)/2; break;
                  }
                  tmpAdjY = (textH-(RealSize(textH, zoomScale)))/2;
#endif /* UC */
                  break;
               case ROTATE90:
                  dx = textAbsX - abs_x;
                  dy = textAbsY - abs_y;
                  abs_x = textAbsX - dy;
                  abs_y = textAbsY + dx;
                  textW = obj_ptr->obbox.rby - obj_ptr->obbox.lty;
                  textH = obj_ptr->obbox.rbx - obj_ptr->obbox.ltx;
                  switch (textJust)
                  {
                     case JUST_L:
#ifndef UC
                        tmpAdjX = -((textW<<zoomScale)+textH)/2;
                        tmpAdjY = (textW-(textH<<zoomScale))/2;
#else /* UC */
                        tmpAdjX = -((RealSize(textW, zoomScale))+textH)/2;
                        tmpAdjY = (textW-(RealSize(textH, zoomScale)))/2;
#endif /* UC */
                        break;
                     case JUST_C:
                        tmpAdjX = -textH/2;
#ifndef UC
                        tmpAdjY = -(textH<<zoomScale)/2;
#else /* UC */
                        tmpAdjY = -(RealSize(textH, zoomScale))/2;
#endif /* UC */
                        break;
                     case JUST_R:
#ifndef UC
                        tmpAdjX = ((textW<<zoomScale)-textH)/2;
                        tmpAdjY = -(textW+(textH<<zoomScale))/2;
#else /* UC */
                        tmpAdjX = ((RealSize(textW, zoomScale))-textH)/2;
                        tmpAdjY = -(textW+(RealSize(textH, zoomScale)))/2;
#endif /* UC */
                        break;
                  }
                  break;
               case ROTATE180:
                  abs_x = 2*textAbsX - abs_x;
                  abs_y = 2*textAbsY - abs_y;
                  textW = obj_ptr->obbox.rbx - obj_ptr->obbox.ltx;
                  textH = obj_ptr->obbox.rby - obj_ptr->obbox.lty;
                  switch (textJust)
                  {
#ifndef UC
                     case JUST_L: tmpAdjX = -(textW+(textW<<zoomScale))/2; break;
                     case JUST_C: tmpAdjX = 0; break;
                     case JUST_R: tmpAdjX = (textW+(textW<<zoomScale))/2; break;
#else /* UC */
                     case JUST_L: tmpAdjX = -(textW+(RealSize(textW, zoomScale)))/2; break;
                     case JUST_C: tmpAdjX = 0; break;
                     case JUST_R: tmpAdjX = (textW+(RealSize(textW, zoomScale)))/2; break;
#endif /* UC */
                  }
#ifndef UC
                  tmpAdjY = -(textH+(textH<<zoomScale))/2;
#else /* UC */
                  tmpAdjY = -(textH+(RealSize(textH, zoomScale)))/2;
#endif /* UC */
                  break;
               case ROTATE270:
                  dx = textAbsX - abs_x;
                  dy = textAbsY - abs_y;
                  abs_x = textAbsX + dy;
                  abs_y = textAbsY - dx;
                  textW = obj_ptr->obbox.rby - obj_ptr->obbox.lty;
                  textH = obj_ptr->obbox.rbx - obj_ptr->obbox.ltx;
                  switch (textJust)
                  {
                     case JUST_L:
#ifndef UC
                        tmpAdjX = -((textW<<zoomScale)-textH)/2;
                        tmpAdjY = -(textW+(textH<<zoomScale))/2;
#else /* UC */
                        tmpAdjX = -((RealSize(textW, zoomScale))-textH)/2;
                        tmpAdjY = -(textW+(RealSize(textH, zoomScale)))/2;
#endif /* UC */
                        break;
                     case JUST_C:
                        tmpAdjX = textH/2;
#ifndef UC
                        tmpAdjY = -(textH<<zoomScale)/2;
#else /* UC */
                        tmpAdjY = -(RealSize(textH, zoomScale))/2;
#endif /* UC */
                        break;
                     case JUST_R:
#ifndef UC
                        tmpAdjX = ((textW<<zoomScale)+textH)/2;
                        tmpAdjY = (textW-(textH<<zoomScale))/2;
#else /* UC */
                        tmpAdjX = ((RealSize(textW, zoomScale))+textH)/2;
                        tmpAdjY = (textW-(RealSize(textH, zoomScale)))/2;
#endif /* UC */
                        break;
                  }
                  break;
	    }
            textAbsX += tmpAdjX; textOrigX = OFFSET_X(textAbsX);
            textAbsY += tmpAdjY; textOrigY = OFFSET_Y(textAbsY);
            abs_x += tmpAdjX; x_off = OFFSET_X(abs_x);
            abs_y += tmpAdjY; y_off = OFFSET_Y(abs_y);
#ifdef KINPUT
	 if ((curFont == FONT_MIN || curFont == FONT_GOT) &&
	     !kinputOn && autoKinput)
	     BeginKanjiConversion (mainDisplay, drawWindow, Button_Ev);
#endif /* KINPUT */
         }

         textCurY = textOrigY;
         if (pressed_in_same_text)
         {
            while (y_off >= textCurY+textCursorH && curStr->next != NULL)
            {
               textCurY += textCursorH;
               curStr = curStr->next;
            }
         }
         else
         {
            tmp_y = textAbsY;
#ifndef UC
            while ((y_off<<zoomScale)+drawOrigY >= tmp_y+textCursorH &&
#else /* UC */
            while ((RealSize(y_off, zoomScale))+drawOrigY >= tmp_y+textCursorH &&
#endif /* UC */
                  curStr->next != NULL)
            {
               textCurY += textCursorH;
               tmp_y += textCursorH;
               curStr = curStr->next;
            }
         }

         curStrW = amount = XTextWidth (canvasFontPtr, curStr->s,
               strlen (curStr->s));

         textCurIndex = 0;
         textCurX = textOrigX;

         switch (textJust)
         {
            case JUST_L: break;
            case JUST_C: textCurX -= (amount/2); break;
            case JUST_R: textCurX -= amount; break;
         }
         left = textCurX;

#ifndef KANJI
         s[1] = '\0';
#endif /* KANJI */	 
         c_ptr = curStr->s;
         if (pressed_in_same_text)
         {
#ifndef KANJI
            for ( ; *c_ptr != '\0'; c_ptr++)
            {
               s[0] = *c_ptr;
               amount = XTextWidth (canvasFontPtr, s, 1);
#else /* KANJI */
	    for ( ; *c_ptr != '\0'; c_ptr++)
	    {
		s[0] = *c_ptr;
		if(0x80 & *c_ptr)
		{
		    c_ptr++; s[1] = *c_ptr;  s[2] = '\0';
		    len = 2;
		} else {
		    s[1] = '\0';
		    len = 1;
		}
		amount = XTextWidth (canvasFontPtr, s, len);
#endif /* KANJI */

               if (x_off < textCurX+amount/2)
                  break;
               else
                  textCurX += amount;
#ifndef KANJI
               textCurIndex++;
#else /* KANJI */
		textCurIndex += len;
#endif /* KANJI */
            }
         }
         else
         {
            tmp_x = textAbsX;
            switch (textJust)
            {
               case JUST_L: break;
               case JUST_C: tmp_x -= (amount/2); break;
               case JUST_R: tmp_x -= amount; break;
            }

#ifndef KANJI
            for ( ; *c_ptr != '\0'; c_ptr++)
            {
               s[0] = *c_ptr;
               amount = XTextWidth (canvasFontPtr, s, 1);
#else /* KANJI */
	    for ( ; *c_ptr != '\0'; c_ptr++)
	    {
		s[0] = *c_ptr;
		if(0x80 & *c_ptr)
		{
		    c_ptr++; s[1] = *c_ptr;  s[2] = '\0';
		    len = 2;
		} else {
		    s[1] = '\0';
		    len = 1;
		}
		amount = XTextWidth (canvasFontPtr, s, len);
#endif /* KANJI */

#ifndef UC
               if ((x_off<<zoomScale)+drawOrigX < tmp_x+amount/2)
#else /* UC */
               if ((RealSize(x_off, zoomScale))+drawOrigX < tmp_x+amount/2)
#endif /* UC */
                  break;
               else
               {
                  textCurX += amount;
                  tmp_x += amount;
               }
#ifndef KANJI
               textCurIndex++;
#else /* KANJI */
	       textCurIndex += len;
#endif /* KANJI */
            }
         }

         attr_ptr = obj_ptr->detail.t->attr;
         if (attr_ptr != NULL && attr_ptr->inherited && textCurY == textOrigY &&
               attr_ptr->shown && attr_ptr->nameshown &&
               textCurIndex < strlen (attr_ptr->name))
         {  /* clicked in the name of an inherited attribute */
            textCurIndex = strlen (attr_ptr->name);
            textCurX = left + XTextWidth (canvasFontPtr, attr_ptr->name,
                  textCurIndex);
         }
         textCursorShown = TRUE;
         textHighlight = FALSE;
         RedrawCurText ();
	}
	}
   else if (Button_Ev->button == Button2)
   {
#ifndef UC
      if (!textCursorShown) return;
#else /* UC */
      if (!textCursorShown)
      {
	 ModeMenu (Button_Ev->x_root, Button_Ev->y_root);
	 return ;
      }
#endif /* UC */

#ifndef UC
      x_off = Button_Ev->x; abs_x = (x_off<<zoomScale) + drawOrigX;
      y_off = Button_Ev->y; abs_y = (y_off<<zoomScale) + drawOrigY;
#else /* UC */
      x_off = Button_Ev->x; abs_x = (RealSize(x_off, zoomScale)) + drawOrigX;
      y_off = Button_Ev->y; abs_y = (RealSize(y_off, zoomScale)) + drawOrigY;
#endif /* UC */

      switch (textJust)
      {
         case JUST_L: x = textOrigX-2; break;
         case JUST_C: x = textOrigX-textW/2-2; break;
         case JUST_R: x = textOrigX-textW-2; break;
      }

      if (!(x_off >= x && x_off <= x+textW+2 &&
            y_off >= textOrigY-2 && y_off <= textOrigY+textH+2))
#ifndef UC
         return;
#else /* UC */
      {
	 ModeMenu (Button_Ev->x_root, Button_Ev->y_root);
	 return;
      }
#endif /* UC */

      obj_ptr = curTextObj;
      endStr = obj_ptr->detail.t->first;

      textEndY = textOrigY;
      while (y_off >= textEndY+textCursorH && endStr->next != NULL)
      {
         textEndY += textCursorH;
         endStr = endStr->next;
      }

      endStrW = amount = XTextWidth (canvasFontPtr, endStr->s,
            strlen (endStr->s));

      textEndX = textOrigX;
      switch (textJust)
      {
         case JUST_L: break;
         case JUST_C: textEndX -= (amount/2); break;
         case JUST_R: textEndX -= amount; break;
      }
      textEndIndex = 0;
      left = textEndX;

#ifndef KANJI
      s[1] = '\0';
      c_ptr = endStr->s;
      for ( ; *c_ptr != '\0'; c_ptr++)
      {
         s[0] = *c_ptr;
         amount = XTextWidth (canvasFontPtr, s, 1);
#else /* KANJI */
       c_ptr = endStr->s;
       for ( ; *c_ptr != '\0'; c_ptr++)
       {
	  s[0] = *c_ptr;
	  if(0x80 & *c_ptr)
	  {
	     c_ptr++; s[1] = *c_ptr; s[2] = '\0';
 	     len = 2;
          } else {
              s[1] = '\0';
	      len = 1;
	  }
          amount = XTextWidth (canvasFontPtr, s, len);
#endif /* KANJI */

         if (x_off < textEndX+amount/2)
            break;
         else
            textEndX += amount;
#ifndef KANJI
         textEndIndex++;
#else /* KANJI */
         textEndIndex += len;
#endif /* KANJI */
      }

      attr_ptr = obj_ptr->detail.t->attr;
      if (attr_ptr != NULL && attr_ptr->inherited && textEndY == textOrigY &&
            attr_ptr->shown && attr_ptr->nameshown &&
            textEndIndex < strlen (attr_ptr->name))
      {
         textEndIndex = strlen (attr_ptr->name);
         textEndX = left + XTextWidth (canvasFontPtr, attr_ptr->name,
               textEndIndex);
      }
      textHighlight = !(endStr == curStr && textEndIndex == textCurIndex);
      RedrawCurText ();
   }
}

static
int NumLines ()
{
   register struct StrRec	* str_ptr;
   register int			i = 0;

   for (str_ptr = firstStr; str_ptr != NULL; str_ptr = str_ptr->next, i++) ;
   return (i);
}

static
void DeleteHighlightedText ()
{
   struct StrRec	* s_ptr, * s_ptr1, * new_cur_str = NULL;
   int			highlighting = FALSE, new_cur_index = 0;
   int			second_index, len;
   int			i, y, new_cur_y = 0, len1, len2;
   char			* s, msg[80];

   if (!textHighlight) return;

   y = textOrigY;
   for (s_ptr = firstStr; s_ptr != NULL; y += textCursorH)
   {
      if (highlighting)
      {  /* started deleting already */
         if (s_ptr == curStr || s_ptr == endStr)
         {
            second_index = (s_ptr == curStr) ? textCurIndex : textEndIndex;
            len1 = strlen (new_cur_str->s);
            len2 = strlen (&(s_ptr->s[second_index]));
            if (len1+len2 >= MAXSTRING)
            {
               sprintf (msg, "String length exceeds %1d.  String truncated.",
                     MAXSTRING);
               Msg (msg);
               s_ptr->s[MAXSTRING-len1+second_index] = '\0';
            }
            strcat (new_cur_str->s, &(s_ptr->s[second_index]));
            if (s_ptr == lastStr)
               lastStr = s_ptr->prev;
            else
               s_ptr->next->prev = s_ptr->prev;
            s_ptr->prev->next = s_ptr->next;
            cfree (s_ptr);
            break;
         }
         else
         {  /* delete the whole line */
            s_ptr1 = s_ptr->next;
            s_ptr1->prev = s_ptr->prev;
            cfree (s_ptr);
            s_ptr = s_ptr1;
         }
      }
      else
      {  /* looking for the beginning ... */
         if (s_ptr == curStr && s_ptr == endStr)
         {  /* the whole string to be deleted is within s_ptr */
            new_cur_str = s_ptr;
            new_cur_index = min(textCurIndex,textEndIndex);
            new_cur_y = y;
            second_index = max(textCurIndex,textEndIndex);
            s = new_cur_str->s;
            len = strlen (&(s[second_index]));
            for (i = 0; i <= len; i++) s[new_cur_index+i] = s[second_index+i];
            break;
         }
         else if (s_ptr == curStr || s_ptr == endStr)
         {  /* found the beginning */
            new_cur_str = s_ptr;
            new_cur_index = (s_ptr == curStr) ? textCurIndex : textEndIndex;
            new_cur_y = y;
            s_ptr->s[new_cur_index] = '\0';
            highlighting = TRUE;
            s_ptr = s_ptr->next;
         }
         else
         {  /* still looking */
            s_ptr = s_ptr->next;
         }
      }
   }
   textHighlight = FALSE;
   curStr = new_cur_str;
   textCurIndex = new_cur_index;
   curStrW = XTextWidth (canvasFontPtr, curStr->s, strlen (curStr->s));
   if (curStrW > textW) textW = curStrW;
   textCurY = new_cur_y;
   SetTextCurX ();
}

static
void HandleCRLF (ColorIndex)
   int	ColorIndex;
{
   register int		i, y;
   struct StrRec	* str_ptr;
   int			need_redraw = textHighlight;

   if (textHighlight) DeleteHighlightedText ();

   y = textCurY;
   for (str_ptr = curStr; str_ptr != NULL; str_ptr = str_ptr->next)
   {
      PaintCurText (drawWindow, drawGC, str_ptr->s, textJust, textOrigX,
            y, canvasFontPtr, ColorIndex, penPat, ERASE, INVALID, INVALID);
      y += textCursorH;
   }

   str_ptr = (struct StrRec *) calloc (1, sizeof(struct StrRec));
   strcpy (str_ptr->s, &curStr->s[textCurIndex]);
   curStr->s[textCurIndex] = '\0';
   AddStr (curStr, curStr->next, str_ptr);
   curStr = str_ptr;
   textCurY += textCursorH;
   textCurIndex = 0;
   curStrW = XTextWidth (canvasFontPtr, curStr->s, strlen (curStr->s));
   SetTextCurX ();
   i = textCursorH * NumLines ();
   if (i > textH)
   {
      textH = i;
      RedrawCurText ();
   }
   else if (need_redraw)
      RedrawCurText ();
   else
   {
      y = textCurY - textCursorH;
      for (str_ptr = curStr->prev; str_ptr != NULL; str_ptr = str_ptr->next)
      {
         PaintCurText (drawWindow, drawGC, str_ptr->s, textJust,
               textOrigX, y, canvasFontPtr, ColorIndex, penPat, PAINT_NORM,
               INVALID, INVALID);
         y += textCursorH;
      }
   }
}

static
void HandleBS (ColorIndex)
   int	ColorIndex;
{
   register int		i, y;
   register char	* s;
   struct StrRec	* str_ptr;
   struct AttrRec       * attr_ptr;
   int			len1, len2;
   char			msg[80];

   if (textHighlight)
   {
      DeleteHighlightedText ();
      RedrawCurText ();
      return;
   }

   attr_ptr = curTextObj->detail.t->attr;
   if (firstStr == lastStr && attr_ptr != NULL && attr_ptr->inherited &&
         attr_ptr->nameshown && textCurIndex == strlen(attr_ptr->name))
      return;
   else
   {
      if (textCurIndex != 0)
      {
         PaintCurText (drawWindow, drawGC, curStr->s, textJust,
               textOrigX, textCurY, canvasFontPtr, ColorIndex, penPat, ERASE,
               INVALID, INVALID);

         s = curStr->s;
#ifndef KANJI	 
         for (i = textCurIndex; i <= strlen (curStr->s); i++) s[i-1] = s[i];
            textCurIndex--;
#else /* KANJI */
	 if ( 0x80 & s[textCurIndex - 1])
		 len1 = 2;
	 else
		 len1 = 1;
         for (i = textCurIndex; i <= strlen (curStr->s); i++) s[i-len1] = s[i];
         textCurIndex -= len1;
#endif /* KANJI */

         curStrW = XTextWidth (canvasFontPtr, curStr->s, strlen (curStr->s));
         PaintCurText (drawWindow, drawGC, curStr->s, textJust, textOrigX,
               textCurY, canvasFontPtr, ColorIndex, penPat, PAINT_NORM,
               INVALID, INVALID);
         SetTextCurX ();
      }
      else
      {
         if (curStr->prev != NULL)
         {
            y = textCurY - textCursorH;
            for (str_ptr=curStr->prev; str_ptr!=NULL; str_ptr=str_ptr->next)
            {
               PaintCurText (drawWindow, drawGC, str_ptr->s, textJust,
                     textOrigX, y, canvasFontPtr, ColorIndex, penPat, ERASE,
                     INVALID, INVALID);
               y += textCursorH;
            }

            if (curStr->next == NULL)
               lastStr = curStr->prev;
            else
               curStr->next->prev = curStr->prev;
            curStr->prev->next = curStr->next;
            textCurIndex = strlen (curStr->prev->s);
            len1 = strlen (curStr->prev->s);
            len2 = strlen (curStr->s);
            if (len1+len2 >= MAXSTRING)
            {
               sprintf (msg, "String length exceeds %1d.  String truncated.",
                     MAXSTRING);
               Msg (msg);
               curStr->s[MAXSTRING-len1] = '\0';
            }
            strcat (curStr->prev->s, curStr->s);
            cfree (curStr);
            curStr = curStr->prev;
            curStrW = XTextWidth (canvasFontPtr, curStr->s, strlen (curStr->s));
            textCurY -= textCursorH;
            SetTextCurX ();

            y = textCurY;
            for (str_ptr = curStr; str_ptr != NULL; str_ptr = str_ptr->next)
            {
               PaintCurText (drawWindow, drawGC, str_ptr->s, textJust,
                     textOrigX, y, canvasFontPtr, ColorIndex, penPat,
                     PAINT_NORM, INVALID, INVALID);
               y += textCursorH;
            }
            if (curStrW > textW)
            {
               textW = curStrW;
               RedrawCurText ();
            }
         }
      }
   }
}

static
void HandleChar (Str, ColorIndex)
   char	* Str;
   int	ColorIndex;
{
   register int		i;
   register char	* s;
   register int		amount;
   int			need_redraw;
   char			msg[80];
   XEvent		ev;

   if (need_redraw = textHighlight) DeleteHighlightedText ();

   if (textCurIndex+strlen (&(curStr->s[textCurIndex])) >= MAXSTRING)
   {
      sprintf (msg, "String length exceeds %1d.  Character ignored.",MAXSTRING);
      Msg (msg);
      RedrawCurText ();
      while (XCheckWindowEvent (mainDisplay, drawWindow, KeyPressMask, &ev)) ;
      return;
   }

   amount = XTextWidth (canvasFontPtr, Str, 1);
 
   if (textJust != JUST_L || textCurIndex != strlen (curStr->s))
      PaintCurText (drawWindow, drawGC, curStr->s, textJust, textOrigX,
            textCurY, canvasFontPtr, ColorIndex, penPat, ERASE,
            INVALID, INVALID);

   s = curStr->s;
   for (i = strlen (curStr->s); i >= textCurIndex; i--) s[i+1] = s[i];
   s[textCurIndex++] = *Str;

   curStrW += amount;
   if (!need_redraw)
      PaintCurText (drawWindow, drawGC, curStr->s, textJust, textOrigX,
            textCurY, canvasFontPtr, ColorIndex, penPat, PAINT_NORM,
            INVALID, INVALID);
   SetTextCurX ();
   if (curStrW > textW)
   {
      textW = curStrW;
      RedrawCurText ();
   }
   else if (need_redraw)
      RedrawCurText ();
}
 
void DrawText (input)
   XEvent	* input;
{
   char			s[80];
   XKeyEvent		* key_ev;
   KeySym		key_sym;
   XComposeStatus	c_stat;

   if (input->type == ButtonPress)
      HandleButton (&(input->xbutton));
   else if (input->type == KeyPress)
   {
      if (!textCursorShown) return;

      key_ev = &(input->xkey);
      XLookupString (key_ev, s, 80, &key_sym, &c_stat);

      if (!((s[0]=='\r' && (key_sym & 0xff)=='\r') ||
            (s[0]=='\n' && (key_sym & 0xff)=='\n') ||
            (s[0]=='\b' && (key_sym & 0xff)=='\b') ||
            (s[0]=='\b' && (key_sym & 0xff)=='h' &&
            (key_ev->state & ControlMask)) ||
            (s[0]=='\177' && (key_sym & 0x7f)=='\177') ||
            (key_sym>='\040' && key_sym<='\177')))
         return;

      EraseTextCursor ();
      s[1] = '\0';
      switch (s[0])
      {
         case '\r':
         case '\n': HandleCRLF (colorIndex); break;

         case '\177': /* <DEL> */
         case '\b': HandleBS (colorIndex); break;

         default:
            HandleChar (s, colorIndex);
            break;
      }
      PutTextCursor ();
#ifndef UC
      MarkRulers (textCurX>>zoomScale, textCurY>>zoomScale);
#else /* UC */
      MarkRulers (ScreenSize(textCurX, zoomScale), ScreenSize(textCurY, zoomScale));
#endif /* UC */
      SetFileModified (TRUE);
   }
}

void DumpOneStr (FP, Str)
   register FILE	* FP;
   register char	* Str;
{
#ifdef KANJI
   int kanjiin = 0, ankin = 0;
#endif /* KANJI */   
   for ( ; *Str != '\0'; Str++)
   {
#ifndef KANJI       
      switch (*Str)
      {
         case '(':
         case ')':
         case '\\': fprintf (FP, "\\");
      }
      fprintf (FP, "%c", *Str);
#else /* KANJI */
      if (curFont == FONT_MIN || curFont == FONT_GOT)
	 if (! kanjiin && 0x80 & *Str) {
	    kanjiin++; 
	    ankin = 0;
            fprintf (FP, "\\377\\001"); 
         } else if (! ankin && ! ( 0x80 & *Str)) {
	    ankin++;
            kanjiin = 0;
	    fprintf (FP, "\\377\\000"); 
         }
      switch (*Str & ((noEuc)? 0x7f:0xff))
      {
         case '(':
         case ')':
         case '\\': fprintf (FP, "\\");
      }
      fprintf (FP, "%c", *Str & ((noEuc)? 0x7f:0xff));
#endif /* KANJI */
   }
}

void DumpTextObj (FP, ObjPtr, PRTGIF)
   FILE				* FP;
   register struct ObjRec	* ObjPtr;
   int				PRTGIF;
{
   int			x, y, font_size, xinc = 0, yinc = 0, color_index;
   struct StrRec	* s_ptr;
   struct TextRec	* text_ptr = ObjPtr->detail.t;

   if (text_ptr->pen == NONEPAT) return;

   if (!PRTGIF) SaveCurFont ();

   curFont = text_ptr->font;
   curFontDPI = text_ptr->dpi;
   curStyle = text_ptr->style;
   curSize = text_ptr->size;
   textJust = text_ptr->just;
   curRotate = text_ptr->rotate;
   penPat = text_ptr->pen;

   if (PRTGIF)
   {
      canvasFontAsc = text_ptr->asc;
      canvasFontDes = text_ptr->des;
      textCursorH = canvasFontAsc + canvasFontDes;
      pointSize = (curFontDPI == FONT_DPI_75) ? pointSize75 : pointSize100;
   }
   else
      SetCanvasFont ();

   x = ObjPtr->x;
   y = ObjPtr->y;

   color_index = ObjPtr->color;
   if (colorDump)
      fprintf (FP, "%.3f %.3f %.3f setrgbcolor\n",
            ((float)tgifColors[color_index].red/maxRGB),
            ((float)tgifColors[color_index].green/maxRGB),
            ((float)tgifColors[color_index].blue/maxRGB));

   if (curFont == FONT_SYM)
   {
      fprintf (FP, "/Symbol ");
      font_size = pointSize[curSize];
      fprintf (FP, "findfont [%1d 0 0 -%1d 0 0] makefont setfont\n",
            font_size, font_size);
   }
#ifdef KANJI
   else if (curFont == FONT_MIN)
   {
      fprintf (FP, "/Ryumin-Times-H ");
      font_size = pointSize[curSize]; 
      fprintf (FP, "findfont [%1d 0 0 -%1d 0 0] makefont setfont\n",
            font_size, font_size, font_size);
   }
   else if (curFont == FONT_GOT)
   {
      fprintf (FP, "/Gothic-Helvetica-H ");
      font_size = pointSize[curSize];
      fprintf (FP, "findfont [%1d 0 0 -%1d 0 0] makefont setfont\n",
            font_size, font_size, font_size);
   }
#endif /* KANJI */
   else
   {
      switch (curFont)
      {
         case FONT_TIM: fprintf (FP, "/Times"); break;
         case FONT_COU: fprintf (FP, "/Courier"); break;
         case FONT_HEL: fprintf (FP, "/Helvetica"); break;
         case FONT_CEN: fprintf (FP, "/NewCenturySchlbk"); break;
      }
      switch (curStyle)
      {
         case STYLE_BI:
            switch (curFont)
            {
               case FONT_TIM: fprintf (FP, "-BoldItalic "); break;
               case FONT_COU: fprintf (FP, "-BoldOblique "); break;
               case FONT_HEL: fprintf (FP, "-BoldOblique "); break;
               case FONT_CEN: fprintf (FP, "-BoldItalic "); break;
            }
            break;
         case STYLE_BR: fprintf (FP, "-Bold "); break;
         case STYLE_NI:
            switch (curFont)
            {
               case FONT_TIM: fprintf (FP, "-Italic "); break;
               case FONT_COU: fprintf (FP, "-Oblique "); break;
               case FONT_HEL: fprintf (FP, "-Oblique "); break;
               case FONT_CEN: fprintf (FP, "-Italic "); break;
            }
            break;
         case STYLE_NR:
            switch (curFont)
            {
               case FONT_TIM: fprintf (FP, "-Roman "); break;
               case FONT_COU: fprintf (FP, " "); break;
               case FONT_HEL: fprintf (FP, " "); break;
               case FONT_CEN: fprintf (FP, "-Roman "); break;
            }
            break;
      }
      font_size = pointSize[curSize];
      fprintf (FP, "findfont [%1d 0 0 -%1d 0 0] makefont setfont\n",
            font_size, font_size);
   }

   fprintf (FP, "   gsave\n");
   switch (penPat)
   {
      case SOLIDPAT: break;
      case BACKPAT: fprintf (FP, "      1 setgray\n"); break;
      default:
         if (!colorDump)
            fprintf (FP, "      pat%1d 8 1 0 72 300 32 div div setpattern\n",
                  penPat);
         break;
   }

   switch (curRotate)
   {
      case ROTATE0: xinc = 0; yinc = textCursorH; break;
      case ROTATE90: xinc = -textCursorH; yinc = 0; break;
      case ROTATE180: xinc = 0; yinc = -textCursorH; break;
      case ROTATE270: xinc = textCursorH; yinc = 0; break;
   }

   for (s_ptr = text_ptr->first; s_ptr != NULL; s_ptr = s_ptr->next)
   {
      switch (curRotate)
      {
         case ROTATE0:
            fprintf (FP, "      %1d %1d moveto (", x, y+canvasFontAsc);
            break;
         case ROTATE90:
            fprintf (FP, "      %1d %1d moveto 90 rotate (",x-canvasFontAsc,y);
            break;
         case ROTATE180:
            fprintf (FP, "      %1d %1d moveto 180 rotate (",x,y-canvasFontAsc);
            break;
         case ROTATE270:
            fprintf (FP, "      %1d %1d moveto 270 rotate (",x+canvasFontAsc,y);
            break;
      }
      DumpOneStr (FP, s_ptr->s);
      switch (textJust)
      {
         case JUST_L:
            if (penPat == SOLIDPAT || penPat == BACKPAT || !colorDump)
               fprintf (FP, ") show\n");
            else
            {
               fprintf (FP, ") true charpath clip\n");
               DumpPatFill (FP, penPat, 8, ObjPtr->bbox, "      ");
            }
            break;
         case JUST_C:
            if (penPat == SOLIDPAT || penPat == BACKPAT || !colorDump)
               fprintf (FP, ") centertext show\n");
            else
            {
               fprintf (FP, ") centertext true charpath clip\n");
               DumpPatFill (FP, penPat, 8, ObjPtr->bbox, "      ");
            }
            break;
         case JUST_R:
            if (penPat == SOLIDPAT || penPat == BACKPAT || !colorDump)
               fprintf (FP, ") righttext show\n");
            else
            {
               fprintf (FP, ") righttext true charpath clip\n");
               DumpPatFill (FP, penPat, 8, ObjPtr->bbox, "      ");
            }
            break;
      }
      if (penPat != SOLIDPAT && penPat != BACKPAT && s_ptr->next != NULL &&
            colorDump)
      {
         fprintf (FP, "   grestore\n");
         fprintf (FP, "   gsave\n");
      }
      switch (curRotate)
      {
         case ROTATE0: break;
         case ROTATE90: fprintf (FP, "      -90 rotate \n"); break;
         case ROTATE180: fprintf (FP, "      -180 rotate \n"); break;
         case ROTATE270: fprintf (FP, "      -270 rotate \n"); break;
      }
      x += xinc;
      y += yinc;
   }
   fprintf (FP, "   grestore\n\n");

   if (!PRTGIF) RestoreCurFont ();
}

void DrawTextObj (Win, XOff, YOff, ObjPtr)
   Window		Win;
   int			XOff, YOff;
   struct ObjRec	* ObjPtr;
{
   struct TextRec	* text_ptr = ObjPtr->detail.t;
   struct StrRec	* s_ptr;
   int			x, y, xinc = 0, yinc = 0;

   SaveCurFont ();
   curFont = text_ptr->font;
   curFontDPI = text_ptr->dpi;
   curStyle = text_ptr->style;
   curSize = text_ptr->size;
   textJust = text_ptr->just;
   curRotate = text_ptr->rotate;
   SetCanvasFont ();

   x = ObjPtr->x - XOff;
   y = ObjPtr->y - YOff;

   switch (curRotate)
   {
      case ROTATE0: xinc = 0; yinc = textCursorH; break;
      case ROTATE90: xinc = -textCursorH; yinc = 0; break;
      case ROTATE180: xinc = 0; yinc = -textCursorH; break;
      case ROTATE270: xinc = textCursorH; yinc = 0; break;
   }

   for (s_ptr = text_ptr->first; s_ptr != NULL; s_ptr = s_ptr->next)
   {
      PaintText (Win, drawGC, s_ptr->s, textJust, curRotate, x, y,
            canvasFontPtr, ObjPtr->color, text_ptr->pen, PAINT_NORM,
            INVALID, INVALID);
      x += xinc;
      y += yinc;
   }

   if (curFontDPI != text_ptr->dpi) text_ptr->dpi = curFontDPI;
#ifdef KANJI
#ifndef UC
   if (canvasKanjiFontIsFake)
#else /* UC */
   if (canvasKanjiFontIsFake || zoomScale < 0)
#endif /* UC */
       SelBox (drawWindow, defaultGC,
	       OFFSET_X(ObjPtr->obbox.ltx), OFFSET_Y(ObjPtr->obbox.lty),
	       OFFSET_X(ObjPtr->obbox.rbx), OFFSET_Y(ObjPtr->obbox.rby));
#endif /* KANJI */   
   RestoreCurFont ();
}

void RedrawCurText ()
{
   register int		x = 0, y;
   struct StrRec	* s_ptr;
   int			highlighting = FALSE, mode;
   int			first_index = INVALID, second_index = INVALID;

   if (!textCursorShown) return;

   switch (textJust)
   {
      case JUST_L: x = textOrigX-2; break;
      case JUST_C: x = textOrigX-textW/2-2; break;
      case JUST_R: x = textOrigX-textW-2; break;
   }
   XClearArea (mainDisplay, drawWindow, x, textOrigY-2,
         textW+5, textH+5, FALSE);
   XDrawRectangle (mainDisplay, drawWindow, defaultGC, x, textOrigY-2,
         textW+4, textH+4);

   y = textOrigY;

   for (s_ptr = curTextObj->detail.t->first; s_ptr != NULL; s_ptr = s_ptr->next)
   {
      if (textHighlight)
      {
         first_index = second_index = INVALID;
         if (highlighting)
         {
            if (s_ptr == curStr || s_ptr == endStr)
            {
               mode = PAINT_INV_NORM;
               first_index = (s_ptr == curStr) ? textCurIndex : textEndIndex;
               highlighting = FALSE;
            }
            else
            {
               mode = PAINT_INV;
               first_index = (s_ptr == curStr) ? textCurIndex : textEndIndex;
            }
         }
         else
         {
            if (s_ptr == curStr && s_ptr == endStr)
            {
               mode = PAINT_NORM_INV_NORM;
               first_index = min(textCurIndex,textEndIndex);
               second_index = max(textCurIndex,textEndIndex);
            }
            else if (s_ptr == curStr || s_ptr == endStr)
            {
               mode = PAINT_NORM_INV;
               first_index = (s_ptr == curStr) ? textCurIndex : textEndIndex;
               highlighting = TRUE;
            }
            else
               mode = PAINT_NORM;
         }
      }
      else
         mode = PAINT_NORM;

      PaintCurText (drawWindow, drawGC, s_ptr->s, textJust, textOrigX, y,
            canvasFontPtr, colorIndex, penPat, mode, first_index, second_index);
      y += canvasFontHeight;
   }

   PutTextCursor ();
}

void SaveString (FP, S)
   FILE			* FP;
   register char	* S;
{
   for ( ; *S != '\0'; S++)
   {
      if (*S == '\\')
         fprintf (FP, "%s", "\\\\");
      else if (*S == '"')
         fprintf (FP, "%s", "\\\"");
      else
         putc (*S, FP);
   }
}

void SaveTextObj (FP, ObjPtr)
   FILE			* FP;
   struct ObjRec	* ObjPtr;
{
   register struct TextRec	* text_ptr = ObjPtr->detail.t;
   register struct StrRec	* s_ptr;

   fprintf (FP, "text('%s',", colorMenuItems[ObjPtr->color]);
   fprintf (FP,
         "%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,%1d,[\n",
         ObjPtr->x, ObjPtr->y, text_ptr->font, text_ptr->style, text_ptr->size,
         text_ptr->lines, text_ptr->just, text_ptr->rotate, text_ptr->pen,
         ObjPtr->obbox.rbx-ObjPtr->obbox.ltx,
         ObjPtr->obbox.rby-ObjPtr->obbox.lty, ObjPtr->id, text_ptr->dpi,
         text_ptr->asc, text_ptr->des);

   for (s_ptr = text_ptr->first; s_ptr->next != NULL; s_ptr = s_ptr->next)
   {
      fprintf (FP, "\t\"", s_ptr->s);
      SaveString (FP, s_ptr->s);
      fprintf (FP, "\",\n", s_ptr->s);
   }

   fprintf (FP, "\t\"", s_ptr->s);
   SaveString (FP, s_ptr->s);
   fprintf (FP, "\"])", s_ptr->s);
}

char * ReadString (Str)
   char	*	Str;
{
   register char	* s = Str;

   for (s = Str; *s != '\0' && *s != '"'; s++)
      if (*s == '\\')
         strcpy (s, s+1);

   if (*s == '"') s++;
   return (s);
}

void ReadTextObj (FP, Inbuf, ObjPtr, PRTGIF)
   FILE			* FP;
   char			* Inbuf;
   struct ObjRec	* * ObjPtr;
   int			PRTGIF;
{
   register int		i, max_len = 0, len;
   struct StrRec	* s_ptr;
   struct TextRec	* text_ptr;
   char			color_str[80], * s;
   char			tmp_str[MAXSTRING+1], inbuf[MAXSTRING+1];
#ifdef KANJI
   char			eucStr[MAXSTRING+1];
#endif /* KANJI */
   int			num_lines, x, y, font, style, size;
   int			text_just, rotate, pen;
   int			bbox_w, bbox_h, dpi, asc, des;

   * ObjPtr = (struct ObjRec *) calloc (1, sizeof(struct ObjRec));
   s = FindChar ('(', Inbuf);
   s = ParseStr (s, ',', color_str);
   if (fileVersion <= 2)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d", &x, &y, &font, &style,
            &size, &num_lines, &text_just);
      rotate = 0;
      pen = 1;
      (*ObjPtr)->id = objId++;
      dpi = FONT_DPI_75;
   }
   else if (fileVersion <= 6)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d , %d , %d", &x, &y, &font,
            &style, &size, &num_lines, &text_just, &rotate, &pen);
      (*ObjPtr)->id = objId++;
      dpi = FONT_DPI_75;
   }
   else if (fileVersion <= 7)
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d , %d , %d , %d , %d",
            &x, &y, &font, &style, &size, &num_lines, &text_just, &rotate, &pen,
            &bbox_w, &bbox_h);
      (*ObjPtr)->id = objId++;
      dpi = FONT_DPI_75;
   }
   else if (fileVersion <= 9)
   {
      sscanf (s,
            "%d , %d , %d , %d , %d , %d , %d , %d , %d , %d , %d , %d , %d",
            &x, &y, &font, &style, &size, &num_lines, &text_just, &rotate, &pen,
            &bbox_w, &bbox_h, &((*ObjPtr)->id), &dpi);
      if ((*ObjPtr)->id >= objId) objId = (*ObjPtr)->id + 1;
   }
   else
   {
      sscanf (s, "%d , %d , %d , %d , %d , %d , %d , %d , %d , %d , %d , %d , \
            %d , %d , %d",
            &x, &y, &font, &style, &size, &num_lines, &text_just, &rotate, &pen,
            &bbox_w, &bbox_h, &((*ObjPtr)->id), &dpi, &asc, &des);
      if ((*ObjPtr)->id >= objId) objId = (*ObjPtr)->id + 1;
   }

   text_ptr = (struct TextRec *) calloc (1, sizeof(struct TextRec));
   text_ptr->lines = num_lines;

   if (!PRTGIF) SaveCurFont ();

   curFont = text_ptr->font = font;
   curFontDPI = text_ptr->dpi = dpi;
   curStyle = text_ptr->style = style;
   curSize = text_ptr->size = size;
   textJust = text_ptr->just = text_just;
   curRotate = text_ptr->rotate = rotate;
   penPat = text_ptr->pen = pen;

   if (PRTGIF)
   {
      if (fileVersion < 10)
      {
         canvasFontAsc =
               pDrawFontAsc[FontIndex(curFontDPI,curFont,curSize,curStyle)];
         canvasFontDes =
               pDrawFontDes[FontIndex(curFontDPI,curFont,curSize,curStyle)];
      }
      else
      {
         canvasFontAsc = asc;
         canvasFontDes = des;
      }
      textCursorH = canvasFontAsc + canvasFontDes;
   }
   else
      SetCanvasFont ();

   text_ptr->asc = canvasFontAsc;
   text_ptr->des = canvasFontDes;

   for (i = 0; i < num_lines; i++)
   {
      fgets (inbuf, MAXSTRING, FP);
      strcpy(tmp_str, FindChar ('"', inbuf));
#ifdef KANJI
      len = j2e(strlen (tmp_str), &tmp_str[0], &eucStr[0]);
      eucStr[len] = '\0';
      strcpy(&tmp_str[0], &eucStr[0]);
#endif /* KANJI */   
      s = ReadString (tmp_str);
      *(--s) = '\0';
      s_ptr = (struct StrRec *) calloc (1, sizeof(struct StrRec));
      strcpy (s_ptr->s, tmp_str);
      AddStr (lastStr, NULL, s_ptr);
      if (PRTGIF)
         len = strlen (tmp_str); /* assume string width = 1 pixel per char */
      else
#ifndef KANJI
         len = XTextWidth (canvasFontPtr, tmp_str, strlen (tmp_str));
#else /* KANJI */
         len = XTextFakeWidth (canvasFontPtr, tmp_str, strlen (tmp_str));
#endif /* KANJI */
      if (len > max_len) max_len = len;
   }
   text_ptr->first = firstStr;
   text_ptr->last = lastStr;

   firstStr = lastStr = NULL;
   textCurIndex = 0;

   (*ObjPtr)->x = x;
   (*ObjPtr)->y = y;

   if (PRTGIF && fileVersion > 6)
      SetTextBBox (*ObjPtr, text_just, bbox_w, bbox_h, rotate);
   else
      SetTextBBox (*ObjPtr, text_just, max_len, num_lines*textCursorH, rotate);

   (*ObjPtr)->type = OBJ_TEXT;
   (*ObjPtr)->color = FindColorIndex (color_str);
   (*ObjPtr)->dirty = FALSE;
   (*ObjPtr)->detail.t = text_ptr;

   if (!PRTGIF)
   {
      if (curFontDPI != text_ptr->dpi) text_ptr->dpi = curFontDPI;
      RestoreCurFont ();
   }
}

void ClearCurText ()
{
   if (textCursorShown)
   {
      EraseTextCursor ();
      textCursorShown = FALSE;
      if (editingText)
      {
         PopCurFont ();
         ShowJust ();
         ShowColor (FALSE);
         ShowCurFont ();
      }
   }
   firstStr = lastStr = curStr = NULL;
   curTextObj = NULL;
   textCurIndex = 0;
   curStrW = 0;
   editingText = FALSE;
}

void AdjustCurText (XOff, YOff)
   int	XOff, YOff;
{
   textOrigX += XOff;
   textOrigY += YOff;
   textCurX += XOff;
   textCurY += YOff;
}

static
int PaintLeftText (Str, Just, Rotate, LtX, LtY)
   char	* Str;
   int	Just, Rotate, LtX, LtY;
   /* LtX and LtY are UNSCALED screen offset */
{
   register int	amount;

   if (zoomScale != 0)
   {
#ifndef UC
      LtX >>= zoomScale;
      LtY >>= zoomScale;
#else /* UC */
      LtX = ScreenSize(LtX, zoomScale);
      LtY = ScreenSize(LtY, zoomScale);
#endif /* UC */
      amount = XTextWidth (canvasFontPtr, Str, strlen (Str));
      BlurText (drawWindow, drawGC, Just, Rotate, LtX, LtY,
#ifndef UC
            (amount>>zoomScale)+1, (textCursorH>>zoomScale)+1);
#else /* UC */
            (ScreenSize(amount, zoomScale))+1, (ScreenSize(textCursorH, zoomScale))+1);
#endif /* UC */
      return (amount);
   }

   LtY += canvasFontAsc;
   amount = XTextWidth (canvasFontPtr, Str, strlen (Str));
   XDrawString (mainDisplay, drawWindow, drawGC, LtX, LtY, Str, strlen (Str));

   return (amount); /* return the length of the painted string */
}

void RepaintFirstStr (ObjPtr, Str)
   struct ObjRec	* ObjPtr;
   char			* Str;
   /* Replace (graphically) the FIRST string of the text in ObjPtr by Str */
{
   register char	* s = ObjPtr->detail.t->first->s, * s1 = Str;
   char			tmp_str[MAXSTRING+1], * c_ptr;
   int			len;
   struct BBRec		bbox;
   XGCValues		values;

   bbox.ltx = ObjPtr->obbox.ltx; bbox.lty = ObjPtr->obbox.lty;
   bbox.rbx = ObjPtr->obbox.rbx; bbox.rby = ObjPtr->obbox.rby;

   c_ptr = tmp_str;
   for ( ; *s != '\0' && *s1 != '\0' && *s1 == *s; *c_ptr++ = *s++, s1++) ;

   if (*s == *s1) return; /* no updates */
   ObjPtr->detail.t->attr->owner->dirty = TRUE;
   *c_ptr = '\0';

   SaveCurFont ();
   curFont = ObjPtr->detail.t->font;
   curFontDPI = ObjPtr->detail.t->dpi;
   curStyle = ObjPtr->detail.t->style;
   curSize = ObjPtr->detail.t->size;
   textJust = ObjPtr->detail.t->just;
   curRotate = ObjPtr->detail.t->rotate;
   SetCanvasFont ();

   if (*s != '\0')
   {
      values.foreground = myBgPixel;
      values.function = GXcopy;
      values.fill_style = FillSolid;
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle, &values);

      len = XTextWidth (canvasFontPtr, tmp_str, strlen (tmp_str));
      XFillRectangle (mainDisplay, drawWindow, drawGC, OFFSET_X(bbox.ltx+len),
#ifndef UC
            OFFSET_Y(bbox.lty), (bbox.rbx-bbox.ltx-len>>zoomScale)+1,
               (textCursorH>>zoomScale)+1);
#else /* UC */
            OFFSET_Y(bbox.lty), (ScreenSize(bbox.rbx-bbox.ltx-len, zoomScale))+1,
               (ScreenSize(textCursorH, zoomScale))+1);
#endif /* UC */

      values.foreground = colorPixels[ObjPtr->color];
      XChangeGC (mainDisplay, drawGC, GCForeground, &values);
   }
   else
   {
      values.foreground = colorPixels[ObjPtr->color];
      values.function = GXcopy;
      values.fill_style = FillSolid;
      XChangeGC (mainDisplay, drawGC,
            GCForeground | GCFunction | GCFillStyle, &values);
   }

   ObjPtr->bbox.rbx = ObjPtr->obbox.rbx = bbox.ltx + PaintLeftText (Str,
         textJust, curRotate, bbox.ltx-drawOrigX, bbox.lty-drawOrigY);

   RestoreCurFont ();
}
#ifdef KANJI
static
void HandleNChars (Str, ColorIndex, len)
   int len;
   char	* Str;
   int	ColorIndex;
{
   register int		i, totallen;
   register char	* s;
   register int		amount;
   int			need_redraw;
   char			msg[80];
   XEvent		ev;

   if (len == 0) return;
   
   if (need_redraw = textHighlight) DeleteHighlightedText ();

   if ((totallen = textCurIndex+strlen (&(curStr->s[textCurIndex]) + (len - 1)))
       >= MAXSTRING)
   {
      sprintf (msg, "String length exceeds %1d.  Character ignored.",MAXSTRING);
      Msg (msg);
      if ((len = totallen - MAXSTRING) <= 0) {
         RedrawCurText ();
         while (XCheckWindowEvent (mainDisplay, drawWindow, KeyPressMask, &ev)) ;
         return;
       }
   }

   amount = XTextWidth (canvasFontPtr, Str, len);
 
   if (textJust != JUST_L || textCurIndex != strlen (curStr->s))
      PaintText (drawWindow, drawGC, curStr->s, textJust, ROTATE0, textOrigX,
            textCurY, canvasFontPtr, ColorIndex, penPat, ERASE,
            INVALID, INVALID);

   s = curStr->s;
   for (i = strlen (curStr->s); i >= textCurIndex; i--) 
	   s[i+len] = s[i];
   strncpy(&s[textCurIndex], Str, len);
   textCurIndex += len;

   curStrW += amount;
   if (!need_redraw)
      PaintText (drawWindow, drawGC, curStr->s, textJust, ROTATE0, textOrigX,
            textCurY, canvasFontPtr, ColorIndex, penPat, PAINT_NORM,
            INVALID, INVALID);
   SetTextCurX ();
   if (curStrW > textW)
   {
      textW = curStrW;
      RedrawCurText ();
   }
   else if (need_redraw)
      RedrawCurText ();
}

#define MAX_TEXT 1000
#include <ctype.h>

void myInsertTextObj (CutBuffer)
unsigned char * CutBuffer;
{
   register unsigned char *p, *r;
   int maxtext;

   if (!textCursorShown)
       return;

   EraseTextCursor ();

   for(p = r = CutBuffer; ; p++){
      if (*p == '\0') {
	  HandleNChars (r, colorIndex, p-r);
	  break;
      }
      if (*p == '\r' || *p == '\n') {
	  HandleNChars (r, colorIndex, p - r);
	  r = p + 1;
           HandleCRLF (colorIndex);
      }
   }
   PutTextCursor ();
#ifndef UC
   MarkRulers (textCurX>>zoomScale, textCurY>>zoomScale);
#else /* UC */
   MarkRulers (ScreenSize(textCurX, zoomScale), ScreenSize(textCurY, zoomScale));
#endif /* UC */
   SetFileModified (TRUE);
}
#endif /* KANJI */
