/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/tgif.c,v 2.0 91/03/05 12:48:48 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include "const.h"
#include "types.h"

#include "mainloop.e"
#include "msg.e"
#include "setup.e"

#ifdef UC
#include "cursor.e"
#include "grid.e"
#include "drawarc.e"
#endif /* UC */
#ifdef DEBUG
#include "mainloop.e"
#include "msg.e"
#include "setup.e"
#include "version.e"
#endif /* DEBUG */
#ifdef KINPUT
#include "kconvert.e"
#endif /* KINPUT */
#ifdef KANJI
#include "file.e"
#endif /* KANJI */
/*
 * extern int	malloc_debug ();
 */

int	lastFile;
short	* pDrawFontAsc;
short	* pDrawFontDes;

#ifdef UC
usage()
{
    fprintf(stderr, "usage: tgif [options][filename]\n");
    fprintf(stderr, "  where options are:\n");
    fprintf(stderr, "  -display <display> or -d <display>\n");
    fprintf(stderr, "  -reverse, -rv or -r\n");
    fprintf(stderr, "  -eps\n");
    fprintf(stderr, "  -savewitheps or -swe\n");    
#ifdef KINPUT
    fprintf(stderr, "  -autokinput or -ak\n");
#endif /* KINPUT */
#ifdef KANJI
    fprintf(stderr, "  -euc\n");
    fprintf(stderr, "  -nokanji\n");    
#endif /* KANJI */
    fprintf(stderr, "  -showdragcursor or -sc\n");
    fprintf(stderr, "  -hidecursor or -hc\n");
    fprintf(stderr, "  -currentdirectory <path> or -cd <path>\n");        
    fprintf(stderr, "  -larc\n");
    fprintf(stderr, "  -help\n");
    exit(1);
    /*NOTREACHED*/
}
#endif /* UC */
/*
 * static
 * void Prompt2 (PromptStr, OpName, FileName)
 *    char	* PromptStr, * OpName, * FileName;
 * {
 *    char	inbuf[80];
 * 
 *    printf (PromptStr);
 *    fgets (inbuf, 80, stdin);
 *    sscanf (inbuf, "%s%s", OpName, FileName);
 * }
 *
 * static
 * void Prompt3 (PromptStr, AttrName, ColorName, ValName)
 *    char	* PromptStr, * AttrName, * ColorName, * ValName;
 * {
 *    char	inbuf[80];
 * 
 *    printf (PromptStr);
 *    fgets (inbuf, 80, stdin);
 *    sscanf (inbuf, "%s%s%s", AttrName, ColorName, ValName);
 * }
 */

int main (argc, argv)
   int	argc;
   char	* argv[];
   /* All these strangeness with strings are related to */
   /*	Prolog's foreign function interface. */
{
   int	i;
   char	op_name[80], file_name[80], s[80];
   char	* sp[6], * func_strp;
/*
 * char	color_name[80], val_name[80];
 * char	attr_name[80], speed_name[80], id_name[80];
 */
   file_name[0] = '\0';
   for (i = 1; i < argc; i++)
   {
#ifdef UC
      if (!strcmp ("-display", argv[i]) || !strcmp ("-d", argv[i])) {
	   if (++i>=argc) usage ();
	   displayName = argv[i];
	   continue;
      }
      if (!strcmp ("-reverse", argv[i]) || !strcmp ("-rv", argv[i]) || !strcmp ("-r", argv[i])) {
	   reverseVideo = TRUE;
	   continue;
      }
      if (!strcmp("-help", argv[i])) {
	   usage();
      }
      if (!strcmp ("-eps", argv[i]))
      {
 	   whereToPrint = LATEX_FIG;
  	   continue;
      }
      if (!strcmp ("-savewitheps", argv[i]) || !strcmp ("-swe", argv[i]))
      {
 	   saveWithEps = TRUE;
  	   continue;
      }
      if (!strcmp ("-showdragcursor", argv[i]) || !strcmp ("-sc", argv[i]))
      {
 	   hideDragCursor = FALSE;
  	   continue;
      }
      if (!strcmp ("-hidecursor", argv[i]) || !strcmp ("-hc", argv[i]))
      {
 	   hideDragCursor = TRUE;
  	   continue;
      }
      if (!strcmp ("-currentdirectory", argv[i]) || !strcmp ("-cd", argv[i]) ||
	  !strcmp ("-defaultdirectory", argv[i]) || !strcmp ("-dd", argv[i])) {
	   if (++i>=argc) usage ();
	   defaultDir = TRUE;
	   defaultDirStr = argv[i];
	   continue;
      }
      if (!strcmp ("-larc", argv[i]))
      {
 	   xLibArc = TRUE;
  	   continue;
      }
#ifdef KINPUT
      if (!strcmp ("-autokinput", argv[i]) || !strcmp ("-ak", argv[i]))
      {
 	   autoKinput = TRUE;
  	   continue;
      }
#endif /* KINPUT */
#ifdef KANJI
      if (!strcmp ("-euc", argv[i]))
      {
	   noEuc = FALSE;
	   continue;
      }
      if (!strcmp ("-nokanji", argv[i]))
      {
	   noKanji = TRUE;
	   continue;
      }
#endif /* KANJI */
#endif /* UC */
      if (*argv[i] == '=')
      {
         strcpy (geometrySpec, argv[i]);
         geometrySpecified = TRUE;
      }
      else if (*argv[i] != '-')
         strcpy (file_name, argv[i]);
   }
/*
 * malloc_debug (1);
 */
   if (file_name[0] == '\0')
      MainLoop ("init", "", &func_strp,
            &sp[0], &sp[1], &sp[2], &sp[3], &sp[4], &sp[5]);
   else
      MainLoop ("init", file_name, &func_strp,
            &sp[0], &sp[1], &sp[2], &sp[3], &sp[4], &sp[5]);
/*
 * for (i = 0; i < 6; i++)
 *    if (strcmp (sp[i], "") != 0)
 *       printf ("%s ", sp[i]);
 *    else
 *       break;
 * printf ("\n");
 */

   while (TRUE)
   {
      strcpy (s, func_strp);
      s[4] = '\0';

      DeallocStrings (&func_strp,&sp[0],&sp[1],&sp[2],&sp[3],&sp[4],&sp[5]);

      if (strcmp (s, "Quit") == 0)
      {
         MainLoop ("quit", file_name, &func_strp,
               &sp[0], &sp[1], &sp[2], &sp[3], &sp[4], &sp[5]);
         break;
      }

      Msg ("Returned from basic driver.");
/*
 *    Prompt2 ("Input an operation and a sub command.\n",op_name,file_name);
 *
 *    if (strcmp (op_name, "animate") == 0)
 *    {
 *       Prompt3 ("Input poly_id, speed, color.\n", id_name, speed_name,
 *             color_name);
 *       Animate (file_name, id_name, speed_name, color_name, &func_strp);
 *       printf ("Animate RETURNs --> %s %s %s\n", func_strp, sp[0], sp[1]);
 *    }
 *    if (strcmp (op_name, "upd_attr_val") == 0)
 *    {
 *       Prompt3 ("Input attrname, color and value.\n", attr_name, color_name,
 *             val_name);
 *       UpdAttrVal (file_name, attr_name, color_name, val_name, &func_strp);
 *       printf ("UpdAttrVal RETURNs --> %s %s %s\n", func_strp, sp[0], sp[1]);
 *    }
 */
      MainLoop (op_name, file_name, &func_strp,
            &sp[0], &sp[1], &sp[2], &sp[3], &sp[4], &sp[5]);
/*
 *    printf ("RETURN --> %s ", func_strp);
 *    for (i = 0; i < 6; i++)
 *       if (strcmp (sp[i], "") != 0)
 *          printf ("%s ", sp[i]);
 *       else
 *          break;
 *    printf ("\n");
 */
   }
   return (0);
}
