.\"@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/tgif.man,v 2.0 91/03/05 12:50:40 william Exp $
.TH TGIF 1 "Version 2.0 and Above" "Tgif"
.SH NAME
\fItgif\fR \- Xlib based 2-D drawing facility under X11.  Also supports
hierarchical construction of drawings.
.SH SYNOPSIS
.B tgif
[\fB=Geometry\fR] 
[\fIfile\fR]
.SH DESCRIPTION
\fITgif\fR is an interactive drawing tool that allows the user to draw and
manipulate objects in the X Window System.
The command line argument \fIfile\fR
specifies a file of objects to be initially edited by tgif.
Tgif is purely based on \fIXlib\fR.
It is tested under X11-R4, and
it requires a 3 button mouse.
.PP
Primitive objects supported by tgif
are rectanges, ovals, rounded-corner rectangles, arcs,
polylines, polygons, open-splines, closed-splines, X11 bitmaps,
and text.  Objects can be grouped together to form a \fIgrouped\fR object.
A grouped object can be made into an \fIicon\fR object or a
\fIsymbol\fR object through user commands.  (Grouped, icon, and symbol
objects are also refered to as \fIcomplex\fR objects.)
.PP
Tgif objects are stored in two types of files.  A file with a
.I \.obj
extension (refered to as an \fIobject\fR file)
is a file of objects, and a file with a
.I \.sym
extension (refered to as a \fIsymbol\fR file)
specifies a ``building-block'' object.
A building-block object consists of the
\fIrepresentation\fR part and the \fIdefinition\fR
part of the object.
Tgif supports the ``bottom-up'' construction of hierarchical
drawings by providing the capability to ``instantiate'' a
building-block object in a drawing.  Tgif also supports the ``top-down''
specification of drawings by allowing the user to make any
complex object the \fIrepresentation\fR
of an un-specified subsystem.  Both types of files are stored in the
form of Prolog facts.  Prolog code can be written to interpret
the drawings!  (It is left to the user to produce this code.
See \fItgif.pl\fR for hints.)  Prolog engines will be refered to as
\fIdrivers\fR in the sections follows.
.PP
\fIAttributes\fR can be attached to any non-text
objects.
Attributes specified in the representation part of a
building-block object are non-detachable, when such an object is instantiated.
See \fBATTRIBUTES\fR section for details.
.PP
Tgif can generate outputs in three different format.
By default, the output is in PostScript(TM) format (color PostScript
is supported), and it is generated in to a file named
/tmp/Tgifa* (produced by mktemp() calls) where * is a number
and this file is piped to lpr.  This takes place when the
laser-printer icon is displayed in the Choice Window (see below
for the naming of tgif windows).
This output can be redirected to a file with a
.I \.ps
extension.  This takes place when the \fIPS\fR icon is displayed.
When the \fILaTeX\fR icon is display, the output generated with the
.I \.eps
extension, and the file is in
the encapsulated PostScript format.
This file can be included in a LaTeX document with the
\fIpsfig\fR or \fIepsf\fR construct; this will be discussed later.
When the \fIx11bm\fR (X11 bitmap) icon is displayed in the
Choice Window and color output is \fInot\fR selected,
tgif generates the output with the
.I \.xbm
extension, and the output is in the X11 bitmap format.
However, if the \fIx11bm\fR (X11 bitmap) icon is displayed in the
Choice Window and color output \fIis\fR selected (through the ^#K
keyboard command),
tgif generates the output with the
.I \.xpm
extension, and the output is in the X11 pitmap format.
An X11 bitmap file can be \fIimported\fR into tgif and be represented
as an tigf primitive object.
.SH GRAPHICAL OBJECTS
An object in an \fIobject\fR file can be a primitive object, a grouped
object, or an \fIicon\fR object.
A \fIsymbol\fR file is an object file with exactly one \fIsymbol\fR
object.  (Recall that a symbol file specifies a building-block
object.)  The symbol object in a symbol file is the representation
part of the building-block object, and the rest of the
symbol file is the definition
part of the building-block object.  The symbol object is highlighted
with a dashed outline to distinguished it from the rest of
the objects.  When a building-block object is instantiated,
the symbol part of the file is copied into the graphics editor and becomes
the icon for the building-block object.
.PP
All objects in tgif can be moved, duplicated, deleted, rotated, 
and flipped.  (However, flipping text objects horizontally will
cause the text justification to change, and flipping text objects
vertically will usually cause the text object to move.)
All objects except text, bitmap, and icon objects can be stretched
(scaled).
.PP
Tgif supports 20 fill patterns, 20 pen patterns, 7 line widths, 4 line
styles (plain, head arrow, tail arrow, double arrows) for
polyline and open-splines, 5 dash patterns,
3 types of text justifications, 4 text
styles (roman, itatlic, bold, bold-italic), 12 text sizes
(8, 10, 12, 14, 18, and 24 for the 75dpi fonts and
11, 14, 17, 20, 25, and 34 for the 100dpi fonts), 5 fonts (Times, Courier,
Helvetica, New-Century-Schoolbook, Symbol), and 10 default colors (magenta,
red, green, blue, yellow, pink, cyan, cadet-blue, white, black).
Only right-angle rotations are supported.
Most commands in tgif can either be activated by a
pop-up menu or by typing an appropriate
non-alphanumeric key.
.SH TGIF SUBWINDOWS
The tgif windows are described below.
.TP
.I Top Window
Displays the name of the file tgif is looking at.  Mouse clicks
and key presses have no effect.
.TP
.I Message Window
This is right under the top window on the left.
It displays tgif messages.  Clicking the left mouse button
in this window scrolls
the messages towards the bottom, clicking the right mouse
button scrolls towards
the top, and clicking hte middle mouse button scrolls
to the location in the
message history depending on where the mouse is clicked.
.TP
.I Panel (Choice) Window
This is the window to the right of the message window.
It displays the current choice (in top/bottom, left/right order) of the
drawing mode, color, horizontal alignment (L C R -),
vertical alignment (T M B -),
text justification, font, text rotation, special (see below),
line width, line style,
poly or spline, dash pattern, print mode, file (see below),
fill pattern, and pen pattern.
Key presses have no effect in this window.
.PP
.RS
The ``special'' and ``file'' mentioned above are dummy icons
that allow the ``special'' menu and the ``file'' menu to be
accesses in the Choice Window.
.PP
Left mouse button advances a particular choice; right mouse button
advances in the reverse direction, and the middle button generates a pop-up
menu to set a particular choice.  If there are objects selected in the
canvas window, then the action of the mouse will cause the selected
objects to change to the newly selected choice; note that in this
case, the current choice won't change if the middle button
is used; also, icon objects
will not change because they should be thought of as ``bitmaps''.
.PP
The settings of the horizontal and vertical
alignments determine how objects align with
each other when the ^L keyboard command is issued, they
determine how each individual object aligns with the grids
when the ^T keyboard command is issued, and they
determine how each icon replaces the old icion when the ^#U
keyboard comand is issued.  The horizontal
alignments are left (L), center (C), right (R), and ignore (-).
The vertical alignments are top (T), middle (M), bottom (B), and
ignore (-).  The best way to understand them is to try them out.
.RE
.TP
.I Canvas Window
This is the drawing area.  Left mouse button selects, moves, stretches,
and reshapes objects.
Holding down the shift key and clicking the left mouse
on an object which is not currently selected will add the
object to the list of already selected objects.  The same
action applied to an object which is already selected will cause
it to be de-selected.
When the drawing mode is set to
text, clicking left mouse button causes selected text to go into edit mode.
In the text edit mode, clicking the middle mouse button highlights sub-strings
of the text.
Right mouse button always generates the main
tgif pop-up menu.  Holding down the shift key and clicking the right
mouse button will change the drawing mode to \fIselect\fR.
Non-alphanumeric key presses are treated as tgif commands, and their
bindings are summarized in the following section.
.TP
.I Scrollbars
Only the left mouse button has effect in the scrollbar windows.
Clicking the left mouse button in the arrow portion of a scrollbar
window causes the canvas window to scroll a small distance on the page,
and clicking in the main area of the scrollbar window causes the
page to scroll to the specified location from the
top or the left of the page.
.TP
.I Rulers
.br
They track the mouse location.
Mouse clicks and key presses have no effect.
.SH NON-ALPHANUMERIC KEY BINDINGS
We use ``^'' for the control key and ``#'' for the meta key in the following
description.
.PP
.DS
  ^A	select all\br
  ^B	send selected objects to the back\br
  ^C	change domain\br
  ^D	duplicate selected objects\br
  ^F	send selected objects to the front\br
  ^G	group selected objects\br
  ^I	instantiate a building-block object\br
  ^K	pop back to (or return to) a higher level and close the symbol file
(reverse of ^V)\br
  ^L	align selected objects\br
  ^N	open a new un-named object file\br
  ^O	open an object file to edit\br
  ^P	print the current page\br
  ^Q	quit tgif\br
  ^R	redraw the page\br
  ^S	save the current object or symbol file\br
  ^T	align selected objects to the grid\br
  ^U	ungroup selected objects\br
  ^V	push into (or edit) the definition part of a building-block object
(selected object just be an icon object)\br
  ^W	change the drawing mode to text\br
  ^X	delete all selected objects\br
  ^Y	copy selected object to cut buffer\br
  ^Z	escape to driver\br
  ^,	scroll left\br
  ^.	scroll right\br
  ^-	print the current page with a specified command\br
\br
  #A	attach selected attributes to the selected complex object\br
  #B	escape to driver\br
  #C	rotate selected objects counter-clockwise\br
  #D	decrement grid size\br
  #E	send a token on a selected polyline\br
  #F	flash the selected polyline\br
  #G	show/un-show grid points\br
  #H	flip the selected object horizontally\br
  #I	increment the grid size\br
  #J	hide attribute names of the selected objects\br
  #K	change the drawing mode to select\br
  #L	give the line style and line width pop-up menu\br
  #M	move the attributes of a selected object\br
  #N	show all attribute names of the selected objects\br
  #O	zoom out\br
  #P	import a .obj file into the current file\br
  #Q	change the drawing mode to polyline/open-spline\br
  #R	change the drawing mode to rectangle\br
  #S	escapt to driver\br
  #T	detach the attributes of the selected objects\br
  #U	undo the previous delete operation\br
  #V	flip the selected object vertically\br
  #W	rotate the selected objects clockwise\br
  #X	escape to driver\br
  #Y	escape to driver\br
  #Z	zoom in\br
  #0	change the font size to 8 (11)\br
  #1	change the font size to 10 (14)\br
  #2	change the font size to 12 (17)\br
  #3	change the font size to 14 (20)\br
  #4	change the font size to 18 (25)\br
  #5	change the font size to 24 (34)\br
  #,	scroll up\br
  #.	scroll down\br
\br
 ^#A	add points to the selected poly or spline\br
 ^#B	change the text style to bold\br
 ^#C	change the text justification to center justified\br
 ^#D	delete points from the selected poly or spline\br
 ^#E	change the drawing mode to rounded-corner rectangles\br
 ^#F	invert selected bitmap objects\br
 ^#G	toggle snapping to the grid points\br
 ^#I	make the selected complex object iconic\br
 ^#J	make the selected icon object a grouped object\br
 ^#K	select color or black-and-white output\br
 ^#L	change the text justification to left justified\br
 ^#M	make the selected complex object symbolic\br
 ^#N	make the selected symbolic object a grouped object\br
 ^#O	change the text style to roman\br
 ^#P	change the text style to bold-italic\br
 ^#Q	change the drawing mode to polygon/closed-spline\br
 ^#R	change the text justification to right justified\br
 ^#S	save the file under a new name\br
 ^#T	change the text style to italic\br
 ^#U	update iconic representations of selected objects\br
 ^#V	change the drawing mode to oval\br
 ^#W	toggle between poly and spline\br
 ^#X	rotate among the various output file formats\br
 ^#Y	paste from the cut buffer\br
 ^#Z	change the drawing mode to arcs\br
 ^#.	import a X11 bitmap file\br
.DE
.br
.SH ATTRIBUTES
Attributes are text strings of the form \fIname=value\fR or \fIvalue\fR
which are attached to any non-text objects.
Attributes can be attached and detached from these objects
except in the following case:
.IP
Attributes of a symbol object in a building-block object file can not
be detached when the building-block object is instantiated.
These attributes are considered to be the ``inherited'' attributes
of the icon object.
.PP
The user has control over which part of an attribute is displayed.
An entire attribute can be made invisible, or only its name
can be made invisible (accomplished through the #M command).
.SH DOMAINS
A \fIdomain\fR is a collection of library symbols suitable for
instantiations.  A library is implemented as a directoy of .sym files,
and therefore, a domain is implemented as a search path.
If there are symbols with the same file names but reside
in different directories specified in the search path, then
the one closer to the front of the search path will be made
available for the user to instantiate.
.PP
The number of domains is be specified by the MaxDomains X default,
and the names of the domains are specified by the Domain# X default.
The library search paths are specified by csh environment variables.
See the section on X DEFAULTS and ENVIRONMENT VARIABLES for more details.
.SH HOW TO MAKE A BUILDING-BLOCK OBJECT (SYMBOL FILE)
Here are the steps for defining a building-block object, to be used
in a hierarchical design.
.IP 1)
Draw the representation part of the building-block object.  Group everything
together.  Select this grouped object.
.IP 2)
Pop-up the main menu with the right mouse button; select ``Special''.
Select ``MakeSymbolic'' from the next pop-up menu.
The selected object becomes a symbol and gets a dashed boundary.
.IP 3)
Type in attributes as individual text strings.  Select the
symbol object and all the
text strgings to be attached to the symbol.  Type #A (for \fIAttach\fR)
to attach attributes to the symbol.
.IP 4)
Build the definition part of the building-block object.  Look at the
``flip-flop.sym'' file for an example.  To look at that file, first,
instantiate a ``flip-flop'' by typing ^I (for \fIInstantialte\fR).
Select the flip-flop from
the pop-up window; place the flip-flop; select the flip-flop and
type ^V (for \fIPush\fR) to see the symbol file.
.IP 5)
Save and name the file.
.SH LATEX FIGURE FORMATS
Here we show how to make a figure for a LaTeX file, first with
the \fIpsfig\fR (or \fIepsf\fR) special construct, then with the
\fIpsfile\fR special construct.  (The author does not recommand
the \fIpsfile\fR construct.)  An example of both can be found
in ``example.tex'' included with this distribution.
.PP
To print a tgif file to be included in a LaTeX document with
the \fIpsfig\fR or \fIepsf\fR special construct
(files generated will be in the
\fIencapsulated PostScript\fR format), first
select LaTeX format in the panel window (click the left mouse
button on the laser printer icon), then type ^P to generate
the encapsulated PostScript file.
If the file name is ``an-sr-flip-flop.obj'',
then the LaTeX figure file generated will be named
``an-sr-flip-flop.eps''.  This file can be included in a LaTeX
document as follows,
.PP
.DS I
\\begin{figure*}[htb]
.br
\\input{psfig}
.br
\\centerline{\\psfig{figure=an-sr-flip-flop.eps}}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.DE
.br
.PP
An alternative way is to use the \fIepsf\fR construct as follows,
.PP
.DS I
\\begin{figure*}[htb]
.br
\\input{epsf}
.br
\\centerline{\\epsffile{an-sr-flip-flop.eps}}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.DE
.br
.PP
The \\centerline command above centers the picture.
If you have multiple tgif figures in your LaTeX document,
you only have to include the psfig macro (\\input{psfig} or \\input{epsf})
once right after
\\begin{document}.  Then within each figure environment,
you wouldn't need the \\input{psfig} (or \\input{epsf} line.
.PP
If encapsulated PostScript is not desired, the \fIpsfile\fR
special construct can be used as described here.
First, center the picture
on the page (e.g., the width of a portrait style page is 7.5 inch, so the
center of the page is at the 3.75 inch mark),
and make the top object on the page as close to
the top of the page as possible.
Select LaTeX format in the panel window,
then print in the LaTeX format.
Same as with the \fIpsfig\fR construct, a file with the \fI.eps\fR
extention will be generated.
This file can be included in a LaTeX document as follows,
.PP
.DS I
\\begin{figure*}[htb]
.br
\\special{psfile="an-sr-flip-flop.eps" hoffset=-40}
.br
\\rule{0in}{1.1in}
.br
\\caption{An SR flip-flop.  \\label{fig:an-sr-flip-flop}}
.br
\\end{figure*}
.br
.DE
.br
.PP
The \\rule{0in}{1.1in} above specifies an invisible box of 1.1 inches
high, which is the total height of the picture in an-sr-flip-flop.
.SH X DEFAULTS
.TP
.I Tgif*Geometry: WIDTHxHEIGHT+X+Y
.TP
.I Tgif*IconGeometry: +X+Y
.TP
.I Tgif*Foreground: COLORSTRING
.TP
.I Tgif*Background: COLORSTRING
.TP
.I Tgif*BorderColor: COLORSTRING
.TP
.I Tgif*ReverseVideo: [on,off]
For black and white terminal, reverse video ``on'' means the background
is black.  For color terminal, reverse video ``on'' means the background
is specified by the Tgif*Foreground color.
.TP
.I Tgif*InitialFont: [Times,Courier,Helvetica,NewCentury,Symbol]
This specified the initial font.
The default is Courier.
.TP
.I Tgif*InitialFontStyle: [Roman,Bold,Italic,BoldItalic]
This specified the initial font style.
The default is Roman.
.TP
.I Tgif*InitialFontJust: [Left,Center,Right]
This specified the initial font justification.
The default is Left.
.TP
.I Tgif*InitialFontDPI: [75,100]
This specified the initial font DPI (dots-per-inch).
The default is 75.
.TP
.I Tgif*InitialFontSizeIndex: [0,1,2,3,4,5]
This specified the initial size \fIindex\fR of the start-up font.
For the 75dpi font, the indices correspond to point sizes
8, 10, 12, 14, 18, and 24.
For the 100dpi font, the indices correspond to point sizes
11, 14, 17, 20, 25, 34.
The default is 4 (18 points) for the 75dpi font and 2 (17 points)
for the 100dpi font.
.TP
.I Tgif*MaxColors: NUMBER
This specified the maximum number of colors.  Color0 through ColorMax,
where Max is NUMBER-1, and they all must exist in .Xdefaults.
.TP
.I Tgif*Color#: COLORSTRING
This specified the correspondance between the color number and a color.
.TP
.I Tgif*DefaultColorIndex: NUMBER
This specified the default color index if certain color can not be found.
Default is 0.
.TP
.I Tgif*PrintCommand: COMMAND
This specified the print command used for printing the PostScript file.
Default is \fIlpr\fR (without any quotes).  An example would be
\fIlpr -h -Pprintername\fR.
.TP
.I Tgif*Synchronize: [on,off]
XSynchronize is called if this default is set to \fIon\fR.  Default is
\fIoff\fR.
.TP
.I Tgif*DoubleClickInterval: NUMBER
This specifies the maximum interval (in milli-seconds)
between two clicked to be recognized as one double-click.
Default is 300.
.TP
.I Tgif*MaxDomains: NUMBER
This specified the maximum number of domains.  Domain0 through DomainMax,
where Max is NUMBER-1, and they all must exist in .Xdefaults.
.TP
.I Tgif*Domain#: DOMAINSTRING
This specified the correspondance between the domain number and a domain name.
See the ENVIRONMENT VARIABLE section to see how to specify a path associated
with a domain.
.TP
.I Tgif*DefaultDomain: NUMBER
This specified the default domain when tgif starts up.
Default is 0 if not specified.
.SH ENVIRONMENT VARIABLE
.TP
.I TGIFPATH
This environment variable should be set such that the files, mentioned in the
\fBFILES\fR section below, can be found.
.TP
.I TGIFICON
This environment variable should be set to the name of the object
file to be displayed when tgif is iconified.  By default, it is
set to ``tgificon''.
If it starts with a / character, absolute path is used; otherwise,
the icon file is assumed to be $TGIFPATH/$TGIFICON.
.TP
.I TGIF_[Domain]
For each \fIDomain\fR name defined in the X defaults, \fITGIF_Domain\fR
specifies a search path for the symbol files.  Each search path
should have the same format as the \fIPATH\fR csh environment variable.
For example, to specify the symbol path for domain \fIDEFAULT\fR
to look for symbol files in the library directory /tmp/tgif/symbols
then in the current directory,
the following command should be executed in csh.
.PP
.DS
.RS
.RS
setenv TGIF_DEFAULT /tmp/tgif/symbols:.
.br
.RE
.RE
.DE
.br
.SH FILES
$TGIFPATH/tgificon.obj contains the default tgif icon.
.br
.PP
$TGIFPATH/.psmac contains tgif PostScript macros.
.br
.SH SEE ALSO
\fBlatex\fR(1L), \fBlpr\fR(1), \fBenv\fR(1), \fBX\fR(1),
\fBdvips\fR(1), \fBcsh\fR(1)
.SH IDIOSYNCHRASIES
When any of the ``escape to driver'' commands are (accidentally)
executed, the current content of the drawing is saved into
``tmpmodel.obj'' if the drawing indicates that it is an .obj file.
Then tgif escapes to the driver and returns right away.
If the drawing indicates that it is a .sym file, then the content
is saved into ``tmpmodel.sym'' but tgif does not return to the driver.
.PP
The paste operation works on a cut buffer generated by tgif or by non-tgif
tools (such as \fIxterm\fR).
If the cut buffer is \fInot\fR generated by tgif, its content is treated as
ASCII character strings, which is inserted into the current drawing
as a text object (current settings for text objects are used
to create the text object).
If the cut buffer \fIis\fR generated by tgif, then all the current
settings are ignored.
.SH BUGS
There seems to be a problem printing certain objects with the
Apple LaserWriter.  Specifically, ovals and Courier fonts
with non-solid pens would not work in color PostScript printing.
However, they work fine with ghostscript and dxpsview.
the Apple LaserWriter.
.SH COPYRIGHT
Please see the ``Copyright'' file for details on the copyrights.
.SH AUTHOR
William Chia-Wei Cheng (william@cs.ucla.edu)
