%
% 1) Call tgif_clean/0 each time before step (2).
% 2) Consult a '.obj' or a '.sym' file.
% 3) Call tgif_state/2.  This must be called before any other tgif goals
%    are called.
% 4) Trace any other goals.
%
% @(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/tgif.pl,v 2.0 91/03/05 12:50:36 william Exp $
%

tgif_state(FileVersion,Obj) :-
	(	var(Obj) -> OutputObj = true,
		current_predicate(state,
			state(_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_))
	;	OutputObj = false
	),
	Obj = state(_PageStyle,FileVersion,_OrigX,_OrigY,_Zoom,
		_GridSize,_Grid,_Color,_HoriAlign,_VertAlign,_LineWidth,
		_LineStyle,_ObjFill,_PenPat,_TextJust,_Font,
		_TextStyle,_TextSize),
	( OutputObj == true -> call(Obj) ; true ),
	FileVersion =< 3,
	!, abolish(tgif_file_version/1),
	!, assert(tgif_file_version(FileVersion)).
tgif_state(FileVersion,Obj) :-
	(	var(Obj) -> OutputObj = true,
		current_predicate(state,
			state(_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_))
	;	OutputObj = false
	),
	Obj = state(_PageStyle,FileVersion,_OrigX,_OrigY,_Zoom,
		_GridSize,_Grid,_Color,_HoriAlign,_VertAlign,_LineWidth,
		_Spline,_LineStyle,_ObjFill,_PenPat,_TextJust,_Font,
		_TextStyle,_TextSize),
	( OutputObj == true -> call(Obj) ; true ),
	FileVersion =< 7,
	!, abolish(tgif_file_version/1),
	!, assert(tgif_file_version(FileVersion)).
tgif_state(FileVersion,Obj) :-
	(	var(Obj) -> OutputObj = true,
		current_predicate(state,
			state(_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_))
	;	OutputObj = false
	),
	Obj = state(_PageStyle,FileVersion,_OrigX,_OrigY,_Zoom,
		_GridSize,_Grid,_Color,_HoriAlign,_VertAlign,_LineWidth,
		_Spline,_LineStyle,_ObjFill,_PenPat,_TextJust,_Font,
		_TextStyle,_TextSize,_TextDPI),
	( OutputObj == true -> call(Obj) ; true ),
	FileVersion =< 8,
	!, abolish(tgif_file_version/1),
	!, assert(tgif_file_version(FileVersion)).
tgif_state(FileVersion,Obj) :-
	(	var(Obj) -> OutputObj = true,
		current_predicate(state,
			state(_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_))
	;	OutputObj = false
	),
	Obj = state(_PageStyle,FileVersion,_OrigX,_OrigY,_Zoom,
		_GridSize,_Grid,_Color,_HoriAlign,_VertAlign,_LineWidth,
		_Spline,_LineStyle,_ObjFill,_PenPat,_TextJust,_Font,
		_TextStyle,_TextSize,_TextDPI,_Dash),
	( OutputObj == true -> call(Obj) ; true ),
	FileVersion >= 9,
	!, abolish(tgif_file_version/1),
	!, assert(tgif_file_version(FileVersion)).

% --------------------------------------------------------------------- %

tgif_text(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 2, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = text(_Color,_X,_Y,_Font,_TextStyle,_TextSize,_NumLines,_TextJust,
		StrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_strs(StrList).
tgif_text(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 6, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = text(_Color,_X,_Y,_Font,_TextStyle,_TextSize,_NumLines,_TextJust,
		_TextRotate,_PenPat,StrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_strs(StrList).
tgif_text(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 7, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = text(_Color,_X,_Y,_Font,_TextStyle,_TextSize,_NumLines,_TextJust,
		_TextRotate,_PenPat,_BBoxW,_BBoxH,StrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_strs(StrList).
tgif_text(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 9, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = text(_Color,_X,_Y,_Font,_TextStyle,_TextSize,_NumLines,_TextJust,
		_TextRotate,_PenPat,_BBoxW,_BBoxH,_Id,_TextDPI,StrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_strs(StrList).
tgif_text(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion >= 10, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = text(_Color,_X,_Y,_Font,_TextStyle,_TextSize,_NumLines,_TextJust,
		_TextRotate,_PenPat,_BBoxW,_BBoxH,_Id,_TextDPI,_Asc,_Des,
		StrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_strs(StrList).

% --------------------------------------------------------------------- %

tgif_box(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 7, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = box(_Color,_X1,_Y1,_X2,_Y2,_ObjFill,_LineWidth,_PenPat),
	( OutputObj == true -> call(Obj) ; true ).
tgif_box(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 8, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = box(_Color,_X1,_Y1,_X2,_Y2,_ObjFill,_LineWidth,_PenPat,_Id,
		AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).
tgif_box(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion >= 9, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = box(_Color,_X1,_Y1,_X2,_Y2,_ObjFill,_LineWidth,_PenPat,_Id,_Dash,
		AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_oval(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 7, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = oval(_Color,_LeftTopX,_LeftTopY,_RightBotX,_RightBotY,_ObjFill,
		_LineWidth,_PenPat),
	( OutputObj == true -> call(Obj) ; true ).
tgif_oval(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 8, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = oval(_Color,_LeftTopX,_LeftTopY,_RightBotX,_RightBotY,_ObjFill,
		_LineWidth,_PenPat,_Id,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).
tgif_oval(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion >= 9, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = oval(_Color,_LeftTopX,_LeftTopY,_RightBotX,_RightBotY,_ObjFill,
		_LineWidth,_PenPat,_Id,_Dash,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_poly(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 3, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = poly(_Color,_NumVs,_Vs,_LineStyle,_LineWidth,_PenPat,_Id,
		AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).
tgif_poly(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 4, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = poly(_Color,_NumVs,_Vs,_LineStyle,_LineWidth,_PenPat,_Id,_Spline,
		AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).
tgif_poly(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 8, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = poly(_Color,_NumVs,_Vs,_LineStyle,_LineWidth,_PenPat,_Id,_Spline,
		_ObjFill,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).
tgif_poly(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion >= 9, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = poly(_Color,_NumVs,_Vs,_LineStyle,_LineWidth,_PenPat,_Id,_Spline,
		_ObjFill,_Dash,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_polygon(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 3, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = polygon(_Color,_NumVs,_Vs,_ObjFill,_LineWidth,_PenPat),
	( OutputObj == true -> call(Obj) ; true ).
tgif_polygon(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 7, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = polygon(_Color,_NumVs,_Vs,_ObjFill,_LineWidth,_PenPat,_Spline),
	( OutputObj == true -> call(Obj) ; true ).
tgif_polygon(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion =< 8, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = polygon(_Color,_NumVs,_Vs,_ObjFill,_LineWidth,_PenPat,_Spline,
		_Id,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).
tgif_polygon(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion >= 9, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = polygon(_Color,_NumVs,_Vs,_ObjFill,_LineWidth,_PenPat,_Spline,
		_Id,_Dash,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_rcbox(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion >= 9, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = rcbox(_Color,_X1,_Y1,_X2,_Y2,_ObjFill,_LineWidth,_PenPat,_Dash,
		_Radius,_Id,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_arc(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion >= 9, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = arc(_Color,_ObjFill,_LineWidth,_PenPat,_Dash,_LtX,_LtY,_Xc,_Yc,
		_X1,_Y1,_X2,_Y2,_Dir,_W,_H,_Angle1,_Angle2,_Id,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_xbm(Obj) :-
	current_predicate(tgif_file_version,tgif_file_version(_)),
	tgif_file_version(FileVersion),
	FileVersion >= 9, !,
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = xbm(_Color,_X1,_Y1,_X2,_Y2,_ObjFill,_Id,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_group(Obj) :-
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = group(ObjList,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_objs(ObjList),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_sym(Obj) :-
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = sym(ObjList,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_objs(ObjList),
	tgif_attrs(AttrList).

% --------------------------------------------------------------------- %

tgif_icon(Obj) :-
	( var(Obj) -> OutputObj = true ; OutputObj = false ),
	Obj = icon(ObjList,_Name,_Id,AttrList),
	( OutputObj == true -> call(Obj) ; true ),
	tgif_objs(ObjList),
	tgif_attrs(AttrList).

% ======================== support routines =========================== %

tgif_clean :- abolish(state/18), abolish(state/19), abolish(state/20).

% --------------------------------------------------------------------- %

tgif_strs([]) :- !.
tgif_strs([_Str|Strs]) :- !, tgif_strs(Strs).

% --------------------------------------------------------------------- %

tgif_objs([]) :- !.
tgif_objs([Obj|Objs]) :-
	!,
	functor(Obj,Functor,_Arity),
	(	Functor == text ->
		tgif_text(Obj)
	;	Functor == box ->
		tgif_box(Obj)
	;	Functor == oval ->
		tgif_oval(Obj)
	;	Functor == poly ->
		tgif_poly(Obj)
	;	Functor == polygon ->
		tgif_polygon(Obj)
	;	Functor == rcbox ->
		tgif_rcbox(Obj)
	;	Functor == arc ->
		tgif_arc(Obj)
	;	Functor == xbm ->
		tgif_xbm(Obj)
	;	Functor == group ->
		tgif_group(Obj)
	;	Functor == sym ->
		tgif_sym(Obj)
	;	Functor == icon ->
		tgif_icon(Obj)
	;	true
	),
	!, tgif_objs(Objs).

% --------------------------------------------------------------------- %

tgif_attrs([]) :- !.
tgif_attrs([Attr|Attrs]) :-
	Attr = attr(_Name,_Value,_ShowAll,_ShowNameOnly,_Inherited,TextObj),
	tgif_text(TextObj),
	!, tgif_attrs(Attrs).
