/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/tgif2ps.c,v 2.0 91/03/05 12:48:49 william Exp $";
#endif

#include <stdio.h>

void Init ()
{
   char	inbuf[256];

   if (fgets (inbuf, 255, stdin) == NULL)
   {
      fprintf (stderr, "ERROR:  Bad first line in input file.\n");
      exit (-1);
   }
   if (strcmp (inbuf, "%!\n") != 0)
   {
      fprintf (stderr, "ERROR:  Bad first line in input file.\n");
      exit (-1);
   }
   printf ("%%!\n");
}

main ()
{
   char	inbuf[256];

   Init ();
   while (fgets (inbuf, 255, stdin) != NULL)
   {
      if (strcmp (inbuf, "90 rotate\n") == 0)
         continue;
      else if (strcmp (inbuf, "72 0.55 mul 72 10.4 mul translate\n") == 0)
      {  /* portrait format */
	 if (fgets (inbuf, 255, stdin) == NULL)
         {
            fprintf (stderr, "ERROR:  Incomplete file.\n");
            exit (-1);
         }
         if (strcmp (inbuf, "0.565 -0.565 scale\n") != 0)
         {
            fprintf (stderr, "ERROR:  '0.565 -0.565 scale' not found.\n");
            exit (-1);
         }
         printf ("0.565 -0.565 scale\n");
      }
      else if (strcmp (inbuf, "72 0.28 mul 72 10.7 mul translate\n") == 0)
      {  /* hi-portrait format */
	 if (fgets (inbuf, 255, stdin) == NULL)
         {
            fprintf (stderr, "ERROR:  Incomplete file.\n");
            exit (-1);
         }
         if (strcmp (inbuf, "0.28 -0.28 scale\n") != 0)
         {
            fprintf (stderr, "ERROR:  '0.28 -0.28 scale' not found.\n");
            exit (-1);
         }
         printf ("0.28 -0.28 scale\n");
      }
      else if (strcmp (inbuf, "72 0.565 mul 72 10.4 mul translate\n") == 0)
      {  /* slide-portrait format */
	 if (fgets (inbuf, 255, stdin) == NULL)
         {
            fprintf (stderr, "ERROR:  Incomplete file.\n");
            exit (-1);
         }
         if (strcmp (inbuf, "1.13 -1.13 scale\n") != 0)
         {
            fprintf (stderr, "ERROR:  '1.13 -1.13 scale' not found.\n");
            exit (-1);
         }
         printf ("1.13 -1.13 scale\n");
      }
      else if (strcmp (inbuf, "72 0.4 mul 72 -0.6 mul translate\n") == 0)
      {  /* landscape or slide-landscape format */
/*       printf ("72 3.5 mul 72 -0.6 mul translate\n"); */
	 if (fgets (inbuf, 255, stdin) == NULL)
         {
            fprintf (stderr, "ERROR:  Incomplete file.\n");
            exit (-1);
         }
         if (strcmp (inbuf, "0.565 -0.565 scale\n") != 0)
         {
            if (strcmp (inbuf, "1.13 -1.13 scale\n") != 0)
            {
               fprintf (stderr, "ERROR:  neither '0.565 -0.565 scale' nor ");
               fprintf (stderr, "'1.13 -1.13 scale' is found.\n");
               exit (-1);
            }
            printf ("1.13 -1.13 scale\n");
         }
         else
            printf ("0.565 -0.565 scale\n");
      }
      else if (strcmp (inbuf, "72 0.2 mul 72 -0.3 mul translate\n") == 0)
      {  /* hi-landscape format */
/*       printf ("72 1.75 mul 72 -0.3 mul translate\n"); */
	 if (fgets (inbuf, 255, stdin) == NULL)
         {
            fprintf (stderr, "ERROR:  Incomplete file.\n");
            exit (-1);
         }
         if (strcmp (inbuf, "0.28 -0.28 scale\n") != 0)
         {
            fprintf (stderr, "ERROR:  '0.28 -0.28 scale' not found.\n");
            exit (-1);
         }
         printf ("0.28 -0.28 scale\n");
      }
      else if (strcmp (inbuf, "showpage\n") == 0)
      {
         exit (0);
      }
      else
         printf ("%s", inbuf);
   }
   fprintf (stderr, "ERROR:  Incomplete file.\n");
   exit (-1);
}
