/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, William Cheng.
 *
 * @(#)$Header: /tmp_mnt/n/kona/tangram/u/william/X11/TGIF2/RCS/types.h,v 2.0 91/03/05 12:50:02 william Exp $
 */

#include "const.h"

typedef struct BBRec {
   int	ltx, lty, rbx, rby;
} * BBRecPtr;

typedef struct PtRec {
   int		x, y;
   struct PtRec	* next;
} * PtRecPtr;

typedef struct ObjRec {
   int			x, y, type, color, id, dirty;
   struct BBRec		obbox;	/* object bounding box */
   struct BBRec		bbox;	/* real bounding box */
   struct ObjRec	* next, * prev;
   struct AttrRec	* fattr, * lattr; /* first and last attributes */
   union {
      struct GroupRec	* r;
      struct PolyRec	* p;
      struct PolygonRec	* g;
      struct BoxRec	* b;
      struct OvalRec	* o;
      struct TextRec	* t;
      struct ArcRec	* a;
      struct RCBoxRec	* rcb;
      struct XBmRec	* xbm;
   } detail;
} * ObjRecPtr;

typedef struct AttrRec {
   char			name[MAXSTRING+1]; /* attribute name */
   char			s[MAXSTRING+1]; /* attribute value string */
   short		bit7on[MAXSTRING+1];
   short		shown; /* TRUE if the attribute is shown */
   short		nameshown; /* TRUE if the attr name is also shown */
   short		inherited; /* TRUE if attr was inherited */
   struct ObjRec	* obj; /* the OBJ_TEXT object that represent the attr */
   struct ObjRec        * owner; /* ptr to owner obj of the record */
   struct AttrRec	* next, * prev; /* next and prev attributes */
} * AttrRecPtr;

typedef struct GroupRec {
   struct ObjRec	* first, * last;
   char			s[MAXSTRING+1];
} * GroupRecPtr;

typedef struct PolyRec {
   int			n;	/* number of points in the polyline */
   XPoint		* vlist;
   int			sn;	/* number of points in the spline polyline */
   XPoint		* svlist;
   int			style, width, pen, curved, fill, dash;
} * PolyRecPtr;

typedef struct PolygonRec {
   int		n;	/* number of points in the polygon */
   XPoint	* vlist;
   int		sn;	/* number of points in the spline polygon */
   XPoint	* svlist;
   int		fill, width, pen, curved, dash;
} * PolygonRecPtr;

typedef struct BoxRec {
   int	fill, width, pen, dash;
} * BoxRecPtr;

typedef struct OvalRec {
   int	fill, width, pen, dash;
} * OvalRecPtr;

typedef struct StrRec {
   char			s[MAXSTRING+1];
   short		bit7on[MAXSTRING+1];
   struct StrRec	* next, * prev;
} * StrRecPtr;

typedef struct TextRec {
   int			just;
   int			lines;
   int			font, style, size, dpi, rotate, pen;
   int			asc, des;
   struct AttrRec       * attr; /* ptr to attr record if text obj is an attr */
   struct StrRec	* first, * last;
} * TextRecPtr;

typedef struct SelRec {
   struct ObjRec	* obj;
   struct SelRec	* next, * prev;
} * SelRecPtr;

typedef struct StkRec {
   struct ObjRec	* first, * last, * sel;
   struct StkRec	* next;
   int			name_valid, file_mod, id, page_style;
   int			orig_x, orig_y, zoom, grid, grid_on;
   int			color, h_align, v_align, line_w, line_s;
   int			fill, pen, dash, just, font, f_style, f_size, f_dpi;
   char			name[MAXPATHLENGTH+1], domain[MAXPATHLENGTH+1];
   char			dir[MAXPATHLENGTH+1], sym_dir[MAXPATHLENGTH+1];
} * StkRecPtr;

typedef struct ArcRec {
   int	fill, width, pen, dash;
   int	xc, yc, x1, y1, x2, y2, dir;
   int	ltx, lty, w, h, angle1, angle2;
} * ArcRecPtr;

typedef struct RCBoxRec {
   int	fill, width, pen, dash, radius;
} * RCBoxRecPtr;

typedef struct XBmRec {
   int		fill;
   char		* data;
   Pixmap	bitmap;
} * XBmRecPtr;

#ifdef UC
struct MoveUndoRec {
    int	dx, dy;
};

struct BoxUndoRec {
    struct BBRec	bbox;
    double		multX, multY;
    int			corner;
};

struct PolyUndoRec {
    struct ObjRec	* objPtr; 
    int			dx, dy;
    int			index;
};

struct PolygonUndoRec {
    struct ObjRec	* objPtr; 
    int			dx, dy;
    int			index;
};

struct {
    int		operation;
    int		object;
    union {
	struct MoveUndoRec	m;
	struct BoxUndoRec 	b;
	struct PolyUndoRec 	p;
	struct PolygonUndoRec 	g;
    } info;
} undo;

#define NOP	0
#define MOVE	1
#define STRETCH	2
#define DELETE	3
#endif /* UC */
#ifdef UC
struct MainMenuWinRec
{
    Window 	window;
    int 	x, y;
    int 	w, h;    
};
#endif /* UC */
#ifdef KANJI
struct Use16as18Rec
{
    int mincho;
    int gothic;
};
#endif /* KANJI */


