/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/cursor.c,v 2.19 1993/02/16 21:54:55 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include "const.h"
#include "types.h"

#include "choice.e"
#include "color.e"
#include "setup.e"
#include "xbitmap.e"

#include "xbm/null.xbm"
#include "xbm/nullmask.xbm"
#include "xbm/text_cur.xbm"

Cursor	nullCursor;
Cursor	cornerCursor;
Cursor	handCursor;
Cursor	defaultCursor;
Cursor	watchCursor;
Cursor	drawCursor;
Cursor	vertexCursor;
Cursor	textCursor;

int	watchCursorOnMainWindow = FALSE;

static GC	textCursorGC;
static Pixmap	textPixmap;
static Pixmap	nullPixmap;
static Pixmap	nullMaskPixmap;

static XImage	* textCursorImage;

static char	* cursorName[] =
{
   "X_cursor",
   "arrow",
   "based_arrow_down",
   "based_arrow_up",
   "boat",
   "bogosity",
   "bottom_left_corner",
   "bottom_right_corner",
   "bottom_side",
   "bottom_tee",
   "box_spiral",
   "center_ptr",
   "circle",
   "clock",
   "coffee_mug",
   "cross",
   "cross_reverse",
   "crosshair",
   "diamond_cross",
   "dot",
   "dotbox",
   "double_arrow",
   "draft_large",
   "draft_small",
   "draped_box",
   "exchange",
   "fleur",
   "gobbler",
   "gumby",
   "hand1",
   "hand2",
   "heart",
   "icon",
   "iron_cross",
   "left_ptr",
   "left_side",
   "left_tee",
   "leftbutton",
   "ll_angle",
   "lr_angle",
   "man",
   "middlebutton",
   "mouse",
   "pencil",
   "pirate",
   "plus",
   "question_arrow",
   "right_ptr",
   "right_side",
   "right_tee",
   "rightbutton",
   "rtl_logo",
   "sailboat",
   "sb_down_arrow",
   "sb_h_double_arrow",
   "sb_left_arrow",
   "sb_right_arrow",
   "sb_up_arrow",
   "sb_v_double_arrow",
   "shuttle",
   "sizing",
   "spider",
   "spraycan",
   "star",
   "target",
   "tcross",
   "top_left_arrow",
   "top_left_corner",
   "top_right_corner",
   "top_side",
   "top_tee",
   "trek",
   "ul_angle",
   "umbrella",
   "ur_angle",
   "watch",
   "xterm",
   ""
};

static unsigned int	cursorID[] =
{
   XC_X_cursor,
   XC_arrow,
   XC_based_arrow_down,
   XC_based_arrow_up,
   XC_boat,
   XC_bogosity,
   XC_bottom_left_corner,
   XC_bottom_right_corner,
   XC_bottom_side,
   XC_bottom_tee,
   XC_box_spiral,
   XC_center_ptr,
   XC_circle,
   XC_clock,
   XC_coffee_mug,
   XC_cross,
   XC_cross_reverse,
   XC_crosshair,
   XC_diamond_cross,
   XC_dot,
   XC_dotbox,
   XC_double_arrow,
   XC_draft_large,
   XC_draft_small,
   XC_draped_box,
   XC_exchange,
   XC_fleur,
   XC_gobbler,
   XC_gumby,
   XC_hand1,
   XC_hand2,
   XC_heart,
   XC_icon,
   XC_iron_cross,
   XC_left_ptr,
   XC_left_side,
   XC_left_tee,
   XC_leftbutton,
   XC_ll_angle,
   XC_lr_angle,
   XC_man,
   XC_middlebutton,
   XC_mouse,
   XC_pencil,
   XC_pirate,
   XC_plus,
   XC_question_arrow,
   XC_right_ptr,
   XC_right_side,
   XC_right_tee,
   XC_rightbutton,
   XC_rtl_logo,
   XC_sailboat,
   XC_sb_down_arrow,
   XC_sb_h_double_arrow,
   XC_sb_left_arrow,
   XC_sb_right_arrow,
   XC_sb_up_arrow,
   XC_sb_v_double_arrow,
   XC_shuttle,
   XC_sizing,
   XC_spider,
   XC_spraycan,
   XC_star,
   XC_target,
   XC_tcross,
   XC_top_left_arrow,
   XC_top_left_corner,
   XC_top_right_corner,
   XC_top_side,
   XC_top_tee,
   XC_trek,
   XC_ul_angle,
   XC_umbrella,
   XC_ur_angle,
   XC_watch,
   XC_xterm
};

void SetTextCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, textCursor);
}

void SetNullCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, nullCursor);
}

void SetWatchCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, watchCursor);
   if (window == mainWindow) watchCursorOnMainWindow = TRUE;
   XSync (mainDisplay, False);
}

void SetDrawCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, drawCursor);
}

void SetVertexCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, vertexCursor);
}

void SetDefaultCursor (window)
   Window	window;
{
   XDefineCursor (mainDisplay, window, defaultCursor);
   if (window == mainWindow && watchCursorOnMainWindow)
      watchCursorOnMainWindow = FALSE;
}

void ShowCursor ()
{
   if (curChoice == DRAWTEXT)
      SetTextCursor (drawWindow);
   else if (curChoice == NOTHING)
      SetDefaultCursor (drawWindow);
   else if (curChoice == VERTEXMODE)
      SetVertexCursor (drawWindow);
   else
      SetDrawCursor (drawWindow);
}

void CreateCursor ()
{
   register int	i, j;
   XGCValues	values;
   XColor	color, fg_color, bg_color;
   char		* c_ptr;
   int		default_cursor_id = XC_arrow;
   int		draw_cursor_id, drag_cursor_id, vertex_cursor_id;
   XImage	* image;

   textPixmap = XCreateBitmapFromData (mainDisplay, mainWindow,
         text_cur_bits, text_cur_width, text_cur_height);

   values.foreground = myFgPixel;
   values.background = myBgPixel;
   values.fill_style = FillOpaqueStippled;
   values.stipple = textPixmap;
   textCursorGC = XCreateGC (mainDisplay, mainWindow,
         GCForeground | GCBackground | GCFillStyle | GCStipple, &values);

   textCursorImage = XCreateImage (mainDisplay, mainVisual, 1, XYBitmap, 0,
         text_cur_bits, text_cur_width, text_cur_height, 8, 2);
   textCursorImage->byte_order = LSBFirst;
   textCursorImage->bitmap_bit_order = LSBFirst;
   textCursorImage->data = text_cur_bits;

   XParseColor(mainDisplay, mainColormap, myFgColorStr, &fg_color);
   XAllocColor(mainDisplay, mainColormap, &fg_color);
   XParseColor(mainDisplay, mainColormap, myBgColorStr, &bg_color);
   XAllocColor(mainDisplay, mainColormap, &bg_color);

   textCursor = XCreateFontCursor (mainDisplay, XC_xterm);
   cornerCursor = XCreateFontCursor (mainDisplay, XC_ul_angle);
   watchCursor = XCreateFontCursor (mainDisplay, XC_watch);

   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DefaultCursor")) != NULL)
   {
      for (i = 0; *cursorName[i] != '\0'; i++)
         if (strcmp (c_ptr, cursorName[i]) == 0)
         {
            default_cursor_id = cursorID[i];
            break;
         }
      if (*cursorName[i] == '\0')
         fprintf (stderr, "Can not find DefaultCursor %s, %s used instead.\n",
               c_ptr, cursorName[default_cursor_id>>1]);
   }
   defaultCursor = XCreateFontCursor (mainDisplay, default_cursor_id);

   draw_cursor_id = default_cursor_id;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DrawCursor")) != NULL)
   {
      for (i = 0; *cursorName[i] != '\0'; i++)
         if (strcmp (c_ptr, cursorName[i]) == 0)
         {
            draw_cursor_id = cursorID[i];
            break;
         }
      if (*cursorName[i] == '\0')
         fprintf (stderr, "Can not find DrawCursor %s, %s used instead.\n",
               c_ptr, cursorName[draw_cursor_id>>1]);
   }
   drawCursor = XCreateFontCursor (mainDisplay, draw_cursor_id);

   drag_cursor_id = XC_hand2;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "DragCursor")) != NULL)
   {
      for (i = 0; *cursorName[i] != '\0'; i++)
         if (strcmp (c_ptr, cursorName[i]) == 0)
         {
            drag_cursor_id = cursorID[i];
            break;
         }
      if (*cursorName[i] == '\0')
         fprintf (stderr, "Can not find DragCursor %s, %s used instead.\n",
               c_ptr, cursorName[drag_cursor_id>>1]);
   }
   handCursor = XCreateFontCursor (mainDisplay, drag_cursor_id);

   vertex_cursor_id = XC_plus;
   if ((c_ptr = XGetDefault (mainDisplay, TOOL_NAME, "VertexCursor")) != NULL)
   {
      for (i = 0; *cursorName[i] != '\0'; i++)
         if (strcmp (c_ptr, cursorName[i]) == 0)
         {
            vertex_cursor_id = cursorID[i];
            break;
         }
      if (*cursorName[i] == '\0')
         fprintf (stderr, "Can not find VertexCursor %s, %s used instead.\n",
               c_ptr, cursorName[vertex_cursor_id>>1]);
   }
   vertexCursor = XCreateFontCursor (mainDisplay, vertex_cursor_id);

   XRecolorCursor (mainDisplay, textCursor, &fg_color, &bg_color);
   XRecolorCursor (mainDisplay, cornerCursor, &fg_color, &bg_color);
   XRecolorCursor (mainDisplay, handCursor, &fg_color, &bg_color);
   XRecolorCursor (mainDisplay, watchCursor, &fg_color, &bg_color);
   XRecolorCursor (mainDisplay, defaultCursor, &fg_color, &bg_color);
   XRecolorCursor (mainDisplay, drawCursor, &fg_color, &bg_color);
   XRecolorCursor (mainDisplay, vertexCursor, &fg_color, &bg_color);

   nullPixmap = XCreatePixmap (mainDisplay, mainWindow, null_width,
         null_height, 1);
   nullMaskPixmap = XCreatePixmap (mainDisplay, mainWindow, nullmask_width,
         nullmask_height, 1);

   image = XGetImage (mainDisplay, nullPixmap, 0, 0, null_width,
         null_height, 1, ZPixmap);
   for (i = 0; i < null_height; i++)
      for (j = 0; j < null_width; j++)
         XPutPixel (image, i, j, 0);
   XPutImage (mainDisplay, nullPixmap, xbmGC, image, 0, 0, 0, 0,
         null_width, null_height);
   XDestroyImage (image);

   image = XGetImage (mainDisplay, nullMaskPixmap, 0, 0, nullmask_width,
         nullmask_height, 1, ZPixmap);
   for (i = 0; i < nullmask_height; i++)
      for (j = 0; j < nullmask_width; j++)
         XPutPixel (image, i, j, 0);
   XPutImage (mainDisplay, nullMaskPixmap, xbmGC, image, 0, 0, 0, 0,
         nullmask_width, nullmask_height);
   XDestroyImage (image);

   nullCursor = XCreatePixmapCursor (mainDisplay, nullPixmap, nullMaskPixmap,
         &color, &color, 0, 0);
}

void PutCursor (window, x, y, foreground)
   Window	window;
   int		x, y, foreground;
{
   XSetForeground (mainDisplay, textCursorGC, foreground);
   XPutImage (mainDisplay, window, textCursorGC, textCursorImage, 0, 0, x, y,
         text_cur_width, text_cur_height);
}

void CleanUpCursors ()
{
   XFreePixmap (mainDisplay, textPixmap);
   XFreeGC (mainDisplay, textCursorGC);
/* XDestroyImage (textCursorImage); */

   XFreeCursor (mainDisplay, textCursor);
   XFreeCursor (mainDisplay, cornerCursor);
   XFreeCursor (mainDisplay, handCursor);
   XFreeCursor (mainDisplay, defaultCursor);
   XFreeCursor (mainDisplay, watchCursor);
   XFreeCursor (mainDisplay, drawCursor);
   XFreeCursor (mainDisplay, vertexCursor);

   XFreePixmap (mainDisplay, nullPixmap);
   XFreePixmap (mainDisplay, nullMaskPixmap);
   XFreeCursor (mainDisplay, nullCursor);
}
