/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/ps.c,v 2.3.1.10 1993/04/28 05:18:33 william Exp $";
#endif

#include <stdio.h>

#include "const.h"

static char	* psMacro[] =
{ "%%EndComments",
  "%%BeginProlog",
  "%",
  "%\tDue to bugs in Transcript, the 'PS-Adobe-' stuff is omitted from line 1",
  "%",
  "",
  "/tgifdict 132 dict def",
  "tgifdict begin",
  "",
  "%",
  "%\tUsing a zero value radius for an ellipse or an arc would result",
  "%\t\tin a non-invertible CTM matrix which causes problem when this",
  "%\t\twhen this PostScript is wrapped inside other routines, such as",
  "%\t\tthe multi.ps package from",
  "%\t\tftp.ucc.su.oz.au:/pub/ps_printing/multi.  You can overcome such",
  "%\t\terror by uncommenting the sole line of the procedure below:",
  "%",
  "/tgif_min_radius",
  " {",
  "%    dup 0.01 lt { pop 0.01 } if",
  " } bind def",
  "",
  "/tgifellipsedict 6 dict def",
  "tgifellipsedict /mtrx matrix put",
  "",
  "/tgifellipse",
  " { tgifellipsedict begin",
  "      /yrad exch def",
  "      /xrad exch def",
  "      /y exch def",
  "      /x exch def",
  "      /savematrix mtrx currentmatrix def",
  "      x y translate",
  "      xrad yrad scale",
  "      0 0 1 0 360 arc",
  "      savematrix setmatrix",
  "   end",
  " } def",
  "",
  "/tgifarrowtipdict 8 dict def",
  "tgifarrowtipdict /mtrx matrix put",
  "",
  "/tgifarrowtip",
  " { tgifarrowtipdict begin",
  "      /dy exch def",
  "      /dx exch def",
  "      /h exch def",
  "      /w exch def",
  "      /y exch def",
  "      /x exch def",
  "      /savematrix mtrx currentmatrix def",
  "      x y translate",
  "      dy dx atan rotate",
  "      0 0 moveto",
  "      w neg h lineto",
  "      w neg h neg lineto",
  "      savematrix setmatrix",
  "   end",
  " } def",
  "",
  "/tgifarcdict 8 dict def",
  "tgifarcdict /mtrx matrix put",
  "",
  "/tgifarcn",
  " { tgifarcdict begin",
  "      /endangle exch def",
  "      /startangle exch def",
  "      /yrad exch def",
  "      /xrad exch def",
  "      /y exch def",
  "      /x exch def",
  "      /savematrix mtrx currentmatrix def",
  "      x y translate",
  "      xrad yrad scale",
  "      0 0 1 startangle endangle arc",
  "      savematrix setmatrix",
  "   end",
  " } def",
  "",
  "/tgifarc",
  " { tgifarcdict begin",
  "      /endangle exch def",
  "      /startangle exch def",
  "      /yrad exch def",
  "      /xrad exch def",
  "      /y exch def",
  "      /x exch def",
  "      /savematrix mtrx currentmatrix def",
  "      x y translate",
  "      xrad yrad scale",
  "      0 0 1 startangle endangle arcn",
  "      savematrix setmatrix",
  "   end",
  " } def",
  "",
  "/tgifsetuserscreendict 22 dict def",
  "tgifsetuserscreendict begin",
  "   /tempctm matrix def",
  "   /temprot matrix def",
  "   /tempscale matrix def",
  "",
  "   /concatprocs",
  "    { /proc2 exch cvlit def",
  "      /proc1 exch cvlit def",
  "      /newproc proc1 length proc2 length add array def",
  "      newproc 0 proc1 putinterval",
  "      newproc proc1 length proc2 putinterval",
  "      newproc cvx",
  "    } def",
  "   /resmatrix matrix def",
  "   /findresolution",
  "    { 72 0 resmatrix defaultmatrix dtransform",
  "      /yres exch def /xres exch def",
  "      xres dup mul yres dup mul add sqrt",
  "    } def",
  "end",
  "",
  "/tgifsetuserscreen",
  " { tgifsetuserscreendict begin",
  "      /spotfunction exch def",
  "      /screenangle exch def",
  "      /cellsize exch def",
  "",
  "      /m tempctm currentmatrix def",
  "      /rm screenangle temprot rotate def",
  "      /sm cellsize dup tempscale scale def",
  "",
  "      sm rm m m concatmatrix m concatmatrix pop",
  "",
  "      1 0 m dtransform /y1 exch def /x1 exch def",
  "",
  "      /veclength x1 dup mul y1 dup mul add sqrt def",
  "      /frequency findresolution veclength div def",
  "",
  "      /newscreenangle y1 x1 atan def",
  "",
  "      m 2 get m 1 get mul m 0 get m 3 get mul sub 0 gt",
  "",
  "      {{neg} /spotfunction load concatprocs",
  "         /spotfunction exch def",
  "      } if",
  "",
  "      frequency newscreenangle /spotfunction load setscreen",
  "   end",
  " } def",
  "",
  "/tgifsetpatterndict 18 dict def",
  "tgifsetpatterndict begin",
  "   /bitison",
  "    { /ybit exch def /xbit exch def",
  "      /bytevalue bstring ybit bwidth mul xbit 8 idiv add get def",
  "",
  "      /mask 1 7 xbit 8 mod sub bitshift def",
  "      bytevalue mask and 0 ne",
  "    } def",
  "end",
  "",
  "/tgifbitpatternspotfunction",
  " { tgifsetpatterndict begin",
  "      /y exch def /x exch def",
  "",
  "      /xindex x 1 add 2 div bpside mul cvi def",
  "      /yindex y 1 add 2 div bpside mul cvi def",
  "",
  "      xindex yindex bitison",
  "       { /onbits onbits 1 add def 1 }",
  "       { /offbits offbits 1 add def 0 }",
  "       ifelse",
  "   end",
  " } def",
  "",
  "/tgifsetpattern",
  " { tgifsetpatterndict begin",
  "      /cellsz exch def",
  "      /angle exch def",
  "      /bwidth exch def",
  "      /bpside exch def",
  "      /bstring exch def",
  "",
  "      /onbits 0 def /offbits 0 def",
  "      cellsz angle /tgifbitpatternspotfunction load tgifsetuserscreen",
  "      {} settransfer",
  "      offbits offbits onbits add div setgray",
  "   end",
  " } def",
  "",
  "/tgifxpmdict 4 dict def",
  "/tgifbwpicstr 1 string def",
  "/tgifcolorpicstr 3 string def",
  "",
  "/tgifsetpixels { tgifxpmdict begin /pixels exch def end } def",
  "",
  "/tgifsetpix { tgifxpmdict begin pixels 3 1 roll putinterval end } def",
  "",
  "/tgifbwspot",
  " { tgifxpmdict begin",
  "      /index exch def",
  "      tgifbwpicstr 0",
  "      pixels index 3 mul 3 getinterval aload pop",
  "      255 mul .114 mul exch 255 mul .587 mul add exch 255 mul .299 mul add",
  "      cvi put",
  "      tgifbwpicstr",
  "   end",
  " } def",
  "",
  "/tgifcolorspot",
  " { tgifxpmdict begin",
  "      /index exch def",
  "      pixels index 3 mul 3 getinterval aload pop",
  "      255 mul cvi tgifcolorpicstr 2 3 -1 roll put",
  "      255 mul cvi tgifcolorpicstr 1 3 -1 roll put",
  "      255 mul cvi tgifcolorpicstr 0 3 -1 roll put",
  "      tgifcolorpicstr",
  "   end",
  " } def",
  "",
  "/tgifnewcolorspot",
  " { tgifxpmdict begin",
  "      /index exch def",
  "      pixels index 3 mul 3 getinterval aload pop setrgbcolor",
  "   end",
  " } def",
  "",
  "/tgifcolordict 4 dict def",
  "",
  "/colorimage where",
  " { pop }",
  " { /colorimage",
  "   { tgifcolordict begin",
  "        pop pop pop pop pop",
  "        /ih exch def",
  "        /iw exch def",
  "        /x 0 def",
  "        /y 0 def",
  "        1 1 ih",
  "         { pop 1 1 iw",
  "            { pop currentfile",
  "              tgifbwpicstr readhexstring pop 0 get tgifnewcolorspot",
  "              x y moveto 1 0 rlineto 0 1 rlineto -1 0 rlineto",
  "              closepath fill",
  "              /x x 1 add def",
  "            } for",
  "           /y y 1 add def",
  "           /x 0 def",
  "         } for",
  "     end",
  "   } def",
  " } ifelse",
  "",
  "/tgifpatdict 10 dict def",
  "",
  "/tgifpatbyte",
  " { currentdict /retstr get exch",
  "   pat i cellsz mod get put",
  " } def",
  "",
  "/tgifpatproc",
  " { 0 1 widthlim {tgifpatbyte} for retstr",
  "   /i i 1 add def",
  " } def",
  "",
  "/tgifpatfill",
  " { tgifpatdict begin",
  "      /h exch def",
  "      /w exch def",
  "      /lty exch def",
  "      /ltx exch def",
  "      /cellsz exch def",
  "      /pat exch def",
  "",
  "      /widthlim w cellsz div cvi 1 sub def",
  "      /retstr widthlim 1 add string def",
  "      /i 0 def",
  "",
  "      ltx lty translate",
  "      w h true [1 0 0 1 0 0] {tgifpatproc} imagemask",
  "      ltx neg lty neg translate",
  "   end",
  " } def",
  "",
  "/pat1 <ffffffffffffffff> def",
  "/pat2 <0000000000000000> def",
  "/pat3 <8000000008000000> def",
  "/pat4 <8800000022000000> def",
  "/pat5 <8800220088002200> def",
  "/pat6 <8822882288228822> def",
  "/pat7 <aa55aa55aa55aa55> def",
  "/pat8 <77dd77dd77dd77dd> def",
  "/pat9 <77ffddff77ffddff> def",
  "/pat10 <77ffffff77ffffff> def",
  "/pat11 <7fffffff7fffffff> def",
  "/pat12 <8040200002040800> def",
  "/pat13 <40a00000040a0000> def",
  "/pat14 <ff888888ff888888> def",
  "/pat15 <ff808080ff080808> def",
  "/pat16 <f87422478f172271> def",
  "/pat17 <038448300c020101> def",
  "/pat18 <081c22c180010204> def",
  "/pat19 <8080413e080814e3> def",
  "/pat20 <8040201008040201> def",
  "/pat21 <8844221188442211> def",
  "/pat22 <77bbddee77bbddee> def",
  "/pat23 <c1e070381c0e0783> def",
  "/pat24 <7fbfdfeff7fbfdfe> def",
  "/pat25 <3e1f8fc7e3f1f87c> def",
  "/pat26 <0102040810204080> def",
  "/pat27 <1122448811224488> def",
  "/pat28 <eeddbb77eeddbb77> def",
  "/pat29 <83070e1c3870e0c1> def",
  "/pat30 <fefdfbf7efdfbf7f> def",
  "/pat31 <7cf8f1e3c78f1f3e> def",
  "",
  "/tgifcentertext { dup stringwidth pop 2 div neg 0 rmoveto } def",
  "",
  "/tgifrighttext { dup stringwidth pop neg 0 rmoveto } def",
  "",
  "/tgifreencsmalldict 12 dict def",
  "/tgifReEncodeSmall",
  " { tgifreencsmalldict begin",
  "      /newcodesandnames exch def",
  "      /newfontname exch def",
  "      /basefontname exch def",
  "",
  "      /basefontdict basefontname findfont def",
  "      /newfont basefontdict maxlength dict def",
  "",
  "      basefontdict",
  "      { exch dup /FID ne",
#ifdef GS_REENCODE_BUG
  "        1 index /UniqueID ne and",
#endif
  "         { dup /Encoding eq",
  "            { exch dup length array copy newfont 3 1 roll put }",
  "            { exch newfont 3 1 roll put }",
  "            ifelse",
  "         }",
  "         { pop pop }",
  "         ifelse",
  "      }",
  "      forall",
  "",
  "      newfont /FontName newfontname put",
  "      newcodesandnames aload pop",
  "",
  "      newcodesandnames length 2 idiv",
  "      { newfont /Encoding get 3 1 roll put}",
  "      repeat",
  "",
  "      newfontname newfont definefont pop",
  "   end",
  " } def",
  "",
  "/tgifgray { 8 1 0 72 300 32 div div tgifsetpattern } bind def",
  "",
  "/tgifboxdict 6 dict def",
  "/tgifboxstroke",
  " { tgifboxdict begin",
  "      /pat def /w def /y2 exch def /x2 exch def /y1 exch def /x1 exch def",
  "      1.415 setmiterlimit",
  "      w 1 eq { w setlinewidth } if",
  "      pat pat1 ne pat pat2 ne and { gsave pat tgifgray } if",
  "      newpath x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto closepath",
  "      pat pat2 eq { 1 setgray stroke 0 setgray } { stroke } ifelse",
  "      pat pat1 ne pat pat2 ne and { grestore } if",
  "      w 1 eq { 1 setlinewidth } if",
  "      1 setmiterlimit",
  "   end",
  " } def",
  "/tgifboxfill",
  " { tgifboxdict begin",
  "      /pat def /y2 exch def /x2 exch def /y1 exch def /x1 exch def",
  "      pat pat1 ne pat pat2 ne and { gsave pat tgifgray } if",
  "      newpath x1 y1 moveto x2 y1 lineto x2 y2 lineto x1 y2 lineto closepath",
  "      pat pat2 eq { 1 setgray fill 0 setgray } { fill } ifelse",
  "      pat pat1 ne pat pat2 ne and { grestore } if",
  "   end",
  " } def",
  "",
  "%%Title: eucfont.ps",
  "%%Creator: shikida@cs.titech.ac.jp, ueno@cs.titech.ac.jp",
  "%%CreationDate: 1991-2-27",
  "%%EndComments",
  "",
  "% <font> copyfont <font>",
  "/copyfont {",
  "    dup maxlength 1 add dict begin",
  "    {",
  "	1 index /FID ne 2 index /UniqueID ne and",
  "	{def} {pop pop} ifelse",
  "    } forall",
  "    currentdict",
  "    end",
  "} bind def",
  "",
  "% <newfont> <asciifont> <kanjifont> eucfont",
  "/eucfont {",
  "    12 dict begin",
  "	dup type /nametype eq { findfont } if",
  "	dup /WMode known {",
  "	    dup /WMode get /WMode exch def",
  "	    WMode 1 eq {",
  "		[0.0 1.0 -1.0 0.0 0.0 0.3] makefont",
  "	    } if",
  "	} if",
  "	copyfont dup begin",
  "	    /Encoding Encoding",
  "	    FMapType dup 2 eq {",
  "		pop 128 128",
  "	    } { 5 eq {",
  "		256 256",
  "	    } {",
  "		/compositefont errordict /invalidfont get exec",
  "	    } ifelse",
  "	    } ifelse",
  "	    getinterval def",
  "	end",
  "	/kanjifont exch definefont",
  "	exch",
  "",
  "	dup type /nametype eq { findfont } if",
  "	exch",
  "",
  "	/FDepVector [ 4 2 roll ] def",
  "	/FontType 0 def",
  "	/FMapType 4 def",
  "	/FontMatrix matrix def",
  "	/Encoding [ 0 1 ] def",
  "	/FontBBox {0 0 0 0} def",
  "	dup /FontName exch def",
  "	currentdict",
  "    end",
  "    definefont pop",
  "} def",
  "",
  NULL
};

void DumpPSMacro (FP)
   FILE	* FP;
{
   register int	i;

   for (i = 0; psMacro[i] != NULL; i++) fprintf (FP, "%s\n", psMacro[i]);
}

int ParsePsAdobeString (s, use_ps_adobe_string, adobe_str, epsf_str)
   char	* s, * adobe_str, * epsf_str;
   int	* use_ps_adobe_string;
{
   register char	* c_ptr=s, * c_ptr1;

   if (!(strcmp ("false", c_ptr) == 0 || strcmp ("False", c_ptr) == 0))
   {
      if (*c_ptr >= '0' && *c_ptr <= '9')
      {
         *use_ps_adobe_string = TRUE;
         for (c_ptr1 = c_ptr; *c_ptr1 != '\0'; c_ptr1++)
            if (*c_ptr1 == '/')
            {
               *c_ptr1 = ' ';
               break;
            }
         sscanf (c_ptr, "%s", adobe_str);
         c_ptr = &c_ptr[strlen(adobe_str)];
         switch (*c_ptr)
         {
            case '\0': break;
            case ' ':
               c_ptr++;
               if (*c_ptr >= '0' && *c_ptr <= '9')
                  sscanf (c_ptr, "%s", epsf_str);
               else
                  return (FALSE);
               break;
            default: return (FALSE);
         }
      }
      else
         return (FALSE);
   }
   return (TRUE);
}
