/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1995, William Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell derivative works of
 * "tgif", and the right to distribute "tgif" for a fee) are
 * reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /u/multimedia/william/X11/TGIF2/RCS/button.c,v 2.56 1995/05/15 01:21:12 william Exp $";
#endif

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "auxtext.e"
#include "box.e"
#ifndef _NO_EXTERN
#include "button.e"
#endif
#include "cursor.e"
#include "file.e"
#include "font.e"
#include "mainloop.e"
#include "mainmenu.e"
#include "msg.e"
#include "raster.e"
#include "rect.e"
#include "setup.e"

int ButtonWidth(Str, Len)
   char	* Str;
   int	Len;
{
   return (defaultFontWidth * max(((int) strlen (Str)) + 2, Len));
}

void DisplayButton (Win, Str, Len, BBox, Normal)
   Window	Win;
   char		* Str;
   int		Len;
   struct BBRec	* BBox;
   int		Normal;
   /* Display a button in Win at location ((*BBox).ltx,(*BBox).lty), Str is */
   /*    centered in the button.  The width of the button is the width of */
   /*    Str + 2 character widths or the width of Len number of characters, */
   /*    whichever is bigger.  *BBox will be set with the bounding */
   /*    box of the button. */
{
   int	button_w, button_h, len_of_str, left;

   len_of_str = strlen (Str);
   button_w = defaultFontWidth * max(len_of_str+2,Len);
   left = (button_w - defaultFontWidth * len_of_str) / 2;
   button_h = defaultFontHeight + 4;
   (*BBox).rbx = (*BBox).ltx + button_w - 1;
   (*BBox).rby = (*BBox).lty + button_h - 1;

   if (Normal)
   {
      XSetForeground (mainDisplay, defaultGC, myBgPixel);
      XFillRectangle (mainDisplay, Win, defaultGC, (*BBox).ltx, (*BBox).lty,
            button_w, button_h);
      XSetForeground (mainDisplay, defaultGC, myFgPixel);

      XDrawRectangle (mainDisplay, Win, defaultGC, (*BBox).ltx, (*BBox).lty,
            button_w, button_h);
      XDrawString (mainDisplay, Win, defaultGC, (*BBox).ltx+left,
            (*BBox).lty+defaultFontAsc+2, Str, len_of_str);
   }
   else
      XFillRectangle (mainDisplay, Win, revDefaultGC, (*BBox).ltx, (*BBox).lty,
            button_w, button_h);
}

void DisplayButtonInBBox (Win, Str, Len, BBox, Normal, HighLight, Width)
   Window	Win;
   char		* Str;
   int		Len, HighLight, Width;
   struct BBRec	* BBox;
   int		Normal;
   /* Display a button in Win at location ((*BBox).ltx,(*BBox).lty), Str is */
   /*    centered in the button.  The width of the button is given in BBox. */
   /* Len must be strlen(Str) */
   /* If HighLight is TRUE, Width is used to draw an outline around the box. */
{
   int	button_w, button_h, left, top, text_w;

   button_w = BBox->rbx - BBox->ltx;
   button_h = BBox->rby - BBox->lty;
   text_w = defaultFontWidth * Len;
   left = ((button_w - text_w)>>1);
   top = ((button_h - defaultFontHeight)>>1);

   if (Normal)
   {
      XSetForeground (mainDisplay, defaultGC, myBgPixel);
      XFillRectangle (mainDisplay, Win, defaultGC, BBox->ltx, BBox->lty,
            button_w, button_h);
      XSetForeground (mainDisplay, defaultGC, myFgPixel);

      XDrawRectangle (mainDisplay, Win, defaultGC, BBox->ltx, BBox->lty,
            button_w, button_h);
      XDrawString (mainDisplay, Win, defaultGC, BBox->ltx+left,
            BBox->lty+defaultFontAsc+2, Str, Len);
   }
   else
      XFillRectangle (mainDisplay, Win, revDefaultGC, BBox->ltx, BBox->lty,
            button_w, button_h);
   if (HighLight)
      XDrawRectangle (mainDisplay, Win, defaultGC, BBox->ltx-Width,
            BBox->lty-Width, button_w+(Width<<1), button_h+(Width<<1));
}

static char * confirmStr[] = { "YES", "NO", "CANCEL" };
static XComposeStatus	c_stat;

int YesNoCancel (Str, DefaultReturn)
   char	* Str;
   int	DefaultReturn;
   /* Create a window with Str centered.  This window also has 3 buttons */
   /*    in it, labeled YES, NO, and CANCEL.  The window has an origin at */
   /*    (100,100) relative to the origin of RootWindow. */
{
   int		w, h, str_start, button_start, top;
   int		str_width, button_widths, dsp_w, dsp_h, exposed = FALSE;
   Window	confirm_win;
   struct BBRec	button_bbox[MAX_CONFIRMS];
   XEvent	input, ev;
   XButtonEvent	* button_ev;
   XKeyEvent	* key_ev;
   int		i, confirming = TRUE, choice = CONFIRM_YES;
   int		win_x, win_y;
   char		buf[80];
   KeySym	key_sym;
   XWMHints	wmhints;
   XSizeHints	sizehints;
   XSetWindowAttributes	win_attrs;

   top = defaultFontAsc+2;

   button_widths = ButtonWidth("YES", 8) + ButtonWidth("NO", 8) +
         ButtonWidth("CANCEL", 8) + 2 * defaultFontWidth;
   str_width = defaultFontWidth * strlen (Str);

   if (str_width > button_widths)
   {
      w = str_width + 4 * defaultFontWidth;
      str_start = 2 * defaultFontWidth;
      button_start = (w - button_widths) / 2;
   }
   else
   {
      w = button_widths + 4 * defaultFontWidth;
      str_start = (w - str_width) / 2;
      button_start = 2 * defaultFontWidth;
   }

   h = 5 * defaultFontHeight;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   win_x = (w > dsp_w) ? 0 : (dsp_w - w)/2;
   win_y = (h > dsp_h) ? 0 : (dsp_h - h)/3;

   if ((confirm_win = XCreateSimpleWindow (mainDisplay, rootWindow,
         win_x, win_y, w, h, brdrW, myBorderPixel, myBgPixel)) == 0)
   {
      fprintf (stderr, "Could not create yes-no-okay window!\n");
      if (fileModified) EmergencySave (0);
      exit (-1);
   }

   win_attrs.save_under = True;
   XChangeWindowAttributes (mainDisplay, confirm_win, CWSaveUnder, &win_attrs);

   wmhints.flags = InputHint | StateHint;
   wmhints.input = True;
   wmhints.initial_state = NormalState;
   XSetWMHints (mainDisplay, confirm_win, &wmhints);

   sizehints.flags = PPosition | PSize | USPosition | PMinSize | PMaxSize;
   sizehints.x = win_x;
   sizehints.y = win_y;
   sizehints.width = sizehints.min_width = sizehints.max_width = w;
   sizehints.height = sizehints.min_height = sizehints.max_height = h;
#ifdef NOTR4MODE
   XSetNormalHints (mainDisplay, confirm_win, &sizehints);
#else
   XSetWMNormalHints (mainDisplay, confirm_win, &sizehints);
#endif
   sprintf (buf, "%s - Confirmation", TOOL_NAME);
   XStoreName (mainDisplay, confirm_win, buf);

   XSetTransientForHint (mainDisplay, confirm_win, mainWindow);
#ifdef MAPBEFORESELECT
   XMapWindow (mainDisplay, confirm_win);
   XSelectInput (mainDisplay, confirm_win,
         KeyPressMask | ButtonPressMask | ExposureMask | StructureNotifyMask);
#else
   XSelectInput (mainDisplay, confirm_win,
         KeyPressMask | ButtonPressMask | ExposureMask | StructureNotifyMask);
   XMapWindow (mainDisplay, confirm_win);
#endif
   if (warpToWinCenter)
      XWarpPointer (mainDisplay, None, confirm_win, 0, 0, 0, 0,
            (int)(w/2), (int)(h/2));

   XSync (mainDisplay, False);

   while (confirming)
   {
      XNextEvent (mainDisplay, &input);

      if ((input.type==MapNotify && input.xany.window==confirm_win) ||
            (input.type==Expose && input.xany.window==confirm_win) ||
            (!exposed &&
            (XCheckWindowEvent (mainDisplay,confirm_win,ExposureMask,&ev) ||
            XCheckWindowEvent (mainDisplay,confirm_win,StructureNotifyMask,
            &ev))))
      {
         while (XCheckWindowEvent (mainDisplay,confirm_win,ExposureMask,&ev)) ;
         while (XCheckWindowEvent (mainDisplay,confirm_win,StructureNotifyMask,
               &ev)) ;

         XDrawRectangle (mainDisplay, confirm_win, defaultGC, 0, 0, w-1, h-1);
         XDrawString (mainDisplay, confirm_win, defaultGC, str_start,
               defaultFontHeight+top, Str, strlen(Str));

         button_bbox[0].lty = button_bbox[1].lty = button_bbox[2].lty =
               3 * defaultFontHeight;
         button_bbox[CONFIRM_YES].ltx = button_start;
         DisplayButton (confirm_win, "YES", 8, &button_bbox[CONFIRM_YES],
               BUTTON_NORMAL);
         button_bbox[CONFIRM_NO].ltx =
               button_bbox[CONFIRM_YES].rbx + 1 + defaultFontWidth;
         DisplayButton (confirm_win, "NO", 8, &button_bbox[CONFIRM_NO],
               BUTTON_NORMAL);
         button_bbox[CONFIRM_CANCEL].ltx =
               button_bbox[CONFIRM_NO].rbx + 1 + defaultFontWidth;
         DisplayButton (confirm_win, "CANCEL", 8, &button_bbox[CONFIRM_CANCEL],
               BUTTON_NORMAL);

         exposed = TRUE;
         XSync (mainDisplay, False);

         if ((input.type==MapNotify && input.xany.window==confirm_win) ||
               (input.type==Expose && input.xany.window==confirm_win))
            continue;
      }

      if (input.type==VisibilityNotify &&
            input.xany.window==mainWindow &&
            input.xvisibility.state==VisibilityUnobscured)
      {
         while (XCheckWindowEvent (mainDisplay, mainWindow,
               VisibilityChangeMask, &ev)) ;
         if (pinnedMainMenu) XMapRaised (mainDisplay, mainMenuWindow);
         for (i = 0; i < numExtraWins; i++)
            if (extraWinInfo[i].mapped && extraWinInfo[i].raise &&
                  extraWinInfo[i].window != None)
               XMapRaised (mainDisplay, extraWinInfo[i].window);
         XMapRaised (mainDisplay, confirm_win);
      }
      else if (input.type == KeyPress)
      {
         key_ev = &(input.xkey);
         XLookupString (key_ev, buf, 80-1, &key_sym, &c_stat);
         TranslateKeys (buf, &key_sym);

         if (!(key_ev->state & (ControlMask | Mod1Mask)))
         {
            if ((key_sym&0xff)=='c' || (key_sym&0xff)=='C' ||
                  (key_sym&0xff)=='\033')
            {
               confirming = FALSE;
               choice = CONFIRM_CANCEL;
            }
            else if ((key_sym&0xff)=='\r' || (key_sym&0xff)=='\n')
            {
               confirming = FALSE;
               choice = DefaultReturn;
            }
            else if ((key_sym&0xff)=='y' || (key_sym&0xff)=='Y')
            {
               confirming = FALSE;
               choice = CONFIRM_YES;
            }
            else if ((key_sym&0xff) == 'n' || (key_sym&0xff) == 'N')
            {
               confirming = FALSE;
               choice = CONFIRM_NO;
            }
         }
	 else if (key_ev->state & ControlMask)
	 {
            if ((key_sym&0xff)=='[')
            {
               confirming = FALSE;
               choice = CONFIRM_CANCEL;
            }
            else if ((key_sym&0xff)=='m' || (key_sym&0xff)=='M')
            {
               confirming = FALSE;
               choice = CONFIRM_YES;
            }
	 }
      }
      else if (input.type == ButtonPress)
      {
         button_ev = &(input.xbutton);
         for (i = 0; i < MAX_CONFIRMS; i++)
            if (PointInBBox (button_ev->x, button_ev->y, button_bbox[i]))
            {
               confirming = FALSE;
               choice = i;
            }
      }
      else if (input.type == Expose && input.xany.window != confirm_win)
         ExposeEventHandler (&input, FALSE);
   }

   if (exposed)
      DisplayButton (confirm_win, confirmStr[choice], 8, &button_bbox[choice],
            BUTTON_INVERT);

   XDestroyWindow (mainDisplay, confirm_win);
   if (warpToWinCenter)
      XWarpPointer (mainDisplay, None, drawWindow, 0, 0, 0, 0,
            (int)(ZOOMED_SIZE(drawWinW)>>1), (int)(ZOOMED_SIZE(drawWinH)>>1));
   return (choice);
}

