/*
 * Author:	Yoichiro Ueno (ueno@cs.titech.ac.jp)
 *
 * Copyright (C) 1991, 1992, Yoichiro Ueno.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
#ifdef USE_XIM

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xlocale.h>
#include "const.h"
#include "types.h"

#include "convkinput.e"
#include "convxim.e"
#include "font.e"
#include "setup.e"

#ifdef USE_XIMP
#define DEFAULT_MODIFIERS	""
#define DEFAULT_LANG		"ja_JP.EUC"
#else
#define DEFAULT_MODIFIERS	"@im=_XWNMO"
#define DEFAULT_LANG		"ja_JP.ujis"
#endif

char	ximConvModifiers[MAXSTRING] = DEFAULT_MODIFIERS;
char	ximConvLang[MAXSTRING] = DEFAULT_LANG;

static char	*locale = NULL;
static char	*modifiers = NULL;
static XIM	im = NULL;
static XIC	ic = NULL;

static void	(*oldhandler)() = NULL;
static Bool	_XIMErrorFlag = False;

#ifdef USE_XIMP
static void (*_XipSetIOErrorHandler(handler))()
void (*handler)();
{
    return NULL;
}
#else
extern void	(*_XipSetIOErrorHandler())();
#endif

static
void _XIMIOError()
{
    _XIMErrorFlag = True;
}

void XIMClose()
{
    if(ic)
	XDestroyIC(ic);
    if(im)
	XCloseIM(im);
    
    im = NULL;
    ic = NULL;
    _XIMErrorFlag = False;
}

void XIMSetICFocus()
{
    char	buf[80];
    XIMStyles *    styles;
    Bool	style_flag;
    int	i;

    if(imProtocol != IM_XIM)
	return;

    if(curKanjiFont == KANJI_FONT_NONE)
	return;

    if(oldhandler == NULL)
	oldhandler = _XipSetIOErrorHandler(_XIMIOError);

    if(locale == NULL) {
	locale = setlocale(LC_ALL, ximConvLang);
	sprintf(buf, "locale is \"%s\".\n", locale);
	Msg(buf);
    }
    if(modifiers == NULL) {
	modifiers = XSetLocaleModifiers(ximConvModifiers);
	sprintf(buf, "modifiers is \"%s\".\n", modifiers);
	Msg(buf);
    }

    if(im == NULL) {
	im = XOpenIM(mainDisplay, NULL, NULL, NULL);
	if(im == NULL) {
	    Msg("Can't open Input Method.\n");
	    return;
	}
    }
    if(ic == NULL) {
	XGetIMValues(im,
		XNQueryInputStyle, &styles,
		NULL, NULL);
	style_flag = False;
	for(i = 0; i < styles->count_styles; i ++)
	    if(styles->supported_styles[i] ==
		    (XIMPreeditNothing | XIMStatusNothing))
		style_flag = True;
	if(!style_flag) {
	    Msg("This IM don't support  \"Root\" input style.\n");
	    XCloseIM(im);
	    im = NULL;
	    return;
	}
	ic = XCreateIC(im,
		XNInputStyle , XIMPreeditNothing | XIMStatusNothing,
		XNClientWindow, drawWindow,
		XNFocusWindow, drawWindow,
		NULL, NULL);
	if(ic == NULL) {
	    printf("Can't create InputContext.\n");
	    XCloseIM(im);
	    im = NULL;
	    return;
	}
	Msg("Open Input Method.\n");
    }
    XSetICFocus(ic);

    if(_XIMErrorFlag) {
	XIMClose();
	Msg("Close Input Method.\n");
    }
}

void XIMNextEvent(dpy, xev_p)
Display *	dpy;
XEvent *	xev_p;
{
    Bool	filter_status;

    do {
	XNextEvent(dpy, xev_p);

	filter_status = XFilterEvent(xev_p, drawWindow);

	if(_XIMErrorFlag) {
	    XIMClose();
	    Msg("Close Input Method.\n");
	}
    } while(filter_status == True);
}

int XIMLookupString(key_ev, buf, buf_len, key_sym_p, c_stat_p)
XKeyEvent *	key_ev;
char *		buf;
int		buf_len;
KeySym *	key_sym_p;
XIMStatus *	c_stat_p;
{
    if(im && ic) {
	c_stat_p->valid = MB_STATUS;
	return XmbLookupString (ic, key_ev, buf, buf_len, key_sym_p, &c_stat_p->mb_status);
    }
    else {
	c_stat_p->valid = COMPOSE_STATUS;
	return XLookupString (key_ev, buf, buf_len, key_sym_p, &c_stat_p->status);
    }
}

void XIMUnsetICFocus()
{
    if(im && ic) {
	XUnsetICFocus(ic);
    }
}
#endif
